﻿var contents = new Array("                  \n\r\n\rPurpose\n\r\n\rAlign the next instruction to a boundary.\n\r\n\rSyntax\n\r\n\r#ALIGN boundary\n\r\n\rRemarks\n\r\n\rThe #ALIGN metastatement is primarily used by advanced assembler programmers to gain ultimate efficiency from critical code sections.\n\r\n\r#ALIGN is used to round up the instruction location to a power of two address. The boundary parameter shown must be a power of two, in the range of 2 through 256.\n\r\n\rPowerBASIC inserts NOP instructions into the code section to bring the instruction location up to the desired address. If the instruction location is already at a multiple of boundary, #ALIGN has no effect.\n\r\n\rSee also\n\r\n\r#OPTIMIZE, ASM, ASM ALIGN, TIX","#ALIGN metastatement","scr\\html__align_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rArtificially inflate the disk image size of a compiled program.\n\r\n\rSyntax\n\r\n\r#BLOAT size_expression\n\r\n\rRemarks\n\r\n\r#BLOAT allows the creation of artificially bloated program files on disk, in order to match or exceed that generated by competing &quot;BloatWare&quot; compilers. #BLOAT does not affect the memory image size (running size) of a compiled program.\n\r\n\rsize_expression\n\r\n\rThe size_expression parameter is a simple Long-integer expression that specifies the total desired size of the compiled programs disk image, but is ignored if it is smaller than the actual program size. #BLOAT uses sections of the actual compiled code to fill and obfuscate the portion added to the file.\n\r\n\rWhile #BLOAT adds no true merit to the technical efficiency of the compiled code, there are a number of reasons for its use, including:1.To allow &quot;BloatWare&quot; programmers to feel more comfortable when using PowerBASIC.2.To impress project leaders/managers with the volume of executable code created.3.To allay the fears of uninformed customers who may mistakenly infer that &quot;such tiny programs couldn\'t possibly do everything that...&quot;4.To make certain versions of a program more readily identifiable simply by examining the size of the file on disk.5.To improve convolution of the contents of the executable disk image, because the bloat region appears to contain executable code.\n\r\n\rSee also\n\r\n\r#COMPILE EXE, #OPTIMIZE\n\r\n\rExample\n\r\n\r#BLOAT 1024 * 1024 * 4 &nbsp;\' Create a 4 MB EXE file","#BLOAT metastatement","scr\\html__bloat_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rDeclare information to be included in a COM Type Library.\n\r\n\rSyntax\n\r\n\r#COM CLASS ClassName &nbsp;[, ClassName...]\n\r\n\r#COM DOC &quot;This is specific information to be used in the Help String&quot;\n\r\n\r#COM HELP &quot;MyProg.chm&quot;[, &amp;H1E00]\n\r\n\r#COM NAME &quot;LibName&quot;, 3.32\n\r\n\r#COM GUID GUID$(&quot;{20000000-2000-2000-2000000000000002}&quot;)\n\r\n\r#COM TLIB {ON|+ | OFF|-}\n\r\n\rRemarks\n\r\n\rThe #COM metastatement establishes information about the COM library or application which can be extracted by COM client programs.\n\r\n\r#COM CLASS allows you to add the COM attribute to a class defined elsewhere. &nbsp;The COM attribute can even be added to a class in an SLL which was compiled separately. A class which is declared AS COM makes it available to external programs through the COM services of Windows. When you define a class as COM, it is automatically considered to be COMMON as well.\n\r\n\r#COM DOC specifies a help string which usually provides a general description of the COM server. \n\r\n\r#COM HELP specifies the name of the associated help file and the help context code. The name must appear as a string literal, while the context code is an unsigned DWORD value greater than zero. The context code may be specified in decimal or radix format. \n\r\n\r#COM NAME specifies the name of the server and the version number. The name must consist of only letters, numbers, and underscore characters, and may contain no punctuation nor spaces. If no name is specified, PowerBASIC substitutes the module name. If no version is specified, PowerBASIC uses version number 0.0.\n\r\n\r#COM GUID specifies the GUID which identifies the entire application or library (APPID or LIBID). If no GUID is specified, PowerBASIC substitutes a random GUID for this purpose.\n\r\n\r#COM TLIB ON specifies that the compiler should create a type library for the compiled EXE or DLL. The type library will be the same name and destination directory as the compiled EXE or DLL, with a .TLB extension.\n\r\n\r#COM TLIB OFF (default) specifies that the compiler should not create a type library for the compiled EXE or DLL.\n\r\n\rType Libraries only support the following data types: BYTE, WORD, DWORD, INTEGER, LONG, QUAD, SINGLE, DOUBLE, CURRENCY, OBJECT, STRING, and VARIANT. If any Methods or Properties use data types not supported by Type Libraries, you will receive a Error 581 - Type Library creation error, when using the #COM TLIB ON metastatement.\n\r\n\rSee also\n\r\n\rCLASS, INTERFACE (Direct), INTERFACE (IDBind), Just what is COM?","#COM metastatement","scr\\html__com_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rDetermine what type of file will be created by the compiler.\n\r\n\rSyntax\n\r\n\r#COMPILE {EXE | DLL | SLL} [&quot;filename{.exe|.dll|.sll}&quot;]\n\r\n\rRemarks\n\r\n\rThis metastatement is used to specify whether a module is to be compiled as an EXE, DLL, or SLL file. The #COMPILE metastatement can only be used once per program, and must be placed before any executable code.\n\r\n\rYou may, optionally, specify the target name and path of the file. If the optional equal sign (=) is included, the name given is considered to be an exact name, and nothing is appended or changed. Otherwise, the file type is forced to be EXE, DLL, or SLL by the compiler.\n\r\n\rIf the filename clause is omitted, the compiled file is given the name of the main source code file with an appropriate extension.\n\r\n\rIf a path is included, the compiled file is placed in the named directory; otherwise, it is placed in the current directory.\n\r\n\rIf the named directory does not exist, the filename is invalid or locked, if the EXE is still running, or if the file cannot be successfully stored in that location for some other reason, a compile-time Error 496 (&quot;Destination file write error&quot;) occurs.\n\r\n\rA related item is the built-in numeric equate %PB_COMPILETIME. Each time you compile your program, this equate is filled with the current date and time of the compilation in PowerTime binary format. You can use the PowerTIME Class to convert it to a text equivalent for use in your application.\n\r\n\rRestrictions\n\r\n\rIf #COMPILE is not specified, the default is #COMPILE EXE.\n\r\n\rExamples\n\r\n\r#COMPILE EXE \' Same name as source, i.e., ABC.EXE\n\r\n\r#COMPILE DLL \' Same name as source, i.e., ABC.DLL\n\r\n\r#COMPILE SLL &quot;ABC&quot; \' Compiles to ABC.SLL\n\r\n\r#COMPILE EXE &quot;ABC.BAS&quot; \' Compiles to ABC.BAS.EXE\n\r\n\rSee also\n\r\n\r%PB_COMPILETIME, #COMPILER, DLLMAIN, LIBMAIN, PBLIBMAIN, PBMAIN, WINMAIN","#COMPILE metastatement","scr\\html__compile_metastatement.htm","","","scr\\html__compiler_metastatement .htm","                  \n\r\n\rPurpose\n\r\n\rCompiler directive to suppress generation of debugging code.\n\r\n\rSyntax\n\r\n\r#DEBUG CODE {ON|+ | OFF|-}\n\r\n\rRemarks\n\r\n\rWhen a program is compiled for debugging in the PowerBASIC IDE, the compiler must generate some additional code to facilitate setting of breakpoints and some other debug operations. In most cases, this does &nbsp;not affect the execution of your program. However, in the case of code repetition in a tight loop, or for certain assembler code or data which must not be altered, it may be very important that some debugging code be suppressed so that code will execute correctly, and at full speed.\n\r\n\r#DEBUG CODE OFF suppresses generation of debug code, from that line, until a subsequent #DEBUG CODE ON (or the end of the Sub/Function/Method/Property) is reached. Of course, when debug code is suppressed, it is not possible to set breakpoints on those lines.\n\r\n\r #DEBUG CODE metastatements are ignored if not compiling for debug.\n\r\n\rSee also\n\r\n\rError Trapping, Errors, Debugging, #DEBUG DISPLAY, #DEBUG ERROR, #DEBUG PRINT","#DEBUG CODE metastatement","scr\\html__debug_code_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rDisplay a message when an untrapped run-time error occurs.\n\r\n\rSyntax\n\r\n\r#DEBUG DISPLAY {ON|+ | OFF|-}\n\r\n\rRemarks\n\r\n\r#DEBUG DISPLAY ON enables error display mode within a compiled PowerBASIC program. In this mode, whenever an untrapped error occurs (without the benefit of ON ERROR GOTO, TRY/CATCH, etc.), program execution is suspended, and a descriptive message is displayed. This message includes the error number, a brief description of the error, and a position descriptor word to help you find the location of the error. The position descriptor word is the first 8 characters of the name of the last (most recent) label, line number, or procedure that was executed. This mode should only be used during program development and debugging. It should never be used in a production program.\n\r\n\rWhen the descriptive message is displayed, it is accompanied by two buttons marked &quot;OK&quot; and &quot;Cancel&quot;. If &quot;OK&quot; is selected, program execution continues despite the error condition. If &quot;Cancel&quot; is &nbsp;selected, program execution is stopped. However, if any child processes were started, it is possible they will continue running until ended normally.\n\r\n\r#DEBUG DISPLAY OFF suppresses display mode, and is the default condition.\n\r\n\rRestrictions\n\r\n\r#DEBUG DISPLAY ON|OFF can only be executed once and must precede all executable code. If #DEBUG DISPLAY is omitted, the default condition is #DEBUG DISPLAY OFF.\n\r\n\rSee also\n\r\n\rError Trapping, Errors, Debugging, #DEBUG CODE, #DEBUG ERROR, #DEBUG PRINT","#DEBUG DISPLAY metastatement","scr\\html__debug_display_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rControl generation of error checking code.\n\r\n\rSyntax\n\r\n\r#DEBUG ERROR {ON|+ | OFF|-}\n\r\n\rRemarks\n\r\n\r#DEBUG ERROR option specifies whether the compiler should generate code that checks for array boundary and null-pointer errors wherever they may occur. The default setting is OFF.\n\r\n\rWhen #DEBUG ERROR mode is ON, any attempt to access an array outside of its boundaries, or attempting to use a null-pointer will generate a run-time Error 9 (&quot;Subscript/Pointer out of range&quot;), and the statement itself is not executed.\n\r\n\rWhen OFF, all statements are executed &quot;as-is&quot; and no errors are generated. However, accessing an array outside its boundaries or using a null-pointer can cause a General Protection Fault (GPF) or Exception error.\n\r\n\rIt is best to enable #DEBUG ERROR error checking when developing a program. Once all of the more obvious bugs have been eradicated, you will want to return to the default setting (OFF), as this will make your code smaller and faster. Depending on the type of application being developed, the final (production) version of a program may not need to contain any error-checking code.\n\r\n\rRestrictions\n\r\n\r#DEBUG ERROR is always enabled when code is running within the Debugger, regardless of any explicit #DEBUG ERROR metastatement.\n\r\n\rDisk I/O errors are always caught, regardless of the state of #DEBUG ERROR.\n\r\n\r#DEBUG ERROR ON does not trap array boundary errors of arrays within User-Defined Types and Unions. Pointers are only tested for null (zero) values. Non-zero pointer target addresses are not tested for readability or writeability.\n\r\n\rSee also\n\r\n\rError Trapping, Errors, Debugging, #DEBUG CODE, #DEBUG DISPLAY, #DEBUG PRINT","#DEBUG ERROR metastatement","scr\\html__debug_error_metastatement_.htm","                  \n\r\n\rPurpose\n\r\n\rDisplay information in the IDE\'s Debugger Output Window\n\r\n\rSyntax\n\r\n\r#DEBUG PRINT string_expression\n\r\n\rRemarks\n\r\n\rThe PRINT option allows the programmer to display arbitrary information in the IDE\'s Debug Output Window during a debugging session. The output window is provided by debugger to display status information about the state of the debugging session; however, #DEBUG PRINT provides a convenient way of creating a &quot;process log&quot; of a Sub/Function/Method/Property/Variable as the program runs. Combined with FUNCNAME$, #DEBUG PRINT can be a useful tool for debugging application code. See the Example below.\n\r\n\rThis is possible because the Debugger Output Window has a scrollable range somewhat like a console window, whereas the Watch Window shows only the instantaneous value of a variable.\n\r\n\r#DEBUG PRINT statements are ignored when code is compiled into a standalone (EXE/DLL) file; they are only included when using the Debugger. Control codes in the string are translated into hex format in the output window. For example, embedded CHR$(0) or $NUL bytes are displayed as &quot;&lt;00&gt;&quot;.\n\r\n\rRestrictions\n\r\n\rYou may use Unicode strings with #DEBUG PRINT, but the results will always be converted to ANSI by Windows. &nbsp;This is a Windows design limitation, not a limitation of PowerBASIC.\n\r\n\rSee also\n\r\n\rDebugging, #DEBUG ERROR, FUNCNAME$\n\r\n\rExample\n\r\n\rFUNCTION PBMAIN() AS LONG\n\r\n\r &nbsp;Arg1% = 10000\n\r\n\r &nbsp;Arg2% = 20000\n\r\n\r &nbsp;CALL MySub(Arg1%, Arg2%)\n\r\n\r &nbsp;CALL MySub(Arg2%, Arg1%)\n\r\n\r &nbsp;#DEBUG PRINT &quot;Done!&quot;\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rSUB MySub(Arg1%, Arg2%)\n\r\n\r &nbsp;#DEBUG PRINT &quot;We\'re in &quot; &amp; FUNCNAME$\n\r\n\r &nbsp;#DEBUG PRINT &quot;Arg2% is&quot; &amp; STR$(Arg2%)\n\r\n\rEND SUB\n\r\n\rResult\n\r\n\rWe\'re in MYSUB\n\r\n\rArg2% is 20000\n\r\n\rWe\'re in MYSUB\n\r\n\rArg2% is 10000\n\r\n\rDone!","#DEBUG PRINT metastatement","scr\\html__debug_print_metastatement_.htm","                  \n\r\n\rPurpose\n\r\n\rDetermine if an equate has been previously defined.\n\r\n\rSyntax\n\r\n\r%DEF({%numeric_equate | $string_equate})\n\r\n\rRemarks\n\r\n\rThe %DEF operator tests whether or not an equate has been defined. If the equate has been defined, %DEF returns TRUE (non-zero); or FALSE (zero) if it has not be defined.\n\r\n\rPowerBASIC automatically defines the equates in the following table according to the PowerBASIC compiler being used. Please note the references to other PowerBASIC compilers are included for those writing programs that may be compilable by more than one PowerBASIC compiler.\n\r\n\r&nbsp;\n\r\n\rEquate\n\r\n\rDefinition\n\r\n\r%PB_CC32\n\r\n\rPre-defined as TRUE (non-zero) in PB/CC for Windows, but is not defined in other compilers.\n\r\n\r%PB_DLL16\n\r\n\rPre-defined as TRUE (non-zero) in PB/DLL 16-bit, but is not defined in other compilers.\n\r\n\r%PB_DLL32\n\r\n\rSynonym of %PB_WIN32\n\r\n\r%PB_WIN32\n\r\n\rPre-defined as TRUE (non-zero) in PB/Win 32-bit, but is not defined in other compilers.\n\r\n\r%PB_REVISION\n\r\n\rPre-defined as the hex revision (10.00 = &amp;H1000).\n\r\n\r%PB_REVLETTER\n\r\n\rPre-defined as the ASCII code of the revision letter (a = &amp;H61), or &amp;H20 if there is no revision letter.\n\r\n\r%PB_EXE\n\r\n\rPre-defined as TRUE (non-zero) if compiling to EXE or as FALSE (zero) if compiling to DLL (PB/Win only) or SLL format.\n\r\n\rThe equate %PB_EXE is always defined in PowerBASIC, so %DEF(%PB_EXE) will always be evaluated as TRUE. The difference being the value assigned to the equate by the compiler. See the examples below.\n\r\n\rThese can be used in conjunction with #IF as a compiler directive to selectively include or exclude code from the compiled file.\n\r\n\rSee also\n\r\n\r#IF, Numeric Equates, Built-in numeric equates, String Equates, Built-in string equates\n\r\n\rExample\n\r\n\r\' 1. Conditional compilation for PB/CC or PB/Win\n\r\n\r#IF %DEF(%PB_CC32)\n\r\n\r &nbsp;\'Assume PB/CC\n\r\n\r &nbsp;#COMPILE EXE &quot;\\PBCC\\APPS\\MYPROG.EXE&quot;\n\r\n\r#ELSE\n\r\n\r &nbsp;\'Assume PB/Win\n\r\n\r &nbsp;#COMPILE DLL &quot;MYAPP.DLL&quot;\n\r\n\r#ENDIF\n\r\n\r&nbsp;\n\r\n\r\' 2. Conditional compilation for EXE or DLL\n\r\n\r#IF %PB_EXE\n\r\n\r &nbsp;\' we are compiling to an EXE (PB/CC or PB/Win)\n\r\n\r &nbsp;FUNCTION PBMAIN\n\r\n\r &nbsp; &nbsp;[statements]\n\r\n\r &nbsp;END FUNCTION\n\r\n\r#ELSE\n\r\n\r &nbsp;\' we are compiling to a DLL (PB/Win)\n\r\n\r &nbsp;FUNCTION PBLIBMAIN\n\r\n\r &nbsp; &nbsp;[statements]\n\r\n\r &nbsp;END FUNCTION\n\r\n\r#ENDIF","%DEF operator","scr\\html__def_operator.htm","                  \n\r\n\rPurpose\n\r\n\rSpecify if variables must be declared before use.\n\r\n\rSyntax\n\r\n\r#DIM {ALL | NONE}\n\r\n\rRemarks\n\r\n\r#DIM NONE (the default), requires you to dimension arrays, but not other kinds of variables, before their use.\n\r\n\rUsing #DIM ALL requires you to declare all variables before they are used in a program. This option makes PowerBASIC behave a lot like languages like C++ and Pascal which require that all variables be declared before they can be used. Although this will require more work, as even simple variables must be declared with DIM, INSTANCE, LOCAL, GLOBAL, STATIC, or THREADED statements, it will protect you from subtle errors like misspelling a variable name. For example, if you are using a variable NumRecords in your program and write a line like:\n\r\n\rINCR NumRecrods\n\r\n\rPowerBASIC will detect that you\'re trying to use a previously undeclared variable (since NumRecrods is misspelled) and give you a compile-time error 519 (&quot;Missing declaration&quot;). If you hadn\'t specified #DIM ALL, you wouldn\'t have gotten an error, but your program would now have a bug that could be difficult to diagnose.\n\r\n\r#DIM ALL means the same thing as OPTION EXPLICIT, and the two can be used interchangeably.\n\r\n\rRestrictions\n\r\n\rWhen #DIM ALL is used, type-specifier symbols with variable names are not allowed in a DIM var statement. e.g. Dim a$(10) will result in compile error 519. Instead variables or arrays defined with the DIM statement must use the AS vartype format. Additionally, DEFtype statements, such as DEFINT, DEFLNG, etc. will be ignored, resulting in an error 519 where any variable they would otherwise define is used.\n\r\n\rSee also\n\r\n\rDEFtype, DIM, GLOBAL, INSTANCE, LOCAL, REDIM, STATIC, OPTION EXPLICIT\n\r\n\rExample\n\r\n\r#DIM ALL\n\r\n\r[statements]\n\r\n\rDIM ListName(1 TO 400) AS STRING\n\r\n\r[statements]\n\r\n\rFOR ix = 1 TO 10 &nbsp;\' PowerBASIC flags this line\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' since &quot;ix&quot; wasn\'t dimensioned\n\r\n\r &nbsp;ListName(ix) = &quot;Test&quot;\n\r\n\rNEXT","#DIM metastatement","scr\\html__dim_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rDeclare a Sub/Function to have the EXPORT attribute.\n\r\n\rSyntax\n\r\n\r#EXPORT SubFuncName [, SubFuncName...]\n\r\n\rRemarks\n\r\n\r#EXPORT allows you to add the EXPORT attribute to a Sub/Function defined elsewhere. &nbsp;The EXPORT attribute can even be added to a Sub/Function in an SLL which was compiled separately.\n\r\n\rThe EXPORT descriptor identifies a Sub/Function which may be accessed between Dynamic Link Libraries (DLLs), and/or the main executable which links them. If a procedure is not marked EXPORT, it is hidden from these other modules. Generally speaking, it\'s best not to mark a Sub/Function in an SLL as EXPORT. While it is syntactically acceptable, it may limit your future options when linking the SLL into host modules. PowerBASIC recommends that you mark them as COMMON in the SLL, and add the EXPORT attribute in the host module.\n\r\n\rIt\'s easy to create an SLL which can be linked into an executable program or a dedicated DLL for the same purpose. To add the EXPORT attribute to a linked Sub/Function, just add the word EXPORT to the DECLARE statement in the host module or add an #EXPORT metastatement.\n\r\n\rUsing this technique, your SLL can be linked directly into an application executable without publishing the Subs/Functions as EXPORT. However, you can also link the same SLL into a DLL host module which adds the EXPORT attribute with #EXPORT.\n\r\n\rFor example, let\'s say you want to make a library which publishes the SUB named XXX. You want to provide it in two forms, a linkable SLL and an industry standard DLL. So, first just create the SLL:\n\r\n\r#COMPILE SLL = &quot;XXXLib.SLL&quot;\n\r\n\r&nbsp;\n\r\n\rSUB xxx() COMMON\n\r\n\r &nbsp;MSGBOX &quot;Hello&quot;\n\r\n\rEND SUB\n\r\n\rJust compile it, and you\'re ready to link it into your application. But now you want to create a DLL, too, since it might be used with other applications. It\'s just this easy:\n\r\n\r#COMPILE DLL = &quot;XXXLib.DLL&quot;\n\r\n\r&nbsp;\n\r\n\r#EXPORT xxx\n\r\n\r#LINK &quot;XXXLib.SLL&quot;\n\r\n\rThat\'s all there is to it. You now have an SLL and an equivalent DLL to do the job of the XXX procedure.\n\r\n\rSee also\n\r\n\r#LINK, DECLARE","#EXPORT metastatement","scr\\html__export_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rDefine sections of source code to be compiled or ignored, depending on a certain condition. This is often referred to as conditional compilation.\n\r\n\rSyntax\n\r\n\r#IF [NOT] {%equate | %DEF({%numeric_equate | $string_equate}) | expression}\n\r\n\r &nbsp;[statements]\n\r\n\r[#ELSEIF [NOT] {%equate | %DEF({%numeric_equate | $string_equate}) | expression}\n\r\n\r &nbsp;[statements]]\n\r\n\r[#ELSE\n\r\n\r &nbsp;[statements]]\n\r\n\r#ENDIF\n\r\n\rRemarks\n\r\n\r%equate is a named constant or constant value. The %DEF operator allows you to test whether an equate has been defined. %DEF returns TRUE or FALSE. Typical usage: #IF %DEF(%PB_DLL16)  or &nbsp;#ELSEIF NOT %DEF(%PB_WIN32). expression may be a simple numeric expression using the arithmetic operators +, -, *, /, and \\, and the relational operators &gt;, &lt;, &gt;=, &lt;=, &lt;&gt;, and =, and may also include the CVQ function.\n\r\n\rPowerBASIC automatically defines the equates in the following table according to the PowerBASIC compiler being used. Please note the references to other PowerBASIC compilers are included for those writing programs that may be compilable by more than one PowerBASIC compiler.\n\r\n\rEquate\n\r\n\rDefinition\n\r\n\r%PB_CC32\n\r\n\rPre-defined as TRUE (non-zero) in PB/CC for Windows, but is not defined in other compilers.\n\r\n\r%PB_DLL16\n\r\n\rPre-defined as TRUE (non-zero) in PB/DLL 16-bit, FALSE (zero) in other compilers.\n\r\n\r%PB_DLL32\n\r\n\rSynonym of %PB_WIN32\n\r\n\r%PB_WIN32\n\r\n\rPre-defined as TRUE (non-zero) in PB/Win 32-bit, but is not defined in other compilers.\n\r\n\r%PB_REVISION\n\r\n\rPre-defined as the hex revision (10.00 = &amp;H1000).\n\r\n\r%PB_REVLETTER\n\r\n\rPre-defined as the ASCII code of the revision letter (a = &amp;H61), or &amp;H20 if there is no revision letter.\n\r\n\r%PB_EXE\n\r\n\rPre-defined as TRUE (non-zero) if compiling to EXE or as FALSE (zero) if compiling to DLL format (PB/Win only). The equate %PB_EXE is always defined in PowerBASIC, so %DEF(%PB_EXE) will always be evaluated as TRUE. The difference being the value assigned to the equate by the compiler.\n\r\n\r&nbsp;\n\r\n\rExamples of valid expressions can include:\n\r\n\r#IF %DEBUG = -1&amp;\n\r\n\r#IF %DEBUG AND (NOT %RELEASE)\n\r\n\r#IF NOT %DEBUG\n\r\n\r#IF %VERSION &lt;&gt; CVQ(&quot;DemoMode&quot;)\n\r\n\rNote that the AND, OR and NOT operators work as bitwise operators, rather than logical operators, in #IF metastatements.\n\r\n\rIf the value of %equate or if %DEF(%equate|$equate) is TRUE (non-zero) or if the result of expression is TRUE, the statements between #IF and #ELSE or #ELSEIF are compiled, and the statements between #ELSE or #ELSEIF and #ENDIF are ignored.\n\r\n\rIf the value of %equate or %DEF(%equate|$equate) is FALSE (zero) or the result of expression is FALSE, the statements between #IF and #ELSE or #ELSEIF are ignored, and those between #ELSE or #ELSEIF and #ENDIF are compiled.\n\r\n\rThe #ELSE or #ELSEIF clause and associated statements are optional, but #ENDIF is required.\n\r\n\rConditional compilation statements can be nested up to 16 levels deep. A primary use of conditional compilation is to include test code in your programs that will be compiled during program development (but not in the final product), and to facilitate building special editions of an application from a single source code file.\n\r\n\rIt is possible to perform bitwise operations on equates to produce a TRUE/FALSE result. For &nbsp;example:\n\r\n\r#IF (%PB_REVISION AND &amp;H0FF00) - &amp;H0700\n\r\n\r &nbsp;SoftwareVersion$ = &quot;not 7.x&quot;\n\r\n\r#ELSE\n\r\n\r &nbsp;SoftwareVersion$ = &quot;7.x&quot;\n\r\n\r#ENDIF\n\r\n\rSee also\n\r\n\r%DEF operator, IF statement, IF block\n\r\n\rExample\n\r\n\rExample \' 1. Conditional compilation by equate value\n\r\n\r%DEBUG = -1 &nbsp; &nbsp; &nbsp; \'set to 0 for no debugging\n\r\n\r#IF %DEBUG\n\r\n\r &nbsp;CALL SubRoutine(Arg1, Arg2, Arg3, Answer)\n\r\n\r &nbsp;CALL DisplayDebugData(Answer)\n\r\n\r#ELSE\n\r\n\r &nbsp;CALL SubRoutine(Arg1, Arg2, Arg3, Answer)\n\r\n\r#ENDIF\n\r\n\r&nbsp;\n\r\n\r\' 2. Conditional compilation for EXE or DLL\n\r\n\r#IF %PB_EXE\n\r\n\r &nbsp;\' we are compiling to an EXE (PB/CC or PB/Win)\n\r\n\r &nbsp;FUNCTION PBMAIN\n\r\n\r &nbsp; &nbsp;[statements]\n\r\n\r &nbsp;END FUNCTION\n\r\n\r#ELSE\n\r\n\r &nbsp;\' we are compiling to a DLL (PB/Win)\n\r\n\r &nbsp;FUNCTION PBLIBMAIN\n\r\n\r &nbsp; &nbsp;[statements]\n\r\n\r &nbsp;END FUNCTION\n\r\n\r#ENDIF","#IF metastatement","scr\\html__if_elseif_else_endif_metastatements.htm","                  \n\r\n\rPurpose\n\r\n\rInstruct the compiler to read a text file from disk and treat it as an integral part of the source code.\n\r\n\rSyntax\n\r\n\r#INCLUDE &quot;FileSpec&quot;\n\r\n\r#INCLUDE ONCE &quot;FileSpec&quot;\n\r\n\r#INCLUDE THIS ONCE\n\r\n\rRemarks\n\r\n\rUse #INCLUDE to compile the text of another file along with the current file. The first form causes FileSpec to be included in every case it is encountered. The second form causes FileSpec to be included only once, the first time it is encountered. This is particularly useful when including common declaration files like WIN32API.INC to avoid redundant code, and the resulting errors. To be effective, the ONCE option must appear on every #INCLUDE of a particular file. Effectively, #INCLUDE ONCE means: &quot;Include this file only if it has not already been included.&quot;\n\r\n\rThe third form (#INCLUDE THIS ONCE) is placed in the file to be included, and produces an end result similar to form two. It tells the compiler to &quot;Include me only one time, no matter how many times it is requested&quot;. Depending upon the content and context, this may be a simpler and more readable method to achieve the desired result.\n\r\n\rFileSpec is a string constant that follows normal LFN file-naming conventions, and which names a PowerBASIC source code file. If FileSpec does not include an extension, the compiler looks for that file name with the default extension of .BAS.\n\r\n\rIf FileSpec does not include a path, the compiler scans the search path for each #INCLUDE file before checking the current (default) directory. For the IDE, the search path can be set in the Compiler Preferences tab in the Options dialog. The search path can also be specified when compiling from the command-line by using the /I Include option. The search path can contain one path or multiple paths to scan. If multiple paths are used, they are separated by a semicolon (;).\n\r\n\rWhen the compiler encounters an #INCLUDE metastatement, it reads FileSpec from disk and continues compilation with the source code in FileSpec. When the end of FileSpec is reached, compilation continues with the statement immediately following the #INCLUDE in the original source file. The result is the same as if the contents of the included file were physically present within the original text. This allows large source files to be broken into smaller sections that are more manageable.\n\r\n\r#INCLUDE metastatements can be nested as many as twelve levels deep. That is, an included file can have #INCLUDE metastatements of its own, including files that also have #INCLUDE metastatements, and so on, for a total of twelve levels of files (including the primary file). Note that macros count as #include files for nesting purposes.\n\r\n\rSee also\n\r\n\rWIN32API.INC Updates\n\r\n\rExample\n\r\n\r\' MYHELLO.BAS\n\r\n\r#INCLUDE ONCE &quot;WIN32API.INC&quot; &nbsp;\'include Windows API calls\n\r\n\rFUNCTION PBMAIN\n\r\n\r &nbsp;MessageBox 0, &quot;Hello World!&quot;, &quot;PowerBASIC&quot;, %MB_OK\n\r\n\rEND FUNCTION","#INCLUDE metastatement","scr\\html__include_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rLINK a pre-compiled Static Link Library (SLL) or a Power Library (PBLIB) into your host program.\n\r\n\rSyntax\n\r\n\r#LINK &quot;filespec.SLL&quot;\n\r\n\r#LINK &quot;filespec.PBLIB&quot;\n\r\n\rRemarks\n\r\n\rThe #LINK metastatement is used to link pre-compiled Unit files (SLL or PBLIB) into your primary host program. The host program must compile to an EXE or DLL module. You cannot link a unit file into another unit file.\n\r\n\rIf a specified SLL unit file (or a component SLL in a PBLIB) is not needed by other compiled code, it is ignored entirely. This allows the host program to be compiled to the smallest possible size.\n\r\n\rThe filespec may include an optional path name, and must include the extension &quot;.SLL&quot; or &quot;.PBLIB&quot;. The #LINK metastatement may be placed at any location in your source file, as long as it is outside of any block structure, such as Sub, Function, Method, Class, etc.\n\r\n\r#LINK shares the file search path with #INCLUDE. If filespec does not include a path, the compiler scans the search path for each #LINK file before checking the current (default) directory. For the IDE, the search path can be set in the Compiler Preferences tab in the Options dialog. The search path can also be specified when compiling from the command-line by using the /I Include option. The search path can contain one path or multiple paths to scan. If multiple paths are used, they are separated by a semicolon (;).\n\r\n\rSee Also\n\r\n\r#COMPILE, #EXPORT","#LINK metastatement","scr\\html__link_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rSpecify which messages should be sent to a Control Callback Function.\n\r\n\rSyntax\n\r\n\r#MESSAGES COMMAND\n\r\n\r#MESSAGES NOTIFY\n\r\n\rRemarks\n\r\n\r#MESSAGES COMMAND specifies that only %WM_COMMAND messages be sent to Control Callback Functions, just as in earlier versions of PowerBASIC\n\r\n\r#MESSAGES NOTIFY specifies that %WM_NOTIFY messages (as well as %WM_COMMAND messages) be sent to Control Callback Functions. This is the default condition, and need not be explicitly stated.\n\r\n\rThere are two general types of CallBack Functions. The first is the DIALOG CALLBACK, which is specified with the CALL DLGPROC clause of the DIALOG SHOW statement. It receives all messages which are directed to the dialog, including certain messages regarding its child controls. Specifically, this would include both %WM_COMMAND and %WM_NOTIFY messages. The second is the CONTROL CALLBACK, which is specified with the CALL CTLPROC clause of the CONTROL ADD statement. If specified, it receives all %WM_COMMAND and %WM_NOTIFY messages sent to the parent dialog.\n\r\n\rPrior to version 9.0 of PowerBASIC for Windows, Control Callback Functions received only %WM_COMMAND messages. Beginning with PB 9.0, %WM_NOTIFY messages are sent as well. There are many situations where these added messages will prove to be very important to you. If your existing callback functions are written with complete error checking (ensuring that CB.MSG = %WM_COMMAND), this minor addition will cause no problems. It just presents additional information which can be acted upon, or just ignored. However, if callbacks were written without complete error checking, some ambiguity is possible. In this case, you should either update your Control Callback code, or suppress %WM_NOTIFY messages with a #MESSAGES Command metastatement.\n\r\n\rSee also\n\r\n\rCallbacks, DIALOG SHOW MODAL, DIALOG SHOW MODELESS, FUNCTION/END FUNCTION","#MESSAGES metastatement","scr\\html__messages_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rChoose the optimization which should be applied to your program.\n\r\n\rSyntax\n\r\n\r#OPTIMIZE CODE [ON | OFF]\n\r\n\r#OPTIMIZE {SIZE | SPEED}\n\r\n\rRemarks\n\r\n\rThe #OPTIMIZE metastatement is used to tell the compiler your preferences in regards to the optimization of generated code. You can specify optimization for either execution speed or smaller code size.\n\r\n\rThe first form of the directive (CODE) tells the compiler whether unreferenced code should be removed from the compiled program to minimize the executable file size. This option defaults to ON as there are few reasons to disable it (other than curiosity as to the effectiveness). Regardless of the compiled module type (SLL, DLL, or EXE), PowerBASIC removes every unneeded:\n\r\n\r1\n\r\n\rSub\n\r\n\r2\n\r\n\rFunction\n\r\n\r3\n\r\n\rFastProc\n\r\n\r4\n\r\n\rMethod\n\r\n\r5\n\r\n\rProperty\n\r\n\r6\n\r\n\rString Literal\n\r\n\r7\n\r\n\rNumeric Literal\n\r\n\r8\n\r\n\rStatic Link Library\n\r\n\rExtraction is always performed on a procedure basis, not an entire class. If you have a CLASS with 50 Methods, but only one is ever called, the other 49 are removed entirely. This level of granularity is particularly important with your personal code library of general purpose functions. You can include them all, and PowerBASIC will use just the minimum necessary. If you generate a log file (using the /L command line option), a list of the extracted procedures, classes, and SLL modules is provided.\n\r\n\rThe second form of the directive (SIZE/SPEED) tells the compiler whether you want additional optimization for execution speed or smaller total code size. If not used, the default is to choose faster code speed.\n\r\n\rIf you choose the SPEED option, one of the primary actions of the compiler is to align heavily used code sections on an address boundary which is most beneficial to the CPU/FPU.\n\r\n\rIn some cases, the speed of loop mechanisms (FOR/NEXT, DO/UNTIL...) can be improved by as much as 100%, and occasionally even more.\n\r\n\rRestrictions\n\r\n\r#OPTIMIZE SIZE | SPEED can only be executed once and must precede all executable code. If #OPTIMIZE is omitted, the default condition is #OPTIMIZE SPEED.\n\r\n\rSee also\n\r\n\r#ALIGN, ASM ALIGN","#OPTIMIZE metastatement","scr\\html__optimize_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rEstablish various compiler options.\n\r\n\rSyntax\n\r\n\r#OPTION {LARGEMEM32 | VERSION3 | VERSION4 | VERSION5 | WIN95 | ANSIAPI}\n\r\n\rRemarks\n\r\n\r#OPTION LARGEMEM32\n\r\n\rFor 32-bit Windows applications, this option sets the &quot;Large Memory Model&quot; flag. This allows your application to use more than the original limit of 2 Gigabytes of memory. Depending upon the version of Windows in use, and the installed memory, the exact increase may vary from computer to computer. In most cases, you will likely be limited to a total of approximately 3 Gigabytes.\n\r\n\r#OPTION VERSION3, VERSION4, VERSION5\n\r\n\rWhen the #OPTION metastatement is used with any one of the VERSION directives, it controls the &quot;minimum Windows version&quot; tag that is written into your compiled code. If the version you select is equal or lower to the version of Windows that is running, the application will be executed. In turn, Windows will tailor the messages it sends to your program according to this version number, so your program will not need to handle messages from a later Windows version. The version tag may also affect the appearance and behavior of Windows common dialogs.\n\r\n\rConversely, if the version tag you select is higher than the version of Windows that is running, Windows will display an error message instead of running your application. For example, running a VERSION5 application on a VERSION4 platform would fail. It is your responsibility to make sure that your program only uses the Windows features that are present in the specified version of Windows. For example, don\'t call an API that\'s present only in Windows XP, if you want your program to run under Windows 98.\n\r\n\r#OPTION VERSION3\n\r\n\rUse #OPTION VERSION3 to make the compiled output file require a minimum of Windows 95 or NT 3.1. That includes Windows 95, 98, ME, Windows NT 3.1-4.0, Windows 2000, XP, Windows 2003, Windows Vista, Windows 7, and later.\n\r\n\r#OPTION VERSION4\n\r\n\rUse #OPTION VERSION4 (default) to make the compiled output file require a minimum of Windows 95 or NT4. That includes Windows 95, 98, ME, Windows NT 4.0, Windows 2000, XP, Windows 2003, Windows Vista, Windows 7, and later.\n\r\n\r#OPTION VERSION5\n\r\n\rUse #OPTION VERSION5 to make the compiled output file require a minimum of Windows 2000. That includes Windows 2000, XP, Windows 2003, Windows Vista, Windows 7, and later.\n\r\n\r#OPTION WIN95\n\r\n\rWindows95, Windows98, and Windows ME do not offer Unicode support for Windows API functions. Normally, that would make it possible to execute your compiled programs on these operating systems, as this version of PowerBASIC offers complete support for Wide Unicode text. However, if you specify #OPTION WIN95 in your source code, PowerBASIC will include a complete Unicode emulation package in your executable or DLL to allow them to run properly on these operating systems, This option will cause your code to be a bit larger, so it should only be used where necessary.\n\r\n\r#OPTION ANSIAPI\n\r\n\rThis version of PowerBASIC offers complete support for Wide Unicode text, so it follows that the internal runtime library would call Unicode versions of functions in the Windows API. In some fairly rare cases, this could cause an incompatibility with code you have written, if your code calls ANSI functions in the Windows API. If you specify #OPTION ANSIAPI in your source code, PowerBASIC will call only ANSI versions of these functions. This option will cause your code to be a bit larger, so it should only be used when needed.\n\r\n\rExample\n\r\n\r#OPTION VERSION5","#OPTION metastatement","scr\\html__option_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rSets a page boundary for the PowerBASIC IDE.\n\r\n\rSyntax\n\r\n\r#PAGE\n\r\n\rRemarks\n\r\n\rProgram listings which are nicely formatted are easier to read and understand, particularly after some elapsed time.\n\r\n\rThe #PAGE metastatement is used to set a page boundary when the source code is printed from the PowerBASIC IDE. Each time a #PAGE is found, the PowerBASIC IDE starts printing on a new page.\n\r\n\r#PAGE has no effect on your compiled code.","#PAGE metastatement","scr\\html__page_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rHelps to determine the date/time of compilation.\n\r\n\rRemarks\n\r\n\rEach time you compile your program, this equate is filled with the current date and time of the compilation in PowerTime binary format. You can use the PowerTIME Class to convert it to a text equivalent for use in your application.\n\r\n\rExample\n\r\n\rLOCAL Built AS IPowerTime\n\r\n\rLET Built = CLASS &quot;PowerTime&quot;\n\r\n\rBuilt.FileTime = %PB_COMPILETIME\n\r\n\rMSGBOX &nbsp;Built.DateString\n\r\n\rMSGBOX &nbsp;Built.TimeString","%PB_COMPILETIME numeric equate","scr\\html__pb_compiletime_numeric_equate.htm","                  \n\r\n\rPurpose\n\r\n\rControl automatic allocation of Register variables.\n\r\n\rSyntax\n\r\n\r#REGISTER {ALL | DEFAULT | NONE}\n\r\n\rRemarks\n\r\n\rRegister variables may be Extended-precision floating-point variables, or 16/32-bit integral-class variables (Word, Dword, Integer, or Long). The #REGISTER metastatement determines the method of automatic allocation of Register variables.\n\r\n\rThe #REGISTER metastatement works at two levels - a &quot;global&quot; setting, and a &quot;local&quot; setting for each Sub/Function/Method/Property. To set the global default #REGISTER options, it must precede all executable code. To override the global register option for an individual routine, it must be placed between the FUNCTION/END FUNCTION, SUB/END SUB, METHOD/END METHOD, or PROPERTY/END PROPERTY pairs before any executable code.\n\r\n\rALL\n\r\n\r#REGISTER ALL requests automatic allocations of all possible Register variables, both integral-class and Extended-precision float variables.\n\r\n\rDEFAULT\n\r\n\r#REGISTER DEFAULT (default) requests automatic allocations of integral-class variables in all cases, and Extended-precision floating-point variables located in a routine which contains no reference to another procedure.\n\r\n\rNONE\n\r\n\r#REGISTER NONE disables automatic assignment of Register variables. You can still use the REGISTER statement to explicitly define Register variables in your code on an individual basis. This provides a way to hand-optimize your code to help obtain the utmost performance.\n\r\n\rRestrictions\n\r\n\rPowerBASIC transparently prevents the automatic register conversion of the variable used in the TO clause of the DIALOG SHOW MODAL and DIALOG SHOW STATE statements. If the target variable is explicitly declared as a register variable, PowerBASIC raises a compile-time Error 491 (&quot;Invalid register variable&quot;). This is necessary as the result values stored in such variables may be assigned from the context of other procedures, and this may only occur with a memory variable.\n\r\n\rSee also\n\r\n\rREGISTER, Optimizing your code\n\r\n\rExample\n\r\n\r#REGISTER DEFAULT &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' global register setting\n\r\n\rFUNCTION PBMAIN() AS LONG\n\r\n\r &nbsp;#REGISTER NONE &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \' No automatic register\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \' vars in this function\n\r\n\r &nbsp;REGISTER x&amp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' Explicitly declare x&amp;\n\r\n\r &nbsp;\n\r\n\rEND FUNCTION","#REGISTER metastatement","scr\\html__register_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rEmbed a PowerBASIC Resource data into a compiled EXE or DLL.\n\r\n\rSyntax\n\r\n\r#RESOURCE BITMAP, &nbsp; ResID, &quot;filespec.BMP&quot;\n\r\n\r#RESOURCE ICON, &nbsp; &nbsp; ResID, &quot;filespec.ICO&quot;\n\r\n\r#RESOURCE MANIFEST, &nbsp; &nbsp; 1, &quot;filespec.XML&quot;\n\r\n\r#RESOURCE RCDATA, &nbsp; ResID, &quot;filespec.DAT&quot;\n\r\n\r#RESOURCE STRING, &nbsp; ResID, &quot;YourWideText&quot;$$ [,LangID]\n\r\n\r#RESOURCE TYPELIB, &nbsp; &nbsp; &nbsp;1, &quot;filespec.TLB&quot;\n\r\n\r#RESOURCE WAVE, &nbsp; &nbsp; ResID, &quot;filespec.WAV&quot;\n\r\n\r#RESOURCE VERSIONINFO &lt;&lt;block&gt;&gt;\n\r\n\r&nbsp;\n\r\n\r#RESOURCE RES, &quot;filespec.RES&quot;\n\r\n\r#RESOURCE PBR, &quot;filespec.PBR&quot;\n\r\n\rRemarks\n\r\n\rThis metastatement is used to include PowerBASIC Resource data into your program or DLL. Resource data may consist of bitmaps, icons, strings, COM Type Libraries, Version Information, and more. You can even embed custom binary data for your personal, specialized needs.\n\r\n\rResource data can be a very valuable tool. &nbsp;While you can certainly load bitmaps and icons from separate files, wouldn\'t it be better to just embed them in your application? &nbsp;When you need the bitmap, it\'s always right there for your use! &nbsp;You don\'t have to deal with scads of files. &nbsp;Now it\'s all at your fingertips.\n\r\n\rThe parameter ResID is a unique identifier which you create to reference this item. It can be a numeric or an alphanumeric literal. If numeric, it must be an integral value from 0 to 65535. If alphanumeric, it must begin with a letter, and consist of letters and numbers. Alphanumeric labels are not case sensitive. The filespec parameter must always be expressed as a string literal which tells the location of the resource data.\n\r\n\rIf a resource file\'s path is not specified, then the compiler will look in the default directory.\n\r\n\rWith most programming languages, creation and embedding of resource data is a cumbersome process. First you create a resource script (an .RC file) with a text editor. Then you save the .RC file. Now, compile the .RC file with a resource compiler to get a .RES file. Next, you convert it to a linkable file using Microsoft\'s CVTRES.EXE or another converter program like PBRES.EXE. Finally, you link it into your .EXE or .DLL with a compiler or linker program. What if you find you need to make a tiny change? &nbsp;Do it all over again, from the beginning. Even &nbsp;older versions of PowerBASIC suffered from this problem.\n\r\n\rIsn\'t there a better way? &nbsp;Yes, PowerBASIC now handles the entire process in a single line of code. Need an embedded bitmap?\n\r\n\r#RESOURCE BITMAP, 123, &quot;MyPicture.BMP&quot;\n\r\n\rPowerBASIC finds your bitmap in the file MyPicture.BMP and embeds it in your executable. When you need to use it, you can reference it by the ID you chose for it (123). The ID can be an integral numeric value or a text name of your choice. So, to display the bitmap on a graphic window, it\'s as simple as:\n\r\n\rGRAPHIC RENDER &quot;#123&quot;, (100,100)-(160,140)\n\r\n\rString Resources\n\r\n\rThe String resource contains string data which is always created and stored as Wide Unicode characters. It is retrieved at run-time with the RESOURCE$ function. Due to the manner in which Windows stores string resources in a string table, the ResID must be numeric.\n\r\n\rThe string data must be from 1 to 127 characters in length, and may not contain any embedded nuls (CHR$(0)). The string data may be specified as a quoted wide string literal (&quot;MyText&quot;$$), or as a wide string literal expression. A string literal expression can be constructed from combinations of wide string equates or wide quoted string literals, the CHR$ function, SPACE$ function, and the STRING$ function when used with numeric parameters.\n\r\n\rVersionInfo Resources\n\r\n\rThe VersionInfo resource contains information about the file, such as its version number, its intended operating system, its original file name, and much more. This resource is intended to be used with the Version Information API functions, so that Windows Explorer, and other programs, can display the relevant information about your EXE. The VersionInfo resource cannot be embedded in a Static Link Library (SLL).\n\r\n\rThe VersionInfo resource is unique in that it requires several #RESOURCE metastatements which are interpreted as a complete block. They must be placed consecutively in the correct sequence in order be processed correctly.1.The block begins with the VERSIONINFO metastatement which marks the beginning of the version block.\n\r\n\r#RESOURCE VERSIONINFO2.Next, you may choose to add one or more of the numeric version metastatements which embed numeric values.\n\r\n\r#RESOURCE FILEFLAGS FlagValue&amp;\n\r\n\r#RESOURCE FILEVERSION HiNum1&amp;, LoNum1&amp;, HiNum2&amp;, LoNum2&amp;\n\r\n\r#RESOURCE PRODUCTVERSION HiNum1&amp;, LoNum1&amp;, HiNum2&amp;, LoNum2&amp;3.Next, the mandatory STRINGINFO metastatement is added, to identify the Language ID and CharSet to be used. Each of these parameters must be passed as a 4-digit HEX value in a string literal. The parameter must not contain the &quot;&amp;H&quot; prefix used with numeric hex numbers.\n\r\n\r#RESOURCE STRINGINFO &quot;LangID&quot;, &quot;CharSet&quot;4.Finally, you will add one or more of the string version metastatements, to provide extensive information about the file. The first string literal parameter chooses one of the following predefined names. The second string literal parameter adds your personal choice of information about the file.\n\r\n\r#RESOURCE VERSION$ &quot;Comments&quot;, &nbsp; &nbsp; &nbsp; &nbsp; &quot;Additional info&quot;\n\r\n\r#RESOURCE VERSION$ &quot;CompanyName&quot;, &nbsp; &nbsp; &nbsp;&quot;PowerBASIC Inc.&quot;\n\r\n\r#RESOURCE VERSION$ &quot;FileDescription&quot;, &nbsp;&quot;Presented to users&quot;\n\r\n\r#RESOURCE VERSION$ &quot;FileVersion&quot;, &nbsp; &nbsp; &nbsp;&quot;Readable VerNum 1.02&quot;\n\r\n\r#RESOURCE VERSION$ &quot;InternalName&quot;, &nbsp; &nbsp; &quot;Private&quot;\n\r\n\r#RESOURCE VERSION$ &quot;LegalCopyright&quot;, &nbsp; &quot;Copyright 2012 PB Inc&quot;\n\r\n\r#RESOURCE VERSION$ &quot;LegalTrademarks&quot;, &nbsp;&quot;xx is a...&quot;\n\r\n\r#RESOURCE VERSION$ &quot;OriginalFilename&quot;, &quot;Original name w/o path&quot;\n\r\n\r#RESOURCE VERSION$ &quot;PrivateBuild&quot;, &nbsp; &nbsp; &quot;Private info&quot;\n\r\n\r#RESOURCE VERSION$ &quot;ProductName&quot;, &nbsp; &nbsp; &nbsp;&quot;Product distributed with&quot;\n\r\n\r#RESOURCE VERSION$ &quot;ProductVersion&quot;, &nbsp; &quot;Version distributed with&quot;\n\r\n\r#RESOURCE VERSION$ &quot;SpecialBuild&quot;, &nbsp; &nbsp; &quot;Special info&quot;\n\r\n\r&nbsp;\n\r\n\rFILEFLAGS\n\r\n\rFlagValue&amp;\n\r\n\rDescription\n\r\n\r%VS_FF_DEBUG  \n\r\n\rFile contains debugging information or is compiled with debugging features enabled.\n\r\n\r%VS_FF_PATCHED\n\r\n\rFile has been modified and is not identical to the original shipping file of the same version number.\n\r\n\r%VS_FF_PRERELEASE\n\r\n\rFile is a development version, not a commercially released product.\n\r\n\r%VS_FF_PRIVATEBUILD\n\r\n\rFile was not built using standard release procedures. If this value is given, you must include a PrivateBuild string item.\n\r\n\r%VS_FF_SPECIALBUILD\n\r\n\rFile was built by the original company using standard release procedures, but is a variation of the standard file of the same version number. If this value is given, you must include a SpecialBuild string item.\n\r\n\r&nbsp;\n\r\n\rSTRINGINFO\n\r\n\rLangID\n\r\n\rLanguage\n\r\n\rLangID\n\r\n\rLanguage\n\r\n\r&amp;H0401\n\r\n\rArabic\n\r\n\r&amp;H0415\n\r\n\rPolish\n\r\n\r&amp;H0402\n\r\n\rBulgarian\n\r\n\r&amp;H0416\n\r\n\rPortuguese (Brazil)\n\r\n\r&amp;H0403\n\r\n\rCatalan\n\r\n\r&amp;H0417\n\r\n\rRhaeto-Romanic\n\r\n\r&amp;H0404\n\r\n\rTraditional Chinese\n\r\n\r&amp;H0418\n\r\n\rRomanian\n\r\n\r&amp;H0405\n\r\n\rCzech\n\r\n\r&amp;H0419\n\r\n\rRussian\n\r\n\r&amp;H0406\n\r\n\rDanish\n\r\n\r&amp;H041A\n\r\n\rCroato-Serbian (Latin)\n\r\n\r&amp;H0407\n\r\n\rGerman\n\r\n\r&amp;H041B\n\r\n\rSlovak\n\r\n\r&amp;H0408\n\r\n\rGreek\n\r\n\r&amp;H041C\n\r\n\rAlbanian\n\r\n\r&amp;H0409\n\r\n\rU.S. English\n\r\n\r&amp;H041D\n\r\n\rSwedish\n\r\n\r&amp;H040A\n\r\n\rCastilian Spanish\n\r\n\r&amp;H041E\n\r\n\rThai\n\r\n\r&amp;H040B\n\r\n\rFinnish\n\r\n\r&amp;H041F\n\r\n\rTurkish\n\r\n\r&amp;H040C\n\r\n\rFrench\n\r\n\r&amp;H0420\n\r\n\rUrdu\n\r\n\r&amp;H040D\n\r\n\rHebrew\n\r\n\r&amp;H0421\n\r\n\rBahasa\n\r\n\r&amp;H040E\n\r\n\rHungarian\n\r\n\r&amp;H0804\n\r\n\rSimplified Chinese\n\r\n\r&amp;H040F\n\r\n\rIcelandic\n\r\n\r&amp;H0807\n\r\n\rSwiss German\n\r\n\r&amp;H0410\n\r\n\rItalian\n\r\n\r&amp;H0809\n\r\n\rU.K. English\n\r\n\r&amp;H0411\n\r\n\rJapanese\n\r\n\r&amp;H080A\n\r\n\rSpanish (Mexico)\n\r\n\r&amp;H0412\n\r\n\rKorean\n\r\n\r&amp;H080C\n\r\n\rBelgian French\n\r\n\r&amp;H0413\n\r\n\rDutch\n\r\n\r&amp;H0816\n\r\n\rPortuguese (Portugal)\n\r\n\r&amp;H0414\n\r\n\rNorwegian - Bokmal\n\r\n\r&amp;H081A\n\r\n\rSerbo-Croatian (Cyrillic)\n\r\n\r&amp;H0810\n\r\n\rSwiss Italian\n\r\n\r&amp;H0C0C\n\r\n\rCanadian French\n\r\n\r&amp;H0813\n\r\n\rBelgian Dutch\n\r\n\r&amp;H100C\n\r\n\rSwiss French\n\r\n\r&amp;H0814\n\r\n\rNorwegian - Nynorsk\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\rSTRINGINFO\n\r\n\rCharSet\n\r\n\rCharacter Set\n\r\n\r&amp;H0000\n\r\n\r7-bit ASCII\n\r\n\r&amp;H03A4\n\r\n\rJapan (Shift - JIS X-0208)\n\r\n\r&amp;H03B5\n\r\n\rKorea (Shift - KSC 5601)\n\r\n\r&amp;H03B6\n\r\n\rTaiwan (Big5)\n\r\n\r&amp;H04B0\n\r\n\rUnicode\n\r\n\r&amp;H04E2\n\r\n\rLatin-2 (Eastern European)\n\r\n\r&amp;H04E3\n\r\n\rCyrillic\n\r\n\r&amp;H04E4\n\r\n\rMultilingual\n\r\n\r&amp;H04E5\n\r\n\rGreek\n\r\n\r&amp;H04E6\n\r\n\rTurkish\n\r\n\r&amp;H04E7\n\r\n\rHebrew\n\r\n\r&amp;H04E8\n\r\n\rArabic\n\r\n\r&nbsp;\n\r\n\rRES/PBR Resources\n\r\n\rThe second group of syntax examples show how you can embed resources which have been pre-compiled used a resource compiler. Standard resource compilers output a binary resource with a .RES extension. PowerBASIC will embed this resource just as it is given in the file. This form will always be supported to support resource forms which are typically not needed for most PowerBASIC programs, or which usually require the use of a resource editor.\n\r\n\rThe final example, using a .PBR file, will only be supported for a limited period of time. This is the form created by the PowerBASIC PBRES utility in older versions of the compiler. It is recommended that you change to the .RES version soon, as it is more efficient, and needs less effort from the programmer. It should be noted that prior versions of PowerBASIC allowed the descriptor &quot;PBR&quot; to be omitted. While this option will be supported for a limited period of time, we recommend that you always insert &quot;PBR&quot; for clarity.\n\r\n\rRestrictions\n\r\n\rWindows 95, 98, and ME offer limited support for resources. When compiling on one of these versions of Windows, only #RESOURCE RES and #RESOURCE PBR may be used. Other forms of the #RESOURCE metastatement are not functional.\n\r\n\rRES and PBR resources cannot be mixed with any other resources. Once you add a PBR or RES resource, you cannot add any other #RESOURCE metastatements in your program.\n\r\n\rSee also\n\r\n\rRESOURCE$, Resource Files\n\r\n\rExample\n\r\n\r#RESOURCE ICON, MySpecialIcon, &quot;Icon.ICO&quot;","#RESOURCE metastatement","scr\\html__resource_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rSet the maximum potential stack size.\n\r\n\rSyntax\n\r\n\r#STACK num_expr\n\r\n\rRemarks\n\r\n\rThe literal numeric expression is expressed in bytes, and is rounded up to the next 64 Kb boundary. The minimum allowable stack size is 128 Kb, and a typical stack size of at least 1 Megabyte (the default) is usually recommended.\n\r\n\rUpon program startup, an initial block of 128 Kb of physical memory is allocated to the stack. As the stack grows, additional memory is automatically added, as necessary, up to the specified maximum. Since physical memory is only committed as required, it is usually prudent to overestimate potential stack needs.\n\r\n\rRestrictions\n\r\n\r#STACK is meaningful with EXE (executable) files only.","#STACK metastatement","scr\\html__stack_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rEnable or disable integrated development tool code in compiled code.\n\r\n\rSyntax\n\r\n\r#TOOLS [ON|+ | OFF|-]\n\r\n\rRemarks\n\r\n\rThe #TOOLS metastatement allows integrated development tools like TRACE, PROFILE, and CALLSTK to be readily disabled, ensuring that extra code and data is not compiled into the final (distribution) version of an application. #TOOLS defaults to ON, and may appear only once in the source code, before any statement that generates executable code.\n\r\n\rSee also\n\r\n\rCALLSTK, CALLSTK$, CALLSTKCOUNT, FUNCNAME$, PROFILE, TRACE","#TOOLS metastatement","scr\\html__tools_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rSpecify whether unique variable names are required.\n\r\n\rSyntax\n\r\n\r#UNIQUE VAR [ON|OFF]\n\r\n\rRemarks\n\r\n\rBy default (#UNIQUE VAR OFF), it is possible to use the same name for more than one variable in your program. &nbsp;For example, you might use abc%, abc#, and abc$ in the same function using default typing defined by the Type ID character. &nbsp;You could even create a local variable named &quot;counters&quot; and a global variable also named &quot;counters&quot;.\n\r\n\rSo, when you reference a variable name in your program, which variable is actually used? &nbsp;Depending upon location of the reference, the compiler chooses the variable with the smallest scope. &nbsp;The precedence of variable scopes is:\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1- Local or Static\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2- Instance\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3- Global or Threaded\n\r\n\rWhen #UNIQUE VAR is OFF, PowerBASIC first tries to find a LOCAL or STATIC. &nbsp;Next, an INSTANCE, and finally a GLOBAL or THREADED. &nbsp;It selects the first one it finds, in that sequence. &nbsp;Of course, you cannot use the same name for a LOCAL and a STATIC, unless you use a Type ID character to differentiate them. You can never use the same name for a GLOBAL and a THREADED, as it would be impossible to tell them apart. &nbsp;While this offers the most flexibility, it can be confusing, and can lead to the creation of insidious, hard-to-find errors in your program. &nbsp;When you reference the wrong variable by accident, the results can be disastrous. If #UNIQUE VAR is enabled, PowerBASIC will require that all variable names be unique. &nbsp;The can make your job a good deal easier, as it removes the ambiguity found with identifier reuse. &nbsp;There are a few exceptions to the uniqueness rule, which are designed to improve readability in your code:\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;1- Local, Static, and Parameter names may be reused in other Subs, Functions, and Methods.\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;2- Instance names may reused in other Classes.\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;3- Scalar and array names may co-exist if they they are the same data type and scope.\n\r\n\r&nbsp;\n\r\n\rSee also\n\r\n\r#DIM, DEFtype, DIM, GLOBAL, LOCAL, REDIM, STATIC, OPTION EXPLICIT","#UNIQUE metastatement","scr\\html__unique_metastatement.htm","                  \n\r\n\rPurpose\n\r\n\rCompiler directive to allow external utility programs to read text inserted on the #UTILITY line.\n\r\n\rSyntax\n\r\n\r#UTILITY &quot;any text for an external program&quot;\n\r\n\rRemarks\n\r\n\rThe entire line is ignored by the PowerBASIC compiler.","#UTILITY metastatement","scr\\html__utility_metastatement.htm","                  \n\r\n\rLet\'s assume you want a simple communications program to use for accessing a local computer bulletin board. You know the parameters for the board: it is 14400 baud, 8 data bits, one stop bit, and no parity.\n\r\n\rYou want to display data on your screen, be able to type data, and have it sent to the bulletin board. You intend to use a modem connected to COM1. The following short program serves as a starting point, and uses PowerBASIC\'s new DDT features to create the user interface:\n\r\n\r&nbsp;\n\r\n\r\n\r\n\r&nbsp;\n\r\n\r\'----------------------------------------------------------\n\r\n\r\'\n\r\n\r\' &nbsp;Serial Communications Example for PowerBASIC for Windows\n\r\n\r\' &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Copyright (C) 2004-2009 PowerBASIC, Inc.\n\r\n\r\'\n\r\n\r\' &nbsp;Be sure to set the $ComPort constant to the appropriate\n\r\n\r\' &nbsp;COM port before compiling this example!\n\r\n\r\'\n\r\n\r\'----------------------------------------------------------\n\r\n\r#COMPILE EXE\n\r\n\r#DIM ALL\n\r\n\r#INCLUDE &quot;WIN32API.INC&quot;\n\r\n\r&nbsp;\n\r\n\r$ComPort &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;= &quot;COM1&quot;\n\r\n\r$AppTitle &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; = &quot;PowerBASIC for Windows Comm Example&quot;\n\r\n\r%IDD_MAIN &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; = 100\n\r\n\r%IDC_LISTBOX1 &nbsp; &nbsp; &nbsp; = 101\n\r\n\r%IDC_EDIT1 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;= 102\n\r\n\r%IDC_SEND &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; = 103\n\r\n\r%IDC_QUIT &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; = 106\n\r\n\r%IDC_ECHO &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; = 107\n\r\n\r&nbsp;\n\r\n\rGLOBAL hComm &nbsp; &nbsp; &nbsp; &nbsp;AS LONG\n\r\n\rGLOBAL Updating &nbsp; &nbsp; AS LONG\n\r\n\rGLOBAL hThread &nbsp; &nbsp; &nbsp;AS DWORD\n\r\n\rGLOBAL ThreadClose &nbsp;AS LONG\n\r\n\r&nbsp;\n\r\n\rDECLARE FUNCTION StartComms &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;AS LONG\n\r\n\rDECLARE FUNCTION SendLine(ASCIIZ) &nbsp; &nbsp; &nbsp; &nbsp;AS LONG\n\r\n\rDECLARE THREAD FUNCTION ReceiveData(BYVAL LONG) AS LONG\n\r\n\rDECLARE FUNCTION EndComms &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;AS LONG\n\r\n\rDECLARE FUNCTION AddLine(BYVAL LONG, BYVAL LONG, ASCIIZ) AS LONG\n\r\n\r&nbsp;\n\r\n\rCALLBACK FUNCTION Dialog_Callback() AS LONG\n\r\n\r &nbsp;SELECT CASE CB.MSG\n\r\n\r &nbsp; &nbsp;CASE %WM_INITDIALOG\n\r\n\r &nbsp; &nbsp; &nbsp;\' Set focus to the edit control\n\r\n\r &nbsp; &nbsp; &nbsp;CONTROL SET FOCUS CB.HNDL, %IDC_EDIT1\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp; &nbsp;\' Set SELECTION range to highlight the initial entry\n\r\n\r &nbsp; &nbsp; &nbsp;CONTROL SEND CB.HNDL, %IDC_EDIT1, %EM_SETSEL, 0, -1\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp; &nbsp;\' Return 0 to stop dialog box engine setting focus\n\r\n\r &nbsp; &nbsp; &nbsp;FUNCTION = %FALSE\n\r\n\r &nbsp;END SELECT\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rCALLBACK FUNCTION Send_Callback() AS LONG\n\r\n\r &nbsp;DIM SendText AS ASCIIZ * 1024, ListCount AS LONG\n\r\n\r &nbsp;DIM lResult AS LONG, hListBox AS DWORD\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Obtain the text to send from the edit control\n\r\n\r &nbsp;CONTROL GET TEXT CB.HNDL, %IDC_EDIT1 TO SendText\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Set the update flag\n\r\n\r &nbsp;Updating = %TRUE\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Send the line to the comm port\n\r\n\r &nbsp;IF SendLine(SendText) THEN\n\r\n\r &nbsp; &nbsp;SendText = &quot;Transmission Error!&quot;\n\r\n\r &nbsp;ELSE\n\r\n\r &nbsp; &nbsp;\' Check the Echo mode state\n\r\n\r &nbsp; &nbsp;CONTROL GET CHECK CB.HNDL, %IDC_ECHO TO lResult\n\r\n\r &nbsp; &nbsp;IF ISTRUE lResult THEN SkipEcho\n\r\n\r &nbsp;END IF\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Add the echo to the listbox\n\r\n\r &nbsp;CALL AddLine(CB.HNDL, %IDC_LISTBOX1, &quot;&lt;== &quot; + SendText)\n\r\n\r&nbsp;\n\r\n\rSkipEcho:\n\r\n\r &nbsp;\' Set the SELECTION range for the edit control so the\n\r\n\r &nbsp;\' next keypress &quot;clears&quot; the existing text\n\r\n\r &nbsp;CONTROL SEND CB.HNDL, %IDC_EDIT1, %EM_SETSEL, 0, -1\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' restore the keyboard focus to the edit control\n\r\n\r &nbsp;CONTROL SET FOCUS CB.HNDL, %IDC_EDIT1\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Release the update flag\n\r\n\r &nbsp;Updating = %FALSE\n\r\n\r &nbsp;FUNCTION = %TRUE\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rCALLBACK FUNCTION Quit_Callback() AS LONG\n\r\n\r &nbsp;\' Kill the dialog and let PBMAIN() continue\n\r\n\r &nbsp;DIALOG END CB.HNDL, 0\n\r\n\r&nbsp;\n\r\n\r &nbsp;FUNCTION = 1\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rFUNCTION AddLine(BYVAL hWnd AS DWORD, BYVAL nID AS LONG, SendText AS ASCIIZ) AS LONG\n\r\n\r &nbsp;DIM ListCount AS LONG\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Find the current listbox count\n\r\n\r &nbsp;LISTBOX GET COUNT hWnd, nID TO ListCount\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Update the listbox\n\r\n\r &nbsp;LISTBOX ADD hWnd, nID, SendText\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Scroll the new item into view\n\r\n\r &nbsp;LISTBOX SELECT hWnd, nID, ListCount + 1\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rFUNCTION PBMAIN\n\r\n\r &nbsp;\' Build our GUI interface.\n\r\n\r &nbsp;DIM hDlg AS DWORD, Txt(1 TO 1) AS STRING, lResult AS LONG\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Initialize the port ready for the session\n\r\n\r &nbsp;IF ISFALSE StartComms THEN\n\r\n\r &nbsp; &nbsp; &nbsp;MSGBOX &quot;Failure to start communications!&quot;,, $AppTitle\n\r\n\r &nbsp; &nbsp; &nbsp;EXIT FUNCTION\n\r\n\r &nbsp;END IF\n\r\n\r&nbsp;\n\r\n\r &nbsp;Txt(1) = &quot;Listbox holds the transmission I/O stream...&quot;\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Create a modal dialog box\n\r\n\r &nbsp;DIALOG NEW 0, $AppTitle,,, 330, 203, %WS_POPUP OR %WS_VISIBLE OR %WS_CLIPCHILDREN OR _\n\r\n\r &nbsp; &nbsp; &nbsp;%WS_CAPTION OR %WS_SYSMENU OR %WS_MINIMIZEBOX, 0 TO hDlg\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Add our application controls\n\r\n\r &nbsp;CONTROL ADD LABEL, hDlg, -1, &quot;Transmission &amp;log for &quot; &amp; $ComPort, 9, 5, 100, 10, 0\n\r\n\r&nbsp;\n\r\n\r &nbsp;CONTROL ADD LISTBOX, hDlg, %IDC_LISTBOX1, Txt(), 9, 15, 313, 133, %WS_BORDER OR _\n\r\n\r &nbsp; &nbsp; &nbsp;%LBS_WANTKEYBOARDINPUT OR %LBS_DISABLENOSCROLL OR %WS_VSCROLL OR %WS_GROUP OR _\n\r\n\r &nbsp; &nbsp;%WS_TABSTOP OR %LBS_NOINTEGRALHEIGHT\n\r\n\r &nbsp;CONTROL ADD LABEL, hDlg, -1, &quot;Te&amp;xt to send&quot;, 9, 151, 100, 10, 0\n\r\n\r &nbsp;CONTROL ADD TEXTBOX, hDlg, %IDC_EDIT1, &quot;ATZ&quot;, 9, 161, 257, 12, %ES_AUTOHSCROLL OR _\n\r\n\r &nbsp; &nbsp; &nbsp;%ES_NOHIDESEL OR %WS_BORDER OR %WS_GROUP OR %WS_TABSTOP\n\r\n\r &nbsp;CONTROL ADD BUTTON, hDlg, %IDC_SEND, &quot;Send &amp;Text&quot;, 273, 160, 50, 14, %WS_GROUP OR _\n\r\n\r &nbsp; &nbsp; &nbsp;%WS_TABSTOP OR %BS_DEFPUSHBUTTON CALL Send_Callback\n\r\n\r &nbsp;CONTROL ADD BUTTON, hDlg, %IDC_QUIT, &quot;&amp;Quit&quot;, 273, 182, 50, 14, %WS_GROUP OR %WS_TABSTOP _\n\r\n\r &nbsp; &nbsp; &nbsp;CALL Quit_Callback\n\r\n\r &nbsp;CONTROL ADD CHECKBOX, hDlg, %IDC_ECHO, &quot;Disable Local &quot;+ &quot;&amp;Echo&quot;, 252, 5, 70, 10, _\n\r\n\r &nbsp; &nbsp; &nbsp;%WS_GROUP OR %WS_TABSTOP OR %BS_AUTOCHECKBOX OR %BS_LEFTTEXT\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Erase our array to free memory no longer required\n\r\n\r &nbsp;REDIM Txt()\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Create a &quot;listen&quot; Thread to monitor input from the modem\n\r\n\r &nbsp;THREAD CREATE ReceiveData(hDlg) TO hThread\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Start the dialog box &amp; run until DIALOG END executed.\n\r\n\r &nbsp;DIALOG SHOW MODAL hDlg, CALL Dialog_Callback TO lResult\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Close down our &quot;listen&quot; Thread\n\r\n\r &nbsp;ThreadClose = %TRUE\n\r\n\r&nbsp;\n\r\n\r &nbsp;DO\n\r\n\r &nbsp; &nbsp;THREAD CLOSE hThread TO lResult\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;\' Release time-slice for improved multitasking\n\r\n\r &nbsp; &nbsp;SLEEP 0\n\r\n\r &nbsp;LOOP UNTIL ISTRUE lResult\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Flush &amp; close the comm port\n\r\n\r &nbsp;CALL EndComms\n\r\n\r&nbsp;\n\r\n\r &nbsp;FUNCTION = %TRUE\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rFUNCTION StartComms AS LONG\n\r\n\r &nbsp;hComm = FREEFILE\n\r\n\r &nbsp;COMM OPEN $COMPORT AS #hComm\n\r\n\r &nbsp;IF ERRCLEAR THEN EXIT FUNCTION &nbsp; &nbsp; \' Port problem?\n\r\n\r&nbsp;\n\r\n\r &nbsp;COMM SET #hComm, BAUD &nbsp; &nbsp; = 14400 &nbsp;\' 14400 baud\n\r\n\r &nbsp;COMM SET #hComm, BYTE &nbsp; &nbsp; = 8 &nbsp; &nbsp; &nbsp;\' 8 bits\n\r\n\r &nbsp;COMM SET #hComm, PARITY &nbsp; = %FALSE \' No parity\n\r\n\r &nbsp;COMM SET #hComm, STOP &nbsp; &nbsp; = 0 &nbsp; &nbsp; &nbsp;\' 1 stop bit\n\r\n\r &nbsp;COMM SET #hComm, TXBUFFER = 4096 &nbsp; \' 4 Kb transmit buffer\n\r\n\r &nbsp;COMM SET #hComm, RXBUFFER = 4096 &nbsp; \' 4 Kb receive buffer\n\r\n\r&nbsp;\n\r\n\r &nbsp;FUNCTION = %TRUE\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rFUNCTION SendLine(SendText AS ASCIIZ) AS LONG\n\r\n\r &nbsp;COMM PRINT #hComm, SendText\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rTHREAD FUNCTION ReceiveData(BYVAL hWnd AS DWORD) AS LONG\n\r\n\r &nbsp;DIM InboundData AS STRING\n\r\n\r &nbsp;DIM Stuf AS STRING, ListCount AS LONG\n\r\n\r &nbsp;DIM Qty AS LONG, x AS LONG, a AS STRING\n\r\n\r&nbsp;\n\r\n\r &nbsp;WHILE ISFALSE ThreadClose\n\r\n\r &nbsp; &nbsp;\' Test the RX buffer\n\r\n\r &nbsp; &nbsp;Qty = COMM(#hComm, RXQUE)\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;\' Abort this iteration if sending\n\r\n\r &nbsp; &nbsp;IF ISFALSE Qty OR Updating THEN\n\r\n\r &nbsp; &nbsp; &nbsp;SLEEP 100\n\r\n\r &nbsp; &nbsp; &nbsp;ITERATE LOOP\n\r\n\r &nbsp; &nbsp;END IF\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;\' Read incoming characters\n\r\n\r &nbsp; &nbsp;COMM RECV #hComm, Qty, Stuf\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;InBoundData = InBoundData &amp; Stuf\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;\' strip out LF characters\n\r\n\r &nbsp; &nbsp;REPLACE CHR$(10) WITH &quot;&quot; IN InBoundData\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;\' process only complete lines of data terminated by CR\n\r\n\r &nbsp; &nbsp;WHILE INSTR(InboundData, CHR$(13))\n\r\n\r &nbsp; &nbsp; &nbsp;\' Display the data\n\r\n\r &nbsp; &nbsp; &nbsp;CALL AddLine(hWnd, %IDC_LISTBOX1, &quot;==&gt; &quot; + EXTRACT$(InBoundData, CHR$(13)))\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp; &nbsp;\' reduce the buffer to remove the &quot;displayed&quot; line\n\r\n\r &nbsp; &nbsp; &nbsp;InBoundData = STRDELETE$(InBoundData, 1, LEN(EXTRACT$(InBoundData, CHR$(13))) + 1)\n\r\n\r &nbsp; &nbsp;WEND\n\r\n\r &nbsp;WEND\n\r\n\r&nbsp;\n\r\n\r &nbsp;FUNCTION = %TRUE\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rFUNCTION EndComms() AS LONG\n\r\n\r &nbsp;DIM dummy AS STRING\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Flush the RX buffer &amp; close the port\n\r\n\r &nbsp;SLEEP 1000\n\r\n\r&nbsp;\n\r\n\r &nbsp;IF COMM(#hComm, RXQUE) THEN\n\r\n\r &nbsp; &nbsp;COMM RECV #hComm, COMM(#hComm, RXQUE), dummy\n\r\n\r &nbsp;END IF\n\r\n\r&nbsp;\n\r\n\r &nbsp;COMM CLOSE #hComm\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rThis short program allows you to connect with the bulletin board, but it will not dial the number of the bulletin board through the program itself. You can do that easily though, in one of two ways:\n\r\n\rYou can dial the bulletin board manually. When you\'re done dialing, connect the telephone line to the modem (or press a button on your modem, switching the line from the telephone back to the modem). The program should now be ready to receive whatever the bulletin board sends.\n\r\n\rYou can send the appropriate signals directly to the modem itself. Most modems recognize a common command set originated by the Hayes Company. To initialize the modem and dial, you would enter the following commands:\n\r\n\rATZ\n\r\n\rATDT18005551212\n\r\n\rNote: some modems require capital letters for AT commands. Lowercase letters will not work.\n\r\n\rAfter you have entered the ATZ command, the modem responds. You will see the message &quot;OK&quot; on your screen. After you have entered ATDT and the telephone number, the modem\'s lights flicker for a moment. If your modem is capable of making a sound, you should hear the sounds of the number being dialed, and the telephone ringing at the other end.\n\r\n\rIf the number is busy, you may hear a busy signal through your modem speaker, or you may not hear anything more. If the connection is made, you may see some garbage characters on your screen.\n\r\n\rAt this point, many users become concerned and think that something must be wrong. Why are there illegible characters on screen? &nbsp;Relax: this happens often. The computer you called does not yet know what baud rate and communications parameters you are using. In most cases, you should press ENTER a few times; the computer at the other end will use that character to determine what your parameters are and will adjust itself accordingly. Soon afterward, you should see a welcoming message. You may now type whatever you like.\n\r\n\rIf you see double lines of characters, click on the Disable Local Echo button. This simply prevents the code from adding your characters to the transmission log window.\n\r\n\rIf you wish to send a stream of AT commands to a modem in quick succession, you may be required to add a small delay between each AT command, in order to give the modem time to decode each command and respond appropriately. A delay of 100 to 200 milliseconds (mSec) is usually sufficient.\n\r\n\r&nbsp;\n\r\n\rUsing disk files\n\r\n\rThe sample program does not let you save material to a disk file, or send data from a disk file to the bulletin board. Nevertheless, those two options are very useful. How do you do it?\n\r\n\rLet us suppose you wanted to send a disk file to the bulletin board. To do that, the routine that sends your keystrokes to the bulletin board must be altered. The usual way to do this is to assign a special keystroke a different meaning: instead of being sent, it is interpreted as a command to get the name of a disk file, read that disk file, and send it to the bulletin board.\n\r\n\rLet\'s add a new button to our dialog window to provide access to this feature - we will label this button Send File. In addition, we must also add a Callback Function to handle the event from this button. Lets start by adding the following equate definition to the block near the beginning of the file:\n\r\n\r%IDC_SENDFILE = 104\n\r\n\rNow we will insert the new Callback Function to the code. We\'ll add this immediately after the Send Callback() function ends:\n\r\n\rCALLBACK FUNCTION SendFile_Callback() AS LONG\n\r\n\r &nbsp;STATIC SendFileName AS STRING\n\r\n\r &nbsp;LOCAL hReadFile AS LONG, FileLen AS LONG, Chunk AS LONG\n\r\n\r &nbsp;LOCAL i AS LONG, Buff1 AS STRING\n\r\n\r&nbsp;\n\r\n\r &nbsp;Buff1 = INPUTBOX$(&quot;Name of disk file to transmit?&quot;, &nbsp;$AppTitle, SendFileName)\n\r\n\r &nbsp;IF ISFALSE LEN(Buff1) OR ISFALSE LEN(DIR$(Buff1)) THEN EXIT FUNCTION\n\r\n\r&nbsp;\n\r\n\r &nbsp;SendFileName = Buff1\n\r\n\r &nbsp;CALL AddLine(CB.HNDL, %IDC_LISTBOX1, &quot;Wait... Sending &quot; &amp; SendFileName)\n\r\n\r &nbsp;DIALOG DOEVENTS\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' send the file\n\r\n\r &nbsp;hReadFile = FREEFILE\n\r\n\r &nbsp;OPEN SendFileName FOR BINARY AS #hReadFile \' Binary mode\n\r\n\r &nbsp;FileLen = LOF(hReadFile) &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \' File length\n\r\n\r &nbsp;Chunk &nbsp; = MAX&amp;(32, COMM(#hComm, TXBUFFER) \\ 2) \' 1/2*Buf\n\r\n\r&nbsp;\n\r\n\r &nbsp;FOR ix = 1 TO FileLen \\ Chunk\n\r\n\r &nbsp; &nbsp;GET$ #hReadFile, Chunk, Buff1 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' Read a chunk\n\r\n\r &nbsp; &nbsp;COMM SEND #hComm, Buff1 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' and send it\n\r\n\r &nbsp; &nbsp;SLEEP 0\n\r\n\r &nbsp;NEXT i\n\r\n\r&nbsp;\n\r\n\r &nbsp;IF FileLen MOD Chunk &lt;&gt; 0 THEN &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \' More to send?\n\r\n\r &nbsp; &nbsp;GET$ #hReadFile, FileLen MOD Chunk, Buff1\n\r\n\r &nbsp; &nbsp;COMM SEND #hComm, Buff1\n\r\n\r &nbsp;END IF\n\r\n\r&nbsp;\n\r\n\r &nbsp;CLOSE #hReadFile\n\r\n\r &nbsp;CALL AddLine(CB.HNDL, %IDC_LISTBOX1, &quot;Transmission complete!&quot;)\n\r\n\rEND FUNCTION\n\r\n\rFinally, we insert the code that adds a new control button on the dialog box. Add the following line to the group of CONTROL ADD statements in the PBMAIN function.\n\r\n\rCONTROL ADD BUTTON, hDlg, %IDC_SENDFILE, &quot;&amp;Send File&quot;, 9, 182, 50, 14, %WS_GROUP OR _\n\r\n\r &nbsp; &nbsp;%WS_TABSTOP CALL SendFile_Callback\n\r\n\rThe routine works, but there\'s no error checking in it. If the disk file does not exist, nothing is sent, but a zero-length file is created. If you enter an illegal file name, the program will set the ERR system variable to indicate that [a potentially fatal] error has occurred. You\'ll probably want to add some kind of error checking to the program for those reasons. \n\r\n\rTo receive a disk file, we will add yet another button to the dialog window titled Receive File. However, things are not quite as simple as the code we added to send a file: you must be able to use the program at the same time as the data is stored, as it comes in from the serial port. We also need a way to stop receiving a disk file.\n\r\n\rFirst, we will add another equate to the beginning of the file, exactly as before:\n\r\n\r%IDC_RECEIVEFILE = 105\n\r\n\rAdd the following line at the end of the GLOBAL variable declarations, just below the equates:\n\r\n\rGLOBAL hWriteFile AS LONG\n\r\n\rNext, add the Callback Function code, immediately after the SendFile_Callback() function that we just added.\n\r\n\rCALLBACK FUNCTION ReceiveFile_Callback() AS LONG\n\r\n\r &nbsp;STATIC ReceiveFileName AS STRING\n\r\n\r &nbsp;LOCAL Buff2 AS STRING\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' First check if file is already open\n\r\n\r &nbsp;IF hWriteFile THEN\n\r\n\r &nbsp; &nbsp;\' Close the file\n\r\n\r &nbsp; &nbsp;CLOSE #hWriteFile\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;CALL AddLine(CB.HNDL, %IDC_LISTBOX1, &quot;Finished writing file!&quot;)\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;\' Update the button label\n\r\n\r &nbsp; &nbsp;CONTROL SET TEXT CB.HNDL, %IDC_RECEIVEFILE, &quot;&amp;Receive File&quot;\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;RESET hWriteFile\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;EXIT FUNCTION\n\r\n\r &nbsp;END IF\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Create a new file\n\r\n\r &nbsp;Buff2 = INPUTBOX$(&quot;Output file name?&quot;, $AppTitle, ReceiveFileName)\n\r\n\r &nbsp;IF ISFALSE LEN(Buff2) THEN EXIT FUNCTION\n\r\n\r&nbsp;\n\r\n\r &nbsp;ReceiveFileName = Buff2\n\r\n\r &nbsp;hWriteFile = FREEFILE\n\r\n\r&nbsp;\n\r\n\r &nbsp;OPEN ReceiveFileName FOR APPEND AS #hWriteFile\n\r\n\r &nbsp;IF ERRCLEAR THEN\n\r\n\r &nbsp; &nbsp;\' Error opening the file\n\r\n\r &nbsp; &nbsp;RESET hWriteFile\n\r\n\r &nbsp;ELSE\n\r\n\r &nbsp; &nbsp;\' Update the dialog\n\r\n\r &nbsp; &nbsp;CALL AddLine(CB.HNDL, %IDC_LISTBOX1, &quot;Receiving data stream to &quot; &amp; ReceiveFileName)\n\r\n\r &nbsp; &nbsp;CONTROL SET TEXT CB.HNDL, %IDC_RECEIVEFILE, &quot;Stop &amp;Receive&quot;\n\r\n\r &nbsp;END IF\n\r\n\rEND FUNCTION\n\r\n\rNow add the CONTROL ADD statement into PBMAIN in the same manner as before.\n\r\n\r &nbsp;CONTROL ADD BUTTON, hDlg, %IDC_RECEIVEFILE, &quot;&amp;Receive File&quot;, 62, 182, 50, 14, %WS_GROUP OR _\n\r\n\r &nbsp; &nbsp; &nbsp;%WS_TABSTOP CALL ReceiveFile_Callback\n\r\n\rFinally, to ensure that the disk file is closed correctly, if the program is closed before the file is closed, insert the following lines just before the END FUNCTION within PBMAIN.\n\r\n\rIF hWriteFile THEN CLOSE #hWriteFile\n\r\n\rWhen we click on the new Receive File button, we enter the file name that will be used to save the data. At this point, the output file is opened. The received data will be appended to the end of any existing file of that name. However, we have not provided any way to actually save any of that information. To do that, add one more small line of code to the ReceiveData() function, immediately after the line:\n\r\n\rInBoundData = InBoundData &amp; Stuf\n\r\n\rThe added line reads:\n\r\n\r\' If Receive mode is on, write raw data to the file\n\r\n\rIF hWriteFile THEN PRINT #hWriteFile, Stuf;\n\r\n\r&nbsp;\n\r\n\rFinishing touches &nbsp; \n\r\n\rIf we examine this example file, we find that we have overlooked one problem: if the program is terminated while the output file is in use, the file is not closed.\n\r\n\rWhile this is not a fatal condition, it is a poor approach to program design: we should always close the files we have opened. Remembering to perform this chore will stand you in good steed when it comes to using the Windows API functions. In many cases, failing to close a registry key or delete a GDI object can cause both deceptive and difficult bugs to locate; or memory leaks that reduce system memory even after your program has ended. The golden rule should always be before you leave, clean up after yourself.\n\r\n\rSo, faced with this problem, how do we know if the output file is open before we end the program? &nbsp;Simple... we set the global variable that holds the file number when the file was open. If this number is non-zero (logical TRUE), we can simply assume we need to close the file before finally exiting the program.\n\r\n\rAfter the line that reads:\n\r\n\rCALL EndComms\n\r\n\rWe add the following line to the file:\n\r\n\rIF hWriteFile THEN CLOSE #hWriteFile\n\r\n\rIn this instance, we control three possible scenarios with only one line of code:\n\r\n\r1. the output file feature was not used (hFile2 = 0)\n\r\n\r2. the output file remained open when the program was about to end (hFile2 &lt;&gt; 0)\n\r\n\r3. the output file had been used, but had been closed before program termination (hFile2 &lt;&gt; 0)\n\r\n\rIt is true that we could have just closed the file associated with hWriteFile regardless of the state of the file or the value of the file number. However, in most programming circles, that is considered to be a poor approach. It is always better to write code that is fail-safe in as many conditions as possible.\n\r\n\rThe final program can be found in the PB\\SAMPLES\\COMM folder of your PowerBASIC installation. It is not very large, but it handles a surprising number of ordinary communications tasks. It lacks some error checking, as has been noted. If you choose to modify this program, you might want to put some error checking in. You might also want to test for such problems as the List box control filling up to the limits of the operating system (i.e., 32767 entries in Windows 95/98/ME), and even add a few more buttons to send certain preformatted strings to modem, for example &quot;ATZ&quot; or &quot;ATDT555-1234&quot;.\n\r\n\rCompared to DOS applications, this communications application may seem overly complex. This is because we simply cannot afford to use 100% of the CPU just to monitor a serial port. If we did, your multitasking operating system would suddenly take a huge drop in performance. If you examine the code a little more deeply, you will see it takes advantage of a very handy feature of 32-bit Windows: multi-threading.\n\r\n\rThis communications program consists of two threads in total: (1) the main thread handles the user commands and sending data to the modem; &nbsp;(2) the second thread simply monitors the serial port for receive data. If we used only one single thread in this application, the code would need to share its time between both data reception and transmission, but by using two, we ensure that the CPU is not heavily loaded unnecessarily.\n\r\n\rUsing a second thread in this way effectively splits the application into two (almost) independent sections. The only time these threads need to be aware of each other is when one is writing to the list box control. To handle this, we used a GLOBAL variable to signal when data was being displayed; temporarily &quot;locking&quot; the other thread until the task was complete.\n\r\n\rFor further experimentation, you could split the main thread down even further and create a separate thread just for writing data to the serial port. You could even try replacing the TEXTBOX control with a COMBOBOX so users can scroll back through the most recent &quot;send&quot; strings, providing a simple &quot;history&quot; feature.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rCommunications Basics\n\r\n\rCommunication Buffers\n\r\n\rParity and general error checking\n\r\n\rStart and Stop bits\n\r\n\rOpening a communications port\n\r\n\rReading and writing data","A simple communications program","scr\\html_a_simple_communications_program.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the absolute value of a numeric expression.\n\r\n\rSyntax\n\r\n\ry = ABS(numeric_expression)\n\r\n\rRemarks\n\r\n\rThe absolute value of a number is its non-negative value. For example, the absolute value of -3 is 3, and the absolute value of +3 is also 3. The absolute value of 0 is 0.\n\r\n\rSee also\n\r\n\rSGN","ABS function","scr\\html_abs_function.htm","                  \n\r\n\rPurpose\n\r\n\rAttach a table of keyboard accelerators to a DDT dialog.\n\r\n\rSyntax\n\r\n\rACCEL ATTACH hDlg, AccelTbl() TO hAccelHandle\n\r\n\rRemarks\n\r\n\rACCEL ATTACH permits you to attach one table of accelerator key definitions to each DDT dialog in your application.\n\r\n\rThe keyboard accelerator itself is a specific keystroke combination, which results in a %WM_COMMAND or %WM_SYSCOMMAND message being placed into the application\'s message queue.\n\r\n\rKeyboard accelerators are very similar to command accelerators, and often permit the same action selections as menus offer. Since keyboard accelerators can be used directly, they negate the need to navigate a menu in order to perform a specific action.\n\r\n\rTypically, application menu items inform users of available keyboard accelerators so expert users can work more efficiently without using the actual menus, but can still use the menu if required. The following image shows a menu showing command accelerator and keyboard accelerators for menu items (the command accelerators are underscored):\n\r\n\r\n\r\n\rOn Windows XP and Windows 2000 you may need to press the ALT key before Command Accelerators are made visible. You can set if Command Accelerators are visible when using the ALT key or all the time in the Windows Display Settings.\n\r\n\rFor a command accelerator to operate, the specific menu item must be visible and enabled. Conversely, keyboard accelerators can be used without the menu being open. In the example above, the CTRL+X keystroke combination will perform the CUT action, but the accelerator letter t will only perform the Cut action if the EDIT menu is opened first.\n\r\n\rAccelTbl()\n\r\n\rTo utilize ACCEL ATTACH, you must first build the array AccelTbl() of ACCELAPI User-Defined Types (UDTs). This ACCELAPI structure is a 6-byte structure with the following definition:\n\r\n\rTYPE ACCELAPI WORD\n\r\n\r &nbsp;FVIRT AS BYTE \' Flags: One or more of %FVIRTKEY, %FSHIFT, %FALT and %FCONTROL\n\r\n\r &nbsp;KEY AS WORD \' Accelerator key: ASCII code, or virtual key code {%FVIRTKEY}\n\r\n\r &nbsp;CMD AS WORD \' Accelerator ID code gets passed in CB.CTL {LO(WORD, WPARAM)}\n\r\n\rEND TYPE\n\r\n\rYou must build the array of ACCELAPI types yourself, then attach it to a dialog by executing an ACCEL ATTACH statement. There must be no empty elements in the array, so it must be sized accurately.\n\r\n\r.FVIRT\n\r\n\rThe .FVIRT flags can be combined together with the OR operator to combine the actions of the individual flags, as follows:\n\r\n\r%FALT\n\r\n\rThe ALT key must be pressed along with the accelerator key.\n\r\n\r%FCONTROL\n\r\n\rThe CTRL key must be pressed along with the accelerator key.\n\r\n\r%FSHIFT\n\r\n\rThe SHIFT key must be pressed along with the accelerator key.\n\r\n\r%FVIRTKEY\n\r\n\rThe .KEY member specifies a virtual-key code. If this flag is not specified, the key member is assumed to specify an ASCII character code. %FVIRTKEY permits case-insensitive accelerator keystroke definitions - the Capslock state is ignored. For example, ALT+A and ALT+a (as determined by the Capslock key) produce the same accelerator event. If %FVIRTKEY is not used, the accelerator ALT+A would not trigger if Capslock were inactive.\n\r\n\r.KEY\n\r\n\rIf the %FVIRTKEY flag is specified in the .FVIRT member, the .KEY field contains the virtual key code for the accelerator key. Virtual key equates are defined in the WIN32API.INC file, starting with the prefix %VK_.\n\r\n\rIf %FVIRTKEY is not specified, the accelerator key code in the .KEY member is the ASCII code of the accelerator key. In this case, alphanumeric keystrokes become case-sensitive and the state of the Capslock key state becomes important. For example, if an accelerator were defined for ALT+A, it would be activated only if the Capslock key was on. Conversely, if an accelerator were defined for ALT+a then it would only be activated Capslock was off.\n\r\n\r.CMD\n\r\n\rThe .CMD member should contain the user-defined numeric ID code of the accelerator. When an accelerator keystroke occurs, a WM_COMMAND message is sent to the dialog Callback Function, with the accelerator identifier returned by the CB.CTL function.\n\r\n\rIt is usual practice to use the ID of a control that is to be activated by an accelerator. Accelerator notification codes sent to the Callback Function have CB.CTLMSG set to 1 (as opposed to button click events messages where CB.CTLMSG = %BN_CLICKED).\n\r\n\rhDlg \n\r\n\rThe handle of the dialog to attach the accelerator table to.\n\r\n\rAccelHandle \n\r\n\rDouble-word or Long-integer variable where the handle of the attached accelerator table will be stored, or zero if the attach operation was unsuccessful.\n\r\n\rRestrictions \n\r\n\rIf a previous table was attached to the target dialog, the table is automatically destroyed when the new table is attached in its place. The accelerator table is also destroyed automatically when the dialog is closed.\n\r\n\rYou can destroy the current accelerator table by executing ACCEL ATTACH with an array which is not dimensioned, but there is little or no reason to ever perform this action.\n\r\n\rAccelerator tables can only run correctly when they are created in the same module that creates the dialog to which each table is attached.\n\r\n\rSee also\n\r\n\rDIALOG NEW, MENU ADD STRING, MENU ATTACH\n\r\n\rExample\n\r\n\rDIM ac(0 TO 8) AS ACCELAPI\n\r\n\rLOCAL hAccelHandle AS DWORD\n\r\n\r&nbsp;\n\r\n\rFOR x&amp; = 0 TO 8\n\r\n\r &nbsp;ac(x&amp;).fvirt = %FCONTROL OR %FSHIFT OR %FVIRTKEY\n\r\n\r &nbsp;ac(x&amp;).key = %VK_1 + x&amp; \' CTRL+SHIFT+1 to 9\n\r\n\r &nbsp;ac(x&amp;).cmd = %BTN1 + x&amp; \' %BTN1 to %BTN9\n\r\n\rNEXT x&amp;\n\r\n\r&nbsp;\n\r\n\rACCEL ATTACH hDlg, ac() TO hAccelHandle","ACCEL ATTACH statement","scr\\html_accel_attach.htm","                  \n\r\n\rMost variables in a PowerBASIC module are visible to Inline Assembler code created with the ASM statement. You can reference LOCAL, STATIC, and GLOBAL variables by name by simply using the name as an operand of the assembler opcode. That isn\'t possible with INSTANCE, THREADED, array, and pointer variables, as their access requires multiple operations best handled by higher level PowerBASIC code. You can also reference procedure parameters by name, though you must differentiate between parameters passed by reference (BYREF), and those passed by value (BYVAL). Any variable referenced in an assembly-language statement must be defined prior to use.\n\r\n\rSUB DoStuff (BYVAL c&amp;)\n\r\n\r &nbsp;LOCAL a%, b$\n\r\n\r &nbsp;a% = 7 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' Local variable a%\n\r\n\r &nbsp;! PUSH EBX\n\r\n\r &nbsp;! MOV &nbsp;AX, a% &nbsp; &nbsp; &nbsp; ; Move value to AX\n\r\n\r &nbsp;! ADD &nbsp;a%, AX &nbsp; &nbsp; &nbsp; ; Add value back to a%\n\r\n\r &nbsp;b$ = &quot;LINDA&quot; &nbsp; &nbsp; &nbsp; &nbsp;\' Local variable b$\n\r\n\r &nbsp;! MOV &nbsp;EBX, b$ &nbsp; &nbsp; &nbsp;; Address of b$\n\r\n\r &nbsp;! MOV &nbsp;[EBX], &quot;l&quot; &nbsp; ; Put lowercase &quot;l&quot; in first position\n\r\n\r &nbsp;! MOV &nbsp;EAX, c&amp; &nbsp; &nbsp; &nbsp;; Put c&amp; into EAX\n\r\n\r &nbsp;! INC &nbsp;EAX &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;; Increment its value\n\r\n\r &nbsp;! MOV &nbsp;c&amp;, EAX &nbsp; &nbsp; &nbsp;; Put it back\n\r\n\r &nbsp;! POP &nbsp;EBX\n\r\n\rEND SUB\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rThe Inline Assembler","Accessing PowerBASIC variables by name","scr\\html_accessing_powerbasic_variables_by_name.htm","                  \n\r\n\rTo work with the individual fields within a record variable, separate the field name from the variable name with a period. Here are some examples using the Student variable in the above DIM statement:\n\r\n\rLast$ &nbsp; &nbsp; = Student.LastName\n\r\n\rMessage$ &nbsp;= &quot;Id number is: &quot; + STR$(Student.IdNum)\n\r\n\rStudent.FirstName = &quot;Bob&quot;\n\r\n\rStudent.LastName &nbsp;= &quot;Smith&quot;\n\r\n\rFullname$ = Student.LastName + &quot; &quot; + Student.FirstName\n\r\n\rFullname$ = RTRIM$(Student.LastName) + &quot;, &quot; + RTRIM$(Student.FirstName)\n\r\n\rNote that the last two statements above produce slightly differing results. The former produces a string that contains the text plus any $SPC (space) characters that pad the text in each of the Student.LastName and Student.FirstName members. Comparatively, the latter statement returns a string with these padding characters removed. In many cases, it can be easier to use a nul-terminated string members to alleviate the need to frequently trim such fixed-length strings, but allowance must be made for the additional $NUL terminator byte required by nul-terminated strings.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rUser-Defined Types (UDTs)\n\r\n\rDefining User-Defined Types\n\r\n\rAccessing the fields of a User-Defined Type\n\r\n\rNesting User-Defined Types\n\r\n\rArrays within User-Defined Types\n\r\n\rUsing arrays of User-Defined Types\n\r\n\rUsing User-Defined Types with procedures\n\r\n\rStorage requirements and restrictions\n\r\n\rUnions","Accessing the fields of a User-Defined Type","scr\\html_accessing_the_fields_of_a_user_defined_type.htm","                  \n\r\n\rPurpose\n\r\n\rTranslates Unicode bytes into ANSI bytes.\n\r\n\rSyntax\n\r\n\ra$ = ACODE$(UnicodeStrExpression [,CodePage&amp;])\n\r\n\rRemarks\n\r\n\rThis version of PowerBASIC handles all conversions between ANSI strings and UNICODE strings automatically. For example:\n\r\n\rMyAnsiString$ = MyWideString$$\n\r\n\rIn this case, the wide characters are transparently converted to byte characters when they are stored in MyAnsiString$. You should not insert an ACODE$ function here. The simple fact that the variables are of differing types (ANSI/WIDE) causes the compiler to make all conversions for you, whenever they are needed.\n\r\n\rOf course, this automatic conversion was not available in previous versions of the compiler. In the past, there were no WIDE UNICODE variables offered, so it was necessary to force wide characters into standard byte strings when UNICODE was needed. The ACODE$ and UCODE$ functions are used for this purpose alone: to support legacy programs which calculated strings in this fashion.\n\r\n\rNew PowerBASIC programs and updates to your older PowerBASIC programs should use the new WIDE UNICODE variables which are now available.\n\r\n\rACODE$ presumes that the UnicodeStrExpression contains WIDE UNICODE characters stored in an ANSI byte string. It converts them into ANSI byte characters and returns them as an ANSI string. To convert an ANSI byte string into a UNICODE byte string, use the UCODE$ function.\n\r\n\rIf the optional parameter CodePage&amp; is present, it represents the code page to be used for the conversion process. If not given, the default code page for the locale of the executing computer is used.\n\r\n\rUnicode strings require two bytes to represent a Unicode character, whereas ANSI strings (the native PowerBASIC string format) use one byte to represent a character. Therefore, ACODE$ returns a string that has half of the byte count of the Unicode string, yet represents the same number of characters.\n\r\n\rSee also\n\r\n\rUCODE$, UCODEPAGE","ACODE$ function","scr\\html_acode_function.htm","                  \n\r\n\rThird Party libraries, utilities, and tools can be found on the Add-on\'s section on the PowerBASIC web site.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rAdditional Source Code and Examples\n\r\n\rWIN32API.INC Updates","Add-on Libraries, Utilities and Tools","scr\\html_add_on_libraries_utilities_and_tools.htm","                  \n\r\n\rOnce the dialog has been created, we can add controls to it. For our example, we will add a text box to let the user type in their name, and also add two BUTTON controls (&quot;OK&quot; and &quot;Cancel&quot;):\n\r\n\rCONTROL ADD TEXTBOX, hDlg, IdText&amp;\n\r\n\r, &quot;&quot;, 14, 21, 134, 12, Style&amp;, exStyle&amp;\n\r\n\rCONTROL ADD BUTTON, hDlg, 1, &quot;&amp;OK&quot;, 44, 38, 40, 14, %BS_DEFAULT or %WS_TABSTOP CALL Ok\n\r\n\rCONTROL ADD BUTTON, hDlg, 2, &quot;&amp;Cancel&quot;, 90, 38, 40, 14 CALL Cancel\n\r\n\rhDlg refers to the handle of the dialog you\'re adding the control to, as returned by the DIALOG NEW statement.\n\r\n\rThe next parameter IdText&amp;, 1, and 2 in the example lines above) is the unique numeric identifier (ID) for the control. Whereas dialog handles are determined by Windows at run-time, controls use ID values that are specified by the programmer. By knowing the dialog handle and a control ID, we can identify and interact programmatically with any control on a DDT dialog using any of the control-related DDT statements.\n\r\n\rIn general, ID values should be kept within in the range 100 to 65535. It should also be noted that some values below 100 are reserved by Windows for special purposes. For example, the special ID value 1 (%IDOK) is usually assigned to a Button control that is to be activated when the ENTER key is pressed (this would typically be the &quot;OK&quot; button on a dialog). Similarly, the special ID value of 2 (%IDCANCEL) is usually assigned to a Button control that is to be activated when the ESCAPE key is pressed (typically this would be the &quot;Cancel&quot; button).\n\r\n\rIn general, two controls on a given dialog should not use the same ID value, as it prevents them from being identified uniquely. However, it is common to assign the special value -1&amp; to plain Label (static) controls that will not have their content, style, or color changed at run-time.\n\r\n\rIt is always a good idea to plan the values of control identifiers carefully. For example, a set of related Option (radio) controls should use ID values that are ordered sequentially, as this makes it very easy to manipulate them as a group with the CONTROL SET OPTION statement, etc. Another common scheme is keep all the ID numbers for the controls in a specific range. For example, the first dialog in a program might use controls whose ID values are in the range 100 to 199, the second dialog might use the range 200 to 299, etc.\n\r\n\rThe identifier parameter is followed by the caption text for the control. The ampersand symbols &quot;&amp;&quot; within the caption text fields is surprisingly helpful - the letter that follows the symbol specifies a command accelerator (hot-key). At run-time, the accelerator character is drawn underscored: OK and Cancel. In this case, the underscored character informs the user that pressing the ALT+O keys has the same effect as using the mouse to click the &quot;OK&quot; button. Similarly, the ALT+C combination will trigger the &quot;Cancel&quot; button.\n\r\n\rCoordinates used in the CONTROL ADD statement are specified in the same terms (dialog units or pixels) as the parent dialog. The final Style&amp; (primary style) and exStyle&amp; (extended style) parameters tell Windows how to draw the control, and how the control should behave. These parameters are optional, and if omitted, receive default styles according to the type of control.\n\r\n\r\n\r\n\rEach type of control has its own unique set of style options. \n\r\n\rMost of the equates have been predefined in the DDT.INC and WIN32API.INC files supplied with PowerBASIC.\n\r\n\rIt should be noted that explicit (custom) style values replace the default values for the control. That is, custom styles are not additional to the default style values - your code must specify all necessary style parameters. This also applies to the extended styles parameter - if your code specifies a custom primary style, the default extended style will no longer be in effect either. In this case, an explicit extended style may also need to be added to the CONTROL ADD statement if an explicit primary style is specified.\n\r\n\rThe CONTROL ADD statement for the &quot;OK&quot; button includes the keyword CALL. This tells Windows to call the &quot;OK&quot; function each time the &quot;OK&quot; button is pressed. The &quot;OK&quot; function is simply a Callback Function that contains the code you want to execute when the button is pressed (or when some other control-related event occurs).\n\r\n\rIn this example, we want to assign the text from the text box control to a global string, and then close the dialog box. However, we first must check that our code is executed only in response to a &quot;click&quot; event - we would not want our dialog to end if some other notification message was sent to the callback! We do this by testing the values of the message parameters held in the CB.HNDL, CB.MSG, and CB.CTLMSG system variables:\n\r\n\rCALLBACK FUNCTION Ok() AS LONG\n\r\n\r &nbsp;IF CB.MSG = %WM_COMMAND AND CB.CTLMSG = %BN_CLICKED THEN\n\r\n\r &nbsp; &nbsp;CONTROL GET TEXT CB.HNDL, %IDTEXT TO gsUserName\n\r\n\r &nbsp; &nbsp;DIALOG END CB.HNDL, 1 \' Return 1\n\r\n\r &nbsp; &nbsp;FUNCTION = 1\n\r\n\r &nbsp;END IF\n\r\n\rEND FUNCTION\n\r\n\rSimilarly, we provide a Callback Function for the &quot;Cancel&quot; button, which will close the dialog box, ignoring any text entered into the text box:\n\r\n\rCALLBACK FUNCTION Cancel() AS LONG\n\r\n\r &nbsp;IF CB.MSG = %WM_COMMAND AND CB.CTLMSG = %BN_CLICKED THEN\n\r\n\r &nbsp; &nbsp;DIALOG END CB.HNDL, 0 \' Return 0\n\r\n\r &nbsp; &nbsp;FUNCTION = 1\n\r\n\r &nbsp;END IF\n\r\n\rEND FUNCTION\n\r\n\rOnce the dialog has been created and the controls added, we are ready to display the dialog on the screen. In this example, we will create it as a Modal dialog. That means that when the DIALOG SHOW MODAL statement is executed, the execution of this portion of our program will block (halt) until the dialog is closed: (see Modal vs. Modeless below for more information on modal and modeless dialogs)\n\r\n\rLOCAL lResult AS LONG\n\r\n\r...\n\r\n\rDIALOG SHOW MODAL hDlg TO lResult\n\r\n\rDuring the time that the &quot;main&quot; part of our code is blocked by the modal dialog, DDT may call the code in the Callback Functions in response to user interaction, etc. If no events occur, our code is not executed at all, and therefore uses no CPU time. In this example, the dialog only closes when the user eventually clicks the OK or the Cancel button (or presses the ENTER or ESCAPE keys).\n\r\n\rOnce the dialog is closed, the lResult variable will contain the value set using the DIALOG END statement, and execution of the statements following the DIALOG SHOW statement will resume. In our example, we use a return value of one (1) to indicate that the user clicked the OK button, and a return value of 0 to indicate the user clicked the Cancel button.\n\r\n\rThe complete example code can be found in the HELLODDT.BAS file in the \\PB\\SAMPLES\\DDT\\HELLODDT folder:\n\r\n\r#COMPILE EXE\n\r\n\r#INCLUDE &quot;DDT.INC&quot;\n\r\n\r&nbsp;\n\r\n\r%IDOK = 1\n\r\n\r%IDCANCEL = 2\n\r\n\r%IDTEXT = 100\n\r\n\r%BS_DEFAULT = 1\n\r\n\r&nbsp;\n\r\n\r\' Global variable to receive the user name\n\r\n\rGLOBAL gsUserName AS STRING\n\r\n\r&nbsp;\n\r\n\rCALLBACK FUNCTION OkButton()\n\r\n\r &nbsp;IF CB.MSG = %WM_COMMAND AND CB.CTLMSG = %BN_CLICKED THEN\n\r\n\r &nbsp; &nbsp;CONTROL GET TEXT CB.HNDL, %IDTEXT TO gsUserName\n\r\n\r &nbsp; &nbsp;DIALOG END CB.HNDL, 1\n\r\n\r &nbsp; &nbsp;FUNCTION = 1\n\r\n\r &nbsp;END IF\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rCALLBACK FUNCTION CancelButton()\n\r\n\r &nbsp;IF CB.MSG = %WM_COMMAND AND CB.CTLMSG = %BN_CLICKED THEN\n\r\n\r &nbsp; &nbsp;DIALOG END CB.HNDL, 0\n\r\n\r &nbsp; &nbsp;FUNCTION = 1\n\r\n\r &nbsp;END IF\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rFUNCTION PBMAIN() AS LONG\n\r\n\r&nbsp;\n\r\n\rLOCAL hDlg AS DWORD\n\r\n\rLOCAL lResult AS LONG\n\r\n\r&nbsp;\n\r\n\r\' ** Create a new dialog template\n\r\n\rDIALOG NEW 0, &quot;What is your name?&quot;, ,, 160, 50, 0, 0 TO hDlg\n\r\n\r&nbsp;\n\r\n\r\' ** Add controls to it\n\r\n\rCONTROL ADD TEXTBOX, hDlg, %IDTEXT, &quot;&quot;, 14, 12, 134, 12\n\r\n\rCONTROL ADD BUTTON, hDlg, %IDOK, &quot;OK&quot;, 34, 32, 40, 14, %BS_DEFAULT OR %WS_TABSTOP CALL OkButton\n\r\n\rCONTROL ADD BUTTON, hDlg, %IDCANCEL, &quot;Cancel&quot;, 84, 32, 40, 14 CALL CancelButton\n\r\n\r&nbsp;\n\r\n\r\' ** Display the dialog\n\r\n\rDIALOG SHOW MODAL hDlg TO lResult\n\r\n\r&nbsp;\n\r\n\r\' ** Check the dialog return result\n\r\n\rIF lResult THEN\n\r\n\r &nbsp;MSGBOX &quot;Hello &quot; &amp; gsUserName, &amp;H00002000&amp; \' = %MB_TASKMODAL\n\r\n\rEND IF\n\r\n\r&nbsp;\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rDynamic Dialog Tools (DDT)\n\r\n\rCreating a Dialog\n\r\n\rModal vs. Modeless\n\r\n\rControls\n\r\n\rControl Styles\n\r\n\rCallbacks\n\r\n\rDialog Styles\n\r\n\rMenus","Adding Controls to the Dialog","scr\\html_adding_controls.htm","                  \n\r\n\rThe PowerBASIC IDE has built-in context-sensitive help for PowerBASIC keywords. If the caret is placed on a keyword when you invoke help, you will get help for that specific keyword. Now, you can add context-sensitive help for your own help files. Here\'s how.\n\r\n\rFor each help file, create a text file with a name of your choice, with a file extension of .PBKeys (using the PowerBASIC IDE, NotePad, or any other text editor). The first line of the text file must contain the name of the help file, as it will be shown in the IDE\'s help menu, like so:\n\r\n\rMenuName=&quot;PowerTree 1.1&quot;\n\r\n\rThe next line of the PBKeys file specifies the name and location of the help file. If the help file is in the same directory as the .PBKeys file, you can specify just the filename, without the path. Otherwise, you must provide a fully-qualified absolute path:\n\r\n\rHelpFile=&quot;C:\\PTreeW11\\PwrTree.hlp&quot;\n\r\n\rEach following line specifies a help keyword. This keyword must be present in the index of the help file, in order for context-sensitive help to work.\n\r\n\rHelpKey=&quot;AccessBlock&quot;\n\r\n\rHelpKey=&quot;ptCreateIndex&quot;\n\r\n\rHelpKey=&quot;ptAdd&quot;\n\r\n\rand so forth.\n\r\n\rWhen you\'re done, save the .PBKeys file in the Bin subdirectory for your compiler. The default location for this is, typically, &quot;C:\\PBWIN10\\Bin\\&quot;. Now, the next time you start the PowerBASIC IDE, your custom keywords will be recognized by the context-sensitive help system. You will also be able to load the help file from the Help menu.\n\r\n\rIf your help file does not appear in the Help menu when you start the IDE, make sure the HelpFile line of the .PBKeys file specifies the correct location and name for your help file.\n\r\n\rThe complete PowerTree .PBKeys file, &quot;PowerTree 1.1.PBKeys&quot;, is already installed in your compiler\'s Bin subdirectory. Please note that the custom help list is only loaded if you have PowerTree 1.1, and it\'s installed at the location specified in the HelpFile line of the PBKeys file.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rThe Integrated Development Environment","Custom Help Files","scr\\html_adding_your_own_help_files_.htm","                  &#183;Pre-Compiled modules and libraries are now supported.&#183;Unreferenced code is automatically removed from the compiled program to minimize the executable file size. This can be overridden using the #OPTIMIZE OFF metastatement.&#183;There is a dramatic improvement of execution speed in many/most DWORD expressions. &#183;Dramatic improvement in GRAPHIC execution speed.&#183;Mask variable assignment expressions may contain any combination of LONG and DWORD values without error. Operators may include +, -, AND, OR, XOR.&#183;WSTRING, WSTRINGZ and WFIELD wide Unicode strings data types are now supported.&#183;Variant variables now recognize the %VT_DECIMAL data type and now may contain UDT data as a string of bytes (%VT_BSTR).&#183;Many new predefined numeric equates and string equates have been built-in to the compiler. One new equate is %PB_COMPILETIME which contains the date and time of compilation. See the Built-in string equates and Built-in numeric equates topics for a complete list.&#183;Run Time error code 98 added: XPRINT PREVIEW error&#183;Compiler error code 444 added: PREFIX clause expected. A PREFIX clause is expected in this statement.&#183;Compiler error code 461 changed: INSTANCE arrays must be declared. INSTANCE arrays must be declared before any CLASS code.&#183;Compiler error code 465 changed: May be defined only once. A program element which should only appear once was duplicated in your program. For example, two #STACK metastatements could cause this error to be generated. A common source of this problem is multiple #INCLUDE files which define the same term.&#183;Compiler error code 466 changed: This name is already in use. This name (identifier) is used for more than one purpose, causing a fatal conflict. For example, you might have used the name ABC as both a variable and a label. You must rename one or both uses of this particular name. PowerBASIC generates this error when it sees the second use of the name.&#183;Compiler error code 468 changed: This equate may not be redefined. A numeric or string equate is defined a second time with a different value. Equate definitions may appear more than once, but the value must remain constant.&#183;Compiler error code 500 update: Variable name must be unique. All Global, Threaded, and Instance variable names must be unique to guarantee access to a specific variable. If #UNIQUE VAR ON is specified, then all variable names must be unique.&#183;Compiler error code 503 changed: Invalid MAIN Function(s). Main/ LibMainFunction(s) do not match the target file type.&#183;Compiler error code 512 changed: Brackets not supported (use OPTIONAL). Brackets are no longer supported for optional parameters.&#183;Compiler error code 518 removed.&#183;Compiler error code 540 changed: Invalid operation with a register variable. This assembler opcode or operands are invalid using a register variable.&#183;Compiler error code 560 added: FASTPROC expected. A FASTPROC statement must precede other related statements like EXIT FASTPROC and END FASTPROC.&#183;Compiler error code 561 added: END FASTPROC expected. A FASTPROC statement must be matched with an associated END FASTPROC.&#183;Compiler error code 599 changed: Requires CLASS but outside of Interfaces. This item must be enclosed within a CLASS, but outside of Interfaces.&#183;Compiler error code 606 changed: PowerCollection / LinkListCollection required. FOR EACH loops require an object of a specific class.&#183;Compiler error code 607 added: New syntax requires GETCOM/NEWCOM/ANYCOM. The LET statement syntax for COM OBJECT creation has been changed. Previous syntax is no longer recognized.&#183;Compiler error code 609 added: Too many macro expansions. You have used more than 65,535 macros in this program.&#183;Compiler error code 610 added: Invalid within a FastProc. You have used a feature which is not supported within a FastProc.&#183;Compiler error code 611 added: FASTPROC params must be ByVal Long Integer. FASTPROC parameters must be ByVal Long Integer.&#183;Compiler error code 612 added: FASTPROC return may only be Long Integer. FASTPROC return value must be Long Integer or nothing.&#183;Compiler error code 613 added: &nbsp;Cannot compile - the program is now running. The program you are trying to compile is currently executing. You may have to use Task Manager to force the program to end.&#183;Compiler error code 614 added: &nbsp;Mismatched CHR Mode (ANSI/Wide). The string operand does not match the required ANSI or Wide mode.&#183;Compiler error code 615 added: PREFIX expected. A PREFIX statement must precede each END PREFIX statement.&#183;Compiler error code 616 added: END PREFIX expected. A PREFIX statement must be matched with an associated END PREFIX.&#183;Compiler error code 617 added: ASMDATA expected. An ASMDATA statement must precede each END ASMDATA statement.&#183;Compiler error code 618 added: END ASMDATA expected. An ASMDATA statement must be matched with an associated END ASMDATA.&#183;Compiler error code 619 added: ENUM expected. An ENUM statement must precede each END ENUM statement.&#183;Compiler error code 620 added: END ENUM expected. An ENUM statement must be matched with an associated END ENUM.&#183;Compiler error code 621 added: Interface cannot inherit from itself. An interface cannot inherit from itself.&#183;Compiler error code 622 added: AS STRING required for variant conversion. Conversion from a UDT as a string requires AS STRING notation.&#183;Compiler error code 623 added: THREADPARM Instance variable required. THREAD Class must declare a THREADPARM Instance variable.&#183;Compiler error code 624 added: Invalid THREADPARM variable type. THREADPARM must be a LONG, DWORD, or UDT PTR INSTANCE variable.&#183;Compiler error code 625 added: THREAD Method required. THREAD Class must include a THREAD Method.&#183;Compiler error code 626 added: Duplicate THREAD Method. THREAD Class must have exactly one THREAD Method.&#183;Compiler error code 627 added: INHERIT IPowerThread expected. THREAD METHOD is only allowed with a threaded interface.&#183;Compiler error code 628 added: Not valid in a Static-Link-Library (SLL). This language element is invalid in a Static-Link-Library.&#183;Compiler error code 629 added: ALIAS disallows Private/Thread/Callback.&#183;Compiler error code 630 added: Link File Error. The SLL Link File is not valid for this compiler.&#183;Compiler error code 631 added: Nested Link Files. You cannot link an SLL file into an SLL file.&#183;Compiler error code 632 added: COMMON name is a duplicate. COMMON procedure name was previously defined.&#183;Compiler error code 633 added: COMMON signature is mismatched. COMMON procedure signature (params, return type...) is mismatched.&#183;Compiler error code 634 added: Undefined COMMON reference. COMMON item was referenced but not defined.&#183;Compiler error code 635 added: USING clause is required. USING &lt;ProcName&gt; is required to describe the function signature.&#183;Compiler error code 636 added: Invalid VersionInfo Resource.&#183;Compiler error code 637 added: This SLL requires CONSOLE (PB/CC only) or DDT support which is not available.&#183;Compiler error code 638 added: Please change AS STRING to AS WSTRING.&#183;Compiler error code 639 added: TYPE variable expected.&#183;Compiler error code 640 added: Invalid use of BYCOPY. The BYCOPY override may not be used with certain parameters (for example, entire arrays).\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rNew Statements and Functions\n\r\n\rChanges to existing Statements and Functions\n\r\n\rNew in the IDE","Additional Changes","scr\\html_additional_changes.htm","                  \n\r\n\rAdditional source code, example files, and utilities can be found on the PowerBASIC web site. Click the following links to go to those web pages:&#183;The FILES section on the PowerBASIC web site  &#183; The Source Code forum in the free PowerBASIC Peer Support Forums on the PowerBASIC web site\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rAdd-on Libraries, Utilities and Tools\n\r\n\rWIN32API.INC Updates","Additional Source Code and Examples","scr\\html_additional_source_code_and_examples.htm","                  \n\r\n\rAn important distinction in assembler is the difference between the address of a variable and the value of a variable. The address of a variable is where it is located in memory; the value of a variable is what is stored at that address.\n\r\n\rThis is the ADDRESS of the variable in memory:\n\r\n\r\n\r\n\rThis is the VALUE at that address:\n\r\n\r\n\r\n\rThe method used in assembler to get the value at an address is a technique called dereferencing.\n\r\n\r! MOV EAX, lpvar &nbsp;; Copy address into EAX\n\r\n\r! MOV EAX, [EAX] &nbsp;; Dereference it\n\r\n\r! MOV nuvar, EAX &nbsp;; Copy EAX into new variable\n\r\n\rUsing square brackets around EAX gives access to the information at the address in EAX. This is the case with any 32-bit register. A register enclosed in square brackets is effectively a memory operand. The size of the data accessed at the address is determined by the size of the register used to receive it. In the above example, it would be a 32-bit value since it uses a 32 bit register for the destination operand. Naturally, it can be done with 8 and 16-bit values as well using the correct size register.\n\r\n\rPointers\n\r\n\rPointers are a useful high-level language abstraction for passing addresses between procedures and performing other types of complex data manipulation.\n\r\n\rIn assembler, when you use an instruction like:\n\r\n\r! LEA EAX, MyVar\n\r\n\ryou have put the address of a variable into the EAX register. When you take the next step and put that address into a variable of its own, you will have a POINTER to the address:\n\r\n\r! LEA EAX, MyVar\n\r\n\r! MOV lpMyVar, EAX\n\r\n\rThe mechanics of this process are worth understanding as it can generate errors that are hard to track down when the technique is used incorrectly.\n\r\n\rYou can pass a pointer to another procedure either by its value:\n\r\n\r! MOV EAX, lpMyVar &nbsp; &nbsp;; Copy the value into EAX\n\r\n\r! PUSH EAX &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;; Push it as a parameter\n\r\n\r! CALL MyProcedure &nbsp; &nbsp;; Call the procedure\n\r\n\ror you can pass it by reference:\n\r\n\r! LEA EAX, lpMyVar &nbsp; &nbsp;; Load the address into EAX\n\r\n\r! PUSH EAX &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;; Push it as a parameter\n\r\n\r! CALL MyProcedure &nbsp; &nbsp;; Call the procedure\n\r\n\rWhen you pass an address in this manner, you have added an extra level of indirection so at the procedure end, you have a reference to a reference to an address. To get the address in the procedure, you need to dereference the variable to get back the original address:\n\r\n\r! MOV EAX, lpMyVar\n\r\n\r! MOV EAX, [EAX]\n\r\n\rThe original address is now stored in EAX.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rThe Inline Assembler\n\r\n\rEffective addressing","Addressing and pointers","scr\\html_addressing_and_pointers.htm","                  \n\r\n\rThe simplest TCP server application is an Echo Server (RFC 862). It simply listens to port 7, and when it receives a data packet, it returns the data packet back to the client.\n\r\n\rWriting a TCP server in PowerBASIC is quite straightforward, but your application must contain a (GUI) window or dialog to receive notification requests from Winsock. It is therefore necessary to either: (1) create a dialog with DDT, or (2) use the Windows API to create a GUI window for the application to receive these notifications. The following function will register a window class, and create a hidden window that can be used by your server.\n\r\n\rFUNCTION MakeWindow() AS DWORD\n\r\n\r &nbsp;LOCAL wce &nbsp; &nbsp; &nbsp; &nbsp; AS WndClassEx\n\r\n\r &nbsp;LOCAL szClassName AS ASCIIZ * 80\n\r\n\r &nbsp;LOCAL hWnd &nbsp; &nbsp; &nbsp; &nbsp;AS DWORD\n\r\n\r &nbsp;STATIC registered AS LONG\n\r\n\r&nbsp;\n\r\n\r &nbsp;IF ISFALSE registered THEN\n\r\n\r &nbsp; &nbsp;szClassName &nbsp; &nbsp; &nbsp; = &quot;PBTCPCOMM&quot;\n\r\n\r &nbsp; &nbsp;wce.cbSize &nbsp; &nbsp; &nbsp; &nbsp;= SIZEOF(wce)\n\r\n\r &nbsp; &nbsp;wce.style &nbsp; &nbsp; &nbsp; &nbsp; = %NULL\n\r\n\r &nbsp; &nbsp;wce.lpfnWndProc &nbsp; = CODEPTR(TcpProc)\n\r\n\r &nbsp; &nbsp;wce.cbClsExtra &nbsp; &nbsp;= 0\n\r\n\r &nbsp; &nbsp;wce.cbWndExtra &nbsp; &nbsp;= 0\n\r\n\r &nbsp; &nbsp;wce.hInstance &nbsp; &nbsp; = GetModuleHandle(BYVAL %NULL)\n\r\n\r &nbsp; &nbsp;wce.hIcon &nbsp; &nbsp; &nbsp; &nbsp; = %NULL\n\r\n\r &nbsp; &nbsp;wce.hCursor &nbsp; &nbsp; &nbsp; = %NULL\n\r\n\r &nbsp; &nbsp;wce.hbrBackground = %NULL\n\r\n\r &nbsp; &nbsp;wce.lpszMenuName &nbsp;= %NULL\n\r\n\r &nbsp; &nbsp;wce.lpszClassName = VARPTR(szClassName)\n\r\n\r &nbsp; &nbsp;wce.hIconSm &nbsp; &nbsp; &nbsp; = %NULL\n\r\n\r &nbsp; &nbsp;RegisterClassEx wce\n\r\n\r &nbsp; &nbsp;registered = %TRUE\n\r\n\r &nbsp;END IF\n\r\n\r&nbsp;\n\r\n\r &nbsp;hWnd = CreateWindow(&quot;PBTCPCOMM&quot;, &quot;&quot;, 0,0,0,0,0, %NULL, %NULL, _\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; GetModuleHandle(BYVAL %NULL), BYVAL %NULL)\n\r\n\r &nbsp;ShowWindow hWnd, %SW_HIDE\n\r\n\r&nbsp;\n\r\n\r &nbsp;FUNCTION = hWnd\n\r\n\rEND FUNCTION\n\r\n\rTo create a TCP server, your program must first open a socket using the TCP OPEN SERVER statement. Then, when a client contacts your server, this socket will receive the notification. To specify which notifications your code will process, use the TCP NOTIFY statement:\n\r\n\r%TCP_ACCEPT = %WM_USER + 4093 \' user-defined message value\n\r\n\r...\n\r\n\rhServer = FREEFILE\n\r\n\rTCP OPEN SERVER PORT 7 AS hServer\n\r\n\rTCP NOTIFY hServer, ACCEPT TO hWnd AS %TCP_ACCEPT\n\r\n\rTCP NOTIFY tells Winsock that it should send the %TCP_ACCEPT message to the window specified by hWnd. Your callback will then include a message handler for the %TCP_ACCEPT message. The lParam&amp; parameter to your callback will tell you what type of notification was sent:\n\r\n\r%TCP_ECHO = %WM_USER + 4094 \' user-defined message value\n\r\n\r...\n\r\n\rCASE %TCP_ACCEPT\n\r\n\r &nbsp;SELECT CASE LO(WORD, lParam&amp;)\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;\'* An ACCEPT notification was sent\n\r\n\r &nbsp; &nbsp;CASE %FD_ACCEPT\n\r\n\r &nbsp; &nbsp; &nbsp;hEcho = FREEFILE\n\r\n\r &nbsp; &nbsp; &nbsp;TCP ACCEPT hServer AS hEcho\n\r\n\r &nbsp; &nbsp; &nbsp;TCP NOTIFY hEcho, RECV CLOSE TO hWnd AS %TCP_ECHO\n\r\n\r&nbsp;\n\r\n\r &nbsp;.\n\r\n\r &nbsp;. \'other notification code goes here\n\r\n\r &nbsp;.\n\r\n\r &nbsp;END SELECT\n\r\n\rOnce your code receives the ACCEPT notification, it uses the TCP ACCEPT statement to &quot;close&quot; the socket. A new socket is created for the actual communication with the client. The original socket (hServer) is used strictly to process ACCEPT notifications only. TCP NOTIFY is then used with the new socket handle to process RECV and CLOSE notifications.\n\r\n\rWhen the Echo Client sends its message to your server, a RECV notification will be sent to your window. Your code can then log the incoming message, and send it right back to the client. When the CLOSE notification is received, you can close the socket:\n\r\n\rCASE %TCP_ECHO\n\r\n\r &nbsp;SELECT CASE LO(WORD, lParam&amp;)\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;CASE %FD_READ\n\r\n\r &nbsp; &nbsp; &nbsp;IF hEcho &lt;&gt; %INVALID_SOCKET THEN\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;TCP RECV hEcho, 1024, buffer\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;TCP SEND hEcho, buffer\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;LogEvent $DQ + Buffer + $DQ\n\r\n\r &nbsp; &nbsp; &nbsp;END IF\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;CASE %FD_CLOSE\n\r\n\r &nbsp; &nbsp; &nbsp;TCP CLOSE hEcho\n\r\n\r &nbsp; &nbsp; &nbsp;hEcho = %INVALID_SOCKET\n\r\n\r&nbsp;\n\r\n\r &nbsp;END SELECT\n\r\n\rTo connect with the Echo Server, our Client simply needs to open a socket at port 7, send a string, and display the string echoed back from the server.\n\r\n\rFUNCTION PBMAIN() AS LONG\n\r\n\r &nbsp;LOCAL hSocket AS LONG\n\r\n\r&nbsp;\n\r\n\r &nbsp;hSocket = FREEFILE\n\r\n\r &nbsp;TCP OPEN PORT 7 AT &quot;&quot; AS hSocket\n\r\n\r &nbsp;IF ERR THEN\n\r\n\r &nbsp; &nbsp;MSGBOX &quot;OPEN Error&quot; + STR$(ERR)\n\r\n\r &nbsp; &nbsp;EXIT FUNCTION\n\r\n\r &nbsp;END IF\n\r\n\r&nbsp;\n\r\n\r &nbsp;IF LEN(COMMAND$) = 0 THEN\n\r\n\r &nbsp; &nbsp;TCP SEND hSocket, &quot;This is a test&quot;\n\r\n\r &nbsp;ELSE\n\r\n\r &nbsp; &nbsp;TCP SEND hSocket, COMMAND$\n\r\n\r &nbsp;END IF\n\r\n\r&nbsp;\n\r\n\r &nbsp;TCP RECV hSocket, 1024, buffer$\n\r\n\r &nbsp;IF ERR THEN\n\r\n\r &nbsp; &nbsp;MSGBOX &quot;RECV Error&quot; + STR$(ERR)\n\r\n\r &nbsp; &nbsp;EXIT FUNCTION\n\r\n\r &nbsp;END IF\n\r\n\r&nbsp;\n\r\n\r &nbsp;MSGBOX buffer$\n\r\n\r&nbsp;\n\r\n\r &nbsp;TCP CLOSE hSocket\n\r\n\rEND FUNCTION\n\r\n\rThe complete Echo Server and Echo Client sample can be found in your PB\\SAMPLES\\INTERNET\\TCP folder.\n\r\n\rFinally, it should be noted that there is no direct correlation between the number of TCP SEND statements executed, compared to the number of %FD_READ messages received. This is because Winsock may concatenate multiple data packets and issue a lesser number of %FD_READ messages in response. Therefore, it is usually necessary to construct your code so that it continues to read data from the incoming data stream until either the returned string is empty, or an error is detected. For example:\n\r\n\rDIM InBuffer AS STRING\n\r\n\r...\n\r\n\r &nbsp;CASE %FD_READ\n\r\n\r &nbsp; &nbsp;InBuffer = &quot;&quot;\n\r\n\r &nbsp; &nbsp;IF hEcho = %INVALID_SOCKET THEN EXIT SELECT\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;DO\n\r\n\r &nbsp; &nbsp; &nbsp;TCP RECV hEcho, 1024, buffer\n\r\n\r &nbsp; &nbsp; &nbsp;IF LEN(buffer) = 0 OR ISTRUE ERR THEN EXIT LOOP\n\r\n\r &nbsp; &nbsp; &nbsp;InBuffer = InBuffer + buffer\n\r\n\r &nbsp; &nbsp; &nbsp;TCP SEND hEcho, buffer\n\r\n\r &nbsp; &nbsp; &nbsp;LogEvent $DQ + Buffer + $DQ\n\r\n\r &nbsp; &nbsp;LOOP\n\r\n\r...\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rTCP and UDP Communications\n\r\n\rSimple Mail Transfer Protocol (SMTP)","An ECHO client and server using TCP","scr\\html_an_echo_client_and_server_using_tcp.htm","                  \n\r\n\rPurpose\n\r\n\rThe AND operator works as both a logical and a bitwise arithmetic operator.\n\r\n\rSyntax\n\r\n\rp AND q\n\r\n\rUsing AND as a logical operator\n\r\n\rAND returns TRUE (non-zero) if (and only if) both its operands are TRUE. The AND truth table looks like this:\n\r\n\rTruth Table\n\r\n\rx\n\r\n\ry\n\r\n\rx AND y\n\r\n\rT\n\r\n\rT\n\r\n\rT\n\r\n\rT\n\r\n\rF\n\r\n\rF\n\r\n\rF\n\r\n\rT\n\r\n\rF\n\r\n\rF\n\r\n\rF\n\r\n\rF\n\r\n\rUsing AND as a bitwise arithmetic operator\n\r\n\rAND masks clear selected bits of an integral-class value without affecting the other bits. For example, to clear the most-significant (leftmost) 2 bits in the integer value &amp;H9700, AND it with &amp;H3FFF. That is, the mask contains all 1s, except for the bit positions you want to force to 0:\n\r\n\r\n\r\n\rSee also\n\r\n\rArithmetic Operators, EQV, IMP, ISFALSE, ISTRUE, NOT, OR, XOR","AND operator","scr\\html_and_operator.htm","                  \n\r\n\rLicense\n\r\n\rThis software is protected by United States copyright law and international treaties. It is licensed for use by one specific person, whose name will be registered with PowerBASIC, Inc., on one computer at a time. It may be moved from one computer to another as long as there is no possibility of it being used on more than one computer at the same time. If this software is used on a network, one licensed copy of the software is required for each person who uses the software. If the licensed product is a compiler, you may distribute the programs you create royalty free. You may not distribute the licensed compiler. If the licensed product includes one or more runtime modules, you may reproduce and distribute them royalty free, provided they are distributed only in conjunction with, and as part of your software program, and provided that they bear your copyright notice or the copyright notice which appears on the PowerBASIC, Inc. disk label. The runtime modules are those files that are required to execute your software program, and which are specifically designated as &quot;runtime modules&quot; in the accompanying PowerBASIC, Inc. documentation. Your use of any of the demonstration or sample programs provided with this product are governed by the notices and restrictions of the respective author or copyright holder. Except as stated above, you may not resell, transfer ownership, barter, donate, rent, lease, lend, or share the licensed software to/with another person or entity. By written request to PowerBASIC, Inc., you may specify a change of licensed user if the replacement user is your employee or family member.\n\r\n\rRestrictions\n\r\n\rYou may use the licensed software to create and maintain any form of target computer program for your own use. However, if you publish any target computer program, freeware or commercial, which is a tool for programmers (programming language, compiler, interpreter, programmer\'s library, etc.), you may not export a wrapper for any PowerBASIC command which allows that command to be used in other programming languages. For example, you may write and publish your own target program to sort data in an array. But you may not publish a target program which exports the PowerBASIC ARRAY SORT Command for use with a programming language other than PowerBASIC.\n\r\n\rLimited Warranty\n\r\n\rPowerBASIC, Inc. warrants that the physical disks and physical documentation are free of defects in workmanship and materials for a period of sixty days from the date of purchase. If the disks or documentation are found to be defective within the warranty period, PowerBASIC, Inc. will replace the defective items at no cost to you. The entire liability of this warranty is limited to replacement and shall not, under any circumstances, encompass any other damages. PowerBASIC, Inc. specifically disclaims all other warranties, expressed or implied, including, but not limited to, any implied warranty of merchantability or fitness for a particular purpose.\n\r\n\rGoverning Law\n\r\n\rThis license and limited warranty shall be construed, interpreted, and governed by the laws of the State of Florida, USA, and any action hereunder shall be brought only in Florida. If any provision is found invalid or unenforceable, the balance of this license and limited warranty shall remain valid and enforceable. Use, duplication, or disclosure by the U.S. Government of the computer software and documentation in this product shall be subject to the restricted rights under DFARS 52.227-7013 applicable to commercial computer software. All rights not specifically granted herein are reserved by PowerBASIC, Inc.","License Agreement","scr\\html_appendix_a_license_agreement.htm","                  \n\r\n\rInternally, the DOS and 32-bit Windows operating systems are very different. DOS applications run in 16-bit &quot;Real Mode&quot;, which means that the largest single data object is 64 Kilobytes (the largest 16-bit value is 65535). And because of the way &quot;memory segmentation&quot; works, the total addressing space available in &quot;Real Mode&quot; is a little over 1 Megabyte. Since the CPU is running in 16-bit mode (Real mode), numeric operations are fastest when variables are 16-bits (Integers and Words).\n\r\n\rIn contrast, 32-bit Windows runs in &quot;Protected Mode&quot;, and the largest single data object is two Gigabytes (the largest 32-bit value is actually four Gigabytes, but the operating system reserves half of that for itself). Because the CPU is running in 32-bit mode (Protected mode), numeric operations are fastest when variables are 32-bits (Long-integers and Double-words).\n\r\n\rUse 32-bit Variables  \n\r\n\rAs you move your DOS code into PowerBASIC, you should replace all &quot;Integer&quot; and &quot;Word&quot; variable types with Long-integers and Double-words respectively - particularly in FOR/NEXT loops and integral-class math calculations. It actually takes the CPU longer to perform a calculation on a 2-byte Integer than it does with a 4-byte Long-integer, and it takes even longer with single byte variables.\n\r\n\rUse Register Variables  \n\r\n\rRegister variables are variables that are stored directly in specific CPU registers, rather than in application memory. Since data in a CPU register can be accessed much faster, and with less code, Register variables are valuable optimization tools.\n\r\n\rRegister variables are always local to the Sub, Function, Method, or Property where they appear. In the current version of PowerBASIC, there may be up to two integral-class Register variables (Word/Dword/Integer/Long), and up to four Extended-precision floats. It is possible that future versions of the compiler will change these limits, so you may declare an unlimited number of them. Any &quot;extra&quot; Register variables are automatically reclassified as locals.\n\r\n\rThe REGISTER statement allows you to choose which variables will be classified as Register variables. If you do not make the choice in a particular procedure, the compiler will attempt to choose for you. By default, the compiler will always assign the first two integral-class local variables available. Extended-precision float variables will be automatically assigned only in functions that contain no external function calls.\n\r\n\rintegral class Register variables are most efficient for variables that are updated or used often, such as For/Next loop counter variables, and variables that are used repeatedly as array indexes. Floating-point Register variables should generally be chosen with a bit more caution, since the compiler must generate code to save and restore them to conventional memory around each call to a procedure. In some rather rare cases, it is possible that floating-point Register variables could actually reduce execution speed. However, they are extremely valuable with intensive floating-point calculations and in functions that have few references to other procedures.\n\r\n\rDue to the design of FPUs (floating point units), and the instruction sets available, the first float register variable declared in your program has far more optimization possibilities than the others do. Use care in choosing the variable which is used most within floating-point expressions (that is, on the right side of the \'=\' assignment operator), in order to gain the greatest advantage in execution speed. Also, remember it is typically valuable to assign floating-point numeric constants to Register variables when they are used in repetitive or intensive calculations.\n\r\n\rYou must use care with Inline Assembler floating-point opcodes in procedures that enable Register variables. Floating-point Register variables may occupy up to four of the FPU registers, so you must limit your use of the x87 registers to the remaining four. Further, floating-point Register variables may never be referenced by name from Inline Assembler code, as the compiler cannot always track the register locations with absolute certainty.\n\r\n\rRegister variables are preserved when a call to an external DLL or API function is made. Register variables are automatically thread-safe too.\n\r\n\rBecause Register variables are stored within the CPU, it is not possible to use VARPTR on a register variable. When passing a register variable to a procedure BYREF, the compiler temporarily converts the register variable into a memory variable, and reloads the register variable upon return from the procedure call. The overhead that this adds is insignificant.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rThe Inline Assembler","Optimizing your code","scr\\html_appendix_c_optimizing_your_code.htm","                  &#183;GUID: &nbsp;This is a &quot;Globally Unique Identifier&quot;, a very large number which is used to uniquely identify every interface, every class, and every COM application or library which exists anywhere in the world. GUID\'s identify the specific components, wherever and whenever they may be used. A GUID is a 16-byte (128-bit) value, which could be represented as an integral value or a string. This 128-bit item is large enough to represent all the possible values, anywhere in the world. The PowerBASIC GUID$() function (or a hot-key in the PowerBASIC IDE) can generate a random GUID which is statistically guaranteed to be unique from any other generated GUID. Each of these identifying GUID\'s may be assigned by the programmer, or they will be randomly assigned by the PowerBASIC compiler. When a GUID is written in text, it takes the form: {00CC0098-0000-0000-0000-0000000000FF}.&#183;DIRECT INTERFACE: &nbsp;This is the most efficient form of interface. When you call a particular METHOD or  PROPERTY, the compiler simply performs an indirect jump to the correct entry point listed in the virtual function table (VFT or VTBL). This is just as fast as calling a standard Sub or Function, and is the default access method used by PowerBASIC.&#183;DISPATCH INTERFACE: &nbsp;This is a slow form of interface, originally introduced as a part of Microsoft Visual Basic. When you use DISPATCH, the compiler actually passes the name of the METHOD you wish to execute as a text string. The parameters can also be passed in the same way. The object must then look up the names, and decide which METHOD to execute, and which parameters to use, based upon the text strings provided. This is a very slow process. Many scripting languages still use DISPATCH as their sole method of operation, so continued support is necessary.&#183;DUAL INTERFACE: &nbsp;This is a combination of a Direct Interface and a Dispatch Interface. This most flexible form allows either option to be used, depending upon how the calling application is implemented.&#183;AUTOMATION: &nbsp;This is a special calling convention, defined by MS later in the evolution of COM and objects. An Automation object is simply one which adheres to the rules for Automation COM Objects. It may offer just a direct interface, just a Dispatch interface, or both of them (DUAL). It should be noted that some programmers use the word AUTOMATION to mean DISPATCH. Even though that\'s not correct, you should keep the possibility in mind whenever you encounter the term. Automation Methods must use parameters, return values, and assignment variables which are AUTOMATION compatible: BYTE, WORD, DWORD, INTEGER, LONG, QUAD, SINGLE, DOUBLE, CURRENCY, OBJECT, STRING, WSTRING, and VARIANT. A User Defined Type used as a return value or parameter will be converted to a BYVAL DWORD. All Automation Methods return a hidden result code which is called the hResult. This is not really a handle, as the name suggests, but a result code to report the success or failure of a call to a METHOD or PROPERTY.&#183;IUNKNOWN: &nbsp;This is the name of a special interface which is the basis for every object. It has three methods, which are always defined as the first three methods in every interface. These 3 methods are used by compilers (PowerBASIC or others) to look up other interfaces on the object, and to keep track of usage of this object. While IUNKNOWN is mandatory for every object, you won\'t ever need to reference it directly. PowerBASIC handles all those messy details automatically.&#183;OBJECT REFERENCE: &nbsp;This is a reference (a pointer) to an object, which is the only way objects are used. In PowerBASIC, an object variable initially contains NOTHING. When you create an object, or duplicate one, a reference to that object is placed in an object variable by the compiler. That is, a pointer to the object is automatically inserted in the object variable. It is now considered to contain an OBJECT REFERENCE until such time as the reference is deleted or set to NOTHING.&#183;COMPONENT: &nbsp;An object that encapsulates code and data, providing a set of publicly available services.&#183;MONIKER: &nbsp;An object that implements the IMoniker interface. A moniker acts as a name that uniquely identifies a COM object. In the same way that a path identifies a file in the file system, a moniker identifies a COM object in the directory namespace.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rWhat is an object, anyway?\n\r\n\rWhat are the parts of an object?\n\r\n\rWhat does a Class look like?\n\r\n\rWhat is a Base Class?","Are there other important \"Buzz-Words\"?","scr\\html_are_there_other_important__buzz_words__.htm","                  \n\r\n\rArithmetic operators perform normal mathematical operations. Several of these operators merit a word of explanation. The backslash (\\) represents integral division. Integral division rounds its operands to an integral value, to produce a truncated quotient with no remainder. For example, 5 \\ 2 evaluates to 2, and 9 \\ 10 evaluates to 0. Integral division is also faster than floating-point division when using integral-class variables or expressions.\n\r\n\rThe remainder of an integral division can be determined with the MOD (modulo) operator (MOD is valid for all numeric types). MOD is similar to integer division except that it returns the remainder of the division rather than the quotient. For example, 5 MOD 2 returns the value 1, and 9 MOD 10 returns the value 9.\n\r\n\rThe ISTRUE operator returns TRUE only if its operand is TRUE (non-zero). ISTRUE is guaranteed to return -1 as its TRUE value, whereas the operators can return any non-zero value.\n\r\n\rThe ISFALSE operator returns TRUE only if its operand is FALSE (zero). ISFALSE is guaranteed to return -1 as its TRUE value, where the operators can return any non-zero value.\n\r\n\rPowerBASIC arithmetic operators\n\r\n\rOperator\n\r\n\rAction\n\r\n\rExample\n\r\n\r^\n\r\n\rExponentiation\n\r\n\r10^4\n\r\n\r-\n\r\n\rNegation\n\r\n\r-16\n\r\n\r*\n\r\n\rMultiplication\n\r\n\r45 * 19\n\r\n\r/\n\r\n\rFloating-point division\n\r\n\r45 / 19\n\r\n\r\\\n\r\n\rIntegral division\n\r\n\r45 \\ 19\n\r\n\r+\n\r\n\rAdd\n\r\n\r45 + 19\n\r\n\r-\n\r\n\rSubtract\n\r\n\r45 - 19\n\r\n\rMOD\n\r\n\rModulo\n\r\n\r45 MOD 19\n\r\n\rISFALSE\n\r\n\rBoolean False\n\r\n\rISFALSE 45\n\r\n\rISTRUE\n\r\n\rBoolean True\n\r\n\rISTRUE 19\n\r\n\rNOT, AND,\n\r\n\rOR, XOR,\n\r\n\rEQV, IMP\n\r\n\rBit manipulation operations\n\r\n\rNOT 0, 45 AND 19\n\r\n\r45 OR 19, 45 XOR 19\n\r\n\r45 EQV 19, 45 IMP 19\n\r\n\r&nbsp;\n\r\n\rNote: PowerBASIC does not trap numeric overflow or underflow errors in equation and expression evaluation. Please refer to the topics Errors and Error Trapping for more information.\n\r\n\rIt is recommended that this table be read in conjunction with the Mathematical Order of Operator Precedence table, and the effects that operator precedence has on the evaluation of numeric expressions.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rRelational Operators\n\r\n\rOperator Precedence\n\r\n\rLET statement","Arithmetic Operators","scr\\html_arithmetic_operators.htm","                  \n\r\n\rPurpose\n\r\n\rAllow the assignment of a number of values to successive elements of an array.\n\r\n\rSyntax\n\r\n\rARRAY ASSIGN array() = param1 [,param2] [,]\n\r\n\rRemarks\n\r\n\rARRAY ASSIGN allows the assignment of a number of values to successive elements of an array. The assignment always starts with the first array element, and continues sequentially as the elements appear in memory. The values to be assigned must match the array type, and may be literals, variables, or expressions. ARRAY ASSIGN cannot be used on an array of Interfaces.\n\r\n\rSee also\n\r\n\rARRAY &nbsp;DELETE, ARRAY INSERT, ARRAY SCAN, ARRAY SORT, DIM, LBOUND, PowerArray, REDIM, UBOUND\n\r\n\rExample\n\r\n\rARRAY ASSIGN x&amp;() = 1,2,3,4,5,6,7,8,9,10","ARRAY ASSIGN statement","scr\\html_array_assign_statement.htm","                  \n\r\n\rIt is often useful to treat a set of variables as a group. This lets you perform repetitive operations more easily. An array is a group of string or numeric data sharing the same variable name. The individual values that make up an array are called elements. An element of an array can be used in a statement or expression wherever you would use a regular string or numeric variable. In other words, each element of an array is itself a variable.\n\r\n\rPowerBASIC provides several statements that perform operations on an array as a whole, allowing you to sort its contents, scan its contents for data that matches a certain condition, and insert data into or delete data from the existing structure.\n\r\n\rYou can think of an array as a row of boxes, numbered from zero to a predetermined number: four, in the example figure below. Each box holds a distinct value, which may or may not differ from the values in the other boxes. The boxes and their numbers are represented by parentheses surrounding a number; for example, item%(3) represents box number three of the array item%. Thus, if the value held within box number 3 is 1952, the statement total%=item%(3) would place the value 1952 into the variable total%.\n\r\n\r\n\r\n\rDimensioning a dynamic array with DIM or REDIM also clears each element, unless the PRESERVE option is present. Each element of each numeric array is set to zero; string arrays are set to the null string (&quot;&quot;, length zero). Declaring the name and type of an array, as well as the number and organization of its elements, is performed by the DIM statement. For example:\n\r\n\rDIM payments(55) AS CURRENCYX\n\r\n\rcreates an array variable payments, consisting of 56 Extended-currency elements, numbered 0 through 55. Array payments and an Extended-currency variable also named payments are separate variables. If this is confusing, you\'ll understand why we suggest that you use different variable names.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rSubscripts\n\r\n\rString arrays\n\r\n\rMultidimensional arrays\n\r\n\rArray storage requirements\n\r\n\rInternal representations of arrays\n\r\n\rArrays within User-Defined Types\n\r\n\rArray operations\n\r\n\rPOWERARRAY Object","Array Data Types","scr\\html_array_data_types.htm","                  \n\r\n\rPurpose\n\r\n\rDelete a single item from a given array.\n\r\n\rSyntax\n\r\n\rARRAY DELETE array([index]) [FOR count] [, expression]\n\r\n\rRemarks\n\r\n\rARRAY DELETE deletes the data stored at the nominated element in array, an n-dimensional array. You can specify the index of the element which is to have its data deleted, how many elements (count) are to be automatically shifted down by one position, and what data value to give the last element after the rest of the elements have been shifted (expression).\n\r\n\rAll of these parameters are optional. If index is not specified, the data stored in the element at the beginning of the array is deleted. If expression is not present, the last element that the data is shifted out of will contain zero if array is a numeric array, or an empty string if array is a string array. If a shift count is given, when shifting the rest of the array to eliminate the element, only count elements will be shifted.\n\r\n\rBy default, ARRAY DELETE throws away the data at the element index of array, shifting the data in the appropriate portion of the array to cover the old element:\n\r\n\rDIM A(1 TO 4) AS LONG\n\r\n\rARRAY DELETE A(2), 17&amp;\n\r\n\rmakes A(2)=A(3), A(3)=A(4), and A(4)=17. The original value of A(1) remains in place. Use count to &quot;protect&quot; a portion of the array from the shift:\n\r\n\rDIM A(1 TO 4) AS LONG\n\r\n\rARRAY DELETE A(2) FOR 2, 17&amp;\n\r\n\rmakes A(2)=A(3) and A(3)=17 because you told it to shift only 2 elements. The original values of A(4) and A(1) remain in place.\n\r\n\rDELETE with multi-dimensional arrays\n\r\n\rcount can also be used with a multi-dimensional array (stored in linear column-major order; see ARRAY SORT), to prevent shifting element data from one dimension into another dimension, thus preserving the organization of the array. For example:\n\r\n\rDIM A(0 TO 1,0 TO 1) AS INTEGER\n\r\n\rA(0,0)=0\n\r\n\rA(1,0)=100\n\r\n\rA(0,1)=200\n\r\n\rA(1,1)=300\n\r\n\rARRAY DELETE A(0,0) FOR 2, 17%\n\r\n\rmakes A(0,0)=100 and A(1,0)=17. The original values of A(0,1) and A(1,1) remain in place since you told it to shift only 2 elements. Without count:\n\r\n\rARRAY DELETE A(0,0), 17%\n\r\n\rmakes A(0,0)=100, A(1,0)=200, A(0,1)=300, and A(1,1)=17. The original value of A(0,0) is lost.\n\r\n\rRestrictions\n\r\n\rARRAY DELETE cannot be used on arrays within UDT structures. However, ARRAY DELETE can be used with arrays of UDT structures - simply treat them as if they were an array of fixed-length strings.\n\r\n\rTo use ARRAY DELETE on an embedded UDT array, use DIM..AT to dimension a regular array (of the same type) directly &quot;over the top&quot; of the UDT array, and use ARRAY DELETE on that array. For example:\n\r\n\rTYPE SalesType\n\r\n\r &nbsp;OrderNum AS LONG\n\r\n\r &nbsp;PartNumber(1 TO 20) AS STRING * 20\n\r\n\rEND TYPE\n\r\n\r[statements]\n\r\n\rDIM Sales AS SalesType\n\r\n\r[statements]\n\r\n\rDIM Temp(1 TO 20) AS STRING * 20 AT VARPTR(Sales.Partnumber(1))\n\r\n\rARRAY DELETE Temp(5), &quot;string&quot;\n\r\n\rERASE Temp()\n\r\n\rSee also\n\r\n\rARRAY ASSIGN, ARRAY INSERT, ARRAY SCAN, ARRAY SORT, DIM, LBOUND, PowerArray, REDIM, UBOUND\n\r\n\rExample\n\r\n\rMakes A(2)=3 and A(3)=2.5. A(0) and A(1) remain in place:\n\r\n\rDIM A(0 TO 3) AS CUX\n\r\n\rA(0)=0\n\r\n\rA(1)=1\n\r\n\rA(2)=2\n\r\n\rA(3)=3\n\r\n\rARRAY DELETE A(2), 2.5@@\n\r\n\rMakes A(0)=2, A(1)=3, and A(2)=0. The original value of A(0) is lost:\n\r\n\rDIM A(0 TO 2) AS EXT\n\r\n\rA(0)=1\n\r\n\rA(1)=2\n\r\n\rA(2)=3\n\r\n\rARRAY DELETE A()","ARRAY DELETE statement","scr\\html_array_delete_statement.htm","                  \n\r\n\rPurpose\n\r\n\rInsert a single item into a given array.\n\r\n\rSyntax\n\r\n\rARRAY INSERT array([index]) [FOR count] [, expression]\n\r\n\rRemarks\n\r\n\rARRAY INSERT inserts a single data item into array, an n-dimensional array. You can specify the index at which the new element data is to be inserted, how many elements (count) are to be shifted up by one position to make room for the new element data, and what data value to give the new element (expression).\n\r\n\rAll of these parameters are optional. If index is not specified, the element data is inserted at the beginning of the array &nbsp;If expression is not present, the new element will contain zero if array is a numeric array, or an empty string if array is a string array.\n\r\n\rIf a shift count is given, when shifting the rest of the array to make way for the new element data, only count elements will be shifted.\n\r\n\rBy default, ARRAY INSERT throws away the data in last element of array, then shifts the appropriate portion of the array to make way for the new element data:\n\r\n\rDIM A(1 TO 4) AS LONG\n\r\n\rARRAY INSERT A(2), 17\n\r\n\rmakes A(4)=A(3), A(3)=A(2), and A(2)=17. The original value of A(4) is lost, while the original value of A(1) remains in place. Use count to &quot;protect&quot; a portion of the array from the shift:\n\r\n\rDIM A(1 TO 4) AS LONG\n\r\n\rARRAY INSERT A(2) FOR 2, 17\n\r\n\rmakes A(3)=A(2) and A(2)=17 because you told it to shift only 2 elements. The original values of A(4) and A(1) remain in place.\n\r\n\rINSERT with multi-dimensional arrays\n\r\n\rcount can also be used with a multi-dimensional array (stored in linear column-major order; see ARRAY SORT), to prevent shifting &nbsp;data from one dimension into another dimension, and thus preserving the organization of the array. For example:\n\r\n\rDIM A(0 TO 1,0 TO 1) AS SINGLE\n\r\n\rA(0,0)=0\n\r\n\rA(1,0)=100\n\r\n\rA(0,1)=200\n\r\n\rA(1,1)=300\n\r\n\rARRAY INSERT A(0,0) FOR 2, 17\n\r\n\rmakes A(0,0)=17 and A(1,0)=0. The original values of A(0,1) and A(1,1) remain in place since you told it to shift only 2 elements. Without count:\n\r\n\rARRAY INSERT A(0,0), 17\n\r\n\rmakes A(0,0)=17, A(1,0)=0, A(0,1)=100, and A(1,1)=200. The original value of A(1,1) is lost.\n\r\n\rRestrictions\n\r\n\rARRAY INSERT cannot be used on arrays within UDT structures or on an array of Interfaces. However, ARRAY INSERT can be used with arrays of UDT structures - simply treat them as if they were an array of fixed-length strings.\n\r\n\rTo use ARRAY INSERT on an embedded UDT array, use DIM..AT to dimension a regular array (of the same type) directly &quot;over the top&quot; of the UDT array, and use ARRAY INSERT on that array. For example:\n\r\n\rTYPE SalesType\n\r\n\r &nbsp;OrderNum AS LONG\n\r\n\r &nbsp;PartNumber(1 TO 20) AS STRING * 20\n\r\n\rEND TYPE\n\r\n\r[statements]\n\r\n\rDIM Sales AS SalesType\n\r\n\r[statements]\n\r\n\rDIM Temp(1 TO 20) AS STRING * 20 AT VARPTR(Sales.Partnumber(1))\n\r\n\rARRAY INSERT Temp(5), &quot;string&quot;\n\r\n\rERASE Temp()\n\r\n\rSee also\n\r\n\rARRAY ASSIGN, ARRAY DELETE, ARRAY SCAN, ARRAY SORT, DIM, LBOUND, PowerArray, REDIM, UBOUND\n\r\n\rExample\n\r\n\rMakes A(3)=2.5 and A(4)=3. A(0), A(1), and A(2) remain in place:\n\r\n\rDIM A(0 TO 4) AS DOUBLE\n\r\n\rA(0)=0\n\r\n\rA(1)=1\n\r\n\rA(2)=2\n\r\n\rA(3)=3\n\r\n\rARRAY INSERT A(3), 2.5#\n\r\n\rMakes  A(0)=0, A(1)=1, and A(2)=2. The original value of A(2) is lost:\n\r\n\rDIM A(0 TO 2) AS QUAD\n\r\n\rA(0)=1\n\r\n\rA(1)=2\n\r\n\rA(2)=3\n\r\n\rARRAY INSERT A()","ARRAY INSERT statement","scr\\html_array_insert_statement.htm","                  \n\r\n\rThe following functions can be used to manipulate and manage arrays: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  \n\r\n\r#DEBUG ERROR\n\r\n\rControl generation of error checking code\n\r\n\r#DIM\n\r\n\rSpecify if variables must be declared before use\n\r\n\rARRAY ASSIGN\n\r\n\rAssign a number of values to successive elements of an array\n\r\n\rARRAY DELETE\n\r\n\rDelete a single item from a given array\n\r\n\rARRAY INSERT\n\r\n\rInsert a single item into a given array\n\r\n\rARRAY SCAN\n\r\n\rScan all or part of an array for a given value\n\r\n\rARRAY SORT\n\r\n\rSort all or part of a given array\n\r\n\rARRAYATTR\n\r\n\rReturn descriptive attributes of a given array\n\r\n\rBIT CALC\n\r\n\rSet or reset a bit in an implied bit-array\n\r\n\rBIT\n\r\n\rReturn the value of a particular bit in an implied bit-array\n\r\n\rBIT\n\r\n\rManipulate individual bits of an implied bit-array\n\r\n\rDATA\n\r\n\rDeclare an array of constants to be read by READ$\n\r\n\rDATACOUNT\n\r\n\rReturn the total count of the number of local data items\n\r\n\rDIM\n\r\n\rDeclare and dimension arrays, scalar variables, and pointers\n\r\n\rERASE\n\r\n\rDeallocate array memory\n\r\n\rFILESCAN\n\r\n\rRapidly scan an open file, before loading into an array with GET\n\r\n\rGET\n\r\n\rRead a complete array from a binary file\n\r\n\rIPowerArray.ARRAYBASE\n\r\n\rReturns the address of the first element of the array.\n\r\n\rIPowerArray.ARRAYDESC\n\r\n\rReturns the address of the SAFEARRAY descriptor.\n\r\n\rIPowerArray.ARRAYINFO &lt;Get&gt;\n\r\n\rRetrieves the info string, if one is present.\n\r\n\rIPowerArray.ARRAYINFO &lt;Set&gt;\n\r\n\rAssigns the info string.\n\r\n\rIPowerArray.CLONE\n\r\n\rAn exact duplicate of the SafeArray is created, and stored in the specified PowerArray object.\n\r\n\rIPowerArray.COPYFROMVARIANT\n\r\n\rAn exact copy is made of the specified SafeArray and stored in this PowerArray object.\n\r\n\rIPowerArray.COPYTOVARIANT\n\r\n\rAn exact copy is made of the SafeArray in this object and stored in the specified Variant.\n\r\n\rIPowerArray.DIM\n\r\n\rDimensions (creates) a new array.\n\r\n\rIPowerArray.ELEMENTPTR\n\r\n\rRetrieves the address of the specified data element.\n\r\n\rIPowerArray.ELEMENTSIZE\n\r\n\rRetrieves the storage size (in bytes) of each data element of the array.\n\r\n\rIPowerArray.ERASE\n\r\n\rDestroys the contained array and empties the object.\n\r\n\rIpowerArray.LBOUND\n\r\n\rRetrieves the lower bound number for the dimension specified.\n\r\n\rIPowerArray.LOCK\n\r\n\rIncrements the lock count of the SAFEARRAY.\n\r\n\rIPowerArray.MOVEFROMVARIANT\n\r\n\rTransfers ownership of the specified SafeArray to the PowerArray object.\n\r\n\rIPowerArray.MOVETOVARIANT\n\r\n\rTransfers ownership of the SafeArray contained in this PowerArray object to a variant parameter.\n\r\n\rIPowerArray.REDIM\n\r\n\rAllows the SafeArray to be erased and re-dimensioned to a new size.\n\r\n\rIPowerArray.REDIMPRESERVE\n\r\n\rAllows the least significant (rightmost) bound to be changed to a new size. The remaining data items in the array are preserved.\n\r\n\rIPowerArray.RESET\n\r\n\rAll elements in the SafeArray are set back to their initial, default value.\n\r\n\rIPowerArray.SUBSCRIPTS\n\r\n\rRetrieves the number of dimensions (subscripts) for this array.\n\r\n\rIPowerArray.UBOUND\n\r\n\rRetrieves the upper bound number for the dimension specified.\n\r\n\rIPowerArray.UNLOCK\n\r\n\rDecrements the lock count of the SAFEARRAY.\n\r\n\rIPowerArray.VALUEGET\n\r\n\rRetrieves the value of the specified array element.\n\r\n\rIPowerArray.VALUESET\n\r\n\rAssigns the specified value to the specified array element.\n\r\n\rIPowerArray.VALUETYPE\n\r\n\rRetrieves the %VT code which describes the data contained in this array.\n\r\n\rJOIN$\n\r\n\rReturn a string consisting of all of the strings in a string array\n\r\n\rLBOUND\n\r\n\rReturn the lowest subscript of an array\'s specific dimension\n\r\n\rLET\n\r\n\rAssign a Variant to an array or an array to a Variant\n\r\n\rLINE INPUT#\n\r\n\rRead line(s) from a sequential file into a string variable or array\n\r\n\rMAT\n\r\n\rMatrix calculations on numeric arrays\n\r\n\rPARSE\n\r\n\rParse a string and extract all delimited fields into an array\n\r\n\rPRINT#\n\r\n\rWrite a complete array to a sequential file\n\r\n\rPUT\n\r\n\rWrite a complete array to a binary file\n\r\n\rREAD$\n\r\n\rRetrieve string data from a local DATA list\n\r\n\rREDIM\n\r\n\rDeclare dynamic arrays, allocate, reallocate, deallocate memory\n\r\n\rRESET\n\r\n\rSet an array subscript or an entire array to zero or null/empty\n\r\n\rUBOUND\n\r\n\rReturn the highest subscript of an array\'s specific dimension","Array Operations","scr\\html_array_operations.htm","                  \n\r\n\rPurpose\n\r\n\rScan all or part of an array for a given value.\n\r\n\rSyntax\n\r\n\rNumeric array:\n\r\n\rARRAY SCAN array([index]) [FOR count], expression, TO lvar&amp;\n\r\n\rString arrays:\n\r\n\rARRAY SCAN array ([index]) [FOR count] [, FROM startChar TO endChar] [, COLLATE {UCASE |\n\r\n\r &nbsp;  cstring}], expression, TO lvar&amp;\n\r\n\rRemarks\n\r\n\rARRAY SCAN scans all or part of array, an n-dimension array, for the first element that satisfies expression. expression consists of a relational operator (=, &gt;, &lt;, &lt;&gt;, &gt;=, =&gt;, &lt;=, =&lt;) followed by an expression of the same data type as array. The relative index of the first match is stored in lvar&amp;, which must be a Long-integer variable:\n\r\n\rARRAY SCAN A&amp;(), &gt; 5, TO I&amp;\n\r\n\rThis line of code identifies the relative index of the first element of array A&amp;() that is greater than 5, and stores the relative index in I&amp;. The match index ranges from 1 to the last element of the scan + 1.\n\r\n\rSince it is a relative index:\n\r\n\rDIM A(1 TO 10) AS SINGLE\n\r\n\rARRAY SCAN A(), &gt; 17.42!, TO I&amp;\n\r\n\rwill store 2 in I&amp; if A(2) &gt; 17.42, but:\n\r\n\rDIM A(5 TO 20) AS SINGLE\n\r\n\rARRAY SCAN A(), &gt; 17.42!, TO lvar&amp;\n\r\n\rwill store 2, not 6, in lvar&amp; if A(6) &gt; 17.42.\n\r\n\rIf none of the scanned elements satisfy expression, zero will be stored in lvar&amp;.\n\r\n\rTogether, index and count specify the portion of array to be scanned. index specifies the element at which the scan is to begin, while count specifies the number of consecutive elements to be scanned. If index is not specified, the scan begins at the first element of array. If count is not specified, the array is scanned from element index to the last element of array. If neither is specified, the entire array is scanned:\n\r\n\rDIM A&amp;(1 TO 100)\n\r\n\rARRAY SCAN A&amp;(5), =1, TO I&amp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\'scans 5..100\n\r\n\rARRAY SCAN A&amp;() FOR 10, =1, TO I&amp; &nbsp; &nbsp;\'scans 1..10\n\r\n\rARRAY SCAN A&amp;(10) FOR 20, =1, TO I&amp; &nbsp;\'scans 10..29\n\r\n\rARRAY SCAN A&amp;(), =1, TO I&amp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \'scans 1..100\n\r\n\rScanning a string array\n\r\n\rWhen scanning a string array, COLLATE UCASE treats all lowercase letters as uppercase during the scan (for example, element &quot;Bob&quot; would satisfy the condition = &quot;BOB&quot;):\n\r\n\rARRAY SCAN A$(), COLLATE UCASE, = &quot;BOB&quot;, TO I&amp;\n\r\n\r\' scans A$() for &quot;BOB&quot;; all letters treated as\n\r\n\r\' uppercase\n\r\n\rCOLLATE string is used to specify a non-standard scanning order. cstring must contain exactly 256 characters, in the order in which they should be compared, from lowest to highest. For example, the normal ascending ASCII scan order (where &quot;A&quot; is considered less than &quot;B&quot;, etc.) would be described by a string containing ASCII codes 0 through 255 in order:\n\r\n\rC$ = CHR$(0 TO 255)\n\r\n\rARRAY SCAN A$(), COLLATE C$, &gt; &quot;BOB&quot;, TO I&amp;\n\r\n\rThe normal descending ASCII scan order would be described by a string containing the reverse of the above:\n\r\n\rC$ = STRREVERSE$(CHR$(0 TO 255))\n\r\n\rARRAY SCAN A$(), COLLATE C$, &gt; &quot;BOB&quot;, TO I&amp;\n\r\n\rThe COLLATE string option is provided as a flexible means with which to specify a descending scan, or to specify the scanning order for strings containing international characters or other special symbols.\n\r\n\rSee ARRAY SORT for more information on building collating strings.\n\r\n\rWhen scanning a string array, all characters of each element of the array are normally considered when performing comparisons. To limit the comparison to a specific subset of characters, use FROM to specify the startChar position, and TO to specify the endChar position that ARRAY SCAN will consider within each array element. For example, you could scan based on the zip code contained in the last 5 characters of a 40-character address string:\n\r\n\rARRAY SCAN A$(), = &quot;90210&quot;, TO I&amp;\n\r\n\r\' considers all characters when scanning for &quot;90210&quot;\n\r\n\r&nbsp;\n\r\n\rARRAY SCAN A$(), FROM 36 TO 40, = &quot;90210&quot;, TO I&amp;\n\r\n\r\' considers positions 36..40 only when scanning\n\r\n\rScanning a multi-dimensional array\n\r\n\rWhen scanning a multi-dimensional array, the array is treated as a single-dimension array containing all of the elements of the multi-dimensional array, in linear column-major order. That is, all elements where all dimensions (except the first), are held at their minimum bounds, will come first in memory. These are immediately followed by the elements where the second dimension is set to its next consecutive index value, etc.\n\r\n\rFor example, the elements of a two-dimensional array (DIM A(0 TO n, 0 TO x)) would be stored in consecutive memory locations as follows:\n\r\n\rA(0,0), A(1,0), , A(n,0) \' The first n+1 elements,\n\r\n\rA(0,1), A(1,1), , A(n,1) \' The next n+1 elements,\n\r\n\r[statements] &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' Subsequent elements,\n\r\n\rA(0,x), A(1,x), , A(n,x) \' The last n+1 statements.\n\r\n\ror more clearly:\n\r\n\r &nbsp; A(0,0), A(1,0), A(n,0), A(0,1), A(1,1), A(n,1), A(0,x),  \n\r\n\r &nbsp; A(1,x) , A(n,x)\n\r\n\rIn this case, ARRAY SCAN A(0,0) FOR n+1, &gt;5, TO I&amp; would scan only elements (0,0)...(n,0), while ARRAY SCAN A(0,0), &gt;5, TO I&amp; would scan the entire array: elements (0,0)...(n,x). As mentioned earlier, since ARRAY SCAN records the relative index of the matched element, ARRAY SCAN A(0,0), &gt;5, TO I&amp; would store 2 in I&amp; if A(1,0) &gt; 5.\n\r\n\rOptions\n\r\n\rThe options for ARRAY SCAN can be specified in any order, as long as the FOR option, if present, directly follows the closing parenthesis of the name of array.\n\r\n\rRestrictions\n\r\n\rARRAY SCAN cannot be used on arrays within UDT structures or on an array of Interfaces. However, ARRAY SCAN can be used with arrays of UDT structures - simply treat them as if they were an array of fixed-length strings.\n\r\n\rTo use ARRAY SCAN on an embedded UDT array, use DIM..AT to dimension a regular array (of the same type) directly &quot;over the top&quot; of the UDT array, and use ARRAY SCAN on that array. For example:\n\r\n\rTYPE SalesType\n\r\n\r &nbsp;OrderNum AS LONG\n\r\n\r &nbsp;PartNumber(1 TO 20) AS STRING * 20\n\r\n\rEND TYPE\n\r\n\r[statements]\n\r\n\rDIM Sales AS SalesType\n\r\n\r[statements]\n\r\n\rDIM Temp(1 TO 20) AS STRING * 20 AT VARPTR(Sales.Partnumber(1))\n\r\n\rARRAY SCAN Temp(), FROM 1 TO LEN(Search$), = Search$, TO lResult&amp;\n\r\n\rERASE Temp()\n\r\n\rSee also\n\r\n\rARRAY ASSIGN, ARRAY DELETE, ARRAY INSERT, ARRAY SORT, DIM, LBOUND, PowerArray, REDIM, UBOUND\n\r\n\rExample\n\r\n\rARRAY SCAN A&amp;(5) FOR 10, &gt; 64000&amp;, TO B&amp;\n\r\n\rScans elements 5 through 14 of array A&amp;, looking for the first element whose value is &gt; 64000, and stores the relative index of that element in B&amp;.\n\r\n\rARRAY SCAN A$(5) FOR 10,FROM 16 TO 25,COLLATE C$, = D$, TO B&amp;\n\r\n\rScans elements 5 through 14 of array A$, looking only at characters 16 to 25 of each element, using the order specified by collating string C$, looking for the first element whose value is equal to D$, and stores the relative index of that element in B&amp;.","ARRAY SCAN statement","scr\\html_array_scan_statement.htm","                  \n\r\n\rPurpose\n\r\n\rSort all or part of a given array.\n\r\n\rSyntax\n\r\n\rNumeric array:\n\r\n\rARRAY SORT darray([index]) [FOR count] [,TAGARRAY tarray()] [,{ASCEND | DESCEND}]\n\r\n\rString array:\n\r\n\rARRAY SORT dArray([index]) [FOR count] [,FROM startChar TO endChar] [,COLLATE {UCASE |\n\r\n\r &nbsp;  cstring}] [,TAGARRAY tarray()] [,{ASCEND | DESCEND}]\n\r\n\rCustom sort array:\n\r\n\rARRAY SORT darray([index]) [FOR count] [,TAGARRAY tarray()] ,CALL custfunc()\n\r\n\rRemarks\n\r\n\rARRAY SORT sorts all or part of darray, an n-dimensional array, in ascending or descending order. tarray is a tag-along array whose elements are swapped in the same order as those in darray as the sort proceeds (you could sort an array of names and have an array of corresponding addresses tag along, for example). tarray must have at least as many elements as darray, since corresponding elements of tarray will be swapped during the sort.\n\r\n\rNote that tarray does not have to be of the same type as darray. For example, you could have a numeric array containing account numbers tag along with a string array containing user names:\n\r\n\rDIM Users$(100 TO 500), AcctNum&amp;(100 TO 500)\n\r\n\rARRAY SORT Users$(), TAGARRAY AcctNum&amp;()\n\r\n\rTogether, index and count specify the portion of darray to be sorted. index specifies the element at which the sort is to begin, while count specifies the number of consecutive elements to be sorted. If index is omitted, the sort begins at the first element of darray. If count is omitted or is zero, the array is sorted from element index to the last element of darray. If both are omitted, the entire array is sorted:\n\r\n\rDIM A&amp;(1 TO 99)\n\r\n\rARRAY SORT A&amp;(5) &nbsp; &nbsp; &nbsp; &nbsp;\'sorts elements 5..99 of A&amp;\n\r\n\rARRAY SORT A&amp;() FOR 10 &nbsp;\'sorts elements 1..10 of A&amp;\n\r\n\rARRAY SORT A&amp;(9) FOR 20 \'sorts elements 9..28 of A&amp;\n\r\n\rARRAY SORT A&amp;() &nbsp; &nbsp; &nbsp; &nbsp; \'sorts elements 1..99 of A&amp;\n\r\n\rSorting numeric arrays\n\r\n\rBy default, arrays are sorted in ascending order. To sort in descending order, include the DESCEND keyword:\n\r\n\rARRAY SORT A&amp;(), DESCEND &nbsp;\' descending order\n\r\n\rARRAY SORT A&amp;(), ASCEND &nbsp; \' ascending order\n\r\n\rARRAY SORT A&amp;() &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \' ascending order\n\r\n\rSorting string arrays\n\r\n\rWhen sorting a string array, the sort is performed in ascending order by default. In addition to DESCEND, ARRAY SORT provides the COLLATE UCASE and COLLATE string options.\n\r\n\rCOLLATE UCASE treats all lowercase letters as equal to their uppercase counterparts during the sort (elements &quot;Bob&quot; and &quot;BOB&quot; would be considered equal, for example):\n\r\n\rDIM A$(1 TO 5)\n\r\n\rA$(1) = &quot;Bob&quot;\n\r\n\rA$(2) = &quot;Jan&quot;\n\r\n\rA$(3) = &quot;Linda&quot;\n\r\n\rA$(4) = &quot;Ann&quot;\n\r\n\rA$(5) = &quot;Jerry&quot;\n\r\n\rARRAY SORT A$(), COLLATE UCASE, DESCEND\n\r\n\r\'sorts A$() in descending order; case-insensitive\n\r\n\rCOLLATE cstring is used to specify an entirely new sorting order. This can be used for a variety of purposes, the most obvious of which is the case of international character sets. The collate string cstring must contain exactly 256 characters, one for each of the ASCII codes 0-255, in the order that they would be sorted (from lowest to highest, if an ascending sort were performed on them).\n\r\n\rEach position in the string represents the ASCII code of that value. The contents of the byte at that position tells PowerBASIC the &quot;weight&quot; or importance factor of that particular ASCII code. The default is that position 0 has a weight of 0, position 1 has a weight of 1, etc, so that CHR$(0) sorts first, CHR$(1) sorts next, and so on through CHR$(255).\n\r\n\rSuppose you want the special character &quot;&auml;&quot; to have the same weight as the standard character &quot;a&quot;. It\'s easy: construct a string of 256 characters, 0-255; then go to the position of &quot;&auml;&quot; (ASCII code 132), and change the contents of that byte so it is exactly equal to the code for &quot;a&quot; (97). The following code fragment constructs just such a collate string:\n\r\n\r\' Create a 256-character string:\n\r\n\rFOR ix = 0 TO 255\n\r\n\r &nbsp;C$ = C$ + CHR$(ix)\n\r\n\rNEXT\n\r\n\rMID$(C$, 132 + 1) = CHR$(97)\n\r\n\rWe add one to the ASC value for MID$ because string positions start at 1, not 0. We can also use the expanded CHR$ function to create the same collating string using less code:\n\r\n\rC$ = CHR$(0 TO 131, 97, 133 TO 255)\n\r\n\rIt is most important to remember the rule for creating a collating string, as it is easy to make an intuitive jump to the wrong conclusion. Each position in the string (1-256) represents the ASCII code with that value minus one (CHR$(0) to CHR$(255)). The contents of the byte at that position tell the ARRAY SORT procedure the new &quot;weight&quot; or importance factor for that particular code. This is exactly the technique used by the 80x86-assembler opcode XLAT.\n\r\n\rSuppose you want CHR$(0) to sort at the very end of the sequence. To do that, you would set the byte at position 0+1 to CHR$(255) and the bytes at positions 0+2 to 0+256 to the values 0 to 254. The ASCII sequence in the collating string would appear like this: 255,0,1,2,3,4254. Using the expanded CHR$ function, this is straightforward:\n\r\n\rC$ = CHR$(255, 0 TO 254)\n\r\n\rTo sort upper case and lower case alphabetic characters as exactly equal, just set positions 97 to 122 (a-z) to the values 65-90 (A-Z). This is precisely how COLLATE UCASE is handled. With the collating method implemented by this procedure in PowerBASIC, it is possible for two or more ASCII codes to have equal &quot;weight&quot;.\n\r\n\rAs mentioned earlier, many programmers make a common, fatal mistake by intuitively creating a collating string that is simply a list of ASCII codes, in the sequence they wish to sort. That is, they expect the byte which appears first in the string to sort first, the byte which appears next to sort second, so that creating a collate string from the BASIC code:\n\r\n\rCHR$(65) + CHR$(66) + CHR$(67) + ...\n\r\n\rmight cause the characters &quot;ABC...&quot; to be sorted first. This technique will never work with the ARRAY statement and must be carefully avoided. We describe it here only because it is a common error. While it is arguably more intuitive than the technique implemented in PowerBASIC, the reason it does not work is that it doesn\'t allow two or more ASCII codes to have the same &quot;weight&quot;.\n\r\n\rThe following code builds a collating string compatible with the American OEM ASCII character set. For the fastest operation, this code should be run only once and the collating string should be made global.\n\r\n\rGLOBAL cu AS STRING\n\r\n\rFOR x = 0 TO 255\n\r\n\r &nbsp;cu = cu + CHR$(x)\n\r\n\rNEXT\n\r\n\rMID$(cu, 97+1, 26) = &quot;ABCDEFGHIJKLMNOPQRSTUVWXYZ&quot;\n\r\n\rMID$(cu, 129+1, 6) = &quot;ueaaaa&quot; &nbsp; &nbsp; \' &uuml;&eacute;&acirc;&auml;&agrave;&atilde;\n\r\n\rMID$(cu, 136+1, 9) = &quot;eeeiiiAAE&quot; &nbsp;\' &euml;&egrave;&iuml;&icirc;&igrave;&Auml;&Acirc;&Eacute;\n\r\n\rMID$(cu, 147+1, 8) = &quot;ooouuyOU&quot; &nbsp; \' &ocirc;&ouml;&ograve;&ucirc;&ugrave;&yuml;&Ouml;&Uuml;\n\r\n\rMID$(cu, 161+1, 5) = &quot;iounN&quot; &nbsp; &nbsp; &nbsp;\' &igrave;&ograve;&ugrave;&ntilde;&Ntilde;\n\r\n\rMID$(cu, 168+1, 1) = &quot;?&quot; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' &iquest;\n\r\n\r[ your code goes here ]\n\r\n\rARRAY SORT MyArray$(), COLLATE cu\n\r\n\rAn alternative arrangement using the expanded CHR$ function may look like this:\n\r\n\rcu = CHR$(0 TO 96, &quot;ABCDEFGHIJKLMNOPQRSTUVWXYZ&quot;, _\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;123 TO 128, &quot;ueaaaa&quot;, _ &nbsp; &nbsp; \' &uuml;&eacute;&acirc;&auml;&agrave;&atilde;\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;135, &nbsp; &nbsp; &nbsp; &nbsp;&quot;eeeiiiAAE&quot;, _ &nbsp;\' &euml;&egrave;&iuml;&icirc;&igrave;&Auml;&Acirc;&Eacute;\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;145 TO 146, &quot;ooouuyOU&quot;, _ &nbsp; \' &ocirc;&ouml;&ograve;&ucirc;&ugrave;&yuml;&Ouml;&Uuml;\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;155 TO 160, &quot;iounN&quot;, _ &nbsp; &nbsp; &nbsp;\' &igrave;&ograve;&ugrave;&ntilde;&Ntilde;\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;166 TO 167, &quot;?&quot;, _ &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' &iquest;\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;169 TO 255)\n\r\n\rFor example, the normal ascending ASCII sort order would be described by a string containing ASCII codes 0 through 255 in order:\n\r\n\rC$ = CHR$(0 TO 255)\n\r\n\rARRAY SORT A$(), COLLATE C$\n\r\n\rThe normal descending ASCII sort order would be described by a collating string containing the reverse of the above:\n\r\n\rC$ = STRREVERSE$(CHR$(0 TO 255))\n\r\n\rARRAY SORT A$(), COLLATE C$\n\r\n\rCOLLATE string can also be used with the ASCEND or DESCEND option. With ASCEND, the sort is performed in the order specified by COLLATE string; DESCEND sorts using the reverse of the order specified by COLLATE string:\n\r\n\rARRAY SORT A$(), COLLATE C$, DESCEND\n\r\n\rThe COLLATE string option is provided as a flexible means with which to specify the sorting order for strings containing international characters or other special symbols. Please keep in mind that the characters with ASCII code above CHR$(127) may have different meanings in different countries. The examples here assume that the default American OEM ASCII code page is in use.\n\r\n\rWhen sorting a string array, all characters of each element of the array are normally considered when performing comparisons. To limit the comparison to a specific subset of characters, use FROM to specify the startChar position, and TO to specify the endChar position that ARRAY SORT will consider within each array element. For example, you could sort based on the zip code contained in the last 5 characters of a 40-character address string:\n\r\n\rARRAY SORT A$() &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' sorts all chars\n\r\n\rARRAY SORT A$(), FROM 36 TO 40 \' sorts 36 - 40 only/p&gt;\n\r\n\rBy using the FROM..TO keywords, it also becomes possible to sort an array of User-Defined Types. In this case, ARRAY SORT can sort the array as if it were an array of fixed-length strings.\n\r\n\rSorting custom arrays:\n\r\n\rIn most cases, the standard numeric and string sorts should serve your needs very well. However, in the case of more complex data, it is frequently necessary to create multi-key sorts, or other unusual data sequences. Generally speaking, a multi-key sort is used when you wish to order data based upon multiple sections of a string or UDT. For example, you may wish to have customers sequenced by name -- but in the case of duplicate names, order each set of duplicates by ZIP code. With the custom array option, you can sort by any number of keys, in any sequence you may desire.\n\r\n\rA custom array may be user-defined types, fixed-length strings, or nul-terminated strings. With a custom array sort, you can write your own simple function to tell PowerBASIC the correct sequence for any two array elements. In the following example, the array MyType() is sorted based upon the code you write in the user-written function named MyFunc().\n\r\n\rARRAY SORT MyType(), CALL MyFunc()\n\r\n\rAs PowerBASIC proceeds through the sort, each time it needs to compare two array elements, it calls your custom function (in this case named MyFunc) to determine the correct sequence of the two elements. The custom function you write must always have exactly two ByRef parameters with precisely the same data type as the sorted array, for nul-terminated and FIELD strings, they must contain the length. These are the two variables which you must compare to determine the correct sequence. Your custom function must return a long integer to tell the correct sequence. It returns -1 if the first parameter should precede the second parameter. It returns +1 if the second parameter should precede the first. It returns 0 if the parameters are equal. This affords the PowerBASIC programmer the ultimate tool in sorting capabilities. You can have any number of keys. You can sort ascending, descending, or some other special sequence. The conditions are now totally under your control. The following example show how easy it is to create a multi-key sort, even those based upon non-string members of a UDT.\n\r\n\rType TheType\n\r\n\r &nbsp;LastName &nbsp; as String * 40\n\r\n\r &nbsp;FirstName &nbsp;as String * 20\n\r\n\r &nbsp;BalanceDue as Currency\n\r\n\rEnd Type\n\r\n\r[statements]\n\r\n\rDim MyType(100) as TheType\n\r\n\r[statements]\n\r\n\rArray Sort MyType(), Call MyFunc()\n\r\n\r[statements]\n\r\n\rFunction MyFunc(Param1 as TheType, Param2 as TheType) As Long\n\r\n\r &nbsp;If Param1.LastName &lt; Param2.LastName Then\n\r\n\r &nbsp; &nbsp;Function = -1 : Exit Function\n\r\n\r &nbsp;End If\n\r\n\r &nbsp;If Param1.LastName &gt; Param2.LastName Then\n\r\n\r &nbsp; &nbsp;Function = +1 : Exit Function\n\r\n\r &nbsp;End If\n\r\n\r &nbsp;If Param1.FirstName &lt; Param2.FirstName Then\n\r\n\r &nbsp; &nbsp;Function = -1 : Exit Function\n\r\n\r &nbsp;End If\n\r\n\r &nbsp;If Param1.FirstName &gt; Param2.FirstName Then\n\r\n\r &nbsp; &nbsp;Function = +1 : Exit Function\n\r\n\r &nbsp;End If\n\r\n\r &nbsp;If Param1.BalanceDue &lt; Param2.BalanceDue Then\n\r\n\r &nbsp; &nbsp;Function = +1 : Exit Function\n\r\n\r &nbsp;End If\n\r\n\r &nbsp;If Param1.BalanceDue &gt; Param2.BalanceDue Then\n\r\n\r &nbsp; &nbsp;Function = -1 : Exit Function\n\r\n\r &nbsp;End If\n\r\n\rEnd Function\n\r\n\rNotice that this function first sorts by last name in ascending sequence. If the last names are equal, it then sorts by first name in ascending sequence. If both names are equal, it then sorts by Balance Due in descending sequence so that the accounts with the highest balance appear first. This descending sequence is accomplished by switching the values -1/+1 in the final tests.\n\r\n\rThe array to be sorted, and the function parameters, must be fixed-length strings, nul-terminated strings, or user-defined types. PowerBASIC verifies that the size of the data and parameters are identical. However, to allow maximum flexibility, it does not require that the data types be the same. Therefore, for example, it\'s possible to sort an array of fixed-length strings using a function with UDT parameters as long as the data size is identical. It is the programmer\'s responsibility to ensure accuracy.\n\r\n\rSorting a multi-dimensional array\n\r\n\rWhen sorting a multi-dimensional array, the array is treated as a single-dimension array containing all of the elements of the multi-dimensional array, in linear column-major order. That is, all elements where all dimensions (except the first), are held at their minimum bounds, will come first in memory. These are immediately followed by the elements where the second dimension is set to its next consecutive index value, etc.\n\r\n\rFor example, the elements of a two-dimensional array (i.e., DIM A(n,x)) would be stored in consecutive memory locations like this:\n\r\n\r(0,0), , (n,0), (0,1), , (n,1), , (0,x), , (n,x)\n\r\n\rIn this case, ARRAY SORT A(0,0) FOR n+1 would sort only elements (0,0)...(n,0), while ARRAY SORT A(0,0) would sort the entire array: elements (0,0)(n,x).\n\r\n\rBe very careful when using ARRAY SORT with multi-dimensional arrays so as not to disrupt the organization of the data in the arrays.\n\r\n\rOptions\n\r\n\rThe options for ARRAY SORT can be specified in any order, as long as the FOR option, if it is present, directly follows the closing parenthesis of the name of darray.\n\r\n\rRestrictions\n\r\n\rARRAY SORT cannot be used on arrays within UDT structures or on an array of Interfaces. However, ARRAY SORT can be used with arrays of UDT structures - simply treat them as if they were an array of fixed-length strings.\n\r\n\rTo use ARRAY SORT on an embedded UDT array, use DIM..AT to dimension a regular array (of the same type) directly &quot;over the top&quot; of the UDT array, and use ARRAY SORT on that array. For example:\n\r\n\rTYPE SalesType\n\r\n\r &nbsp;OrderNum AS LONG\n\r\n\r &nbsp;PartNumber(1 TO 20) AS STRING * 20\n\r\n\rEND TYPE\n\r\n\r[statements]\n\r\n\rDIM Sales AS SalesType\n\r\n\r[statements]\n\r\n\rDIM Temp(1 TO 20) AS STRING * 20 AT VARPTR(Sales.Partnumber(1))\n\r\n\rARRAY SORT Temp()\n\r\n\rERASE Temp()\n\r\n\rSee also\n\r\n\rARRAY ASSIGN, ARRAY DELETE, ARRAY INSERT, ARRAY SCAN, CHR$, DIM, LBOUND, PowerArray, REDIM, UBOUND\n\r\n\rExample\n\r\n\rA&amp;(5) FOR 10, TAGARRAY B$(), DESCEND\n\r\n\rSorts elements 5 through 14 of array A&amp; in descending order, tagging along elements 5 through 14 of array B$.\n\r\n\rARRAY SORT A#()\n\r\n\rSorts all elements of array A# in ascending order, using no tag-along array.\n\r\n\rARRAY SORT A$(5) FOR 10, FROM 16 TO 25, COLLATE C$, TAGARRAY D()\n\r\n\rSorts elements 5 to 14 of array A$, considering only characters 16 to 25 of each element, using the sort order specified by collating string C$, tagging along elements 5 to 14 of array D.\n\r\n\rARRAY SORT A$()\n\r\n\rSorts all elements of array A$ in ascending order, considering all characters of each element, using no tag-along array.\n\r\n\rARRAY SORT MYTYPE(), USING MYFUNC()\n\r\n\rSorts all elements of the UDT array MYTYPE, using the custom UDT comparison function MYFUNC() to determine the sequence.","ARRAY SORT statement","scr\\html_array_sort_statement.htm","                  \n\r\n\rA PowerBASIC array may contain up to 4,294,967,295 elements, and the data may occupy as much as all available memory. However, all individual index numbers must fall within the range of a Long-integer variable (-2,147,483,648 to +2,147,483,647).\n\r\n\rPowerBASIC stores array data in main memory for all array types (including LOCAL arrays). Therefore, there is no arbitrary array size limit imposed by the amount of free stack space, such as can be experienced with large LOCAL nul-terminated, and Fixed-length string variables. The availability of main memory is the prime consideration (typically up to 2 Gb can be used). However, LOCAL arrays do require the storage of around 128 bytes on the stack for the array descriptor table.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rArray Data Types\n\r\n\rSubscripts\n\r\n\rString arrays\n\r\n\rMultidimensional arrays\n\r\n\rInternal representations of arrays\n\r\n\rArrays within User-Defined Types\n\r\n\rArray operations\n\r\n\rPOWERARRAY Object","Array storage requirements","scr\\html_array_storage_requirements_.htm","                  \n\r\n\rPurpose\n\r\n\rReturn descriptive attributes of a given array.\n\r\n\rSyntax\n\r\n\ry = ARRAYATTR(Arr(), AttrNum)\n\r\n\rRemarks\n\r\n\rARRAYATTR returns various descriptive attributes of an array, depending upon the value of AttrNum\n\r\n\rAttrNum\n\r\n\rDefinition\n\r\n\r &nbsp; &nbsp; 0\n\r\n\rReturns TRUE (-1) if the array is currently dimensioned, FALSE (0) if not.\n\r\n\r &nbsp; &nbsp; 1\n\r\n\rReturns the data type, as defined in the following table. Note that the numeric equates listed on the right of the table are built into PowerBASIC, but the numeric values they represent are subject to change. Therefore, application code should always use the numeric equates rather than the numeric value, to ensure compatibility with future versions of PowerBASIC. The current data type definitions are:\n\r\n\r&nbsp;\n\r\n\rType\n\r\n\rArray type\n\r\n\rKeyword\n\r\n\rEquate\n\r\n\r&nbsp;\n\r\n\r0\n\r\n\rByte\n\r\n\rBYTE\n\r\n\r%VARCLASS_BYT\n\r\n\r&nbsp;\n\r\n\r1\n\r\n\rWord\n\r\n\rWORD\n\r\n\r%VARCLASS_WRD\n\r\n\r&nbsp;\n\r\n\r2\n\r\n\rDouble-word\n\r\n\rDWORD\n\r\n\r%VARCLASS_DWD\n\r\n\r&nbsp;\n\r\n\r4\n\r\n\rInteger\n\r\n\rINTEGER\n\r\n\r%VARCLASS_INT\n\r\n\r&nbsp;\n\r\n\r5\n\r\n\rLong-integer\n\r\n\rLONG\n\r\n\r%VARCLASS_LNG\n\r\n\r&nbsp;\n\r\n\r8\n\r\n\rQuad-integer\n\r\n\rQUAD\n\r\n\r%VARCLASS_QUD\n\r\n\r&nbsp;\n\r\n\r10\n\r\n\rSingle-precision\n\r\n\rSINGLE\n\r\n\r%VARCLASS_SNG\n\r\n\r&nbsp;\n\r\n\r11\n\r\n\rDouble-precision\n\r\n\rDOUBLE\n\r\n\r%VARCLASS_DBL\n\r\n\r&nbsp;\n\r\n\r12\n\r\n\rExtended-precision\n\r\n\rEXT\n\r\n\r%VARCLASS_EXT\n\r\n\r&nbsp;\n\r\n\r13\n\r\n\rCurrency\n\r\n\rCURRENCY\n\r\n\r%VARCLASS_CUR\n\r\n\r&nbsp;\n\r\n\r14\n\r\n\rExtended Currency\n\r\n\rCURRENCYX\n\r\n\r%VARCLASS_CUX\n\r\n\r&nbsp;\n\r\n\r17\n\r\n\rVariant\n\r\n\rVARIANT\n\r\n\r%VARCLASS_VRNT\n\r\n\r&nbsp;\n\r\n\r18\n\r\n\rInterface\n\r\n\rINTERFACE\n\r\n\r%VARCLASS_IFAC\n\r\n\r&nbsp;\n\r\n\r19\n\r\n\rGUID\n\r\n\rGUID\n\r\n\r%VARCLASS_GUID\n\r\n\r&nbsp;\n\r\n\r20\n\r\n\rUDT or Union\n\r\n\rTYPE/UNION\n\r\n\r%VARCLASS_TYPE\n\r\n\r&nbsp;\n\r\n\r21\n\r\n\rANSI NulTrm string\n\r\n\rASCIIZ/STRINGZ * n\n\r\n\r%VARCLASS_STRZ\n\r\n\r&nbsp;\n\r\n\r22\n\r\n\rFixed-length string\n\r\n\rSTRING * n\n\r\n\r%VARCLASS_FIX\n\r\n\r&nbsp;\n\r\n\r23\n\r\n\rDynamic string\n\r\n\rSTRING\n\r\n\r%VARCLASS_STR\n\r\n\r&nbsp;\n\r\n\r24\n\r\n\rField string\n\r\n\rFIELD\n\r\n\r%VARCLASS_FLD\n\r\n\r&nbsp;\n\r\n\r25\n\r\n\rWide NulTrm string\n\r\n\rWSTRINGZ\n\r\n\r%VARCLASS_WSTRZ\n\r\n\r&nbsp;\n\r\n\r26\n\r\n\rWide FixLen string\n\r\n\rWSTRING * n\n\r\n\r%VARCLASS_WFIX\n\r\n\r&nbsp;\n\r\n\r27\n\r\n\rWide Dynamic string\n\r\n\rWSTRING * n\n\r\n\r%VARCLASS_FLD\n\r\n\r&nbsp;\n\r\n\r28\n\r\n\rWide Field string\n\r\n\rWFIELD\n\r\n\r%VARCLASS_WFLD\n\r\n\r&nbsp;\n\r\n\r2\n\r\n\rReturns TRUE (-1) if it is an array of pointers, FALSE (0) if not.\n\r\n\r&nbsp;\n\r\n\r3\n\r\n\rReturns the number of dimensions of the array. The lower and upper boundaries of each dimension can be retrieved with the LBOUND and UBOUND functions respectively\n\r\n\r&nbsp;\n\r\n\r4\n\r\n\rReturns the total number of elements in the array. For example, the array DIM A&amp;(3,4,5) would comprise 120 elements (4 x 5 x 6 = 120).\n\r\n\r&nbsp;\n\r\n\r5\n\r\n\rReturns the array element size. For example, an array of Double-precision variables would be 8 bytes. For dynamic strings, the size of the string handle (4 bytes) is returned. For DISPATCH and INTERFACE arrays, ARRAYATTR returns the size of a pointer variable (4 bytes).\n\r\n\r&nbsp;\n\r\n\rSee also\n\r\n\rDIM, LBOUND, UBOUND, PowerArray, REDIM\n\r\n\rExample\n\r\n\rDIM z(3,4,5) AS CURRENCYX\n\r\n\rDIM x AS LONG, Answer AS STRING\n\r\n\rFOR x = 0 TO 5\n\r\n\r &nbsp;Answer = Answer + FORMAT$(x)\n\r\n\r &nbsp;Answer = Answer + $TAB\n\r\n\r &nbsp;Answer = Answer + FORMAT$(ARRAYATTR(z(),x))\n\r\n\r &nbsp;Answer = Answer + $CRLF\n\r\n\rNEXT x\n\r\n\r\' The results are stored in Answer:\n\r\n\rResult\n\r\n\r0 &nbsp; &nbsp; &nbsp; -1\n\r\n\r1 &nbsp; &nbsp; &nbsp; 14\n\r\n\r2 &nbsp; &nbsp; &nbsp; 0\n\r\n\r3 &nbsp; &nbsp; &nbsp; 3\n\r\n\r4 &nbsp; &nbsp; &nbsp; 120\n\r\n\r5 &nbsp; &nbsp; &nbsp; 8","ARRAYATTR function","scr\\html_arrayattr_function.htm","                  \n\r\n\rIn prior versions of this compiler, arrays could not be part of a UDT structure. However, we now support both one and two-dimensional arrays of variables that have a fixed-length (for each element) - this includes nul-terminated strings, fixed-length strings, and all numeric variable classes. Individual arrays within a UDT may be up to 16 Megabytes each (although UDTs themselves are limited to 16 Megabytes).\n\r\n\rTwo-dimensional arrays within Types work exactly as do any other array in PowerBASIC, except that their dimensions are specified by positive numeric constant values, and are therefore not dynamically alterable. That is, the dimension sizes must be specified with numeric equates or numeric literal values, and these cannot be altered at run-time.\n\r\n\rLike conventional arrays, the default lower array boundary is zero, but positive non-zero values may be used to specify a specific range of subscript index values for the array, separated from the upper array boundary subscript with the TO keyword. Additionally, both the lower and upper subscript index values must be zero or greater (ie, negative subscript values are not permitted). Examples of valid syntax follow:\n\r\n\rTYPE MYTYPE\n\r\n\r &nbsp;id AS INTEGER &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' Scalar UDT member\n\r\n\r &nbsp;Styles(6) &nbsp; &nbsp; &nbsp; &nbsp; AS DWORD \' &nbsp;7 elements (0 TO 6)\n\r\n\r &nbsp;Yrs(1980 TO 2010) AS LONG &nbsp;\' 31 elements\n\r\n\r &nbsp;Team(100 TO 101) &nbsp;AS BYTE &nbsp;\' &nbsp;2 elements\n\r\n\r &nbsp;Rating(1 TO 10) &nbsp; AS DWORD \' 10 elements\n\r\n\r &nbsp;X(1 TO 5, 0 TO 5) AS EXT &nbsp; \' 30 elements (5x6)\n\r\n\r &nbsp;Y(4,3) &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;AS QUAD &nbsp;\' 20 elements (5x4)\n\r\n\rEND TYPE\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rArray Data Types\n\r\n\rSubscripts\n\r\n\rString arrays\n\r\n\rMultidimensional arrays\n\r\n\rArray storage requirements\n\r\n\rInternal representations of arrays\n\r\n\rArray operations\n\r\n\rPOWERARRAY Object","Arrays within User-Defined Types","scr\\html_arrays_within_user_defined_types.htm","                  \n\r\n\rPurpose\n\r\n\rReturns the character code of the character at the specified position in a string.\n\r\n\rSyntax\n\r\n\rCharCode&amp; = ASC(StrgExpr [, position&amp;])\n\r\n\rRemarks\n\r\n\rASC returns the character code of a particular character in the string expression. If the string is an ANSI string, the returned value will be in the range of 0 to 255. If it is a Unicode string, the returned value will be in the range of 0 to 65535.\n\r\n\rThe optional position&amp; parameter determines which character is to be checked. The first character is one, the second two, etc. If the position&amp; parameter is missing, the first character is presumed. If position&amp; is negative, ASC counts from the end of the string in reverse. That is, -1 specifies the last character, -2 specifies the second to last character, etc.\n\r\n\rCHR$ is the natural complement of ASC. It produces a one-character string corresponding to its ASCII or Unicode argument.\n\r\n\rRestrictions\n\r\n\rIf the string passed is null (zero-length) or the position is zero or greater than the length of the string, the value -1 is returned.\n\r\n\rSee also\n\r\n\rASC statement, CHR$\n\r\n\rExample\n\r\n\rx$ = &quot;The ASCII value of A is&quot; + STR$( ASC(&quot;A&quot;) )\n\r\n\rResult\n\r\n\rThe ASCII value of A is 65","ASC function","scr\\html_asc_function.htm","                  \n\r\n\rPurpose\n\r\n\rReplaces one character in a string by using its character code.\n\r\n\rSyntax\n\r\n\rASC(stringvar, position&amp;) = CharCode&amp;\n\r\n\rRemarks\n\r\n\rThe ASC statement replaces one character in a string variable. The position&amp; parameter determines which character is replaced. The first character is one, the second two, etc. If position&amp; is negative, ASC counts from the end of the string in reverse. That is, -1 specifies the last character, -2 specifies the second to last character, etc.\n\r\n\rIf the stringVar is ANSI, the CharCode must be in the range of 0 to 255. If Unicode, the CharCode must be in the range of 0 to 65535.\n\r\n\rRestrictions\n\r\n\rThe ASC statement cannot be used to extend the length of a string. If string is null (zero-length), or position is zero or greater than the length of stringvar, the operation is ignored.\n\r\n\rSee also\n\r\n\rASC function, CHR$, MID$ statement\n\r\n\rExample\n\r\n\rA$ = &quot;hello There&quot;\n\r\n\rASC(A$,1) = 72 \'replace 1st character with an &quot;H&quot;","ASC statement","scr\\html_asc_statement.htm","                  \n\r\n\rPurpose\n\r\n\rIdentify an assembly-language statement. PowerBASIC\'s Inline Assembler supports 8086/8088, 80286, 80386, 80486, Pentium, Floating-Point, SIMD and MMX instructions.\n\r\n\rSyntax\n\r\n\r{! | ASM} {opcode | label}\n\r\n\r{! | ASM} ALIGN boundary\n\r\n\rRemarks\n\r\n\rThis statement allows you to place assembly-language code within your PowerBASIC source code. An exclamation mark (!) serves as a shortcut for the ASM keyword.\n\r\n\rEach group of ASM statements must preserve the following CPU registers if the assembler code causes them to change: EBX, ESI, EDI, ESP, EBP, and all segment registers. See Saving Registers for more information.\n\r\n\rNo other statements may appear on the same line as an ASM statement; however, comments are acceptable.\n\r\n\r&nbsp;&nbsp;&nbsp;!&nbsp;DB&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1,&nbsp;2,&nbsp;3,&nbsp;4,&nbsp;5\n\r\n\r&nbsp;&nbsp;&nbsp;!&nbsp;DD&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&amp;H45001222,&nbsp;&amp;HFFFF4327\n\r\n\rAny variable referenced in an assembly-language statement must be defined prior to use. For example:\n\r\n\rx% = 10\n\r\n\r! MOV AX, x%\n\r\n\rYou cannot access the target of a pointer with a single ASM statement as you might do in BASIC source code. Instead, you must use the pointer address indirectly. To simulate the BASIC statement INCR @x, you would write:\n\r\n\rDIM x AS INTEGER PTR\n\r\n\rASM MOV EAX, x &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ; EAX holds a pointer to an Integer\n\r\n\rASM INC WORD PTR [EAX] &nbsp; &nbsp; &nbsp; ; Add one to target value\n\r\n\rString literals of up to four characters may be used in Inline Assembler code:\n\r\n\r! MOV AL, &quot;a&quot; &nbsp; &nbsp; &nbsp; &nbsp;; move char a into reg AL\n\r\n\r! MOV AX, &quot;ab&quot; &nbsp; &nbsp; &nbsp; ; move chars ab into reg AX\n\r\n\r! &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;; &quot;a&quot; into AL, &quot;b&quot; into AH\n\r\n\r! MOV EAX, &quot;abcd&quot; &nbsp; &nbsp;; move chars abcd into reg EAX\n\r\n\rPowerBASIC recognizes either an apostrophe ( \' ) or a semi-colon ( ; ) to specify a comment after a line of assembler code:\n\r\n\r! PUSH EAX &nbsp; ; save the EAX register\n\r\n\r! PUSH EBX &nbsp; \' save the EBX register\n\r\n\rALIGN\n\r\n\rASM ALIGN is used in critical situations to gain maximum efficiency from assembler code sections.\n\r\n\rASM ALIGN is used to round up the instruction location to a power of two address. The boundary parameter shown must be a power of two, in the range of 2 through 256.\n\r\n\rPowerBASIC inserts NOP instructions into the code section to bring the instruction location up to the desired address. If the instruction location is already at a multiple of boundary, ALIGN has no effect.\n\r\n\rThe #ALIGN metastatement functions in the same respect as ASM ALIGN, but the ASM ALIGN statement is more suited to being used in a PREFIX/END PREFIX block.\n\r\n\rRestrictions\n\r\n\rCare should be exercised to ensure registers are appropriately preserved when Inline Assembler code is intermixed with BASIC statements. See Saving Registers for more information.\n\r\n\rSee also\n\r\n\rThe Inline Assembler, ASMDATA\n\r\n\rExample\n\r\n\rTo add the values a&amp;, b&amp;, and c&amp;, you would write:\n\r\n\rLOCAL a&amp;, b&amp;, c&amp;, z&amp;\n\r\n\r! MOV &nbsp;EAX, a&amp;\n\r\n\r! ADD &nbsp;EAX, b&amp;\n\r\n\r! ADD &nbsp;EAX, c&amp;\n\r\n\r! MOV &nbsp;z&amp;, EAX\n\r\n\rNotes\n\r\n\rThe follow lists outline the supported mnemonics, data types, operators, and registers that can be used with the ASM statement.\n\r\n\rThe ASM statement supports the following mnemonics:\n\r\n\rAAA, AAD, AAM, AAS, ADC, ADD, ADDPD, ADDPS, ADDSD, ADDSS, ADDSUBPD, ADDSUBPS, ANDNPD, ANDNPS, ANDPD, ANDPS, AND\n\r\n\rBLENDPD, BLENDPS, BLENDVPD, BLENDVPS, BOUND, BSF, BSR, BSWAP, BT, BTC, BTR, BTS\n\r\n\rCALL, CBW, CWD, CDQ, CLC, CLD, CLFLUSH, CLI, CMC, CMOVA, CMOVAE, CMOVB, CMOVBE, CMOVC, CMOVE, CMOVG, CMOVGE, CMOVL, CMOVLE, CMOVNA, CMOVNAE, CMOVNB, CMOVNBE, CMOVNC, CMOVNE, CMOVNG, CMOVNGE, CMOVNL, CMOVNLE, CMOVNO, CMOVNP, CMOVNS, CMOVNZ, CMOVO, CMOVP, CMOVPE, CMOVPO, CMOVS, CMOVZ, CMP, CMPPD, CMPPS, CMPSB, CMPSD, CMPSS, CMPSW, CMPXCHG, CMPXCHG8B, COMISD, COMISS, CPUID, CRC32, CVTDQ2PD, CVTDQ2PS, CVTPD2DQ, CVTPD2PI, CVTPD2PS, CVTPI2PD, CVTPI2PS, CVTPS2DQ, CVTPS2PD, CVTPS2PI, CVTSD2SI, CVTSD2SS, CVTSI2SD, CVTSI2SS, CVTSS2SD, CVTSS2SI, CVTTPD2DQ, CVTTPD2PI, CVTTPS2DQ, CVTTPS2PI, CVTTSD2SI, CVTTSS2SI, CWDE\n\r\n\rDAA, DAS, DEC, DIV, DIVPD, DIVPS, DIVSD, DIVSS, DPPD, DPPS\n\r\n\rEMMS, ENTER, EXTRACTPS\n\r\n\rF2XM1, FABS, FADD, FADDP, FBLD, FBSTP, FCHS, FCLEX, FCMOVB, FCMOVBE, FCMOVE, FCMOVNB, FCMOVNBE, FCMOVNE, FCMOVNU, FCMOVU, FCOM, FCOMI, FCOMIP, FCOMP, FCOMPP, FCOS, FDECSTP, FDIV, FDIVP, FDIVR, FDIVRP, FFREE, FIADD, FICOM, FICOMP, FIDIV, FIDIVR, FILD, FIMUL, FINCSTP, FINIT, FIST, FISTP, FISTTP, FISUB, FISUBR, FLD, FLD1, FLDCW, FLDENV, FLDL2E, FLDL2T, FLDLG2, FLDLN2, FLDPI, FLDZ, FMUL, FMULP, FNCLEX, FNINIT, FNLDCW, FNOP, FNSAVE, FNSTCW, FNSTENV, FNSTSW, FPATAN, FPREM, FPREM1, FPTAN, FRNDINT, FRSTOR, FSAVE, FSCALE, FSIN, FSINCOS, FSQRT, FST, FSTCW, FSTENV, FSTP, FSTSW, FSUB, FSUBP, FSUBR, FSUBRP, FTST, FUCOM, FUCOMI, FUCOMIP, FUCOMP, FUCOMPP, FWAIT, FXAM, FXCH, FXRSTOR, FXSAVE, FXTRACT, FYL2X, FYL2XP1\n\r\n\rHADDPD, HADDPS, HLT, HSUBPD, HSUBPS\n\r\n\rIDIV, IMUL, IN, INC, INSB, INSD, INSERTPS, INSW, INT, INTO, IRET, IRETD\n\r\n\rJA, JAE, JB, JBE, JC, JE, JECXZ, JG, JGE, JL, JLE, JMP, JNA, JNAE, JNB, JNBE, JNC, JNE, JNG, JNGE, JNL, JNLE, JNO, JNP, JNS, JNZ, JO, JP, JPE, JPO, JS, JZ\n\r\n\rLAHF, LAR, LDDQU, LDMXCSR, LDS, LEA, LEAVE, LES, LFENCE, LFS, LGS, LOCK, LODSB, LODSD, LODSW, LOOP, LOOPE, LOOPNE, LOOPNZ, LOOPZ, LSL, LSS\n\r\n\rMASKMOVDQU, MASKMOVQ, MAXPD, MAXPS, MAXSD, MAXSS, MFENCE, MINPD, MINPS, MINSD, MINSS, MONITOR, MOV, MOVAPD, MOVAPS, MOVD, MOVDDUP, MOVDQA, MOVDQU, MOVDQ2Q, MOVHLPS, MOVHPD, MOVHPS, MOVLHPS, MOVLPD, MOVLPS, MOVMSKPD, MOVMSKPS, MOVNTDQA, MOVNTDQ, MOVNTI, MOVNTPD, MOVNTPS, MOVNTQ, MOVQ2DQ, MOVQ, MOVSB, MOVSD, MOVSHDUP, MOVSLDUP, MOVSS, MOVSW, MOVSX, MOVUPD, MOVUPS, MOVZX, MPSADBW, MUL, MULPD, MULPS, MULSD, MULSS, MWAIT\n\r\n\rNEG, NOP, NOT\n\r\n\rOR, ORPD, ORPS, OUT, OUTSB, OUTSD, OUTSW\n\r\n\rPABSB, PABSD, PABSW, PACKSSDW, PACKSSWB, PACKUSDW, PACKUSWB, PADDB, PADDD, PADDQ, PADDSB, PADDSW, PADDUSB, PADDUSW, PADDW, PALIGNR, PAND, PANDN, PAUSE, PAVGB, PAVGW, PBLENDVB, PBLENDW, PCMPEQB, PCMPEQD, PCMPEQW, PCMPEQQ, PCMPESTRI, PCMPESTRM, PCMPISTRI, PCMPISTRM, PCMPGTB, PCMPGTD, PCMPGTQ, PCMPGTW, PEXTRB, PEXTRD, PEXTRW, PHADDD, PHADDW, PHADDSW, PHMINPOSUW, PHSUBD, PHSUBSW, PHSUBW, PINSRB, PINSRD, PINSRW, PMADDUBSW, PMADDWD, PMAXSB, PMAXSD, PMAXSW, PMAXUB, PMAXUD, PMAXUW, PMINSB, PMINSD, PMINSW, PMINUB, PMINUD, PMINUW, PMOVMSKB, PMOVSXBW, PMOVSXBD, PMOVSXBQ, PMOVSXWD, PMOVSXWQ, PMOVSXDQ, PMOVZXBW, PMOVZXBD, PMOVZXBQ, PMOVZXWD, PMOVZXWQ, PMOVZXDQ, PMULDQ, PMULHRSW, PMULHUW, PMULHW, PMULLD, PMULLW, PMULUDQ, POP, POPA, POPAD, POPCNT, POPF, POPFD, POR, PREFETCHT0, PREFETCHT1, PREFETCHT2, PREFETCHNTA, PSADBW, PSHUFB, PSHUFD, PSHUFHW, PSHUFLW, PSHUFW, PSIGNB, PSIGND, PSIGNW, PSLLD, PSLLDQ, PSLLQ, PSLLW, PSRAD, PSRAW, PSRLD, PSRLDQ, PSRLD, PSRLQ, PSRLW, PSUBB, PSUBD, PSUBQ, PSUBW, PSUBSB, PSUBSW, PSUBUSB, PSUBUSW, PTEST, PUNPCKHBW, PUNPCKHDQ, PUNPCKHQDQ, PUNPCKHWD, PUNPCKLBW, PUNPCKLDQ, PUNPCKLQDQ, PUNPCKLWD, PUSH, PUSHA, PUSHAD, PUSHF, PUSHFD, PXOR\n\r\n\rRCL, RCR, RCPPS, RCPSS, RDPMC, RDTSC, REP, REPE, REPNE, REPNZ, REPZ, RET, RETF, RETN, ROL, ROR, ROUNDPD, ROUNDPS, ROUNDSD, ROUNDSS, RSQRTPS, RSQRTSS\n\r\n\rSAHF, SAL, SAR, SBB, SCASB, SCASD, SCASW, SETA, SETAE, SETB, SETBE, SETC, SETE, SETG, SETGE, SETL, SETLE, SETNA, SETNAE, SETNB, SETNBE, SETNC, SETNE, SETNG, SETNGE, SETNL, SETNLE, SETNO, SETNP, SETNS, SETNZ, SETO, SETP, SETPE, SETPO, SETS, SETZ, SFENCE, SHL, SHLD, SHR, SHRD, SHUFPD. SHUFPS, SQRTPD, SQRTPS, SQRTSD, SQRTSS, STC, STD, STI, STMXCSR, STOSB, STOSD, STOSW, SUB, SUBPD, SUBPS, SUBSD, SUBSS\n\r\n\rTEST\n\r\n\rUCOMISD, UCOMISS, UNPCKHPD, UNPCKHPS, UNPCKLPD, UNPCKLPS\n\r\n\rVERR, VERW\n\r\n\rWAIT\n\r\n\rXADD, XCHG, XGETBV, XLAT, XOR, XORPD, XORPS, XRSTOR, XSAVE, XSETBV\n\r\n\rThe ASM statement supports the following data types and operators:\n\r\n\rBYTE\n\r\n\rDB, DD, DW, DWD, DWORD\n\r\n\rFAR\n\r\n\rNEAR\n\r\n\rPOINTER, PTR\n\r\n\rQWD, QWORD\n\r\n\rSHORT\n\r\n\rTBY, TBYTE\n\r\n\rWORD, WRD\n\r\n\rThe ASM statement supports the following registers:\n\r\n\rInteger\n\r\n\r32-bit\n\r\n\rLow 16-bit\n\r\n\rHigh 8-bit\n\r\n\rLow 8-bit\n\r\n\rEAX\n\r\n\rAX\n\r\n\rAH\n\r\n\rAL\n\r\n\rEBX\n\r\n\rBX\n\r\n\rBH\n\r\n\rBL\n\r\n\rECX\n\r\n\rCX\n\r\n\rCH\n\r\n\rCL\n\r\n\rEDX\n\r\n\rDX\n\r\n\rDH\n\r\n\rDL\n\r\n\rESI\n\r\n\rSI\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\rEDI\n\r\n\rDI\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\rESP\n\r\n\rSP\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\rEBP\n\r\n\rBP\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\rSegments\n\r\n\rCS, DS, ES, SS, FS, GS\n\r\n\rMMX Registers\n\r\n\rMM(0), MM(1), MM(2), MM(3), MM(4), MM(5), MM(6), MM(7)\n\r\n\rMM0, MM1, MM2, MM3, MM4, MM5, MM6, MM7\n\r\n\rFloating Point registers\n\r\n\rST(0), ST(1), ST(2), ST(3), ST(4), ST(5), ST(6), ST(7)\n\r\n\rXMM registers\n\r\n\rXMM(0), XMM(1), XMM(2), XMM(3), XMM(4), XMM(5), XMM(6), XMM(7)\n\r\n\rXMM0, XMM1, XMM2, XMM3, XMM4, XMM5, XMM6, XMM7\n\r\n\rASM supports these special words\n\r\n\rPowerBASIC supports three special reserved words, which are used to specify a return value from a procedure of the same type:\n\r\n\rFUNCTION\n\r\n\rASM &nbsp;mov FUNCTION, eax\n\r\n\rMETHOD\n\r\n\rASM &nbsp;mov METHOD, 3\n\r\n\rPROPERTY\n\r\n\rASM &nbsp;mov PROPERTY, dx\n\r\n\rThe above examples are the functional equivalent of the comparable BASIC syntax:\n\r\n\rFUNCTION = x&amp;\n\r\n\rMETHOD &nbsp; = 3\n\r\n\rPROPERTY = z%\n\r\n\rThe exception is that the assembler syntax allows you to assign a return value directly from an appropriate CPU register. Of course, these special reserved words may only be referenced within a procedure of the same type (FUNCTION may only be used in a user-defined function, etc.)\n\r\n\rSee Also\n\r\n\r#ALIGN, ASMDATA/END ASMDATA","ASM ALIGN statement","scr\\html_asm_statement.htm","                  \n\r\n\rPurpose\n\r\n\rDefine a block where primitive read-only data is stored.\n\r\n\rSyntax\n\r\n\rASMDATA BlockName\n\r\n\r &nbsp;DB &nbsp;1, &quot;ABC&quot;$, &nbsp;0\n\r\n\r &nbsp;DW &nbsp;2, &quot;XYZ&quot;$$, 0\n\r\n\r &nbsp;DD &nbsp;&amp;H12345678\n\r\n\r &nbsp;DQ &nbsp;1234567890\n\r\n\rEND ASMDATA\n\r\n\rRemarks\n\r\n\rIt is frequently convenient to define some data within the code section of your program. This data is read-only, so it may never be altered. An attempt to do so will result in a GPF (General Protection Fault), which will cause termination of your program. This type of data is generally accessed only by ASM code.\n\r\n\rDefined Data can be placed inside of a Sub, Function, Method, or Property using ASM statements, but there are a number of pitfalls to that technique. When debugging, or when using TRACE, PROFILE, #DEBUG DISPLAY, ERL, ERL$, etc., PowerBASIC must insert special code in various places which makes if difficult (if not impossible) for you to access the data accurately. You don\'t know the size of the inserted code, so you\'ll have some difficulty addressing it accurately.\n\r\n\rAn ASMDATA block solves that problem entirely. It is designed for the sole purpose of defining data, and no extra code or extra data is ever inserted for any reason. Data within the block is never aligned, so you always know the exact location of each item. The ASMDATA block must be located outside of any Sub, Function, Method, or Property. However, the BlockName you assign is public, so it may be referenced from any place in your program. You may have one block on your program, or many.\n\r\n\rBy default, all ASMDATA blocks are positioned at the first available byte. This allows contiguous blocks to be accessed as though they were one larger block. You can align any or all of the blocks differently by preceding the block with an #ALIGN metastatement.\n\r\n\rLabels and line numbers are not allowed in an ASMDATA block. If you need a reference point to a particular sub-section of your data, just split it into two or more blocks, using each BlockName as the reference point.\n\r\n\rThe only statements allowed within an ASMDATA block are DB, DD, DQ, and DW, so they do not need to be preceded by an ASM statement. An ANSI string literal expression may be placed in a DB statement, and a WIDE (unicode) string literal expression may be placed in a DW statement, it should be noted that strings in ASM blocks must be 255 characters or less. A string literal expression may consist of quoted string literals, string equates, and the concatenation operators (&amp;,+). You may also use CHR$(), SPACE$(), and STRING$() if they use only literal parameters.\n\r\n\rYou can access the address of an ASMDATA block with the CODEPTR() function. So, if you create a block named ABC, like this:\n\r\n\rASMDATA ABC\n\r\n\r &nbsp;DB &nbsp;5,2,3\n\r\n\r &nbsp;DB &nbsp;7,8,9\n\r\n\rEND ASMDATA\n\r\n\rYou would access it something like this:\n\r\n\rAsmVar = CODEPTR(ABC)\n\r\n\rAnother option is to access it directly to a CPU register of your choice by using one of these opcodes:\n\r\n\rASM LEA EBX, abc\n\r\n\rASM MOV EBX, Offset abc\n\r\n\rThis would result in moving the first data byte (5) into register AL.\n\r\n\rOr even move it directly to a 32-bit variable:\n\r\n\rASM MOV &nbsp; AsmVar, Offset abc\n\r\n\rSee also\n\r\n\rASM","ASMDATA/END ASMDATA statements","scr\\html_asmdata_end_asmdata_statements.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the arctangent of an argument.\n\r\n\rSyntax\n\r\n\ry = ATN(numeric_expression)\n\r\n\rRemarks\n\r\n\rATN returns the arctangent (Inverse Tangent) of numeric_expression; that is, the angle whose tangent is numeric_expression.\n\r\n\rThe result, as with all operations involving angles in PowerBASIC, is in radians rather than degrees. Although it is common to specify angles in degrees, the radian is a more convenient measurement for mathematical operations. One radian is defined as the angle at the center of a circle that subtends an arc equal in length to one radius. Since for all circles, using the constant &pi;:\n\r\n\rCircumference / radius = 2 * &pi;\n\r\n\rthe length of the circumference of a circle is equal to 2 * &pi; * radius, and the angle of a full circle (360 degrees) is equal to 2 * &pi; radians.\n\r\n\rTo convert radians to degrees, just multiply the radian value by 180/&pi;, or 57.29577951308232##. For example, the arctangent of 0.23456 can be converted this way:\n\r\n\rt = ATN(.23456!) &nbsp; &nbsp; &nbsp; &nbsp;\'t = 0.230395 (radians)\n\r\n\rt = 57.29577951308232## * ATN(.23456!) \'t= 13.200 (degrees)\n\r\n\rTo convert degrees to radians, multiply by 0.0174532925199433##. For example:\n\r\n\r14 degrees = (0.0174532925199433## * 14) = 0.2443460952792062 radians\n\r\n\rRather than memorizing the radians/degrees conversion factors, calculate them for yourself by remembering this relationship: 2 &pi; radians equals a full circle (360 degrees), so 1 &pi; radian is 180 / &pi; degrees. Conversely, 1 degree equals &pi; / 180 radians.\n\r\n\r&pi; is a transcendental constant, meaning that it has an infinite number of decimal places. To 15-place accuracy, adequate for most applications, &pi; = 3.141592653589793##. This value can be closely approximated with the expression:\n\r\n\rpi## = 4 * ATN(1)\n\r\n\rDegrees-to-radians and radians-to-degrees conversions are good applications for user-defined functions.\n\r\n\rThe ATN function always returns an Extended-precision result.\n\r\n\rThe Tangent (TAN) of a value can be easily calculated with the TAN function.\n\r\n\rThe Hyperbolic Tangent (TANH) can be calculated:\n\r\n\rTanH = (EXP(2 * Value) - 1) / (EXP(2 * Value) + 1)\n\r\n\rThe Inverse Hyperbolic Tangent (ARCTANH) of a value can be calculated:\n\r\n\rArcTanH = LOG((1 + Value) / (1 - Value)) / 2\n\r\n\r&nbsp;\n\r\n\r\' Useful Macro functions\n\r\n\rMACRO Pi = 3.141592653589793##\n\r\n\rMACRO DegreesToRadians(dpDegrees) = (dpDegrees*0.0174532925199433##)\n\r\n\rMACRO RadiansToDegrees(dpRadians) = (dpRadians*57.29577951308232##)\n\r\n\rSee also\n\r\n\rCOS, SIN, TAN","ATN function","scr\\html_atn_function.htm","                  \n\r\n\rAn important consideration when using the stack is to be symmetrical in the byte count of what is pushed and what is popped.\n\r\n\rIf the stack is not balanced on exit from an assembly code block (i.e., you POP too few or too many registers), your routine will return to the wrong location in your code. This is because PowerBASIC must assume that the last item on the stack is the address to which it should return.\n\r\n\rIn other words, if the stack is not balanced on exit from an assembly code block, program execution is likely to resume at the wrong address and instantly crash the program. In most instances, if you PUSH a given data size onto the stack, you must POP the same data size.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rThe Inline Assembler\n\r\n\rThe stack\n\r\n\rTricks of the stack","Balancing the stack","scr\\html_balancing_the_stack.htm","                  \n\r\n\rPurpose\n\r\n\rSound a tone through the computer\'s speaker.\n\r\n\rSyntax\n\r\n\rBEEP\n\r\n\rRemarks\n\r\n\rBEEP plays the default Windows waveform sound, typically a &frac14; second tone, through either the built-in speaker; or a sound card if installed (in which case the Windows &quot;Default Beep&quot; sound is played). The Default Beep can be configured in the Sounds section of Control Panel.\n\r\n\rRestrictions\n\r\n\rThe physical aspects of the built-in speaker may have an effect on the quality and level of the resultant sound.","BEEP statement","scr\\html_beep_statement.htm","                  \n\r\n\rPurpose\n\r\n\rCreate a BGR color value from 3 primary color values or from an RGB value\n\r\n\rSyntax\n\r\n\rresult&amp; = BGR(red&amp;, green&amp;, blue&amp;)\n\r\n\rresult&amp; = BGR(rgbexpr&amp;)\n\r\n\rRemarks\n\r\n\rAn RGB value is a long integer value in the range of 0 to &amp;H00FFFFFF. It is used to specify a very precise color to various PowerBASIC functions and Windows API functions. The lowest three bytes of the value each specify the intensity of a primary color which combine to form the resultant color. Byte 1 (lowest) represents the red component, byte 2 the green, and byte 3 the blue. They can each take on a value in the range of 0 to 255. Byte 4 (highest) is always 0.\n\r\n\rSome Windows API functions, such as those which reference Device Independent Bitmaps (DIB), require that the colors be specified in the reverse sequence (Blue-Green-Red instead of Red-Green-Blue). In order to maximize performance and execution speed, PowerBASIC statements and functions which reference these structures also use the BGR format. These include GRAPHIC GET BITS and GRAPHIC SET BITS. When used with 3 parameters, the BGR() function creates a BGR value from the three component values.\n\r\n\rWhen used with one parameter, this function translates an RGB value to its BGR equivalent by swapping the first byte with the third byte, and returning the result.\n\r\n\rFor example, the RGB value of blue is &amp;HFF0000. BGR() translates it to &amp;H0000FF. Calling RGB() with that value converts it back to &amp;HFF0000.\n\r\n\rSee also\n\r\n\rBuilt In RGB Color Equates, RGB","BGR function","scr\\html_bgr_function.htm","                  \n\r\n\rPurpose\n\r\n\rConvert an integral value to a binary string.\n\r\n\rSyntax\n\r\n\rs$ = BIN$(IntVal [, Digits, LeadSpaces, TrailSpaces])\n\r\n\rRemarks\n\r\n\rIntVal is a numeric expression in the range of a 64-bit Quad Integer (-9223372036854775808 to +9223372036854775807). Any fractional part of the value is rounded. The result string is always formatted as an integral number using all the significant digits in IntVal. It is never expressed in scientific notation.\n\r\n\rIf Digits is 0 (or not given), no leading characters will be added to the numeric field. If Digits is a positive number greater than 0, the result string will be prepended with leading zeros to achieve the desired length. If Digits is a negative number, leading spaces are added to reach the absolute length. Digits may be in the range of -64 to +64.\n\r\n\rLeadSpaces specifies additional leading spaces to be prepended, regardless of the length of the numeric portion of the string.\n\r\n\rTrailSpaces specifies additional trailing spaces to be appended to the end of the string.\n\r\n\rSee also\n\r\n\rDEC$, FORMAT$, HEX$, OCT$, STR$, TRIM$, USING$, VAL","BIN$ function","scr\\html_bin$_function.htm","                  \n\r\n\rPowerBASIC\'s binary file technique, an extension to Interpretive BASIC, allows you to treat any file as a numbered sequence of bytes without regard to anything, including the following: ASCII characters, number versus string considerations, record length, carriage returns. With the binary approach to a file problem, you read and write a file by specifying exactly which bytes to read or write. This is similar to the services provided by Windows API functions used for reading and writing files.\n\r\n\rFlexibility always comes at a price. Binary files require that you do all the work to decide what goes where. Binary may be the best option when dealing with alien files that aren\'t in ASCII format; for example, a file created by a spreadsheet or database product. Of course, you will have to know the precise structure of the file before you can even attempt to break it down into numbers and strings agreeable to PowerBASIC.\n\r\n\rEvery file opened in binary mode has an associated position indicator that points to the place in the file that will be read or written to next. Use the SEEK statement to set the position indicator, and the SEEK function to read it.\n\r\n\rBinary files are accessed in the following way:1.First, OPEN the file in BINARY mode. You need not specify whether you are reading or writing; you can do either, or both.2.To read the file, use SEEK to position the file pointer at the byte you want to read. Then use GET$ to read a specified number of characters into a string variable.3. To write to the file, load a string variable with the information to be written. Then use SEEK to position the point in the file to which it should be written, and use PUT$ to write the data.4.When finished, CLOSE the file.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rFiles\n\r\n\rSequential Files\n\r\n\rRandom Access Files","Binary Files","scr\\html_binary_files.htm","                  \n\r\n\rPurpose\n\r\n\rSet or reset a bit in an integral class variable (or implied bit-array) based upon the result of an expression.\n\r\n\rSyntax\n\r\n\rBIT CALC intvar, bitnumber, calcexpr\n\r\n\rRemarks\n\r\n\rBIT CALC performs like a combination of the BIT SET and BIT RESET statements, offering the choice between set (1) and reset (0) according to the result of a numeric expression.\n\r\n\rintvar\n\r\n\rAn integral class variable (Byte, Word, Double-word, Integer, Long-integer or Quad-integer), or a variable forming the base of an implied bit-array.\n\r\n\rbitnumber\n\r\n\rAn integral class expression or numeric literal that specifies the bit number to adjust. Bit numbers start from zero (0), and extend to the size of the target variable or bit-array. For example, a 16-bit integer variable uses the range 0 to 15. An implied bit-array comprised of a Long-integer array with 100 elements (4 bytes * 100 = 400 bytes = 3200 bits) covers the bit range 0 to 3199.\n\r\n\rcalcexpr\n\r\n\rThe value derived from bit zero of calcexpr determines the set or reset action. If bit zero contains a zero (0), the bit in intvar is reset; if bit zero in calcexpr contains a one (1), the bit in intvar is set. This action can be more easily remembered if we consider PowerBASIC performs an implied bitwise AND operation (calcexpr AND 1) to derive the set or reset action.\n\r\n\rCare must be exercised to ensure that the bit index number (bitnumber) does not exceed the number of bits that can be validly accessed. For example, reading the 17th bit of a 16-bit scalar variable may trigger a General Protection Fault (GPF). Similarly, adjusting the 4097th bit of a bit-array derived from a 128-element DWORD array may cause similar problems. bitnumber is always zero-based, so the 129th bit of an implied bit-array is referenced in the BIT statement with bitnumber equal to 128. For example: x&amp; = BIT(A?(1), 128).\n\r\n\r&nbsp;\n\r\n\rSee also\n\r\n\rBIT function, BIT statement, BITS functions\n\r\n\rExample\n\r\n\rDIM dwStatus1 AS DWORD\n\r\n\rDIM dwStatus2 AS DWORD\n\r\n\rDIM iBit &nbsp; &nbsp; &nbsp;AS INTEGER\n\r\n\rDIM sResult1 &nbsp;AS STRING\n\r\n\rDIM sResult2 &nbsp;AS STRING\n\r\n\r&nbsp;\n\r\n\rFOR iBit = 0 TO 31\n\r\n\r &nbsp;BIT CALC dwStatus1, iBit, RND(0,1)\n\r\n\r &nbsp;BIT CALC dwStatus2, iBit, iBit MOD 3\n\r\n\rNEXT iBit\n\r\n\rsResult1 = BIN$(dwStatus1,32)\n\r\n\rsResult2 = BIN$(dwStatus2,32)\n\r\n\rResult\n\r\n\rsResult1 = &quot;01001101001110101110111010010101&quot;\n\r\n\rsResult2 = &quot;10010010010010010010010010010010&quot;","BIT CALC statement","scr\\html_bit_calc_statement.htm","                  \n\r\n\rTYPE and UNION structures may contain bit variables, which are named BIT (unsigned values) or SBIT (signed values). Each bit variable may occupy from 1 to 31 bits. When used in a TYPE, bit variables are packed one after another up to a total of 32 bits per bit field. When used in a UNION, all bit variables overlay each other, starting at the first bit position.\n\r\n\rBit variables may only be used as TYPE or UNION members, not as scalar, array, or pointer variables. The size of a bit variable is defined as:\n\r\n\rvar AS BIT * nlit [IN BYTE|WORD|DWORD]\n\r\n\rwhere the term &quot;* nlit&quot; defines the number of bits (1 to 31), and the optional term &quot;IN BYTE|WORD|DWORD&quot;, if present, defines the start of a new bit field of 1, 2, or 4 bytes.\n\r\n\rTYPE abcd\n\r\n\r &nbsp;valu AS BIT * 31 IN DWORD\n\r\n\r &nbsp;sign AS SBIT * 1\n\r\n\r &nbsp;nybl2 AS BIT * 4 IN BYTE\n\r\n\r &nbsp;nybl1 AS BIT * 4\n\r\n\rEND TYPE\n\r\n\rThe example type above is 5 bytes in size, containing a 4-byte bit field and a 1-byte bit field. In this case, each contain 2 bit variables of varying size. The range of values which may be stored depends upon the number of bits available. For example, &quot;BIT * 4&quot; has a range of 0 to 15, &quot;SBIT * 1&quot; has a range of -1 to 0, and &quot;SBIT * 5&quot; has a range of -16 to +15. BIT and SBIT variables may not be used with SHIFT or ROTATE statements.\n\r\n\rUNION abcde\n\r\n\r &nbsp;Part1 AS BIT * 8 IN DWORD\n\r\n\r &nbsp;Part2 AS BIT * 16\n\r\n\rEND UNION\n\r\n\rThe example union above is 2 bytes in size, containing an 8-bit field and an overlapping 16-bit field.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rTYPE/END TYPE block\n\r\n\rUNION/END UNION statements","Bit Data Types","scr\\html_bit_data_types.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the value of a particular bit in an integral class variable (or in an implied bit-array)\n\r\n\rSyntax\n\r\n\rflag = BIT(intvar, bitnumber)\n\r\n\rRemarks\n\r\n\rThe BIT function is used to determine the value of one particular bit in an integral-class variable or implied bit-array.\n\r\n\rintvar\n\r\n\rThe parameter intvar must be a variable, not an expression. The BIT function returns either 0 or 1 to indicate the value of the specified bit.\n\r\n\rbitnumber\n\r\n\rThe bit in question.  The allowable range for the parameter is the same as that of a Long-integer. This makes it possible to have implicit bit-arrays of more than 2 billion bits in size. For such arrays, bits 0 to 15 are in the first word starting at intvar, bits 16-31 are in the next word, and so forth.\n\r\n\rImplied bit-arrays are considered to start at the memory position of the variable intvar. For example, if intvar is itself an array variable, it is possible to access bits in any of the following elements of the array. See the array examples below.\n\r\n\rCare must be exercised to ensure that the bit index number (bitnumber) does not exceed the number of bits that can be validly accessed. For example, reading the 17th bit of a 16-bit scalar variable may trigger a General Protection Fault (GPF). Similarly, adjusting the 4097th bit of a bit-array derived from a 128-element DWORD array may cause similar problems. bitnumber is always zero-based, so the 129th bit of an implied bit-array is referenced in the BIT statement with bitnumber equal to 128. For example: x&amp; = BIT(A?(1), 128).\n\r\n\r&nbsp;\n\r\n\rSee also\n\r\n\rBIT CALC statement, BIT statement, BITS functions\n\r\n\rExample\n\r\n\rx% = 7\n\r\n\ry% = BIT(x%, 2)\n\r\n\r[statements]\n\r\n\rDIM z%(1:2000000) &nbsp;\' 32 million element bit-array\n\r\n\ry% = BIT(z%(1),16) \' bit 0 of 2nd word of z%()\n\r\n\ry% = BIT(z%(2000000),15) &nbsp; \' MSB of last element\n\r\n\ry% = BIT(z%(1), 31999999&amp;) \' MSB of last element","BIT function","scr\\html_bit_function.htm","                  \n\r\n\rPurpose\n\r\n\rManipulate individual bits of an integral class variable (or in an implied bit-array), for storing values such as TRUE/FALSE (flag) settings quickly and efficiently.\n\r\n\rSyntax\n\r\n\rBIT {SET | RESET | TOGGLE} intvar, bitnumber\n\r\n\rRemarks\n\r\n\rintvar must be one of the integral-class variable types: Byte, Word, Integer, Double-word, Long-integer, or Quad-integer.\n\r\n\rThe allowable range for the parameter bitnumber is the same as that of a Long-integer, making it possible to have implicit bit-arrays of more than 2 billion bits in size. Bits 0 to 15 are in the first word starting at intvar, bits 16-31 are in the next word, and so forth.\n\r\n\rImplied bit-arrays are considered to start at the memory position of the variable intvar. For example, if intvar is itself an array variable, it is possible to access bits in any of the following elements of the array. See the array examples below.\n\r\n\rCare must be exercised to ensure that the bit index number (bitnumber) does not exceed the number of bits that can be validly accessed. For example, adjusting the 17th bit of a 16-bit scalar variable may cause a subtle memory corruption problem, and/or may trigger a General Protection Fault (GPF). Similarly, adjusting the 4097th bit of a bit-array derived from a 128-element DWORD array may cause similar problems. bitnumber is always zero-based, so the 129th bit of an implied bit-array is referenced in the BIT statement with bitnumber equal to 128. For example: BIT SET A?(1), 128.\n\r\n\r&nbsp;\n\r\n\rSET\n\r\n\rSets the indicated bit to one.\n\r\n\rRESET &nbsp; \n\r\n\rSets the indicated bit to zero.\n\r\n\rTOGGLE\n\r\n\rToggles the indicated bit: one becomes zero; zero becomes one.\n\r\n\rSee also\n\r\n\rBIT CALC statement, BIT function, BITS functions\n\r\n\rExample\n\r\n\rx% = 7\n\r\n\rBIT SET x%, 2 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \' Sets the 3rd bit (bit 2) to 1\n\r\n\rBIT RESET x%, 10 &nbsp; &nbsp; &nbsp; &nbsp;\' Sets the 11th bit (bit 10) to 0\n\r\n\rBIT TOGGLE x%, 5 &nbsp; &nbsp; &nbsp; &nbsp;\' Toggle bit 5\n\r\n\r[statements]\n\r\n\rDIM z%(1 TO 2000) &nbsp; &nbsp; &nbsp; \' 32000 element bit-array\n\r\n\rBIT SET z%(1), 37 &nbsp; &nbsp; &nbsp; \' Sets bit 5 of 3rd word to a 1\n\r\n\rBIT TOGGLE z%(1),0 &nbsp; &nbsp; &nbsp;\' Toggle lowest bit in 1st word\n\r\n\rBIT RESET z%(2000), 15 &nbsp;\' Clear the MSB of integer array element\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' 2000 (bit 31999 of the implied bit array,\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' numbered 0 to 31999)\n\r\n\rBIT RESET z%(1), 31999 &nbsp;\' Clear the MSB of element 2000\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' (this is equivalent to the previous line)","BIT statement","scr\\html_bit_statement.htm","                  \n\r\n\rPurpose\n\r\n\rCopy string contents without modification.\n\r\n\rSyntax\n\r\n\rAnsiVar$ &nbsp;= BITS$(STRING,  StringExpr)\n\r\n\rWideVar$$ = BITS$(WSTRING, StringEXpr)\n\r\n\rRemarks\n\r\n\rThis function copies the exact contents of a string expression to a string variable without making any ANSI/UNICODE conversions. It assumes that the data already matches the format specified by the director word STRING or WSTRING. This functionality will not often be needed, so a certain amount of caution should be used.\n\r\n\rFor example, in older versions of PowerBASIC, there were no WIDE string variables available. It was therefore necessary to store Unicode data in an ANSI byte string. In updating these programs, &nbsp;you may find you need to transfer this WIDE data to a WIDE variable, but without the automatic internal conversion normally provided by the compiler. BITS$ provides just that functionality. Of course, it can copy bytes from WIDE to ANSI as well.\n\r\n\rSee also\n\r\n\rBITS\n\r\n\rExample\n\r\n\rxyz$&nbsp;=&nbsp;&quot;Hello&quot;\n\r\n\rxyz$&nbsp;=&nbsp;UCODE$(xyz$)\n\r\n\rwidevar$$&nbsp;=&nbsp;BITS$(WSTRING,&nbsp;xyz$)\n\r\n\r\'&nbsp;widevar$$&nbsp;now&nbsp;contains&nbsp;&quot;Hello&quot;&nbsp;in&nbsp;unicode&nbsp;format.","BITS$ function","scr\\html_bits$_function.htm","                  \n\r\n\rPurpose\n\r\n\rConverts an integral value into another data type, based upon the bit pattern of the value. This is particularly helpful in converting between signed and unsigned representations.\n\r\n\rSyntax\n\r\n\rresultvar = BITS(datatype, expression)\n\r\n\rdatatype\n\r\n\rThe parameter datatype may be BYTE, WORD, DWORD, INTEGER, or LONG to specify the new data type which should be returned by the function.\n\r\n\rexpression\n\r\n\rAn integral class variable, expression, or numeric literal, which designates the original value to be converted.\n\r\n\rRemarks\n\r\n\rSince the integer value -1 and word value 65535 have the identical bit pattern of 1111111111111111, BITS(WORD,-1) would return the unsigned word value of 65535. Of course, BITS(INTEGER,65535) would then return the integer value -1. Other values and data types would follow the same pattern and rules.\n\r\n\rThis newer form of BITS condenses the functionality of the older forms (BITS%, BITS&amp;, BITS?, BITS?? and BITS???) into a single function. In particular, this provides for the addition of new data types in future version of PowerBASIC, particularly those which may not have an associated type-specifier character.\n\r\n\rSee also\n\r\n\rBIT CALC statement, BIT function, BIT statement, BITS$, BITSE","BITS function","scr\\html_bits_function.htm","                  \n\r\n\rPurpose\n\r\n\rCompare integral values for equivalent bits regardless of sign.\n\r\n\rSyntax\n\r\n\rx&amp; = BITSE(nexp, nexp, bitsize)\n\r\n\rRemarks\n\r\n\rThis function allows you to compare two integral values for equivalent bit patterns, regardless of whether they are signed or unsigned values. The two numeric expressions (nexp) are the integral values to be compared, &nbsp;The bitsize parameter specifies the number of bits to be compared, 8, 16, or 32.\n\r\n\rFor example, the integer value -1 and the word value 65535 both have the identical bit pattern: 1111111111111111. The difference is simply the way the bits are interpreted by a program.\n\r\n\rx&amp; = BITSE( -1, 65535, 16)\n\r\n\rThe above example would cause the lowest 16 bits of the expressions to be compared. Since they are equal, the value TRUE (-1) is returned.\n\r\n\rSee also\n\r\n\rBITS","BITSE function","scr\\html_bitse_function.htm","                  \n\r\n\rThe Include Paths Selection dialog provides a simple method of creating an Include file list for the PowerBASIC compiler, and the Resource Compiler. The Include folder list specifies the search order that the compilers use to locate #INCLUDE and #include files. The Include Paths Selection Dialog box is launched by the Ellipsis buttons on the Compiler Preferences tab page.\n\r\n\r\n\r\n\rFolder list\n\r\n\rThe list of folders in a drag list control. The folders appear in the order in which the compiler search for #INCLUDE (PowerBASIC) or #include (Resource Compiler) files. There are two ways to rearrange the order of folders:\n\r\n\r1. &nbsp; &nbsp; &nbsp;  Click and drag the individual folder names up and down in the Folders List; or\n\r\n\r2. &nbsp; &nbsp; &nbsp;  Select (highlight) a folder and use the Move Up and Move Down buttons to reposition the folder in the list.\n\r\n\rAdd Folder\n\r\n\rLaunch the standard Windows &quot;Browse for Folder&quot; dialog, where the folder tree can be navigated. The default folder is the currently selected folder in the Folders list to the left of the Add Folder button or the current folder if none are selected. The Browse for Folder dialog looks like this:\n\r\n\r&nbsp;\n\r\n\r\n\r\n\rDelete\n\r\n\rDelete the currently selected folder. If all folders are deleted, a new entry specifying the current folder is automatically created, ensuring at least one folder appears in the list.\n\r\n\rMove Up\n\r\n\rMove the currently selected folder up one position in the Folders List, increasing the search priority of the selected folder. The compilers search the Folders List in the order they appear.\n\r\n\rMove Down\n\r\n\rMove the currently selected folder up down position in the Folders List, decreasing the search priority of the selected folder. The compilers search the Folders List in the order they appear.\n\r\n\rOK\n\r\n\rAccept all changes to the Folders List, and return to the Compiler Preferences dialog.\n\r\n\rCancel\n\r\n\rCancel any changes made to the Folder List, and return to the Compiler Preferences dialog.","Browsing for Include folders","scr\\html_browsing_for_include_folders.htm","                  \n\r\n\rPurpose\n\r\n\rBuild or concatenate strings with very high efficiency.\n\r\n\rSyntax\n\r\n\rx$ = BUILD$(a$,b$,c$,d$...)\n\r\n\rRemarks\n\r\n\rIn some cases, string concatenation using the classic string operators can be a slow process. This is particularly true when there are many operands using longer strings. The BUILD$ function passes all the typical bottlenecks to create a new string at the greatest possible speed. The following 2 lines are functionally identical, but the BUILD$ version will execute substantially faster.\n\r\n\rx$ = a$ + &quot;bb&quot; + c$ + y$(7) + y$(i&amp;) + z$\n\r\n\rx$ = BUILD$(a$, &quot;bb&quot;, c$, y$(7), y$(i&amp;), z$)\n\r\n\rIt\'s interesting to note that this string function could have been named APPEND$ or PREPEND$ because it performs these functionalities so well. For example, to prepend a topic number to text$ while also adding a period at the end, you could execute:\n\r\n\rtext$ = BUILD$( &quot;1) &quot;, text$, &quot;.&quot;)\n\r\n\rIn order to extract the utmost efficiency, BUILD$() was designed to work with a very narrow definition. The component parameters must be dynamic string variables, either scalar or array, string literals, or string equates. They may not be expressions. There is virtually no limit as to the number of parameters.\n\r\n\rThe BUILD$() function is most valuable when you are concatenating numerous strings all at the same time. However, when you must add many string sections, in many separate operations, the StringBuilder object is much faster, and a more appropriate choice.\n\r\n\rGenerally speaking, the greater the number of parameters, the greater the increase in execution speed.\n\r\n\rSee also\n\r\n\rLET, CHR$, CSET, CSET$, JOIN$, LSET, LSET$, REPEAT$, RSET, RSET$, STRING$, STRINGBUILDER, STRINSERT$, WRAP$","BUILD$ function","scr\\html_build$_function.htm","                  \n\r\n\rThe compiler provides a set of built-in Interfaces, including:\n\r\n\r&nbsp;\n\r\n\rICLASSFACTORY\n\r\n\rICONNECTIONPOINTCONTAINER\n\r\n\rICONNECTIONPOINT\n\r\n\rIDISPATCH\n\r\n\rIUNKNOWN\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rWhat are the parts of an object?\n\r\n\rAre there other important &quot;Buzz-Words&quot;?\n\r\n\rWhat does an Interface look like?\n\r\n\rBuilt-in numeric equates\n\r\n\rBuilt-in string equates\n\r\n\rBuilt-in User Defined Types\n\r\n\rBuilt-in RGB Color Equates","Built-in Interfaces","scr\\html_built_in_interfaces.htm","                  \n\r\n\rThe compiler provides a convenient set of built-in numeric equates.\n\r\n\rThe first to consider should be the group which determines the compiler version and the supported feature level. Additional information may be found with the %DEF equate operator.\n\r\n\rCompiler Version:\n\r\n\r%PB_CC32, %PB_DLL32, %PB_EXE, %PB_REVISION, %PB_REVLETTER, %PB_WIN32\n\r\n\rCompile-Time information:\n\r\n\r%PB_COMPILETIME\n\r\n\rAt each compile, this equate is filled with the current date and time of the compilation in PowerTime binary format. You can use the PowerTime Class to convert it to a text equivalent for use in your application.\n\r\n\rFor use with #RESOURCE FILEFLAGS:\n\r\n\r%VS_FF_DEBUG, %VS_FF_INFOINFERRED, %VS_FF_PATCHED, %VS_FF_PRERELEASE, %VS_FF_PRIVATEBUILD, %VS_FF_SPECIALBUILD\n\r\n\rFor use with ARRAYATTR:\n\r\n\r%VARCLASS_BYT, %VARCLASS_WRD, %VARCLASS_DWD, %VARCLASS_INT, %VARCLASS_LNG, %VARCLASS_QUD, %VARCLASS_SNG, %VARCLASS_DBL, %VARCLASS_EXT, %VARCLASS_CUR, %VARCLASS_CUX, %VARCLASS_VRNT, %VARCLASS_IFAC, %VARCLASS_TYPE, %VARCLASS_GUID, %VARCLASS_ASC, %VARCLASS_STRZ %VARCLASS_FIX, %VARCLASS_STR, %VARCLASS_FLD, %VARCLASS_WSTRZ, %VARCLASS_WFIX, %VARCLASS_WSTR, %VARCLASS_WFLD\n\r\n\rFor use with BUTTONS:\n\r\n\r%BN_CLICKED, %BN_DBLCLK, %BN_DISABLE, %BN_DOUBLECLICKED, %BN_HILITE, %BN_KILLFOCUS, %BN_PAINT, %BN_SETFOCUS, %BN_UNHILITE, %IDOK, %IDCANCEL, %IDABORT, %IDRETRY, %IDIGNORE, %IDYES, %IDNO, %IDCLOSE, %IDHELP, %IDTRYAGAIN, %IDCONTINUE, %BS_TEXT, %BS_PUSHBUTTON, %BS_DEFPUSHBUTTON, %BS_DEFAULT, %BS_CHECKBOX, %BS_AUTOCHECKBOX, %BS_RADIOBUTTON, %BS_3STATE, %BS_AUTO3STATE, %BS_GROUPBOX, %BS_USERBUTTON, %BS_AUTORADIOBUTTON, %BS_OWNERDRAW, %BS_LEFTTEXT, %BS_ICON, %BS_BITMAP, %BS_LEFT, %BS_RIGHT, %BS_CENTER, %BS_TOP, %BS_BOTTOM, %BS_VCENTER, %BS_PUSHLIKE, %BS_MULTILINE, %BS_NOTIFY, %BS_FLAT, %BS_RIGHTBUTTON\n\r\n\rFor use with Callback functions:\n\r\n\r%NM_OUTOFMEMORY, %NM_CLICK, %NM_DBLCLK, %NM_RETURN, %NM_RCLICK, %NM_RDBLCLK, %NM_SETFOCUS, %NM_KILLFOCUS, %NM_CUSTOMDRAW, %NM_HOVER, %NM_NCHITTEST, %NM_KEYDOWN, %NM_RELEASEDCAPTURE, %NM_SETCURSOR, %NM_CHAR, %NM_TOOLTIPSCREATED, %NM_LDOWN, %NM_RDOWN, %NM_THEMECHANGED, %SC_SIZE, %SC_MOVE, %SC_MINIMIZE, %SC_MAXIMIZE, %SC_NEXTWINDOW, %SC_PREVWINDOW, %SC_CLOSE, %SC_VSCROLL, %SC_HSCROLL, %SC_MOUSEMENU, %SC_KEYMENU, %SC_ARRANGE, %SC_RESTORE, %SC_TASKLIST, %SC_SCREENSAVE, %SC_HOTKEY, %SC_DEFAULT, %SC_MONITORPOWER, %SC_CONTEXTHELP, %WM_ACTIVATE, %WM_ACTIVATEAPP, %WM_CANCELMODE, %WM_CAPTURECHANGED, %WM_CHAR, %WM_CLOSE, %WM_COMMAND, %WM_CREATE, %WM_DESTROY, %WM_DRAWITEM, %WM_HELP, %WM_HSCROLL, %WM_INITDIALOG, %WM_KEYDOWN, %WM_KEYUP, %WM_KILLFOCUS, %WM_LBUTTONDBLCLK, %WM_LBUTTONDOWN, %WM_LBUTTONUP, %WM_MBUTTONDBLCLK, %WM_MBUTTONDOWN, %WM_MBUTTONUP, %WM_MOUSEACTIVATE, %WM_MOUSEFIRST, %WM_MOUSEHOVER, %WM_MOUSELAST, %WM_MOUSELEAVE, %WM_MOUSEMOVE, %WM_MOUSEWHEEL, %WM_MOVE, %WM_NCACTIVATE, %WM_NCCALCSIZE, %WM_NCCREATE, %WM_NCDESTROY, %WM_NCHITTEST, %WM_NCLBUTTONDBLCLK, %WM_NCLBUTTONDOWN, %WM_NCLBUTTONUP, %WM_NCMBUTTONDBLCLK, %WM_NCMBUTTONDOWN, %WM_NCMBUTTONUP, %WM_NCMOUSEMOVE, %WM_NCPAINT, %WM_NCRBUTTONDBLCLK, %WM_NCRBUTTONDOWN, %WM_NCRBUTTONUP, %WM_NCXBUTTONDBLCLK, %WM_NCXBUTTONDOWN, %WM_NCXBUTTONUP, %WM_NOTIFY, %WM_NULL, %WM_PAINT, %WM_QUIT, %WM_RBUTTONDBLCLK, %WM_RBUTTONDOWN, %WM_RBUTTONUP, %WM_SETFOCUS, %WM_SIZE, %WM_SYSKEYDOWN, %WM_SYSKEYUP, %WM_TIMER, %WM_VSCROLL, %WM_USER\n\r\n\rFor use with CONTROL SHOW STATE and DIALOG SHOW STATE:\n\r\n\r%SW_HIDE, %SW_SHOWNORMAL, %SW_NORMAL, %SW_SHOWMINIMIZED, %SW_SHOWMAXIMIZED, %SW_MAXIMIZE, %SW_SHOWNOACTIVATE, %SW_SHOW, %SW_MINIMIZE, %SW_SHOWMINNOACTIVE, %SW_SHOWNA, %SW_RESTORE, %SW_SHOWDEFAULT, %SW_FORCEMINIMIZE, %SW_MAX\n\r\n\rFor use with COMBOBOXES:\n\r\n\r%CBS_SIMPLE, %CBS_DROPDOWN, %CBS_DROPDOWNLIST, %CBS_OWNERDRAWFIXED, %CBS_OWNERDRAWVARIABLE, %CBS_AUTOHSCROLL, %CBS_OEMCONVERT, %CBS_SORT, %CBS_HASSTRINGS, %CBS_NOINTEGRALHEIGHT, %CBS_DISABLENOSCROLL, %CBS_UPPERCASE, %CBS_LOWERCASE, %CBN_CLOSEUP, %CBN_DBLCLK, %CBN_DROPDOWN, %CBN_EDITCHANGE, %CBN_EDITUPDATE, %CBN_ERRSPACE, %CBN_KILLFOCUS, %CBN_SELENDCANCEL, %CBN_SELCHANGE, %CBN_SELENDOK, %CBN_SETFOCUS\n\r\n\rFor use with DIALOG and/or CONTROL styles:\n\r\n\r%DLGC_WANTARROWS, %DLGC_WANTTAB, %DLGC_WANTALLKEYS, %DLGC_WANTMESSAGE, %DLGC_HASSETSEL, %DLGC_DEFPUSHBUTTON, %DLGC_UNDEFPUSHBUTTON, %DLGC_RADIOBUTTON, %DLGC_WANTCHARS, %DLGC_STATIC, %DLGC_BUTTON, %DS_ABSALIGN, %DS_SYSMODAL, %DS_3DLOOK, %DS_FIXEDSYS, %DS_NOFAILCREATE, %DS_LOCALEDIT, %DS_SETFONT, %DS_MODALFRAME, %DS_NOIDLEMSG, %DS_SETFOREGROUND, %DS_CONTROL, %DS_CENTER, %DS_CENTERMOUSE, %DS_CONTEXTHELP, %DS_SETFOREGROUND, %WS_OVERLAPPED, %WS_POPUP, %WS_CHILD, %WS_MINIMIZE, %WS_VISIBLE, %WS_DISABLED, %WS_CLIPSIBLINGS, %WS_CLIPCHILDREN, %WS_MAXIMIZE, %WS_CAPTION, %WS_BORDER, %WS_DLGFRAME, %WS_VSCROLL, %WS_HSCROLL, %WS_SYSMENU, %WS_THICKFRAME, %WS_GROUP, %WS_TABSTOP, %WS_MINIMIZEBOX, %WS_MAXIMIZEBOX, %WS_TILED, %WS_ICONIC, %WS_SIZEBOX, %WS_OVERLAPPEDWIN, %WS_OVERLAPPEDWINDOW, %WS_TILEDWINDOW, %WS_POPUPWINDOW, %WS_CHILDWINDOW, %WS_EX_DLGMODALFRAME, %WS_EX_NOPARENTNOTIFY, %WS_EX_TOPMOST, %WS_EX_ACCEPTFILES, %WS_EX_TRANSPARENT, %WS_EX_TOOLWINDOW, %WS_EX_SMCAPTION, %WS_EX_WINDOWEDGE, %WS_EX_CLIENTEDGE, %WS_EX_CONTEXTHELP, %WS_EX_RIGHT, %WS_EX_LEFT, %WS_EX_RTLREADING, %WS_EX_LTRREADING, %WS_EX_LEFTSCROLLBAR, %WS_EX_RIGHTSCROLLBAR, %WS_EX_CONTROLPARENT, %WS_EX_STATICEDGE, %WS_EX_APPWINDOW, %WS_EX_OVERLAPPEDWINDOW, %WS_EX_PALETTEWINDOW, %WS_EX_LAYERED, %WS_EX_NOINHERITLAYOUT, %WS_EX_LAYOUTRTL, %WS_EX_COMPOSITED, %WS_EX_NOACTIVATE\n\r\n\rFor use with the DIALOG NEW statement:\n\r\n\r%HWND_DESKTOP, %DS_SHELLFONT\n\r\n\rFor use with the DIR$ function:\n\r\n\r%NORMAL, %HIDDEN, %SYSTEM, %VLABEL, %SUBDIR\n\r\n\rFor use with the DISPLAY BROWSE statement:\n\r\n\r%BIF_RETURNONLYFSDIRS, %BIF_DONTGOBELOWDOMAIN, %BIF_RETURNFSANCESTORS, %BIF_EDITBOX, %BIF_NEWDIALOGSTYLE, %BIF_USENEWUI, %BIF_BROWSEINCLUDEURLS, %BIF_UAHINT, %BIF_NONEWFOLDERBUTTON, %BIF_NOTRANSLATETARGETS, %BIF_BROWSEINCLUDEFILES, %BIF_SHAREABLE\n\r\n\rFor use with the DISPLAY COLOR statement:\n\r\n\r%CC_FULLOPEN, %CC_PREVENTFULLOPEN, %CC_SHOWHELP\n\r\n\rFor use with the DISPLAY FONT statement:\n\r\n\r%CF_SCREENFONTS, %CF_PRINTERFONTS, %CF_BOTH, %CF_SHOWHELP, %CF_INITTOLOGFONTSTRUCT, %CF_USESTYLE, %CF_EFFECTS, %CF_APPLY, %CF_ANSIONLY, %CF_SCRIPTSONLY, %CF_NOVECTORFONTS, %CF_NOSIMULATIONS, %CF_LIMITSIZE, %CF_FIXEDPITCHONLY, %CF_WYSIWYG, %CF_FORCEFONTEXIST, %CF_SCALABLEONLY, %CF_TTONLY, %CF_NOFACESEL, %CF_NOSTYLESEL, %CF_NOSIZESEL, %CF_SELECTSCRIPT, %CF_NOSCRIPTSEL, %CF_NOVERTFONTS\n\r\n\rFor use with the DISPLAY OPENFILE and DISPLAY SAVEFILE statements:\n\r\n\r%OFN_ALLOWMULTISELECT, %OFN_CREATEPROMPT, %OFN_DONTADDTORECENT, %OFN_ENABLESIZING, %OFN_EXPLORER, %OFN_EXTENSIONDIFFERENT, %OFN_FILEMUSTEXIST, %OFN_FORCESHOWHIDDEN, %OFN_HIDEREADONLY, %OFN_LONGNAMES, %OFN_NODEREFERENCELINKS, %OFN_NOLONGNAMES, %OFN_NONETWORKBUTTON, %OFN_NOREADONLYRETURN, %OFN_NOTESTFILECREATE, %OFN_NOVALIDATE, %OFN_OVERWRITEPROMPT, %OFN_PATHMUSTEXIST, %OFN_READONLY, %OFN_SHAREAWARE, %OFN_SHOWHELP\n\r\n\rFor use with ERR and ERRCLEAR:\n\r\n\r%ERR_NOERROR, %ERR_ILLEGALFUNCTIONCALL, %ERR_OVERFLOW (reserved), %ERR_OUTOFMEMORY, %ERR_SUBSCRIPTPOINTEROUTOFRANGE, %ERR_DIVISIONBYZERO (reserved), %ERR_DEVICETIMEOUT, %ERR_INTERNALERROR, %ERR_BADFILENAMEORNUMBER, %ERR_FILENOTFOUND, %ERR_BADFILEMODE, %ERR_FILEISOPEN, %ERR_DEVICEIOERROR, %ERR_FILEALREADYEXISTS, %ERR_DISKFULL, %ERR_INPUTPASTEND, %ERR_BADRECORDNUMBER, %ERR_BADFILENAME, %ERR_TOOMANYFILES, %ERR_DEVICEUNAVAILABLE, %ERR_COMMERROR, %ERR_PERMISSIONDENIED, %ERR_DISKNOTREADY, %ERR_DISKMEDIAERROR, %ERR_RENAMEACROSSDISKS, %ERR_PATHFILEACCESSERROR, %ERR_PATHNOTFOUND, %ERR_OBJECTERROR, %ERR_GLOBALMEMORYCORRUPT (formerly %ERR_FARHEAPCORRUPT), %ERR_STRINGSPACECORRUPT, %ERR_DIVISIONBYZERO, %ERR_FARHEAPCORRUPT, %ERR_GLOBALMEMORYCORRUPT, %ERR_OVERFLOW\n\r\n\rFor use with GRAPHIC COPY, GRAPHIC GET MIX, GRAPHIC SET MIX, GRAPHIC STRETCH, XPRINT COPY, XPRINT GET MIX, XPRINT SET MIX, and XPRINT STRETCH (some statements may accept only a subset of these equates):\n\r\n\r%MIX_BLACKNESS, %MIX_NOTMERGESRC, %MIX_MASKNOTSRC, %MIX_NOTCOPYSRC, %MIX_MASKSRCNOT, %MIX_NOT, %MIX_XORSRC, %MIX_NOTMASKSRC, %MIX_MASKSRC, %MIX_NOTXORSRC, %MIX_NOP, %MIX_MERGENOTSRC, %MIX_COPYSRC, %MIX_MERGESRCNOT, %MIX_MERGESRC, %MIX_WHITENESS, %BLACKONWHITE, %WHITEONBLACK, %COLORONCOLOR, %HALFTONE\n\r\n\rFor use with GRAPHIC IMAGELIST and XPRINT IMAGELIST:\n\r\n\r%ILD_NORMAL, %ILD_TRANSPARENT, %ILD_MASK, %ILD_BLEND25, %ILD_BLEND50, %ILD_IMAGE, %ILD_ROP, %ILD_OVERLAYMASK\n\r\n\rFor use with LABELS and GRAPHIC CONTROLS:\n\r\n\r%SS_LEFT, %SS_CENTER, %SS_RIGHT, %SS_ICON, %SS_BLACKRECT, %SS_GRAYRECT, %SS_WHITERECT, %SS_BLACKFRAME, %SS_GRAYFRAME, %SS_WHITEFRAME, %SS_USERITEM, %SS_SIMPLE, %SS_LEFTNOWORDWRAP, %SS_NOWORDWRAP, %SS_OWNERDRAW, %SS_BITMAP, %SS_ENHMETAFILE, %SS_ETCHEDHORZ, %SS_ETCHEDVERT, %SS_ETCHEDFRAME, %SS_REALSIZECONTROL, %SS_NOPREFIX, %SS_NOTIFY, %SS_CENTERIMAGE, %SS_RIGHTJUST, %SS_REALSIZEIMAGE, %SS_REALSIZE, %SS_SUNKEN, %SS_ENDELLIPSIS, %SS_PATHELLIPSIS, %SS_WORDELLIPSIS, %SS_ELLIPSISMASK\n\r\n\rFor use with HEADERS:\n\r\n\r%HDM_GETITEMCOUNT, %HDM_INSERTITEM, %HDM_INSERTITEMW, %HDM_DELETEITEM, %HDM_GETITEM, %HDM_GETITEMW, %HDM_SETITEM, %HDM_SETITEMW, %HDM_LAYOUT, %HDM_HITTEST, %HDM_GETITEMRECT, %HDM_SETIMAGELIST, %HDM_GETIMAGELIST, %HDM_ORDERTOINDEX, %HDM_CREATEDRAGIMAGE, %HDM_GETORDERARRAY, %HDM_SETORDERARRAY, %HDM_SETHOTDIVIDER, %HDM_SETBITMAPMARGIN, %HDM_GETBITMAPMARGIN, %HDM_SETUNICODEFORMAT, %HDM_GETUNICODEFORMAT, %HDM_SETFILTERCHANGETIMEOUT, %HDM_EDITFILTER, %HDM_CLEARFILTER, %HDN_FIRST, %HDN_ITEMCHANGING, %HDN_ITEMCHANGINGW, %HDN_ITEMCHANGED, %HDN_ITEMCHANGEDW, %HDN_ITEMCLICK, %HDN_ITEMCLICKW, %HDN_ITEMDBLCLICK, %HDN_ITEMDBLCLICKW, %HDN_DIVIDERDBLCLICK, %HDN_DIVIDERDBLCLICKW, %HDN_BEGINTRACK, %HDN_BEGINTRACKW, %HDN_ENDTRACK, %HDN_ENDTRACKW, %HDN_TRACK, %HDN_TRACKW, %HDN_GETDISPINFO, %HDN_GETDISPINFOW, %HDN_BEGINDRAG, %HDN_ENDDRAG, %HDN_FILTERCHANGE, %HDN_FILTERBTNCLICK, %HHT_NOWHERE, %HHT_ONHEADER, %HHT_ONDIVIDER, %HHT_ONDIVOPEN, %HHT_ONFILTER, %HHT_ONFILTERBUTTON, %HHT_ABOVE, %HHT_BELOW, %HHT_TORIGHT, %HHT_TOLEFT, %HDF_BITMAP, %HDF_BITMAP_ON_RIGHT, %HDF_CENTER, %HDF_IMAGE, %HDF_JUSTIFYMASK, %HDF_LEFT, %HDF_OWNERDRAW, %HDF_RIGHT, %HDF_RTLREADING, %HDF_SORTDOWN, %HDF_SORTUP, %HDF_STRING, %HDFT_HASNOVALUE, %HDFT_ISNUMBER, %HDFT_ISSTRING, %HDI_BITMAP, %HDI_DI_SETITEM, %HDI_FILTER, %HDI_FORMAT, %HDI_HEIGHT, %HDI_IMAGE, %HDI_LPARAM, %HDI_ORDER, %HDI_TEXT, %HDI_WIDTH, %HDS_BUTTONS, %HDS_DRAGDROP, %HDS_FILTERBAR, %HDS_FLAT, %HDS_FULLDRAG, %HDS_HIDDEN, %HDS_HORZ, %HDS_HOTTRACK\n\r\n\rFor use with LISTBOXES:\n\r\n\r%LBN_DBLCLK, %LBN_ERRSPACE, %LBN_KILLFOCUS, %LBN_SELCANCEL, %LBN_SELCHANGE, %LBN_SETFOCUS, %LBS_NOTIFY, %LBS_SORT, %LBS_NOREDRAW, %LBS_MULTIPLESEL, %LBS_OWNERDRAWFIXED, %LBS_OWNERDRAWVARIABLE, %LBS_HASSTRINGS, %LBS_USETABSTOPS, %LBS_NOINTEGRALHEIGHT, %LBS_MULTICOLUMN, %LBS_WANTKEYBOARDINPUT, %LBS_EXTENDEDSEL, %LBS_DISABLENOSCROLL, %LBS_NODATA, %LBS_NOSEL, %LBS_STANDARD\n\r\n\rFor use with LISTVIEWS:\n\r\n\r%LVN_BEGINDRAG, %LVN_BEGINLABELEDIT, %LVN_BEGINRDRAG, %LVN_COLUMNCLICK, %LVN_DELETEALLITEMS, %LVN_DELETEITEM, %LVN_ENDLABELEDIT, %LVN_GETDISPINFO, %LVN_INSERTITEM, %LVN_ITEMCHANGED, %LVN_ITEMCHANGING, %LVN_KEYDOWN, %LVN_SETDISPINFO, %LVS_ALIGNLEFT, %LVS_ALIGNTOP, %LVS_ALIGNMASK, %LVS_AUTOARRANGE, %LVS_EDITLABELS, %LVS_OWNERDRAWFIXED, %LVS_NOCOLUMNHEADER, %LVS_NOSORTHEADER, %LVS_ICON, %LVS_REPORT, %LVS_SMALLICON, %LVS_LIST, %LVS_TYPEMASK, %LVS_SINGLESEL, %LVS_SORTASCENDING, %LVS_SORTDESCENDING, %LVS_SHAREIMAGELISTS, %LVS_NOLABELWRAP, %LVS_EDITLABELS, %LVS_OWNERDATA, %LVS_NOSCROLL, %LVS_OWNERDRAWFIXED, %LVS_SHOWSELALWAYS, %LVS_EX_GRIDLINES, %LVS_EX_SUBITEMIMAGES, %LVS_EX_CHECKBOXES, %LVS_EX_TRACKSELECT, %LVS_EX_HEADERDRAGDROP, %LVS_EX_FULLROWSELECT, %LVS_EX_ONECLICKACTIVATE, %LVS_EX_TWOCLICKACTIVATE, %LVS_EX_FLATSB, %LVS_EX_REGIONAL, %LVS_EX_INFOTIP, %LVS_EX_UNDERLINEHOT, %LVS_EX_UNDERLINECOLD, %LVS_EX_MULTIWORKAREAS, %LVS_EX_LABELTIP, %LVS_EX_BORDERSELECT, %LVS_EX_DOUBLEBUFFER, %LVS_EX_HIDELABELS, %LVS_EX_SINGLEROW, %LVS_EX_SNAPTOGRID, %LVS_EX_SIMPLESELECT, %LVNI_ALL, %LVNI_FOCUSED, %LVNI_SELECTED, %LVNI_CUT, %LVNI_DROPHILITED, %LVNI_ABOVE, %LVNI_BELOW, %LVNI_TOLEFT, %LVNI_TORIGHT, %LVM_GETSELECTEDCOLUMN, %LVM_ISGROUPVIEWENABLED, %LVM_GETOUTLINECOLOR, %LVM_SETOUTLINECOLOR, %LVM_CANCELEDITLABEL, %LVM_MAPINDEXTOID, %LVM_MAPIDTOINDEX, %LVM_SETTILEVIEWINFO, %LVM_GETTILEVIEWINFO, %LVM_SETTILEINFO, %LVM_GETTILEINFO, %LVM_SETINSERTMARK, %LVM_GETINSERTMARK, %LVM_INSERTMARKHITTEST, %LVM_GETINSERTMARKRECT, %LVM_SETINSERTMARKCOLOR, %LVM_GETINSERTMARKCOLOR, %LVM_SETINFOTIP, %LVM_GETHOVERTIME, %LVM_SETTOOLTIPS, %LVM_GETTOOLTIPS, %LVM_SORTITEMSEX, %LVM_SETSELECTEDCOLUMN, %LVM_SETTILEWIDTH, %LVM_SETVIEW, %LVM_GETVIEW, %LVM_GETSUBITEMRECT, %LVM_SUBITEMHITTEST, %LVM_SETCOLUMNORDERARRAY, %LVM_GETCOLUMNORDERARRAY, %LVM_SETHOTITEM, %LVM_GETHOTITEM, %LVM_SETHOTCURSOR, %LVM_GETHOTCURSOR, %LVM_APPROXIMATEVIEWRECT, %LVM_GETSELECTIONMARK, %LVM_SETSELECTIONMARK. %LVM_SETBKIMAGE, %LVM_GETBKIMAGE, %LVM_SETHOVERTIME, %LVM_GETTOPINDEX, %LVM_GETCOUNTPERPAGE, %LVM_GETORIGIN, %LVM_UPDATE, %LVM_SETITEMSTATE, %LVM_GETITEMSTATE, %LVM_SETITEMTEXT, %LVM_GETITEMTEXT, %LVM_SETITEMCOUNT, %LVM_SORTITEMS, %LVM_SETITEMPOSITION32, %LVM_GETSELECTEDCOUNT, %LVM_GETITEMSPACING, %LVM_GETISEARCHSTRING, %LVM_SETICONSPACING, %LVM_SETEXTENDEDLISTVIEWSTYLE, %LVM_GETEXTENDEDLISTVIEWSTYLE, %LVM_ARRANGE, %LVM_EDITLABEL, %LVM_GETEDITCONTROL, %LVM_GETCOLUMN, %LVM_SETCOLUMN, %LVM_INSERTCOLUMN, %LVM_DELETECOLUMN, %LVM_GETCOLUMNWIDTH, %LVM_SETCOLUMNWIDTH, %LVM_GETHEADER, %LVM_CREATEDRAGIMAGE, %LVM_GETVIEWRECT, %LVM_GETTEXTCOLOR, %LVM_SETTEXTCOLOR, %LVM_GETTEXTBKCOLOR, %LVM_SETTEXTBKCOLOR, %LVM_GETITEM, %LVM_SETITEM, %LVM_INSERTITEM, %LVM_DELETEITEM, %LVM_DELETEALLITEMS, %LVM_GETCALLBACKMASK, %LVM_SETCALLBACKMASK, %LVM_GETNEXTITEM, %LVM_FINDITEM, %LVM_GETITEMRECT, %LVM_SETITEMPOSITION, %LVM_GETITEMPOSITION, %LVM_GETSTRINGWIDTH, %LVM_HITTEST, %LVM_ENSUREVISIBLE, %LVM_SCROLL, %LVM_REDRAWITEMS, %LVM_GETBKCOLOR, %LVM_SETBKCOLOR, %LVM_GETIMAGELIST, %LVM_SETIMAGELIST, %LVM_GETITEMCOUNT, %LVSIL_NORMAL, %LVSIL_SMALL, %LVSIL_STATE, %LVM_EDITLABELW, %LVM_ENABLEGROUPVIEW, %LVM_FINDITEMW, %LVM_GETBKIMAGEW, %LVM_GETGROUPINFO, %LVM_GETGROUPMETRICS, %LVM_GETISEARCHSTRINGW, %LVM_GETITEMTEXTW, %LVM_GETITEMW, %LVM_GETNUMBEROFWORKAREAS, %LVM_GETSTRINGWIDTHW, %LVM_GETWORKAREAS, %LVM_HASGROUP, %LVM_INSERTGROUP, %LVM_INSERTGROUPSORTED, %LVM_INSERTITEMW, %LVM_MOVEGROUP, %LVM_MOVEITEMTOGROUP, %LVM_REMOVEALLGROUPS, %LVM_REMOVEGROUP, %LVM_SETBKIMAGE, %LVM_SETBKIMAGEW, %LVM_SETCOLUMNW, %LVM_SETGROUPINFO, %LVM_SETGROUPMETRICS, %LVM_SETITEMTEXTW, %LVM_SETITEMW, %LVM_SETSELECTIONMARK, %LVM_SETWORKAREAS, %LVM_SORTGROUPS, %LVN_BEGINLABELEDITW, %LVN_ENDLABELEDITW, %LVN_GETDISPINFOW, %LVN_SETDISPINFOW\n\r\n\rFor use with MENU CONTEXT:\n\r\n\r%TPM_BOTTOMALIGN, %TPM_CENTERALIGN, %TPM_LEFTALIGN, %TPM_LEFTBUTTON, %TPM_RIGHTALIGN, %TPM_RIGHTBUTTON, %TPM_TOPALIGN, %TPM_VCENTERALIGN, %TPM_HORIZONTAL, %TPM_NONOTIFY, %TPM_RETURNCMD, %TPM_VERTICAL\n\r\n\rFor use with MENU ADD POPUP, MENU ADD STRING, MENU GET STATE, and MENU SET STATE:\n\r\n\r%MF_CHECKED, %MF_ENABLED, %MF_GRAYED, %MF_DISABLED, %MF_UNHILITE, %MF_HILITE, %MF_UNCHECKED, %MFS_CHECKED, %MFS_DEFAULT, %MFS_DISABLED, %MFS_ENABLED, %MFS_GRAYED, %MFS_HILITE, %MFS_UNCHECKED, %MFS_UNHILITE\n\r\n\rFor use with MSGBOX:\n\r\n\r%MB_OK, %MB_OKCANCEL, %MB_ABORTRETRYIGNORE, %MB_YESNOCANCEL, %MB_YESNO, %MB_RETRYCANCEL, %MB_CANCELTRYCONTINUE, %MB_ICONHAND, %MB_ICONQUESTION, %MB_ICONEXCLAMATION, %MB_ICONASTERISK, %MB_USERICON, %MB_ICONWARNING, %MB_ICONERROR, %MB_ICONINFORMATION, %MB_ICONSTOP, %MB_DEFBUTTON1, %MB_DEFBUTTON2, %MB_DEFBUTTON3, %MB_DEFBUTTON4, %MB_APPLMODAL, %MB_SYSTEMMODAL, %MB_TASKMODAL, %MB_HELP, %MB_NOFOCUS, %MB_SETFOREGROUND, %MB_DEFAULT_DESKTOP_ONLY, %MB_TOPMOST, %MB_RIGHT, %MB_RTLREADING, %MB_SERVICE_NOTIFICATION, %MB_SERVICE_NOTIFICATION_NT3X, %MB_TYPEMASK, %MB_ICONMASK, %MB_DEFMASK, %MB_MODEMASK, %MB_MISCMASK\n\r\n\rFor use with OBJRESULT and IDISPINFO:\n\r\n\r%S_OK, %S_FALSE, %E_UNEXPECTED, %E_NOTIMPL, %E_NOINTERFACE, %E_POINTER, %E_ABORT, %E_FAIL, %E_ACCESSDENIED, %E_HANDLE, %E_OUTOFMEMORY, %E_INVALIDARG, %DISP_E_ARRAYISLOCKED, %DISP_E_BADINDEX, %DISP_E_BADPARAMCOUNT, %DISP_E_BADVARTYPE, %DISP_E_EXCEPTION, %DISP_E_MEMBERNOTFOUND, %DISP_E_NONAMEDARGS, %DISP_E_OVERFLOW, %DISP_E_PARAMNOTFOUND, %DISP_E_TYPEMISMATCH, %DISP_E_UNKNOWNINTERFACE, %DISP_E_UNKNOWNLCID, %DISP_E_UNKNOWNNAME, %DISP_E_PARAMNOTOPTIONAL\n\r\n\rFor use with PowerArray:\n\r\n\r%VT_I2, %VT_UI4, %VT_I4, %VT_I8, %VT_R4, %VT_INT, %VT_R8, %VT_UINT, %VT_CY, %VT_PTR, %VT_DATE, %VT_USERDEFINED, %VT_BSTR, %VT_FILETIME, %VT_DISPATCH, %VT_ASTR, %VT_BOOL, %VT_STRINGFIX, %VT_VARIANT, %VT_WSTRINGFIX, %VT_UNKNOWN, %VT_STRINGZ, %VT_DECIMAL, %VT_WSTRINGZ, %VT_I1, %VT_TYPE, %VT_UI1, %VT_EXT, %VT_UI2, %VT_CURX\n\r\n\rFor use with PROCESS GET PRIORITY and PROCESS SET PRIORITY:\n\r\n\r%HIGH_PRIORITY_CLASS, %IDLE_PRIORITY_CLASS, %NORMAL_PRIORITY_CLASS, %REALTIME_PRIORITY_CLASS\n\r\n\rFor use with PROGRESSBARS:\n\r\n\r%PBS_SMOOTH, %PBS_VERTICAL\n\r\n\rFor use with SCROLLBARS::\n\r\n\r%SB_HORZ, %SB_VERT, %SB_CTL, %SB_BOTH, %SB_LINEUP, %SB_LINELEFT, %SB_LINEDOWN, %SB_LINERIGHT, %SB_PAGEUP, %SB_PAGELEFT, %SB_PAGEDOWN, %SB_PAGERIGHT, %SB_THUMBPOSITION, %SB_THUMBTRACK, %SB_TOP, %SB_LEFT, %SB_BOTTOM, %SB_RIGHT, %SB_ENDSCROLL, %SBS_HORZ, %SBS_VERT, %SBS_TOPALIGN, %SBS_LEFTALIGN, %SBS_BOTTOMALIGN, %SBS_RIGHTALIGN, %SBS_SIZEBOXTOPLEFTALIGN, %SBS_SIZEBOXBOTTOMRIGHTALIGN, %SBS_SIZEBOX, %SBS_SIZEGRIP, %SIF_RANGE, %SIF_PAGE, %SIF_POS, %SIF_DISABLENOSCROLL, %SIF_TRACKPOS, %SIF_ALL, %SBARS_SIZEGRIP, %SBARS_TOOLTIPS\n\r\n\rFor use with STATUSBARS:\n\r\n\r%SBT_OWNERDRAW, %SBT_NOBORDERS, %SBT_POPOUT, %SBT_RTLREADING, %SBT_TOOLTIPS, %SBT_NOTABPARSING\n\r\n\rFor use with TAB Controls:\n\r\n\r%TCHT_NOWHERE, %TCHT_ONITEMICON, %TCHT_ONITEMLABEL, %TCHT_ONITEM, %TCIF_TEXT, %TCIF_IMAGE, %TCIF_RTLREADING, %TCIF_PARAM, %TCIF_STATE, %TCIS_BUTTONPRESSED, %TCIS_HIGHLIGHTED, %TCN_KEYDOWN, %TCN_SELCHANGE, %TCN_SELCHANGING, %TCN_GETOBJECT, %TCN_FOCUSCHANGE, %TCS_SCROLLOPPOSITE, %TCS_FLATBUTTONS, %TCS_FORCEICONLEFT, %TCS_FORCELABELLEFT, %TCS_HOTTRACK, %TCS_TABS, %TCS_BUTTONS, %TCS_FIXEDWIDTH, %TCS_RAGGEDRIGHT, %TCS_FOCUSONBUTTONDOWN, %TCS_OWNERDRAWFIXED, %TCS_TOOLTIPS, %TCS_FOCUSNEVER, %TCS_EX_FLATSEPARATORS, %TCS_EX_REGISTERDROP\n\r\n\rFor use with TCP NOTIFY:\n\r\n\r%FD_ACCEPT, %FD_CLOSE, %FD_CONNECT, %FD_READ, %FD_WRITE\n\r\n\rFor use with TEXTBOXES:\n\r\n\r%EN_CHANGE, %EN_ERRSPACE, %EN_HSCROLL, %EN_KILLFOCUS, %EN_MAXTEXT, %EN_SETFOCUS, %EN_UPDATE, %EN_VSCROLL, %ES_LEFT, %ES_CENTER, %ES_RIGHT, %ES_MULTILINE, %ES_UPPERCASE, %ES_LOWERCASE, %ES_PASSWORD, %ES_AUTOVSCROLL, %ES_AUTOHSCROLL, %ES_NOHIDESEL, %ES_OEMCONVERT, %ES_READONLY, %ES_WANTRETURN, %ES_NUMBER, %EN_ALIGN_LTR_EC, %EN_ALIGN_RTL_EC\n\r\n\rFor use with THREAD GET PRIORITY and THREAD SET PRIORITY:\n\r\n\r%THREAD_PRIORITY_ABOVE_NORMAL, %THREAD_PRIORITY_BELOW_NORMAL, %THREAD_PRIORITY_HIGHEST, %THREAD_PRIORITY_IDLE, %THREAD_PRIORITY_LOWEST, %THREAD_PRIORITY_NORMAL, %THREAD_PRIORITY_TIME_CRITICAL\n\r\n\rFor use with TOOLBARS:\n\r\n\r%CCS_ADJUSTABLE, %CCS_BOTTOM, %CCS_LEFT, %CCS_NODIVIDER, %CCS_NOMOVEX, %CCS_NOMOVEY, %CCS_NOPARENTALIGN, %CCS_NORESIZE, %CCS_RIGHT, %CCS_TOP, %CCS_VERT, %BTNS_AUTOSIZE, %BTNS_BUTTON, %BTNS_CHECK, %BTNS_GROUP, %BTNS_CHECKGROUP, %BTNS_DROPDOWN, %BTNS_NOPREFIX, %BTNS_SEP, %BTNS_SHOWTEXT, %BTNS_WHOLEDROPDOWN, %TBSTYLE_AUTOSIZE, %TBSTYLE_BUTTON, %TBSTYLE_CHECK, %TBSTYLE_GROUP, %TBSTYLE_CHECKGROUP, %TBSTYLE_DROPDOWN, %TBSTYLE_SEP, %TBSTYLE_TOOLTIPS, %TBSTYLE_FLAT, %TBSTYLE_LIST, %TBSTYLE_TRANSPARENT, %TBSTYLE_WRAPABLE, %TBSTATE_CHECKED, %TBSTATE_DISABLED, %TBSTATE_ELLIPSES, %TBSTATE_ENABLED, %TBSTATE_HIDDEN, %TBSTATE_INDETERMINATE, %TBSTATE_MARKED, %TBSTATE_PRESSED, %TBSTATE_WRAP, %TBN_BEGINADJUST, %TBN_BEGINDRAG, %TBN_CUSTHELP, %TBN_ENDADJUST, %TBN_ENDDRAG, %TBN_GETBUTTONINFO, %TBN_QUERYDELETE, %TBN_QUERYINSERT, %TBN_RESET, %TBN_TOOLBARCHANGE, %TB_ADDBITMAP, %TB_ADDBUTTONS, %TB_ADDBUTTONSW, %TB_ADDSTRING, %TB_ADDSTRINGW, %TB_AUTOSIZE, %TB_BUTTONCOUNT, %TB_BUTTONSTRUCTSIZE, %TB_CHANGEBITMAP, %TB_CHECKBUTTON, %TB_COMMANDTOINDEX, %TB_CUSTOMIZE, %TB_DELETEBUTTON, %TB_ENABLEBUTTON, %TB_GETANCHORHIGHLIGHT, %TB_GETBITMAP, %TB_GETBUTTON, %TB_GETBUTTONINFO, %TB_GETBUTTONINFOW, %TB_GETBUTTONSIZE, %TB_GETBUTTONTEXT, %TB_GETBUTTONTEXTW, %TB_GETDISABLEDIMAGELIST, %TB_GETEXTENDEDSTYLE, %TB_GETHOTIMAGELIST, %TB_GETHOTITEM, %TB_GETIMAGELIST, %TB_GETINSERTMARK, %TB_GETINSERTMARKCOLOR, %TB_GETITEMRECT, %TB_GETMAXSIZE, %TB_GETMETRICS, %TB_GETOBJECT, %TB_GETPADDING, %TB_GETRECT, %TB_GETROWS, %TB_GETSTATE, %TB_GETSTRING, %TB_GETSTRINGW, %TB_GETSTYLE, %TB_GETTEXTROWS, %TB_GETTOOLTIPS, %TB_HIDEBUTTON, %TB_HITTEST, %TB_INDETERMINATE, %TB_INSERTBUTTON, %TB_INSERTBUTTONW, %TB_INSERTMARKHITTEST, %TB_ISBUTTONCHECKED, %TB_ISBUTTONENABLED, %TB_ISBUTTONHIDDEN, %TB_ISBUTTONHIGHLIGHTED, %TB_ISBUTTONINDETERMINATE, %TB_ISBUTTONPRESSED, %TB_LOADIMAGES, %TB_MAPACCELERATOR, %TB_MAPACCELERATORW, %TB_MARKBUTTON, %TB_MOVEBUTTON, %TB_PRESSBUTTON, %TB_REPLACEBITMAP, %TB_SAVERESTORE, %TB_SAVERESTOREW, %TB_SETANCHORHIGHLIGHT, %TB_SETBITMAPSIZE, %TB_SETBUTTONINFO, %TB_SETBUTTONINFOW, %TB_SETBUTTONSIZE, %TB_SETBUTTONWIDTH, %TB_SETCMDID, %TB_SETDISABLEDIMAGELIST, %TB_SETDRAWTEXTFLAGS, %TB_SETEXTENDEDSTYLE, %TB_SETHOTIMAGELIST, %TB_SETHOTITEM, %TB_SETIMAGELIST, %TB_SETINDENT, %TB_SETINSERTMARK, %TB_SETINSERTMARKCOLOR, %TB_SETMAXTEXTROWS, %TB_SETMETRICS, %TB_SETPADDING, %TB_SETPARENT, %TB_SETROWS, %TB_SETSTATE, %TB_SETSTYLE, %TB_SETTOOLTIPS, %TBN_GETBUTTONINFOW, %TBSTYLE_ALTDRAG, %TBSTYLE_CUSTOMERASE, %TBSTYLE_EX_DOUBLEBUFFER, %TBSTYLE_EX_DRAWDDARROWS, %TBSTYLE_EX_HIDECLIPPEDBUTTONS, %TBSTYLE_EX_MIXEDBUTTONS, %TBSTYLE_NOPREFIX, %TBSTYLE_REGISTERDROP\n\r\n\rFor use with TREEVIEWS:\n\r\n\r%TVS_HASBUTTONS, %TVS_HASLINES, %TVS_LINESATROOT, %TVS_EDITLABELS, %TVS_DISABLEDRAGDROP, %TVS_SHOWSELALWAYS, %TVS_RTLREADING, %TVS_NOTOOLTIPS, %TVS_CHECKBOXES, %TVS_TRACKSELECT, %TVS_SINGLEEXPAND, %TVS_INFOTIP, %TVS_FULLROWSELECT, %TVS_NOSCROLL, %TVS_NONEVENHEIGHT, %TVS_NOHSCROLL, %TVI_ROOT, %TVI_FIRST, %TVI_LAST, %TVI_SORT, %TVE_COLLAPSE, %TVE_EXPAND, %TVE_TOGGLE, %TVE_EXPANDPARTIAL, %TVE_COLLAPSERESET, %TVN_BEGINDRAG, %TVN_BEGINLABELEDIT, %TVN_BEGINRDRAG, %TVN_DELETEITEM, %TVN_ENDLABELEDIT, %TVN_GETDISPINFO, %TVN_ITEMEXPANDED, %TVN_ITEMEXPANDING, %TVN_KEYDOWN, %TVN_SELCHANGED, %TVN_SELCHANGING, %TVN_SETDISPINFO, %TVN_BEGINDRAGW, %TVN_BEGINLABELEDITW, %TVN_BEGINRDRAGW, %TVN_DELETEITEMW, %TVN_ENDLABELEDITW, %TVN_GETDISPINFOW, %TVN_ITEMEXPANDEDW, %TVN_ITEMEXPANDINGW, %TVN_SELCHANGEDW, %TVN_SELCHANGINGW, %TVN_SETDISPINFOW\n\r\n\rFor use with VARIANTVT:\n\r\n\r%VT_EMPTY, %VT_NULL, %VT_I2, %VT_I4, %VT_R4, %VT_R8, %VT_CY, %VT_DATE, %VT_BSTR, %VT_DISPATCH, %VT_ERROR, %VT_BOOL, %VT_VARIANT, %VT_DECIMAL, %VT_UNKNOWN, %VT_I1, %VT_UI1, %VT_UI2, %VT_UI4, %VT_I8, %VT_UI8, %VT_INT, %VT_UINT, %VT_VOID, %VT_HRESULT, %VT_PTR, %VT_SAFEARRAY, %VT_CARRAY, %VT_USERDEFINED, %VT_LPSTR, %VT_LPWSTR, %VT_RECORD, %VT_FILETIME, %VT_BLOB, %VT_STREAM, %VT_STORAGE, %VT_STREAMED_OBJECT, %VT_STORED_OBJECT, %VT_BLOB_OBJECT, %VT_CF, %VT_CLSID, %VT_VECTOR, %VT_ARRAY, %VT_BYREF\n\r\n\rFor use with XPRINT ATTACH CHOOSE:\n\r\n\r%PD_ALLPAGES, %PD_SELECTION, %PD_PAGENUMS, %PD_NOSELECTION, %PD_NOPAGENUMS, %PD_COLLATE, %PD_PRINTTOFILE, %PD_PRINTSETUP, %PD_NOWARNING, %PD_RETURNDC, %PD_RETURNIC, %PD_RETURNDEFAULT, %PD_SHOWHELP, %PD_ENABLEPRINTHOOK, %PD_ENABLESETUPHOOK, %PD_ENABLEPRINTTEMPLATE, %PD_ENABLESETUPTEMPLATE, %PD_ENABLEPRINTTEMPLATEHANDLE, %PD_ENABLESETUPTEMPLATEHANDLE, %PD_USEDEVMODECOPIES, %PD_USEDEVMODECOPIESANDCOLLATE, %PD_DISABLEPRINTTOFILE, %PD_HIDEPRINTTOFILE, %PD_NONETWORKBUTTON, %PD_CURRENTPAGE, %PD_NOCURRENTPAGE, %PD_EXCLUSIONFLAGS, %PD_USELARGETEMPLATE, %PD_RESULT_CANCEL, %PD_RESULT_PRINT, %PD_RESULT_APPLY, %PDERR_PRINTERCODES, %PDERR_SETUPFAILURE, %PDERR_PARSEFAILURE, %PDERR_RETDEFFAILURE, %PDERR_LOADDRVFAILURE, %PDERR_GETDEVMODEFAIL, %PDERR_INITFAILURE, %PDERR_NODEVICES, %PDERR_NODEFAULTPRN, %PDERR_DNDMMISMATCH, %PDERR_CREATEICFAILURE, %PDERR_PRINTERNOTFOUND, %PDERR_DEFAULTDIFFERENT\n\r\n\rFor use with the XPRINT GET COLLATE and XPRINT SET COLLATE statements:\n\r\n\r%DMCOLLATE_FALSE, %DMCOLLATE_TRUE\n\r\n\rFor use with the XPRINT GET COLORMODE and XPRINT SET COLORMODE statements:\n\r\n\r%DMCOLOR_MONOCHROME, %DMCOLOR_COLOR\n\r\n\rFor use with the XPRINT GET DUPLEX and XPRINT SET DUPLEX statements:\n\r\n\r%DMDUP_SIMPLEX, %DMDUP_VERTICAL, %DMDUP_HORIZONTAL\n\r\n\rFor use with the XPRINT GET PAPER, XPRINT GET PAPERS, and XPRINT SET PAPER statements:\n\r\n\r%DMPAPER_LETTER, %DMPAPER_TABLOID, %DMPAPER_LEDGER, %DMPAPER_LEGAL, %DMPAPER_STATEMENT, %DMPAPER_EXECUTIVE, %DMPAPER_A3, %DMPAPER_A4, %DMPAPER_A5, %DMPAPER_B4, %DMPAPER_B5, %DMPAPER_FOLIO, %DMPAPER_QUARTO, %DMPAPER_10X14, %DMPAPER_11X17, %DMPAPER_NOTE, %DMPAPER_ENV_9, %DMPAPER_ENV_10\n\r\n\rFor use with the XPRINT GET TRAY, XPRINT GET TRAYS, and XPRINT SET TRAY statements:\n\r\n\r%DMBIN_UPPER, %DMBIN_LOWER, %DMBIN_MIDDLE, %DMBIN_MANUAL, %DMBIN_ENVELOPE, %DMBIN_ENVMANUAL, %DMBIN_AUTO, %DMBIN_TRACTOR, %DMBIN_SMALLFMT, %DMBIN_LARGEFMT, %DMBIN_LARGECAPACITY, %DMBIN_CASSETTE, %DMBIN_FORMSOURCE\n\r\n\rFor use with Miscellaneous API routines:\n\r\n\r%BIF_VALIDATE, %CF_BITMAP, %CF_DIB, %CF_DIBV5, %CF_DIF, %CF_ENHMETAFILE, %CF_HDROP, %CF_LOCALE, %CF_METAFILEPICT, %CF_OEMTEXT, %CF_PALETTE, %CF_PENDATA, %CF_RIFF, %CF_SYLK, %CF_TEXT, %CF_TIFF, %CF_UNICODETEXT, %CF_WAVE, %CS_BYTEALIGNCLIENT, %CS_BYTEALIGNWINDOW, %CS_CLASSDC, %CS_DBLCLKS, %CS_DROPSHADOW, %CS_GLOBALCLASS, %CS_HREDRAW, %CS_IME, %CS_KEYCVTWINDOW, %CS_NOCLOSE, %CS_NOKEYCVT, %CS_OWNDC, %CS_PARENTDC, %CS_SAVEBITS, %CS_VREDRAW, %MAX_FNAME, %MAX_PATH, %MAXIMUM_WAIT_OBJECTS, %OFN_NOCHANGEDIR, %SND_ALIAS, %SND_ALIAS_ID, %SND_APPLICATION, %SND_ASYNC, %SND_FILENAME, %SND_LOOP, %SND_MEMORY, %SND_NODEFAULT, %SND_NOSTOP, %SND_NOWAIT, %SND_PURGE, %SND_RESOURCE, %SND_VALID, %TCS_BOTTOM, %TCS_MULTILINE, %TCS_MULTISELECT, %TCS_RIGHT, %TCS_RIGHTJUSTIFY, %TCS_SINGLELINE, %TCS_VERTICAL, %WS_EX_MDICHILD\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rBuilt-in RGB Color Equates\n\r\n\rConstants and Literals\n\r\n\rNumeric Equates\n\r\n\rString Equates\n\r\n\rBuilt-in string equates\n\r\n\rBuilt-in Interfaces\n\r\n\rBuilt-in User Defined Types","Built-in numeric equates","scr\\html_built_in_numeric_equates.htm","                  \n\r\n\rThe following is a list of RGB color equates built into the compiler, which can be used with routines that accept RGB color values.\n\r\n\rRed Colors\n\r\n\r%RGB_INDIANRED\n\r\n\r= &amp;H5C5CCD\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTCORAL\n\r\n\r= &amp;H8080F0\n\r\n\r&nbsp;\n\r\n\r%RGB_SALMON\n\r\n\r= &amp;H7280FA\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKSALMON\n\r\n\r= &amp;H7A96E9\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTSALMON\n\r\n\r= &amp;H7AA0FF\n\r\n\r&nbsp;\n\r\n\r%RGB_CRIMSON  \n\r\n\r= &amp;H3C14DC\n\r\n\r&nbsp;\n\r\n\r%RGB_RED  \n\r\n\r= &amp;H0000FF\n\r\n\r&nbsp;\n\r\n\r%RGB_FIREBRICK\n\r\n\r= &amp;H2222B2\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKRED\n\r\n\r= &amp;H00008B\n\r\n\r&nbsp;\n\r\n\rPink Colors\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\r%RGB_PINK\n\r\n\r= &amp;HCBC0FF\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTPINK\n\r\n\r= &amp;HC1B6FF\n\r\n\r&nbsp;\n\r\n\r%RGB_HOTPINK\n\r\n\r= &amp;HB469FF\n\r\n\r&nbsp;\n\r\n\r%RGB_DEEPPINK\n\r\n\r= &amp;H9314FF\n\r\n\r&nbsp;\n\r\n\r%RGB_MEDIUMVIOLETRED\n\r\n\r= &amp;H8515C7\n\r\n\r&nbsp;\n\r\n\r%RGB_PALEVIOLETRED\n\r\n\r= &amp;H9370DB\n\r\n\r&nbsp;\n\r\n\rOrange Colors\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTSALMON\n\r\n\r= &amp;H7AA0FF\n\r\n\r&nbsp;\n\r\n\r%RGB_CORAL\n\r\n\r= &amp;H507FFF\n\r\n\r&nbsp;\n\r\n\r%RGB_TOMATO\n\r\n\r= &amp;H4763FF\n\r\n\r&nbsp;\n\r\n\r%RGB_ORANGERED\n\r\n\r= &amp;H0045FF\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKORANGE\n\r\n\r= &amp;H008CFF\n\r\n\r&nbsp;\n\r\n\r%RGB_ORANGE\n\r\n\r= &amp;H00A5FF\n\r\n\r&nbsp;\n\r\n\rYellow Colors\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\r%RGB_GOLD\n\r\n\r= &amp;H00D7FF\n\r\n\r&nbsp;\n\r\n\r%RGB_YELLOW\n\r\n\r= &amp;H00FFFF\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTYELLOW\n\r\n\r= &amp;HE0FFFF\n\r\n\r&nbsp;\n\r\n\r%RGB_LEMONCHIFFON\n\r\n\r= &amp;HCDFAFF\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTGOLDENRODYELLOW\n\r\n\r= &amp;HD2FAFA\n\r\n\r&nbsp;\n\r\n\r%RGB_PAPAYAWHIP\n\r\n\r= &amp;HD5EFFF\n\r\n\r&nbsp;\n\r\n\r%RGB_MOCCASIN\n\r\n\r= &amp;HB5E4FF\n\r\n\r&nbsp;\n\r\n\r%RGB_PEACHPUFF\n\r\n\r= &amp;HB9DAFF\n\r\n\r&nbsp;\n\r\n\r%RGB_PALEGOLDENROD\n\r\n\r= &amp;HAAE8EE\n\r\n\r&nbsp;\n\r\n\r%RGB_KHAKI\n\r\n\r= &amp;H8CE6F0\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKKHAKI\n\r\n\r= &amp;H6BB7BD\n\r\n\r&nbsp;\n\r\n\rPurple Colors\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\r%RGB_LAVENDER  \n\r\n\r= &amp;HFAE6E6\n\r\n\r&nbsp;\n\r\n\r%RGB_THISTLE\n\r\n\r= &amp;HD8BFD8\n\r\n\r&nbsp;\n\r\n\r%RGB_PLUM\n\r\n\r= &amp;HDDA0DD\n\r\n\r&nbsp;\n\r\n\r%RGB_VIOLET\n\r\n\r= &amp;HEE82EE\n\r\n\r&nbsp;\n\r\n\r%RGB_ORCHID\n\r\n\r= &amp;HD670DA\n\r\n\r&nbsp;\n\r\n\r%RGB_MAGENTA\n\r\n\r= &amp;HFF00FF\n\r\n\r&nbsp;\n\r\n\r%RGB_MEDIUMORCHID\n\r\n\r= &amp;HD355BA\n\r\n\r&nbsp;\n\r\n\r%RGB_MEDIUMPURPLE\n\r\n\r= &amp;HDB7093\n\r\n\r&nbsp;\n\r\n\r%RGB_BLUEVIOLET  \n\r\n\r= &amp;HE22B8A\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKVIOLET\n\r\n\r= &amp;HD30094\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKORCHID  \n\r\n\r= &amp;HCC3299\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKMAGENTA\n\r\n\r= &amp;H8B008B\n\r\n\r&nbsp;\n\r\n\r%RGB_PURPLE\n\r\n\r= &amp;H800080\n\r\n\r&nbsp;\n\r\n\r%RGB_INDIGO\n\r\n\r= &amp;H82004B\n\r\n\r&nbsp;\n\r\n\r%RGB_SLATEBLUE\n\r\n\r= &amp;HCD5A6A\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKSLATEBLUE\n\r\n\r= &amp;H8B3D48\n\r\n\r&nbsp;\n\r\n\r%RGB_MEDIUMSLATEBLUE\n\r\n\r= &amp;HEE687B\n\r\n\r&nbsp;\n\r\n\rGreen Colors\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\r%RGB_GREENYELLOW\n\r\n\r= &amp;H2FFFAD\n\r\n\r&nbsp;\n\r\n\r%RGB_CHARTREUSE\n\r\n\r= &amp;H00FF7F\n\r\n\r&nbsp;\n\r\n\r%RGB_LAWNGREEN\n\r\n\r= &amp;H00FC7C\n\r\n\r&nbsp;\n\r\n\r%RGB_LIME\n\r\n\r= &amp;H00FF00\n\r\n\r&nbsp;\n\r\n\r%RGB_LIMEGREEN\n\r\n\r= &amp;H32CD32\n\r\n\r&nbsp;\n\r\n\r%RGB_PALEGREEN\n\r\n\r= &amp;H98FB98\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTGREEN\n\r\n\r= &amp;H90EE90\n\r\n\r&nbsp;\n\r\n\r%RGB_MEDIUMSPRINGGREEN\n\r\n\r= &amp;H9AFA00\n\r\n\r&nbsp;\n\r\n\r%RGB_SPRINGGREEN\n\r\n\r= &amp;H7FFF00\n\r\n\r&nbsp;\n\r\n\r%RGB_MEDIUMSEAGREEN\n\r\n\r= &amp;H71B33C\n\r\n\r&nbsp;\n\r\n\r%RGB_SEAGREEN\n\r\n\r= &amp;H578B2E\n\r\n\r&nbsp;\n\r\n\r%RGB_FORESTGREEN\n\r\n\r= &amp;H228B22\n\r\n\r&nbsp;\n\r\n\r%RGB_GREEN\n\r\n\r= &amp;H008000\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKGREEN\n\r\n\r= &amp;H006400\n\r\n\r&nbsp;\n\r\n\r%RGB_YELLOWGREEN\n\r\n\r= &amp;H32CD9A\n\r\n\r&nbsp;\n\r\n\r%RGB_OLIVEDRAB\n\r\n\r= &amp;H238E6B\n\r\n\r&nbsp;\n\r\n\r%RGB_OLIVE\n\r\n\r= &amp;H008080\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKOLIVEGREEN\n\r\n\r= &amp;H2F6B55\n\r\n\r&nbsp;\n\r\n\r%RGB_MEDIUMAQUAMARINE\n\r\n\r= &amp;HAACD66\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKSEAGREEN\n\r\n\r= &amp;H8FBC8F\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTSEAGREEN\n\r\n\r= &amp;HAAB220\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKCYAN\n\r\n\r= &amp;H8B8B00\n\r\n\r&nbsp;\n\r\n\r%RGB_TEAL\n\r\n\r= &amp;H808000\n\r\n\r&nbsp;\n\r\n\rBlue Colors\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\r%RGB_CYAN\n\r\n\r= &amp;HFFFF00\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTCYAN\n\r\n\r= &amp;HFFFFE0\n\r\n\r&nbsp;\n\r\n\r%RGB_PALETURQUOISE\n\r\n\r= &amp;HEEEEAF\n\r\n\r&nbsp;\n\r\n\r%RGB_AQUAMARINE\n\r\n\r= &amp;HD4FF7F\n\r\n\r&nbsp;\n\r\n\r%RGB_TURQUOISE\n\r\n\r= &amp;HD0E040\n\r\n\r&nbsp;\n\r\n\r%RGB_MEDIUMTURQUOISE\n\r\n\r= &amp;HCCD148\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKTURQUOISE\n\r\n\r= &amp;HD1CE00\n\r\n\r&nbsp;\n\r\n\r%RGB_CADETBLUE\n\r\n\r= &amp;HA09E5F\n\r\n\r&nbsp;\n\r\n\r%RGB_STEELBLUE\n\r\n\r= &amp;HB48246\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTSTEELBLUE\n\r\n\r= &amp;HDEC4B0\n\r\n\r&nbsp;\n\r\n\r%RGB_POWDERBLUE\n\r\n\r= &amp;HE6E0B0\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTBLUE\n\r\n\r= &amp;HE6D8AD\n\r\n\r&nbsp;\n\r\n\r%RGB_SKYBLUE\n\r\n\r= &amp;HEBCE87\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTSKYBLUE\n\r\n\r= &amp;HFACE87\n\r\n\r&nbsp;\n\r\n\r%RGB_DEEPSKYBLUE\n\r\n\r= &amp;HFFBF00\n\r\n\r&nbsp;\n\r\n\r%RGB_DODGERBLUE\n\r\n\r= &amp;HFF901E\n\r\n\r&nbsp;\n\r\n\r%RGB_CORNFLOWERBLUE\n\r\n\r= &amp;HED9564\n\r\n\r&nbsp;\n\r\n\r%RGB_MEDIUMSLATEBLUE\n\r\n\r= &amp;HEE687B\n\r\n\r&nbsp;\n\r\n\r%RGB_ROYALBLUE\n\r\n\r= &amp;HE16941\n\r\n\r&nbsp;\n\r\n\r%RGB_BLUE\n\r\n\r= &amp;HFF0000\n\r\n\r&nbsp;\n\r\n\r%RGB_MEDIUMBLUE\n\r\n\r= &amp;HCD0000\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKBLUE  \n\r\n\r= &amp;H8B0000\n\r\n\r&nbsp;\n\r\n\r%RGB_NAVY  \n\r\n\r= &amp;H800000\n\r\n\r&nbsp;\n\r\n\r%RGB_MIDNIGHTBLUE\n\r\n\r= &amp;H701919\n\r\n\r&nbsp;\n\r\n\rBrown Colors\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\r%RGB_CORNSILK\n\r\n\r= &amp;HDCF8FF\n\r\n\r&nbsp;\n\r\n\r%RGB_BLANCHEDALMOND\n\r\n\r= &amp;HCDEBFF\n\r\n\r&nbsp;\n\r\n\r%RGB_BISQUE\n\r\n\r= &amp;HC4E4FF\n\r\n\r&nbsp;\n\r\n\r%RGB_NAVAJOWHITE\n\r\n\r= &amp;HADDEFF\n\r\n\r&nbsp;\n\r\n\r%RGB_WHEAT\n\r\n\r= &amp;HB3DEF5\n\r\n\r&nbsp;\n\r\n\r%RGB_BURLYWOOD\n\r\n\r= &amp;H87B8DE\n\r\n\r&nbsp;\n\r\n\r%RGB_TAN  \n\r\n\r= &amp;H8CB4D2\n\r\n\r&nbsp;\n\r\n\r%RGB_ROSYBROWN\n\r\n\r= &amp;H8F8FBC\n\r\n\r&nbsp;\n\r\n\r%RGB_SANDYBROWN\n\r\n\r= &amp;H60A4F4\n\r\n\r&nbsp;\n\r\n\r%RGB_GOLDENROD\n\r\n\r= &amp;H20A5DA\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKGOLDENROD\n\r\n\r= &amp;H0B86B8\n\r\n\r&nbsp;\n\r\n\r%RGB_PERU\n\r\n\r= &amp;H3F85CD\n\r\n\r&nbsp;\n\r\n\r%RGB_CHOCOLATE  \n\r\n\r= &amp;H1E69D2\n\r\n\r&nbsp;\n\r\n\r%RGB_SADDLEBROWN\n\r\n\r= &amp;H13458B\n\r\n\r&nbsp;\n\r\n\r%RGB_SIENNA\n\r\n\r= &amp;H2D52A0\n\r\n\r&nbsp;\n\r\n\r%RGB_BROWN\n\r\n\r= &amp;H2A2AA5\n\r\n\r&nbsp;\n\r\n\r%RGB_MAROON\n\r\n\r= &amp;H000080\n\r\n\r&nbsp;\n\r\n\rWhite Colors\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\r%RGB_WHITE\n\r\n\r= &amp;HFFFFFF\n\r\n\r&nbsp;\n\r\n\r%RGB_SNOW\n\r\n\r= &amp;HFAFAFF\n\r\n\r&nbsp;\n\r\n\r%RGB_HONEYDEW\n\r\n\r= &amp;HF0FFF0\n\r\n\r&nbsp;\n\r\n\r%RGB_MINTCREAM\n\r\n\r= &amp;HFAFFF5\n\r\n\r&nbsp;\n\r\n\r%RGB_AZURE\n\r\n\r= &amp;HFFFFF0\n\r\n\r&nbsp;\n\r\n\r%RGB_ALICEBLUE\n\r\n\r= &amp;HFFF8F0\n\r\n\r&nbsp;\n\r\n\r%RGB_GHOSTWHITE\n\r\n\r= &amp;HFFF8F8\n\r\n\r&nbsp;\n\r\n\r%RGB_WHITESMOKE\n\r\n\r= &amp;HF5F5F5\n\r\n\r&nbsp;\n\r\n\r%RGB_SEASHELL\n\r\n\r= &amp;HEEF5FF\n\r\n\r&nbsp;\n\r\n\r%RGB_BEIGE  \n\r\n\r= &amp;HDCF5F5\n\r\n\r&nbsp;\n\r\n\r%RGB_OLDLACE\n\r\n\r= &amp;HE6F5FD\n\r\n\r&nbsp;\n\r\n\r%RGB_FLORALWHITE\n\r\n\r= &amp;HF0FAFF\n\r\n\r&nbsp;\n\r\n\r%RGB_IVORY\n\r\n\r= &amp;HF0FFFF\n\r\n\r&nbsp;\n\r\n\r%RGB_ANTIQUEWHITE\n\r\n\r= &amp;HD7EBFA\n\r\n\r&nbsp;\n\r\n\r%RGB_LINEN\n\r\n\r= &amp;HE6F0FA\n\r\n\r&nbsp;\n\r\n\r%RGB_LAVENDERBLUSH\n\r\n\r= &amp;HF5F0FF\n\r\n\r&nbsp;\n\r\n\r%RGB_MISTYROSE\n\r\n\r= &amp;HE1E4FF\n\r\n\r&nbsp;\n\r\n\rGray Colors\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\r%RGB_GAINSBORO\n\r\n\r= &amp;HDCDCDC\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTGRAY\n\r\n\r= &amp;HD3D3D3\n\r\n\r&nbsp;\n\r\n\r%RGB_SILVER\n\r\n\r= &amp;HC0C0C0\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKGRAY\n\r\n\r= &amp;HA9A9A9\n\r\n\r&nbsp;\n\r\n\r%RGB_GRAY\n\r\n\r= &amp;H808080\n\r\n\r&nbsp;\n\r\n\r%RGB_DIMGRAY\n\r\n\r= &amp;H696969\n\r\n\r&nbsp;\n\r\n\r%RGB_LIGHTSLATEGRAY\n\r\n\r= &amp;H998877\n\r\n\r&nbsp;\n\r\n\r%RGB_SLATEGRAY\n\r\n\r= &amp;H908070\n\r\n\r&nbsp;\n\r\n\r%RGB_DARKSLATEGRAY  \n\r\n\r= &amp;H4F4F2F\n\r\n\r&nbsp;\n\r\n\r%RGB_BLACK\n\r\n\r= &amp;H000000\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rBuilt-in numeric equates\n\r\n\rBuilt-in string equates &nbsp; &nbsp;  \n\r\n\rBuilt-in Interfaces &nbsp; &nbsp; \n\r\n\rBuilt-in User Defined Types\n\r\n\rConstants and Literals\n\r\n\rNumeric Equates\n\r\n\rString Equates","Built In RGB Color Equates","scr\\html_built_in_rgb_color_equates_.htm","                  \n\r\n\rThe compiler also provides a set of built-in string equates. These offer convenience as well as self-documentation.\n\r\n\rThe following table shows the ANSI form, each of which begins with a single dollar-sign ($). The compiler also includes and offers a wide Unicode version of each of them, identified by a double dollar-sign ($$). For example, $NUL returns a byte with the character code zero (0), while $$NUL returns a word with the character code zero (0).\n\r\n\r&nbsp;\n\r\n\rANSI\n\r\n\rCharacter(s)\n\r\n\rDefinition\n\r\n\r$NUL\n\r\n\rCHR$(0)\n\r\n\rNull\n\r\n\r$BEL\n\r\n\rCHR$(7)\n\r\n\rBell\n\r\n\r$BS\n\r\n\rCHR$(8)\n\r\n\rBack Space\n\r\n\r$TAB\n\r\n\rCHR$(9)\n\r\n\rHorizontal Tab\n\r\n\r$LF\n\r\n\rCHR$(10)\n\r\n\rLine Feed\n\r\n\r$VT\n\r\n\rCHR$(11)\n\r\n\rVertical Tab\n\r\n\r$FF\n\r\n\rCHR$(12)\n\r\n\rForm Feed\n\r\n\r$CR\n\r\n\rCHR$(13)\n\r\n\rCarriage Return\n\r\n\r$CRLF\n\r\n\rCHR$(13,10)\n\r\n\rCR and LF\n\r\n\r$EOF\n\r\n\rCHR$(26)\n\r\n\rEnd-of-File\n\r\n\r$ESC\n\r\n\rCHR$(27)\n\r\n\rEscape\n\r\n\r$SPC\n\r\n\rCHR$(32)\n\r\n\rSpace\n\r\n\r$DQ\n\r\n\rCHR$(34)\n\r\n\rDouble-Quote\n\r\n\r$DQ2\n\r\n\rCHR$(34,34)\n\r\n\rTwo Double-Quotes (&quot;&quot;)\n\r\n\r$SQ\n\r\n\rCHR$(39)\n\r\n\rSingle-Quote\n\r\n\r$SQ2\n\r\n\rCHR$(39,39)\n\r\n\rTwo Single-Quotes (\'\')\n\r\n\r$QCQ\n\r\n\rCHR$(34, 44, 34)\n\r\n\rDouble-Quote, Comma, Double-Quote\n\r\n\r$WHITESPACE\n\r\n\rCHR$(32, 9, 13, 10)\n\r\n\rSpace, Tab, CR, LF\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rConstants and Literals\n\r\n\rNumeric Equates\n\r\n\rBuilt-in numeric equates\n\r\n\rBuilt-in string equates\n\r\n\rString Equates\n\r\n\rBuilt-in Interfaces\n\r\n\rBuilt-in User Defined Types\n\r\n\rBuilt-in RGB Color Equates","Built-in string equates","scr\\html_built_in_string_equates.htm","                  \n\r\n\rThe compiler provides a set of built-in User-Defined Types, including:\n\r\n\rTYPE DispParams\n\r\n\r &nbsp;VariantArgs AS VARIANT\n\r\n\r &nbsp;NamedDispID AS VARIANT\n\r\n\r &nbsp;CountArgs &nbsp; AS DWORD\n\r\n\r &nbsp;CountNamed &nbsp;AS DWORD\n\r\n\rEND TYPE\n\r\n\rDispParams is used internally by the compiler to send parameters to Dispatch methods and properties.\n\r\n\r&nbsp;\n\r\n\rTYPE DirData\n\r\n\r &nbsp;FileAttributes AS DWORD\n\r\n\r &nbsp;CreationTime &nbsp; AS QUAD\n\r\n\r &nbsp;LastAccessTime AS QUAD\n\r\n\r &nbsp;LastWriteTime &nbsp;AS QUAD\n\r\n\r &nbsp;FileSizeHigh &nbsp; AS DWORD\n\r\n\r &nbsp;FileSizeLow &nbsp; &nbsp;AS DWORD\n\r\n\r &nbsp;Reserved0 &nbsp; &nbsp; &nbsp;AS DWORD\n\r\n\r &nbsp;Reserved1 &nbsp; &nbsp; &nbsp;AS DWORD\n\r\n\r &nbsp;FileName &nbsp; &nbsp; &nbsp; AS WStringZ * 260\n\r\n\r &nbsp;ShortName &nbsp; &nbsp; &nbsp;AS WStringZ * &nbsp;14\n\r\n\rEND TYPE\n\r\n\rDirData is used with the DIR$ function to retrieve file or directory information.\n\r\n\r&nbsp;\n\r\n\rTYPE Point\n\r\n\r &nbsp;x AS LONG\n\r\n\r &nbsp;y AS LONG\n\r\n\rEND TYPE\n\r\n\rUsed with various API routines.\n\r\n\r&nbsp;\n\r\n\rTYPE NMHDR\n\r\n\r &nbsp;HwndFrom AS DWORD\n\r\n\r &nbsp;IdFrom &nbsp; AS DWORD\n\r\n\r &nbsp;Code &nbsp; &nbsp; AS LONG\n\r\n\rEND TYPE\n\r\n\rNMHDR is used with CB.NMHDR and contains information about notification messages.\n\r\n\r&nbsp;\n\r\n\rTYPE NMCHAR\n\r\n\r &nbsp;Hdr &nbsp; &nbsp; &nbsp; &nbsp;AS NMHDR\n\r\n\r &nbsp;Ch &nbsp; &nbsp; &nbsp; &nbsp; AS DWORD\n\r\n\r &nbsp;dwItemPrev AS DWORD\n\r\n\r &nbsp;dwItemNext AS DWORD\n\r\n\rEND TYPE\n\r\n\rNMCHAR is used with CB.NMHDR and contains information about a character notification messages.\n\r\n\r&nbsp;\n\r\n\rTYPE NMKEY\n\r\n\r &nbsp;Hdr &nbsp; &nbsp;AS NMHDR\n\r\n\r &nbsp;nVKey &nbsp;AS DWORD\n\r\n\r &nbsp;uFlags AS DWORD\n\r\n\rEND TYPE\n\r\n\rNMKEY is used with CB.NMHDR and contains information about key notification messages.\n\r\n\r&nbsp;\n\r\n\rTYPE NMMOUSE\n\r\n\r &nbsp;Hdr &nbsp; &nbsp; &nbsp; &nbsp;AS NMHDR\n\r\n\r &nbsp;dwItemSpec AS DWORD\n\r\n\r &nbsp;dwItemData AS DWORD\n\r\n\r &nbsp;Pt &nbsp; &nbsp; &nbsp; &nbsp; AS POINT\n\r\n\r &nbsp;dwHitInfo &nbsp;AS LONG\n\r\n\rEND TYPE\n\r\n\rNMMOUSE is used with CB.NMHDR and contains information about key notification messages.\n\r\n\r&nbsp;\n\r\n\rTYPE NMTOOLTIPSCREATED\n\r\n\r &nbsp;Hdr &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;AS NMHDR\n\r\n\r &nbsp;HwndToolTips AS DWORD\n\r\n\rEND TYPE\n\r\n\rNMTOOLTIPSCREATED is used with CB.NMHDR and contains information about %NM_TOOLTIPSCREATED messages.\n\r\n\r&nbsp;\n\r\n\rTYPE PowerBounds\n\r\n\r &nbsp;Elements1 &nbsp; &nbsp; AS LONG\n\r\n\r &nbsp;LowBound1 &nbsp; &nbsp; AS LONG\n\r\n\r &nbsp;Elements2 &nbsp; &nbsp; AS LONG\n\r\n\r &nbsp;LowBound2 &nbsp; &nbsp; AS LONG\n\r\n\r &nbsp;Elements3 &nbsp; &nbsp; AS LONG\n\r\n\r &nbsp;LowBound3 &nbsp; &nbsp; AS LONG\n\r\n\r &nbsp;Elements4 &nbsp; &nbsp; AS LONG\n\r\n\r &nbsp;LowBound4 &nbsp; &nbsp; AS LONG\n\r\n\rEND TYPE\n\r\n\rPowerBounds is used with a PowerArray Object to dimension the array.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rBuilt-in numeric equates\n\r\n\rBuilt-in string equates\n\r\n\rBuilt-in RGB Color Equates","Built-in User Defined Types","scr\\html_built_in_user_defined_types.htm","                  \n\r\n\rBytes are 8-bit (1 byte) unsigned integers ranging in value from 0 to 255 &nbsp;( 0 to 2^8-1). The type-specifier character for a Byte is: ?.\n\r\n\rByte variables are identified by following the variable name with a question mark (i.e., var?), or by using the DEFBYT statement as described in the previous discussion of Integers. You can also declare Byte variables using the BYTE keyword with the DIM statement. For example:\n\r\n\rDIM I AS BYTE\n\r\n\rByte variables are particularly useful for storing small, unsigned integral quantities like the number of days in a month. You should not use Byte variables in FOR/NEXT loops, as they are highly inefficient.\n\r\n\rA PowerBASIC Byte variable is equivalent to a bool data type (in lowercase) used by most modern C compilers. A bool is a non-traditional 8-bit unsigned data type, whereas a BOOL data type (in capital letters) is equivalent to a Long-integer in PowerBASIC. Be aware that some older C compilers may freely interchange bool and BOOL keywords.\n\r\n\rA Delphi byte is equivalent to a PowerBASIC Byte.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rDouble-word (???)\n\r\n\rIntegers (%)\n\r\n\rLong integers (&amp;)\n\r\n\rQuad integers (&amp;&amp;)\n\r\n\rWord (??)","Byte (?)","scr\\html_byte_(_).htm","                  \n\r\n\rPurpose\n\r\n\rInvoke a Sub or Function indirectly.\n\r\n\rSyntax\n\r\n\rCALL DWORD TargetPtr\n\r\n\rCALL DWORD TargetPtr USING abc([arguments]) [TO result_var]\n\r\n\rRemarks\n\r\n\rCALL DWORD is an essential ingredient for implementing run-time (explicit) dynamic linking of DLLs, rather than the more common load-time (implicit) linking. This provides a way of constructing calls to APIs and DLLs that may not be present in all versions of Windows. This technique ensures that an application can start up successfully, even if Windows cannot resolve the location of the API or DLL function.\n\r\n\rThe first (simplified) form of CALL DWORD may be used if the target Sub/Function takes no parameters and offers no return value. It also requires STDCALL (SDECL) calling conventions, which is used by the vast majority (99%+) of import procedures. In all other cases, you must use the second form, with a USING clause to define the signature of the target Sub/Function.\n\r\n\rTargetPtr\n\r\n\rA Double-word, Long-integer, or pointer variable that contains the address of the entry point of a procedure (Sub or Function). If the target Sub/Function is located in the same module, you can retrieve the address with the CODEPTR function. If it\'s located in an external DLL, use IMPORT ADDR to load it and get the address.\n\r\n\rUSING\n\r\n\rThis option is used to define a model procedure declaration which matches all of the calling conventions desired to be used to invoke the target Sub/Function. For example, the following two calls to the function MySubCall are equivalent:\n\r\n\rDECLARE SUB MySubCall\n\r\n\rDIM PtrMySubCall AS DWORD\n\r\n\rPtrMySubCall= CODEPTR(MySubCall)\n\r\n\r[statements]\n\r\n\rCALL MySubCall\n\r\n\rCALL DWORD PtrMySubCall USING MySubCall\n\r\n\rarguments\n\r\n\rAn optional, comma-delimited list of variables, expressions, and constants to be passed to the procedure as parameters. In the CALL DWORD context, enclosing parentheses are required. The number and type of parameters passed must agree with the arguments of the procedure named by the USING clause. See CALL for more information on parameter passing methods.\n\r\n\rTO result_var\n\r\n\rWhen calling a Function which returns a value, the TO keyword offers a way to assign the function return value to result_var.\n\r\n\rRestrictions\n\r\n\rThread Functions and Callback Functions may not be invoked with CALL DWORD. The DECLARE model for the USING clause may not specify a LIB or IMPORT option.\n\r\n\rSee also\n\r\n\rCALL, CODEPTR, DECLARE, FASTPROC, FUNCTION/END FUNCTION, IMPORT, SUB/END SUB, THREAD CREATE","CALL DWORD statement","scr\\html_call_dword_statement.htm","                  \n\r\n\rPurpose\n\r\n\rInvoke a procedure (Sub, Function, Method, Property, or FastProc).\n\r\n\rSyntax\n\r\n\rCALL ProcName [([arguments])] [TO result_var]\n\r\n\rRemarks\n\r\n\rThe CALL statement has the following parts:\n\r\n\rProcName\n\r\n\rThe name of a Sub, Function, Method, Property, or FastProc defined elsewhere in the program.\n\r\n\rarguments\n\r\n\rAn optional, comma-delimited list of variables, expressions, and constants to be passed to the procedure as parameters, for up to 32 parameters. If the CALL keyword is used, the arguments must be enclosed in parentheses. \n\r\n\rYou can omit the CALL keyword. If you do so, you may also omit the parentheses surrounding arguments. For example, the following lines are equivalent:\n\r\n\rCALL MyProc(parm1, parm2)\n\r\n\rMyProc(parm1, Parm2)\n\r\n\rMyProc parm1, parm2\n\r\n\rHowever, if the first parameter argument is enclosed in parentheses for any reason, the entire parameter list must be enclosed in parentheses. For example:\n\r\n\rMyProc (3+z, b) &nbsp; &nbsp;\' Valid syntax\n\r\n\rMyProc ((3+z), b) &nbsp;\' Valid syntax\n\r\n\rMyProc (3+z), b &nbsp; &nbsp;\' Invalid syntax\n\r\n\rThis updated syntax now permits macros to be called using the SUB-style convention if/when the macros expand directly to Function calls. For example:\n\r\n\rMACRO sm(Msg) = SendMessage(a, Msg, b, c)\n\r\n\rcan be called like this (when the return value is not required):\n\r\n\rsm(x)\n\r\n\rIn all cases, the number and type of parameters passed must agree with the arguments in procedure definition.\n\r\n\rVariant Arguments\n\r\n\rYou can think of a Variant as a kind of container, which can hold a variable of most any data type. If you call a procedure which requires a variant for one or more of its arguments, PowerBASIC will automatically convert a standard data type into a variant data type.\n\r\n\rWhile a variant may not normally contain a UDT, PowerBASIC offers a special methodology to do so. At programmer direction, a TYPE may be assigned to a variant (as a byte string) by using:\n\r\n\r[LET] VrntVar = TypeVar AS STRING\n\r\n\rIn the same manner, a UDT argument can be auto-converted to the variant type by appending AS STRING:\n\r\n\rCALL ProcName(UDTVar AS STRING)\n\r\n\rThe data contained in the User-Defined Type variable (UDT) is stored in the variant argument as a dynamic string of bytes (vt_bstr). When you retrieve that UDT data (with Variant$), PowerBASIC understands the content and handles it accurately. However, other programming languages may not understand this technique, so it should be limited to PowerBASIC applications. This methodology is implemented in all of the PowerBASIC COLLECTION objects as it greatly enhances ease of coding and performance of the final executable.\n\r\n\rPassing Parameters\n\r\n\rIn a procedure definition, every parameter is described by the data type, and the format used to pass it. The type may be any normal variable type, such as long, string, User-Defined Type, etc. The passing format describes how the value is presented to the procedure: by reference (BYREF), by value (BYVAL), or by reference to a copy (BYCOPY).\n\r\n\rBYREF\n\r\n\rWhen a parameter is passed by reference, it consists of a 4-byte address of the data. In this case, the original data can be modified by the procedure.\n\r\n\rBYVAL\n\r\n\rWhen a parameter is passed by value, it consists of an actual copy of the data. Since the parameter is a copy, the original data cannot be modified by the procedure.\n\r\n\rWhen you pass parameters from the calling code with an explicit BYVAL, you effectively switch off the compilers type-checking for that parameter. This can be useful in cases where the called code is expecting a BYREF parameter, and you wish to pass an address of another data type that would trigger a compile-time error without the BYVAL method. For example:\n\r\n\rSUB TheSub(x AS STRINGZ) \' Address of x expected\n\r\n\r &nbsp;[statements]\n\r\n\rEND SUB\n\r\n\r[statements]\n\r\n\rDIM a$\n\r\n\ra$ = &quot;Dynamic string data&quot;\n\r\n\rCALL TheSub(BYVAL STRPTR(a$)) \' Pass data address\n\r\n\rBYCOPY\n\r\n\rA parameter passed by copy is a special case; somewhat of a hybrid of the other two methods. When a procedure expects a parameter to be passed by reference, it expects to see a pointer to the data. In some cases, such as when the parameter is a calculated expression, it is not precisely possible to pass a pointer, since an expression result is a temporary value that does not exist in a permanent memory location. On the other hand, if you wish to ensure that the original data is not modified by the procedure, you can place a BYCOPY override in the arguments list.\n\r\n\rIn both cases, a copy of the data is stored in a temporary memory location, and the parameter consists of a 4-byte address of this temporary location. Another way to force BYCOPY is to enclose a variable name in parentheses, so it will appear to the compiler as an expression, rather than just a single variable.\n\r\n\rUnless declared otherwise, parameters default to BYREF passing method. Expressions and constants are always passed BYCOPY. Fixed length strings, User-Defined Types, and full arrays are always passed BYREF.\n\r\n\rCALL MySub (i&amp;) &nbsp; &nbsp; &nbsp; &nbsp;\' i&amp; is passed by reference\n\r\n\rCALL MySub (BYREF i&amp;) &nbsp;\' i&amp; is passed by reference\n\r\n\rCALL MySub (BYCOPY i&amp;) \' i&amp; is passed by copy\n\r\n\rCALL MySub ((i&amp;)) &nbsp; &nbsp; &nbsp;\' i&amp; is passed by copy\n\r\n\rUnless declared otherwise, parameters default to the BYREF passing method. Expressions and constants are always passed BYCOPY. Full arrays are always passed BYREF.\n\r\n\rEntire arrays are specified by using an empty set of parentheses after the array, while individual array elements are specified by subscript index number. For example:\n\r\n\rCALL SumArray(a()) &nbsp; &nbsp; \' pass entire array \'a\'\n\r\n\rCALL SumArray(a(3)) &nbsp; &nbsp;\' pass element 3 of array \'a\'\n\r\n\rThe CALL statement can be used to invoke functions, subs, methods, properties, or fastprocs. In this case, the return value of the function is simply discarded, unless the TO keyword is used to specify a return variable.\n\r\n\rIf a procedure expects a parameter by reference, it is possible to substitute a pointer by value, for the identical result. This is particularly useful with Fixed-length strings and Types:\n\r\n\rDECLARE SUB a(z%)\n\r\n\rDIM MyInt AS INTEGER, x AS INTEGER PTR\n\r\n\rx = VARPTR(MyInt)\n\r\n\rCALL a(MyInt)\n\r\n\r \' &nbsp; or\n\r\n\rCALL a(BYVAL x)\n\r\n\r \' &nbsp; or\n\r\n\rCALL a(BYVAL VARPTR(MyInt))\n\r\n\rOf course, if the procedure is expecting a parameter by value, you may not pass the pointer, but rather the pointer target (i.e., CALL a(@x)).\n\r\n\rPowerBASIC compilers have a limit of 32 parameters per SUB, FUNCTION, METHOD, and PROPERTY. To pass more than 32 parameters, construct a User-Defined Type (UDT) and pass (the address of) the UDT by reference (BYREF) instead.\n\r\n\rFixed-length strings, STRINGZ strings, and User-Defined Types/Unions may also be passed as BYVAL or OPTIONAL parameters, now. Try to avoid passing large items BYVAL, as it\'s terribly inefficient, and there is a maximum size limit of 64 Kb for a given parameter list. Arrays cannot be passed BYVAL.\n\r\n\rWhen a procedure definition specifies either a BYREF parameter or a pointer variable parameter, the calling code may freely pass a BYVAL DWORD or a Pointer instead. While the use of the explicit BYVAL override in the calling code is optional, it is recommended for clarity. It is necessary to explicitly declare all pointer parameters as BYVAL (i.e., BYVAL X AS BYTE PTR). Failure to do so will generate a compile-time Error 549 (&quot;BYVAL required with pointers&quot;).\n\r\n\rA procedure may also be imported and exported within the same module. That is, a function in the module may be stated as EXPORT, while a DECLARE in the same module specifies it as an imported function by the option LIB &quot;XXX.DLL&quot;, provided that XXX.DLL is the name of the module. This may be particularly valuable when you wish to build an #INCLUDE file with all of the DECLARE statements for a project.\n\r\n\rFor information on using OPTIONAL parameters, please see DECLARE, FUNCTION, METHOD, PROPERTY and SUB topics.\n\r\n\rNOTHING\n\r\n\rThe reserved word NOTHING can be used to replace any OBJECT variable parameter. In this case, the compiler passes a null object (or a pointer to a null object if BYREF) in place of a typical parameter. While this simplifies some programming issues, the technique must be used with caution. If the target METHOD or FUNCTION is not expecting a null parameter, it could cause a fatal error condition.\n\r\n\rTO result_var\n\r\n\rThis offers an optional way to assign a function return value to result_var. For example, the following code assigns the return value to x% in two different ways:\n\r\n\rx% = MyFunCall\n\r\n\rCALL MyFunCall TO x%\n\r\n\rRestrictions\n\r\n\rA thread Function may not be directly called or executed, except by a THREAD CREATE statement. \n\r\n\rSee also\n\r\n\rCALL DWORD, DECLARE, FASTPROC, FUNCTION/END FUNCTION, METHOD, PROPERTY, SUB/END SUB, THREAD CREATE","CALL statement","scr\\html_call_statement.htm","                  \n\r\n\rA callback is a Function called by Windows when an event occurs. In the previous modal dialog example, when the OK button is clicked by the user, Windows calls the OkButton() function. PowerBASIC\'s Dynamic Dialog Tools allows you to create a single callback to handle all events for the dialog, or you can create individual Callback Functions for each Control in your dialog. You can even use a combination of the two methods.\n\r\n\r&nbsp;\n\r\n\rControl Callback\n\r\n\rIf you\'ve used Visual Basic, you\'ll be familiar with the concept of a Control Callback even though it\'s not called by that name. A Control Callback is a function that is called when a %WM_COMMAND or %WM_NOTIFY event is generated for a particular control. In the earlier example, we arranged it so the OkButton() function was called when the OK button was clicked. Further, when the Cancel button was clicked, the CancelButton() function was called. A Control Callback function is enabled when you execute a CONTROL ADD statement using the CALL CtlProc option at the end.\n\r\n\rCONTROL ADD BUTTON, hDlg, %IDOK, &quot;OK&quot;, 34, 32, 40, 14, %BS_DEFAULT OR %WS_TABSTOP CALL OkButton\n\r\n\rCONTROL ADD BUTTON, hDlg, %IDCANCEL, &quot;Cancel&quot;, 84, 32, 40, 14 CALL CancelButton\n\r\n\rSome controls, like text boxes, list boxes, and combo boxes, can generate more than one type of event. In VB, each separate event on each control is handled by a new function. For example, if your VB form includes a list box, it may include a Callback Function such as List1_Change() that is called whenever the current selected item changes. In PowerBASIC, only a single Callback Function is needed for each control. When an event occurs, the Callback Function just chooses which events to handle, and which events to ignore. If your PowerBASIC callback wanted to process the Change event for a list box, your code would look like this:\n\r\n\rCALLBACK FUNCTION List1() AS LONG\n\r\n\r &nbsp;IF CB.MSG = %WM_COMMAND THEN\n\r\n\r &nbsp; &nbsp;IF CB.CTLMSG = %LBN_SELCHANGE THEN\n\r\n\r &nbsp; &nbsp; &nbsp;[your code here]\n\r\n\r &nbsp; &nbsp; &nbsp;FUNCTION = 1\n\r\n\r &nbsp; &nbsp;END IF\n\r\n\r &nbsp;END IF\n\r\n\r&nbsp;\n\r\n\rEND FUNCTION\n\r\n\rYou can use a combination of the CB.MSG and CB.CTLMSG functions to decide exactly which event has occurred. Generally speaking, in a Control Callback, CB.MSG will contain either %WM_COMMAND or %WM_NOTIFY. The CB.CTLMSG will return the specific message is either of those two categories. In this example situation, the control notification  %LBN_SELCHANGE is sent to the callback for the list box whenever the item in the list box changes (the user clicks on the new item or uses the keyboard to select a new item).\n\r\n\r\n\r\n\rAll of the control and dialog message equates are located in the DDT.INC file. This file is simply a subset of the much larger WIN32API.INC file and is provided only for convenience. Therefore, the use of these two files is mutually exclusive.\n\r\n\rIf your code processes a message, it should return TRUE (any non-zero value) by setting FUNCTION = number within the Control Callback. This advises that there is no need to process that message further. If you return the value FALSE (zero), the message is passed on to your Dialog Callback, if you have one. If the message is still unhandled by your Dialog Callback, the DDT dialog engine itself will handle the message on your behalf.\n\r\n\rIf your code processes a %WM_NOTIFY message, the return value is generally ignored. Because of the nature of %WM_NOTIFY messages, they are always directed to both Control callbacks and Dialog callbacks to use as needed.\n\r\n\rPrior to version 9.0 of PowerBASIC for Windows, Control Callback Functions received only %WM_COMMAND messages. Beginning with PB 9.0, %WM_NOTIFY messages are sent as well. There are many situations where these added messages will prove to be very important. If your existing callback functions are written with complete error checking (ensuring that CB.MSG = %WM_COMMAND), this minor addition will cause no problems. It just presents additional information which can be acted upon, or just ignored. However, if callbacks were written without complete error checking, some ambiguity is possible. In this case, you should either update your Control Callback code, or suppress %WM_NOTIFY messages with a #MESSAGES COMMAND metastatement. \n\r\n\rWhen a Control Callback receives a click notification for a control, the callback will receive a %WM_COMMAND message in the CB.MSG variable. A common mistake made by programmers is to fail to test both CB.MSG and CB.CTLMSG parameters before responding to the message. If the message is truly generated from a click event, CB.CTLMSG will contain %BN_CLICKED. This simple test ensures that your code responds correctly to notification messages.\n\r\n\rCALLBACK FUNCTION OkButton() AS LONG\n\r\n\r &nbsp;IF CB.MSG = %WM_COMMAND AND CB.CTLMSG = %BN_CLICKED THEN\n\r\n\r &nbsp; &nbsp;\'...Process the click event here\n\r\n\r &nbsp; &nbsp;FUNCTION = 1\n\r\n\r &nbsp;END IF\n\r\n\rEND FUNCTION\n\r\n\rIt pays to be sure you are responding to the correct message in your callback. Subtle bugs can occur if you aren\'t very careful to notice and recognize unanticipated messages.\n\r\n\rIt should also be noted that there are ranges of notification messages that individual controls can send to the Control Callback or Dialog Callback. However, many of these messages are suppressed unless the controls have been initially assigned a &quot;notify&quot; style. For controls that are members of the Button class (CHECKBOX, OPTION, FRAME, etc.), this is the %BS_NOTIFY style. Please refer to the statements for additional information on notification styles for other control types.\n\r\n\r&nbsp;\n\r\n\rDialog callback\n\r\n\rIf you review the example code in most Windows programming books (particularly the Windows 32-bit SDK), you will see that most of the examples create a single callback for the entire dialog. Each time the user presses a button, a message is sent to this Callback Function. Within this Callback Function, there is often a large SELECT CASE or IF/ELSEIF/THEN structure, designed to pick out the incoming event messages and then process the selected messages.\n\r\n\rC programmers are usually quite familiar with this concept, and often resort to using &quot;Message Cracker&quot; functions to separate their event handling code into a set of independent functions. On the other hand, PowerBASIC\'s DDT takes much of this drudgery away. By permitting separate callbacks for each CONTROL ADD statement, you become free to enclose your event handling code in separate functions, just like a C programmer may do, but without the confusing macros C programmers are often forced to use.\n\r\n\rDDT gives the programmer the choice of either using a single callback to handle all dialog and control events, or writing a callback for each (or any) specific control. If you intentionally omit a callback for a particular control, the programmer has the choice of handling messages for that control within the dialog Callback Function, or ignoring them altogether.\n\r\n\rIn addition to handling control messages within the dialog callback, this Callback Function also provides a way to handle events that concern the actual dialog box itself. For example, handling a %WM_PAINT message, or notification that the dialog was minimized, etc.\n\r\n\rA Dialog Callback function is enabled when you execute a DIALOG SHOW statement using the CALL DlgProc option.\n\r\n\rDIALOG SHOW MODELESS hDlg CALL DlgProc TO lResult&amp;\n\r\n\ror:\n\r\n\rDIALOG SHOW MODAL hDlg CALL DlgProc TO lResult&amp;\n\r\n\rThese two lines of code specify that dialog related event messages should be directed to the Callback Function DlgProc(). If we rewrote the earlier DDT example to use a single Dialog Callback instead of individual Control Callback Functions, the function might look something like this:\n\r\n\rCALLBACK FUNCTION DlgProc()\n\r\n\r &nbsp;SELECT CASE CB.MSG\n\r\n\r &nbsp; &nbsp;CASE %WM_COMMAND\n\r\n\r &nbsp; &nbsp; &nbsp;IF CB.CTLMSG = %BN_CLICKED THEN\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;IF CB.CTL = %IDOK THEN\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;DIALOG END CB.HNDL, 1\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;FUNCTION = 1\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;ELSEIF CB.CTL = %IDCANCEL THEN\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;DIALOG END CB.HNDL, 0\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;FUNCTION = 1\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;END IF\n\r\n\r &nbsp; &nbsp; &nbsp;END IF\n\r\n\r &nbsp;END SELECT\n\r\n\rEND FUNCTION\n\r\n\rTo complete this stage of modifications, you would also remove the &quot;CALL OkButton&quot; and &quot;CALL CancelButton&quot; parameters from the CONTROL ADD lines. Once changed, this modified code produces the identical behavior of the original example with only a single Callback Function.\n\r\n\rThis simple example only scrapes the surface of what can be achieved in a Dialog Callback Function. For example, by intercepting a %WM_ERASEBKGND message, you could draw onto the dialog client area, producing colorful dialogs with ease.\n\r\n\r&nbsp;\n\r\n\rCallback Return Values\n\r\n\rCallback functions always return a long integer result. The primary purpose of this return value is to tell the PowerBASIC DDT engine and the Windows operating system whether your Callback Function has processed this particular message. If you return the value TRUE (any non-zero value), you are asserting that the message was processed and no further handling is needed. If you return the value FALSE (zero), the PowerBASIC DDT engine will manage the message for you, using the default message procedures in Windows. If you do not specify a return value in the function, PowerBASIC chooses the value FALSE (zero) for you.\n\r\n\rThe term &quot;process a message&quot; may have many meanings. If it\'s a simple notification of a change in focus or style, which has no impact on your program, you may decide to consider it processed, yet do nothing. In other cases, your reaction could be quite complex and involved. As the programmer, that\'s your decision to make. But, regardless of your reaction, you should consider a message &quot;processed&quot; (returning a true value) whenever no further handling of the message (by DDT or Windows) is needed.\n\r\n\rIn some cases, especially when dealing with Common Controls and custom controls, you may be required to return a second result value through a special Windows data area named DWL_MSGRESULT. When you complete a Callback Function, PowerBASIC automatically copies any non-zero return value to DWL_MSGRESULT, if you haven\'t done so already. Therefore, it\'s generally safe to ignore this requirement in your code.\n\r\n\rIn most cases, when you process a message, you\'ll return a generic value for TRUE, such as: &nbsp;FUNCTION = 1. However, some messages require that you return a special value for TRUE, such as a graphical brush handle. As long as the value is non-zero, you can return it in the normal manner (with FUNCTION=n), since any non-zero value automatically implies that the message was processed.\n\r\n\rThat said, there are a few unique messages which may require special handling. Luckily, they\'re rare, but some just &quot;break all the rules&quot; listed above. For example, you might find one which requires a zero result, even when you have processed the message. You may find another which requires the return value be different from DWL_MSGRESULT. For these very special cases, you can simply specify two return values:\n\r\n\rFUNCTION = 1, BrushHandle&amp;\n\r\n\rIn this form, the first numeric expression specifies the value to be returned from the Callback Function. The second numeric expression tells the value to be assigned to DWL_MSGRESULT. When you use this double parameter assignment, the results are absolute. PowerBASIC assumes you have processed the message, regardless of the values given. PowerBASIC makes no other assumptions of any kind about these values. A double parameter function assignment is only allowed in a Callback Function.\n\r\n\rPrevious versions of PowerBASIC did not offer a double parameter form of function return. This caused some difficulty with a few Windows messages which required a special return value of zero. If you return a value of zero (0) with the single parameter form, it implies the message was not processed at all by the Callback. This issue is totally circumvented by the double parameter form.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rDynamic Dialog Tools (DDT)\n\r\n\rCreating a Dialog\n\r\n\rAdding Controls to the Dialog\n\r\n\rModal vs. Modeless\n\r\n\rControls\n\r\n\rControl Styles\n\r\n\rDialog Styles\n\r\n\rMenus","Callbacks","scr\\html_callbacks.htm","                  \n\r\n\rPurpose\n\r\n\rRetrieve the details of a specific stack frame from the call stack.\n\r\n\rSyntax\n\r\n\rsfname$ = CALLSTK$(n)\n\r\n\rRemarks\n\r\n\rCALLSTK$(1) returns the name of the current Sub, Function, Method, or Property, and the value of each of the parameters at the time it was called. CALLSTK$(2) returns the name of the procedure which called the current one, as well as its parameters. Likewise, CALLSTK$(3) returns the one above it, and so forth.\n\r\n\rIf the CALLSTK$(n) parameter is outside the range of one (1) through the number of stack frames identified by CALLSTKCOUNT, an empty string is returned. parameters are displayed in decimal, while pointer and array parameters display a decimal representation of the offset of the target value.\n\r\n\rRestrictions\n\r\n\rThe CALLSTK$ function can be invaluable during debugging, but it generates substantial extra code which should be avoided in a final release version of an application. If the source code contains #TOOLS OFF, all CALLSTK$ functions which remain in the program return an empty string.\n\r\n\rThe CALLSTK$ function is &quot;thread-aware&quot;, returning only stack frame details from the thread in which it was referenced.\n\r\n\rSee also\n\r\n\r#TOOLS, CALLSTK, CALLSTKCOUNT, FUNCNAME$, PROFILE, TRACE\n\r\n\rExample\n\r\n\rFOR x&amp; = CALLSTKCOUNT TO 1 STEP -1\n\r\n\r &nbsp;A$ = A$ + CALLSTK$(x&amp;)\n\r\n\rNEXT x&amp;","CALLSTK$ function","scr\\html_callstk_function.htm","                  \n\r\n\rPurpose\n\r\n\rCapture a complete representation of the stack frames in the call stack.\n\r\n\rSyntax\n\r\n\rCALLSTK diskfilename$\n\r\n\rRemarks\n\r\n\rPowerBASIC creates a stack frame for each call to a Sub, Function, Method, or Property, and records each nested call in a call stack. The stack frame holds the parameters being passed to the routine, and providing space for local variable storage, etc. Since procedures can call other procedures to an almost limitless depth, there may be a substantial number of stack frames present at any given moment.\n\r\n\rThe CALLSTK statement can help provide answers to the age-old &quot;how did I get here?&quot; question. When combined with other debugging statements such as CALLSTK$, CALLSTKCOUNT, and TRACE, the programmer has a set of tools that can significantly reduce the amount of effort required to debug an application.\n\r\n\rExecuting a CALLSTK statement captures a representation of all of the stack frames that exist above the one that includes the CALLSTK statement. When the CALLSTK statement is executed, a standard sequential file (of the specified file name in diskfilename$) is created. The resulting disk file contains a list of every call to a procedure, and their associated parameter values, which are currently defined on the call stack.\n\r\n\rdiskfilename$ must be a legal file spec, may be a Long File Name (LFN), and may include a path. If the file cannot be created for any reason, the operation will be ignored and no run-time error will be generated. If present, CALLSTK overwrites the existing file.\n\r\n\rIf PBMAIN calls the SUB aaa(x&amp;) which then calls the SUB bbb(y&amp;), the CALLSTK from within bbb(y&amp;) might look like this:\n\r\n\rPBMAIN()\n\r\n\raaa(77)\n\r\n\rbbb(-1)\n\r\n\rLater, if bbb(y&amp;) exited, then aaa(x&amp;) called ccc(z&amp;), the updated CALLSTK from within ccc(z&amp;) might then appear as:\n\r\n\rPBMAIN()\n\r\n\raaa(77)\n\r\n\rccc(33)\n\r\n\rNumeric parameters are displayed in decimal, while pointer and array parameters display a decimal representation of the offset of the target value.\n\r\n\rRestrictions\n\r\n\rCALLSTK can be invaluable during debugging, but it generates substantial additional code that should be avoided in a final release version of an application. If the source code contains #TOOLS OFF, all CALLSTK statements which remain in the program are ignored.\n\r\n\rThe CALLSTK statement is &quot;thread-aware&quot;, displaying only stack frame details from the thread in which it was executed.\n\r\n\rSee also\n\r\n\r#TOOLS, CALLSTK$, CALLSTKCOUNT, FUNCNAME$, PROFILE, TRACE\n\r\n\rExample\n\r\n\rFUNCTION PBMAIN\n\r\n\r &nbsp;CALL Sb1(100)\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rSUB Sb1(x AS LONG)\n\r\n\r &nbsp;CALL Sb2(x + 1)\n\r\n\rEND SUB\n\r\n\r&nbsp;\n\r\n\rSUB Sb2(y AS LONG)\n\r\n\r &nbsp;CALLSTK &quot;Stack frame test.txt&quot;\n\r\n\rEND SUB\n\r\n\rResult\n\r\n\rPBMAIN()\n\r\n\rSB1(100)\n\r\n\rSB2(101)","CALLSTK statement","scr\\html_callstk_statement.htm","                  \n\r\n\rPurpose\n\r\n\rRetrieve the number of stack frames in the call stack. Used in conjunction with the CALLSTK$ function.\n\r\n\rSyntax\n\r\n\rcount&amp; = CALLSTKCOUNT\n\r\n\rRemarks\n\r\n\rCALLSTKCOUNT returns a Long-integer value that represents the total number of stack frames that currently exist on the application call stack.\n\r\n\rRetrieve individual stack frame details with the CALLSTK$ function, or write them all to a disk file with the CALLSTK statement.\n\r\n\rRestrictions\n\r\n\rThe CALLSTKCOUNT function, when used in conjunction with the CALLSTK$ function, can be invaluable during debugging, but its use generates substantial extra code which should be avoided in a final release version of an application. If the source code contains #TOOLS OFF, all CALLSTKCOUNT functions which remain in the program return zero.\n\r\n\rThe CALLSTKCOUNT function is &quot;thread-aware&quot;, returning only the stack frame count from the thread in which it was referenced.\n\r\n\rSee also\n\r\n\r#TOOLS, CALLSTK$, CALLSTK, FUNCNAME$, PROFILE, TRACE\n\r\n\rExample\n\r\n\rFOR x&amp; = CALLSTKCOUNT TO 1 STEP 1\n\r\n\r &nbsp;A$ = A$ + CALLSTK$(x&amp;)\n\r\n\rNEXT x&amp;","CALLSTKCOUNT function","scr\\html_callstkcount_function.htm","                  \n\r\n\rPurpose\n\r\n\rIn a Callback Function, return information about a message.\n\r\n\rSyntax\n\r\n\rCtlID &nbsp; = CB.CTL\n\r\n\rCtlMsg &nbsp;= CB.CTLMSG\n\r\n\rWinHndl = CB.HNDL\n\r\n\rValue &nbsp; = CB.LPARAM\n\r\n\rMsg &nbsp; &nbsp; = CB.MSG\n\r\n\rValue &nbsp; = CB.WPARAM\n\r\n\rCodeMsg = CB.NMCODE\n\r\n\rNmPtr &nbsp; = CB.NMHDR\n\r\n\rNmStruc = CB.NMHDR$\n\r\n\rNmHndl &nbsp;= CB.NMHWND\n\r\n\rNmID &nbsp; &nbsp;= CB.NMID\n\r\n\rRemarks\n\r\n\rWhen an event occurs (like a user clicking on a button, a character typed into a text box, etc.) &nbsp;Windows sends a message to the control Callback Function, or the Dialog Callback Function. The CB functions are used to easily retrieve information about the message. These CB functions can only be used within a callback function.\n\r\n\rCallback functions in Windows have a standard set of four parameters. For this reason, PowerBASIC allows you to ignore them and save some typing in your source code. The implied parameters are:\n\r\n\rFUNCTION DlgCallback(BYVAL hDlg AS DWORD &nbsp;_\n\r\n\r &nbsp;BYVAL wMsg AS LONG &nbsp; _\n\r\n\r &nbsp;BYVAL wParam AS LONG _\n\r\n\r &nbsp;BYVAL lParam AS LONG)\n\r\n\rGeneric Callback Functions\n\r\n\rCB.HNDL\n\r\n\rThis function returns the window handle of the parent dialog. This is the value specified by the hDlg parameter above.\n\r\n\rCB.MSG\n\r\n\rEach type of message sent to your callback function has a unique numeric value, such as %WM_COMMAND, %WM_NOTIFY, etc. CB.MSG will return the actual numeric message value of the message being processed. The definitions of the numeric values in other CB functions (CB.LPARAM, CB.WPARAM, CB.CTL, etc.) can only be ascertained once CB.MSG is identified. Therefore, callback functions usually test the value of CB.MSG first.\n\r\n\rCB.WPARAM\n\r\n\rWhen Windows sends a message to a callback function, the wParam value contains different values, depending on the nature of the particular message (CB.MSG). In other words, CB.WPARAM returns a message-dependent value.\n\r\n\rCB.LPARAM\n\r\n\rWhen Windows sends a message to a callback function, the lParam value contains different values, depending on the nature of the particular message (CB.MSG). In other words, CB.LPARAM returns a message-dependent value.\n\r\n\r%WM_COMMAND Specific Callback Functions\n\r\n\rCB.CTL\n\r\n\rIf CB.MSG = %WM_COMMAND, this function returns the ID number assigned to the control with the CONTROL ADD statement. For other values of CB.MSG, it returns message-dependent values. This value is sent as the low-order word of the wParam parameter. It\'s functionally equivalent to LO(WORD, wParam&amp;) in a conventional function, or LO(WORD, CB.WPARAM) in a DDT Callback Function.\n\r\n\rCB.CTLMSG\n\r\n\rIf CB.MSG = %WM_COMMAND, this function returns the specific control message describing the event which occurred. For example, CB.CTLMSG returns %BN_CLICKED when the user clicks a button. For other values of CB.MSG, it returns message-dependent values. This value is sent as the high-order word of the wParam parameter. It\'s functionally equivalent to HI(WORD, wParam&amp;) in a conventional function, or HI(WORD, CB.WPARAM) in a DDT Callback Function.\n\r\n\r%WM_NOTIFY Specific Callback Functions\n\r\n\rCB.NMCODE\n\r\n\rIf CB.MSG = %WM_NOTIFY, this function returns the specific notification message describing the event which occurred. For example, CB.NMCODE returns %NM_SETFOCUS when the described control gains the focus. For other values of CB.MSG, the value returned is meaningless.\n\r\n\rCB.NMHDR\n\r\n\rIf CB.MSG = %WM_NOTIFY, this function returns the address (a pointer) to the NMHDR UDT for this notification message. NMHDR is defined as:\n\r\n\rType NMHDR\n\r\n\r &nbsp;hwndFrom &nbsp;as DWord &nbsp;\' Handle of the control sending the message\n\r\n\r &nbsp;idfrom &nbsp; &nbsp;as DWord &nbsp;\' Identifier of the control sending the message\n\r\n\r &nbsp;code &nbsp; &nbsp; &nbsp;as Long &nbsp; \' Notification code\n\r\n\rEnd Type\n\r\n\rSome notification messages (%NM_CHAR, %NM_CLICK, etc.) require an extended version of the NM structure. However, all NM structures begin with an NMHDR UDT, so the pointer returned here is always accurate. For other values of CB.MSG, the pointer returned by CB.NMHDR is meaningless.\n\r\n\rCB.NMHDR$\n\r\n\rIf CB.MSG = %WM_NOTIFY, this function returns the contents of the NMHDR UDT as a dynamic string. If the notification message is one which requires an extended version of the NM structure, the string returned contains all of the data for the extended UDT. However, in all cases, the first 12 bytes of the returned string will be the contents of NMHDR. You can use TYPE SET to assign the string data to an appropriate user-defined type. For other values of CB.MSG, the string returned by CB.NMHDR$ is meaningless.\n\r\n\rThe following notification messages use the extended NM structures as listed, so an appropriately longer string is returned:\n\r\n\rMessage\n\r\n\rUDT\n\r\n\r%NM_CLICK\n\r\n\rNMMOUSE\n\r\n\r%NM_RCLICK\n\r\n\rNMMOUSE\n\r\n\r%NM_NCHITTEST\n\r\n\rNMMOUSE\n\r\n\r%NM_KEYDOWN\n\r\n\rNMKEY\n\r\n\r%NM_SETCURSOR\n\r\n\rNMMOUSE\n\r\n\r%NM_CHAR\n\r\n\rNMCHAR\n\r\n\r%NM_TOOLTIPSCREATED\n\r\n\rNMTOOLTIPSCREATED\n\r\n\rOther special notify messages may use a different extended NM structure than those listed above. To ensure compatibility, you can include an optional numeric parameter to specify the size of the special UDT you are using:\n\r\n\rTYPE SET NotifyUDT = CB.NMHDR$(sizeof(NotifyUDT))\n\r\n\rCB.NMHWND\n\r\n\rIf CB.MSG = %WM_NOTIFY, this function returns the handle of the control which sent this message. For other values of CB.MSG, the value returned is meaningless.\n\r\n\rCB.NMID\n\r\n\rIf CB.MSG = %WM_NOTIFY, this function returns the ID number assigned to this control. For other values of CB.MSG, the value returned is meaningless.\n\r\n\rRestrictions\n\r\n\rThese functions are only valid inside a Callback Function. The CB Callback functions replace CBMSG, CBHNDL, CBLPARAM, CBWPARAM, CBCTL, and CBCTLMSG . Note these functions are no longer supported, so update your code to use the new syntax.\n\r\n\rSee also\n\r\n\rCallbacks, Dynamic Dialog Tools","CB Callback functions","scr\\html_cb_callback_functions.htm","                  \n\r\n\rPurpose\n\r\n\rConvert a value to specific variable type.\n\r\n\rSyntax\n\r\n\rbytevar? &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;= CBYT(numeric_expression)\n\r\n\rcurrencyvar@ &nbsp; &nbsp; &nbsp;= CCUR(numeric_expression)\n\r\n\rcurrencyextvar@@ &nbsp;= CCUX(numeric_expression)\n\r\n\rdoublevar# &nbsp; &nbsp; &nbsp; &nbsp;= CDBL(numeric_expression)\n\r\n\rdoublewordvar??? &nbsp;= CDWD(numeric_expression)\n\r\n\rextendedvar## &nbsp; &nbsp; = CEXT(numeric_expression)\n\r\n\rintegervar% &nbsp; &nbsp; &nbsp; = CINT(numeric_expression)\n\r\n\rlongintvar&amp; &nbsp; &nbsp; &nbsp; = CLNG(numeric_expression)\n\r\n\rquadintvar&amp;&amp; &nbsp; &nbsp; &nbsp;= CQUD(numeric_expression)\n\r\n\rsinglevar! &nbsp; &nbsp; &nbsp; &nbsp;= CSNG(numeric_expression)\n\r\n\rwordvar?? &nbsp; &nbsp; &nbsp; &nbsp; = CWRD(numeric_expression)\n\r\n\rRemarks\n\r\n\rEach of these functions converts a numeric expression to a particular variable type. In each case, numeric_expression must be within the legal range for the result type. The numeric_expression will be rounded if necessary.\n\r\n\rFunction\n\r\n\rResult type\n\r\n\rCBYT\n\r\n\rByte\n\r\n\rCCUR\n\r\n\rCurrency\n\r\n\rCCUX\n\r\n\rExtended-currency\n\r\n\rCDBL\n\r\n\rDouble-precision floating-point\n\r\n\rCDWD\n\r\n\rDouble-word\n\r\n\rCEXT\n\r\n\rExtended-precision floating-point\n\r\n\rCINT\n\r\n\rInteger\n\r\n\rCLNG\n\r\n\rLong-integer\n\r\n\rCQUD\n\r\n\rQuad-integer\n\r\n\rCSNG\n\r\n\rSingle-precision floating-point\n\r\n\rCWRD\n\r\n\rWord\n\r\n\rThese conversion functions are rarely needed as PowerBASIC automatically performs any necessary conversions when executing an assignment statement or passing parameters. For example:\n\r\n\re% = f#\n\r\n\ris equivalent to:\n\r\n\re% = CINT(f#)\n\r\n\rIn the case of the functions that convert to integral class values, the fractional part of the number is rounded. If the fractional part is exactly .5 then it rounds to the nearest even integral value. For example, CINT(1.5) returns 2, CINT(.5) returns 0, and CLNG(-0.6) returns -1.\n\r\n\rRestrictions\n\r\n\rCSNG limit string display to 7 significant digits.\n\r\n\rSee also\n\r\n\rCEIL, CVI and associated functions, FIX, INT, MKI$ and associated functions\n\r\n\rExample\n\r\n\r\' Calculate CINT for a series of values\n\r\n\rFOR I! = 2.4! TO 2.65! STEP 0.05!\n\r\n\r &nbsp;x$ = FORMAT$(I!, &quot;0.00&quot;) + &quot; is&quot; + STR$(CINT(I!))\n\r\n\rNEXT I!\n\r\n\rResult\n\r\n\r2.40 is 2\n\r\n\r2.45 is 2\n\r\n\r2.50 is 2\n\r\n\r2.55 is 3\n\r\n\r2.60 is 3\n\r\n\r2.65 is 3","CWRD function","scr\\html_cbyt_ccur_ccux_cdbl_cdwd_cext_cint_clng_cqud_csng_and.htm","                  \n\r\n\rPurpose\n\r\n\rConvert a floating point variable or expression into an integral class value, by returning the smallest integral value that is greater than or equal to its argument.\n\r\n\rSyntax\n\r\n\rintvar = CEIL(numeric_expression)\n\r\n\rRemarks\n\r\n\rThe CEIL function rounds upward, returning the smallest integral value that is greater than or equal to numeric_expression. For example, y = CEIL(1.5) places the value 2 into y.\n\r\n\rSee also\n\r\n\rCINT, FIX, FRAC, INT, ROUND\n\r\n\rExample\n\r\n\r\' Display the ceiling for a series of values\n\r\n\rFOR W! = -1.5! TO 1.5! STEP 0.5!\n\r\n\r &nbsp;x$ = &quot;CEIL&quot; + FORMAT$(W!, &quot;* 0.00&quot;) + _\n\r\n\r &nbsp; &nbsp;&quot; =&quot; + FORMAT$(CEIL(W!), &quot;* 0.00&quot;)\n\r\n\rNEXT W!\n\r\n\rResult\n\r\n\rCEIL -1.50 = -1.00\n\r\n\rCEIL -1.00 = -1.00\n\r\n\rCEIL -0.50 = &nbsp;0.00\n\r\n\rCEIL &nbsp;0.00 = &nbsp;0.00\n\r\n\rCEIL &nbsp;0.50 = &nbsp;1.00\n\r\n\rCEIL &nbsp;1.00 = &nbsp;1.00\n\r\n\rCEIL &nbsp;1.50 = &nbsp;2.00","CEIL function","scr\\html_ceil_function.htm","                  &#183;#COMPILE metastatement has been enhanced to support compiling of Static Link Libraries.&#183;%DEF operator has been expanded so that %PB_EXE returns false when compiling a Static Link Library.&#183;ARRAY DELETE and ARRAY INSERT statements now supports Variants, Objects, Guids, and UDT arrays.&#183;ARRAY SORT now uses CALL instead of USING when specifying a custom array sort function.&#183;ASC function has been improved to support Unicode as well as ANSI strings.&#183;ASC statement has been improved to support Unicode as well as ANSI strings.&#183;ASMDATA DD now supports sign-extended values.&#183;BIN$ function has been expanded to 64-bits with formatting and now supports adding leading and trailing spaces to the string result.&#183;CALL statement offers automatic conversion of numeric, string, and UDT parameters to variant parameters.&#183;CHOOSE, CHOOSE&amp;, and CHOOSE$ functions have been enhanced with optional ELSE clause. The ELSE option allows an optional choice value to be returned when no match is made. For example:\n\r\n\rChoiceVar$ = CHOOSE$(7,&quot;ONE&quot;, &quot;TWO&quot; ELSE &quot;NUL&quot;)\n\r\n\rIn this case, the ELSE expression &quot;NUL&quot; is returned.\n\r\n\rCHOOSE and CHOOSE&amp; also support an optional BIT clause where the selection is based upon the first bit set (lowest to highest) in the specified index. This is particularly valuable when used with an ENUMERATION which also uses the BIT option, to describe a set of attributes for an item in your program.\n\r\n\rThe CHOOSE$ function now has an optional BITS clause that works in the same general fashion as the BIT clause, except the function may return multiple choices, as a concatenated string, if more than one bit is set. For example:\n\r\n\rx$ = CHOOSE$(BITS 5, &quot;Computer &quot;, &quot;Laptop &quot;, &quot;Desktop &quot;)\n\r\n\rSince the value 5 consists of 2 bits (the lowest and third-lowest) set, the first and third strings are concatenated and returned to the caller. In this case, &quot;Computer Desktop &quot; is the result.&#183;CLIPBOARD GET TEXT statement automatically converts the retrieved string to ANSI or Unicode to match the format of the target variable.&#183;CODEPTR function has been improved to return the address of a FASTPROC.&#183;COMBOBOX ADD and COMBOBOX INSERT statements now offer an optional TO clause that returns the index position of the added string.&#183;COMM function, COMM LINE, COMM OPEN, COMM PRINT, COMM RECV, COMM SEND, and COMM SET have been expanded to support ANSI and Unicode strings. COMM LINE, COMM OPEN, COMM PRINT, COMM RECV, and COMM SEND have been improved with an optional timeout (see COMM TIMEOUT) to &nbsp;complete the given COMM operation.&#183;CONTROL ADD GRAPHIC statement. Graphic controls may now be resized with CONTROL SET CLIENT, GRAPHIC SET CLIENT, CONTROL SET SIZE, or GRAPHIC SET SIZE.&#183;CONTROL SET CLIENT statement now resizes graphic controls.&#183;CONTROL SET FONT statement resets back to the default original font chosen by PowerBASIC when a font handle of zero is specified.&#183;CONTROL SET SIZE statement has been enhanced to support graphic controls.&#183;DECLARE statement has been updated to support the COMMON and THREADSAFE descriptors. A COMMON Sub or Function is one which may be referenced by and between linked unit modules (Main or SLL). With the THREADSAFE option, PowerBASIC automatically establishes a semaphore which allows only one thread to execute the Sub/Function at a time. Other callers must wait until the first thread exits the THREADSAFE procedure before they are allowed to begin.&#183;DIR$ function now supports Unicode file names and directories. The DIRDATA built-in UDT has been updated to return Unicode short and long filenames.&#183;EXIT statement has been improved to support exiting a FASTPROC immediately.&#183;FONT NEW statement now optionally supports creating fonts with external leading.&#183;FUNCTION/END FUNCTION statements have been expanded to support an optional THREADSAFE descriptor. With the THREADSAFE option, PowerBASIC automatically establishes a semaphore which allows only one thread to execute the procedure at a time.&#183;GET$ statement reads ANSI string data from a file opened in binary mode, but if the data is read into a Unicode string it will be converted to Unicode before it is assigned.&#183;GRAPHIC COLOR statement now supports parameters of -3 to indicate that the existing color should not be changed.&#183;GRAPHIC GET CLIENT statement now returns the client area size in dialog units or pixels only. The size represents the physical size of the display area on the screen. This change was necessary because of the improved graphic functionality involving virtual windows, resizing of graphic windows, etc. Prior versions returned scaled sizes if a GRAPHIC SCALE was executed. Substitute GRAPHIC GET CANVAS for functionality which is fully compatible with the old format.&#183;GRAPHIC GET LOC and GRAPHIC SET LOC now only support Graphic Windows. For Graphic Controls use CONTROL GET LOC and CONTROL SET LOC.&#183;GRAPHIC SET FONT statement resets back to the default original font chosen by PowerBASIC when a font handle of zero is specified.&#183;GRAPHIC PRINT statement has been expanded to support POS(), SPC(), TAB(), commas, and semicolons. The POS(n) clause is an optional function used to set the POS to the horizontal page unit. Multiple uses of the POS function is permitted in a single statement. The SPC(n) clause is an optional function used to insert n spaces into the printed output. Multiple use of SPC is permitted in a single statement. The TAB(n) clause is an optional function used to tab to the nth column before printing the next expression. Multiple use of TAB is permitted in a single statement.&#183;GRAPHIC RENDER statement now supports icons as well as bitmaps.&#183;GRAPHIC WAITKEY$ statement has been improved with a optional KeyMask$ and TimeOut&amp; expressions. If the optional KeyMask$ expression is included, only a limited set of keys are recognized. KeyMask$ may include any number of Sub-Masks, one for each key to observe. For example, GRAPHIC WAITKEY$(&quot;YyNn&quot;) will recognize upper-case or lower-case Y or N (for yes/no answers), while any other key will be ignored. If KeyMask$ is omitted, or evaluates to a zero-length string, any key event will be recognized. If the optional TimeOut&amp; expression is included, it tells the maximum number of milliseconds to wait for a key. GRAPHIC WAITKEY$(5000) will wait a maximum of 5 seconds. The specified TimeOut period will only be approximate, so you should not rely upon precision accuracy. If the TimeOut period is exceeded, a zero-length string is returned. If the TimeOut&amp; parameter is omitted, or evaluates to zero (0), it will wait an infinite length of time.&#183;GRAPHIC WINDOW statement has been expanded to support an optional font handle of the initial font to be used in the GRAPHIC WINDOW.&#183;GRAPHIC WINDOW END statement has been enhanced with an optional handle of the graphic window to close.&#183;HEX$ function now supports adding leading and trailing spaces to the string result.&#183;IPowerTime.DateDiff now reports invalid parameters through OBJRESULT.&#183;IPowerTime.TimeDiff now reports invalid parameters through OBJRESULT.&#183;IPowerTime.NewDate now reports invalid parameters through OBJRESULT.&#183;IPowerTime.NewTime now reports invalid parameters through OBJRESULT.&#183;LET statement (with Types) has been expanded to support assigning a Variant byte string to a UDT using the Variant$ function.&#183;LISTBOX ADD and LISTBOX INSERT statements now offer an optional TO clause that returns the index position of the added string.&#183;MENU ADD POPUP statement has been expanded with an optional AS id&amp; clause. id&amp; is a unique numeric identifier for this popup menu. id&amp; may be used later with a BYCMD option to reference this popup.&#183;MENU GET STATE statement has been enhanced to support the %MFS menu states equates.&#183;MENU SET STATE statement has been enhanced to support the %MFS menu states equates.&#183;METHOD/END METHOD statements have been expanded to support an optional THREADSAFE descriptor. With the THREADSAFE option, PowerBASIC automatically establishes a semaphore which allows only one thread to execute the procedure at a time.&#183;MID$ function and MID$ statement now support both a starting and ending position.&#183;OCT$ function has been expanded to 64-bits with formatting and now supports adding leading and trailing spaces to the string result.&#183;OPEN statement has been improved with the CHR clause. The CHR clause specifies the character mode for this file: ANSI or WIDE (Unicode). Since sequential files consist of text alone, the selected mode is enforced by PowerBASIC. All data read or written to the file is automatically forced to the selected mode, regardless of the type of variables or expressions used. With binary or random files, this specification has no effect, but it may be included in your code for self-documentation purposes.&#183;PATHNAME$ function has been enhanced to accept relative path names.&#183;POKE statement now supports multiple data items to be stored successively.&#183;PROPERTY/END PROPERTY statements have been expanded to support an optional THREADSAFE descriptor. With the THREADSAFE option, PowerBASIC automatically establishes a semaphore which allows only one thread to execute the procedure at a time.&#183;PUT$ statement has been expanded to support Unicode string expressions. If string expressions result is a Unicode string, it is converted to ANSI byte characters.&#183;SELECT CASE/END SELECT block has been improved with the CONST$$ modifier to enhance performance when the controlling expression is Unicode.&#183;SUB/END SUB statements have been expanded to support an optional THREADSAFE descriptor. With the THREADSAFE option, PowerBASIC automatically establishes a semaphore which allows only one thread to execute the procedure at a time.&#183;TOOLBAR ADD SEPARATOR statement has been improved with an optional unique numeric identifier. This identifier may be used later with a BYCMD option in TOOLBAR DELETE, TOOLBAR SET STATE, etc.&#183;TRIM$ function has been expanded to take a numeric expression and convert it to a string without any leading or trailing spaces along with an option specify the maximum number of significant digits.&#183;UCODEPAGE statement now supports the OEM code page. By default, the system ANSI code page, is used to map the character translation. If you are compiling a CONSOLE application or one which makes use of the high-order ANSI codes, CHR$(128) through CHR$(255) for line drawing and a few international characters, you should declare an OEM code page by placing UCODEPAGE OEM at the start of your PBMain function.&#183;VAL function has been enhanced with an optional parameter to specify the position in the string where the conversion should begin.&#183;VARIANT$ and VARIANT$$ used to return strings based on the contents of the variant. VARIANT$ now assumes the contents of the variant is a wide Unicode string and converts it to a ANSI string. VARIANT$$ assumes the contents of the variant is a wide Unicode string and returns the contents directly as a wide Unicode string. VARIANT$(BYTE, VrntVar) always returns the contents as an ANSI byte string. This result can be assigned to an ANSI string variable or a User-Defined Type.&#183;XPRINT ATTACH CHOOSE statement has been expanded to support optional numeric expression to control the execution of the Printer Dialog.&#183;XPRINT COLOR statement now supports parameters of -3 to indicate that the existing color should not be changed.&#183;XPRINT PRINT statement has been expanded to support POS(), SPC(), TAB(), commas, and semicolons. The POS(n) clause is an optional function used to set the POS to the horizontal page unit. Multiple uses of the POS function is permitted in a single statement. The SPC(n) clause is an optional function used to insert n spaces into the printed output. Multiple use of SPC is permitted in a single statement. The TAB(n) clause is an optional function used to tab to the nth column before printing the next expression. Multiple use of TAB is permitted in a single statement.&#183;XPRINT SET FONT statement resets back to the default original font chosen by PowerBASIC when a font handle of zero is specified,\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rNew Statements and Functions\n\r\n\rNew in the IDE\n\r\n\rAdditional Changes","Changes to existing Statements and Functions","scr\\html_changes_to_existing_statements_and_functions.htm","                  \n\r\n\rA string consists of a set of zero or more characters. A character is an alphabetic letter, a number, a punctuation mark, or even non-printing control codes, which usually aid in formatting the text. On a computer, a character is represented by a specific number associated with it. For example, the character &quot;A&quot; is usually represented by the number 65, while the character &quot;3&quot; is usually associated with the number 51.\n\r\n\rThis representation is convenient, since a string of text characters can be readily stored as a series of small integral numbers. For example, the word &quot;Hello&quot; is stored as 72, 105, 108, 108, 111. Couldn\'t be any simpler. How are the numbers assigned and associated? &nbsp;It\'s just a matter of mutual consent by those who use them. As long as everyone agrees on the associations, the system works well. That said, we have experienced a certain amount of growing pains over the years. With the global growth of computer use, larger character sets are needed to represent the necessary characters. We have clearly reached the point where every programmer must consider alternate character sets for his applications. Failure to do so can carry severe penalties. When you find you can no longer read data files from an outside source, or can no longer read text from the Internet, it will be too late. The following sections describe the most-common and most-used character sets.\n\r\n\rASCII\n\r\n\rASCII was the first character set to be used on small computers. In fact, all of the other sets described here use ASCII codes as-is for a base. ASCII is a set of 128 characters, numbered from 0 to 127. It was designed for American English, so it defines only unaccented letters, numbers, punctuation, and control codes. As long as you only need English text, ASCII works fairly well.\n\r\n\rASCII needs just 7 bits of storage per character, so it was convenient to store each character in a byte. The last bit was simply ignored. Of course, that meant that the values from 128 to 255 were unused. That void wouldn\'t last long.\n\r\n\rOEM\n\r\n\rOEM is the acronym for &quot;Original Equipment Manufacturer&quot;. IBM introduced the IBM PC in 1981. Along with it came their version of an expanded character set. It\'s been known as the OEM character set ever since. In fact, that character set is still the default for the Windows Console Device on the very latest version of Windows.\n\r\n\rThe first 128 characters are identical to ASCII. However, IBM decided to use the remaining 128 characters for other purposes. They defined them for the most common accented characters, line drawing characters, and special symbols and punctuation. Of course, this was an improvement, but many characters in non-English languages were unavailable. This led to new OEM character sets (German, Cyrillic...), with many different interpretations for that second set of character codes. Of course, this caused a good amount of confusion trying to understand the contents of strings from an external source. Not an ideal solution.\n\r\n\rANSI\n\r\n\rSome time later, the ANSI character set evolved. Once again, the first 128 characters are the same as ASCII. But there are many ways to handle the second set. The decoding system, called &quot;code pages&quot;, handles these items accurately, even if cumbersome. In reality, many languages need hundreds or thousands of characters. Clearly, the character codes can\'t possibly be squeezed into a byte. The solution? &nbsp;Multi-byte characters. Some characters are one byte, and some are more. If a particular character needs a multi-byte representation, a special ID byte is inserted, followed by the identifying data. A multi-byte character may consist of two, three, or even more bytes. That special ID byte determines what data will follow.\n\r\n\rMulti-byte ANSI imposes a unique problem. You can\'t just scan your way through a string, byte-by-byte. Some characters are multi-byte! &nbsp;You must use care to treat them accurately, or your data will be destroyed. A word of warning... it\'s virtually impossible to scan backwards through a multi-byte string. That\'s because ANSI uses the same numeric values for both the ID byte, and the data which follows. When you look backwards and find an ID value, you can\'t tell if it\'s an ID or data. It just won\'t work well.\n\r\n\rUNICODE\n\r\n\rUnicode was created to represent every language into a single character set. While there are several Unicode formats, we\'ll concentrate on the only two varieties with real usage: &nbsp;UTF-8 and UTF-16. PowerBASIC uses UTF-16, which stores each character as a two-byte unsigned word. UTF-16 is used natively by Windows, COM, Visual Basic, Java, etc.\n\r\n\rUTF-16 UNICODE\n\r\n\rJust as before, the first 128 values represent ASCII characters. Other characters, primarily in non-English languages, have been assigned the higher values. At this time, and for the foreseeable future, UTF-16 is the character set of choice for all of your applications. It is the best way to store all of your data to keep it secure and understandable.\n\r\n\rUTF-8 UNICODE\n\r\n\rUTF-8 is somewhat of a hybrid between ANSI and UTF-16. It is used when the size of the text is of utmost importance. That makes it an obvious choice for downloading from the Internet. UTF-8 uses the same single byte characters for ASCII values. Further, it even uses the identical algorithm for multi-byte character, with one glowing exception: &nbsp;the ID byte and the data bytes are always unique! &nbsp;With that knowledge in hand, it is possible to scan backwards from any position. PowerBASIC does not support the use of UTF-8 within standard code. That\'s because UTF-8 is much slower in performance than UTF-16. That said, PowerBASIC does provide conversion functions to/from UTF-8, so you have it readily available for all of your Internet applications. UTF-8 files are byte orientated and should be opened as an ANSI file (CHR=ANSI).\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\r#OPTION metastatement\n\r\n\rACODE$ function\n\r\n\rChrToOem$ function\n\r\n\rChrToUtf8$ function\n\r\n\rOemToChr$ function\n\r\n\rUCODE$ function\n\r\n\rUCODEPAGE statement\n\r\n\rUtf8ToChr$ function\n\r\n\rDynamic (Variable-length) strings ($)\n\r\n\rFIELD strings\n\r\n\rFixed-length strings\n\r\n\rNul-Terminated Strings","Characters, Strings, and Unicode","scr\\html_characters_strings_and_unicode.htm","                  \n\r\n\rPurpose\n\r\n\rChange the current (default) directory on the default drive, or any other drive (similar to the DOS CHDIR command). CHDIR affects only the default drive for the current program.\n\r\n\rSyntax\n\r\n\rCHDIR path\n\r\n\rRemarks\n\r\n\rpath is a string expression containing either a relative or an explicit directory name. The directory name can be constructed from a (DOS-Style) Short File Name (SFN) directory name, a Long File Name (LFN) directory name, or a combination of the two. Also, path may be prefixed with a drive letter and colon (i.e., &quot;D:&quot;) to change the current directory on a non-default drive.\n\r\n\rThe current directory is the location where your program will perform file operations by default. Thus:\n\r\n\rCHDIR &quot;\\DATA&quot;\n\r\n\rchanges to the \\DATA subdirectory on the current drive, and:\n\r\n\rCHDIR &quot;..\\DATA2&quot;\n\r\n\rchanges the current directory to a directory whose parent is also the parent to the original directory. The double-period implies the parent directory.\n\r\n\rCHDIR &quot;J:\\Program Files\\Internet Explorer&quot;\n\r\n\rchanges the current directory of Drive J. Drive J need not be the current default drive.\n\r\n\rIf path does not specify a valid directory on the target drive, a run-time Error 76 occurs (&quot;Path not found&quot;).\n\r\n\rA program that changes the current directory on the default drive also changes its active directory.\n\r\n\rpath may also be used with UNC names (i.e., \\\\server\\share), but their use is subject to operating system restrictions.\n\r\n\rRestrictions\n\r\n\rCHDIR is not intended to change the current default drive. Use CHDRIVE instead.\n\r\n\rSee also\n\r\n\rCHDRIVE, CURDIR$, MKDIR, RMDIR","CHDIR statement","scr\\html_chdir_statement.htm","                  \n\r\n\rPurpose\n\r\n\rChange the current default drive.\n\r\n\rSyntax\n\r\n\rCHDRIVE drive\n\r\n\rRemarks\n\r\n\rdrive is a string expression whose first character is a letter from A to the highest logical drive letter. The trailing colon (:) that DOS uses is optional in PowerBASIC. If drive does not indicate a valid drive, a run-time Error 76 occurs (&quot;Path not found&quot;).\n\r\n\rSee also\n\r\n\rCHDIR, CURDIR$, MKDIR, RMDIR\n\r\n\rExample\n\r\n\rSDrive$ = &quot;C&quot;\n\r\n\rCHDRIVE SDrive$ &nbsp; \' change to the C: drive","CHDRIVE statement","scr\\html_chdrive_statement.htm","                  \n\r\n\rPurpose\n\r\n\rReturn one of several values, based upon the value of an index.\n\r\n\rSyntax\n\r\n\ry &nbsp;= CHOOSE(index&amp;,  choice1 [, choice2] ...[ELSE choice9])\n\r\n\ry&amp; = CHOOSE&amp;(index&amp;, choice1 [, choice2] ...[ELSE choice9])\n\r\n\ry$ = CHOOSE$(index&amp;, choice1 [, choice2] ...[ELSE choice9])\n\r\n\ry &nbsp;= CHOOSE([BIT] &nbsp; index&amp;, choice1 [, choice2] ...[ELSE choice9])\n\r\n\ry&amp; = CHOOSE&amp;([BIT] &nbsp;index&amp;, choice1 [, choice2] ...[ELSE choice9])\n\r\n\ry$ = CHOOSE$([BIT] &nbsp;index&amp;, choice1 [, choice2] ...[ELSE choice9])\n\r\n\ry$ = CHOOSE$([BITS] index&amp;, choice1 [, choice2] ...[ELSE choice9])\n\r\n\rRemarks\n\r\n\rThese functions may take any number of choice parameters. They return one of the parameters, or a combination of them, based upon the value of index&amp;. In the standard form, index&amp; makes the choice based upon the sequence of the parameters. That is, if index&amp; is one, choice1 is returned. If two, choice2 is returned, etc. If index&amp; is not equal to one of the choice values, the default value is returned to the calling code.\n\r\n\rCHOOSE expects choices of any numeric type. CHOOSE&amp; expects choices optimized for an integral data type. CHOOSE$ expects choices of string type. CHOOSE% is recognized as a valid synonym for CHOOSE&amp;.\n\r\n\rELSE\n\r\n\rIf no match is made with one of the choice values, the value zero (0) or an empty (zero-length) string is normally returned. However, if an ELSE clause is included as the last choice, its value is returned as the default value. For example:\n\r\n\rChoiceVar$ = CHOOSE$(7,&quot;ONE&quot;, &quot;TWO&quot; ELSE &quot;NUL&quot;)\n\r\n\rIn this case, the ELSE expression &quot;NUL&quot; is returned.\n\r\n\rBIT\n\r\n\rIf the BIT option is included, the selection is based upon the first bit set (lowest to highest) in index&amp;. That is, the lowest bit (1) returns choice1, the next bit (2) returns choice2, the next bit (4) returns choice3, the next bit(8) returns choice4, etc. Evaluation of index&amp; stops as soon as one set bit is found. This is particularly valuable when used with an ENUMERATION which also uses the BIT option, to describe a set of attributes for an item in your program.\n\r\n\rBITS\n\r\n\rThis is similar to the BIT option, but is only available with the CHOOSE$() version. index&amp; is evaluated in the same general fashion, but the function may return multiple choices, as a concatenated string, if more than one bit is set. For example:\n\r\n\rx$ = CHOOSE$(BITS 5, &quot;Computer &quot;, &quot;Laptop &quot;, &quot;Desktop &quot;)\n\r\n\rSince the value 5 consists of 2 bits (the lowest and third-lowest) set, the first and third strings are concatenated and returned to the caller. In this case, &quot;Computer Desktop &quot; is the result.\n\r\n\rRestrictions\n\r\n\rPowerBASIC only evaluates the selected choice(s) at run-time, not all of them. This ensures optimum execution speed, as well as the elimination of unanticipated side effects.\n\r\n\rSee also\n\r\n\rIIF, IIF&amp;, IIF$, MAX, MAX&amp;, MAX$, MIN, MIN&amp;, MIN$, SWITCH, SWITCH&amp;, SWITCH$, SELECT\n\r\n\rExample\n\r\n\ry&amp; = 4\n\r\n\ra$ = CHOOSE$(y&amp;, &quot;Bill&quot;, &quot;Bob&quot;, &quot;Bruce&quot;, &quot;Barry&quot;)\n\r\n\rResult\n\r\n\ra$ = &quot;Barry&quot;","CHOOSE function","scr\\html_choose_function.htm","                  \n\r\n\rPurpose\n\r\n\rConverts one or more numeric character codes (ANSI or UNICODE), code ranges, and/or strings into a single string containing the corresponding character(s).\n\r\n\rSyntax\n\r\n\rs$ &nbsp;= CHR$(expression [,expression] [,...])\n\r\n\rs$ &nbsp;= CHR$(string_expression [,...])\n\r\n\rs$$ = CHR$$(x&amp; TO y&amp;, ...)\n\r\n\rRemarks\n\r\n\rThe CHR$() form of the function creates a string of ANSI (1-byte) characters. Arguments must be ANSI (1-byte) characters, or codes in the range of 0 to 255. The CHR$$() form of the function creates a string of WIDE (2-byte) characters. Arguments must be WIDE (2-byte) characters, or codes in the range of 0 to 65535. \n\r\n\rGenerally speaking, PowerBASIC handles ANSI/WIDE conversions for you, automatically and transparently. However, there are just a few functions (CHR$, PEEK$, POKE$, STRING$, etc.) which are ambiguous, by definition, and require that the programmer choose the appropriate result type (ANSI or WIDE). Use CHR$ for ANSI results, or use CHR$$ for Unicode results. In the remainder of these remarks, CHR$ is used to represent both CHR$ and CHR$$.\n\r\n\rCHR$ creates and returns a string. There are three forms of arguments available, and they may be intermixed in a single CHR$ function. The created string may contain no characters, one character, or multiple characters, depending upon the arguments you use. You may specify any number of arguments for this function.\n\r\n\rIf the argument is a numeric expression, it is translated into the character defined by that number. A character code of -1 is treated as a special case. If you use it as an argument, CHR$ returns an empty (zero length) string for that character. For example, CHR$(65, -1, 66) returns &quot;AB&quot;.\n\r\n\rCHR$(x&amp; TO y&amp;) returns a sequence of all characters from CHR$(x&amp;) through CHR$(y&amp;) inclusive. The characters may be ascending or descending in sequence. For example, CHR$(65 TO 70) returns the string &quot;ABCDEF&quot;. CHR$(52 T0 50) returns the string &quot;432&quot;, and CHR$(65 TO 65) returns the string &quot;A&quot;.\n\r\n\rIf the argument is a string expression, the characters are simply copied into the newly created string at the specified position. The expanded CHR$ definition is intended to assist in the encoding of longer strings, to avoid the need for concatenation operations.\n\r\n\rFor example, the CHR$ function can be used to create COLLATE strings for the ARRAY SORT and ARRAY SCAN statements at run-time, and can be used to create string equates at compile time:\n\r\n\r$colstring = CHR$(0 TO 131, 97, 133 TO 255)\n\r\n\rThe following lines are functionally equivalent, and return the same string result:\n\r\n\ra$ = CHR$(&quot;Line1&quot;, 13, 10, &quot;Line2&quot;)\n\r\n\ra$ = &quot;Line1&quot; &amp; CHR$(13) &amp; CHR$(10) &amp; &quot;Line2&quot;\n\r\n\ra$ = &quot;Line1&quot; &amp; $CRLF &amp; &quot;Line2&quot;\n\r\n\rCHR$ complements the ASC function, which returns the numeric character code of a nominated character in a string.\n\r\n\rSee also\n\r\n\rARRAY SCAN, ARRAY SORT, ASC function, ASC statement, NUL$, SPACE$, STRING$\n\r\n\rExample\n\r\n\rH$ = CHR$(&quot;a$=&quot;, $DQ, 33, $DQ+$DQ, 35 TO 39, 40, $DQ)\n\r\n\rResult\n\r\n\ra$=&quot;!&quot;&quot;#$%&amp;\'(&quot;","CHR$$ function","scr\\html_chr_function.htm","                  \n\r\n\rPurpose\n\r\n\rDetermine the size of a single character in a string variable.\n\r\n\rSyntax\n\r\n\rsiz&amp; = CHRBYTES(MyStringVar)\n\r\n\rRemarks\n\r\n\rThis function is used to determine whether a particular string variable contains ANSI characters or Unicode (wide) characters, ANSI characters are stored in 1 byte, so the function returns 1 if the variable is a dynamic string, stringz, string*n, or field string. Unicode characters are stored in 2 bytes, so the function returns 2 if the variable is a wstring, wstringz, wstring*n, or wfield string. This function may be particularly valuable in some macros which use string variables.\n\r\n\rSee Also\n\r\n\rLEN, SIZEOF","CHRBYTES function","scr\\html_chrbytes_function.htm","                  \n\r\n\rPurpose\n\r\n\rTranslates a string of ANSI/WIDE characters to OEM byte characters.\n\r\n\rSyntax\n\r\n\ro$ = ChrToOem$(AnsiOrWide$)\n\r\n\rRemarks\n\r\n\rAnsiOrWide$ contains a series of ANSI characters or WIDE (16-bit) characters, &nbsp;ChrToOem$ translates it into OEM byte characters.\n\r\n\rSee also\n\r\n\rOemToChr$, ChrToUtf8$, Utf8ToChr$","ChrToOem$ function","scr\\html_chrtooem$_function.htm","                  \n\r\n\rPurpose\n\r\n\rTranslates a string of ANSI/WIDE characters to UTF-8 byte characters.\n\r\n\rSyntax\n\r\n\ro$ = ChrToUtf8$(AnsiOrWide$)\n\r\n\rRemarks\n\r\n\rAnsiOrWide$ contains a series of ANSI characters or WIDE (16-bit) characters, &nbsp;ChrToUtf8$ translates it into UTF-8 byte characters.\n\r\n\rSee also\n\r\n\rChrToOem$, OemToChr$, Utf8ToChr$","ChrToUtf8$ function","scr\\html_chrtoutf8$_function.htm","                  \n\r\n\rPurpose\n\r\n\rCreate the code and data for an object.\n\r\n\rSyntax\n\r\n\rCLASS name &nbsp;[$GUID] [COMMON] [OPTIMIZE] [AS COM | AS EVENT]\n\r\n\r  Class Method code blocks...\n\r\n\r &nbsp; &nbsp;INSTANCE ClassName AS STRING\n\r\n\r &nbsp; &nbsp;INTERFACE name $GUID &nbsp;[AS EVENT]\n\r\n\r &nbsp; &nbsp;INHERIT IUNKNOWN\n\r\n\r &nbsp; &nbsp;Method and Property code blocks...\n\r\n\r &nbsp;END INTERFACE\n\r\n\r &nbsp;EVENT SOURCE interface-name\n\r\n\rEND CLASS\n\r\n\rRemarks\n\r\n\rCLASS / END CLASS statements enclose the Interface implementation(s) &nbsp;and Instance variable declarations of a Class. METHOD and PROPERTY blocks contain the code to be executed on an object. INSTANCE statements define the variables which are unique to each instance of an object of this class.\n\r\n\rThe name and optional $GUID are supplied by the programmer to identify the class. By default, a class is considered private, so that the methods are accessible only from within the EXE or DLL where it is defined. The AS COM attribute makes the class available externally, to virtually any process which is COM-aware.\n\r\n\rWith a private class, the $GUID may be freely omitted, as PowerBASIC can readily identify the class by name. With a published COM class, you should insert a specific GUID of your choice. If omitted, a &nbsp;random GUID will be created by the compiler, but it will change every time you compile the program. This will be difficult to synchronize with other programs which wish to identify and access your object.\n\r\n\rCOMMON\n\r\n\rThe optional COMMON descriptor may be included to specify that this class may be freely referenced by and between linked unit modules (Host/Main or SLL). This has the added side effect of ensuring that the class will not be removed by #OPTIMIZE CODE ON.\n\r\n\rAS EVENT\n\r\n\rIf a class is an Event Source (it generates events rather than handling events), one or more EVENT SOURCE statements are included to name the event interfaces. The event interfaces must be declared and implemented separately. An event is generated by executing a RAISEEVENT statement or an OBJECT RAISEEVENT statement in the class. If a class is an Event Handler (it contains code to handle an event generated by an Event Source), the AS EVENT attribute must appear on the CLASS statement and each INTERFACE statement. An Event Handler is also known as an &quot;Event Sink&quot;, using COM terminology.\n\r\n\rOPTIMIZE\n\r\n\rWith code optimization enabled (#OPTIMIZE CODE ON), PowerBASIC removes code for subs and functions which are not called. Where possible, this technique is even applied to individual methods and property methods within classes.\n\r\n\rOf course, if an object variable is transferred out of the current module (to another EXE/SLL/DLL), there is no way to determine (at compile-time) which methods may be called on it at run-time, so none can be safely removed. COM, COMMON, and EVENT classes allow variables to be transferred out of the module, so they block removal of any code in the class.\n\r\n\rThe OPTIMIZE descriptor allows you to control this code optimization to a high degree. If you specify the OPTIMIZE option, you are stating that no object variables on this class will be transferred out of the module. Therefore, PowerBASIC is free to remove any code in the class which is not referenced. This is a powerful tool which can allow you to substantially reduce the size of your program.\n\r\n\rThe OPTIMIZE rules can be summarized:1.If a class is marked COM, COMMON, or EVENT, no methods or property methods are ever removed from it.2.If a class is marked OPTIMIZE, you state that no object variables from this class will be transferred out of the module. Methods which are not referenced are removed from the final code. OPTIMIZE may not be combined with COM, COMMON, or EVENT.3.If no classes in the module are marked COM, COMMON, or EVENT, all classes are considered to be marked OPTIMIZE. All methods in all classes which are not referenced are extracted from the final code.\n\r\n\rSee also\n\r\n\r#OPTIMIZE, EVENT SOURCE, EVENTS, INSTANCE, INTERFACE (Direct), INTERFACE (IDBind),  Just what is COM?, METHOD, PROPERTY, RAISEEVENT, What is an object, anyway?","CLASS/END CLASS block","scr\\html_class_end_class_block.htm","                  \n\r\n\rPurpose\n\r\n\rDelete characters from a string.\n\r\n\rSyntax\n\r\n\rs$ = CLIP$(LEFT  StringExpression, Count&amp;)\n\r\n\rs$ = CLIP$(RIGHT StringExpression, Count&amp;)\n\r\n\rs$ = CLIP$(MID &nbsp; StringExpression, Start&amp;, Count&amp;)\n\r\n\rRemarks\n\r\n\rLEFT\n\r\n\rReturns the contents of StringExpression with Count&amp; characters removed from the left side.\n\r\n\rRIGHT\n\r\n\rReturns the contents of StringExpression with Count&amp; characters removed from the right side.\n\r\n\rMID\n\r\n\rReturns the contents of StringExpression with Count&amp; characters removed starting at position Start&amp;. The first character is considered position 1, the second position 2...\n\r\n\rIf Count&amp; is negative, or Start&amp; is less than one, the return value is undefined.\n\r\n\rRestrictions\n\r\n\rIf Count&amp; is less than one, the entire string is returned. If Start&amp; is less than one, the results are undefined.\n\r\n\rSee also\n\r\n\rEXTRACT$, LTRIM$, MID$, REMOVE$, REPLACE, RTRIM$, SHRINK$, STRINSERT$, STRDELETE$, TRIM$, UNWRAP$","CLIP$ function","scr\\html_clip$_function.htm","                  \n\r\n\rPurpose\n\r\n\rCopy data to/from the Windows ClipBoard.\n\r\n\rSyntax\n\r\n\rCLIPBOARD GET BITMAP &nbsp;TO ClipVar [, ClipResult]\n\r\n\rCLIPBOARD GET OEMTEXT TO AnsiStrgVar [, ClipResult]\n\r\n\rCLIPBOARD GET TEXT &nbsp; &nbsp;TO StrgVar [, ClipResult]\n\r\n\rCLIPBOARD GET UNICODE TO StrgVar [, ClipResult]\n\r\n\rCLIPBOARD RESET [, ClipResult]\n\r\n\rCLIPBOARD SET BITMAP  ClipHndl [, ClipResult]\n\r\n\rCLIPBOARD SET OEMTEXT StrgExpr [, ClipResult]\n\r\n\rCLIPBOARD SET TEXT &nbsp;  StrgExpr [, ClipResult]\n\r\n\rCLIPBOARD SET UNICODE StrgExpr [, ClipResult]\n\r\n\rClipHndl\n\r\n\rA Long Integer or Dword value which specifies the 32-bit handle of a GRAPHIC BITMAP passed to the clipboard.\n\r\n\rClipResult\n\r\n\rA Long Integer or Dword variable which receives a true result (-1) if the operation was successful, or a false result (0) if it failed.\n\r\n\rClipVar\n\r\n\rA Long Integer or Dword variable which receives a 32-bit handle of a newly created GRAPHIC BITMAP.\n\r\n\rStrgExpr\n\r\n\rA string expression which specifies data to be passed to the clipboard.\n\r\n\rStrgVar\n\r\n\rA string variable which receives string data from the clipboard.\n\r\n\rRemarks\n\r\n\rThe Windows ClipBoard provides support for the transfer of various types of data between applications, or even different parts of a single application. The concept is simple -- save some data on the ClipBoard and retrieve it later. In most cases, it\'s just used to transfer plain text, so the PowerBASIC CLIPBOARD statement concentrates on the common data formats. With text transfer, you can just read or write a string. With bitmaps, a GRAPHIC BITMAP is used for this purpose.\n\r\n\rWhen you retrieve data using CLIPBOARD, the original copy always remains in the CLIPBOARD, so the operation can be repeated any number of times. When you store data on the CLIPBOARD, your original copy remains unchanged. The data is copied, with no change of ownership.\n\r\n\rThe clipboard can hold multiple data items, but only one of each data format at a time. Generally speaking, multiple data items are only used to store a single piece of data in multiple formats to ensure it can be retrieved successfully later. However, you should note that Windows automatically converts string data between TEXT, OEMTEXT, and UNICODE. When you store data in one of those forms, it\'s not necessary to repeat it with the others.\n\r\n\rYou must execute a CLIPBOARD RESET to empty the clipboard before storing new data items.\n\r\n\rEach form of the CLIPBOARD statement offers an optional ClipResult variable. If the requested operation is deemed successful by Windows, this variable is assigned the value TRUE (-1). If it fails, the value FALSE (0) is assigned instead. You should note that the success test is not a comprehensive one. It tests only the operation, not the validity of the data.\n\r\n\rThere are nine general forms of the CLIPBOARD statement:\n\r\n\rCLIPBOARD GET BITMAP TO ClipVar [, ClipResult]\n\r\n\rA new GRAPHIC BITMAP is automatically created. A Bitmap is copied from the ClipBoard and stored in this newly created GRAPHIC BITMAP. The handle of the new GRAPHIC BITMAP is assigned to the ClipVar, a DWord or Long Integer variable. If the operation is not successful, the value zero (0) is assigned instead.\n\r\n\rCLIPBOARD GET OEMTEXT TO AnsiStrgVar [, ClipResult]\n\r\n\rA text string is retrieved from the CLIPBOARD, and assigned to the ANSI string variable specified by AnsiStrgVar. If necessary, it is converted to OEM Text format, the format used by the Windows Console. If no text can be retrieved, a nul (zero-length) string is assigned instead.\n\r\n\rCLIPBOARD GET TEXT TO StrgVar [, ClipResult]\n\r\n\rA text string is retrieved from the CLIPBOARD, and assigned to the string variable specified by StrgVar, which may be ANSI or WIDE format. If necessary, the text is automatically converted to match the format of the target variable. If no text can be retrieved, a nul (zero-length) string is assigned instead.\n\r\n\rCLIPBOARD RESET [, ClipResult]\n\r\n\rThe contents of the CLIPBOARD are deleted.\n\r\n\rCLIPBOARD SET BITMAP  ClipHndl [, ClipResult]\n\r\n\rA GRAPHIC BITMAP, specified by ClipHndl, is stored on the CLIPBOARD. The GRAPHIC BITMAP may be a GRAPHIC CONTROL, GRAPHIC WINDOW, or GRAPHIC BITMAP. When passing a GRAPHIC CONTROL to the Clipboard, use CONTROL HANDLE to obtain the handle to the GRAPHIC CONTROL.\n\r\n\rCLIPBOARD SET OEMTEXT StrgExpr [, ClipResult]\n\r\n\rA text string, specified by StrExpr, is stored on the CLIPBOARD. The string data is assumed to use characters in the OEM character set.\n\r\n\rCLIPBOARD SET TEXT StrgExpr [, ClipResult]\n\r\n\rA text string, specified by StrExpr, is stored on the CLIPBOARD. The string data may be in either ANSI or WIDE format.\n\r\n\rThe following two functions, with UNICODE options, were specifically designed for older versions of PowerBASIC which did not support wide Unicode strings. They may only be used with legacy programs which must store wide characters in an ANSI string variable. They should be converted to the TEXT option with wide string variables as soon as possible, as these forms of CLIPBOARD will not be supported in future versions of PowerBASIC.\n\r\n\r&nbsp;\n\r\n\rCLIPBOARD GET UNICODE TO AnsiStrgVar [, ClipResult]\n\r\n\rA text string is retrieved from the CLIPBOARD, and assigned to the ANSI string variable specified by AnsiStrgVar. Even though the string variable uses 1-byte ANSI characters, the data is represented as 2-byte wide Unicode characters. If no text can be retrieved, a nul (zero-length) string is assigned instead.\n\r\n\rCLIPBOARD SET UNICODE AnsiStrgExpr [, ClipResult]\n\r\n\rA UniCode text string, stored in ANSI variables and constants, is stored on the CLIPBOARD.","CLIPBOARD SET UNICODE statement","scr\\html_clipboard_statement.htm","                  \n\r\n\rPurpose\n\r\n\rConclude I/O (input/output) to / from a file or device.\n\r\n\rSyntax\n\r\n\rCLOSE [[#] filenum&amp; [, [#] filenum&amp;] ...]\n\r\n\rRemarks\n\r\n\rCLOSE ends the relationship between a PowerBASIC file number and the disk file or device that was associated with it by an OPEN statement. Any pending I/O operations on the file/device are concluded, buffers are flushed and released, and the disk directory information (if any) for that file is updated.\n\r\n\rIf no file number is specified, CLOSE closes all open files.\n\r\n\rIf the file was opened using OPEN HANDLE, the CLOSE statement is still needed, although it does not tell the operating system to close the file. In this special case, the file was already open when OPEN HANDLE provided access to it, and will remain open after CLOSE disassociates the file from PowerBASIC.\n\r\n\rCLOSE works with all types of files and devices (disk files, devices, COMM, TCP, UDP, etc).\n\r\n\rThe number symbols (#) are optional but recommended for clarity.\n\r\n\rSee also\n\r\n\rCOMM CLOSE, FILEATTR, FLUSH, OPEN, TCP CLOSE, UDP CLOSE","CLOSE statement","scr\\html_close_statement.htm","                  \n\r\n\rPurpose\n\r\n\rReturn a 16-byte GUID string (128-bit GUID format string) containing a CLSID associated with a unique ProgramID string of a COM object or component.\n\r\n\rSyntax\n\r\n\ra$ = CLSID$(ProgramID$)\n\r\n\rRemarks\n\r\n\rA CLSID string is a 128-bit (16-byte) binary string representing the GUID or UUID of a COM object/component. A CLSID string is not in a human-readable format.\n\r\n\rYou can convert textual ID name of a COM object/component into a CLSID string with the CLSID$ function. CLSID examines the system registry in order to determine the CLSID string associated with the ProgramID$ string.\n\r\n\rThe ProgramID$ parameter is not case-sensitive, so &quot;MSAGENT.CONTROL.2&quot;, &quot;MSAgent.Control.2&quot; and &quot;msagent.control.2&quot; all refer to the same COM object/component. If the ProgramID$ cannot be found, or if any error occurs during the lookup and conversion process, CLSID$ will not set the ERR system variable, but will return an empty string.\n\r\n\rTo convert the binary CLSID string into human-readable GUID/UUID format, use the GUIDTXT$ function. CLSID$ is the complement to the PROGID$ function.\n\r\n\rPowerBASIC programmers rarely, if ever, need to deal with CLSID strings in order to utilize a COM object or component. &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  \n\r\n\ra$\n\r\n\rThe return string may be assigned to a dynamic string, fixed-length or nul-terminated string (at least 16 bytes long), or (typically) a GUID variable. See DIM for more information.\n\r\n\rSee also\n\r\n\rDIM, GUID$, GUIDTXT$, INTERFACE (Direct), INTERFACE (IDBind), ISNOTHING, ISOBJECT, LET (with Objects), OBJECT, OBJACTIVE, OBJPTR, OBJRESULT, PROGID$, What does a Class look like?, What is an object, anyway?\n\r\n\rExample\n\r\n\rMSWordClassID$ = CLSID$(&quot;word.application.8&quot;)\n\r\n\rIF LEN(MSWordClassID$) = 16 THEN\n\r\n\r &nbsp;\' Success getting the CLSID$ of MSWord\n\r\n\r &nbsp;a$ = PROGID$(MSWordClassID$)\n\r\n\r &nbsp;\'a$ holds &quot;Word.Application.8&quot;\n\r\n\r &nbsp;b$ = GUIDTXT$(MSWordClassID$)\n\r\n\r &nbsp;\'b$ holds &quot;{000209FF-0000-0000-C000-000000000046}&quot;\n\r\n\rEND IF","CLSID$ function","scr\\html_clsid_function.htm","                  \n\r\n\rPurpose\n\r\n\rObtain a 32-bit address of a label, Sub, Function, or Fastproc, as well as ASMDATA blocks.\n\r\n\rSyntax\n\r\n\rAddrVar = CODEPTR(Label)\n\r\n\rAddrVar = CODEPTR(ProcName)\n\r\n\rRemarks\n\r\n\rCODEPTR retrieves the address of a Label, Sub, Function, or FastProc. The first form may be used to get the address of a label located within the same procedure. The second form is used to obtain the address of a Sub, Function, or FastProc. \n\r\n\rCODEPTR is particularly useful when it is necessary to pass the address of a SUB or FUNCTION to PowerBASIC or Windows to specify a Callback Function.\n\r\n\rRestrictions\n\r\n\rCODEPTR cannot obtain the address of a METHOD or PROPERTY as direct access to them would constitute an illegal operation.\n\r\n\rSee also\n\r\n\rSTRPTR, VARPTR, CALL DWORD\n\r\n\rExample\n\r\n\r#COMPILE EXE\n\r\n\rSUB MySub()\n\r\n\rEND SUB\n\r\n\r&nbsp;\n\r\n\rFUNCTION PBMAIN\n\r\n\r &nbsp;LOCAL MySubPtr AS LONG, X AS STRING\n\r\n\r &nbsp;MySubPtr = CODEPTR(MySub) \' Address of MySub()\n\r\n\r &nbsp;X = &quot;MySub() is located at address &quot; + FORMAT$(MySubPtr))\n\r\n\rEND FUNCTION","CODEPTR function","scr\\html_codeptr_function.htm","                  \n\r\n\rPurpose\n\r\n\rA collection object is a set of items which can be referred to as a unit. It provides a convenient way to refer to a related group of items as a single object. The items in a collection need only be related by the fact that they exist in the collection. They do not have to share the same data type.\n\r\n\rYou create a collection the same way you create other objects, but using a predefined internal class and a predefined internal interface.\n\r\n\rLOCAL Collect AS IPowerCollection\n\r\n\rLET Collect = CLASS &quot;PowerCollection&quot;\n\r\n\rOnce you have created a collection object, you can manipulate it using the member methods. Each data item in the set is stored as a variant variable, which may contain any valid data type (numeric, string, UDT, object, etc.). Collection interfaces are DUAL -- member methods may be referenced using either Direct or Dispatch form.\n\r\n\rWhile the collection object expects to receive your data items as variant variables, you can take advantage of the auto-conversion options in PowerBASIC. If a variant parameter is expected, and you pass a single variable instead, PowerBASIC will automatically convert it with no intervention needed on your part.\n\r\n\rVery often, it\'s convenient to create a collection of user defined types (UDT). While a variant may not normally contain a UDT, PowerBASIC offers a special methodology to do so. At programmer direction, a TYPE may be assigned to a variant (as a byte string) by using:\n\r\n\r[LET] VrntVar = TypeVar AS STRING\n\r\n\rIn the same manner, a UDT argument can be auto-converted to the variant type by appending AS STRING:\n\r\n\rCollObj.Add(Key$$, UDTVar AS STRING)\n\r\n\rThe data contained in the User-Defined Type variable (UDTVar) is stored in the variant argument as a dynamic string of bytes (vt_bstr). When the collection object retrieves that UDT data, it understands the content and handles it accurately. This special technique offers ease of coding and much improved execution speed. If you like, you can use the same sort of functionality in your own PowerBASIC code. However, you should keep in mind that other programming languages may not understand this technique, so it should be limited to PowerBASIC applications.\n\r\n\rPower Collection\n\r\n\rA Power Collection creates a set of data items, each of which is associated with an alpha-numeric string key which you define. The data item is passed and stored as a variant, while the key is passed and stored as a wide (Unicode) string. You can retrieve these data items directly by using their key, by their position in the collection, or sequentially in ascending or descending sequence.\n\r\n\rSyntax\n\r\n\rThe CLASS is &quot;PowerCollection&quot;. The INTERFACE is IPowerCollection (a DUAL interface).\n\r\n\r&lt;ObjectVar&gt;.membername(params)\n\r\n\rRetVal = &lt;ObjectVar&gt;.membername(params)\n\r\n\r&lt;ObjectVar&gt;.membername(params) TO ReturnVariable\n\r\n\rRemarks\n\r\n\rItems in a PowerCollection may be retrieved by their key using the ITEM method. They may be retrieved sequentially using the NEXT or PREVIOUS method. Each key in a PowerCollection must be unique. Keys in a PowerCollection are case-sensitive. To access the keys in a case-insensitive manner, you must create and retrieve all keys as either upper case or lower case, but not mixed.\n\r\n\rThe Dispatch ID (DispID) for each member method is displayed within angle brackets.\n\r\n\rPower Collection Methods\n\r\n\rADD &lt;3&gt; (PowerKey AS WString, PowerItem AS Variant)\n\r\n\rThe PowerItem variant is added to the end of the PowerCollection. It is associated with the PowerKey string for later retrieval. If the operation was successful, an HResult of S_OK (0) is returned. If it fails because of a duplicate key, an HResult of E_DUPLICATEKEY (&amp;H800A01C9) is returned, and an Object Error (99) is generated.\n\r\n\rCLEAR &lt;4&gt;\n\r\n\rAll PowerKeys and PowerItems are removed from the PowerCollection.\n\r\n\rCONTAINS &lt;5&gt; (PowerKey AS WString) AS Long\n\r\n\rThe PowerCollection is scanned to determine if the specified PowerKey is present. If found, the Index number of this Item (range of 1 - COUNT) is returned. This value will always evaluate as true. If not found, the value false (0) is returned.\n\r\n\rCOUNT &lt;6&gt; AS Long\n\r\n\rThe number of data items currently contained in the PowerCollection is returned to the caller.\n\r\n\rENTRY &lt;7&gt; (Index AS Long, OUT PowerKey as WString, OUT PowerItem as Variant)\n\r\n\rThe PowerCollection entry specified by the Index number is returned to the caller in the two specified OUT parameters. If the index number is less than one, or greater than the item count, the variant returned will be of type empty (VT_EMPTY), and the OBJRESULT will be %S_FALSE (1).\n\r\n\rFIRST &lt;1&gt; AS Long\n\r\n\rThe current INDEX for the PowerCOLLECTION is set to one (1), so that subsequent references to the NEXT method will access member items from the beginning. The previous value of the INDEX is returned to the caller.\n\r\n\rINDEX &lt;8&gt; (Index AS Long) AS Long\n\r\n\rThe current INDEX for the PowerCOLLECTION is set to the specified index number. If the parameter is less than one, or greater than the current count of data items, the INDEX is not changed. The previous value of the INDEX is returned to the caller.\n\r\n\rIndexVar&amp; = ObjectVar.INDEX(0)\n\r\n\rThe above example retrieves the current index number, without changing it, and assigns it to the variable IndexVar&amp;.\n\r\n\rITEM &lt;9&gt; (PowerKey AS WString) AS Variant\n\r\n\rThe PowerItem associated with the specified PowerKey is returned. If the specified key is not found, the variant returned will be of type empty (VT_EMPTY), and the OBJRESULT will be %S_FALSE (1).\n\r\n\rLAST &lt;10&gt; AS Long\n\r\n\rThe current INDEX for the PowerCOLLECTION is set to the last item so that subsequent references to the PREVIOUS method will access member items from the end. The previous value of the INDEX is returned to the caller.\n\r\n\rNEXT &lt;2&gt; AS Variant\n\r\n\rThe NEXT method allows the PowerCollection data items to be retrieved sequentially. Each time NEXT is referenced, the data item at the position specified by the INDEX is returned to the caller, and the INDEX is incremented. If the operation is successful, the OBJRESULT is set to %S_OK (0). When there are no more data items to retrieve, the OBJRESULT is set to %S_FALSE (1).\n\r\n\rPREVIOUS &lt;11&gt; AS Variant\n\r\n\rThe PREVIOUS method allows the PowerCollection data items to be retrieved sequentially. Each time PREVIOUS is referenced, the data item at the position specified by the INDEX is returned to the caller, and the INDEX is decremented. If the operation is successful, the OBJRESULT is set to %S_OK (0). When there are no more data items to retrieve, the OBJRESULT is set to %S_FALSE (1).\n\r\n\rREMOVE &lt;12&gt; (PowerKey AS WString)\n\r\n\rThe specified PowerKey, and the PowerItem associated with it, are removed from the PowerCollection. The index number of each data item past the removed item is decremented by one. If the requested PowerKey is not found, OBJRESULT returns %S_FALSE (1) and no operation is performed.\n\r\n\rREPLACE &lt;13&gt; (PowerKey AS WString, PowerItem AS Variant)\n\r\n\rThe PowerItem associated with the specified PowerKey is replaced by the new specified PowerItem. If the requested PowerKey is not found, OBJRESULT returns %S_FALSE (1) and no operation is performed.\n\r\n\rSORT &lt;14&gt; (Flags AS Long)\n\r\n\rThe data items in the PowerCollection are sorted based upon the text in the associated PowerKeys. If the parameter Flags is zero(0), the items are sorted in ascending sequence. If one (1), the items are sorted in descending sequence.\n\r\n\rLinkList Collection\n\r\n\rA Linked List Collection is an ordered set of data items, which are accessed by their position in the list rather than by an alphanumeric string key. Each data item is passed and stored as a variant variable. You can retrieve these data items by their position number, or sequentially in ascending or descending sequence.\n\r\n\rSyntax\n\r\n\rThe CLASS is &quot;LinkListCollection&quot;. The INTERFACE is ILinkListCollection (a DUAL interface).\n\r\n\r&lt;ObjectVar&gt;.membername(params)\n\r\n\rRetVal = &lt;ObjectVar&gt;.membername(params)\n\r\n\r&lt;ObjectVar&gt;.membername(params) TO ReturnVariable\n\r\n\rRemarks\n\r\n\rItems in a LinkListCollection may be retrieved by their position number using the ITEM method. They may be retrieved sequentially using the NEXT or PREVIOUS methods.\n\r\n\rThe Dispatch ID (DispID) for each member method is displayed within angle brackets.\n\r\n\rLinkList Collection Methods\n\r\n\rADD &lt;3&gt; (PowerItem AS Variant)\n\r\n\rThe PowerItem variant is added to the end of the LinkListCollection.\n\r\n\rCLEAR &lt;4&gt;\n\r\n\rAll PowerItems are removed from the LinkListCollection.\n\r\n\rCOUNT &lt;5&gt; AS Long\n\r\n\rThe number of data items currently contained in the LinkListCollection is returned to the caller.\n\r\n\rFIRST &lt;1&gt; AS Long\n\r\n\rThe current INDEX for the LinkListCOLLECTION is set to one (1), so that subsequent references to the NEXT method will access member items from the beginning. The previous value of the INDEX is returned to the caller.\n\r\n\rINDEX &lt;6&gt; (Index AS Long) AS Long\n\r\n\rThe current INDEX for the LinkListCOLLECTION is set to the specified index number. If the parameter is less than one, or greater than current count of data items, the INDEX is not changed. The previous value of the INDEX is returned to the caller.\n\r\n\rIndexVar&amp; = ObjectVar.INDEX(0)\n\r\n\rThe above example retrieves the current index number, without changing it, and assigns it to the variable IndexVar&amp;.\n\r\n\rINSERT &lt;7&gt; (Index AS Long, PowerItem AS Variant)\n\r\n\rThe PowerItem variant is added to the collection at the position specified by the Index. If the index number is less than one, or greater than the count, the item is added to the end of the list.\n\r\n\rITEM &lt;8&gt; (Index AS Long) AS Variant\n\r\n\rThe PowerItem at the position specified by Index is returned. If the specified item is not present, the variant returned will be of type empty (VT_EMPTY), and the OBJRESULT will be %S_FALSE (1).\n\r\n\rLAST &lt;9&gt; AS Long\n\r\n\rThe current INDEX for the LinkListCOLLECTION is set to the last item so that subsequent references to the PREVIOUS method will access member items from the end. The previous value of the INDEX is returned to the caller.\n\r\n\rNEXT &lt;2&gt; AS Variant\n\r\n\rThe NEXT method allows the LinkListCollection data items to be retrieved sequentially. Each time NEXT is referenced, the data item at the position specified by the INDEX is returned to the caller, and the INDEX is incremented. If the operation is successful, the OBJRESULT is set to %S_OK (0). When there are no more data items to retrieve, the OBJRESULT is set to %S_FALSE (1).\n\r\n\rPREVIOUS &lt;10&gt; AS Variant\n\r\n\rThe PREVIOUS method allows the LinkListCollection data items to be retrieved sequentially. Each time PREVIOUS is referenced, the data item at the position specified by the INDEX is returned to the caller, and the INDEX is decremented. If the operation is successful, the OBJRESULT is set to %S_OK (0). When there are no more data items to retrieve, the OBJRESULT is set to %S_FALSE (1).\n\r\n\rREMOVE &lt;11&gt; (Index AS Long)\n\r\n\rThe PowerItem at the position specified by Index is removed from the LinkListCollection. The index number of each data item past the removed item is decremented by one. If the requested item is not present, OBJRESULT returns %S_FALSE (1) and no operation is performed.\n\r\n\rREPLACE &lt;12&gt; (Index AS Long, PowerItem AS Variant)\n\r\n\rThe PowerItem at the position specified by Index is replaced by the new specified PowerItem. If the requested PowerItem is not present, OBJRESULT returns %S_FALSE (1) and no operation is performed.\n\r\n\rStack Collection\n\r\n\rA Stack Collection is an ordered set of data items, which are accessed on a LIFO (Last-In / First-Out) basis. This collection follows the same algorithm as the machine stack on your Intel CPU. Each data item is passed and stored as a variant variable, using the PUSH and POP methods.\n\r\n\rSyntax\n\r\n\rThe CLASS is &quot;StackCollection&quot;. The INTERFACE is IStackCollection (a DUAL interface).\n\r\n\r&lt;ObjectVar&gt;.membername(params)\n\r\n\rRetVal = &lt;ObjectVar&gt;.membername(params)\n\r\n\r&lt;ObjectVar&gt;.membername(params) TO ReturnVariable\n\r\n\rRemarks\n\r\n\rThe Dispatch ID (DispID) for each member method is displayed within angle brackets.\n\r\n\rStack Collection Methods\n\r\n\rCLEAR &lt;1&gt;\n\r\n\rAll PowerItems are removed from the StackCollection.\n\r\n\rCOUNT &lt;2&gt; AS Long\n\r\n\rThe number of data items currently contained in the StackCollection is returned to the caller.\n\r\n\rPOP &lt;3&gt; AS Variant\n\r\n\rThe PowerItem at the &quot;Stack-Top&quot; (the item most recently added) is retrieved and returned to the caller. When there are no more data items to retrieve, the variant returned will be of type empty (VT_EMPTY), and the OBJRESULT will be %S_FALSE (1).\n\r\n\rPUSH &lt;4&gt; (PowerItem AS Variant)\n\r\n\rThe specified PowerItem is added to the StackCollection at the &quot;Stack-Top&quot; position.\n\r\n\rQueue Collection\n\r\n\rA Queue Collection is an ordered set of data items, which are accessed on a FIFO (First-In / First-Out) basis. Each data item is passed and stored as a variant variable, using the ENQUEUE and DEQUEUE methods.\n\r\n\rSyntax\n\r\n\rThe CLASS is &quot;QueueCollection&quot;. The INTERFACE is IQueueCollection (a DUAL interface).\n\r\n\r&lt;ObjectVar&gt;.membername(params)\n\r\n\rRetVal = &lt;ObjectVar&gt;.membername(params)\n\r\n\r&lt;ObjectVar&gt;.membername(params) TO ReturnVariable\n\r\n\rRemarks\n\r\n\rThe Dispatch ID (DispID) for each member method is displayed within angle brackets.\n\r\n\rQueue Collection Methods\n\r\n\rCLEAR &lt;1&gt;\n\r\n\rAll PowerItems are removed from the QueueCollection.\n\r\n\rCOUNT &lt;2&gt; AS Long\n\r\n\rThe number of data items currently contained in the QueueCollection is returned to the caller.\n\r\n\rDEQUEUE &lt;3&gt; AS Variant\n\r\n\rThe PowerItem at the &quot;oldest&quot; position is retrieved and returned to the caller. When there are no more data items to retrieve, the variant returned will be of type empty (VT_EMPTY), and the OBJRESULT will be %S_FALSE (1).\n\r\n\rENQUEUE &lt;4&gt; (PowerItem AS Variant)\n\r\n\rThe specified PowerItem is added to the QueueCollection at the &quot;newest&quot; position.\n\r\n\rSee Also\n\r\n\rFOR EACH/NEXT","StackCollection","scr\\html_collection_object_group.htm","                  \n\r\n\rPurpose\n\r\n\rA collection object is a set of items which can be referred to as a unit. It provides a convenient way to refer to a related group of items as a single object. The items in a collection need only be related by the fact that they exist in the collection. They do not have to share the same data type.\n\r\n\rYou create a collection the same way you create other objects, but using a predefined internal class and a predefined internal interface.\n\r\n\rLOCAL Collect AS IPowerCollection\n\r\n\rLET Collect = CLASS &quot;PowerCollection&quot;\n\r\n\rOnce you have created a collection object, you can manipulate it using the member methods. Each data item in the set is stored as a variant variable, which may contain any valid data type (numeric, string, UDT, object, etc.). Collection interfaces are DUAL -- member methods may be referenced using either Direct or Dispatch form.\n\r\n\rWhile the collection object expects to receive your data items as variant variables, you can take advantage of the auto-conversion options in PowerBASIC. If a variant parameter is expected, and you pass a single variable instead, PowerBASIC will automatically convert it with no intervention needed on your part.\n\r\n\rVery often, it\'s convenient to create a collection of user defined types (UDT). While a variant may not normally contain a UDT, PowerBASIC offers a special methodology to do so. At programmer direction, a TYPE may be assigned to a variant (as a byte string) by using:\n\r\n\r[LET] VrntVar = TypeVar AS STRING\n\r\n\rIn the same manner, a UDT argument can be auto-converted to the variant type by appending AS STRING:\n\r\n\rCollObj.Add(Key$$, UDTVar AS STRING)\n\r\n\rThe data contained in the User-Defined Type variable (UDTVar) is stored in the variant argument as a dynamic string of bytes (vt_bstr). When the collection object retrieves that UDT data, it understands the content and handles it accurately. This special technique offers ease of coding and much improved execution speed. If you like, you can use the same sort of functionality in your own PowerBASIC code. However, you should keep in mind that other programming languages may not understand this technique, so it should be limited to PowerBASIC applications.\n\r\n\rPower Collection\n\r\n\rA Power Collection creates a set of data items, each of which is associated with an alpha-numeric string key which you define. The data item is passed and stored as a variant, while the key is passed and stored as a wide (Unicode) string. You can retrieve these data items directly by using their key, by their position in the collection, or sequentially in ascending or descending sequence.\n\r\n\rSyntax\n\r\n\rThe CLASS is &quot;PowerCollection&quot;. The INTERFACE is IPowerCollection (a DUAL interface).\n\r\n\r&lt;ObjectVar&gt;.membername(params)\n\r\n\rRetVal = &lt;ObjectVar&gt;.membername(params)\n\r\n\r&lt;ObjectVar&gt;.membername(params) TO ReturnVariable\n\r\n\rRemarks\n\r\n\rItems in a PowerCollection may be retrieved by their key using the ITEM method. They may be retrieved sequentially using the NEXT or PREVIOUS method. Each key in a PowerCollection must be unique. Keys in a PowerCollection are case-sensitive. To access the keys in a case-insensitive manner, you must create and retrieve all keys as either upper case or lower case, but not mixed.\n\r\n\rThe Dispatch ID (DispID) for each member method is displayed within angle brackets.\n\r\n\rPower Collection Methods\n\r\n\rADD &lt;3&gt; (PowerKey AS WString, PowerItem AS Variant)\n\r\n\rThe PowerItem variant is added to the end of the PowerCollection. It is associated with the PowerKey string for later retrieval. If the operation was successful, an HResult of S_OK (0) is returned. If it fails because of a duplicate key, an HResult of E_DUPLICATEKEY (&amp;H800A01C9) is returned, and an Object Error (99) is generated.\n\r\n\rCLEAR &lt;4&gt;\n\r\n\rAll PowerKeys and PowerItems are removed from the PowerCollection.\n\r\n\rCONTAINS &lt;5&gt; (PowerKey AS WString) AS Long\n\r\n\rThe PowerCollection is scanned to determine if the specified PowerKey is present. If found, the Index number of this Item (range of 1 - COUNT) is returned. This value will always evaluate as true. If not found, the value false (0) is returned.\n\r\n\rCOUNT &lt;6&gt; AS Long\n\r\n\rThe number of data items currently contained in the PowerCollection is returned to the caller.\n\r\n\rENTRY &lt;7&gt; (Index AS Long, OUT PowerKey as WString, OUT PowerItem as Variant)\n\r\n\rThe PowerCollection entry specified by the Index number is returned to the caller in the two specified OUT parameters. If the index number is less than one, or greater than the item count, the variant returned will be of type empty (VT_EMPTY), and the OBJRESULT will be %S_FALSE (1).\n\r\n\rFIRST &lt;1&gt; AS Long\n\r\n\rThe current INDEX for the PowerCOLLECTION is set to one (1), so that subsequent references to the NEXT method will access member items from the beginning. The previous value of the INDEX is returned to the caller.\n\r\n\rINDEX &lt;8&gt; (Index AS Long) AS Long\n\r\n\rThe current INDEX for the PowerCOLLECTION is set to the specified index number. If the parameter is less than one, or greater than the current count of data items, the INDEX is not changed. The previous value of the INDEX is returned to the caller.\n\r\n\rIndexVar&amp; = ObjectVar.INDEX(0)\n\r\n\rThe above example retrieves the current index number, without changing it, and assigns it to the variable IndexVar&amp;.\n\r\n\rITEM &lt;9&gt; (PowerKey AS WString) AS Variant\n\r\n\rThe PowerItem associated with the specified PowerKey is returned. If the specified key is not found, the variant returned will be of type empty (VT_EMPTY), and the OBJRESULT will be %S_FALSE (1).\n\r\n\rLAST &lt;10&gt; AS Long\n\r\n\rThe current INDEX for the PowerCOLLECTION is set to the last item so that subsequent references to the PREVIOUS method will access member items from the end. The previous value of the INDEX is returned to the caller.\n\r\n\rNEXT &lt;2&gt; AS Variant\n\r\n\rThe NEXT method allows the PowerCollection data items to be retrieved sequentially. Each time NEXT is referenced, the data item at the position specified by the INDEX is returned to the caller, and the INDEX is incremented. If the operation is successful, the OBJRESULT is set to %S_OK (0). When there are no more data items to retrieve, the OBJRESULT is set to %S_FALSE (1).\n\r\n\rPREVIOUS &lt;11&gt; AS Variant\n\r\n\rThe PREVIOUS method allows the PowerCollection data items to be retrieved sequentially. Each time PREVIOUS is referenced, the data item at the position specified by the INDEX is returned to the caller, and the INDEX is decremented. If the operation is successful, the OBJRESULT is set to %S_OK (0). When there are no more data items to retrieve, the OBJRESULT is set to %S_FALSE (1).\n\r\n\rREMOVE &lt;12&gt; (PowerKey AS WString)\n\r\n\rThe specified PowerKey, and the PowerItem associated with it, are removed from the PowerCollection. The index number of each data item past the removed item is decremented by one. If the requested PowerKey is not found, OBJRESULT returns %S_FALSE (1) and no operation is performed.\n\r\n\rREPLACE &lt;13&gt; (PowerKey AS WString, PowerItem AS Variant)\n\r\n\rThe PowerItem associated with the specified PowerKey is replaced by the new specified PowerItem. If the requested PowerKey is not found, OBJRESULT returns %S_FALSE (1) and no operation is performed.\n\r\n\rSORT &lt;14&gt; (Flags AS Long)\n\r\n\rThe data items in the PowerCollection are sorted based upon the text in the associated PowerKeys. If the parameter Flags is zero(0), the items are sorted in ascending sequence. If one (1), the items are sorted in descending sequence.\n\r\n\rLinkList Collection\n\r\n\rA Linked List Collection is an ordered set of data items, which are accessed by their position in the list rather than by an alphanumeric string key. Each data item is passed and stored as a variant variable. You can retrieve these data items by their position number, or sequentially in ascending or descending sequence.\n\r\n\rSyntax\n\r\n\rThe CLASS is &quot;LinkListCollection&quot;. The INTERFACE is ILinkListCollection (a DUAL interface).\n\r\n\r&lt;ObjectVar&gt;.membername(params)\n\r\n\rRetVal = &lt;ObjectVar&gt;.membername(params)\n\r\n\r&lt;ObjectVar&gt;.membername(params) TO ReturnVariable\n\r\n\rRemarks\n\r\n\rItems in a LinkListCollection may be retrieved by their position number using the ITEM method. They may be retrieved sequentially using the NEXT or PREVIOUS methods.\n\r\n\rThe Dispatch ID (DispID) for each member method is displayed within angle brackets.\n\r\n\rLinkList Collection Methods\n\r\n\rADD &lt;3&gt; (PowerItem AS Variant)\n\r\n\rThe PowerItem variant is added to the end of the LinkListCollection.\n\r\n\rCLEAR &lt;4&gt;\n\r\n\rAll PowerItems are removed from the LinkListCollection.\n\r\n\rCOUNT &lt;5&gt; AS Long\n\r\n\rThe number of data items currently contained in the LinkListCollection is returned to the caller.\n\r\n\rFIRST &lt;1&gt; AS Long\n\r\n\rThe current INDEX for the LinkListCOLLECTION is set to one (1), so that subsequent references to the NEXT method will access member items from the beginning. The previous value of the INDEX is returned to the caller.\n\r\n\rINDEX &lt;6&gt; (Index AS Long) AS Long\n\r\n\rThe current INDEX for the LinkListCOLLECTION is set to the specified index number. If the parameter is less than one, or greater than current count of data items, the INDEX is not changed. The previous value of the INDEX is returned to the caller.\n\r\n\rIndexVar&amp; = ObjectVar.INDEX(0)\n\r\n\rThe above example retrieves the current index number, without changing it, and assigns it to the variable IndexVar&amp;.\n\r\n\rINSERT &lt;7&gt; (Index AS Long, PowerItem AS Variant)\n\r\n\rThe PowerItem variant is added to the collection at the position specified by the Index. If the index number is less than one, or greater than the count, the item is added to the end of the list.\n\r\n\rITEM &lt;8&gt; (Index AS Long) AS Variant\n\r\n\rThe PowerItem at the position specified by Index is returned. If the specified item is not present, the variant returned will be of type empty (VT_EMPTY), and the OBJRESULT will be %S_FALSE (1).\n\r\n\rLAST &lt;9&gt; AS Long\n\r\n\rThe current INDEX for the LinkListCOLLECTION is set to the last item so that subsequent references to the PREVIOUS method will access member items from the end. The previous value of the INDEX is returned to the caller.\n\r\n\rNEXT &lt;2&gt; AS Variant\n\r\n\rThe NEXT method allows the LinkListCollection data items to be retrieved sequentially. Each time NEXT is referenced, the data item at the position specified by the INDEX is returned to the caller, and the INDEX is incremented. If the operation is successful, the OBJRESULT is set to %S_OK (0). When there are no more data items to retrieve, the OBJRESULT is set to %S_FALSE (1).\n\r\n\rPREVIOUS &lt;10&gt; AS Variant\n\r\n\rThe PREVIOUS method allows the LinkListCollection data items to be retrieved sequentially. Each time PREVIOUS is referenced, the data item at the position specified by the INDEX is returned to the caller, and the INDEX is decremented. If the operation is successful, the OBJRESULT is set to %S_OK (0). When there are no more data items to retrieve, the OBJRESULT is set to %S_FALSE (1).\n\r\n\rREMOVE &lt;11&gt; (Index AS Long)\n\r\n\rThe PowerItem at the position specified by Index is removed from the LinkListCollection. The index number of each data item past the removed item is decremented by one. If the requested item is not present, OBJRESULT returns %S_FALSE (1) and no operation is performed.\n\r\n\rREPLACE &lt;12&gt; (Index AS Long, PowerItem AS Variant)\n\r\n\rThe PowerItem at the position specified by Index is replaced by the new specified PowerItem. If the requested PowerItem is not present, OBJRESULT returns %S_FALSE (1) and no operation is performed.\n\r\n\rStack Collection\n\r\n\rA Stack Collection is an ordered set of data items, which are accessed on a LIFO (Last-In / First-Out) basis. This collection follows the same algorithm as the machine stack on your Intel CPU. Each data item is passed and stored as a variant variable, using the PUSH and POP methods.\n\r\n\rSyntax\n\r\n\rThe CLASS is &quot;StackCollection&quot;. The INTERFACE is IStackCollection (a DUAL interface).\n\r\n\r&lt;ObjectVar&gt;.membername(params)\n\r\n\rRetVal = &lt;ObjectVar&gt;.membername(params)\n\r\n\r&lt;ObjectVar&gt;.membername(params) TO ReturnVariable\n\r\n\rRemarks\n\r\n\rThe Dispatch ID (DispID) for each member method is displayed within angle brackets.\n\r\n\rStack Collection Methods\n\r\n\rCLEAR &lt;1&gt;\n\r\n\rAll PowerItems are removed from the StackCollection.\n\r\n\rCOUNT &lt;2&gt; AS Long\n\r\n\rThe number of data items currently contained in the StackCollection is returned to the caller.\n\r\n\rPOP &lt;3&gt; AS Variant\n\r\n\rThe PowerItem at the &quot;Stack-Top&quot; (the item most recently added) is retrieved and returned to the caller. When there are no more data items to retrieve, the variant returned will be of type empty (VT_EMPTY), and the OBJRESULT will be %S_FALSE (1).\n\r\n\rPUSH &lt;4&gt; (PowerItem AS Variant)\n\r\n\rThe specified PowerItem is added to the StackCollection at the &quot;Stack-Top&quot; position.\n\r\n\rQueue Collection\n\r\n\rA Queue Collection is an ordered set of data items, which are accessed on a FIFO (First-In / First-Out) basis. Each data item is passed and stored as a variant variable, using the ENQUEUE and DEQUEUE methods.\n\r\n\rSyntax\n\r\n\rThe CLASS is &quot;QueueCollection&quot;. The INTERFACE is IQueueCollection (a DUAL interface).\n\r\n\r&lt;ObjectVar&gt;.membername(params)\n\r\n\rRetVal = &lt;ObjectVar&gt;.membername(params)\n\r\n\r&lt;ObjectVar&gt;.membername(params) TO ReturnVariable\n\r\n\rRemarks\n\r\n\rThe Dispatch ID (DispID) for each member method is displayed within angle brackets.\n\r\n\rQueue Collection Methods\n\r\n\rCLEAR &lt;1&gt;\n\r\n\rAll PowerItems are removed from the QueueCollection.\n\r\n\rCOUNT &lt;2&gt; AS Long\n\r\n\rThe number of data items currently contained in the QueueCollection is returned to the caller.\n\r\n\rDEQUEUE &lt;3&gt; AS Variant\n\r\n\rThe PowerItem at the &quot;oldest&quot; position is retrieved and returned to the caller. When there are no more data items to retrieve, the variant returned will be of type empty (VT_EMPTY), and the OBJRESULT will be %S_FALSE (1).\n\r\n\rENQUEUE &lt;4&gt; (PowerItem AS Variant)\n\r\n\rThe specified PowerItem is added to the QueueCollection at the &quot;newest&quot; position.\n\r\n\rSee Also\n\r\n\rFOR EACH/NEXT","Collection Object Group","scr\\html_collection_object_group_2.htm","                  \n\r\n\rThe following operations provides a convenient way to refer to a related group of items:\n\r\n\rILinkListCollection.ADD\n\r\n\rAn item is added to the end of the LinkListCollection.\n\r\n\rILinkListCollection.CLEAR\n\r\n\rAll items are removed from the LinkListCollection.\n\r\n\rILinkListCollection.COUNT\n\r\n\rReturns the number of data items currently contained in the LinkListCollection.\n\r\n\rILinkListCollection.FIRST\n\r\n\rSets the index to the first item and returns the previous value.\n\r\n\rILinkListCollection.INDEX\n\r\n\rSets the index value and returns the previous value.\n\r\n\rILinkListCollection.INSERT\n\r\n\rAn item is added to the LinkListCollection at the specified position.\n\r\n\rILinkListCollection.ITEM\n\r\n\rReturns the item at the position specified in the LinkListCollection.\n\r\n\rILinkListCollection.LAST\n\r\n\rSets the index value to the last item and returns the previous value.\n\r\n\rILinkListCollection.NEXT\n\r\n\rReturns the next item in the LinkListCollection.\n\r\n\rILinkListCollection.PREVIOUS\n\r\n\rReturns the previous item in the LinkListCollection.\n\r\n\rILinkListCollection.REMOVE\n\r\n\rRemoves the item at the specified position from the LinkListCollection.\n\r\n\rILinkListCollection.REPLACE\n\r\n\rReplaces the item at the specified position with a new item in the LinkListCollection.\n\r\n\rIPowerCollection.ADD\n\r\n\rAn item and key is added to the end of the PowerCollection.\n\r\n\rIPowerCollection.CLEAR\n\r\n\rRemoves all items and keys from the PowerCollection.\n\r\n\rIPowerCollection.CONTAINS\n\r\n\rScans the PowerCollection for the specified key.\n\r\n\rIPowerCollection.COUNT\n\r\n\rReturns the number of data items currently contained in the PowerCollection.\n\r\n\rIPowerCollection.ENTRY\n\r\n\rReturns the PowerCollection item specified by the Index number.\n\r\n\rIPowerCollection.FIRST\n\r\n\rSets the index to the first item and returns the previous value.\n\r\n\rIPowerCollection.INDEX\n\r\n\rSets the index value and returns the previous value.\n\r\n\rIPowerCollection.ITEM\n\r\n\rReturns the item associated with the specified key in the PowerCollection.\n\r\n\rIPowerCollection.LAST\n\r\n\rSets the index to the last item and returns the previous value.\n\r\n\rIPowerCollection.NEXT\n\r\n\rReturns the next item in the PowerCollection.\n\r\n\rIPowerCollection.PREVIOUS\n\r\n\rReturns the previous item in the PowerCollection.\n\r\n\rIPowerCollection.REMOVE\n\r\n\rRemoves the item associated with the specified key from the PowerCollection.\n\r\n\rIPowerCollection.REPLACE\n\r\n\rReplaces the item associated with the specified key with a new item.\n\r\n\rIPowerCollection.SORT\n\r\n\rThe data items in the PowerCollection are sorted based upon the text in the associated keys.\n\r\n\rIQueueCollection.CLEAR\n\r\n\rAll items are removed from the QueueCollection.\n\r\n\rIQueueCollection.COUNT\n\r\n\rReturns the number of data items currently contained in the QueueCollection.\n\r\n\rIQueueCollection.DEQUEUE\n\r\n\rThe item at the &quot;oldest&quot; position in the QueueCollection is returned.\n\r\n\rIQueueCollection.ENQUEUE\n\r\n\rThe specified item is added to the QueueCollection at the &quot;newest&quot; position.\n\r\n\rIStackCollection.CLEAR\n\r\n\rAll items are removed from the StackCollection.\n\r\n\rIStackCollection.COUNT\n\r\n\rReturns the number of data items currently contained in the StackCollection.\n\r\n\rIStackCollection.POP\n\r\n\rThe item at the &quot;Stack-Top&quot; (the item most recently added) is returned.\n\r\n\rIStackCollection.PUSH\n\r\n\rThe specified item is added to the StackCollection at the &quot;Stack-Top&quot; position.","Collection Objects","scr\\html_collection_objects.htm","                  \n\r\n\r#COM DOC\n\r\n\rSpecifies a help string which usually provides a general description of the COM server.\n\r\n\r#COM HELP\n\r\n\rSpecifies the name of the associated help file and the help context code.\n\r\n\r#COM NAME\n\r\n\rSpecifies the name of the server and the version number.\n\r\n\r#COM GUID\n\r\n\rSpecifies the GUID which identifies the entire application or library (APPID or LIBID).\n\r\n\rACODE$\n\r\n\rTranslate a Unicode string into an ANSI string.\n\r\n\rCLASS/END CLASS\n\r\n\rCreate the code and data for an object.\n\r\n\rCLSID$\n\r\n\rReturn a 16-byte (128-bit) GUID string containing a CLSID.\n\r\n\rENUM/END ENUM\n\r\n\rCreates a group of logically related numeric equates.\n\r\n\rEVENT SOURCE\n\r\n\rDeclare an event interface within a Class definition.\n\r\n\rEVENTS\n\r\n\rAttach or detach an event handler to/from an event source.\n\r\n\rFOR EACH/NEXT\n\r\n\rDefine a loop of program statements which can sequentially examine and act upon each member of a PowerCollection or LinkListCollection.\n\r\n\rGUID$\n\r\n\rReturn a 16-byte (128-bit) Globally Unique Identifier GUID.\n\r\n\rGUIDTXT$\n\r\n\rReturn a 38-byte human-readable GUID/UUID string.\n\r\n\rIDISPINFO\n\r\n\rSets and returns additional information about certain Dispatch Status Codes for the OBJRESULT function.\n\r\n\rINSTANCE\n\r\n\rDeclare INSTANCE variables which are unique to each object.\n\r\n\rINTERFACE / END INTERFACE Block (Direct)\n\r\n\rDeclare a direct object interface and its member Methods/Properties.\n\r\n\rINTERFACE/END INTERFACE block (IDBind)\n\r\n\rDeclare a dispatch interface and its member Methods/Properties for the purposes of IDBinding to a Dispatch COM interface.\n\r\n\rISINTERFACE\n\r\n\rDetermine whether an object supports a particular interface.\n\r\n\rISNOTHING\n\r\n\rDetermine the current status of a given object variable.\n\r\n\rISOBJECT\n\r\n\rDetermine the current status of a given object variable.\n\r\n\rLET (with Objects)\n\r\n\rAssign an object reference to an object variable.\n\r\n\rLET (with Variants)\n\r\n\rAssign a value to a variable or Variant.\n\r\n\rME\n\r\n\rA pseudo object variable to reference the current object.\n\r\n\rMETHOD / END METHOD\n\r\n\rDefine a METHOD procedure within a class.\n\r\n\rMYBASE\n\r\n\rA pseudo object variable to reference the inherited parent object.\n\r\n\rOBJACTIVE\n\r\n\rReturn True/False of the running state of a COM EXE object.\n\r\n\rOBJECT GET\n\r\n\rRetrieve or read the value of an Dispatch Interface member Property.\n\r\n\rOBJECT LET\n\r\n\rAssign or write a value to an Dispatch Interface member Property.\n\r\n\rOBJECT SET\n\r\n\rAssign or write a value to an Dispatch Interface member Property that contains a reference to an object.\n\r\n\rOBJECT CALL\n\r\n\rCall or execute a member Method of an Dispatch Interface.\n\r\n\rOBJECT RAISEEVENT\n\r\n\rCall or execute a member Method of an event Dispatch Interface.\n\r\n\rOBJEQUAL\n\r\n\rCheck if object variables refer to the same object.\n\r\n\rOBJPTR\n\r\n\rReturn an object pointer of a specified object variable.\n\r\n\rOBJRESULT\n\r\n\rReturn the execution result of the most recent OBJECT statement.\n\r\n\rOBJRESULT$\n\r\n\rReturns a string which describes an OBJRESULT (hResult) code.\n\r\n\rPROGID$\n\r\n\rReturn the alphanumeric PROGID string (text) of a given CLSID.\n\r\n\rPROPERTY GET\n\r\n\rRetrieve a data value from the object.\n\r\n\rPROPERTY SET\n\r\n\rAssign a data value to an object.\n\r\n\rRAISEEVENT\n\r\n\rCall Event Handler code.\n\r\n\rRESET\n\r\n\rClear a Variant to empty (%VT_EMPTY).\n\r\n\rUCODE$\n\r\n\rTranslate an ANSI string into a Unicode string.\n\r\n\rVARIANT#\n\r\n\rReturn the numeric value contained in a Variant variable.\n\r\n\rVARIANT$\n\r\n\rReturn the ANSI dynamic string value contained in a Variant variable.\n\r\n\rVARIANT$$\n\r\n\rReturns the Unicode string value contained in a Variant variable.\n\r\n\rVARIANTVT\n\r\n\rDetermine the internal data type of the data stored in a Variant.","COM Commands","scr\\html_com_functions.htm","                  \n\r\n\rPurpose\n\r\n\rManipulate a COMBOBOX control in order to set/retrieve data.\n\r\n\rSyntax\n\r\n\rCOMBOBOX ADD hDlg, id&amp;, StrExpr [TO datav&amp;]\n\r\n\rCOMBOBOX DELETE hDlg, id&amp;, item&amp;\n\r\n\rCOMBOBOX FIND hDlg, id&amp;, item&amp;, StrExpr TO datav&amp;\n\r\n\rCOMBOBOX FIND EXACT hDlg, id&amp;, item&amp;, StrExpr TO datav&amp;\n\r\n\rCOMBOBOX GET COUNT hDlg, id&amp; TO datav&amp;\n\r\n\rCOMBOBOX GET SELCOUNT hDlg, id&amp; TO datav&amp;\n\r\n\rCOMBOBOX GET SELECT hDlg, id&amp; TO datav&amp;\n\r\n\rCOMBOBOX GET STATE hDlg, id&amp;, item&amp; TO datav&amp;\n\r\n\rCOMBOBOX GET TEXT hDlg, id&amp; [,item&amp;] TO txtv$\n\r\n\rCOMBOBOX GET USER hDlg, id&amp;, item&amp; TO datav&amp;\n\r\n\rCOMBOBOX INSERT hDlg, id&amp;, item&amp;, StrExpr [TO datav&amp;]\n\r\n\rCOMBOBOX RESET hDlg, id&amp;\n\r\n\rCOMBOBOX SELECT hDlg, id&amp;, item&amp;\n\r\n\rCOMBOBOX SET TEXT hDlg, id&amp;, item&amp;, StrExpr\n\r\n\rCOMBOBOX SET USER hDlg, id&amp;, item&amp;, NumExpr\n\r\n\rCOMBOBOX UNSELECT hDlg, id&amp;\n\r\n\rhDlg\n\r\n\rHandle of the dialog that owns the combobox.\n\r\n\rid&amp;\n\r\n\rThe control identifier assigned with CONTROL ADD COMBOBOX.\n\r\n\ritem&amp;\n\r\n\rPosition of data in the COMBOBOX. First string=1, second=2...\n\r\n\rNumExpr\n\r\n\rA numeric expression passed as a parameter.\n\r\n\rStrExpr\n\r\n\rA string expression passed as a parameter.\n\r\n\rtxtv$\n\r\n\rA string variable to which result text is assigned.\n\r\n\rdatav&amp;\n\r\n\rA long integer variable to which result data is assigned.\n\r\n\rRemarks\n\r\n\rIn each of the following samples and descriptions, the COMBOBOX control which is the subject of the statement is identified by the handle of the dialog that owns the COMBOBOX (hDlg), and the unique control identifier you gave it upon creation in CONTROL ADD COMBOBOX.\n\r\n\rCOMBOBOX ADD hDlg, id&amp;, StrExpr [TO datav&amp;]\n\r\n\rThe string value specified by StrExpr is added to the COMBOBOX control. If the COMBOBOX has the %CBS_SORT style, the new string is inserted in alphanumeric order; otherwise it is added to the end of the existing list. If the optional TO clause is included, the index position of the added string is assigned to the variable represented by datav&amp;. The index is one for the first string, two for the second, etc. If the index is less than one, an error occurred and no string was added.\n\r\n\rCOMBOBOX DELETE hDlg, id&amp;, item&amp;\n\r\n\rThe string at the position specified by item&amp; is deleted from the COMBOBOX. The item number (item&amp;) is indexed to one (1=first, 2=second, and so on).\n\r\n\rCOMBOBOX FIND hDlg, id&amp;, item&amp;, StrExpr TO datav&amp;\n\r\n\rStrings in the COMBOBOX are searched to find the first string which begins with the data in StrExpr, regardless of any characters which follow. Comparisons are not case-sensitive. Strings are searched beginning with the string specified by item&amp;, and ending with the last string in the COMBOBOX. Searching does not wrap to the beginning of the list. The item number (item&amp;) is indexed to 1 (1=first, 2=second, etc.). To search the entire COMBOBOX starting with the first string, item&amp; should be set to one (1). If a matching string is found, the index value of the match is assigned to the variable specified by datav&amp;. If no match is found, the value zero (0) is assigned to it.\n\r\n\rCOMBOBOX FIND EXACT hDlg, id&amp;, item&amp;, StrExpr TO datav&amp;\n\r\n\rStrings in the COMBOBOX are searched to find the first string which exactly matches the data in StrExpr. Comparisons are not case-sensitive. Strings are searched beginning with the string specified by item&amp;, and ending with the last string in the COMBOBOX. Searching does not wrap to the beginning of the list. The item number (item&amp;) is indexed to 1 (1=first, 2=second, etc.). To search the entire COMBOBOX starting with the first string, item&amp; should be set to one (1). If a matching string is found, the index value of the match is assigned to the variable specified by datav&amp;. If no match is found, the value zero (0) is assigned to it.\n\r\n\rCOMBOBOX GET COUNT hDlg, id&amp; TO datav&amp;\n\r\n\rThe number of items in the list box of the COMBOBOX is retrieved, and assigned to the long integer variable specified by datav&amp;.\n\r\n\rCOMBOBOX GET SELCOUNT hDlg, id&amp; TO datav&amp;\n\r\n\rThe number of selected items in the list box of the COMBOBOX is retrieved, and assigned to the long integer variable specified by datav&amp;. Since this is a single-selection list box, the retrieved value will always be either zero or one.\n\r\n\rCOMBOBOX GET SELECT hDlg, id&amp; TO datav&amp;\n\r\n\rThe index of the currently selected item in the list box of the COMBOBOX is retrieved, and assigned to the variable specified by datav&amp;. The index is 1 for the first item, 2 for the second item, etc. If there is no current selection, the value zero (0) is assigned.\n\r\n\rCOMBOBOX GET STATE hDlg, id&amp;, item&amp; TO datav&amp;\n\r\n\rA data item is checked to see if it is currently selected. The numeric value item&amp; specifies which user value is to be checked, 1 for the first item, 2 for the second item, etc. If the item is selected, -1 (true) is assigned to the variable specified by datav&amp;. Otherwise, 0 (false) is assigned to it.\n\r\n\rCOMBOBOX GET TEXT hDlg, id&amp; [,item&amp;] TO txtv$\n\r\n\rText is retrieved from the COMBOBOX and assigned to the string variable specified by txtv$. If the numeric expression item&amp; is included, it determines which text string is returned, 1 for the first item, 2 for the second item, etc. If item&amp; is missing, or contains the value zero, the selected text is returned (or an empty string if none is selected). If you wish to retrieve the text found in the edit box portion of the COMBOBOX (regardless of whether it was typed or selected), you should use the CONTROL GET TEXT statement instead.\n\r\n\rCOMBOBOX GET USER hDlg, id&amp;, item&amp; TO datav&amp;\n\r\n\rEach item in a COMBOBOX may have a long integer user value associated with it at the discretion of the programmer. This user value is retrieved with COMBOBOX GET USER. The numeric value item&amp; specifies which user value is requested, 1 for the first item, 2 for the second item, etc. The returned user value is assigned to the long integer variable specified by datav&amp;. COMBOBOX user values are assigned with the COMBOBOX SET USER statement. In addition to these COMBOBOX user values, every DDT control offers an additional eight user values which can be accessed with CONTROL GET USER and CONTROL SET USER.\n\r\n\rCOMBOBOX INSERT hDlg, id&amp;, item&amp;, StrExpr [TO datav&amp;]\n\r\n\rThe text for a new data item, specified by StrExpr, is inserted at the location given by item&amp;. The value of item&amp; = 1 for the first item, 2 for the second item, etc. The list of data items is not re-sorted, even if the COMBOBOX was created with the style %CBS_SORT. If you wish to sort all of the items, use COMBOBOX ADD instead. If the optional TO clause is included, the index position of the inserted string is assigned to the variable represented by datav&amp;. The index is one for the first string, two for the second, etc. If the index is less than one, an error occurred and no string was inserted.\n\r\n\rCOMBOBOX RESET hDlg, id&amp;\n\r\n\rDelete all contents of the specified COMBOBOX.\n\r\n\rCOMBOBOX SELECT hDlg, id&amp;, item&amp;\n\r\n\rThe string value specified by item&amp; is chosen as selected text for the COMBOBOX control, and the selected text is scrolled into a visible position. The value of item&amp; = 1 for the first item, 2 for the second item, etc.\n\r\n\rCOMBOBOX SET TEXT hDlg, id&amp;, item&amp;, StrExpr\n\r\n\rThe text for the data item specified by item&amp; is replaced with the new text in StrExpr. The value of item&amp; = 1 for the first item, 2 for the second item, etc. The list of data items is not re-sorted, even if the COMBOBOX was created with the style %CBS_SORT. If you wish to sort all of the items, use COMBOBOX DELETE followed by COMBOBOX ADD instead.\n\r\n\rCOMBOBOX SET USER hDlg, id&amp;, item&amp;, NumExpr\n\r\n\rEach item in a COMBOBOX may have a long integer user value associated with it at the discretion of the programmer. This user value is assigned with COMBOBOX SET USER, and retrieved with COMBOBOX GET USER. The numeric value item&amp; specifies which user value is to be accessed, 1 for the first item, 2 for the second item, etc. The value specified by NumExpr is saved for later retrieval. In addition to these COMBOBOX user values, every DDT control offers an additional eight user values which can be accessed with CONTROL GET USER and CONTROL SET USER.\n\r\n\rCOMBOBOX UNSELECT hDlg, id&amp;\n\r\n\rAll items in a COMBOBOX control are set to an unselected state.\n\r\n\rRestrictions\n\r\n\rUnder Windows 95/98/ME, a list box is limited to 32,767 items. In all versions of Windows, the actual string data contained by the list box is limited only by available memory.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD COMBOBOX, CONTROL GET TEXT","COMBOBOX UNSELECT statement","scr\\html_combobox_statement.htm","                  \n\r\n\rPurpose\n\r\n\rClose an open serial port.\n\r\n\rSyntax\n\r\n\rCOMM CLOSE [#] hComm [, [#] hComm ...]\n\r\n\rRemarks\n\r\n\rCloses one or more communication ports, as specified by the PowerBASIC file number held in each hComm parameter. COMM CLOSE ends the relationship between a PowerBASIC file number, and the serial port device that was previously associated with it by the COMM OPEN statement.\n\r\n\rThe Number symbol (#) prefix is optional, but recommended for the purposes of clarity.\n\r\n\rIt is also recommended that you explicitly close any serial port that you have opened before your application terminates. Note that COMM CLOSE is a synonym for CLOSE.\n\r\n\rSee also\n\r\n\rSerial Communications, CLOSE, COMM function, COMM LINE, COMM OPEN, COMM PRINT, COMM RECV, COMM RESET, COMM SEND, COMM SET, COMM TIMEOUT\n\r\n\rExample\n\r\n\rCOMM CLOSE #hComm, 5 \' Close hComm and file number 5","COMM CLOSE statement","scr\\html_comm_close_statement.htm","                  \n\r\n\rPurpose\n\r\n\rRetrieve the value or status of a communications parameter.\n\r\n\rSyntax\n\r\n\rlResult&amp; = COMM([#] hComm, Comfunc)\n\r\n\rRemarks\n\r\n\rhComm is the PowerBASIC file number as was used by the COMM OPEN statement to open the communications port. Select a Comfunc keyword from the following table to retrieve the associated setting.\n\r\n\rComfunc\n\r\n\rvalue  (TRUE &lt;&gt; 0, FALSE = 0)\n\r\n\rBAUD\n\r\n\rPort Baud Rate (9600, 14400, 19200, etc).\n\r\n\rBREAK\n\r\n\rTRUE/FALSE Break is asserted. Break is generally used to &quot;get the attention&quot; of the connected modem, terminal or system.\n\r\n\rBYTE\n\r\n\rNumber of bits per byte (4, 5, 6, 7, or 8).\n\r\n\rCD\n\r\n\rTRUE/FALSE Carrier Detect state; synonym for RLSD (READ-ONLY). When CD is TRUE, the DCE (modem) has a suitable connection on the communications channel present. When CD is FALSE, there is no suitable connection.\n\r\n\rCTS\n\r\n\rTRUE/FALSE &nbsp;Clear-To-Send state is returned (READ-ONLY).\n\r\n\rCTSFLOW\n\r\n\rTRUE/FALSE Enable CTS output flow control (Input signal). When CTSFLOW is enabled, it causes the DTE (computer) to stop sending data whenever the CTS signal is set to logic low by the DCE (modem). Transmission continues when the DCE (modem) sets the CTS signal back to logic high. The CTS signal is usually used in response to an RTS signal.\n\r\n\rDSR\n\r\n\rTRUE/FALSE &nbsp;Data-Set-Ready state is returned (READ-ONLY).\n\r\n\rDSRFLOW\n\r\n\rTRUE/FALSE Enable DSR output flow control (Input signal). When DSRFLOW is enabled, it causes the DTE (computer) to stop sending data whenever the DSR signal is set to logic low by the DCE (modem). Transmission is enabled when the DSR signal returns to logic high. The DSR signal is often used in conjunction with CTS in response to a RTS signal.\n\r\n\rDSRSENS\n\r\n\rTRUE/FALSE Enable DSR sensitivity. When DSRSENS is enabled, data received by the DTE (computer) is placed into the receive buffer only if DSR is set to logic high. If DSR is set low, received data is discarded. Enabling DSRSENS allows DSR to enable or disable the DTE (the computer) to receive data from the DTE (the modem). DSRSENS is rarely used in practical communications situations.\n\r\n\rDTRFLOW\n\r\n\rTRUE/FALSE Enable DTR handshaking flow control (Output signal). When DTRFLOW is enabled, it signals that the DCE (modem) should prepare to connect to the communications channel. DTR is usually used for modem on-hook/off-hook control, but can also be used in conjunction with DSR for handshaking.\n\r\n\rDTRLINE\n\r\n\rTRUE/FALSE Enable DTR line. When enabled, DTRLINE leaves the DTR line active when the port is closed by the DTE (computer). This ensures that the DCE (modem) does not close the communications channel when the port is closed.\n\r\n\rNULL\n\r\n\rTRUE/FALSE Null ($NUL) bytes are discarded when read.\n\r\n\rPARITY\n\r\n\rTRUE/FALSE Enable parity checking. This mode must be enabled for the other Parity options to be selected.\n\r\n\rPARITYCHAR\n\r\n\rCharacter to use for parity error replacement. PARITY must be enabled.\n\r\n\rPARITYREPL\n\r\n\rTRUE/FALSE Enable character replacement on parity error. PARITY must be enabled.\n\r\n\rPARITYTYPE\n\r\n\r0 = None, 1 = Odd, 2 = Even, 3 = Mark, 4 = Space. PARITY must be enabled. Default = 0.\n\r\n\rRING\n\r\n\rTRUE/FALSE Ring indicator is on (READ-ONLY). When RING returns TRUE, a ringing signal is being received on the communications channel (by the modem). RING approximates the state of the ringing signal; however, it may not be reported accurately on all Windows platforms.\n\r\n\rRLSD\n\r\n\rReceive-line-signal-detect (READ-ONLY). See CD/Carrier Detect above.\n\r\n\rRTSFLOW\n\r\n\rReady To Send (Output signal). 0 = Disable, 1 = Enable, 2 = Handshake, 3 = Toggle. Toggle is used for half-duplex (2-wire) operations to &quot;reverse&quot; the line. While the DTE (computer) is busy sending data, it raises the RTS signal and the DCE (modem) blocks its data receive channel. When RTS signal reverts to logic low, the DCE (modem) reverts to transmit mode and the DTE (computer) switches to receive mode.\n\r\n\rHandshake mode causes the DTE (computer) to check the receive buffer (RXQUE) after each character is placed into the buffer. When the buffer is 5/6th full, the RTS signal is dropped. When the receive buffer drops to below 1/6th full, RTS is raised again\n\r\n\rRXBUFFER\n\r\n\rSize of the receive buffer in bytes.\n\r\n\rRXQUE\n\r\n\rCharacters currently in the receive buffer (READ-ONLY).\n\r\n\rSTOP\n\r\n\r0 = 1 stop bits, 1 = 1.5 stop bits, 2 = 2 stop bits.\n\r\n\rTXBUFFER\n\r\n\rSize of the transmit buffer in bytes. In some cases, Windows may not be able to report the transmit size.\n\r\n\rTXQUE\n\r\n\rCharacters currently in the transmit buffer (READ-ONLY).\n\r\n\rXINPFLOW\n\r\n\rTRUE/FALSE Enable XON/XOFF input flow control. When the DTE (computer) receive buffer is full, an XOFF character is sent to the DCE (modem) to instruct it to halt transmission. When the DCE is ready to resume transmission, an XON character is sent to the DCE. Typically, XOFF is sent when the receive buffer has less than 1/16th remaining, and XON is sent when the receive buffer drops to less than 1/16th of its maximum size. Default = FALSE.\n\r\n\rXOUTFLOW\n\r\n\rTRUE/FALSE Enable XON/XOFF out flow control. When enabled, the DCE (modem) sends an XOFF to the DTE (computer) to halt data transmission to the DCE. When the DCE is ready to receive more data, an XON character is sent. XOUTFLOW typically uses the same 1/16th rules as XINPFLOW. Default = FALSE.\n\r\n\r&nbsp;\n\r\n\rCommon baud rates range from 110 to 256000. There are equates defined in the WIN32API.INC file, prefixed with %CBR_ to assist you with specifying a common baud rate, but you are not restricted to a limited set of rates.\n\r\n\rPowerBASIC sets the ERR system variable if an error occurs when using the COMM function.\n\r\n\rThe Number symbol (#) prefix is optional, but recommended for the purposes of clarity.\n\r\n\rRestrictions\n\r\n\rDue to differences between Win32 operating systems, parameters (such as the TXBUFFER and TXQUE) may not be queried successfully in all circumstances.\n\r\n\rSee also\n\r\n\rSerial Communications, COMM CLOSE, COMM LINE, COMM OPEN, COMM PRINT, COMM RECV, COMM RESET, COMM SEND, COMM SET, COMM TIMEOUT\n\r\n\rExample\n\r\n\rQty&amp; = COMM(#hComm, RXQUE)\n\r\n\rx$ = &quot;The receive buffer contains &quot; + _\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;FORMAT$(Qty&amp;) + &quot; bytes of data.&quot;\n\r\n\r&nbsp;\n\r\n\rQty&amp; = COMM(#hComm, TXBUFFER) - COMM(#hComm, TXQUE)\n\r\n\rx$ = &quot;There is room for &quot; + FORMAT$(Qty&amp;) + _\n\r\n\r &nbsp;&quot; bytes in the transmit buffer.&quot;","COMM function","scr\\html_comm_function.htm","                  \n\r\n\rPurpose\n\r\n\rReceive a CR/LF ($CRLF) terminated &quot;line&quot; of data from a serial port.\n\r\n\rSyntax\n\r\n\rCOMM LINE [INPUT] [#] hComm, string_var\n\r\n\rRemarks\n\r\n\rRead a delimited line of data from the receive buffer, where a &quot;line&quot; is defined as a stream of data that is terminated by a CR/LF (carriage return and linefeed, $CRLF, or CHR$(13,10)). COMM LINE INPUT is ideal for retrieving modem response strings in reply to &quot;AT&quot; commands sent to a modem.\n\r\n\rhComm is the file number you used with COMM OPEN, an integer in the range of 1 to 32767. The Number symbol (#) prefix is optional, but recommended for clarity.\n\r\n\rCOMM LINE reads the receive buffer up to the next $CRLF character pair. The $CRLF bytes are removed from the buffer but do not form part of the string data returned by COMM LINE. Note that if there is no $CRLF pair in the receive buffer, the statement will wait indefinitely for a complete $CRLF terminated line of data. In this sense, COMM LINE is a blocking statement. The COMM TIMEOUT statement can be used to specify COMM timeouts limits.\n\r\n\rThe data received is assigned to the string_var. The character mode of the string_var must match the CHR option in COMM OPEN (ANSI/WIDE). If not, an error 5 (Illegal function call) will be generated, and no data will be received.\n\r\n\rThe EOF function may also be used with COMM LINE (and TCP LINE) to detect that an incomplete line was received. Normally, the COMM LINE statement reads data until a $CRLF character pair is found, and in that case, EOF will return false (zero). However, if a timeout does occur, COMM LINE will return whatever data has been accumulated, and set EOF to logical TRUE (non-zero).\n\r\n\rIn many cases, it would be prudent to test EOF after every COMM LINE statement to verify that a full line has been received. In some cases, you may wish to execute the statement one or more additional times, combining the data, in order to obtain a full line of text.\n\r\n\rSee also\n\r\n\rSerial Communications, COMM CLOSE, COMM function, COMM OPEN, COMM PRINT, COMM RECV, COMM RESET, COMM SEND, COMM SET, COMM TIMEOUT, EOF\n\r\n\rExample\n\r\n\rCOMM PRINT #hComm, &quot;AT&quot;\n\r\n\rSLEEP 1000 \' delay for modem to respond\n\r\n\rDO\n\r\n\r &nbsp;COMM LINE INPUT #hComm, a$\n\r\n\r &nbsp;CALL DisplayResponse(a$) \' display the modem echo\n\r\n\rLOOP UNTIL LEN(a$)","COMM LINE statement","scr\\html_comm_line_statement.htm","                  \n\r\n\rPurpose\n\r\n\rOpen a serial port.\n\r\n\rSyntax\n\r\n\rCOMM OPEN &quot;COMn&quot; AS [#] hComm [CHR = ANSI|WIDE]\n\r\n\rRemarks\n\r\n\rOpens a serial port to begin communications, creating a relationship between a file number and a specific serial port device.\n\r\n\rCOMn\n\r\n\rIdentifies the serial port number, for example, COM1, COM4, etc. A colon must not follow the port specification. See Restrictions below.\n\r\n\rhComm\n\r\n\rA numeric expression specifying an unused PowerBASIC file number, in the range of 1 to 32767. This is typically provided by the FREEFILE function. The Number symbol (#) prefix is optional, but recommended for clarity.\n\r\n\rIf the port was not opened successfully, the ERR system variable will contain the error code. Before actual communications through the port can commence, you must configure the communication parameters by using a COMM SET statement for each parameter.\n\r\n\rRestrictions\n\r\n\rA colon may not be used in the port name, as was common in DOS code. COMM OPEN cannot use an operating system file handle, nor open a &nbsp;port that is already in use. When opening ports above COM9, Windows requires the port name to be specified using the following syntax:\n\r\n\rCOMM OPEN &quot;\\\\.\\COM15&quot; AS #hComm\n\r\n\rSee also\n\r\n\rSerial Communications, COMM CLOSE, COMM function, COMM LINE, COMM PRINT, COMM RECV, COMM RESET, COMM SEND, COMM SET, COMM TIMEOUT, FREEFILE, OPEN\n\r\n\rExample\n\r\n\rDIM hComm AS LONG\n\r\n\rhComm = FREEFILE\n\r\n\rCOMM OPEN &quot;COM1&quot; AS #hComm\n\r\n\rCOMM OPEN &quot;COM2&quot; AS #5","COMM OPEN statement","scr\\html_comm_open_statement.htm","                  \n\r\n\rPurpose\n\r\n\rSend a string of text through a serial port with optional CR/LF.\n\r\n\rSyntax\n\r\n\rCOMM PRINT [#] hComm, string_expression [;] [TO CharCountVar]\n\r\n\rRemarks\n\r\n\rThe text data contained in string_expression is sent to the serial port associated with the file number hComm. The number symbol (#) is optional.\n\r\n\rThe data is sent in the character form specified in the COMM OPEN statement. If CHR=WIDE was given, the data is sent in wide Unicode characters. Otherwise, it is sent in ANSI bytes. The data will be converted to the appropriate form automatically.\n\r\n\rThis statement is a variation of COMM SEND, but is usually used with text only. Each string_expression sent is automatically followed by a Carriage-Return and Line-Feed pair to delimit the line. However, if a trailing semi-colon (;) is added, the CR/LF is suppressed.\n\r\n\rIf the optional &quot;TO CharCountVar&quot; clause is included, a count of the number of characters written is assigned to it. This count includes the CR/LF, if utilized. This will allow you to gauge the success of the operation. If a TimeOut occurred, this value will be less than expected, and a run-time error 24 (Device Timeout) will be generated.\n\r\n\rCOMM PRINT is ideal for sending &quot;AT&quot; commands to a modem. Omit the trailing semicolon for this purpose, since you would want the CR/LF to be sent along with the data.\n\r\n\rSee also\n\r\n\rSerial Communications, COMM CLOSE, COMM function, COMM LINE, COMM OPEN, COMM RECV, COMM RESET, COMM SEND, COMM SET, COMM TIMEOUT","COMM PRINT statement","scr\\html_comm_print_statement.htm","                  \n\r\n\rPurpose\n\r\n\rReceive binary data from a serial port.\n\r\n\rSyntax\n\r\n\rCOMM RECV [#] hComm, count&amp;, string_var\n\r\n\rRemarks\n\r\n\rRetrieve the count&amp; number of bytes from the receive buffer, placing the results in string_var. Program execution will halt until count&amp; bytes are available, so it is wise to check how many bytes are available before making a COMM RECV request. You can do this by checking the RXQUE value with the COMM function, as shown in the example below.\n\r\n\rhComm is the file number you used with COMM OPEN, an integer in the range of 1 to 32767. The Number symbol (#) prefix is optional, but recommended for clarity.\n\r\n\rThe data received is assigned to the string_var. The character mode of the string_var must match the CHR option in COMM OPEN (ANSI/WIDE). If not, an error 5 (Illegal function call) will be generated, and no data will be received.\n\r\n\rSee also\n\r\n\rSerial Communications, COMM CLOSE, COMM function, COMM LINE, COMM OPEN, COMM PRINT, COMM RESET, COMM SEND, COMM SET, COMM TIMEOUT\n\r\n\rExample\n\r\n\rQty&amp; = COMM(#hComm, RXQUE)\n\r\n\rCOMM RECV #hComm, Qty&amp;, a$","COMM RECV statement","scr\\html_comm_recv_statement.htm","                  \n\r\n\rPurpose\n\r\n\rDisable flow control for a given serial port.\n\r\n\rSyntax\n\r\n\rCOMM RESET [#] hComm, FLOW\n\r\n\rRemarks\n\r\n\rSwitches off all flow control to the serial port as specified by the file number stored in hComm.\n\r\n\rThe Number symbol (#) prefix is optional, but recommended for the purposes of clarity.\n\r\n\rSee also\n\r\n\rSerial Communications, COMM CLOSE, COMM function, COMM LINE, COMM OPEN, COMM PRINT, COMM RECV, COMM SEND, COMM SET, COMM TIMEOUT","COMM RESET statement","scr\\html_comm_reset_statement.htm","                  \n\r\n\rPurpose\n\r\n\rSend a string of data through a serial port.\n\r\n\rSyntax\n\r\n\rCOMM SEND [#] hComm, string_expression TO [CharCountVar]\n\r\n\rRemarks\n\r\n\rThe data contained in string_expression is sent to the serial port associated with the file number hComm. The number symbol (#) is optional.\n\r\n\rThe data is sent in the character form specified in the COMM OPEN statement. If CHR=WIDE was given, the data is sent in wide Unicode characters. Otherwise, it is sent in ANSI bytes. The data will be converted to the appropriate form automatically.\n\r\n\rWith COMM SEND, no delimiters are added to the data. If a trailing CR/LF is needed, it\'s usually best to use COMM PRINT instead.\n\r\n\rIf the optional &quot;TO CharCountVar&quot; clause is included, a count of the number of characters written is assigned to it. This will allow you to gauge the success of the operation. If a TimeOut occurred, this value will be less than expected, and a run-time error 24 (Device Timeout) will be generated.\n\r\n\rSee also\n\r\n\rSerial Communications, COMM CLOSE, COMM function, COMM LINE, COMM OPEN, COMM PRINT, COMM RECV, COMM RESET, COMM SET, COMM TIMEOUT\n\r\n\rExample\n\r\n\rA$ = &quot;ATDT1,555-1234;&quot;\n\r\n\rCOMM SEND #hComm, a$","COMM SEND statement","scr\\html_comm_send_statement.htm","                  \n\r\n\rPurpose\n\r\n\rSet communication options for a serial port.\n\r\n\rSyntax\n\r\n\rCOMM SET [#] hComm, Comfunc = value\n\r\n\rRemarks\n\r\n\rSet the parameters needed to communicate with a serial port. This must always be done before you can send and receive data through the port.\n\r\n\rTo configure the communication parameters, use keywords from the following table to specify the Comfunc as well as a suitable value chosen from the range applicable to the Comfunc parameter you want to set. If an error occurs when attempting to set a parameter, PowerBASIC sets the ERR system variable to indicate the error number. While each parameter must be set individually, it is also possible to change certain parameters without the need to close and re-establish communications.\n\r\n\rCOMM SET keywords table\n\r\n\rComfunc\n\r\n\rvalue  (TRUE &lt;&gt; 0, FALSE = 0)\n\r\n\rBAUD\n\r\n\rPort Baud Rate (9600, 14400, 19200, etc). See notes below.\n\r\n\rBREAK\n\r\n\rTRUE/FALSE Break is asserted. Break is generally used to &quot;get the attention&quot; of the connected modem, terminal or system.\n\r\n\rBYTE\n\r\n\rNumber of bits per byte (4, 5, 6, 7, or 8).\n\r\n\rCD\n\r\n\rTRUE/FALSE Carrier Detect state; synonym for RLSD (READ-ONLY). When CD is TRUE, the DCE (modem) has a suitable connection on the communications channel present. When CD is FALSE, there is no suitable connection.\n\r\n\rCTSFLOW\n\r\n\rTRUE/FALSE Enable CTS output flow control (Input signal). When CTSFLOW is enabled, it causes the DTE (computer) to stop sending data whenever the CTS signal is set to logic low by the DCE (modem). Transmission continues when the DCE (modem) sets the CTS signal back to logic high. The CTS signal is usually used in response to an RTS signal.\n\r\n\rDSRFLOW\n\r\n\rTRUE/FALSE Enable DSR output flow control (Input signal). When DSRFLOW is enabled, it causes the DTE (computer) to stop sending data whenever the DSR signal is set to logic low by the DCE (modem). Transmission is enabled when the DSR signal returns to logic high. The DSR signal is often used in conjunction with CTS in response to a RTS signal.\n\r\n\rDSRSENS\n\r\n\rTRUE/FALSE Enable DSR sensitivity. When DSRSENS is enabled, data received by the DTE (computer) is placed into the receive buffer only if DSR is set to logic high. If DSR is set low, received data is discarded. Enabling DSRSENS allows DSR to enable or disable the DTE (the computer) to receive data from the DTE (the modem). DSRSENS is rarely used in practical communications situations.\n\r\n\rDTRFLOW\n\r\n\rTRUE/FALSE Enable DTR handshaking flow control (Output signal). When DTRFLOW is enabled, it signals that the DCE (modem) should prepare to connect to the communications channel. DTR is usually used for modem on-hook/off-hook control, but can also be used in conjunction with DSR for handshaking.\n\r\n\rDTRLINE\n\r\n\rTRUE/FALSE Enable DTR line. When enabled, DTRLINE leaves the DTR line active when the port is closed by the DTE (computer). This ensures that the DCE (modem) does not close the communications channel when the port is closed.\n\r\n\rNULL\n\r\n\rTRUE/FALSE Null ($NUL) bytes are discarded when read.\n\r\n\rPARITY\n\r\n\rTRUE/FALSE Enable parity checking. This mode must be enabled for the other Parity options to be selected.\n\r\n\rPARITYCHAR\n\r\n\rCharacter to use for parity error replacement. PARITY must be enabled.\n\r\n\rPARITYREPL\n\r\n\rTRUE/FALSE Enable character replacement on parity error. PARITY must be enabled.\n\r\n\rPARITYTYPE\n\r\n\r0 = None, 1 = Odd, 2 = Even, 3 = Mark, 4 = Space. PARITY must be enabled. Default = 0.\n\r\n\rRING\n\r\n\rTRUE/FALSE Ring indicator is on (READ-ONLY). When RING returns TRUE, a ringing signal is being received on the communications channel (by the modem). RING approximates the state of the ringing signal; however, it may not be reported accurately on all Windows platforms.\n\r\n\rRLSD\n\r\n\rReceive-line-signal-detect (READ-ONLY). See CD/Carrier Detect above.\n\r\n\rRTSFLOW\n\r\n\rReady To Send (Output signal). 0 = Disable, 1 = Enable, 2 = Handshake, 3 = Toggle. Toggle is used for half-duplex (2-wire) operations to &quot;reverse&quot; the line. While the DTE (computer) is busy sending data, it raises the RTS signal and the DCE (modem) blocks its data receive channel. When RTS signal reverts to logic low, the DCE (modem) reverts to transmit mode and the DTE (computer) switches to receive mode.\n\r\n\rHandshake mode causes the DTE (computer) to check the receive buffer (RXQUE) after each character is placed into the buffer. When the buffer is 5/6th full, the RTS signal is dropped. When the receive buffer drops to below 1/6th full, RTS is raised again.\n\r\n\rRXBUFFER\n\r\n\rSize of the receive buffer in bytes.\n\r\n\rRXQUE\n\r\n\rCharacters currently in the receive buffer (READ-ONLY).\n\r\n\rSTOP\n\r\n\r0 = 1 stop bits, 1 = 1.5 stop bits, 2 = 2 stop bits.\n\r\n\rTXBUFFER\n\r\n\rSize of the transmit buffer in bytes. In some cases, Windows may not be able to report the transmit size.\n\r\n\rTXQUE\n\r\n\rCharacters currently in the transmit buffer (READ-ONLY).\n\r\n\rXINPFLOW\n\r\n\rTRUE/FALSE Enable XON/XOFF input flow control. When the DTE (computer) receive buffer is full, an XOFF character is sent to the DCE (modem) to instruct it to halt transmission. When the DCE is ready to resume transmission, an XON character is sent to the DCE. Typically, XOFF is sent when the receive buffer has less than 1/16th remaining, and XON is sent when the receive buffer drops to less than 1/16th of its maximum size. Default = FALSE.\n\r\n\rXOUTFLOW\n\r\n\rTRUE/FALSE Enable XON/XOFF out flow control. When enabled, the DCE (modem) sends an XOFF to the DTE (computer) to halt data transmission to the DCE. When the DCE is ready to receive more data, an XON character is sent. XOUTFLOW typically uses the same 1/16th rules as XINPFLOW. Default = FALSE.\n\r\n\rCommon baud rates range from 110 to 256000. There are equates defined in the WIN32API.INC file, prefixed with %CBR_ to assist you with specifying a common baud rate, but you are not restricted to a limited set of rates.\n\r\n\rAttempting to set a READ-ONLY attribute will result in a compile-time Error 542 (&quot;May not be altered&quot;).\n\r\n\rThe Number symbol (#) prefix is optional, but recommended for the purposes of clarity.\n\r\n\rSee also\n\r\n\rSerial Communications, COMM CLOSE, COMM function, COMM LINE, COMM OPEN, COMM PRINT, COMM RECV, COMM RESET, COMM SEND, COMM TIMEOUT\n\r\n\rExample\n\r\n\rTo open a communication port and initialize it for use, you will need to set the following parameters (the selection is typical, but is mainly for demonstration purposes - you may choose your own settings as necessary)\n\r\n\r\' Minimum settings\n\r\n\rCOMM SET #hComm, BAUD &nbsp; &nbsp; = 9600 &nbsp; \' 9600 baud\n\r\n\rCOMM SET #hComm, BYTE &nbsp; &nbsp; = 8 &nbsp; &nbsp; &nbsp;\' 8 bits\n\r\n\rCOMM SET #hComm, PARITY &nbsp; = %FALSE \' No parity\n\r\n\rCOMM SET #hComm, STOP &nbsp; &nbsp; = 0 &nbsp; &nbsp; &nbsp;\' 1 stop bit\n\r\n\rCOMM SET #hComm, TXBUFFER = 2048 &nbsp; \' transmit buffer\n\r\n\rCOMM SET #hComm, RXBUFFER = 4096 &nbsp; \' receive buffer\n\r\n\r&nbsp;\n\r\n\r\' Optional settings for flow control\n\r\n\rCOMM SET #hComm, CTSFLOW &nbsp;= 1 &nbsp;\' Enable CTS\n\r\n\rCOMM SET #hComm, RTSFLOW &nbsp;= 1 &nbsp;\' Enable RTS\n\r\n\rCOMM SET #hComm, XINPFLOW = 0 &nbsp;\' Disable XON/OFF\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \' Input flow control\n\r\n\rCOMM SET #hComm, XOUTFLOW = 0 &nbsp;\' Disable XON/XOFF\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \' Output flow control","COMM SET statement","scr\\html_comm_set_statement.htm","                  \n\r\n\rPurpose\n\r\n\rPlace a limit on the time to complete a COMM operation.\n\r\n\rSyntax\n\r\n\rCOMM TIMEOUT [#] hComm, TimeOutMS&amp;\n\r\n\rRemarks\n\r\n\rCOMM TIMEOUT allows you to specify how long a COMM operation should wait to send or receive a byte of data. This value is measured in milliseconds. If the specified number of milliseconds elapses &nbsp;without a response, the COMM operation will fail and a run-time error 24 (Device Timeout) will be generated.\n\r\n\rSee also\n\r\n\rSerial Communications, COMM CLOSE, COMM function, COMM LINE, COMM OPEN, COMM PRINT, COMM RECV, COMM RESET, COMM SEND, COMM SET, COMM TIMEOUT, FREEFILE, OPEN","COMM TIMEOUT statement","scr\\html_comm_timeout_statement.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the command-line arguments used to start the program.\n\r\n\rSyntax\n\r\n\rs$ = COMMAND$\n\r\n\rs$ = COMMAND$(ArgNum)\n\r\n\rRemarks\n\r\n\rCOMMAND$ returns everything that was typed following the program name. Some operating system manuals refer to this text as the trailer or command tail. You can use COMMAND$ to collect run-time arguments, like filenames, and program options.\n\r\n\rDepending upon the optional argument number, COMMAND$ will return either the complete trailer, or just one of the arguments. If the ArgNum is zero (0), or not present, the complete trailer is returned. If the ArgNum is greater than zero, the trailer is parsed to return an individual argument (1 = first argument. 2 = second argument, etc.). If the ArgNum is greater than the number of arguments, a null string (zero-length) is returned.\n\r\n\rArguments are delimited by one or more blank spaces. If blank spaces are significant, you should enclose the argument in double quotes (&quot;). Any such double-quotes are stripped from the return value by COMMAND$. If a zero-length quoted string (&quot;&quot;) is found, it is ignored entirely.\n\r\n\rFor example, consider a program named FASTSORT.EXE that reads data from one file, sorts it, and puts the result in a new file. Using COMMAND$ lets you specify the input and output file names when the program is invoked:\n\r\n\rFASTSORT.EXE cust.dta cust.new\n\r\n\rWhen FASTSORT begins execution, COMMAND$ or COMMAND$(0) would return:\n\r\n\rcust.dta cust.new\n\r\n\rCOMMAND$(1) would return:\n\r\n\rcust.dta\n\r\n\rCOMMAND$(2) would return:\n\r\n\rcust.new\n\r\n\rRestrictions\n\r\n\rIn some recent versions of Windows, file association and drag-drop file operations cause filenames to be enclosed with double-quote marks when they are passed in COMMAND$. It would be wise to ensure that your applications are prepared for this possibility. Some operating systems automatically enclose the command-line in double-quote marks.\n\r\n\rPowerBASIC imposes no arbitrary limits on the length of the string returned by COMMAND$ but, the operating system may impose limits. Such limits may become evident, for example, when attempting to Drag and Drop a large number of files onto an EXE within Windows Explorer. Usually, attempting to drop more files than the operating system permits will result in an operating system warning message.\n\r\n\rWithin the IDE, a COMMAND$ command-line parameter can be specified for the purposes of testing in both Compile and Execute and Compile and Debug modes.\n\r\n\rSee also\n\r\n\rJOIN$, PARSE, PARSE$, PARSECOUNT, PATHNAME$, PATHSCAN$, WINMAIN\n\r\n\rExample\n\r\n\r#COMPILE EXE\n\r\n\rFUNCTION PBMAIN\n\r\n\r &nbsp;IF TRIM$(COMMAND$) = &quot;&quot; THEN\n\r\n\r &nbsp; &nbsp;EXIT FUNCTION &nbsp;\' No command-line params given, just quit\n\r\n\r &nbsp;ELSEIF INSTR(COMMAND$, &quot;/Q&quot;) THEN\n\r\n\r &nbsp; &nbsp;\' Process the /Q option\n\r\n\r &nbsp;ELSEIF INSTR(COMMAND$, &quot;/W&quot;) THEN\n\r\n\r &nbsp; &nbsp;\' Process the /W option\n\r\n\r &nbsp;END IF\n\r\n\rEND FUNCTION","COMMAND$ function","scr\\html_command_function.htm","                  \n\r\n\rThe following is a list of the commands built into the compiler and separated into 18 groups of related commands, which can assist with identifying the best command for the task at hand. Some commands may appear in more than one group.\n\r\n\r&nbsp;\n\r\n\rCommand List\n\r\n\rArray Operations\n\r\n\rCollection Objects\n\r\n\rCOM Commands\n\r\n\rCommunication Control\n\r\n\rCompiler Operations\n\r\n\rDebugging and Error Control\n\r\n\rFile Commands\n\r\n\rFlow Control\n\r\n\rGraphic Commands\n\r\n\rInput Commands\n\r\n\rMemory Management\n\r\n\rMetastatements\n\r\n\rNumeric Operations\n\r\n\rOperating System\n\r\n\rPrinting Commands\n\r\n\rString Operations\n\r\n\rThread Control\n\r\n\rTime Commands\n\r\n\rMisc Operations\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rKeyword Reference\n\r\n\rFormat and typefaces","Command Summary","scr\\html_command_summary.htm","                  \n\r\n\rOn assembly code lines, a semi-colon ( ; ) is typically used for comments, although an apostrophe ( \' ) is still valid. For example:\n\r\n\rSUB KerPlunk\n\r\n\r &nbsp;ASM PUSH EBX &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ; Save EBX\n\r\n\r &nbsp;ASM MOV &nbsp;EAX, 5 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;; Put 5 into EAX\n\r\n\r &nbsp; &nbsp;! MOV &nbsp;EBX, &amp;HFF &nbsp; &nbsp; &nbsp; ; Put FFh into EBX\n\r\n\r &nbsp; &nbsp;! ADD &nbsp;EAX, EBX &nbsp; &nbsp; &nbsp; &nbsp;\' EAX = EAX + EBX\n\r\n\r &nbsp; &nbsp;! POP &nbsp;EBX &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \' Restore EBX\n\r\n\rEND SUB\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rThe Inline Assembler","Commenting Assembly code","scr\\html_commenting_assembly_code.htm","                  \n\r\n\rBuffers can be useful in solving various types of communication or data transfer problems. For example, a printer typically includes a buffer of at least a few thousand characters. Since the computer can send material to the printer faster than it is capable of putting the material on paper, the buffer serves three purposes:\n\r\n\r1. &nbsp; &nbsp; &nbsp;  To even the workload for the printer\n\r\n\r2. &nbsp; &nbsp; &nbsp;  To allow the computer to finish sending material sooner\n\r\n\r3. &nbsp; &nbsp; &nbsp;  To handle occasions when the printer cannot accept more material\n\r\n\rIf the printer did not have a buffer, the computer would be forced to send data one character at a time. Until each character is received and printed, the computer should not send more. To prevent this, the printer sends a busy signal back to the computer. When it gets this signal, the computer stops until the printer sends a &quot;ready&quot; signal. This &quot;ready/busy&quot; signaling is called handshaking.\n\r\n\rVisualize what is taking place. The printer sends a ready signal; the computer sends a character; the printer sends a busy signal, forcing the computer to wait while it prints the character; and then the whole process repeats. That is a lot of signaling for just one transmitted character!\n\r\n\rFurther, there is a possibility of error. If the computer is fast or the printer is slow (or both), it\'s possible for the computer to send the next character before the printer is able to signal that it\'s busy - something called buffer overflow. This can also happen if there is something wrong with the handshaking signals. When this happens, the printer fails to print one or more characters. Those characters have been sent by the computer, but cannot be received by the printer because there is no place to put them.\n\r\n\rWith a buffer, the printer sends a busy signal only when the buffer is full (or nearly so). That way, even if additional characters have already been sent, there will be room to store them before they are printed. Most of the time, the computer sends and the printer receives. As a result, far less signaling is necessary, and more actual data is transmitted. Therefore, a buffer makes communications between computers and printers more efficient. Since there is room to store characters transmitted, there is less chance that a character will be missed; so a buffer makes transmissions more error free, too.\n\r\n\rIn general, all communications are affected by buffering in the same way. For that reason, PowerBASIC allows you to set aside one communications buffer for received data and a separate buffer for transmitted data. In your programs, you have two responsibilities: to make sure that the buffer you use is large enough, and to empty the buffer as often as needed to prevent a buffer overflow.\n\r\n\rHow large a buffer will you need? &nbsp;It depends on the sort of program you are writing, and is often a matter of trial and error. At low baud rates (up to 300 baud), 256 bytes is probably adequate. Under some circumstances, 256 bytes may well be adequate at 1200 baud or higher; it all depends on how often your program checks the buffer and empties it. It\'s probably a good idea to use a buffer of 1024 bytes or more for 1200 baud, and it\'s not at all uncommon to use buffers of 4 Kilobytes or more. With the large amount of data memory available to your applications with PowerBASIC, you could specify a receive buffer of 1 MB (or even more) and have little impact on system memory.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rSerial Communications\n\r\n\rCommunications Basics\n\r\n\rParity and general error checking\n\r\n\rStart and Stop bits\n\r\n\rOpening a communications port\n\r\n\rReading and writing data\n\r\n\rA simple communications program","Communication Buffers","scr\\html_communication_buffers.htm","                  \n\r\n\rCOMM\n\r\n\rRetrieve the value or status of a communications parameter\n\r\n\rCOMM CLOSE\n\r\n\rClose an open serial port\n\r\n\rCOMM LINE\n\r\n\rReceive a CR/LF terminated &quot;line&quot; of data from a serial port\n\r\n\rCOMM OPEN\n\r\n\rOpen a serial port\n\r\n\rCOMM PRINT\n\r\n\rSend a &quot;line&quot; of binary data through a serial port\n\r\n\rCOMM RECV\n\r\n\rReceive binary data from a serial port\n\r\n\rCOMM RESET\n\r\n\rDisable flow control for a given serial port\n\r\n\rCOMM SEND\n\r\n\rSend a string of binary data through a serial port\n\r\n\rCOMM SET\n\r\n\rSet communication options for a serial port\n\r\n\rCOMM TIMEOUT\n\r\n\rPlaces a limit on the time to complete a COMM operation.\n\r\n\rEOF\n\r\n\rReturn end-of-file status of a file, serial or TCP/UDP transmission\n\r\n\rFREEFILE\n\r\n\rReturn the next available PowerBASIC file number\n\r\n\rHOST ADDR\n\r\n\rTranslate a host name into a corresponding IP address\n\r\n\rHOST NAME\n\r\n\rTranslate an IP address into a corresponding host name\n\r\n\rOPEN\n\r\n\rPrepare a file or device for reading or writing\n\r\n\rTCP ACCEPT\n\r\n\rAccept an incoming request for TCP communication\n\r\n\rTCP CLOSE\n\r\n\rClose a previously opened TCP/IP port\n\r\n\rTCP LINE INPUT\n\r\n\rReceive a line of text from a specified TCP/IP port\n\r\n\rTCP NOTIFY\n\r\n\rDesignate which TCP/IP events generate notification messages\n\r\n\rTCP OPEN\n\r\n\rEnable an app to communicate with a TCP/IP server or client\n\r\n\rTCP PRINT\n\r\n\rWrite a string to a nominated TCP/IP\n\r\n\rTCP RECV\n\r\n\rReceive data from a specified TCP/IP port\n\r\n\rTCP SEND\n\r\n\rWrite a string to a nominated TCP/IP port\n\r\n\rUDP CLOSE\n\r\n\rClose a previously opened UDP socket\n\r\n\rUDP NOTIFY\n\r\n\rDesignate which TCP/IP events generate notification messages\n\r\n\rUDP OPEN\n\r\n\rCreate a socket to communicate with a UDP server or client\n\r\n\rUDP RECV\n\r\n\rReceive data from a previously opened UDP port\n\r\n\rUDP SEND\n\r\n\rSend a string of data through a previously opened UDP socket","Communication Control","scr\\html_communication_functions.htm","                  \n\r\n\rTo communicate from one computer to another, you need a communications program on each machine, and some way to connect them (telephone lines, for example). Sometimes, those programs are built into the operating system. Even when that\'s the case, there will be times when you want to do something faster, more reliably, or in a different manner than what has been provided.\n\r\n\rTo communicate, you will need a way for each program to inform the other that:\n\r\n\r1. &nbsp; &nbsp; &nbsp;  It is ready/not ready to transmit/receive data.\n\r\n\r2. &nbsp; &nbsp; &nbsp;  Data has been received and is correct.\n\r\n\r3. &nbsp; &nbsp; &nbsp;  Data has been received and is not correct.\n\r\n\r4. &nbsp; &nbsp; &nbsp;  Transmission is over.\n\r\n\rIf it is not important to check for, or correct errors, items 2 and 3 in the previous list can be ignored. Those capabilities are often skipped when the programs are to be used for simple communications - short text or brief typed messages. Even the other two parts can be dropped if the programs are closely monitored, or if errors will not matter very much.\n\r\n\rHowever, it is important to realize that receiving and transmitting data is not always quite as simple as it might appear, especially when you are coding under Windows. For example, suppose your program is receiving data and saving material to a disk file. What should happen if more data is received while the program is writing data to disk? &nbsp;Alternatively, suppose the user presses a key that means &quot;clear the screen and display a menu&quot; while data is being received?\n\r\n\rSituations like this are common. The standard way of handling them is to use a buffer.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rSerial Communications\n\r\n\rCommunication Buffers\n\r\n\rParity and general error checking\n\r\n\rStart and Stop bits\n\r\n\rOpening a communications port\n\r\n\rReading and writing data\n\r\n\rA simple communications program","Communications Basics","scr\\html_communications_basics.htm","                  \n\r\n\rWhen dealing with C, intrinsic types are in lowercase. Defined types are in all caps by convention. C data types are case-sensitive. Integer-class types can take a modifier of &quot;signed&quot; or &quot;unsigned&quot;, and are signed by default.\n\r\n\rC arrays are defined by the number of elements and are indexed from zero:\n\r\n\r&quot;char foo[32]&quot; translates to DIM foo(0 TO 31) AS BYTE, or DIM foo AS STRING * 32, depending on the context of the code.\n\r\n\rC arrays are stored in row-major order whereas PowerBASIC arrays are stored in column-major order. Bear in mind that when accessing C arrays the following C code:\n\r\n\rk = arr[i,j]\n\r\n\rwould translate to PowerBASIC as:\n\r\n\rk = arr(j,i)\n\r\n\rC arrays are accessed as follows:\n\r\n\r(0,0), (0,1), (0,2), ...\n\r\n\r(1,0), (1,1), (1,2), ...\n\r\n\rwhereas PowerBASIC arrays are accessed:\n\r\n\r(0,0), (1,0), (2,0), ...\n\r\n\r(0,1), (1,1), (2,1), ...\n\r\n\rCommonly, C/C++ code prefixes data types with &quot;LP&quot; which indicates a pointer. Therefore, items with the LP prefix usually correspond to a pointer in PowerBASIC; however, the size of the pointer\'s target will depend on the data type.\n\r\n\rMore information on C/C++ syntax can be found on the Internet, such as at http://www.open-std.org/jtc1/sc22/wg14/www/docs/n1124.pdf and http://www.open-std.org/JTC1/SC22/WG21/\n\r\n\rC/C++ Data Types\n\r\n\rType\n\r\n\rLanguage\n\r\n\rFormat\n\r\n\rPowerBASIC\n\r\n\rbool\n\r\n\rC++\n\r\n\runsigned 8-bit\n\r\n\rBYTE (2)\n\r\n\rchar\n\r\n\rC/C++\n\r\n\rsigned 8-bit\n\r\n\rBYTE (2)\n\r\n\rchar*\n\r\n\rC/C++\n\r\n\rchar pointer\n\r\n\rSTRINGZ (1)\n\r\n\rdouble\n\r\n\rC/C++\n\r\n\r8-byte float\n\r\n\rDOUBLE\n\r\n\rfloat\n\r\n\rC/C++\n\r\n\r4-byte float\n\r\n\rSINGLE\n\r\n\rint\n\r\n\rC/C++\n\r\n\rsigned 32-bit\n\r\n\rLONG (3)\n\r\n\rlong\n\r\n\rC/C++\n\r\n\rsigned 32-bit\n\r\n\rLONG\n\r\n\rshort\n\r\n\rC/C++\n\r\n\rsigned 16-bit\n\r\n\rINTEGER\n\r\n\rvoid\n\r\n\rC/C++\n\r\n\r(no return value)\n\r\n\rSUB\n\r\n\rvoid *\n\r\n\rC/C++\n\r\n\rpointer &nbsp; &nbsp; \n\r\n\r(ANY) [PTR] (1)\n\r\n\rDefined types (SDK types)  \n\r\n\rType\n\r\n\rFormat\n\r\n\rPowerBASIC\n\r\n\rATOM\n\r\n\runsigned 16-bit\n\r\n\rWORD\n\r\n\rBOOL\n\r\n\rsigned 32-bit\n\r\n\rLONG\n\r\n\rboolean\n\r\n\r8-bit integer\n\r\n\rBYTE\n\r\n\rBoolean\n\r\n\rsigned 16-bit\n\r\n\rINTEGER\n\r\n\rBOOLEAN\n\r\n\r8-bit integer\n\r\n\rBYTE\n\r\n\rBSTR\n\r\n\rdynamic string\n\r\n\rWSTRING {unicode}\n\r\n\rBYTE\n\r\n\runsigned 8-bit\n\r\n\rBYTE\n\r\n\rCOLORREF\n\r\n\runsigned 32-bit\n\r\n\rDWORD\n\r\n\rDWORD\n\r\n\runsigned 32-bit\n\r\n\rDWORD\n\r\n\rHANDLE\n\r\n\runsigned 32-bit\n\r\n\rDWORD\n\r\n\rHWND/HDC/\n\r\n\runsigned 32-bit\n\r\n\rDWORD\n\r\n\rINT32\n\r\n\rsigned 32-bit\n\r\n\rLONG\n\r\n\rINT64\n\r\n\rsigned 64-bit\n\r\n\rQUAD\n\r\n\rLARGE_INTEGER\n\r\n\rsigned 64-bit\n\r\n\rQUAD\n\r\n\rLPARAM\n\r\n\rsigned 32-bit\n\r\n\rLONG\n\r\n\rLP\n\r\n\rpointer  &nbsp;  \n\r\n\r(ANY) [PTR] (4)\n\r\n\rLPCSTR\n\r\n\rSTRINGZ pointer\n\r\n\rSTRINGZ [PTR]\n\r\n\rLPDWORD\n\r\n\rDWORD pointer\n\r\n\rDWORD [PTR]\n\r\n\rLPINT\n\r\n\rLONG pointer\n\r\n\rLONG [PTR]\n\r\n\rLPSTR\n\r\n\rSTRINGZ pointer\n\r\n\rSTRINGZ [PTR]\n\r\n\rLPUINT\n\r\n\rDWORD pointer\n\r\n\rDWORD [PTR]\n\r\n\rLPVOID\n\r\n\r32-bit pointer\n\r\n\r(ANY) [PTR]\n\r\n\rLPWSTR\n\r\n\rWSTRINGZ pointer\n\r\n\rWSTRINGZ [PTR]\n\r\n\rLRESULT\n\r\n\rsigned 32-bit\n\r\n\rLONG\n\r\n\rNULL\n\r\n\r32-bit &nbsp; &nbsp;  \n\r\n\r0 or %NULL\n\r\n\rPASCAL\n\r\n\r{calling convention}\n\r\n\r/STDCALL\n\r\n\rQWORD\n\r\n\runsigned 64-bit\n\r\n\rQUAD (2)\n\r\n\rSTDCALL\n\r\n\r{calling convention}\n\r\n\rSDECL/STDCALL\n\r\n\rUCHAR\n\r\n\runsigned 8-bit\n\r\n\rBYTE\n\r\n\rUINT\n\r\n\runsigned 32-bit\n\r\n\rDWORD (3)\n\r\n\rUINT16\n\r\n\runsigned 16-bit\n\r\n\rWORD\n\r\n\rUINT32\n\r\n\runsigned 32-bit\n\r\n\rDWORD\n\r\n\rUINT64\n\r\n\runsigned 64-bit\n\r\n\rQUAD (2)\n\r\n\rVOID\n\r\n\rSUB &nbsp; &nbsp; &nbsp; &nbsp; \n\r\n\r{no return value}\n\r\n\rVOID *\n\r\n\rpointer  &nbsp;  \n\r\n\r(ANY) [PTR] (1)\n\r\n\rWINAPI\n\r\n\r{calling convention}\n\r\n\rSDECL/STDCALL\n\r\n\rWORD\n\r\n\runsigned 16-bit\n\r\n\rWORD\n\r\n\rWPARAM\n\r\n\rsigned 32-bit\n\r\n\rLONG","C/C++","scr\\html_comparative_data_types_c_c_.htm","                  \n\r\n\rDelphi uses integer conventions similar to C, although the names are case-insensitive, as with BASIC. That is, a Delphi INTEGER value may be either a PowerBASIC INTEGER or LONG, depending on whether the Delphi code is 16-bit or 32-bit.\n\r\n\rThe elements of multi-dimensional arrays, in Delphi, are not necessarily stored in a straightforward order in memory. Such arrays are not compatible with other languages.\n\r\n\rDelphi Data Types\n\r\n\rType\n\r\n\rFormat\n\r\n\rPowerBASIC\n\r\n\ransistring\n\r\n\rdynamic ANSI string\n\r\n\rSTRING\n\r\n\rboolean\n\r\n\runsigned 8-bit\n\r\n\rBYTE\n\r\n\rbyte\n\r\n\runsigned 8-bit\n\r\n\rBYTE\n\r\n\rbytebool\n\r\n\runsigned 8-bit\n\r\n\rBYTE\n\r\n\rcardinal\n\r\n\runsigned 16/32-bit\n\r\n\rWORD/DWORD (5)\n\r\n\rcomp\n\r\n\rsigned 64-bit\n\r\n\rQUAD\n\r\n\rcurrency\n\r\n\r8-byte fixed point\n\r\n\rCURRENCY\n\r\n\rdouble\n\r\n\r8-byte floating point\n\r\n\rDOUBLE\n\r\n\rextended\n\r\n\r10-byte floating point\n\r\n\rEXT\n\r\n\rint64\n\r\n\rsigned 64-bit\n\r\n\rQUAD\n\r\n\rinteger\n\r\n\rsigned 16/32-bit\n\r\n\rINTEGER/LONG (5)\n\r\n\rlongbool\n\r\n\rsigned 32-bit\n\r\n\rLONG\n\r\n\rlongint\n\r\n\rsigned 32-bit\n\r\n\rLONG\n\r\n\rlongword\n\r\n\runsigned 32-bit\n\r\n\rDWORD\n\r\n\rpchar\n\r\n\rSTRINGZ string\n\r\n\rSTRINGZ\n\r\n\rshortint\n\r\n\rsigned 8-bit\n\r\n\rBYTE (2)\n\r\n\rshortstring\n\r\n\r2 to 256 byte string\n\r\n\rSTRING * 256\n\r\n\rsingle\n\r\n\r4-byte float\n\r\n\rSINGLE\n\r\n\rsmallint\n\r\n\rsigned 16-bit\n\r\n\rINTEGER\n\r\n\rvariant\n\r\n\rdata-dependent\n\r\n\rVARIANT\n\r\n\rwstring\n\r\n\rdynamic Unicode string\n\r\n\rWSTRING\n\r\n\rword\n\r\n\runsigned 16-bit\n\r\n\rWORD\n\r\n\rwordbool\n\r\n\runsigned 16-bit\n\r\n\rWORD","Delphi","scr\\html_comparative_data_types_delphi.htm","                  \n\r\n\rType\n\r\n\rFormat\n\r\n\rPowerBASIC\n\r\n\rBoolean\n\r\n\rsigned 16-bit\n\r\n\rINTEGER\n\r\n\rByte\n\r\n\runsigned 8-bit\n\r\n\rBYTE\n\r\n\rConst\n\r\n\rnumeric constant\n\r\n\r{Equate} (2)\n\r\n\rCurrency\n\r\n\r8-byte fixed point\n\r\n\rCURRENCY\n\r\n\rDouble\n\r\n\r8-byte float\n\r\n\rDOUBLE\n\r\n\rInteger\n\r\n\rsigned 16-bit\n\r\n\rINTEGER\n\r\n\rLong\n\r\n\rsigned 32-bit\n\r\n\rLONG\n\r\n\rSingle\n\r\n\r4-byte float\n\r\n\rSINGLE\n\r\n\rString\n\r\n\rdynamic string\n\r\n\rSTRING\n\r\n\rString * n\n\r\n\rfixed-length string\n\r\n\rSTRING * n\n\r\n\rVariant\n\r\n\rdata-dependent\n\r\n\rVARIANT","Visual Basic 6","scr\\html_comparative_data_types_visual_basic_6.htm","                  \n\r\n\r#ALIGN\n\r\n\rAlign the next instruction to a boundary.\n\r\n\r%DEF\n\r\n\rDetermine if an equate has been previously defined\n\r\n\r%PB_COMPILETIME\n\r\n\rContains the date and time of compilation.\n\r\n\r#BLOAT\n\r\n\rArtificially inflate the disk image size of a compiled program\n\r\n\r#COMPILE\n\r\n\rDetermine which type of file will be created by the compiler\n\r\n\r#DEBUG CODE\n\r\n\rCompiler directive to suppress generation of debugging code\n\r\n\r#DEBUG DISPLAY\n\r\n\rDisplay a message when an untrapped run-time error occurs.\n\r\n\r#DIM\n\r\n\rSpecify if variables must be declared before use\n\r\n\r#EXPORT\n\r\n\rDeclare a Sub/Function to have the EXPORT attribute.\n\r\n\r#IF\n\r\n\rDefine sections of source code to be compiled or ignored\n\r\n\r#LINK\n\r\n\rLink a pre-compiled Static Link Library (SLL) into your host program.\n\r\n\r#MESSAGES\n\r\n\rSpecify which messages should be sent to a Control Callback Function\n\r\n\r#OPTIMIZE\n\r\n\rChoose the optimization which should be applied to your program.\n\r\n\r#OPTION\n\r\n\rEstablish various compiler options.\n\r\n\r#REGISTER\n\r\n\rControl automatic allocation of Register variables\n\r\n\r#STACK\n\r\n\rSet the maximum potential stack size\n\r\n\r#TOOLS\n\r\n\rEnable/disable integrated development tools in compiled code\n\r\n\r#UNIQUE\n\r\n\rSpecify whether unique variable names are required.\n\r\n\rDECLARE\n\r\n\rExplicitly declare a Sub or Function\n\r\n\rDEFBYT\n\r\n\rDeclare the default variable type to be Byte\n\r\n\rDEFCUR\n\r\n\rDeclare the default variable type to be Currency\n\r\n\rDEFCUX\n\r\n\rDeclare the default variable type to be Extended Currency\n\r\n\rDEFDBL\n\r\n\rDeclare the default variable type to be Double-precision\n\r\n\rDEFDWD\n\r\n\rDeclare the default variable type to be Double-word\n\r\n\rDEFEXT\n\r\n\rDeclare the default variable type to be Extended-precision\n\r\n\rDEFINT\n\r\n\rDeclare the default variable type to be Integer\n\r\n\rDEFLNG\n\r\n\rDeclare the default variable type to be Long-integer\n\r\n\rDEFQUD\n\r\n\rDeclare the default variable type to be Quad-integer\n\r\n\rDEFSNG\n\r\n\rDeclare the default variable type to be Single-precision\n\r\n\rDEFSTR\n\r\n\rDeclare the default variable type to be String\n\r\n\rDEFWRD\n\r\n\rDeclare the default variable type to be Word\n\r\n\rDIM\n\r\n\rDeclare and dimension arrays, scalar variables, and pointers\n\r\n\rDLLMAIN\n\r\n\rFunction called by Windows each time a DLL is loaded into, and unloaded from, memory\n\r\n\rERASE\n\r\n\rDeallocate array memory\n\r\n\rGLOBAL\n\r\n\rDeclare global (shared) variables between Subs, Functions, Classes, Methods, and Properties\n\r\n\rINSTANCE\n\r\n\rDeclare Instance variables which are unique to each object\n\r\n\rLIBMAIN\n\r\n\rFunction called by Windows each time a DLL is loaded into, and unloaded from, memory\n\r\n\rLOCAL\n\r\n\rDeclare local variables in a Sub, Function, Method or Property\n\r\n\rMACRO\n\r\n\rDefine a single or multi-line text substitution block\n\r\n\rOPTION EXPLICIT\n\r\n\rForce explicit declaration of all variables\n\r\n\rPBLIBMAIN\n\r\n\rFunction called by Windows each time a DLL is loaded into, and unloaded from, memory\n\r\n\rPBMAIN\n\r\n\rDefine the initial entry-point Function for an application\n\r\n\rPREFIX/END PREFIX\n\r\n\rExecutes a series of statements, each of which utilizes pre-defined source code.\n\r\n\rPROFILE\n\r\n\rCapture an execution time profile of the Subs, Functions, Methods, and Properties\n\r\n\rREDIM\n\r\n\rDeclare dynamic arrays, allocate, reallocate, deallocate memory\n\r\n\rREGISTER\n\r\n\rDefine local Register variables within a Sub, Function, Method, or Property\n\r\n\rSTATIC\n\r\n\rDeclare static variables inside of a Sub, Function, Method, or Property\n\r\n\rSTRPTR\n\r\n\rReturn the address of the data held by a variable length string\n\r\n\rVARPTR\n\r\n\rReturn the 32-bit address of a variable or string handle\n\r\n\rWINMAIN\n\r\n\rDefine the initial entry-point Function for an application","Compiler Operations","scr\\html_compiler_functions.htm","                  \n\r\n\r\n\r\n\rInclude File Paths\n\r\n\rInclude\n\r\n\rThe path (or paths) where the Compiler may search for source code files referenced in #INCLUDE metastatements, and PBR and RES files referenced with #RESOURCE metastatements. Multiple paths are automatically separated with semi-colons. Use the Ellipsis button () to adjust the Include path settings - see Browsing for Include folders for more information. Note that this field behaves identically to the /I command-line compiler parameter.\n\r\n\rCompiler Options\n\r\n\rBeep on completion\n\r\n\rThe default system sound is played when compilation is completed successfully. The default system sound can be changed in Control Panel.\n\r\n\rDetailed results\n\r\n\rAfter compilation of PowerBASIC source code, the output pane will display detailed compilation results, providing details on compiled code size, data and string literal size, code extracted, etc. With this option turned off only a successful compilation message or compile time error message will be displayed.\n\r\n\rCreate log file\n\r\n\rDuring compilation, a log file is created in the same directory as the primary source file. The log file contains the same information as the Display Results dialog discussed above. The file is assigned the same &quot;base name&quot; as the main source code file, but with the extension .LOG (i.e., PROJECT1.LOG). In case of a compile-time error, this log file will contain details of the nature of the error (in addition to the compile-time error message display produced by the compiler itself).\n\r\n\r&nbsp;\n\r\n\rCreate a .PBR when\n\r\n\rcompiling .RC files\n\r\n\rSpecify this option to create a .PBR file when compiling a .RC resource file.","Compiler tab","scr\\html_compiler_preferences.htm","                  \n\r\n\rA string literal is simply a group of characters surrounded by quotation marks. It may optionally be followed by a TypeID of a single $ to specify ANSI characters, or a double $$ for wide, Unicode characters. If no TypeID is included, the default is ANSI characters. PowerBASIC will always make ANSI/WIDE conversions as needed, but it is best to specify it explicitly for efficiency. For example:\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;MyAnsi$ &nbsp; = &nbsp;&quot;This is a string&quot;$\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;MyWide$$ &nbsp;= &nbsp;&quot;This is a UniCode string&quot;$$\n\r\n\r&nbsp;\n\r\n\rA string literal can include the double-quote character, simply by doubling the character within the string. For example:\n\r\n\rA$ = &quot;This is a &quot;&quot;string&quot;&quot;&quot;\n\r\n\rNumeric literals represent numeric values. They consist primarily of the digits 0 through 9 and a decimal point. Negative values need a leading minus sign (-); a plus sign (+) is optional for positive values. The amount of precision you supply determines the internal representation (Integer, Long-integer, Quad-integer, Byte, Word, Double-word, Single-precision, Double-precision, Extended-precision, and Currency) which PowerBASIC will use in processing that literal value.\n\r\n\rYou can also force a literal value to be stored with a given precision by following the constant with one of the variable type-specifiers (%, &amp;, &amp;&amp;, ?, ??, ???, !, #, ##, @, @@). This ability becomes very important when working with Currency and other floating-point numbers.\n\r\n\rFor example, the statement eVar## = 1.1 stores the Single-precision representation of 1.1 (which is 1.10000002384185791) in the Extended-precision variable eVar##. In order to store the exact quantity 1.1 in eVar##, you must follow 1.1 with the Extended-precision type-specifier (##). For example\n\r\n\r&nbsp;\n\r\n\rDIM x1 AS EXT, x2 AS EXT\n\r\n\rx1 = 1.1 &nbsp; &nbsp; \' Single-precision literal\n\r\n\rx2 = 1.1## &nbsp; \' Extended-precision literal\n\r\n\ra$ = STR$(x1,18) &nbsp; &nbsp; \' 1.10000002384185791\n\r\n\rb$ = STR$(x1) &nbsp; &nbsp; &nbsp; &nbsp;\' 1.10000002384186\n\r\n\rc$ = STR$(x2,18) &nbsp; &nbsp; \' 1.1\n\r\n\rd$ = STR$(x2) &nbsp; &nbsp; &nbsp; &nbsp;\' 1.1\n\r\n\r&nbsp;\n\r\n\rIf a type-specifier does not follow a numeric constant, the following rules are used to determine the precision the value will be stored in:\n\r\n\r&nbsp;1.If the value contains no decimal point and is in the range 0 to 255, PowerBASIC stores the value as a Byte.2.If the value is an integer in the range -32,768 to 32,767, yet outside the range for Byte constants, PowerBASIC stores the value as an Integer.3.If the value is an integer in the range 32,768 to 65,535, PowerBASIC will store the value as a Word.4.If the value is an integer in the range -2^31 to 2^31-1 inclusive (about -2 billion to +2 billion), yet outside the range for Word constants, PowerBASIC stores the value as a Long-integer.5.If an integer value is positive, exceeds the maximum value for a Long-integer, and still falls within the range for a Double-word, PowerBASIC will store the value as a Double-word.6.If the value is an integer too large to fit in a Long or Double-word, but small enough to fit in a Quad integer, it will be stored as a Quad integer.7.If the value contains a decimal point and has up to six significant digits, PowerBASIC stores it as a Single-precision floating-point.8.A numeric constant with a decimal point and more than six significant digits, but less than 17, or a whole number too large to be a Quad-integer but small enough to fall within the range of Double-precision floating-point, is stored in Double-precision floating-point format. Larger values (with up to 18 significant digits) are stored in Extended-precision format.\n\r\n\r&nbsp;\n\r\n\rFor example:\n\r\n\r345.1 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' A Single-precision constant\n\r\n\r1.10321 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' A Single-precision constant\n\r\n\r1.103213 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \' A Double-precision constant\n\r\n\r3453212.1234 &nbsp; &nbsp; &nbsp; \' A Double-precision constant\n\r\n\r1112223.4445556667 \' An Extended-precision constant\n\r\n\r&nbsp;\n\r\n\rWhen the sign of an Integer constant is not apparent (there is no type-specifier), PowerBASIC uses the following rules to determine whether to store the value as signed or unsigned:\n\r\n\rIf the number includes a type-specifier, the value will be signed or unsigned according to the type (specifically: Byte, Word and Double-word are unsigned; Integer, Long-integer, Quad-integer are signed).\n\r\n\rIf there is no type-specifier, and the number is a 16-bit quantity expressed as exactly 4 hexadecimal digits (or the number is a 32-bit quantity expressed as exactly 8 hexadecimal digits) and the most significant bit is set, the value is considered to be signed. All other hexadecimal constants are evaluated as unsigned. The same rules apply to 16 and 32 bit binary and octal literals.\n\r\n\rSuch signed hexadecimal values can be forced to evaluate as unsigned by adding an additional leading zero digit, or by adding a type-specifier suffix. This behavior is designed for compatibility with other BASIC dialects.\n\r\n\rSome examples of these rules follow:\n\r\n\r&nbsp;\n\r\n\r32767?? &nbsp; &nbsp; &nbsp; \' A Word constant &nbsp; &nbsp; &nbsp; &nbsp; (unsigned)\n\r\n\r-40000 &nbsp; &nbsp; &nbsp; &nbsp;\' A Long-integer constant (signed)\n\r\n\r32 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\' A Byte constant &nbsp; &nbsp; &nbsp; &nbsp; (unsigned)\n\r\n\r-32 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; \' An Integer constant &nbsp; &nbsp; (signed)\n\r\n\r&amp;H08000 &nbsp; &nbsp; &nbsp; \' A Word constant &nbsp; &nbsp; &nbsp; &nbsp; (unsigned)\n\r\n\r&amp;H8000 &nbsp; &nbsp; &nbsp; &nbsp;\' An Integer constant &nbsp; &nbsp; (signed)\n\r\n\r&amp;H8000&amp; &nbsp; &nbsp; &nbsp; \' An Integer constant &nbsp; &nbsp; (signed)\n\r\n\r&amp;H08000&amp; &nbsp; &nbsp; &nbsp;\' An Integer constant &nbsp; &nbsp; (signed)\n\r\n\r&amp;H80000000 &nbsp; &nbsp;\' Long-integer constant &nbsp; (signed)\n\r\n\r&amp;H80000000&amp;&amp; &nbsp;\' Long-integer constant &nbsp; (signed)\n\r\n\r&amp;H080000000 &nbsp; \' Double-word constant &nbsp; &nbsp;(unsigned)\n\r\n\r&amp;H80000000??? \' Double-word constant &nbsp; &nbsp;(unsigned)\n\r\n\r&nbsp;\n\r\n\rThis sequence of events allows PowerBASIC to make an intelligent decision about the constants in your program. Rather than arbitrarily making all ambiguous constant references signed (or unsigned), it tries to determine what type of constant you intended to use. You do not necessarily have to make a decision about the size of an integer constant, only whether it should be signed or unsigned. All you need to do to guarantee that a constant will be treated as an unsigned value is to place a leading zero in the number. You need not consider whether the number is a Byte, Word, or Double-word (as long as you do not exceed the largest Double-word value).\n\r\n\rIt is sometimes convenient to express integral values in number systems (bases) other than decimal (which is base 10). This is particularly true when expressing information that is binary in nature; for example, machine addresses. PowerBASIC allows you to specify integer data in Hexadecimal (base 16), Octal (base 8), and Binary (base 2) notation.\n\r\n\rHexadecimal constants consist of up to 16 characters, where each character is from the set 0 through 9 and A through F (and a through f), and must be preceded by &amp;H. An additional (leading) zero can also be included to force the hexadecimal value to be treated as an unsigned value, or a suitable type-specifier can be added instead. The following are equivalent ways of specifying an unsigned hexadecimal value in the Double-word (DWORD) range:\n\r\n\r&nbsp;\n\r\n\rA??? = &amp;H0FFFFFFFF\n\r\n\rA??? = &amp;HFFFFFFFF???\n\r\n\r&nbsp;\n\r\n\rOctal constants contain only the characters 0 through 7, can be up to 22 digits long, and must be preceded by &amp;O, &amp;Q, or simply &amp;.\n\r\n\r&nbsp;\n\r\n\rB = &amp;Q7777\n\r\n\r&nbsp;\n\r\n\rBinary constants contain only 0s and 1s, can be up to 64 digits long, and must be preceded by &amp;B.\n\r\n\rEach of the following constants represents the integer value 256 (decimal):\n\r\n\r&nbsp;\n\r\n\r256 ~ &amp;H100 ~ &amp;O400 ~ &amp;Q400 ~ &amp;400 ~ &amp;B100000000\n\r\n\r&nbsp;\n\r\n\rJust as with decimal constants, a hexadecimal, octal or binary constant may have a type-specifier. You can use ?, ??, ???, %, &amp;, &amp;&amp; (Byte, Word, Double-word, Integer, Long-integer, Quad-integer) type-specifiers with constants in any number base.\n\r\n\rIf you do not use a type-specifier with these constants, the compiler will select the smallest integral type that will contain the number. When there is no type-specifier, PowerBASIC stores the value as unsigned, unless the most significant bit is a sign bit and the leading digit is not a zero. For example, &amp;H8000 is signed, because its most significant bit is a sign bit (1000 0000 0000 0000), and its leading digit is non-zero. On the other hand, &amp;H08000 is unsigned; although its most significant bit is a sign-bit (1000 0000 0000 0000), its leading digit is a zero.\n\r\n\r&nbsp;\n\r\n\rYou can use the VAL function &nbsp;to convert strings to numeric values. Such strings can contain decimal, hexadecimal, binary and octal numbers in string format. See VAL function for more info.\n\r\n\r&nbsp;\n\r\n\rPowerBASIC programs process two distinct classes of data: variables and constants. A variable is allowed to change its value as a program runs. A constant\'s value is fixed at compile-time, and cannot change during program execution (hence, it remains constant). PowerBASIC supports four types of constants: string literals, numeric literals, string equates and numeric equates.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rDefining Constants\n\r\n\rArray Data Types\n\r\n\rBit Data Types\n\r\n\rGUID Data Types\n\r\n\rObject Data Types\n\r\n\rPointers\n\r\n\rUser Defined Types\n\r\n\rUnions\n\r\n\rVariant Data Types","Constants and Literals","scr\\html_constants_and_literals.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a custom control to a DDT dialog.\n\r\n\rSyntax\n\r\n\rCONTROL ADD classname$, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rclassname$\n\r\n\rA registered custom control or common control class name, for example, &quot;MSCTLS_STATUSBAR32&quot;, etc. classname$ may be a string expression, quoted string literal, or a string equate.\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the control will be created.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control. Equates are recommended for clarity of the source code.\n\r\n\rtxt$\n\r\n\rText to be displayed in the control, if any. txt$ may be a string expression, string, or string constant, and may be zero length.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the  parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying \n\r\n\rthe width of the control. The width is given in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the control The height is given in the same terms (pixels or dialog units) as the parent dialog..\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the custom control. There are no default style values for a custom control. Many standard Windows common controls require the %WS_CHILD and %WS_VISIBLE styles to be explicitly specified, or the control may not be visible or function correctly. Please consult the control\'s documentation for information on its primary and extended styles.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the custom control. As with style&amp; above, there are no default extended style values for a custom control - the statement should explicitly include all required primary and extended styles for the control.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the custom control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the control Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the messages are handled by the DDT engine.\n\r\n\rRemarks\n\r\n\rWhen the user interacts with the control, a message is sent to the designated Callback Function. If there is no Callback Function designated, the message is sent to the callback for the dialog.\n\r\n\rThe style&amp; and exstyle&amp; values are dependent on the type of custom control or common control being used. The notification messages sent to your callback are also dependent on the type of custom control or common control being used.\n\r\n\rWhen the Callback Function receives a %WM_COMMAND message, the identity of the control sending the message can be found with the CB.CTL function. Use the CB.CTLMSG function to retrieve the notification message value in your callback. However, many Windows common controls send %WM_NOTIFY messages (to the parent dialog\'s callback, not the control callback) rather than the more conventional %WM_COMMAND messages. In such cases, the meaning of the message parameters CB.WPARAM and CB.LPARAM will vary according to the type of notification message being processed.\n\r\n\rRestrictions\n\r\n\rCustom controls may require special handling other than the DDT generic functions (CONTROL SET COLOR, CONTROL SET FONT, etc.). Consult the controls documentation for information.\n\r\n\rSee also\n\r\n\r#MESSAGES, Dynamic Dialog Tools, CONTROL HANDLE, CONTROL SEND,","CONTROL ADD statement","scr\\html_control_add.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a command button to a dialog. A command button is a button that causes an action to occur when the button is clicked. A common example of a command button is the &quot;OK&quot; button on a message box dialog.\n\r\n\rSyntax\n\r\n\rCONTROL ADD BUTTON, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the button will be created. The dialog will become the parent of the command button.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the button in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %NewAccount is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rHowever, it is typical for a dialog to include an OK and/or a Cancel button, represented by the predefined equates %IDOK and %IDCANCEL respectively. A button with an ID of %IDOK is triggered (clicked) when the ENTER key is pressed by the user, and a button with the ID of %IDCANCEL is triggered when the ESCAPE key is pressed. These and other predefined &quot;standard&quot; equates can be found in the WIN32API.INC and DDT.INC files.\n\r\n\rtxt$\n\r\n\rText to be displayed in the button. An ampersand (&amp;) may be included in txt$ to specify a hot-key. See the Remarks section below. OK and Cancel/Close buttons do not usually contain accelerators, since such buttons usually respond to the ENTER and ESCAPE keystrokes, respectively.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the  parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying \n\r\n\rthe width of the button. The width is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 50 dialog units.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the button. The height is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 14 dialog units.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the button. The default button style comprises %BS_CENTER, %BS_VCENTER, and %WS_TABSTOP. The default style is used if both the primary and extended style parameters are omitted from the statement. For example:\n\r\n\rCONTROL ADD BUTTON, hDlg, id&amp;, txt$, 100, 100, 150, 200, , , _\n\r\n\r &nbsp;CALL ButtonCallback() \' Use default styles\n\r\n\rCustom style values replace the default values. That is, they are not additional to the default style values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary button style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%BS_BOTTOM\n\r\n\rPlace the text at the bottom of the button.\n\r\n\r%BS_CENTER\n\r\n\rCenter the text horizontally in the button. (default)\n\r\n\r%BS_DEFAULT\n\r\n\rCreate a button with a heavy black border. The user can select this button by pressing the ENTER key. This style is useful for enabling the user to quickly select the most likely option. You can only have one Default button per dialog. It is recommended to make id&amp; = 1, or id&amp; = %IDOK for this control. Synonym of %BS_DEFPUSHBUTTON.\n\r\n\r%BS_DEFPUSHBUTTON\n\r\n\rSynonym of %BS_DEFAULT.\n\r\n\r%BS_FLAT\n\r\n\rCreate a flat button (without the raised 3D look).\n\r\n\r%BS_LEFT\n\r\n\rPlace the text on the left side of the button.\n\r\n\r%BS_MULTILINE\n\r\n\rWrap the caption text across multiple lines, if the text string is too long to fit on a single line. To force a wrap, insert a $CR (or $CRLF) into the caption text at the desired wrap position.\n\r\n\r%BS_NOTIFY\n\r\n\rEnable a button to send the %BN_KILLFOCUS and %BN_SETFOCUS notification messages to the button Callback Function.\n\r\n\r%BS_PUSHLIKE\n\r\n\rButton state alternates (toggles) between normal (raised) and depressed (sunken) modes.\n\r\n\r%BS_RIGHT\n\r\n\rPlace the text on the right side of the button.\n\r\n\r%BS_TOP\n\r\n\rPlace the text at the top edge of the button.\n\r\n\r%BS_VCENTER\n\r\n\rCenter the text vertically in the button. (default)\n\r\n\r%WS_BORDER\n\r\n\rAdd a thin line border around the control.\n\r\n\r%WS_DISABLED\n\r\n\rCreate a control that is initially disabled. A disabled control cannot receive input from the user. Use the CONTROL ENABLE statement to re-enable the button.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group. Groups configured this way permit the arrow keys to shift focus between the controls within the group, and focus can jump from group to group with the usual TAB and SHIFT+TAB keys. Both tab stops and groups are permitted to wrap from the end of the tab order back to the start.\n\r\n\r%WS_TABSTOP\n\r\n\rAllow button control to receive keyboard focus when the user presses the TAB and SHIFT+TAB keys. The TAB key shifts keyboard focus to the next control with the %WS_TABSTOP style, and SHIFT+TAB shifts focus to the previous control with %WS_TABSTOP. (default)\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the button control. The default extended button style comprises %WS_EX_LEFT. The default extended style is used if both the primary and extended style parameters are omitted from the CONTROL ADD BUTTON statement, in the same manner as style&amp; above.\n\r\n\rThe extended button style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_LEFT\n\r\n\rThe button has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe button has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rIf the ampersand (&amp;) character appears in the txt$ parameter, the letter that follows will be displayed underscored. This adds a control accelerator (hot-key) to enable the user to directly &quot;click&quot; a control, simply by pressing and holding the ALT key while pressing the specified hot-key. For example, &quot;E&amp;xit&quot; makes ALT+x the hot-key.\n\r\n\rOn Windows XP and Windows 2000 you may need to press the ALT key before Control Accelerators are made visible. You can set if Command Accelerators are visible when using the ALT key or all the time in the Windows Display Settings.\n\r\n\rUnless the %BS_FLAT style is used, the button is drawn on the dialog using a 3-dimensional look. When the user clicks a button, a message is sent to the Callback Function designated for the button. If there is no Callback Function designated, the message is sent to the callback for the dialog.\n\r\n\rIn general, if the control Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE, if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rNotification messages are sent to the Callback Function, with CB.MSG = %WM_COMMAND, CB.CTL holding the ID (id&amp;) of the control, and CB.CTLMSG holding the following values:\n\r\n\r%BN_CLICKED\n\r\n\rSent when the user clicks a mouse button, or activates the button with the hot-key (unless the button has been disabled).\n\r\n\r%BN_DISABLE\n\r\n\rSent when a button is disabled.\n\r\n\r%BN_KILLFOCUS\n\r\n\rSent when a button loses the keyboard focus. The button must include the %BS_NOTIFY style.\n\r\n\r%BN_SETFOCUS\n\r\n\rSent when a button receives the keyboard focus. The button must include the %BS_NOTIFY style.\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET TEXT, CONTROL SET FONT, CONTROL SET TEXT","CONTROL ADD BUTTON statement","scr\\html_control_add_button.htm","                  \n\r\n\rPurpose\n\r\n\rAdd an auto 3-state checkbox to a dialog. This is commonly used to indicate a selection that may be True (set or checked), False (unset or cleared) or Indeterminate (grayed), and is often found in dialogs that provide &quot;multiple choice&quot; options.\n\r\n\rSyntax\n\r\n\rCONTROL ADD CHECK3STATE, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the 3-state checkbox will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the %AutoLogoff equate is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rtxt$\n\r\n\rText to be displayed in the 3-state checkbox. An ampersand (&amp;) may be included in txt$ to specify a hot-key. See the Remarks section below.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the control. The width is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 40 dialog units.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the control. The height is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 14 dialog units.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the 3-state checkbox control. The default 3-state checkbox style comprises %BS_LEFT, %BS_VCENTER, and %WS_TABSTOP. The default style is used only if both the primary and extended style parameters are omitted from the statement. For example:\n\r\n\rCONTROL ADD CHECK3STATE, hDlg, id&amp;, txt$, 100, 100, 40, 14, , , _\n\r\n\r &nbsp;CALL Check3Callback() \' Use default styles\n\r\n\rCustom style values replace the default values. That is, they are not additional to the default style values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary 3-state checkbox style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%BS_BOTTOM\n\r\n\rPlace the text at the bottom of the control.\n\r\n\r%BS_CENTER\n\r\n\rCenter the text horizontally in the control.\n\r\n\r%BS_FLAT\n\r\n\rCreate a flat control (without the raised 3D look).\n\r\n\r%BS_LEFT\n\r\n\rPlace the text on the left side of the checkbox. Also see %BS_LEFTTEXT. (default)\n\r\n\r%BS_LEFTTEXT\n\r\n\rPlace the checkbox to the right of the text portion of the control. Combine with %BS_RIGHT to right-align text against the left side of the checkbox control.\n\r\n\r%BS_MULTILINE\n\r\n\rWrap the caption text across multiple lines, if the text string is too long to fit on a single line. To force a wrap, insert a $CR (or $CRLF) into the caption text at the desired wrap position.\n\r\n\r%BS_NOTIFY\n\r\n\rEnable a control to send the %BN_KILLFOCUS and %BN_SETFOCUS messages to the callback.\n\r\n\r%BS_PUSHLIKE\n\r\n\rButton state alternates (toggles) between normal (raised) and depressed (sunken) modes.\n\r\n\r%BS_RIGHT\n\r\n\rPlace the text on the right side of the checkbox. Also see %BS_LEFTTEXT.\n\r\n\r%BS_TOP\n\r\n\rPlace the text at the top of the control.\n\r\n\r%BS_VCENTER\n\r\n\rCenter the text vertically in the control. (default)\n\r\n\r%WS_DISABLED\n\r\n\rCreate a control that is initially disabled. A disabled control cannot receive input from the user.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group. Groups configured this way permit the arrow keys to shift focus between the controls within the group, and focus can jump from group to group with the usual TAB and SHIFT+TAB keys. Both tab stops and groups are permitted to wrap from the end of the tab order back to the start.\n\r\n\r%WS_TABSTOP\n\r\n\rAllow the 3-state checkbox to receive keyboard focus when the user presses the TAB and SHIFT+TAB keys. The TAB key shifts keyboard focus to the next control with the %WS_TABSTOP style, and SHIFT+TAB shifts focus to the previous control with %WS_TABSTOP. (default)\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the 3-state checkbox control. The default extended 3-state checkbox style comprises %WS_EX_LEFT. The default extended style is used if both the primary and extended style parameters are omitted from the CONTROL ADD CHECK3STATE statement, in the same manner as style&amp; above.\n\r\n\rThe extended 3-state checkbox style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIn general, if the control Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rIf the ampersand (&amp;) character appears in the txt$ parameter, the letter that follows will be displayed underscored. This adds a control accelerator (hot-key) to enable the user to directly &quot;click&quot; a control, simply by pressing and holding the ALT key while pressing the specified hot-key. For example, &quot;Set s&amp;tate&quot; makes ALT+t the hot-key.\n\r\n\rWhen the user clicks a 3-state checkbox, a message is sent to the Callback Function designated for the control. If there is no Callback Function designated, the message is sent to the callback for the dialog.\n\r\n\rIf the control callback processes the notification message, it should return TRUE (non-zero) to prevent the message being passed needlessly to the dialog callback, and eventually to the DDT engine itself.\n\r\n\rNotification messages are sent to the Callback Function, with CB.MSG = %WM_COMMAND, CB.CTL holding the ID (id&amp;) of the control, and CB.CTLMSG holding the following values:\n\r\n\r%BN_CLICKED\n\r\n\rSent when the user clicks a mouse button, or activates the control with the hot-key (unless the control has been disabled).\n\r\n\r%BN_DISABLE\n\r\n\rSent when a control is disabled.\n\r\n\r%BN_KILLFOCUS\n\r\n\rSent when a control loses the keyboard focus. The control must include the %BS_NOTIFY style.\n\r\n\r%BN_SETFOCUS\n\r\n\rSent when a control receives the keyboard focus. The control must include the %BS_NOTIFY style.\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD CHECKBOX, CONTROL ADD OPTION, CONTROL GET CHECK, CONTROL SET CHECK, CONTROL SET COLOR, CONTROL SET FONT","CONTROL ADD CHECK3STATE statement","scr\\html_control_add_check3state.htm","                  \n\r\n\rPurpose\n\r\n\rAdd an auto-checkbox to a dialog. This is typically used to indicate a True/False or on/off selection, and is common in dialogs that offer choices of options to a user.\n\r\n\rSyntax\n\r\n\rCONTROL ADD CHECKBOX, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the checkbox will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %DisableUser is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rtxt$\n\r\n\rText to be displayed next to the checkbox. An ampersand (&amp;) may be included in txt$ to specify a hot-key. See the Remarks section below.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the control. The width is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 40 dialog units.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the control. The height is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 14 dialog units.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the checkbox control. The default checkbox style comprises %BS_LEFT, %BS_VCENTER, and %WS_TABSTOP. The default style is used only if both the primary and extended parameters are omitted from the statement. For example:\n\r\n\rCONTROL ADD CHECKBOX, hDlg, id&amp;, txt$, 100, 100, 40, 14, , , _\n\r\n\r &nbsp;CALL CheckboxCallback() \' Use default styles\n\r\n\rCustom style values replace the default values. That is, they are not additional to the default style values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary checkbox style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%BS_BOTTOM\n\r\n\rPlace the text at the bottom of the control.\n\r\n\r%BS_CENTER\n\r\n\rCenter the text horizontally in the control.\n\r\n\r%BS_LEFT\n\r\n\rPlace the text on the left side of the label portion of the control. Also see %BS_LEFTTEXT. (default)\n\r\n\r%BS_LEFTTEXT\n\r\n\rPlace the checkbox to the right of the text portion of the control. Combine with %BS_RIGHT to right-align text against the left side of the checkbox control.\n\r\n\r%BS_MULTILINE\n\r\n\rWrap the caption text across multiple lines, if the text string is too long to fit on a single line. To force a wrap, insert a $CR (or $CRLF) into the caption text at the desired wrap position.\n\r\n\r%BS_NOTIFY\n\r\n\rEnable a control to send the %BN_KILLFOCUS and %BN_SETFOCUS messages to the callback.\n\r\n\r%BS_PUSHLIKE\n\r\n\rButton state alternates (toggles) between normal (raised) and depressed (sunken) modes.\n\r\n\r%BS_RIGHT\n\r\n\rPlace the text on the right side of the label portion of the control. Also see %BS_LEFTTEXT.\n\r\n\r%BS_TOP\n\r\n\rPlace the text at the top of the control.\n\r\n\r%BS_VCENTER\n\r\n\rCenter the text vertically in the control. (default)\n\r\n\r%WS_DISABLED\n\r\n\rCreate a control that is initially disabled. A disabled control cannot receive input from the user.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group. Groups configured this way permit the arrow keys to shift focus between the controls within the group, and focus can jump from group to group with the usual TAB and SHIFT+TAB keys. Both tab stops and groups are permitted to wrap from the end of the tab order back to the start.\n\r\n\r%WS_TABSTOP\n\r\n\rAllow checkbox control to receive the keyboard focus when the user presses the TAB and SHIFT+TAB keys. Pressing the TAB key changes the keyboard focus to the next control with the %WS_TABSTOP style, and SHIFT+TAB moves it to the previous control with %WS_TABSTOP. (default)\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the checkbox control. The default extended checkbox style comprises %WS_EX_LEFT. The default extended style is used if both the primary and extended parameters are omitted from the CONTROL ADD CHECKBOX statement, in the same manner as style&amp; above.\n\r\n\rThe extended checkbox style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIn general, when the control Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rIf the ampersand (&amp;) character appears in the txt$ parameter, the letter that follows will be displayed underscored. This adds a control accelerator (hot-key) to enable the user to directly &quot;click&quot; a control, simply by pressing and holding the ALT key while pressing the specified hot-key. For example, &quot;O&amp;ption &quot; makes ALT+p the hot-key.\n\r\n\rWhen the user clicks a control, a message is sent to the Callback Function designated for the control. If there is no Callback Function designated, the message is sent to the callback for the dialog.\n\r\n\rIf the control callback processes the notification message, it should return TRUE (non-zero) to prevent the message being passed needlessly to the dialog callback, and eventually to the DDT engine itself.\n\r\n\rNotification messages are sent to the Callback Function, with CB.MSG = %WM_COMMAND, CB.CTL holding the ID (id&amp;) of the control, and CB.CTLMSG holding the following values:\n\r\n\r%BN_CLICKED\n\r\n\rSent when the user clicks a mouse button or activates the control with the hot-key (unless the control has been disabled).\n\r\n\r%BN_DISABLE\n\r\n\rSent when a control is disabled.\n\r\n\r%BN_KILLFOCUS\n\r\n\rSent when a control loses the keyboard focus. The control must include the %BS_NOTIFY style.\n\r\n\r%BN_SETFOCUS\n\r\n\rSent when a control receives the keyboard focus. The control must include the %BS_NOTIFY style.\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD CHECK3STATE, CONTROL ADD OPTION, CONTROL GET CHECK, CONTROL SET CHECK, CONTROL SET COLOR, CONTROL SET FONT","CONTROL ADD CHECKBOX statement","scr\\html_control_add_checkbox.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a combo box to a dialog. A combo box is often used to allow a user to select an item from a predefined list, or enter a fresh (unlisted) item. A combo box may contain only text strings. To put numbers in a combo box, convert them to strings with the FORMAT$, USING$, or STR$ functions.\n\r\n\rSyntax\n\r\n\rCONTROL ADD COMBOBOX, hDlg, id&amp;, [items$()], x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the combo box will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %StockNumberList is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers\n\r\n\ritems$()\n\r\n\rOptional dynamic (variable length) string array, containing the initial items to be displayed in the combo box. Items are copied from the array to the combo box, starting at the lowest subscript of the array (LBOUND), continuing on toward the end of the array, until an empty string is encountered, or the highest subscript is reached. If an array with an LBOUND of zero (the default) is specified, be sure that the 1st element (0) contains data.\n\r\n\rTo create a combo box that is initially empty, either omit this parameter, or specify an array whose first element contains an empty string. If the combo box uses the %CBS_SORT style, the items are sorted alphanumerically as they are added to the combo box.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the control. The width is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is around 100 dialog units.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the control. The height is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 40 dialog units.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the control.\n\r\n\rThere are three types of combo boxes: simple, dropdown, and dropdownlist. A simple combo box consists of a text box control and a list box; the list box is always displayed. A dropdown combo box consists of a text box control and a list box; the list box is not displayed unless the user clicks an icon. A dropdownlist combo box consists of a label control (not editable) and a list box; the list box is not displayed unless the user clicks an icon.\n\r\n\rCombo box style\n\r\n\rList box control\n\r\n\rText box control\n\r\n\rSimple \n\r\n\rNo \n\r\n\rYes\n\r\n\rDropdown (default)\n\r\n\rYes \n\r\n\rYes\n\r\n\rDropdownlist \n\r\n\rYes \n\r\n\rNo\n\r\n\rNote that some styles of combo box are mutually exclusive. In other words, you cannot combine certain styles that may conflict with one another. For example, you cannot specify %CBS_SIMPLE and %CBS_DROPDOWN at the same time.\n\r\n\rThe default combo box style comprises %CBS_DROPDOWN, %CBS_SORT, and %WS_TABSTOP. The default style is used only if both the primary and extended style parameter values are omitted from the statement. For example:\n\r\n\rCONTROL ADD COMBOBOX, hDlg, id&amp;, txt$(), 100, 100, 100, 40, , , CALL ComboCallback() \' Use default styles\n\r\n\rCustom style values replace the default values. That is, they are not additional to the default style values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary combo box style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%CBS_AUTOHSCROLL\n\r\n\rAutomatically scroll the text in the text box to the right when the user types a character at the end of the line. If this style is not set, only text that fits within the rectangular boundary is allowed.\n\r\n\r%CBS_DISABLENOSCROLL\n\r\n\rShow a disabled vertical scroll bar in the list box when the box does not contain enough items to scroll. Without this style, the scroll bar is hidden when the list box does not contain enough items.\n\r\n\r%CBS_DROPDOWN \n\r\n\rSimilar to %CBS_SIMPLE, except that the list box is not displayed unless the user selects the icon next to the edit control. (default)\n\r\n\r%CBS_DROPDOWNLIST\n\r\n\rSimilar to %CBS_DROPDOWN, except that the text box is replaced by a (non-editable) label item that displays the current selection in the list box.\n\r\n\r%CBS_HASSTRINGS\n\r\n\rThe combo box will contain strings. (persistent)\n\r\n\r%CBS_LOWERCASE\n\r\n\rConvert to lowercase any uppercase characters entered into the text box control portion of the combo box.\n\r\n\r%CBS_NOINTEGRALHEIGHT\n\r\n\rCreate the list box portion of the combo box with exactly the size specified by the CONTROL ADD COMBOBOX statement. Without this style, Windows reduces the height of the list box portion of the combo box so that it does not display any partial (clipped) items.\n\r\n\r%CBS_SIMPLE\n\r\n\rDisplay the list box at all times. The current selection in the list box is displayed in the text box.\n\r\n\r%CBS_SORT\n\r\n\rAutomatically sorts strings added to the combo box. (default)\n\r\n\r%CBS_UPPERCASE\n\r\n\rConvert any characters entered into the text box of a combo box into uppercase.\n\r\n\r%WS_DISABLED\n\r\n\rCreate a control that is initially disabled. A disabled control cannot receive input from the user. Use the CONTROL ENABLE statement to re-enable a disabled control.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group.\n\r\n\r%WS_TABSTOP\n\r\n\rAllow combo box control to receive keyboard focus when the user presses the TAB and SHIFT+TAB keys. The TAB key shifts keyboard focus to the next control with the %WS_TABSTOP style, and SHIFT+TAB shifts focus to the previous control with %WS_TABSTOP. (default)\n\r\n\r%WS_VSCROLL\n\r\n\rAllow the control to display a vertical scroll bar if the list is longer than the height of the combo box. Use in conjunction with %CBS_DISABLENOSCROLL to make the scroll bar visible at all times.\n\r\n\rDo not intermix list box styles with similarly named combo box styles as the numeric values of similar styles can produce unexpected results. For example, %LBS_SORT =&amp;H2 and %CBS_SORT = &amp;H100. Combo box styles are prefixed with %CBS.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the combo box control. The default extended combo box style comprises %WS_EX_LEFT, and %WS_EX_CLIENTEDGE. The default extended style is only used if both the primary and extended parameters are omitted from the CONTROL ADD COMBOBOX statement, in the same manner as style&amp; above.\n\r\n\rThe extended combo box style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control. (default)\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIn general, when the control Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rWhen the user selects an item or edits the text of a combo box, a message is sent to the Callback Function designated for the combo box. If there is no Callback Function designated then the message is sent to the callback for the dialog.\n\r\n\rIf the control callback processes the notification message, it should return TRUE (non-zero) to prevent the message being passed needlessly to the dialog callback, and eventually to the DDT engine itself.\n\r\n\rNotification messages are sent to the Callback Function, with CB.MSG = %WM_COMMAND, CB.CTL holding the ID (id&amp;) of the control, and CB.CTLMSG holding the following values:\n\r\n\r%CBN_CLOSEUP\n\r\n\rSent when the list box of a combo box has been closed.\n\r\n\r%CBN_DBLCLK\n\r\n\rSent when the user double-clicks a string in the list box of a combo box.\n\r\n\r%CBN_DROPDOWN\n\r\n\rSent when the list box of a combo box is about to be made visible.\n\r\n\r%CBN_EDITCHANGE\n\r\n\rSent after the user has taken an action that may have altered the text in the text box portion of a combo box. Unlike the %CBN_EDITUPDATE notification message, this notification message is sent after Windows updates the screen.\n\r\n\r%CBN_EDITUPDATE\n\r\n\rSent when the text box portion of a combo box is about to display altered text. This notification message is sent after the control has formatted the text, but before it displays the text.\n\r\n\r%CBN_ERRSPACE\n\r\n\rSent when a combo box cannot allocate enough memory to meet a specific request.\n\r\n\r%CBN_KILLFOCUS\n\r\n\rSent when a combo box loses the keyboard focus.\n\r\n\r%CBN_SELCHANGE\n\r\n\rSent when the selection in the list box of a combo box is about to be changed, as a result of the user either clicking in the list box or changing the selection by using the arrow keys.\n\r\n\r%CBN_SELCANCEL\n\r\n\rSent when the user selects an item, but then selects another control or closes the dialog box. It indicates the user\'s initial selection is to be ignored.\n\r\n\r%CBN_SELENDOK\n\r\n\rSent when the user selects a list item, or selects an item and then closes the list. It indicates that the user\'s selection is to be processed.\n\r\n\r%CBN_SETFOCUS\n\r\n\rSent when a combo box receives the keyboard focus.\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, COMBOBOX, CONTROL SET COLOR, CONTROL SET FONT","CONTROL ADD COMBOBOX statement","scr\\html_control_add_combobox.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a frame to a dialog. This is also known as a &quot;group&quot; control, and is typically drawn around controls to indicate a visual association between such controls. A frame control is often used around related Option controls.\n\r\n\rSyntax\n\r\n\rCONTROL ADD FRAME, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the frame will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %RelatedItems is more informative than a literal value such as 497. If you will not be changing the text in a frame control after it is created, you may use -1 for the id&amp;; however, best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rtxt$\n\r\n\rText to be displayed in the frame. An ampersand (&amp;) may be included in txt$ to specify a hot-key. See the Remarks section below.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the control. The width is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 40 dialog units.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the control. The height is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 14 dialog units.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the frame control. The default frame style comprises %BS_LEFT, and %BS_TOP. The default style is used only if both the primary and extended parameters are omitted from the statement. For example:\n\r\n\rCONTROL ADD FRAME, hDlg, id&amp;, txt$, 100, 100, 40, 14, , \' Use default styles\n\r\n\rCustom style values replace the default values. That is, they are not additional to the default style values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary frame style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%BS_CENTER\n\r\n\rCenter the text horizontally in the frame.\n\r\n\r%BS_LEFT\n\r\n\rPlace the text on the left side of the frame. (default)\n\r\n\r%BS_GROUPBOX\n\r\n\rDisplay a frame in which other controls can be positioned to infer a &quot;visual association&quot; or relationship between those controls. (persistent)\n\r\n\r%BS_MULTILINE\n\r\n\rWrap the caption text across multiple lines if the text string is too long to fit on a single line. Wrapping is not automatic, but the line wrap position can be specified by inserting a $CR (or $CRLF) character at the desired wrap position in the caption text.\n\r\n\r%BS_RIGHT\n\r\n\rPlace the text on the right side of the frame.\n\r\n\r%BS_TOP\n\r\n\rPlace the text at the top of the frame. (persistent) Note: the %BS_TOP style is persistent - the frame control does not support %BS_BOTTOM alignment.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group. Groups configured this way permit the arrow keys to shift focus between the controls within the group, and focus can jump from group to group with the usual TAB and SHIFT+TAB keys. Both tab stops and groups are permitted to wrap from the end of the tab order back to the start.\n\r\n\r%WS_DISABLED\n\r\n\rCreate a control that is initially disabled. A disabled frame control is displayed with grayed text.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the frame control. The default extended frame style comprises %WS_EX_LEFT. The default extended style is used if both the primary and extended parameters are omitted from the CONTROL ADD FRAME statement, in the same manner as style&amp; above.\n\r\n\rThe extended combo box style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rRemarks\n\r\n\rA frame control does not send messages to its parent dialog and does not require or support a Callback.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET TEXT, CONTROL SET COLOR, CONTROL SET FONT, CONTROL SET TEXT","CONTROL ADD FRAME statement","scr\\html_control_add_frame.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a static graphic control to a dialog for drawing, pictures, text, etc.\n\r\n\rSyntax\n\r\n\rCONTROL ADD GRAPHIC, hDlg, ID, Txt$, x, y, nWide, nHigh [,style] [,exstyle] [,CALL CallBack]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the graphic control will be placed. The dialog will become the parent of the control.\n\r\n\rID\n\r\n\rA unique numeric identifier for this control which is specified by the programmer. It must be an integral value in the range of 1 to 65535. This ID is usually specified with a numeric equate for clarity of the code. For example, the equate %IDC_GRAPHIC1 is more informative than a literal value such as 497. PowerBASIC recommends that identifier values should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rTxt$\n\r\n\rText to associate with the Graphic control. A Graphic control does not display this text, so it is common to set this value to a null, empty string literal (&quot;&quot; or $NUL).\n\r\n\rx, y\n\r\n\rIntegral expressions which specify the location of the control within the dialog client area. X is the horizontal position, and Y is the vertical position. 0,0 refers to the upper left corner of the Dialog. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rnWide, nHigh\n\r\n\rIntegral expressions which specify the overall width and height of the GRAPHICimage area. If you choose a style which includes a border, the client area will be slightly smaller, in order to accommodate it. You use GRAPHIC GET CLIENT to determine the exact client size available to you. The width and height are given in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rstyle\n\r\n\rOptional primary style of the image control. This value can be a combination of the values below, combined together with the OR operator to form a bitmask. If style is omitted, the default combination is %WS_CHILD OR %WS_VISIBLE OR %SS_OWNERDRAW.\n\r\n\r%SS_NOTIFY\n\r\n\rSend %STN_CLICKED and %STN_DBLCLK notification messages to the Callback Function when the user clicks or double-clicks the control.\n\r\n\r%SS_SUNKEN\n\r\n\rDraw a half-sunken border around the graphic control.\n\r\n\r%WS_BORDER\n\r\n\rAdd a thin line border around the graphic control.\n\r\n\r%WS_DLGFRAME\n\r\n\rCreate a graphic control that has a border of the style typically used with dialog boxes.\n\r\n\rexstyle\n\r\n\rOptional extended style of the graphic control. This value can be a combination of the values below, combined together with the OR operator to form a bitmask. If exstyle is omitted, there is no default extended style.\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rA graphic control is typically used with graphic statements to draw graphs, pictures, text, etc. After you create a graphic control, you would normally use GRAPHIC ATTACH to select it as the target of subsequent GRAPHIC statements. However, if there is no selected graphic target at the time of creation, the new Graphic Control is automatically attached and selected.\n\r\n\rA graphic control will only send notification messages to a callback if the %SS_NOTIFY style is used. Notification messages are sent to the callback function with CB.MSG = %WM_COMMAND, CB.CTL holding the ID (id&amp;) of the control, and CB.CTLMSG holding one of the following values:\n\r\n\r%STN_CLICKED\n\r\n\rSent when the user clicks a mouse button on the graphic control (unless the image control has been disabled).\n\r\n\r%STN_DBLCLK\n\r\n\rSent when the user double-clicks on a graphic control (unless the control has been disabled).\n\r\n\r%STN_DISABLE\n\r\n\rSent when a graphic control has been disabled.\n\r\n\r%STN_ENABLE\n\r\n\rSent when a graphic control has been enabled.\n\r\n\rWhen a callback function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rAll PowerBASIC graphical displays are persistent -- they will be automatically redrawn when altered or temporarily covered by another window.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, GRAPHIC ATTACH, GRAPHIC COLOR, GRAPHIC SCALE, GRAPHIC SET FONT, GRAPHIC STYLE, GRAPHIC WIDTH, GRAPHIC WINDOW","CONTROL ADD GRAPHIC statement","scr\\html_control_add_graphic.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a header control to a dialog.\n\r\n\rSyntax\n\r\n\rCONTROL ADD HEADER, hDlg, ID, Txt$, x, y, wide, high [,style] [,exstyle] [,CALL CallBack]\n\r\n\rRemarks\n\r\n\rHandle of the dialog on which the header control will be placed. The dialog will become the parent of the control.\n\r\n\rID\n\r\n\rA unique numeric identifier for this control which is specified by the programmer. It must be an integral value in the range of 1 to 65535. This ID is usually specified with a numeric equate for clarity of the code. For example, the equate %IDC_HEADER1 is more informative than a literal value such as 497. PowerBASIC recommends that identifier values should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rTxt$\n\r\n\rText to associate with the Header control. A Header control does not display this text, so it is common to set this value to a null, empty string literal (&quot;&quot; or $NUL).\n\r\n\rx, y\n\r\n\rIntegral expressions which specify the location of the control within the dialog client area. X is the horizontal position, and Y is the vertical position. 0,0 refers to the upper left corner of the Dialog. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rwide, high\n\r\n\rIntegral expressions which specify the overall width and height of the header area.\n\r\n\rstyle\n\r\n\rOptional primary style of the header control. This value can be a combination of the values below, combined together with the OR operator to form a bitmask. If style is omitted, the default combination is %WS_CHILD OR %WS_VISIBLE.\n\r\n\r%WS_CHILD\n\r\n\rThe control is a child window.\n\r\n\r%WS_VISIBLE\n\r\n\rThe control is visible.\n\r\n\r%WS_BORDER\n\r\n\rAdd a thin line border around the header control.\n\r\n\rexstyle\n\r\n\rOptional extended style of the header control.\n\r\n\rcallback\n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rSee Also\n\r\n\rHEADER","CONTROL ADD HEADER statement","scr\\html_control_add_header_statement.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a (non-resizing) image control to a dialog. This is typically used to display a bitmap or icon stored in a resource file.\n\r\n\rSyntax\n\r\n\rCONTROL ADD IMAGE, hDlg, id&amp;, image$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the image will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the image in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %WizardBMP is more informative than a literal value such as 497. If you will not be changing the image in the control after it is created, you may use -1 for the id&amp;; however, best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rimage$\n\r\n\rName of the bitmap or icon in the resource file. If the image resource uses an integral identifier, image$ should begin with a Number symbol (#) followed by the identifier in an ASCII format, e.g., &quot;#998&quot; or FORMAT$(rcid&amp;, &quot;\\##&quot;). Otherwise, use the text identifier name for the image.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the image. The width is given in the same terms (pixels or dialog units) as the parent dialog. This value is ignored unless the %SS_CENTERIMAGE style is specified.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the image. The height is given in the same terms (pixels or dialog units) as the parent dialog. This value is ignored unless the %SS_CENTERIMAGE style is specified.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the image control. This value can be a combination of the values below, combined together with the OR operator to form a bitmask.\n\r\n\rIn addition, the initial image format may be specified explicitly as either %SS_ICON or %SS_BITMAP, or the image format may be omitted completely.\n\r\n\rIf the image format is specified, it must match the format of the file specified in image$. However, if the image format is not specified, PowerBASIC will examine the file to determine the correct image format to use.\n\r\n\r%SS_BITMAP\n\r\n\rDisplay only bitmap images. Also see %SS_ICON. (persistent)\n\r\n\r%SS_CENTERIMAGE\n\r\n\rIf the image is smaller than the label, fill the rest of the label with the color of the pixel in the top left corner of the image.\n\r\n\r%SS_ICON\n\r\n\rDisplay only icon images. Also see %SS_ICON. (persistent)\n\r\n\r%SS_NOTIFY\n\r\n\rSend %STN_CLICKED and %STN_DBLCLK notification messages to the Callback Function when the user clicks or double-clicks the control.\n\r\n\r%SS_SUNKEN\n\r\n\rDraw a half-sunken border around the image control.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group. Groups configured this way permit the arrow keys to shift focus between the controls within the group, and focus can jump from group to group with the usual TAB and SHIFT+TAB keys. Both tab stops and groups are permitted to wrap from the end of the tab order back to the start.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the image control. The default extended image control style comprises %WS_EX_LEFT. The default extended style is used if both the primary and extended parameters are omitted from the CONTROL ADD IMAGE statement, in the same manner as style&amp; above.\n\r\n\rThe extended image control style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_TRANSPARENT \n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIn general, when the control Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rThe bitmap or icon used in the image is not resized to fit the control. If your control is 64 dialog units wide and your icon or bitmap is only 32, half of the image will be blank. For best results, icons should be 32x32 pixels.\n\r\n\rOnce an image control has been created, the images it displays can be changed with the CONTROL SET IMAGE statement, but only if the images are of the same format as the original. For example, if an image control was initially created showing a bitmap file, all subsequent image changes must also be bitmap images. However, if the image format must be changed at run-time, for example, because icons are to be displayed instead of bitmaps, there are a couple of options. For example, the application could use separate controls for each image format, or the existing control could be destroyed, and a new control created with an image of the opposite format.\n\r\n\rAn image control will only send notification messages to a callback if the %SS_NOTIFY style is used. Notification messages are sent to the Callback Function with CB.MSG = %WM_COMMAND, CB.CTL holding the ID (id&amp;) of the control, and CB.CTLMSG holding the following values:\n\r\n\r%STN_CLICKED\n\r\n\rSent when the user clicks a mouse button on the image control (unless the image control has been disabled).\n\r\n\r%STN_DBLCLK\n\r\n\rSent when the user double-clicks on an image control (unless the control has been disabled).\n\r\n\r%STN_DISABLE\n\r\n\rSent when an image control has been disabled.\n\r\n\r%STN_ENABLE\n\r\n\rSent when an image control has been enabled.\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD GRAPHIC, CONTROL ADD IMAGEX, CONTROL ADD IMGBUTTON, CONTROL ADD IMGBUTTONX, CONTROL SET IMAGE, CONTROL SET IMAGEX, CONTROL SET IMGBUTTON, CONTROL SET IMGBUTTONX","CONTROL ADD IMAGE statement","scr\\html_control_add_image.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a stretched image control to a dialog. This is typically used to display bitmaps and icons, which are automatically stretched or condensed to fill the controls client area.\n\r\n\rSyntax\n\r\n\rCONTROL ADD IMAGEX, hDlg, id&amp;, image$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the image will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the image in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %BackgroundIMG is more informative than a literal value such as 497. If you will not be changing the image in the control after it is created, you may use -1 for the id&amp;; however, best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rimage$\n\r\n\rName of the bitmap or icon in the resource file. If the image resource uses an integral identifier, image$ should begin with a Number symbol (#) followed by the identifier in an ASCII format, e.g., &quot;#998&quot; or FORMAT$(rcid&amp;, &quot;\\##&quot;). Otherwise, use the text identifier name for the image.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the image. The width is given in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the image. The height is given in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the stretched image control. In addition to the image control styles listed below, the initial image format may be specified explicitly as either %SS_ICON or %SS_BITMAP, or you may choose not to specify the image format at all.\n\r\n\rIf the image format is specified, it must match the format of the file specified in image$. However, if the image format is not specified, PowerBASIC will examine the file to determine the correct image format to use.\n\r\n\rThis value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%SS_BITMAP\n\r\n\rDisplay only bitmap images. Also see %SS_ICON. (persistent)\n\r\n\r%SS_ICON\n\r\n\rDisplay only icon images. Also see %SS_ICON. (persistent)\n\r\n\r%SS_NOTIFY\n\r\n\rSend %STN_CLICKED and %STN_DBLCLK notification messages to the Callback Function when the user clicks or double-clicks the control.\n\r\n\r%SS_SUNKEN\n\r\n\rDraw a half-sunken border around the image control.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group. Groups configured this way permit the arrow keys to shift focus between the controls within the group, and focus can jump from group to group with the usual TAB and SHIFT+TAB keys. Both tab stops and groups are permitted to wrap from the end of the tab order back to the start.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the stretched image control. The default extended image style comprises %WS_EX_LEFT. The default extended style is used if both the primary and extended parameters are omitted from the CONTROL ADD IMAGEX statement, in the same manner as style&amp; above.\n\r\n\rThe extended stretched image style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_TRANSPARENT \n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIn general, when the control Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rThe bitmap or icon used in the image is resized to fit the control. If your control is 64 dialog units wide and your icon or bitmap is only 32, it will be stretched to cover the entire control. For best results, icons should be 32x32 pixels.\n\r\n\rAn image control will only send notification messages to a callback if the %SS_NOTIFY style is used. Notification messages are sent to the Callback Function with CB.MSG = %WM_COMMAND, CB.CTL holding the ID (id&amp;) of the control, and CB.CTLMSG holding the following values:\n\r\n\r%STN_CLICKED\n\r\n\rSent when the user clicks a mouse button on the image control (unless the image control has been disabled).\n\r\n\r%STN_DBLCLK\n\r\n\rSent when the user double-clicks on an image control (unless the control has been disabled).\n\r\n\r%STN_DISABLE\n\r\n\rSent when an image control has been disabled.\n\r\n\r%STN_ENABLE\n\r\n\rSent when an image control has been enabled.\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rRestrictions\n\r\n\rUnder Windows 95/98/ME, an attempt to stretch an icon significantly above 64x64 may fail due to internal limits that vary between those particular versions of Windows. Bitmaps are not affected in this manner. Windows NT/2000/XP systems do not impose any comparable limitations on either icons or bitmaps.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD GRAPHIC, CONTROL ADD IMAGE, CONTROL ADD IMGBUTTON, CONTROL ADD IMGBUTTONX, CONTROL SET IMAGE, CONTROL SET IMAGEX, CONTROL SET IMGBUTTON, CONTROL SET IMGBUTTONX","CONTROL ADD IMAGEX statement","scr\\html_control_add_imagex.htm","                  \n\r\n\rPurpose\n\r\n\rAdd an image button to a dialog. Image buttons are often used to enhance the appearance of a dialog.\n\r\n\rSyntax\n\r\n\rCONTROL ADD IMGBUTTON, hDlg, id&amp;, image$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the button will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the button in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %IconButton1 is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rHowever, it is typical for a dialog to include an OK and/or a Cancel button, represented by the predefined equates %IDOK and %IDCANCEL respectively. A button with an ID of %IDOK is triggered (clicked) when the ENTER key is pressed by the user, and a button with the ID of %IDCANCEL is triggered when the ESCAPE key is pressed. These and other predefined &quot;standard&quot; equates can be found in the WIN32API.INC and DDT.INC files.\n\r\n\rimage$\n\r\n\rName of the bitmap or icon in the resource file. If the image resource uses an integral identifier, image$ should begin with a Number symbol (#) followed by the identifier in an ASCII format, e.g., &quot;#998&quot;. Otherwise, use the text identifier name for the image.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the control. The width is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 40 dialog units.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the control. The height is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 14 dialog units.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the image button control. The default image button style is %WS_TABSTOP. The default style is used only if both the primary and extended parameters are omitted from the statement. For example:\n\r\n\rCONTROL ADD IMGBUTTON, hDlg, id&amp;, txt$, 100, 100, 150, 200, , , _\n\r\n\r &nbsp;CALL ImgButtonCallback() \' Use default styles\n\r\n\rCustom style values replace the default values. That is, they are not additional to the default style values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary image button style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%BS_DEFAULT\n\r\n\rCreate the button with a heavy black border. The user can select this button by pressing the ENTER key. This style is useful for enabling the user to quickly select the most likely option. There may only be one Default button per dialog.\n\r\n\r%BS_FLAT\n\r\n\rCreate a flat button (without the raised 3D look).\n\r\n\r%BS_NOTIFY\n\r\n\rEnable a button to send the %BN_KILLFOCUS and %BN_SETFOCUS notification messages to the button Callback Function.\n\r\n\r%WS_DISABLED\n\r\n\rCreate a control that is initially disabled. A disabled control cannot receive input from the user. Use the CONTROL ENABLE statement to re-enable the button.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group. Groups configured this way permit the arrow keys to shift focus between the controls within the group, and focus can jump from group to group with the usual TAB and SHIFT+TAB keys. Both tab stops and groups are permitted to wrap from the end of the tab order back to the start.\n\r\n\r%WS_TABSTOP\n\r\n\rAllow button control to receive keyboard focus when the user presses the TAB and SHIFT+TAB keys. The TAB key shifts keyboard focus to the next control with the %WS_TABSTOP style, and SHIFT+TAB shifts focus to the previous control with %WS_TABSTOP. (default)\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the image button control. The default extended image button style comprises %WS_EX_LEFT. The default extended style is only used if both the primary and extended parameters are omitted from the CONTROL ADD IMGBUTTON statement, in the same manner as style&amp; above.\n\r\n\rThe extended image button style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_LEFT\n\r\n\rThe button has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe button has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rGenerally speaking, if the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rThe bitmap or icon used in the button is not resized to fit the button. If your button is 64 dialog units wide and your icon or bitmap is only 32, half of the button will be blank. For best results, icons should be 32x32 pixels.\n\r\n\rAn image button is drawn on the dialog using a 3-dimensional look, unless the %BS_FLAT style is specified. When the user clicks on the image button, a message is sent to the button\'s Callback Function. If there is no Callback Function designated, the message is sent to the callback for the dialog.\n\r\n\rNotification messages are sent to the Callback Function with CB.MSG = %WM_COMMAND, CB.CTL holding the ID (id&amp;) of the control, and CB.CTLMSG holding the following values:\n\r\n\r%BN_CLICKED\n\r\n\rSent when the user clicks a mouse button, or activates the button with the hot-key (unless the button has been disabled).\n\r\n\r%BN_DISABLE\n\r\n\rSent when a button is disabled.\n\r\n\r%BN_KILLFOCUS\n\r\n\rSent when a button loses the keyboard focus. The button must include the %BS_NOTIFY style.\n\r\n\r%BN_SETFOCUS\n\r\n\rSent when a button receives the keyboard focus. The button must include the %BS_NOTIFY style.\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD GRAPHIC, CONTROL ADD IMAGE, CONTROL ADD IMAGEX, CONTROL ADD IMGBUTTONX, CONTROL SET IMAGE, CONTROL SET IMAGEX, CONTROL SET IMGBUTTON, CONTROL SET IMGBUTTONX","CONTROL ADD IMGBUTTON statement","scr\\html_control_add_imgbutton.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a stretched image button to a dialog. Stretched image buttons are often used to enhance the appearance of a dialog, with the image being automatically stretched or condensed to fill the control.\n\r\n\rSyntax\n\r\n\rCONTROL ADD IMGBUTTONX, hDlg, id&amp;, image$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the button will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the button in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %IconButton2 is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rHowever, it is typical for a dialog to include an OK and/or a Cancel button, represented by the predefined equates %IDOK and %IDCANCEL respectively. A button with an ID of %IDOK is triggered (clicked) when the ENTER key is pressed by the user, and a button with the ID of %IDCANCEL is triggered when the ESCAPE key is pressed. These and other predefined &quot;standard&quot; equates can be found in the WIN32API.INC and DDT.INC files.\n\r\n\rimage$\n\r\n\rName of the bitmap or icon in the resource file. If the image resource uses an integral identifier, image$ should begin with a Number symbol (#) followed by the identifier in an ASCII format, e.g., &quot;#998&quot;. Otherwise, use the text identifier name for the image.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the control. The width is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 40 dialog units.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the control. The height is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 14 dialog units.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the stretched image button. The default image button style is %WS_TABSTOP. The default style is used if both the primary and extended style parameters are omitted from the statement. For example:\n\r\n\rCONTROL ADD IMGBUTTONX, hDlg, id&amp;, txt$, 100, 100, 150, 200, , , _\n\r\n\r &nbsp;CALL ImgButtonxCallback() \' Use default styles\n\r\n\rCustom style values replace the default values. That is, they are not additional to the default style values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary stretched image button style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%BS_DEFAULT\n\r\n\rCreate the button with a heavy black border. The user can select this button by pressing the ENTER key. This style is useful for enabling the user to quickly select the most likely option. There may only be one Default button per dialog.\n\r\n\r%BS_FLAT\n\r\n\rCreate a flat button (without the raised 3D look).\n\r\n\r%BS_NOTIFY\n\r\n\rEnable a button to send the %BN_KILLFOCUS and %BN_SETFOCUS notification messages to the button Callback Function.\n\r\n\r%WS_DISABLED\n\r\n\rCreate a control that is initially disabled. A disabled control cannot receive input from the user. Use the CONTROL ENABLE statement to re-enable the button.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group. Groups configured this way permit the arrow keys to shift focus between the controls within the group, and focus can jump from group to group with the usual TAB and SHIFT+TAB keys. Both tab stops and groups are permitted to wrap from the end of the tab order back to the start.\n\r\n\r%WS_TABSTOP\n\r\n\rAllow button control to receive keyboard focus when the user presses the TAB and SHIFT+TAB keys. The TAB key shifts keyboard focus to the next control with the %WS_TABSTOP style, and SHIFT+TAB shifts focus to the previous control with %WS_TABSTOP. (default)\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the stretched image button control. The default extended button style comprises %WS_EX_LEFT. The default extended style is used if both the primary and extended parameters are omitted from the CONTROL ADD IMGBUTTONX statement, in the same manner as style&amp; above.\n\r\n\rThe extended stretched image style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_LEFT\n\r\n\rThe button has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe button has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rThe bitmap or icon used in the button is resized to fit the button. If your button is 64 dialog units wide and your icon or bitmap is only 32, it will be stretched to cover the entire button. For best results, icons should be 32x32 pixels.\n\r\n\rThe image button is drawn on the dialog using a 3-dimensional look, unless the %BS_FLAT style is specified. When the user clicks a button, a message is sent to the Callback Function designated for the button. If there is no Callback Function designated, the message is sent to the callback for the dialog.\n\r\n\rNotification messages are sent to the Callback Function with CB.MSG = %WM_COMMAND, CB.CTL holding the ID (id&amp;) of the control, and CB.CTLMSG holding the following values:\n\r\n\r%BN_CLICKED\n\r\n\rSent when the user clicks a mouse button, or activates the button with the hot-key (unless the button has been disabled).\n\r\n\r%BN_DISABLE\n\r\n\rSent when a button is disabled.\n\r\n\r%BN_KILLFOCUS\n\r\n\rSent when a button loses the keyboard focus. The button must include the %BS_NOTIFY style.\n\r\n\r%BN_SETFOCUS\n\r\n\rSent when a button receives the keyboard focus. The button must include the %BS_NOTIFY style.\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD GRAPHIC, CONTROL ADD IMAGE, CONTROL ADD IMAGEX, CONTROL ADD IMGBUTTON, CONTROL SET IMAGE, CONTROL SET IMAGEX, CONTROL SET IMGBUTTON, CONTROL SET IMGBUTTONX","CONTROL ADD IMGBUTTONX statement","scr\\html_control_add_imgbuttonx.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a text label to a dialog. A text label is similar to a conventional static control.\n\r\n\rSyntax\n\r\n\rCONTROL ADD LABEL, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the label will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %BlockTitle is more informative than a literal value such as 497. If you will not be changing the text in a line control after it is created, you may use -1 for the id&amp;; however, best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rtxt$\n\r\n\rText to be displayed in text label. An ampersand (&amp;) may be included in txt$ to specify a hot-key. See the Remarks section below.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the control. The width is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 40 dialog units.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the control. The height is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 8 dialog units.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the label control. The default label style is %SS_LEFT. The default style is used if both the primary and extended style parameters are omitted from the statement. For example:\n\r\n\rCONTROL ADD LABEL, hDlg, id&amp;, txt$, 100, 100, 150, 200, , , _\n\r\n\r &nbsp;CALL LabelCallback() \' Use default styles\n\r\n\rCustom style values replace the default values. That is, they are not additional to the default style values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary label style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%SS_CENTER\n\r\n\rHorizontally center the caption text. The text is formatted before it is displayed. Words that extend past the end of a line are automatically wrapped to the beginning of the next centered line.\n\r\n\r%SS_CENTERIMAGE\n\r\n\rVertically center the caption text. The text is not wrapped even if it extends beyond the width of the control.\n\r\n\r%SS_ENDELLIPSIS\n\r\n\rReplace the end of the given string with ellipsis as needed to fit the result in the specified rectangle. Windows NT/2000/XP only.\n\r\n\r%SS_ETCHEDFRAME\n\r\n\rDraw the frame of the control using an etched edge style.\n\r\n\r%SS_ETCHEDHORZ\n\r\n\rDraw the horizontal edges of the control using an etched edge style.\n\r\n\r%SS_ETCHEDVERT\n\r\n\rDraw the vertical edges of the control using an etched edge style.\n\r\n\r%SS_LEFT\n\r\n\rLeft-align the given text. The text is formatted before it is displayed. Words that extend past the end of a line are automatically wrapped to the beginning of the next left-aligned line. (default)\n\r\n\r%SS_NOPREFIX\n\r\n\rPrevent interpretation of ampersand (&amp;) characters in the label text as control accelerator prefix characters. These are normally displayed with the ampersand removed and the next character in the string underscored.\n\r\n\r%SS_NOTIFY\n\r\n\rSend %STN_CLICKED and %STN_DBLCLK notification messages to the Callback Function when the user clicks or double-clicks the control.\n\r\n\r%SS_NOWORDWRAP\n\r\n\rLeft-align the given text. Tabs are expanded but words are not wrapped. Text that extends past the end of a line is clipped.\n\r\n\r%SS_PATHELLIPSIS\n\r\n\rReplace the file path portion of the given string with ellipsis as needed to fit the result in the specified rectangle. Windows 2000/XP only.\n\r\n\r%SS_RIGHT\n\r\n\rRight-align the given text. The text is formatted before it is displayed. Words that extend past the end of a line are automatically wrapped to the beginning of the next right-aligned line.\n\r\n\r%SS_SIMPLE\n\r\n\rThe caption text is left-aligned. If the control is colored, color is only applied to the region containing the caption text, and the remainder of the control is drawn in standard colors.\n\r\n\r%SS_SUNKEN\n\r\n\rDraw a half-sunken border around the label control.\n\r\n\r%SS_WORDELLIPSIS\n\r\n\rTruncate text that does not fit, adding ellipsis as needed. Windows NT/2000/XP only\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the label control. The default extended label style comprises %WS_EX_LEFT. The default extended style is used if both the primary and extended parameters are omitted from the CONTROL ADD LABEL statement, in the same manner as style&amp; above.\n\r\n\rThe extended label style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rIf the ampersand (&amp;) character appears in the txt$ parameter, the letter that follows will be displayed underscored. This adds a control accelerator (hot-key) to enable the user to directly &quot;click&quot; the control that immediately follows in the Tab-Order after the Label control, simply by pressing and holding the ALT key while pressing the specified hot-key. For example, &quot;Choose &amp;Security Level&quot; makes ALT+S the hot-key.\n\r\n\rA label control will only send messages to a callback if the %SS_NOTIFY style is used. The following notifications are sent to the Callback Function:\n\r\n\r%STN_CLICKED\n\r\n\rSent when the user clicks a mouse button, or activates the button with the hot-key (unless the button has been disabled).\n\r\n\r%STN_DBLCLK\n\r\n\rSent when the user double-clicks on a label control (unless the control has been disabled).\n\r\n\r%STN_DISABLE\n\r\n\rSent when a button is disabled.\n\r\n\r%STN_ENABLE\n\r\n\rSent when a label control has been enabled.\n\r\n\rUse the CONTROL SET TEXT statement to change the text in a label control and CONTROL SET FONT to change the font used in a label control. This is only possible if the label has a unique ID value (i.e., id&amp; should not be -1).\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET TEXT, CONTROL SET COLOR, CONTROL SET FONT, CONTROL SET TEXT","CONTROL ADD LABEL statement","scr\\html_control_add_label.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a line control to a dialog. A line control may also be a rectangle (empty or filled).\n\r\n\rSyntax\n\r\n\rCONTROL ADD LINE, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the line will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %SeparatorLeft is more informative than a literal value such as 497. If you will not be changing the size or location of a line control after it is created, you may use -1 for the id. Otherwise, best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rtxt$\n\r\n\rText to associate with the line control. A line control does not display text, so it is possible to use this string for your own purposes; however, an ampersand (&amp;) may be included in txt$ to specify a hot-key. See the Remarks section below.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the control. The width is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 40 dialog units.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the control. The height is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 1 dialog unit.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the line control. The default line style is %SS_ETCHEDFRAME. The default style is used if both the primary and extended style parameters are omitted from the statement. For example:\n\r\n\rCONTROL ADD LINE, hDlg, id&amp;, &quot;&quot;, 100, 100, 150, 1, , , CALL LineCallback() \' Use default styles\n\r\n\rCustom style values replace the default values. That is, they are not additional to the default style values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary line style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%SS_BLACKFRAME\n\r\n\rDraw a box with the frame drawn in the same color as the window frames. This color is black in the default Windows color scheme.\n\r\n\r%SS_BLACKRECT\n\r\n\rDraw a rectangle filled with the current window frame color. This color is black in the default Windows color scheme.\n\r\n\r%SS_ETCHEDFRAME\n\r\n\rDraw the frame of the control using an etched edge style. (default)\n\r\n\r%SS_ETCHEDHORZ\n\r\n\rDraw the horizontal edges of the control using an etched edge style.\n\r\n\r%SS_ETCHEDVERT\n\r\n\rDraw the vertical edges of the control using an etched edge style.\n\r\n\r%SS_GRAYFRAME\n\r\n\rDraw a box with the frame drawn with the same color as the screen background (desktop). This color is gray in the default Windows color scheme.\n\r\n\r%SS_GRAYRECT\n\r\n\rDraw a rectangle filled with the current screen background color. This color is gray in the default Windows color scheme.\n\r\n\r%SS_NOPREFIX\n\r\n\rPrevent interpretation of any ampersand (&amp;) characters in the control\'s text as a control accelerator prefix characters. These normally are displayed with the ampersand removed and the next character in the string underscored.\n\r\n\r%SS_NOTIFY\n\r\n\rSends %STN_CLICKED and %STN_DBLCLK notification messages to the line controls Callback Function when the user clicks or double-clicks the line control.\n\r\n\r%SS_RIGHTJUST\n\r\n\rForce the bottom-right corner of the control to remain fixed when the control is resized. Only the top and left sides are adjusted to accommodate a new image.\n\r\n\r%SS_WHITEFRAME\n\r\n\rDraw a box with the frame drawn with the same color as the window backgrounds. This color is white in the default Windows color scheme.\n\r\n\r%SS_WHITERECT\n\r\n\rDraw a rectangle filled with the current window background color. This color is white in the default Windows color scheme.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the line control. The default extended line style comprises %WS_EX_LEFT. The default extended style is used if both the primary and extended parameters are omitted from the CONTROL ADD LINE statement, in the same manner as style&amp; above.\n\r\n\rThe extended line control style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control. The Callback Function will only receive messages if the %SS_NOTIFY style is used.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rIf the ampersand (&amp;) character appears in the txt$ parameter, the letter that follows will be displayed underscored. This adds a control accelerator (hot-key) to enable the user to directly &quot;click&quot; the control that immediately follows in the Tab-Order after the Line control, simply by pressing and holding the ALT key while pressing the specified hot-key. For example, &quot;&amp;Test Suite &quot; makes ALT+T the hot-key.\n\r\n\rA line control will only send messages to a callback if the %SS_NOTIFY style is used. The following notifications are sent to the Callback Function:\n\r\n\r%STN_CLICKED\n\r\n\rSent when the user clicks a line control (unless the control has been disabled).\n\r\n\r%STN_DBLCLK\n\r\n\rSent when the user double-clicks a line control (unless the control has been disabled).\n\r\n\r%STN_DISABLE\n\r\n\rSent when a line control has been disabled.\n\r\n\r%STN_ENABLE\n\r\n\rSent when a line control has been enabled.\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL HANDLE, CONTROL SEND","CONTROL ADD LINE statement","scr\\html_control_add_line.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a list box control to a dialog. A list box contains a set of predefined entries that permit a user to select one or more items. A list box may contain strings, images, or both. To put numbers in a list box, convert them to strings with the FORMAT$, USING$, or STR$ functions.\n\r\n\rSyntax\n\r\n\rCONTROL ADD LISTBOX, hDlg, id&amp;, [items$()], x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the list box will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %PickList is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\ritems$() \n\r\n\rOptional dynamic (variable length) string array containing the initial items to be displayed in the list box. Items are copied from the array to the list box, starting at the lowest subscript of the array (LBOUND), continuing on toward the end of the array until an empty string is encountered, or the highest subscript is reached. If an array with an LBOUND of zero (the default) is specified, be sure that the 1st element (0) contains data. Also see Restrictions below.\n\r\n\rTo create a list box that is initially empty, either omit this parameter, or specify an array whose first element contains an empty string. If the list box uses the %LBS_SORT style, the items are sorted alphanumerically as they are added to the list box.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the control. The width is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 100 dialog units.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the control. The height is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 40 dialog units.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the list box control. The default list box style comprises %LBS_SORT, %LBS_NOTIFY, %WS_TABSTOP, and %WS_VSCROLL (along with the %WS_EX_CLIENTEDGE extended style). The default list box style is used if both the primary and extended style parameters are omitted from the statement. For example:\n\r\n\rCONTROL ADD LISTBOX, hDlg, id&amp;, items$(), 100, 100, 150, 200, , , _\n\r\n\r &nbsp;CALL ListboxCallback() \' Use default styles\n\r\n\rCustom style values replace the default values. That is, they are not additional to the default style values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary list box style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%LBS_DISABLENOSCROLL\n\r\n\rShow a disabled vertical scroll bar in the list box when the box does not contain enough items to scroll. Without this style, the scroll bar is hidden when the list box does not contain enough items. Used in conjunction with the %WS_VSCROLL style.\n\r\n\r%LBS_EXTENDEDSEL\n\r\n\rAllow selection of multiple items in the list box by using the SHIFT key with mouse and/or keyboard actions.\n\r\n\r%LBS_MULTICOLUMN\n\r\n\rList box has multiple columns, and can be scrolled horizontally. To set the width, send the %LB_SETCOLUMNWIDTH message to the list box control.\n\r\n\r%LBS_MULTIPLESEL\n\r\n\rAllow selection of multiple items in the list box (without needing to use the SHIFT key) with mouse and/or keyboard actions.\n\r\n\r%LBS_NOINTEGRALHEIGHT\n\r\n\rForce the size of the list box to be exactly the size specified when the control is created. Otherwise, Windows may resize the list box to ensure that items are not partially displayed (clipped).\n\r\n\r%LBS_NOSEL\n\r\n\rThe list box can contain items that can be viewed but not selected.\n\r\n\r%LBS_NOTIFY\n\r\n\rSend the callback a message whenever the user clicks or double-clicks a string in the list box.\n\r\n\r%LBS_SORT\n\r\n\rAutomatically sort strings added to the list box in alphanumeric order.\n\r\n\r%LBS_STANDARD\n\r\n\rEquivalent to the combination of %LBS_SORT, %LBS_NOTIFY, %WS_VSCROLL and %WS_BORDER styles.\n\r\n\r%LBS_USETABSTOPS\n\r\n\rExpand tab ($TAB, CHR$(9)) characters. The default tab positions are for every 32 dialog units. To change the tab stop positions, send the %LB_SETTABSTOPS message to the list box control.\n\r\n\r%WS_DISABLED\n\r\n\rCreate a control that is initially disabled. A disabled control cannot receive input from the user.\n\r\n\r%WS_HSCROLL\n\r\n\rAllow the control to display a horizontal scroll bar. By default this is disabled unless the controls horizontal scroll width has been configured by sending a %LB_SETHORIZONTALEXTENT message to the control. Use in conjunction with %LBS_DISABLENOSCROLL to make the scroll bar(s) visible at all times.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group.\n\r\n\r%WS_TABSTOP\n\r\n\rAllow the control to receive keyboard focus when the user presses the TAB and SHIFT+TAB keys. The TAB key shifts keyboard focus to the next control with the %WS_TABSTOP style, and SHIFT+TAB shifts focus to the previous control with %WS_TABSTOP. (default)\n\r\n\r%WS_VSCROLL\n\r\n\rAllow the control to display a vertical scroll bar if the list is longer than the height of the list box. Use in conjunction with %LBS_DISABLENOSCROLL to make the scroll bar(s) visible at all times.\n\r\n\rDo not intermix list box styles with similarly named combo box styles as the numeric values of similar styles can produce unexpected results. For example, %LBS_SORT =&amp;H2 and %CBS_SORT = &amp;H100. List box styles are prefixed with %LBS.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the list box control. The default extended list box style comprises %WS_EX_CLIENTEDGE, and %WS_EX_LEFT. The default extended style is used if both the primary and extended parameters are omitted from the CONTROL ADD LISTBOX statement, in the same manner as style&amp; above.\n\r\n\rThe extended list box style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rThe following notifications are sent to the Callback Function:\n\r\n\r%LBN_DBLCLK\n\r\n\rSent when the user double-clicks a string in the list portion of a list box.\n\r\n\r%LBN_ERRSPACE\n\r\n\rSent when a list box cannot allocate enough memory to meet a specific request.\n\r\n\r%LBN_KILLFOCUS\n\r\n\rSent when a list box loses the keyboard focus.\n\r\n\r%LBN_SELCANCEL\n\r\n\rSent when the user selects an item, but then selects another control or closes the dialog box. It indicates the user\'s initial selection is to be ignored.\n\r\n\r%LBN_SELCHANGE\n\r\n\rSent when the selection in the list box is about to be changed as a result of the user either clicking in the list box or changing the selection by using the arrow keys.\n\r\n\r%LBN_SETFOCUS\n\r\n\rSent when a list box receives the keyboard focus.\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rRestrictions \n\r\n\rUnder Windows 95/98/ME, a list box is limited to 32,736 items. In all versions of Windows, the actual string data contained by the list box is limited only by available memory.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL SET COLOR, CONTROL SET FONT, LISTBOX","CONTROL ADD LISTBOX statement","scr\\html_control_add_listbox.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a ListView control to a dialog. A ListView displays a set of predefined string data items in one or more columns. The user may then view the items, selecting one or more of them for use in the program at a later time.\n\r\n\rSyntax\n\r\n\rCONTROL ADD LISTVIEW, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg\n\r\n\rHandle of the dialog in which the ListView will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %PickList is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rtxt$\n\r\n\rText to associate with the ListView control. A ListView control does not display this text, so it is common to set this value to a null, empty string literal (&quot;&quot;).\n\r\n\rx,y\n\r\n\rInteger expressions, variables, or numeric literal values specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx,yy\n\r\n\rIntegral expressions, variable, or numeric literal values, specifying the width and height of the control. xx is the width and yy is the height, given in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the ListView control. The default ListView style comprises %WS_TABSTOP, %LVS_REPORT, and %LVS_SHOWSELALWAYS. This default ListView style is used if the style parameters are omitted from the statement, as in the following example:\n\r\n\rCONTROL ADD LISTVIEW, hDlg, id&amp;, &quot;&quot;, 100, 100, 150, 200, , , CALL LVCallback()\n\r\n\rIf you include explicit style values, they replace the default values. That is, they are not added to the default styles values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary ListView style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%LVS_ALIGNLEFT\n\r\n\rItems are left-aligned in icon and small icon view.\n\r\n\r%LVS_ALIGNTOP\n\r\n\rItems are aligned with the top of the control in icon and small icon view.\n\r\n\r%LVS_AUTOARRANGE\n\r\n\rIcons are automatically kept arranged.\n\r\n\r%LVS_EDITLABELS\n\r\n\rItem text can be edited by the user. The parent window must process notification messages.\n\r\n\r%LVS_ICON\n\r\n\rThis style specifies icon view.\n\r\n\r%LVS_LIST\n\r\n\rThis style specifies list view.\n\r\n\r%LVS_NOCOLUMNHEADER\n\r\n\rIn report view, there are no headers on the columns.\n\r\n\r%LVS_NOLABELWRAP\n\r\n\rItem text is displayed on a single line in icon view.\n\r\n\r%LVS_NOSCROLL\n\r\n\rNo scroll bars are provided. Incompatible with list view and report view.\n\r\n\r%LVS_NOSORTHEADER\n\r\n\rReport view column headers are flat, not like buttons. User can not click on the header to generate a column click notification.\n\r\n\r%LVS_OWNERDATA\n\r\n\rThis style specifies a virtual ListView control.\n\r\n\r%LVS_OWNERDRAWFIXED\n\r\n\rThe owner window can paint items in report view.\n\r\n\r%LVS_REPORT\n\r\n\rThis style specifies report view. The first column is always left-aligned and columns have headers.\n\r\n\r%LVS_SHAREIMAGELISTS\n\r\n\rThe image list will not be deleted when the control is destroyed.\n\r\n\r%LVS_SHOWSELALWAYS\n\r\n\rSelections are always shown, even without the focus.\n\r\n\r%LVS_SINGLESEL\n\r\n\rOnly one item at a time can be selected. By default, multiple items may be selected.\n\r\n\r%LVS_SMALLICON\n\r\n\rThis style specifies small icon view.\n\r\n\r%LVS_SORTASCENDING\n\r\n\rItem indexes are sorted as added in ascending order.\n\r\n\r%LVS_SORTDESCENDING\n\r\n\rItem indexes are sorted as added in descending order.\n\r\n\r%WS_DISABLED\n\r\n\rCreate a control that is initially disabled. A disabled control cannot receive input from the user.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group.\n\r\n\r%WS_TABSTOP\n\r\n\rAllow the control to receive keyboard focus when the user presses the TAB and SHIFT+TAB keys. The TAB key shifts keyboard focus to the next control with the %WS_TABSTOP style, and SHIFT+TAB shifts focus to the previous control with %WS_TABSTOP.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the ListView control. The default extended style is %WS_EX_LEFT. The default extended style is used if both the primary and extended parameters are omitted from the CONTROL ADD LISTVIEW statement, in the same manner as style&amp; above.\n\r\n\rThe extended ListView style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback\n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification messages.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL SET COLOR, CONTROL SET FONT, HEADER, LISTVIEW","CONTROL ADD LISTVIEW statement","scr\\html_control_add_listview_statement.htm","                  \n\r\n\rPurpose\n\r\n\rAdd an option button to a dialog. An option button is just like a conventional &quot;radio button&quot; control.\n\r\n\rSyntax\n\r\n\rCONTROL ADD OPTION, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the option button will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %DefCon5 is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rtxt$\n\r\n\rText to be displayed next to the option button. An ampersand (&amp;) may be included in txt$ to specify a hot-key. See the Remarks section below.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the control. The width is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 40 dialog units.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the control. The height is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 14 dialog units.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the option button control. The default option button styles are %WS_TABSTOP, %BS_LEFT, and %BS_VCENTER. The default styles are used if both the primary and extended style parameters are omitted from the statement. For example:\n\r\n\rCONTROL ADD OPTION, hDlg, id&amp;, txt$, 100, 100, 150, 200, , , _\n\r\n\r &nbsp;CALL OptionButtonCallback() \' Use default styles\n\r\n\rCustom style values replace the default values. That is, they are not in addition to the default style values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary option button style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%BS_BOTTOM\n\r\n\rPlace the text at the bottom of the control.\n\r\n\r%BS_CENTER\n\r\n\rCenter the text horizontally in the control.\n\r\n\r%BS_LEFT\n\r\n\rPlace the text on the left side of the control. Also see %BS_LEFTTEXT. (default)\n\r\n\r%BS_LEFTTEXT\n\r\n\rPlace the option button to the right of the text portion of the control. Combine with %BS_RIGHT to right-align text against the left side of the option button.\n\r\n\r%BS_MULTILINE\n\r\n\rWrap the caption text across multiple lines, if the text string is too long to fit on a single line. To force a wrap, insert a $CR (or $CRLF) into the caption text at the desired wrap position.\n\r\n\r%BS_NOTIFY\n\r\n\rEnable the %BN_KILLFOCUS and %BN_SETFOCUS notification messages for the option button.\n\r\n\r%BS_PUSHLIKE\n\r\n\rButton state alternates (toggles) between normal (raised) and depressed (sunken) modes.\n\r\n\r%BS_RIGHT\n\r\n\rPlace the text on the right side of the control. Also see %BS_LEFTTEXT.\n\r\n\r%BS_TOP\n\r\n\rPlace the text at the top of the control.\n\r\n\r%BS_VCENTER\n\r\n\rCenter the text vertically in the control. (default)\n\r\n\r%WS_DISABLED\n\r\n\rCreate a control that is initially disabled. A disabled control cannot receive input from the user.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group. Groups configured this way permit the arrow keys to shift focus between the controls within the group, and focus can jump from group to group with the usual TAB and SHIFT+TAB keys. Both tab stops and groups are permitted to wrap from the end of the tab order back to the start.\n\r\n\r%WS_TABSTOP\n\r\n\rAllow the option control to receive keyboard focus when the user presses the TAB and SHIFT+TAB keys. The TAB key shifts keyboard focus to the next control with the %WS_TABSTOP style, and SHIFT+TAB shifts focus to the previous control with %WS_TABSTOP. (default)\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the option button control. The default extended option button style comprises %WS_EX_LEFT. The default extended style is used if both the primary and extended style parameters are omitted from the CONTROL ADD OPTION statement completely, in the same manner as style&amp; above.\n\r\n\rThe extended option button style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rOption buttons are used for presenting a list of choices, only one of which may be selected. So, there is no point in having just a single option button. If what you want is to allow turning a single item on or off, use a Checkbox instead.\n\r\n\rWhen a group of option buttons are created, you should explicitly set the &quot;selected&quot; and &quot;unselected&quot; state of all option buttons, using the CONTROL SET OPTION statement to set the Check State of all the buttons in the group.\n\r\n\rIn addition, the first OPTION control in a group should have the style %WS_GROUP (to mark the beginning of a group of buttons) and %WS_TABSTOP. The remainder of the OPTION controls in the group should not have %WS_GROUP or %WS_TABSTOP styles. However, the very next non-OPTION control to appear in the tab order after the group should be given the %WS_GROUP and %WS_TABSTOP styles (the latter may depend on the type of control it is). If there are no other controls after the group, add %WS_GROUP to the first control in the dialog. This ensures that keyboard navigation with the arrow keys will operate within the group of OPTION controls, and that the TAB and SHIFT+TAB keys will switch focus between whole groups of controls (instead of individual controls as is common when each group member has the %WS_TABSTOP style).\n\r\n\rIf the ampersand (&amp;) character appears in the txt$ parameter, the letter that follows will be displayed underscored. This adds a control accelerator (hot-key) to enable the user to directly select the Option control, simply by pressing and holding the ALT key while pressing the specified hot-key. For example, &quot;Level &amp;3&quot; makes ALT+3 the hot-key.\n\r\n\rWhen the user clicks an option button, a message is sent to the Callback Function designated for the control. If there is no Callback Function designated then the message is sent to the callback for the dialog.\n\r\n\rThe following notifications are sent to the Callback Function:\n\r\n\r%BN_CLICKED\n\r\n\rSent when the user clicks a mouse button, or activates the button with the hot-key (unless the button has been disabled).\n\r\n\r%BN_KILLFOCUS\n\r\n\rSent then the option button loses keyboard focus, provided the button has the %BS_NOTIFY style.\n\r\n\r%BN_SETFOCUS\n\r\n\rSent when the option button receives keyboard focus, provided the option button has the %BS_NOTIFY style.\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD CHECK3STATE, CONTROL ADD CHECKBOX, CONTROL GET CHECK, CONTROL SET COLOR, CONTROL SET FONT, CONTROL SET OPTION\n\r\n\rExample \n\r\n\rRefer to the example in the CONTROL SET OPTION topic.","CONTROL ADD OPTION statement","scr\\html_control_add_option.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a ProgressBar control to a dialog. A ProgressBar is a rectangle that is gradually filled, left to right, as some work progresses.\n\r\n\rSyntax\n\r\n\rCONTROL ADD PROGRESSBAR, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg\n\r\n\rHandle of the dialog in which the ProgressBar will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %PickList is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rtxt$\n\r\n\rText to associate with the ProgressBar control. A ProgressBar control does not display this text, so it is common to set this value to a null, empty string literal (&quot;&quot;).\n\r\n\rx,y\n\r\n\rInteger expressions, variables, or numeric literal values specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx,yy\n\r\n\rIntegral expressions, variable, or numeric literal values, specifying the width and height of the control. xx is the width and yy is the height, given in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the ProgressBar control. The default ProgressBar style is %WS_BORDER. This default style is used if both the primary and extended style parameters are omitted from the statement, as in the following example:\n\r\n\rCONTROL ADD PROGRESSBAR, hDlg, id&amp;, &quot;&quot;,90,90,90,20, , , CALL PBCallback()\n\r\n\rIf you include explicit style values, they replace the default values. That is, they are not added to the default styles values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary style value can be a combination of the standard window values, and the values specific to a ProgressBar (below), which are combined together with the OR operator to form a bitmask:\n\r\n\r%PBS_SMOOTH\n\r\n\rThe bar is smooth rather than segmented.\n\r\n\r%PBS_VERTICAL\n\r\n\rThe control is advanced vertically.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the control. The value can be a combination of the values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback\n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification messages.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL SET COLOR, PROGRESSBAR","CONTROL ADD PROGRESSBAR statement","scr\\html_control_add_progressbar_statement.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a scroll bar control to a dialog. A scroll bar allows the user to scroll information left and right, or up and down. Your program, in response to notification messages from the scroll bar control, must do the actual scrolling itself.\n\r\n\rSyntax\n\r\n\rCONTROL ADD SCROLLBAR, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the scroll bar will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %ReportScrollUpDown is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rtxt$\n\r\n\rText to associate with the scroll bar. A scroll bar control does not display text, so it is possible to use this string for your own purposes; however, an ampersand (&amp;) may be included in txt$ to specify a (hidden) hot-key. See the Remarks section below. Typically, this parameter is specified as an empty string (&quot;&quot;) or a $NUL string equate.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the control. The width is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 10 dialog units.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the control. The height is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 11 dialog units.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the scroll bar control. The default scroll bar style is %SBS_HORZ; however, if the width is less than the height, the control is automatically switched to %SBS_VERT, regardless of whether %SBS_HORZ is specified or not. If %SBS_VERT is specified, the control will always be created as a vertical scroll bar regardless of the dimensions of the control. The default style is used if both the primary and extended style parameters are omitted from the statement. For example:\n\r\n\rCONTROL ADD SCROLLBAR, hDlg, id&amp;, txt$, 100, 100, 150, 14, , , _\n\r\n\r &nbsp;CALL Scrollbar1Callback() \' Use default styles\n\r\n\rCustom style values replace the default values. That is, they are not additional to the default style values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary scroll bar style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%SBS_BOTTOMALIGN\n\r\n\rAlign the bottom edge of the scroll bar with the bottom edge of the dialog, and use the default height of system scroll bars. Used with %SBS_HORZ.\n\r\n\r%SBS_HORZ\n\r\n\rMake the control a horizontal scroll bar (default - see style&amp; above).\n\r\n\r%SBS_LEFTALIGN\n\r\n\rAlign the left edge of the scroll bar with the left edge of the dialog, and use the default width of system scroll bars. Used with %SBS_VERT.\n\r\n\r%SBS_RIGHTALIGN\n\r\n\rAlign the right edge of the scroll bar with the right edge of the dialog, and use the default width of system scroll bars. Used with %SBS_VERT.\n\r\n\r%SBS_TOPALIGN\n\r\n\rAlign the top edge of the scroll bar with the top edge of the window, and use the default height of system scroll bars. Used with %SBS_HORZ.\n\r\n\r%SBS_VERT\n\r\n\rMake the control a vertical scroll bar (see style&amp; above).\n\r\n\r%WS_DISABLED\n\r\n\rCreate a control that is initially disabled. A disabled control cannot receive input from the user.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group.\n\r\n\r%WS_TABSTOP\n\r\n\rAllow the scrollbar control to receive keyboard focus when the user presses the TAB and SHIFT+TAB keys. The TAB key shifts keyboard focus to the next control with the %WS_TABSTOP style, and SHIFT+TAB shifts focus to the previous control with %WS_TABSTOP.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the scroll bar control. The default extended scroll bar style comprises %WS_EX_LEFT. The default extended style is used if both the primary and extended style parameters are omitted from the CONTROL ADD SCROLLBAR statement, in the same manner as style&amp; above.\n\r\n\rThe extended scroll bar style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE non-zero) if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages automatically.\n\r\n\rRemarks\n\r\n\rIf the ampersand (&amp;) character appears in the txt$ parameter, the letter that follows will become a control accelerator (hot-key) to enable the user to directly select the scroll bar control, simply by pressing and holding the ALT key while pressing the specified hot-key. For example, &quot;&amp;9&quot; makes ALT+9 the hot-key. The actual text in txt$ is not displayed in a scroll bar control.\n\r\n\rWhen the user clicks on a scroll bar, drags the thumb (also called the scroll box), or initiates a scroll event with the keyboard, a message is sent to the Callback Function designated for the control. If there is no Callback Function designated, the message is sent to the callback for the dialog.\n\r\n\rThe following notifications are sent to the Callback Function:\n\r\n\r%WM_HSCROLL\n\r\n\rSent when the user adjusts a horizontal scroll bar.\n\r\n\r%WM_VSCROLL\n\r\n\rSent when the user adjusts a vertical scroll bar.\n\r\n\rWhen a Callback Function receives a %WM_HSCROLL or %WM_VSCROLL message, it should retrieve and set the scroll bar control settings through the GetScrollInfo API and SCROLLBAR SET POS function calls. Be sure to use the %SB_CTL flag with these API functions, rather than the %SB_HORZ or %SB_VERT flags.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL HANDLE, CONTROL SEND, CONTROL SET COLOR, SCROLLBAR","CONTROL ADD SCROLLBAR statement","scr\\html_control_add_scrollbar.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a StatusBar control to a dialog. A StatusBar is a horizontal window, typically at the bottom of a dialog client area, which displays various kinds of status information. It can be divided into parts to display multiple items.\n\r\n\rSyntax\n\r\n\rCONTROL ADD STATUSBAR, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg\n\r\n\rHandle of the dialog in which the StatusBar will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %PickList is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rtxt$\n\r\n\rText to initially display in the StatusBar control.\n\r\n\rx,y\n\r\n\rInteger expressions to specify control location. In the case of a StatusBar, location parameters are ignored since the control is placed on the top or the bottom of the dialog, based upon the chosen style. These location parameters are usually defined as 0, 0.\n\r\n\rxx,yy\n\r\n\rIntegral expressions to specify control size. In the case of a ToolBar, size parameters are ignored since the control is created with a default size. These size parameters are usually defined as 0, 0.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the StatusBar control. The default StatusBar style is %CCS_BOTTOM. This default style is used if both the primary and extended style parameters are omitted from the statement, as in the following example:\n\r\n\rCONTROL ADD STATUSBAR, hDlg, id&amp;, &quot;&quot;, 5, 5, 5, 5, , , CALL SBCallback()\n\r\n\rIf you include explicit style values, they replace the default values. That is, they are not added to the default styles values - your code must specify all necessary primary and extended style parameters.\n\r\n\r%CCS_TOP\n\r\n\rThe StatusBar is placed at the top of the dialog.\n\r\n\r%CCS_BOTTOM\n\r\n\rThe StatusBar is placed at the bottom of the dialog.\n\r\n\r%SBARS_SIZEGRIP\n\r\n\rA sizegrip is added to the StatusBar.\n\r\n\r%SBARS_TOOLTIPS\n\r\n\rUse this style to enable tooltips.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the StatusBar control. The extended StatusBar style value can be a combination of the values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback\n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification messages.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL SET FONT, STATUSBAR","CONTROL ADD STATUSBAR statement","scr\\html_control_add_statusbar_statement.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a Tab Control to a dialog. A Tab Control is analogous to the dividers in a notebook. It displays one particular page, selecting it from multiple pages, when the user chooses the corresponding tab.\n\r\n\rSyntax\n\r\n\rCONTROL ADD TAB, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg\n\r\n\rHandle of the dialog in which the Tab Control will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %PickList is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rtxt$\n\r\n\rText to associate with the Tab Control. A Tab Control does not display this text, so it is common to set this value to a null, empty string literal (&quot;&quot;).\n\r\n\rx,y\n\r\n\rInteger expressions, variables, or numeric literal values specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx,yy\n\r\n\rIntegral expressions, variable, or numeric literal values, specifying the width and height of the control. xx is the width and yy is the height, given in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the Tab control. The default Tab style is %WS_CHILD and %WS_TABSTOP. This default style is used if both the primary and extended style parameters are omitted from the statement, as in the following example:\n\r\n\rCONTROL ADD TAB, hDlg, id&amp;, &quot;&quot;,90,90,200,90, , , CALL PBCallback()\n\r\n\rIf you include explicit style values, they replace the default values. That is, they are not added to the default styles values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary style value can be a combination of the standard window values, and the values specific to a Tab Control (below), which are combined together with the OR operator to form a bitmask:\n\r\n\r%TCS_FORCEICONLEFT\n\r\n\rIcons are forced to the left\n\r\n\r%TCS_FORCELABELLEFT\n\r\n\rLabels are forced to the left\n\r\n\r%TCS_FIXEDWIDTH\n\r\n\rAll tabs are the same size\n\r\n\r%TCS_RAGGEDRIGHT\n\r\n\rTabs are not stretched\n\r\n\r%TCS_FOCUSONBUTTONDOWN\n\r\n\rTabs receive the focus when clicked\n\r\n\r%TCS_OWNERDRAWFIXED\n\r\n\rParent window is responsible for drawing tabs\n\r\n\r%TCS_TOOLTIPS\n\r\n\rA Tooltip control is associated with the control\n\r\n\r%TCS_FOCUSNEVER\n\r\n\rTab never receives the focus\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the control. The value can be a combination of the values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback\n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification messages.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL SET FONT, TAB","CONTROL ADD TAB statement","scr\\html_control_add_tab_statement.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a text box control to a dialog. A text box is very similar to a conventional edit control, and it is used to enter text into an application. Text boxes support single-line and multiple-line input.\n\r\n\rSyntax\n\r\n\rCONTROL ADD TEXTBOX, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg \n\r\n\rHandle of the dialog in which the text box will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %CustomerName is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rtxt$\n\r\n\rDefault text to be displayed in text box. txt$ may be a string, string equate, or string expression. txt$ can be empty if there is no default text.\n\r\n\rx, y\n\r\n\rInteger expressions, variables, or numeric literal values, specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the width of the control. The width is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 100 dialog units.\n\r\n\ryy \n\r\n\rIntegral expression, variable, or numeric literal value, specifying the height of the control. The height is given in the same terms (pixels or dialog units) as the parent dialog. The most common value used in the Microsoft Dialog Editor and Visual Studio is 12 dialog units.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the text box control. The default text box style comprises %WS_TABSTOP, %WS_BORDER, %ES_LEFT, and %ES_AUTOHSCROLL. The default style is used if both the primary and extended style parameters are omitted from the statement. For example:\n\r\n\rCONTROL ADD TEXTBOX, hDlg, id&amp;, txt$, 100, 100, 150, 200, , , _\n\r\n\r &nbsp;CALL EditControlCallback() \' Use default styles\n\r\n\rCustom style values replace the default values. That is, they are not additional to the default style values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary text box style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%ES_AUTOHSCROLL\n\r\n\rAutomatically scroll text to the right by 10 characters when the user types a character at the end of the line. When the user presses the ENTER key, scroll all text back to position zero.\n\r\n\r%ES_AUTOVSCROLL\n\r\n\rAutomatically scroll text up one page when the user presses the ENTER key on the last line. This must be combined with the %ES_WANTRETURN and %ES_MULTILINE styles. Also see %WS_VSCROLL.\n\r\n\r%ES_CENTER\n\r\n\rCenter text in a multi-line edit control.\n\r\n\r%ES_LEFT\n\r\n\rLeft-aligns text. (default)\n\r\n\r%ES_LOWERCASE\n\r\n\rConvert all characters to lowercase as they are typed into the edit control.\n\r\n\r%ES_MULTILINE\n\r\n\rAllow the control to accept multiple lines of input. By default, the ENTER key activates the default button on the dialog. To use the ENTER key as a carriage return in the text box control, include the %ES_WANTRETURN style.\n\r\n\rIf the %ES_AUTOHSCROLL style is included, the control automatically scrolls horizontally when the caret goes past the right edge of the control. Otherwise, the control automatically wraps words to the beginning of the next line when necessary. The control size determines the position of the word wrap.\n\r\n\r%ES_NOHIDESEL\n\r\n\rNegate the default behavior for a text box. The default behavior hides the selection when the control loses the input focus, and inverts the selection when the control receives the input focus. If you specify %ES_NOHIDESEL, the selected text is inverted, even if the control does not have the focus.\n\r\n\r%ES_NUMBER\n\r\n\rAllow only digits (&quot;0123456789&quot;) instead of characters. Although Windows does not consider the negation symbol (-) or period symbol (.) to be digits, subclassing a TextBox that does not use %ES_NUMBER and rejecting &quot;unwanted&quot; keystrokes is common practice among advanced programmers.\n\r\n\r%ES_OEMCONVERT\n\r\n\rText is converted from the windows character set to OEM, then back to Windows, as it is entered.\n\r\n\r%ES_PASSWORD\n\r\n\rDisplay an asterisk (*) for each character typed into the control in order to obscure the password.\n\r\n\r%ES_READONLY\n\r\n\rPrevent the user from typing or editing text in the control. Text can still be selected and copied from the control to the clipboard with the mouse.\n\r\n\r%ES_RIGHT\n\r\n\rRight-align text in a multi-line text box.\n\r\n\r%ES_UPPERCASE\n\r\n\rConvert all characters to uppercase as they are typed into the control.\n\r\n\r%ES_WANTRETURN\n\r\n\rAllow the ENTER key to insert a carriage return in a multi-line text box. Otherwise, the ENTER key works as the dialog box\'s default push button. This style has no effect on a single-line text box.\n\r\n\r%WS_BORDER\n\r\n\rAdd a thin line border around the text box control.\n\r\n\r%WS_HSCROLL\n\r\n\rAdd a horizontal scroll bar to the edit control, when used in conjunction to the %ES_AUTOHSCROLL style.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group.\n\r\n\r%WS_TABSTOP\n\r\n\rAllow the textbox control to receive keyboard focus when the user presses the TAB and SHIFT+TAB keys. The TAB key shifts keyboard focus to the next control with the %WS_TABSTOP style, and SHIFT+TAB shifts focus to the previous control with %WS_TABSTOP. (default)\n\r\n\r%WS_VSCROLL\n\r\n\rAdd a vertical scroll bar to the edit control. This style should be used in conjunction to the %ES_MULTILINE and %ES_AUTOVSCROLL styles.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the text box control. The default extended text box style comprises %WS_EX_CLIENTEDGE with %WS_EX_LEFT. The default extended style is used if both the primary and extended parameters are omitted from the CONTROL ADD TEXTBOX statement, in the same manner as style&amp; above.\n\r\n\rThe extended text box style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback \n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rIf you specify the %ES_AUTOHSCROLL style, the control automatically scrolls horizontally when the caret goes past the right edge of the control. To start a new line, the user must press the ENTER key.\n\r\n\rIf you do not specify %ES_AUTOHSCROLL, the control automatically wraps words to the beginning of the next line when necessary. A new line is also started if the user presses the ENTER key. The control size determines the position of the word wrap.\n\r\n\rThe following notifications are sent to the Callback Function:\n\r\n\r%EN_CHANGE\n\r\n\rSent when the user has taken an action that may have altered text in the text box. Unlike the %EN_UPDATE notification, this message is sent after Windows updates the screen. Programmatically changing the text in a control also triggers this message.\n\r\n\r%EN_ERRSPACE\n\r\n\rSent when the text box cannot allocate enough memory to meet a specific request.\n\r\n\r%EN_HSCROLL\n\r\n\rSent when the user clicks a multi-line text box\'s horizontal scroll bar. The callback is notified before the screen is updated.\n\r\n\r%EN_KILLFOCUS\n\r\n\rSent when an edit control loses the keyboard focus.\n\r\n\r%EN_MAXTEXT\n\r\n\rSent when the current text insertion has exceeded the specified number of characters for the text box. The text insertion is truncated.\n\r\n\r%EN_SETFOCUS\n\r\n\rSent when an edit control receives the keyboard focus.\n\r\n\r%EN_UPDATE\n\r\n\rSent when a text box is about to display altered text. This notification message is sent after the control has formatted the text, but before it displays the text. Also see %EN_CHANGE.\n\r\n\r%EN_VSCROLL\n\r\n\rSent when the user clicks a text box\'s vertical scroll bar. The callback is notified before the screen is updated.\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification message.\n\r\n\rUse CONTROL GET TEXT to retrieve the text from a text box control, and use CONTROL SET TEXT to change the text in a text box control. Changing the text in a text box control (in response to a %EN_CHANGE or %EN_UPDATE message) will trigger a second set of %EN_CHANGE and %EN_UPDATE messages. Unless this is compensated for, these notifications can unwittingly cause an endless loop.\n\r\n\rFor example, the following is potentially fatal:\n\r\n\rCALLBACK FUNCTION EditControlCallback()\n\r\n\r &nbsp;IF CB.CTL = %ID_EDITBOX1 AND CB.CTLMSG = %EN_CHANGE THEN\n\r\n\r &nbsp; &nbsp;CONTROL SET TEXT CB.HNDL, CB.CTL, &quot;New Text&quot;\n\r\n\r &nbsp; &nbsp;EXIT FUNCTION\n\r\n\r &nbsp;END IF\n\r\n\r &nbsp;[statements]\n\r\n\rAs CONTROL SET TEXT is a &quot;blocking&quot; statement (that is, the statement does not complete until the text has been changed), it is a simple matter to block the endless loop effect:\n\r\n\rCALLBACK FUNCTION EditControlCallback()\n\r\n\r &nbsp;STATIC EditBusy&amp;\n\r\n\r &nbsp;IF CB.CTL = %ID_EDITBOX1 AND CB.CTLMSG = %EN_CHANGE THEN\n\r\n\r &nbsp; &nbsp;IF EditBusy&amp; THEN EXIT FUNCTION\n\r\n\r &nbsp; &nbsp;EditBusy&amp; = -1\n\r\n\r &nbsp; &nbsp;CONTROL SET TEXT CB.HNDL, CB.CTL, &quot;New Text&quot;\n\r\n\r &nbsp; &nbsp;RESET EditBusy&amp;\n\r\n\r &nbsp; &nbsp;EXIT FUNCTION\n\r\n\r &nbsp;END IF\n\r\n\r &nbsp;[statements]\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET TEXT, CONTROL SET COLOR, CONTROL SET FONT, CONTROL SET TEXT","CONTROL ADD TEXTBOX statement","scr\\html_control_add_textbox.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a ToolBar control to a dialog. A ToolBar overlays part of a dialog\'s client area, typically at the top.\n\r\n\rSyntax\n\r\n\rCONTROL ADD TOOLBAR, hDlg, ID, Txt$, x, y, nWide, nHigh [,style] [,exstyle&amp;] [,CALL callback]\n\r\n\rhDlg\n\r\n\rHandle of the dialog in which the ToolBar will be created. The dialog will become the parent of the control.\n\r\n\rID\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %PickList is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rTxt$\n\r\n\rText to associate with the ToolBar control. A ToolBar control does not display this text, so it is common to set this value to a null, empty string literal (&quot;&quot; or $NUL).\n\r\n\rx,y\n\r\n\rIntegral expressions which specify the location of the control within the dialog client area. In the case of a ToolBar, size parameters are ignored since the control is created with a default position. These size parameters are usually omitted.\n\r\n\rnWide, nHigh\n\r\n\rIntegral expressions which specify the overall width and height of the control. In the case of a ToolBar, size parameters are ignored since the control is created with a default size. These size parameters are usually omitted.\n\r\n\rstyle\n\r\n\rOptional primary style of the ToolBar control. The default ToolBar style is %WS_CHILD or %WS_VISIBLE or %WS_BORDER or %CCS_TOP or %TBSTYLE_FLAT. This default style is used if both the primary and extended style parameters are omitted from the statement, as in the following example:\n\r\n\rCONTROL ADD TOOLBAR, hDlg, id&amp;, &quot;&quot;, 1, 1, 1, 1, , , CALL TBCallback()\n\r\n\rIf you include explicit style values, they replace the default values. That is, they are not added to the default styles values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary ToolBar style value can be a combination of the values below, combined together with the OR operator to form a bitmask:\n\r\n\r%CCS_TOP\n\r\n\rThe ToolBar is placed at the top of the dialog.\n\r\n\r%CCS_BOTTOM\n\r\n\rThe ToolBar is placed at the bottom of the dialog.\n\r\n\rexstyle&amp;\n\r\n\rOptional extended style of the ToolBar control. The extended ToolBar style value can be a combination of the values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback\n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. Generally speaking, ToolBar command messages result from clicking a ToolBar Button, so the message is sent to the callback specified in TOOLBAR ADD BUTTON or the dialog callback specified in DIALOG SHOW. Message routing by button allows you to easily determine which button generated the event, and eliminates virtually all %WM_COMMAND messages here. This callback is primarily used to process %WM_NOTIFY messages.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rWhen a Callback Function receives a message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the notification messages.\n\r\n\rSee also\n\r\n\rDIALOG SHOW MODAL, DIALOG SHOW MODELESS, Dynamic Dialog Tools, CONTROL SET FONT, TOOLBAR","CONTROL ADD TOOLBAR statement","scr\\html_control_add_toolbar_statement.htm","                  \n\r\n\rPurpose\n\r\n\rAdd a TreeView control to a dialog. A TreeView displays a set of string data items with a parent-child relationship between the items. This creates a hierarchical list of data which can have any number of levels. The user may view the items, selecting them for use in the program at a later time.\n\r\n\rSyntax\n\r\n\rCONTROL ADD TREEVIEW, hDlg, id&amp;, txt$, x, y, xx, yy [, [style&amp;] [, [exstyle&amp;]]] [[,] CALL callback]\n\r\n\rhDlg\n\r\n\rHandle of the dialog in which the TreeView will be created. The dialog will become the parent of the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control in the range 1 to 65535, frequently specified with numeric equates for clarity of the code. For example, the equate %PickList is more informative than a literal value such as 497. Best practice suggests identifiers should start at 100 to avoid conflict with any of the standard predefined identifiers.\n\r\n\rtxt$\n\r\n\rText to associate with the TreeView control. A TreeView control does not display this text, so it is common to set this value to a null, empty string literal (&quot;&quot;).\n\r\n\rx,y\n\r\n\rInteger expressions, variables, or numeric literal values specifying the location of the control inside the dialog client area. x is the horizontal position, and y is the vertical position. 0,0 refers to the upper left corner of the dialog box client area. Coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rxx,yy\n\r\n\rIntegral expressions, variable, or numeric literal values, specifying the width and height of the control. xx is the width and yy is the height, given in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rstyle&amp;\n\r\n\rPrimary style of the TreeView control. The default TreeView style comprises %WS_TABSTOP, %TVS_HASBUTTONS, %TVS_LINESATROOT, %TVS_HASLINES, and %TVS_SHOWSELALWAYS. This default TreeView style is used if the style parameters are omitted from the statement, as in the following example:\n\r\n\rCONTROL ADD TREEVIEW, hDlg, id&amp;, &quot;&quot;, 100, 100, 150, 200, , , CALL TVCallback()\n\r\n\rIf you include explicit style values, they replace the default values. That is, they are not added to the default styles values - your code must specify all necessary primary and extended style parameters.\n\r\n\rThe primary TreeView style value can be a combination of the values below, combined together with the OR operator to form a bitmask:\n\r\n\r%TVS_HASBUTTONS\n\r\n\rDisplays +- signs next to parent items so the user can expand or collapse a list of child items.\n\r\n\r%TVS_HASLINES\n\r\n\rUses lines to show the hierarchy of data items.\n\r\n\r%TVS_LINESATROOT\n\r\n\rUses lines to link items at the root level.\n\r\n\r%TVS_EDITLABELS\n\r\n\rAllows the user to edit the labels of the data items.\n\r\n\r%TVS_DISABLEDRAGDROP\n\r\n\rPrevents drag and drop\n\r\n\r%TVS_SHOWSELALWAYS\n\r\n\rA selected item remains selected when the control loses focus.\n\r\n\r%TVS_NOTOOLTIPS\n\r\n\rDisables ToolTips.\n\r\n\r%TVS_CHECKBOXES\n\r\n\rEnables check boxes for items with an image.\n\r\n\r%TVS_TRACKSELECT\n\r\n\rEnables hot tracking.\n\r\n\r%TVS_SINGLEEXPAND\n\r\n\rOnly one item can be expanded at a time.\n\r\n\r%TVS_INFOTIP\n\r\n\rObtains ToolTip information.\n\r\n\r%TVS_FULLROWSELECT\n\r\n\rThe entire row of a selected item is highlighted.\n\r\n\r%TVS_NOSCROLL\n\r\n\rDisables horizontal and vertical scrolling.\n\r\n\r%TVS_NONEVENHEIGHT\n\r\n\rSets the height of items to an odd height.\n\r\n\r%TVS_NOHSCROLL\n\r\n\rDisables horizontal scrolling.\n\r\n\r%WS_DISABLED\n\r\n\rCreate a control that is initially disabled. A disabled control cannot receive input from the user.\n\r\n\r%WS_GROUP\n\r\n\rDefine the start of a group of controls. The first &nbsp;control in each group should also use %WS_TABSTOP style. The next %WS_GROUP control in the tab order defines the end of this group and the start of a new group.\n\r\n\r%WS_TABSTOP\n\r\n\rAllow the control to receive keyboard focus when the user presses the TAB and SHIFT+TAB keys. The TAB key shifts keyboard focus to the next control with the %WS_TABSTOP style, and SHIFT+TAB shifts focus to the previous control with %WS_TABSTOP.\n\r\n\rexstyle&amp;\n\r\n\rExtended style of the TreeView control. The default extended style is %WS_EX_LEFT. The default extended style is used if both the primary and extended parameters are omitted from the CONTROL ADD TREEVIEW statement, in the same manner as style&amp; above.\n\r\n\rThe extended TreeView style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rApply a sunken edge border to the control.\n\r\n\r%WS_EX_LEFT\n\r\n\rThe control has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_RIGHT\n\r\n\rThe control has generic &quot;right-aligned&quot; properties. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment; otherwise, the style is ignored.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rApply a three-dimensional border style to the control (intended to be used for items that do not accept user input).\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the control are drawn before the control is drawn. The control is deemed transparent because elements behind the control have already been painted - the control itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rApply a raised edge border to the control.\n\r\n\rcallback\n\r\n\rOptional name of a Callback Function that receives all %WM_COMMAND and %WM_NOTIFY messages for the control. See the #MESSAGES metastatement to choose which messages will be received. If a callback for the control is not designated, you must create a dialog Callback Function to process messages from your control.\n\r\n\rIf the Callback Function processes a message, it should return TRUE (non-zero) to prevent the message being passed unnecessarily to the dialog callback (if one exists). The dialog callback should also return TRUE if the notification message is processed by that Callback Function. Otherwise, the DDT engine processes unhandled messages.\n\r\n\rRemarks\n\r\n\rWhen a Callback Function receives a %WM_COMMAND message, it should explicitly test the value of CB.CTL and CB.CTLMSG to guarantee it is responding appropriately to the messages.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL SET COLOR, CONTROL SET FONT, TREEVIEW","CONTROL ADD TREEVIEW statement","scr\\html_control_add_treeview_statement.htm","                  \n\r\n\rPurpose\n\r\n\rDisable a control so that it no longer receives any messages or accepts user interaction.\n\r\n\rSyntax\n\r\n\rCONTROL DISABLE hDlg, id&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control. id&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rA disabled control will not receive any messages when clicked with the mouse or selected with the keyboard. Most, but not all, controls will redraw themselves as &quot;gray&quot; when disabled.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ENABLE, CONTROL KILL","CONTROL DISABLE statement","scr\\html_control_disable.htm","                  \n\r\n\rPurpose\n\r\n\rEnable a control so that it can receive messages when the user interacts with it via the mouse or keyboard.\n\r\n\rSyntax\n\r\n\rCONTROL ENABLE hDlg, id&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control. id&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rAn enabled control will receive messages when clicked with the mouse or selected with the keyboard.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL DISABLE, CONTROL KILL","CONTROL ENABLE statement","scr\\html_control_enable.htm","                  \n\r\n\rPurpose\n\r\n\rGet the Check State of a CHECK3STATE, CHECKBOX, or OPTION button.\n\r\n\rSyntax\n\r\n\rCONTROL GET CHECK hDlg, id&amp; TO lResult&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rlResult&amp; receives the Check State of the control as follows:\n\r\n\rlResult&amp;\n\r\n\rCheck State of control\n\r\n\r0 (Zero)\n\r\n\rButton is unchecked (unset, or cleared)\n\r\n\r1 (One)\n\r\n\rButton is checked (set)\n\r\n\r2 (Two)\n\r\n\rButton is indeterminate (grayed) (CHECK3STATE only)\n\r\n\rNote that a grayed (indeterminate) CHECK3STATE control does not mean the control is disabled. Rather, the Check State of the control is both checked and unchecked.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD CHECK3STATE, CONTROL ADD CHECKBOX, CONTROL ADD OPTION, CONTROL SET CHECK, CONTROL SET OPTION, TREEVIEW GET CHECK, TREEVIEW SET CHECK","CONTROL GET CHECK statement","scr\\html_control_get_check.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the client size of the specified child control.\n\r\n\rSyntax\n\r\n\rCONTROL GET CLIENT hDlg, id&amp; TO w&amp;, h&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rThe size of the control client area is placed in the w&amp; (width) and h&amp; (height) variables. The size is specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET LOC, CONTROL GET SIZE, CONTROL SET CLIENT, CONTROL SET CLIENT, CONTROL SET LOC, CONTROL SET SIZE, DIALOG UNITS, DIALOG PIXELS, GRAPHIC GET CLIENT","CONTROL GET CLIENT statement","scr\\html_control_get_client.htm","                  \n\r\n\rPurpose\n\r\n\rGet the location of the specified control in a dialog.\n\r\n\rSyntax\n\r\n\rCONTROL GET LOC hDlg, id&amp; TO x&amp;, y&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rThe location of the top left corner of the control is placed in the x&amp; (horizontal location) and y&amp; (vertical location) variables. The location is relative to the upper-left corner of the client area in the parent dialog. The coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET CLIENT, CONTROL GET SIZE, CONTROL SET LOC, CONTROL SET SIZE","CONTROL GET LOC statement","scr\\html_control_get_loc.htm","                  \n\r\n\rPurpose\n\r\n\rGet the size of a control in the specified dialog.\n\r\n\rSyntax\n\r\n\rCONTROL GET SIZE hDlg, id&amp; TO nWide&amp;, nHigh&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rThe width is placed in the nWide&amp; and the height is placed in nHigh&amp; variables. The coordinates are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET CLIENT, CONTROL GET LOC, CONTROL SET LOC, CONTROL SET SIZE","CONTROL GET SIZE statement","scr\\html_control_get_size.htm","                  \n\r\n\rPurpose\n\r\n\rGet the text from a control.\n\r\n\rSyntax\n\r\n\rCONTROL GET TEXT hDlg, id&amp; TO txt$\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement. Any text in the control is placed into the txt$ variable.\n\r\n\rWith combo boxes, CONTROL GET TEXT returns the text entered in the edit portion of the control. To retrieve the selected text from the list portion of a combo box or a list box control, use the COMBOBOX GET TEXT statement or LISTBOX GET TEXT statement respectively.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, COMBOBOX GET TEXT, CONTROL SET TEXT, LISTBOX GET TEXT, LISTVIEW GET TEXT, TREEVIEW GET TEXT","CONTROL GET TEXT statement","scr\\html_control_get_text.htm","                  \n\r\n\rPurpose\n\r\n\rRetrieve a value from the user data area of a DDT control.\n\r\n\rSyntax\n\r\n\rCONTROL GET USER hDlg, id&amp;, index&amp; TO retvar&amp;\n\r\n\rRemarks\n\r\n\rEach DDT control has a user data area consisting of eight Long-integer values which may be used at the programmer\'s discretion to save relevant data. CONTROL GET USER allows one of the values to be retrieved, based upon the index parameter value (1 through 8).\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rindex&amp; is the index number of the user data value to retrieve, in the range 1 to 8 inclusive.\n\r\n\rretvar&amp; receives the Long-integer data value store in the nominated user data index.\n\r\n\rRestrictions \n\r\n\rData in the user data area is lost when the control is destroyed. The data area is completely separate from the %GWL_USERDATA area maintained by Windows.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, COMBOBOX GET USER, COMBOBOX SET USER, CONTROL SET USER, DIALOG GET USER, DIALOG SET USER, LISTBOX GET USER, LISTBOX SET USER, LISTVIEW GET USER, LISTVIEW SET USER, TREEVIEW GET USER, TREEVIEW SET USER","CONTROL GET USER statement","scr\\html_control_get_user.htm","                  \n\r\n\rPurpose\n\r\n\rReturn a window handle for the specified control ID.\n\r\n\rSyntax\n\r\n\rCONTROL HANDLE hDlg, id&amp; TO hCtl&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control. id&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rThe returned value is a window handle for the control, assigned by Windows when the control was initially created, uniquely identifying the control from all other controls. Some API functions require a window handle value rather than a control ID value.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL SEND, WINDOW GET ID, WINDOW GET PARENT","CONTROL HANDLE statement","scr\\html_control_handle.htm","                  \n\r\n\rPurpose\n\r\n\rMake a control invisible.\n\r\n\rSyntax\n\r\n\rCONTROL HIDE HDlg, ID&amp;\n\r\n\rRemarks\n\r\n\rThe Control identified by the HDlg/ID&amp; combination is made invisible.\n\r\n\rHDlg is the handle of the dialog which owns the control. ID&amp; is the unique control identifier assigned to the control with CONTROL ADD.\n\r\n\rSee Also\n\r\n\rCONTROL NORMALIZE, CONTROL SET SIZE, DIALOG HIDE, DIALOG NORMALIZE","CONTROL HIDE statement","scr\\html_control_hide_statement.htm","                  \n\r\n\rPurpose\n\r\n\rRemove a control from a dialog.\n\r\n\rSyntax\n\r\n\rCONTROL KILL hDlg, id&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control. id&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rThe control is destroyed and removed from the dialog. The Callback Function for the control or dialog will no longer receive messages for the control.\n\r\n\rRestrictions \n\r\n\rA control should not be destroyed while processing a notification message from the same control, but it is permissible to kill a different control in the notification handler. If is absolutely necessary to kill a control while processing one of its notification messages, use the PostMessage API function (or the DIALOG POST or CONTROL POST statements) to post a user-defined message to the dialog callback, and kill the control when processing the user-defined message.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL DISABLE, CONTROL ENABLE\n\r\n\rExample\n\r\n\r\' How to avoid &quot;suicide&quot; conditions\n\r\n\rCALLBACK FUNCTION DlgCallBack() AS LONG\n\r\n\r &nbsp;SELECT CASE CB.MSG\n\r\n\r &nbsp; &nbsp;CASE %WM_COMMAND\n\r\n\r &nbsp; &nbsp; &nbsp;IF CB.CTLMSG = %BN_CLICKED AND CB.CTL = %MyBtn THEN\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;DIALOG POST CB.HNDL, %WM_USER + 999&amp;, 0, 0\n\r\n\r &nbsp; &nbsp; &nbsp;END IF\n\r\n\r &nbsp; &nbsp;CASE %WM_USER + 999&amp;\n\r\n\r &nbsp; &nbsp; &nbsp;CONTROL KILL CB.HNDL, %MyBtn\n\r\n\r &nbsp; &nbsp; &nbsp;FUNCTION = 1\n\r\n\r &nbsp;END SELECT\n\r\n\rEND FUNCTION","CONTROL KILL statement","scr\\html_control_kill.htm","                  \n\r\n\rPurpose\n\r\n\rMake a control visible.\n\r\n\rSyntax\n\r\n\rCONTROL NORMALIZE HDlg, ID&amp;\n\r\n\rRemarks\n\r\n\rThe Control identified by the HDlg/ID&amp; combination is made visible.\n\r\n\rHDlg is the handle of the dialog which owns the control. ID&amp; is the unique control identifier assigned to the control with CONTROL ADD.\n\r\n\rSee also\n\r\n\rCONTROL HIDE, CONTROL SET SIZE, DIALOG HIDE, DIALOG NORMALIZE","CONTROL NORMALIZE statement","scr\\html_control_normalize_statement.htm","                  \n\r\n\rPurpose\n\r\n\rPlace a message in the message queue to be processed at the leisure of the target control.\n\r\n\rSyntax\n\r\n\rCONTROL POST hDlg, id&amp;, Msg&amp;, wParam&amp;, lParam&amp;\n\r\n\rRemarks\n\r\n\rCONTROL POST places the message in the message queue and returns immediately. The message is processed by the control at a later time, when it reads the message from the queue.\n\r\n\rThis behavior is quite different to the CONTROL SEND statement, which forces the control to process the message immediately before returning. Since CONTROL POST is an asynchronous operation, it is not possible to retrieve a return code from the message.\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rMsg&amp; is the message you want to post to the control.\n\r\n\rwParam&amp; is the first message parameter. lParam&amp; is the second message parameter. The values of wParam&amp; and lParam&amp; are message-dependent. By Default, PowerBASIC passes these parameters BYVAL. If the target control is expected to alter the values held by variables passed in the wParam&amp; and lParam&amp; parameters, pass them using VARPTR() or the changes will likely be discarded.\n\r\n\rNote that the address of the data must remain valid until after the control has processed the message and accessed the data. In this case, using STATIC or GLOBAL variables can be very important or a General Protection Fault (GPF) may occur (that is, if the variables have gone out of scope by the time the message is processed).\n\r\n\rAn example of posting the addresses of variables to a control:\n\r\n\r\' Retrieve an Edit controls Current Selection\n\r\n\r\' Sel1&amp; and Sel2&amp; must be STATIC or GLOBAL\n\r\n\rCONTROL POST CB.HNDL, %ID_EDIT6, %EM_GETSEL, VARPTR(Sel1&amp;), VARPTR(Sel2&amp;)\n\r\n\rCONTROL POST returns immediately after the placing the message in the queue.\n\r\n\rRestrictions\n\r\n\rTo post a custom message to a control, use a message value in the range of (%WM_USER + 500) to (%WM_USER + &amp;H07FFF), or use the RegisterWindowMessage API to obtain a unique message value from the operating system. Using messages with a numeric value of less then %WM_USER + 500 may conflict with Windows Common Control messages.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL HANDLE, CONTROL SEND, DIALOG POST, DIALOG SEND\n\r\n\rExample\n\r\n\r\' Programmatically post a click message to a button:\n\r\n\rCONTROL POST hDlg, %ID_BTN1, %BM_CLICK, 0, 0","CONTROL POST statement","scr\\html_control_post.htm","                  \n\r\n\rPurpose\n\r\n\rSchedule a designated control to be redrawn.\n\r\n\rSyntax\n\r\n\rCONTROL REDRAW hDlg, id&amp;\n\r\n\rRemarks\n\r\n\rCONTROL REDRAW invalidates the target control and schedules a redraw event to occur.\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rRestrictions \n\r\n\rRedrawing of individual controls is considered a low priority event, and a control redraw may not happen instantly if there are pending messages in the message queue. That is, pending messages in the message queue may need to be processed before the scheduled redraw event occurs.\n\r\n\rIt is not advisable to use CONTROL REDRAW or DIALOG REDRAW within the %WM_PAINT and associated message handling code, or an infinite redraw loop could occur.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL SET COLOR, DIALOG SET COLOR, DIALOG REDRAW\n\r\n\rExample\n\r\n\rCONTROL REDRAW hDlg, %ID_LABEL1","CONTROL REDRAW statement","scr\\html_control_redraw.htm","                  \n\r\n\rPurpose\n\r\n\rSend a message to a control.\n\r\n\rSyntax\n\r\n\rCONTROL SEND hDlg, id&amp;, Msg&amp;, wParam&amp;, lParam&amp; [TO lResult&amp;]\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rMsg&amp; is the message you want to send the control.\n\r\n\rwParam&amp; is the first message parameter. lParam&amp; is the second message parameter. The values of wParam&amp; and lParam&amp; are message-dependent. By default, PowerBASIC passes these parameters BYVAL. If the target control is expected to return or alter the values passed in the wParam&amp; and lParam&amp; parameters, pass them using VARPTR or the return values will be discarded. For example:\n\r\n\r\' Retrieve an Edit control\'s Current Selection\n\r\n\rCONTROL SEND CB.HNDL, %ID_EDIT1, %EM_GETSEL, VARPTR(Sel1&amp;), VARPTR(Sel2&amp;)\n\r\n\rCONTROL SEND does not return from execution until the control\'s callback has processed the message. This synchronous behavior is quite different to the behavior of CONTROL POST, which simply places the message in the control\'s message queue (for processing at a later time) and immediately returns. On this basis, CONTROL SEND can receive a return value from the message, but CONTROL POST cannot.\n\r\n\rTO \n\r\n\rThe return value from the message can optionally be assigned to lResult&amp;.\n\r\n\rIf CONTROL SEND sends a message that arrives back in the same callback as the message originated, care should be exercised to ensure that critical STATIC and GLOBAL variables are not unexpectedly altered by the second message processing code in the callback. This is known as re-entrant code design.\n\r\n\rRestrictions \n\r\n\rTo send a custom message to a dialog, use a message value in the range of (%WM_USER + 500) to (%WM_USER + &amp;H07FFF), or use the RegisterWindowMessage API to obtain a unique message value from the operating system. Using messages with a numeric value of less then %WM_USER + 500 may conflict with Windows Common Control messages.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL HANDLE, CONTROL POST, DIALOG POST, DIALOG SEND\n\r\n\rExample\n\r\n\r\' Programmatically click a button:\n\r\n\rCONTROL SEND hDlg, %ID_BTN1, %BM_CLICK, 0, 0","CONTROL SEND statement","scr\\html_control_send.htm","                  \n\r\n\rPurpose\n\r\n\rSet the Check State for a CHECK3STATE or CHECKBOX control.\n\r\n\rSyntax\n\r\n\rCONTROL SET CHECK hDlg, id&amp;, checkstate&amp;\n\r\n\rRemarks\n\r\n\rWith a checkbox control, the Check State is set (checked) when an \'X\' symbol is shown in the check box. The Check State is deemed unset (unchecked or cleared) when the check box is empty.\n\r\n\rA CHECK3STATE control supports a third state, known as indeterminate. In this state, the check box is grayed.\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the button control with a CONTROL ADD  statement.\n\r\n\rFor CHECKBOX controls, set checkstate&amp; to zero (0) to uncheck (unset or clear) the Check State of the control, or one (1) to check (set) the Check State of the control.\n\r\n\rFor CHECK3STATE controls, set checkstate&amp; to zero (0) to uncheck (unset or clear) the Check State of the control, one (1) to check (set) the Check State (display an \'X\' symbol in the box), or two (2) to set the indeterminate state (display a grayed check box).\n\r\n\rTo set the Check State of OPTION controls, use the CONTROL SET OPTION statement.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD CHECK3STATE, CONTROL ADD CHECKBOX, CONTROL ADD OPTION, CONTROL GET CHECK, CONTROL SET OPTION, TREEVIEW GET CHECK, TREEVIEW SET CHECK","CONTROL SET CHECK statement","scr\\html_control_set_check.htm","                  \n\r\n\rPurpose\n\r\n\rChange the size of a control to a specific client area size.\n\r\n\rSyntax\n\r\n\rCONTROL SET CLIENT hDlg, id&amp;, nWide&amp;, nHigh&amp;\n\r\n\rRemarks\n\r\n\rClient size may be smaller than total size, depending on the type of borders used. The client area is the part inside the borders of a control, which varies depending upon the style and exstyle at creation. In a control without borders, the client size and total size is the same. As an alternate example, a control with the %WS_BORDER style will typically have a client area a few pixels smaller than the total size.\n\r\n\rhDlg\n\r\n\rHandle of the dialog that owns the control.\n\r\n\rid&amp;\n\r\n\rThe unique control identifier, assigned to the control with the CONTROL ADD statement.\n\r\n\rnWide&amp;, nHigh&amp;\n\r\n\rIntegral expressions, variables, or numeric literal values, specifying the desired size of the client area. Width and height are specified in pixels or dialog units, depending upon the system used when the parent dialog was created.\n\r\n\rGraphic Controls\n\r\n\rBeginning with this version of PowerBASIC, GRAPHIC CONTROLS may be resized with CONTROL SET CLIENT, GRAPHIC SET CLIENT, CONTROL SET SIZE, and GRAPHIC SET SIZE.\n\r\n\rWhen you change the size of a graphic control, the original bitmap is copied, pixel for pixel, to the newly resized control. Any expanded area is filled with the current background color. Your program draws to it in the normal fashion for a bitmap of the new size.\n\r\n\rIf a clip area had been established to create margins, it is reset. If scaled coordinates had been established, they are also reset, as neither would be appropriate for the altered size. You can enable these attributes again with GRAPHIC SCALE or GRAPHIC SET CLIP, based upon the new size of the drawing area.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET CLIENT, CONTROL GET LOC, CONTROL GET SIZE, CONTROL SET LOC, CONTROL SET SIZE, GRAPHIC SET CLIENT, GRAPHIC SET SIZE","CONTROL SET CLIENT statement","scr\\html_control_set_client.htm","                  \n\r\n\rPurpose\n\r\n\rSet the color of a control to a specific RGB foreground and background color.\n\r\n\rSyntax\n\r\n\rCONTROL SET COLOR hDlg, id&amp;, foreclr&amp;, backclr&amp;\n\r\n\rRemarks\n\r\n\rhDlg identifies the controls parent dialog, and id&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rColor values of foreclr&amp; and backclr&amp; must be in the range of &amp;H0 to &amp;H00FFFFFF. RGB can be a useful function to derive a 32-bit color value from discrete Red, Green and Blue values:\n\r\n\rforeclr&amp;\n\r\n\r The foreground color parameter foreclr&amp; is used to set the color of the text displayed in the control. If foreclr&amp; = -1&amp;, the default foreground text color is used.\n\r\n\rbackclr&amp;\n\r\n\rThe backclr&amp; parameter specifies the color of the background behind the text in the control. If backclr&amp; = -1&amp;, the default background text color is used. If backclr&amp; = -2&amp;, the text background is not painted, allowing the background to show &quot;through&quot; the text. The non-visible background style may produce undesirable side effects with some controls. For example, on a FRAME control, the caption text will appear superimposed over an unbroken frame.\n\r\n\rIn 16-bit or greater color-depth mode, the specified RGB color is used when the background of the control is drawn. However, in 8-bit (256-color) mode, the color system works quite differently. Behind the scenes in Windows, the base system palette usually contains 20 solid colors that are not dithered when drawn on the controls background. These solid-colors are ideal for control background colors with DDT dialogs in 256-color mode.\n\r\n\rConversely, when using a non-solid RGB color value, Windows will dither (approximate) the color to draw the control, using combinations of two or more colors. This usually produces an undesirable pattern effect.\n\r\n\rTo avoid these problems when in 256-color mode, controls should be colored with one of the 20 standard (solid) system colors, or the default color should be used instead. PowerBASIC includes the following 10 built-in equates for help with the selection of a standard solid color:\n\r\n\r%RGB_BLACK %RGB_BLUE %RGB_GREEN %RGB_CYAN %RGB_RED\n\r\n\r%RGB_MAGENTA %RGB_YELLOW %RGB_WHITE %RGB_GRAY %RGB_LIGHTGRAY\n\r\n\rMany non standard colors are also built into the compiler, see the Built In RGB Color Equates topic for a complete list.\n\r\n\rIf you prefer to disable color in 256-color mode, the number of colors can be easily tested with the following code:\n\r\n\r\' Determine number of colors\n\r\n\rLOCAL hDC AS DWORD, iColors AS LONG\n\r\n\r&nbsp;\n\r\n\rhDC = GetWindowDC(GetDeskTopWindow())\n\r\n\riColors = 2&amp; ^ (GetDeviceCaps(hDC, %BITSPIXEL) * GetDeviceCaps(hDC, %PLANES))\n\r\n\rReleaseDC GetDeskTopWindow(), hDC\n\r\n\rIF iColors &gt; 256 THEN _\n\r\n\r &nbsp;CONTROL SET COLOR hDlg, idctl&amp;, -1, RGB(0,255,100)\n\r\n\rIn 256-color mode on most computers, the values of the standard 20 system colors can be found by requesting the first and last 10 (0 to 9, and 246 to 255 inclusive) entries from the GetSystemPaletteEntries API function, as follows:\n\r\n\r\' Fill array with solid colors\n\r\n\rDIM hDC AS DWORD, Cols AS LONG, x AS LONG\n\r\n\r&nbsp;\n\r\n\rhDC = GetWindowDC(GetDesktopWindow)\n\r\n\rCols = GetDeviceCaps(hDC, %NUMRESERVED)\n\r\n\rREDIM lp(1 TO Cols) AS LONG\n\r\n\rx&amp; = GetSystemPaletteEntries(hDC, 0, Cols \\ 2, BYVAL VARPTR(lp(1)))\n\r\n\rx&amp; = GetSystemPaletteEntries(hDC, 256 - x&amp;, Cols - x&amp;, BYVAL VARPTR(lp(x&amp; + 1)))\n\r\n\rReleaseDC GetDesktopWindow, hDC\n\r\n\r\' Array lp() now contains the solid color table\n\r\n\rFor more information on working with palettes in 256-color mode, please consult WIN32.HLP or visit http://msdn.microsoft.com.\n\r\n\rRestrictions \n\r\n\rWindows does not permit the color of standard push button controls, line controls, image controls, image buttons, and most common controls to be altered by the standard CONTROL SET COLOR techniques.\n\r\n\rTo create a colored push button or colored region on a dialog, the preferred solution is to use an IMGBUTTON/IMAGEBUTTONX or IMAGE/IMAGEX control, with a suitably colored bitmap. Some common controls offer specific ways to set their color. For example, the background color of a List View control can be set with the %LVM_SETBKCOLOR message.\n\r\n\rWhen dynamically changing colors of a control from within a callback (i.e., after the DIALOG SHOW statement), a CONTROL SET COLOR statement should be immediately followed by an explicit CONTROL REDRAW statement.\n\r\n\rWithout this forced control redraw, the control background color change may not become evident to the user until the control is eventually repainted in the normal course of user interaction. For example, a normal repaint may only occur if the control becomes obscured and then uncovered by another window. Ensuring a timely repaint of the control will guarantee the control maintains an up-to-date appearance at all times.\n\r\n\rWhen updating the colors of multiple controls at the same time, a DIALOG REDRAW is usually more efficient than multiple CONTROL REDRAW statements.\n\r\n\rSee also\n\r\n\rBuilt In RGB Color Equates, Dynamic Dialog Tools, CONTROL GET CLIENT, CONTROL GET SIZE, CONTROL REDRAW, CONTROL SET FONT, DIALOG REDRAW, DIALOG SET COLOR\n\r\n\rExample\n\r\n\r\' Set the color with discrete RGB values\n\r\n\rCONTROL SET COLOR hDlg, idBtn&amp;, RGB(255,255,255), RGB(0,0,255)\n\r\n\r&nbsp;\n\r\n\r\' Or we could use the built-in equates:\n\r\n\rCONTROL SET COLOR hDlg, idBtn&amp;, %RGB_WHITE, %RGB_BLUE","CONTROL SET COLOR statement","scr\\html_control_set_color.htm","                  \n\r\n\rPurpose\n\r\n\rSet the keyboard focus to the specified control.\n\r\n\rSyntax\n\r\n\rCONTROL SET FOCUS hDlg, id&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rThe control that owns the focus will receive all keyboard messages. Many controls change their appearance when they receive (and lose) keyboard focus, usually by the display of a &quot;focus rectangle&quot; around or on the control that has keyboard focus. Only one control can have keyboard focus at any moment, and situations can arise where no controls have focus.\n\r\n\rControls that include a &quot;notify&quot; style (i.e., %BS_NOTIFY) will receive a notification message when focus is gained or lost. That is, when one such control loses focus, it receives a message to that effect and the control gaining focus may also receive an appropriate focus notification message.\n\r\n\rWhen a control gains focus the parent dialog will also be set as the foreground window.\n\r\n\rWindows does not guarantee the order in which focus notification messages are dispatched to the control losing focus and the control gaining focus. Applications should not rely on the order in which these types of messages are received.\n\r\n\rRestrictions \n\r\n\rCONTROL SET FOCUS cannot be used to set the focus of a control in a separate thread.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools","CONTROL SET FOCUS statement","scr\\html_control_set_focus.htm","                  \n\r\n\rPurpose\n\r\n\rSelect a font to be used for a particular Windows Control.\n\r\n\rSyntax\n\r\n\rCONTROL SET FONT hDlg, id&amp;, FontHndl&amp;\n\r\n\rhDlg\n\r\n\rHandle of the dialog in which owns the control.\n\r\n\rid&amp;\n\r\n\rUnique identifier for the control which was assigned with a CONTROL ADD statement.\n\r\n\rFontHndl&amp;\n\r\n\rThe numeric handle returned by the FONT NEW statement when the font was created.\n\r\n\rRemarks\n\r\n\rThe font specified by FontHndl&amp; is selected to be used by this particular control, until or unless it is changed with another CONTROL SET FONT statement. If you specify a FontHndl&amp; of zero, the font is changed back to the original default font chosen by PowerBASIC.\n\r\n\rYou can predefine virtually any number of fonts and attributes by executing FONT NEW statements for each of them. That makes them ready for immediate use when selected by CONTROL SET FONT, GRAPHIC SET FONT, and XPRINT SET FONT.\n\r\n\rSee also\n\r\n\rDIALOG DEFAULT FONT, FONT END, FONT NEW, GRAPHIC SET FONT, XPRINT SET FONT","CONTROL SET FONT statement","scr\\html_control_set_font_statement_.htm","                  \n\r\n\rPurpose\n\r\n\rChange the icon or bitmap displayed in an IMAGE control. The new image is not re-sized to fit the size of the control.\n\r\n\rSyntax\n\r\n\rCONTROL SET IMAGE hDlg, id&amp;, newimage$\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with the CONTROL ADD IMAGE statement.\n\r\n\rnewimage$ specifies the name of the bitmap or icon in the resource file. If the image resource uses an integral identifier, newimage$ should begin with a Number symbol (#), followed by the integer identifier in ASCII format. For example, &quot;#998&quot;. Otherwise, the text identifier name should be used.\n\r\n\rRestrictions \n\r\n\rImages can only be exchanged with images of the same type. That is, if the control is displaying a bitmap then the replacement image must also be a bitmap. If the control is displaying an icon, the replacement image must also be an icon. For best results, icons should be 32x32 pixels.\n\r\n\rWhen an image is changed, CONTROL SET IMAGE automatically releases the old image from memory. Previous versions of PowerBASIC placed the onus on the programmer to release the old image handle.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD GRAPHIC, CONTROL ADD IMAGE, CONTROL ADD IMAGEX, CONTROL ADD IMGBUTTON, CONTROL ADD IMGBUTTONX, CONTROL GET CLIENT, CONTROL GET SIZE, CONTROL SET IMAGEX, CONTROL SET IMGBUTTON, CONTROL SET IMGBUTTONX","CONTROL SET IMAGE statement","scr\\html_control_set_image.htm","                  \n\r\n\rPurpose\n\r\n\rChange the icon or bitmap displayed in an IMAGEX control. The new image is re-sized to fit the size of the control.\n\r\n\rSyntax\n\r\n\rCONTROL SET IMAGEX hDlg, id&amp;, newimage$\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with the CONTROL ADD IMAGEX statement.\n\r\n\rnewimage$ specifies the name of the bitmap or icon in the resource file. If the image resource uses an integral identifier, newimage$ should begin with a Number symbol (#), followed by the integer identifier in ASCII format. For example, &quot;#998&quot;. Otherwise, the text identifier name should be used.\n\r\n\rRestrictions \n\r\n\rImages can only be exchanged with images of the same type. That is, if the control is displaying a bitmap then the replacement image must also be a bitmap. If the control is displaying an icon, the replacement image must also be an icon. For best results, icons should be 32x32 pixels.\n\r\n\rWhen an image is changed, CONTROL SET IMAGEX automatically releases the old image from memory. Previous versions of PowerBASIC placed the onus on the programmer to release the old image handle.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD GRAPHIC, CONTROL ADD IMAGE, CONTROL ADD IMAGEX, CONTROL ADD IMGBUTTON, CONTROL ADD IMGBUTTONX, CONTROL SET IMAGE, CONTROL SET IMGBUTTON, CONTROL SET IMGBUTTONX","CONTROL SET IMAGEX statement","scr\\html_control_set_imagex.htm","                  \n\r\n\rPurpose\n\r\n\rChange the icon or bitmap displayed in an IMAGE control. The new image is not re-sized to fit the size of the control.\n\r\n\rSyntax\n\r\n\rCONTROL SET IMGBUTTON hDlg, id&amp;, newimage$\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with the CONTROL ADD IMGBUTTON statement.\n\r\n\rnewimage$ specifies the name of the bitmap or icon in the resource file. If the image resource uses an integral identifier, newimage$ should begin with a Number symbol (#), followed by the integer identifier in ASCII format. For example, &quot;#998&quot;. Otherwise, the text identifier name should be used.\n\r\n\rRestrictions \n\r\n\rImages can only be exchanged with images of the same type. That is, if the control is displaying a bitmap then the replacement image must also be a bitmap. If the control is displaying an icon, the replacement image must also be an icon. For best results, icons should be 32x32 pixels.\n\r\n\rWhen an image is changed, CONTROL SET IMGBUTTON automatically releases the old image from memory. Previous versions of PowerBASIC placed the onus on the programmer to release the old image handle.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD GRAPHIC, CONTROL ADD IMAGE, CONTROL ADD IMAGEX, CONTROL ADD IMGBUTTON, CONTROL ADD IMGBUTTONX, CONTROL SET IMAGE, CONTROL SET IMAGEX, CONTROL SET IMGBUTTONX","CONTROL SET IMGBUTTON statement","scr\\html_control_set_imgbutton.htm","                  \n\r\n\rPurpose\n\r\n\rChange the icon or bitmap displayed in an IMAGEX control. The new image is re-sized to fit the size of the control.\n\r\n\rSyntax\n\r\n\rCONTROL SET IMGBUTTONX hDlg, id&amp;, newimage$\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with the CONTROL ADD IMGBUTTONX statements.\n\r\n\rnewimage$ specifies the name of the bitmap or icon in the resource file. If the image resource uses an integeral identifier, newimage$ should begin with a Number symbol (#), followed by the integer identifier in ASCII format. For example, &quot;#998&quot;. Otherwise, the text identifier name should be used.\n\r\n\rRestrictions \n\r\n\rImages can only be exchanged with images of the same type. That is, if the control is displaying a bitmap then the replacement image must also be a bitmap. If the control is displaying an icon, the replacement image must also be an icon. For best results, icons should be 32x32 pixels.\n\r\n\rWhen an image is changed, CONTROL SET IMGBUTTONX automatically releases the old image from memory. Previous versions of PowerBASIC placed the onus on the programmer to release the old image handle.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD GRAPHIC, CONTROL ADD IMAGE, CONTROL ADD IMAGEX, CONTROL ADD IMGBUTTON, CONTROL ADD IMGBUTTONX, CONTROL SET IMAGE, CONTROL SET IMAGEX, CONTROL SET IMGBUTTON","CONTROL SET IMGBUTTONX statement","scr\\html_control_set_imgbuttonx.htm","                  \n\r\n\rPurpose\n\r\n\rMove the control to a new location in the dialog.\n\r\n\rSyntax\n\r\n\rCONTROL SET LOC hDlg, id&amp;, x&amp;, y&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rx&amp; and y&amp; specify the new location for the upper left corner of the control. These coordinates are relative to the upper left corner of the client area of the parent dialog (0,0), and are specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rThe location coordinates may be negative or larger than the width of the parent dialog\'s client area, causing the control to be clipped (partially displayed) or completely hidden.\n\r\n\rThis technique is often employed to capture the ENTER key, by creating a default button (%BS_DEFAULT) and positioning the control outside of the client area of the dialog - even though the control is not visible, it is still active and can respond to control accelerator keystrokes, etc.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET CLIENT, CONTROL GET LOC, CONTROL GET SIZE, CONTROL SET SIZE","CONTROL SET LOC statement","scr\\html_control_set_loc.htm","                  \n\r\n\rPurpose\n\r\n\rSet the Check State for an OPTION (radio) control, and unset the Check State for other OPTION buttons in a group.\n\r\n\rSyntax\n\r\n\rCONTROL SET OPTION hDlg, id&amp;, minid&amp;, maxid&amp;\n\r\n\rRemarks\n\r\n\rThe Check State is deemed set (checked) when the check box is selected, and unset (unchecked or clear) if the check box is empty. Only one OPTION control in a group of OPTION controls should ever have its Check State set at any given time. OPTION controls in a group should be assigned unique sequential identifier numbers.\n\r\n\rhDlg refers to the dialog that owns the OPTION controls.\n\r\n\rid&amp; is the unique control identifier as assigned to the button control with a CONTROL ADD OPTION statement. CONTROL SET OPTION sets the Check State for this control, and unsets the Check State for all of the remaining OPTION controls whose identifiers are included in the range minid&amp; through maxid&amp;, inclusive.\n\r\n\rThe first OPTION control in a group should have the style %WS_GROUP to mark the beginning of a group of buttons, and the first non-OPTION control after the group should also have this style set. If there are no other controls after the group, add %WS_GROUP to the first control in the dialog. This ensures keyboard navigation with the arrow buttons will operate within the group of OPTION controls.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD OPTION, CONTROL GET CHECK\n\r\n\rExample\n\r\n\r#INCLUDE &quot;DDT.INC&quot;\n\r\n\r%OPT1 = 101\n\r\n\r%OPT2 = 102\n\r\n\r%OPT3 = 103\n\r\n\r%OPT4 = 104\n\r\n\r%OPT5 = 105\n\r\n\r&nbsp;\n\r\n\rFUNCTION PBMAIN\n\r\n\r &nbsp;DIM hDlg AS DWORD\n\r\n\r &nbsp;DIALOG NEW 0, &quot;OPTION control test&quot;, , ,100, 100, _\n\r\n\r &nbsp; &nbsp;%WS_SYSMENU OR %WS_CAPTION TO hDlg\n\r\n\r &nbsp;CONTROL ADD OPTION, hDlg, %OPT1, &quot;Option 1&quot;, 10, 6, 50, 14, _\n\r\n\r &nbsp; &nbsp;%WS_GROUP OR %WS_TABSTOP\n\r\n\r &nbsp;CONTROL ADD OPTION, hDlg, %OPT2, &quot;Option 2&quot;, 10, 20, 50, 14\n\r\n\r &nbsp;CONTROL ADD OPTION, hDlg, %OPT3, &quot;Option 3&quot;, 10, 34, 50, 14\n\r\n\r &nbsp;CONTROL ADD OPTION, hDlg, %OPT4, &quot;Option 4&quot;, 10, 48, 50, 14\n\r\n\r &nbsp;CONTROL ADD OPTION, hDlg, %OPT5, &quot;Option 5&quot;, 10, 62, 50, 14\n\r\n\r &nbsp;CONTROL ADD BUTTON, hDlg, %IDOK, &quot;OK&quot;, 25, 80, 50, 14, _\n\r\n\r &nbsp; &nbsp;%WS_GROUP OR %WS_TABSTOP\n\r\n\r&nbsp;\n\r\n\r &nbsp;\' Set the initial state to OPTION button 3\n\r\n\r &nbsp;CONTROL SET OPTION hDlg, %OPT3, %OPT1, %OPT5\n\r\n\r&nbsp;\n\r\n\r &nbsp;DIALOG SHOW MODAL hDlg\n\r\n\rEND FUNCTION","CONTROL SET OPTION statement","scr\\html_control_set_option.htm","                  \n\r\n\rPurpose\n\r\n\rChange the size of a control.\n\r\n\rSyntax\n\r\n\rCONTROL SET SIZE hDlg, id&amp;, nWide&amp;, nHigh&amp;\n\r\n\rRemarks\n\r\n\rOverall size may be larger than client size, depending on the type of borders used. The client area is the part inside the borders of a control, which varies depending upon the style and exstyle at creation. Overall size includes the borders. In a control without borders, the client size and total size is the same. However, a control with the %WS_BORDER style will typically have a client area a few pixels smaller than the total size.\n\r\n\rhDlg\n\r\n\rHandle of the dialog that owns the control.\n\r\n\rnWide&amp;, nHigh&amp;\n\r\n\rIntegral numeric expressions which specify the desired size of the overall area. Width and height are specified in pixels or dialog units, depending upon the system used when the parent dialog was created.\n\r\n\rGraphic Controls\n\r\n\rBeginning with this version of PowerBASIC, GRAPHIC CONTROLS may be resized with CONTROL SET CLIENT, GRAPHIC SET CLIENT, CONTROL SET SIZE, and GRAPHIC SET SIZE.\n\r\n\rWhen you change the size of a graphic control, the original bitmap is copied, pixel for pixel, to the newly resized control. Any expanded area is filled with the current background color. Your program draws to it in the normal fashion for a bitmap of the new size.\n\r\n\rIf a clip area had been established to create margins, it is reset. If scaled coordinates had been established, they are also reset, as neither would be appropriate for the altered size. You can enable these attributes again with GRAPHIC SCALE or GRAPHIC SET CLIP, based upon the new size of the drawing area.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET CLIENT, CONTROL GET LOC, CONTROL GET SIZE, CONTROL SET LOC, GRAPHIC SET CLIENT, GRAPHIC SET SIZE","CONTROL SET SIZE statement","scr\\html_control_set_size.htm","                  \n\r\n\rPurpose\n\r\n\rChange the text in a control.\n\r\n\rSyntax\n\r\n\rCONTROL SET TEXT hDlg, id&amp;, txt$\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with a CONTROL ADD  statement.\n\r\n\rtxt$ is the new text for the control. Any existing text in the control is replaced with the new text.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET TEXT","CONTROL SET TEXT statement","scr\\html_control_set_text.htm","                  \n\r\n\rPurpose\n\r\n\rSet a value in the user data area of a DDT control.\n\r\n\rSyntax\n\r\n\rCONTROL SET USER hDlg, id&amp;, index&amp;, usrval&amp;\n\r\n\rRemarks\n\r\n\rEach DDT control has a user data area consisting of eight Long-integer values which may be used at the programmer\'s discretion to save relevant data. CONTROL SET USER allows one of the values to be set, based upon the index parameter value (1 through 8).\n\r\n\rhDlg refers to the dialog that owns the control.\n\r\n\rid&amp; is the unique control identifier as assigned to the control with a CONTROL ADD statement.\n\r\n\rindex&amp; is the index number of the user data value to set, in the range 1 to 8 inclusive.\n\r\n\rusrval&amp; is the Long-integer data value to store in the user data area.\n\r\n\rRestrictions \n\r\n\rData in the user data area is lost when the control is destroyed. The data area is completely separate from the %GWL_USERDATA area maintained by Windows.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, COMBOBOX GET USER, COMBOBOX SET USER, CONTROL GET USER, DIALOG GET USER, DIALOG SET USER, LISTBOX GET USER, LISTBOX SET USER, LISTVIEW GET USER, LISTVIEW SET USER, TREEVIEW GET USER, TREEVIEW SET USER","CONTROL SET USER statement","scr\\html_control_set_user.htm","                  \n\r\n\rPurpose\n\r\n\rChange the visible state of a control.\n\r\n\rSyntax\n\r\n\rCONTROL SHOW STATE hDlg, id&amp;, showstate&amp; [TO lResult&amp;]\n\r\n\rRemarks\n\r\n\rCONTROL SHOW STATE is used to alter the state and/or appearance of the specified control, identified by the parent dialog handle hDlg, and control id&amp; unique identifier combination.\n\r\n\rshowstate&amp; can be one of the following (with a value in the range from 0 to 10) as defined in the WIN32API.INC file):\n\r\n\r%SW_HIDE\n\r\n\rHide the control.\n\r\n\r%SW_MAXIMIZE\n\r\n\rMaximize the specified control.\n\r\n\r%SW_MINIMIZE\n\r\n\rMinimize the specified control.\n\r\n\r%SW_RESTORE\n\r\n\rActivate and display the control. If the control is minimized or maximized, Windows restores it to its original size and position. An application should specify this flag when restoring a minimized control.\n\r\n\r%SW_SHOW\n\r\n\rActivate the control and display it in its current size and position.\n\r\n\r%SW_SHOWMAXIMIZED\n\r\n\rSynonym of %SW_MAXIMIZE.\n\r\n\r%SW_SHOWMINIMIZED\n\r\n\rActivate the control and minimize it.\n\r\n\r%SW_SHOWNA\n\r\n\rDisplay the control in its current state without activating it. The currently active window/control remains active.\n\r\n\r%SW_SHOWNOACTIVATE\n\r\n\rDisplay the control in its most recent size and position without activating it. The currently active window/control remains active.\n\r\n\r%SW_SHOWNORMAL\n\r\n\rActivate and display the control. If the control is minimized or maximized, it is restored it to its original size and position.\n\r\n\rIf the optional TO clause is included, the lResult&amp; variable is assigned the value zero if the control was previously not visible, or non-zero if it was previously visible.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL DISABLE, CONTROL ENABLE, DIALOG SHOW STATE","CONTROL SHOW STATE statement","scr\\html_control_show_state.htm","                  \n\r\n\rUsing the IDE\n\r\n\rFirstly, ensure that the PowerBASIC IDE\'s OPTIONS dialog is configured to correctly point to the RC.EXE and PBRES.EXE files. Once configured, the IDE can automatically compile a .RC into a .RES file. When the &quot;Create a .PBR when compiling .RC files&quot; option on the compiler options tab is selected the IDE will also produce a .PBR file from the .RES file. This is achieved in one simple step: simply load the .RC file into the IDE and select Compile.\n\r\n\rUsing the command-line Resource Compiler\n\r\n\rTo compile the .RC file, we need to run the Resource Compiler from a DOS box (command-line) to create the binary (.RES) resource file.\n\r\n\rThe resource compiler takes the filename of your modified (.RC) resource script file as a parameter, and produces a new 32-bit .RES file. For example:\n\r\n\rC:\\PB\\BIN\\RC.EXE MYAPP.RC\n\r\n\rNote that you may need to change the path name to suit your individual settings. At this point, you should have a compiled binary resource file (i.e., MYAPP.RES), ready to be used with the #RESOURCE metastatement.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rWhat is a Resource File?\n\r\n\rResource Editors\n\r\n\rResource Compiling\n\r\n\rResource Scripts\n\r\n\r#RESOURCE metastatement","Converting a .RC to a .RES","scr\\html_converting_a__rc_to_a__res_.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the cosine of an angle.\n\r\n\rSyntax\n\r\n\ry = COS(numeric_expression)\n\r\n\rRemarks\n\r\n\rnumeric_expression is an angle specified in radians. To convert radians to degrees, multiply by 57.29577951308232##. To convert degrees to radians, multiply by 0.0174532925199433##. For more information on radians, see the ATN function.\n\r\n\rCOS returns an Extended-precision value that always ranges between -1 and +1 inclusive.\n\r\n\rThe Inverse Cosine (ARCCOS) of a value can be calculated as follows:\n\r\n\rpi## = 3.141592653589793##\n\r\n\rArcCos = pi## / 2 - ATN(Value / SQR(1 - Value * Value))\n\r\n\rThe Hyperbolic Cosine (COSH) of a value can also be calculated:\n\r\n\rCosH = (EXP(Value) + EXP(-Value)) / 2\n\r\n\rThe Inverse Hyperbolic Cosine (ARCCOSH) of a value can also be calculated:\n\r\n\rArcCosH = LOG(Value + SQR(Value * Value - 1))\n\r\n\r&nbsp;\n\r\n\r\' Useful Macro functions\n\r\n\rMACRO Pi = 3.141592653589793##\n\r\n\rMACRO DegreesToRadians(dpDegrees) = (dpDegrees*0.0174532925199433##)\n\r\n\rMACRO RadiansToDegrees(dpRadians) = (dpRadians*57.29577951308232##)\n\r\n\rSee also\n\r\n\rATN, SIN, TAN\n\r\n\rExample\n\r\n\rpi## = 3.141592653589793##\n\r\n\r\' we could also use pi## = ATN(1) * 4\n\r\n\rFOR I&amp; = 0 TO 360 STEP 45\n\r\n\r &nbsp;x$ = &quot;Cosine of &quot; + FORMAT$(I&amp;, &quot;* 0&quot;) + _\n\r\n\r &nbsp; &nbsp;&quot; degrees = &quot; + FORMAT$(COS(pi## / 180 * _\n\r\n\r &nbsp; &nbsp;I&amp;), &quot;* 0.00&quot;)\n\r\n\rNEXT I&amp;\n\r\n\rResult\n\r\n\rCosine of &nbsp; 0 degrees = &nbsp;1.00\n\r\n\rCosine of &nbsp;45 degrees = &nbsp;0.71\n\r\n\rCosine of &nbsp;90 degrees = &nbsp;0.00\n\r\n\rCosine of 135 degrees = -0.71\n\r\n\rCosine of 180 degrees = -1.00\n\r\n\rCosine of 225 degrees = -0.71\n\r\n\rCosine of 270 degrees = &nbsp;0.00\n\r\n\rCosine of 315 degrees = &nbsp;0.71\n\r\n\rCosine of 360 degrees = &nbsp;1.00","COS function","scr\\html_cos_function.htm","                  \n\r\n\rIn this example, we will create a simple dialog that asks the user to enter his/her name, providing a text box for input, plus both &quot;OK&quot; and &quot;Cancel&quot; buttons. To create the dialog, first we use the DIALOG NEW statement:\n\r\n\rLOCAL hParent AS DWORD\n\r\n\rLOCAL hDlg AS DWORD\n\r\n\r[statements]\n\r\n\rDIALOG NEW hParent, Caption$,,, 160, 50, Style&amp;, exStyle&amp; TO hDlg\n\r\n\rhParent refers to the parent window handle. If this value is 0 (or %HWND_DESKTOP), the dialog has no parent window, and may be referred to as a &quot;top-level&quot; window. However, if the dialog has a parent window and the dialog is a MODAL dialog, Windows will automatically disable the parent window while the DDT dialog is displayed.\n\r\n\rCaption$ is the text displayed in the caption of the dialog. This may be the name of your program, or it can be used to convey other information to the user.\n\r\n\rThe next two parameters for the location on the screen are omitted (this causes the dialog to be centered on the screen), and the size is set to 160 dialog units wide by 50 dialog units tall. Style&amp; specifies how the dialog is drawn on the screen (with a caption, without a caption, etc). exStyle&amp; specifies an extended style attributes for drawing the dialog. For information on the range of possible dialog styles, please see the DIALOG NEW statement.\n\r\n\rOnce the dialog has been created, the handle for it is placed in the hDlg variable. hDlg may be a Long-integer or Double-word variable (i.e., hDlg&amp; or hDlg???), but a Double-word variable is recommended. This handle is used by Windows (and your program) code to identify the dialog. Windows gives each dialog a unique handle value at run-time; no two windows, dialogs, or controls can have the same handle value. This means that the actual handle value will be different every time the dialog is created.\n\r\n\rNote that the height and width values determine the client size of the dialog, if the dialog style explicitly includes the %WS_CAPTION style. Otherwise, they are interpreted as the outer dimensions of the complete dialog.\n\r\n\r&nbsp;\n\r\n\rNote: The location and size of a dialog are specified in Dialog Units or, optionally, Pixels.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rDynamic Dialog Tools (DDT)\n\r\n\rAdding Controls to the Dialog\n\r\n\rModal vs. Modeless\n\r\n\rControls\n\r\n\rControl Styles\n\r\n\rCallbacks\n\r\n\rDialog Styles\n\r\n\rMenus","Creating a Dialog","scr\\html_creating_a_dialog.htm","                  \n\r\n\rDISPATCH objects are easy to create. The technique is virtually identical to that for direct interfaces. You must first declare the object variable -- if you wish to use &quot;Late Binding&quot;, you\'ll use the generic name IDISPATCH.\n\r\n\rLOCAL DispVar AS IDISPATCH\n\r\n\rLET DispVar = NEWCOM &quot;DispProgID&quot;\n\r\n\rIf you wish to use &quot;ID Binding&quot;, you\'ll use the interface name from your Interface IDBIND structure.\n\r\n\rLOCAL DispVar AS MyDispIfaceName\n\r\n\rLET DispVar = NEWCOM &quot;DispProgID&quot;\n\r\n\rIf all went well, you now have an object! &nbsp;(And an object reference in your object variable). Of course, it\'s &nbsp;always a good idea to use the ISOBJECT(DispVar) function to be certain that the operation was a success. If it failed, an attempt to use the object variable could cause a fatal exception.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rWhat is an object, anyway?\n\r\n\rWhat is DISPATCH?\n\r\n\rLate Binding\n\r\n\rID Binding\n\r\n\rHow do you call a DISPATCH METHOD?","Creating a DISPATCH Object","scr\\html_creating_a_dispatch_object_.htm","                  \n\r\n\rA DLL contains one or more exported Classes, Subs, or Functions that may be called by applications or other DLLs. A DLL may also contain any number of private Subs or Functions that can only be called from within the library. Creating a DLL with PowerBASIC is straightforward. Below are the steps to follow to convert parts of a Visual Basic program to a DLL.\n\r\n\rStep 1:\n\r\n\rThe first step is to identify the sections of your application that are used in multiple programs, or in the case of Visual Basic, Subs and Functions that you need to execute faster.\n\r\n\rStep 2:\n\r\n\rSave those Subs and Functions as text, and change the file extension to .BAS. This will become the source module that will be compiled into a DLL with PowerBASIC. You could also create the source file from scratch, if you so wish.\n\r\n\rStep 3:\n\r\n\rLaunch PBEDIT.EXE (the PowerBASIC IDE) and add the EXPORT keyword to any Sub or Function in the DLL source code (that you wish to be made accessible to external applications). Add #COMPILE DLL to the top of the source code file, and make any other changes to your .BAS source module. See the SUB/END SUB and FUNCTION/END FUNCTION topics for more information on the exact syntax.\n\r\n\rStep 4:\n\r\n\rClick the compile button on the PowerBASIC IDE toolbar.\n\r\n\rAny compile-time errors will be flagged at this point. Repeat steps 3 to 4 above until no more errors are reported. You are then ready to start testing and debugging your DLL. Debugging is done using the PowerBASIC symbolic Debugger built into the PowerBASIC IDE (PBEDIT.EXE). See the section on Debugging for more information.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rWhat is a Dll?\n\r\n\rPrivate and Exported Procedures\n\r\n\rDll example\n\r\n\rLibMain\n\r\n\rWhat is an object, anyway?\n\r\n\rJust what is COM?\n\r\n\rWhat is a COM component?","Creating a Dynamic Link Library","scr\\html_creating_a_dynamic_link_library.htm","                  \n\r\n\rCreation of an SLL couldn\'t be easier. All it takes is a single metastatement at the top of your module source code:\n\r\n\r#COMPILE SLL\n\r\n\rIf your source code file is named &quot;ABC.BAS&quot;, then your Static Link Library will automatically be named &quot;ABC.SLL&quot;. (You can check the #COMPILE section for additional naming options.) When you wish to use the SLL code in a host program, you use:\n\r\n\r#LINK &quot;ABC.SLL&quot;\n\r\n\rand the contents are automatically embedded in the new .EXE or .DLL. It\'s just that simple.\n\r\n\r&nbsp;\n\r\n\rCommon Subs and Functions\n\r\n\rA COMMON Sub or Function is one which is visible between the primary host program and one or more SLL unit modules. A Sub/Function is defined as COMMON by inserting that word as one of the descriptors:\n\r\n\rFUNCTION MyFunc(Parm AS LONG) COMMON AS DOUBLE\n\r\n\r &nbsp;&lt;Function code&gt;...\n\r\n\rEND FUNCTION\n\r\n\rWhen you create an SLL, you may find you need to reference a Sub or Function which is located in the main Host Module or another SLL. In that case, you must DECLARE it with the COMMON descriptor:\n\r\n\rDECLARE FUNCTION MyFunc(Parm AS LONG) COMMON AS DOUBLE\n\r\n\rIt is not necessary to DECLARE a COMMON Sub or Function at all in the Host Module. If you choose to do so (for self-documentation or other reasons), it is generally advisable to omit the COMMON descriptor, as its presence will force the SLL to be linked, whether needed or not.\n\r\n\rOf course, when the host module is compiled, all references to COMMON items must be resolved accurately, or an appropriate error will be generated. Any Sub/Function not defined as COMMON may not be shared between modules.\n\r\n\rThe EXPORT descriptor identifies a Sub/Function which may be accessed between Dynamic Link Libraries (DLLs), and/or the main executable which links them. If a procedure is not marked EXPORT, it is hidden from these other modules. Generally speaking, it\'s best not to mark a Sub/Function in an SLL as EXPORT. While it is syntactically acceptable, it may limit your future options when linking the SLL into host modules. PowerBASIC recommends that you mark them as COMMON in the SLL, and add the EXPORT attribute in the host module.\n\r\n\rIt\'s easy to create an SLL which can be linked into an executable program or a dedicated DLL for the same purpose. To add the EXPORT attribute to a linked Sub/Function, just add the word EXPORT to the DECLARE statement in the host module or add an #EXPORT metastatement.\n\r\n\r#EXPORT MyFunc\n\r\n\rDECLARE FUNCTION MyFunc(Parm AS LONG) COMMON EXPORT AS DOUBLE\n\r\n\rUsing this technique, your SLL can be linked directly into an application executable without publishing the Subs/Functions as EXPORT. However, you can also link the same SLL into a DLL host module which adds the EXPORT attribute to any or all of the COMMON Subs and Functions in the corresponding DECLARE statements.\n\r\n\rFor example, let\'s say you want to make a library which publishes the SUB named XXX. You want to provide it in two forms, a linkable SLL and an industry standard DLL. So, first just create the SLL:\n\r\n\r#COMPILE SLL = &quot;XXXLib.SLL&quot;\n\r\n\r&nbsp;\n\r\n\rSUB xxx() COMMON\n\r\n\r &nbsp;MSGBOX &quot;Hello&quot;\n\r\n\rEND SUB\n\r\n\rJust compile it, and you\'re ready to link it into your application. But now you want to create a DLL, too, since it might be used with other applications. It\'s just this easy:\n\r\n\r#COMPILE DLL = &quot;XXXLib.DLL&quot;\n\r\n\r&nbsp;\n\r\n\r#EXPORT xxx\n\r\n\r#LINK &quot;XXXLib.SLL&quot;\n\r\n\rThat\'s all there is to it. You now have an SLL and an equivalent DLL to do the job of the XXX procedure.\n\r\n\rCommon Classes and Objects\n\r\n\rA COMMON Class is one which is visible between the primary host module and one or more SLL unit modules. A Class is defined as COMMON by inserting that word as a Class Descriptor:\n\r\n\rCLASS MyClass $MyGuid COMMON\n\r\n\r &nbsp;&lt;Class code&gt;...\n\r\n\rEND CLASS\n\r\n\rA class which is declared AS COM makes it available to external programs through the COM services of Windows. You can define a class to be both COM and COMMON by adding both descriptors. However, a COM Class is automatically considered to be COMMON as well.\n\r\n\rCLASS MyClass $MyGuid COMMON AS COM\n\r\n\r &nbsp;&lt;Class code&gt;...\n\r\n\rEND CLASS\n\r\n\rUnreferenced Code\n\r\n\rAny code in an SLL marked COMMON, COM, or EXPORT is always included in your compiled SLL module. Any additional code referenced by them is also included. All other unused code is automatically extracted at the time the SLL is compiled. Keep in mind that the resulting SLL module is pre-compiled, and cannot be modified further.\n\r\n\rWhen you link an SLL into a host module, it is examined carefully by the compiler. If it is determined that no code in the SLL is needed, the SLL is simply not linked. This can reduce the size of your final program substantially. However, if even one procedure in an SLL is used, the entire SLL is included. Therefore, it may be in your best interest to split up your code into multiple SLL modules. The PowerBASIC Compiler will pick and choose exactly which ones are needed and ignore the rest. This assures the smallest possible size of the resulting application.\n\r\n\rManaging Multiple SLL Modules\n\r\n\rFor your convenience, multiple SLL modules may be collected into a Power Library, which is linked as a single item. However, the PowerBASIC Compiler treats the component modules individually, just as though they were each linked separately. A component SLL in a Power Library which is not needed is ignored entirely.\n\r\n\rSLL modules are collected into a Power Library with the PowerLib utility librarian. This GUI application can readily add, remove, replace, or list the component SLL modules. Optionally, you can also use a command line librarian if that better serves your needs. The file extension for Power Libraries is &quot;.PBLIB&quot;.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rWhat is an Sll?\n\r\n\rSll example\n\r\n\rPowerBASIC Library Manager","Creating a Static Link Library","scr\\html_creating_a_static_link_library.htm","                  \n\r\n\rPurpose\n\r\n\rReturn a string containing a centered (padded) string.\n\r\n\rSyntax\n\r\n\rresult_var = CSET$(string_expression, strlen&amp; [USING ustring_expression])\n\r\n\rRemarks\n\r\n\rCSET$ centers the string string_expression into a string of strlen&amp; characters.\n\r\n\rUSING\n\r\n\rIf ustring_expression is null (empty) or is not specified, CSET$ pads string_expression with space characters. Otherwise, CSET$ pads the string with the first character of ustring_expression.\n\r\n\rIf string_expression is shorter then strlen&amp;, CSET$ centers string_expression within result_var, padding both sides as described above; otherwise, CSET$ returns the left-most strlen&amp; bytes of string_expression.\n\r\n\rSee also\n\r\n\rCSET, GET, LET, LSET, LSET$, PUT, RESET, RSET, RSET$, STRINSERT$, TYPE &nbsp;SET\n\r\n\rExample\n\r\n\ra$ = CSET$(&quot;PowerBASIC&quot;, 20)\n\r\n\r\' result: &quot; &nbsp; &nbsp; PowerBASIC &nbsp; &nbsp; &quot;\n\r\n\r&nbsp;\n\r\n\ra$ = CSET$(&quot;PowerBASIC&quot;,20 USING &quot;*&quot;)\n\r\n\r\' result: &quot;*****PowerBASIC*****&quot;","CSET$ function","scr\\html_cset_function.htm","                  \n\r\n\rPurpose\n\r\n\rCenter a string within the space of another string or User-Defined Type.\n\r\n\rSyntax\n\r\n\rCSET [ABS] result_var = string_expression [USING string_expression]\n\r\n\rRemarks\n\r\n\rCSET centers a string into the space of another string or variable of a User-Defined Type.\n\r\n\rABS\n\r\n\rIf ABS is specified, or ustring_expression is null (empty), CSET leaves the padding positions unchanged from their original content, rather than replacing them with spaces.\n\r\n\rUSING\n\r\n\rIf string_expression is shorter then result_var, CSET centers string_expression within result_var, padding both sides with the first character in ustring_expression, or spaces if not specified.\n\r\n\rIf string_expression is longer than result_var, CSET truncates string_expression from the right until it fits in result_var.\n\r\n\rCSET can be used to assign the content of a User-Defined Type to a User-Defined Type variable of a different class, or assign a dynamic string to a User-Defined Type. For example:\n\r\n\rCSET MyType = MyType2\n\r\n\rCSET MyType = a$\n\r\n\rLSET and RSET work similarly, but performs left and right-justification respectively.\n\r\n\rSee also\n\r\n\rCSET$, GET, LET, LET (With Types), LSET, LSET$, PUT, RESET, RSET, RSET$, STRINSERT$, TYPE &nbsp;SET\n\r\n\rExample\n\r\n\ra$ = RTRIM$(REPEAT$(5,&quot;COOL &quot;))\n\r\n\rCSET ABS a$ = &quot;..PowerBASIC..&quot;\n\r\n\r\' result: &quot;COOL ..PowerBASIC.. COOL&quot;\n\r\n\rCSET a$ = &quot;PowerBASIC&quot; USING &quot;*&quot;\n\r\n\r\' result: &quot;*******PowerBASIC*******&quot;","CSET statement","scr\\html_cset_statement.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the current directory path for the specified drive.\n\r\n\rSyntax\n\r\n\rs$ = CURDIR$[(drive$)]\n\r\n\rRemarks\n\r\n\rdrive$ is an optional string expression, containing the drive letter of the target disk drive. If drive$ is not specified or is an empty string, the current directory path is returned for the default drive.\n\r\n\rSee also\n\r\n\rCHDRIVE, CHDIR\n\r\n\rExample\n\r\n\rFUNCTION PBMAIN\n\r\n\r &nbsp;LOCAL FullCurrentPath$\n\r\n\r &nbsp;LOCAL CurrentDrive$\n\r\n\r &nbsp;FullCurrentPath$ = CURDIR$\n\r\n\r &nbsp;IF MID$(CURDIR$,2,1) = &quot;:&quot; THEN\n\r\n\r &nbsp; &nbsp;CurrentDrive$ = LEFT$(CURDIR$,2)\n\r\n\r &nbsp;END IF\n\r\n\rEND FUNCTION","CURDIR$ function","scr\\html_curdir_function.htm","                  \n\r\n\rCurrency variables are 8 byte binary representations of floating point numbers, which are considered to always have a fixed number of digits to the right of the decimal point. &nbsp;Currency numbers have a range of approximately -9.22*10^14 to +9.22*10^14, and Extended-currency have a range of -9.22*10^16 to +9.22*10^16.\n\r\n\rThe type-specifier character for Currency and Extended-currency floating-point is: @ and @@ respectively.\n\r\n\rYou can also use the DEFCUR or DEFCUX statement as described under Integers. &nbsp;They can also be declared using the CUR/CURRENCY or CUX/CURRENCYX keywords with the DIM statement. &nbsp;For example:\n\r\n\rDIM I AS CUR\n\r\n\rDIM J AS CURRENCYX\n\r\n\rCurrency variables (@) have up to 4 digits of precision after the decimal point, and are useful for prices and quantities where fractions of a cent are desired. &nbsp;Extended-currency variables (@@) have two digits of precision after the decimal point. &nbsp;They are optimized for financial calculations where fractions of a cent are not required.\n\r\n\rThe currency data types are especially useful for financial calculations, as they avoid the round-off errors associated with Single, Double, and Extended-precision numbers (which must be an exact power of two in order to be represented exactly). &nbsp;While many numbers can be represented exactly as a power of two, there are also many that cannot. &nbsp;For example, 1.10000002384185791 is the closest power of two to 1.1, in single precision.\n\r\n\rSo, when assigning numeric literal values to a Currency or Extended-currency variable, we recommend using a type specifier to ensure the value is given the intended precision. &nbsp;For example:\n\r\n\rDIM x1 AS CUR\n\r\n\rx1 = 1.0001@\n\r\n\r&nbsp;\n\r\n\rDIM x2 AS CUX\n\r\n\rx2 = 1.01@@\n\r\n\rInternally, Currency and Extended-currency numbers are stored as Quad-integers with an implied decimal point (at 4 places for Currency, and at 2 places for Extended-currency). &nbsp;This approach ensures that all of the digits of the variables can be represented exactly.\n\r\n\rCurrency and Extended Currency perform a similar role as BCD variables in some BASIC dialects to ensure monetary values can be represented exactly; however, the internal storage of BCD variables and CUR/CUX differs substantially.\n\r\n\rDelphi and Visual Basic both offer a currency data type that is identical to the PowerBASIC Currency variable.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rArray Data Types\n\r\n\rBit Data Types\n\r\n\rGUID Data Types\n\r\n\rObject Data Types\n\r\n\rPointers\n\r\n\rUser Defined Types\n\r\n\rUnions\n\r\n\rVariant Data Types","Currency and Extended-currency","scr\\html_currency_()_and_extended_currency_().htm","                  \n\r\n\rPurpose\n\r\n\rExtracts numeric data from an ANSI string.\n\r\n\rSyntax\n\r\n\rbytevar? &nbsp; &nbsp; &nbsp; &nbsp; = CVBYT(stringexpr [, offset])\n\r\n\rcurvar@ &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;= CVCUR(stringexpr [, offset])\n\r\n\rcuxvar@@ &nbsp; &nbsp; &nbsp; &nbsp; = CVCUX(stringexpr [, offset])\n\r\n\rdoublevar# &nbsp; &nbsp; &nbsp; = CVD &nbsp;(stringexpr [, offset])\n\r\n\rdoublewordvar??? = CVDWD(stringexpr [, offset])\n\r\n\rextendedvar## &nbsp; &nbsp;= CVE &nbsp;(stringexpr [, offset])\n\r\n\rintegervar% &nbsp; &nbsp; &nbsp;= CVI &nbsp;(stringexpr [, offset])\n\r\n\rlongintvar&amp; &nbsp; &nbsp; &nbsp;= CVL &nbsp;(stringexpr [, offset])\n\r\n\rquadintvar&amp;&amp; &nbsp; &nbsp; = CVQ &nbsp;(stringexpr [, offset])\n\r\n\rsinglevar! &nbsp; &nbsp; &nbsp; = CVS &nbsp;(stringexpr [, offset])\n\r\n\rwordvar?? &nbsp; &nbsp; &nbsp; &nbsp;= CVWRD(stringexpr [, offset])\n\r\n\rRemarks\n\r\n\rThe CVx functions return a number corresponding to a binary pattern stored in a ANSI string value. The binary pattern is the internal format used by PowerBASIC to store these values in memory. This format follows the IEEE standard wherever it applies. The MKx$ functions are complementary to the CVx functions. Do not confuse these functions with the VAL function, which converts a number stored as a printable text string (such as &quot;123.45&quot;) into a numeric expression.\n\r\n\rIn all but the most extreme cases, StringExpr must be an ANSI string or UDT which consists of single bytes. WIDE (Unicode) strings consist of a series of 2-byte words which will generally yield undefined results.\n\r\n\rThe CVx functions allow you to retrieve values beyond the first byte of the StringExpr. In this case, the optional offset parameter tells the byte position where the conversion should begin. This is the byte position, not the character position, even with a WIDE StringExpr. If Offset is not given, it is presumed to be one (1).\n\r\n\rFor example: &quot;Value&amp; = CVL(x$, 3)&quot; would extract the 3rd through 6th bytes of x$ and convert these 4 bytes to the corresponding Long-integer value. In this example, x$ must be at least 6 bytes long.\n\r\n\rFunction\n\r\n\rVariable\n\r\n\rConverts to\n\r\n\rCVBYT\n\r\n\r1-byte string\n\r\n\rByte\n\r\n\rCVCUR\n\r\n\r8-byte string\n\r\n\rCurrency\n\r\n\rCVCUX\n\r\n\r8-byte string\n\r\n\rExtended-currency\n\r\n\rCVD\n\r\n\r8-byte string\n\r\n\rDouble-precision float\n\r\n\rCVDWD\n\r\n\r4-byte string\n\r\n\rDouble-word\n\r\n\rCVE\n\r\n\r10-byte string\n\r\n\rExtended-precision float\n\r\n\rCVI\n\r\n\r2-byte string\n\r\n\rInteger\n\r\n\rCVL\n\r\n\r4-byte string\n\r\n\rLong-integer\n\r\n\rCVQ\n\r\n\r8-byte string\n\r\n\rQuad-integer\n\r\n\rCVS\n\r\n\r4-byte string\n\r\n\rSingle-precision float\n\r\n\rCVWRD\n\r\n\r2-byte string\n\r\n\rWord\n\r\n\rRestrictions\n\r\n\rExpressions involving Numeric Equates and conditional compilation (#IF) may also include the CVQ function. This allows you to easily assign numeric values to an equate, based upon a meaningful mnemonic. In this context, the CVQ expression is limited to a length of eight bytes. For example:\n\r\n\r%Mode &nbsp;= CVQ(&quot;DEBUG&quot;)\n\r\n\r%Style = CVQ(&quot;Cool&quot;)\n\r\n\rCVS limits string display to seven significant digits.\n\r\n\rSee also\n\r\n\rMKBYT$ and associated functions","CVWRD function","scr\\html_cvbyt_functions.htm","                  \n\r\n\rPurpose\n\r\n\rDeclare string constants within the source code to be read by READ$ function.\n\r\n\rSyntax\n\r\n\rDATA [&quot;]item[&quot;] [[, [&quot;]item[&quot;]] ...]\n\r\n\rRemarks\n\r\n\rDATA statements may only appear inside of Subs, Functions, Method, or Properties, and are visible only to the code in the procedure in which they appear. Each procedure may therefore have its own private data.\n\r\n\rData may consist of virtually any text characters. Data items may be enclosed in quotes to preserve leading/trailing spaces, which are otherwise stripped during compilation.\n\r\n\rRestrictions\n\r\n\rThere is a limit of 64 Kilobytes and 16384 separate data items per procedure. Previous versions of PowerBASIC ignored plain text located immediately after a quoted literal up to the next comma or end-of-line; however, this is no longer acceptable and generates an Error 477 (&quot;Syntax error&quot;).\n\r\n\rDATA statements cannot extend across more than one physical source code line using line continuation characters. Special care should be used when formatting DATA statements, especially if the data is to contain underscore and/or colon characters. The following examples highlight data items in blue:\n\r\n\rIf an underscore appears after a comma, it is treated as the start of a quoted data string, rather than a line continuation character:\n\r\n\r\' Three data items exist in this line:\n\r\n\rDATA &quot;Tom&quot;, &quot;Dick&quot;, _Harry\n\r\n\rThe colon (statement separator) character, when used within unquoted string data, performs as a regular statement separator:\n\r\n\r\' Two data items and a separate statement\n\r\n\rDATA &quot;Tom&quot;,&quot;Dick&quot; : Harry&amp; = 1\n\r\n\rHowever, if a colon character appears within a quoted data string, it is treated as part of the data string:\n\r\n\r\' 3 data items\n\r\n\rDATA &quot;Tom&quot;,Dick,&quot;:Harry&amp; = 1&quot;\n\r\n\rSee also\n\r\n\rDATACOUNT, READ$, VAL\n\r\n\rExample\n\r\n\rDATA &quot;Abc&quot;, Bob, &quot;Sally&quot;, 123\n\r\n\rDATA 456.78, &quot; &nbsp;leading space&quot;\n\r\n\rDATA embedded &quot;quotes within data&quot;","DATA statement","scr\\html_data_statement.htm","                  \n\r\n\rThere are three basic types of operands that can be placed in a register: immediate, memory or another register.\n\r\n\rAn immediate operand is usually a numeric literal (number) but it can also be a string literal in the form &quot;a&quot; which is converted by PowerBASIC to its ASCII equivalent code.\n\r\n\r! MOV AL, &quot;a&quot; &nbsp; &nbsp; &nbsp; ; String literal\n\r\n\r! MOV EDX, 0 &nbsp; &nbsp; &nbsp; &nbsp;; Numeric immediate/literal\n\r\n\rA memory operand is an address in memory of some form of data:\n\r\n\r! MOV AL, [ESI] &nbsp; &nbsp; ; Copy byte at address in ESI into AL\n\r\n\r! MOV EDX, lpMemvar ; Copy variable address into EDX\n\r\n\rA register operand is a register with a value in it:\n\r\n\r! MOV ECX, EDX &nbsp; &nbsp; &nbsp;; Copy EDX into ECX\n\r\n\rThe actions that can be performed are determined by the available opcodes. For example, trying to move one memory operand directly into another does not work because there is no opcode in the 80x86 processor to do it.\n\r\n\r! MOV mVar, lpMem &nbsp; ; This fails as there is no opcode\n\r\n\rHowever, if you have a &quot;spare&quot; register, you make an indirect copy through that register:\n\r\n\r! MOV EAX, lpMem &nbsp; &nbsp;; Copy memory value into register\n\r\n\r! MOV mVar, EAX &nbsp; &nbsp; ; Copy register into memory variable\n\r\n\rIf you don\'t have a &quot;spare&quot; register, it can be done another way but it is slightly slower:\n\r\n\r! PUSH lpMem &nbsp; &nbsp; &nbsp; &nbsp;; Push memory value onto the stack\n\r\n\r! POP mVar &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;; Pop it off as another memory value\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rThe Inline Assembler\n\r\n\rRegisters\n\r\n\rMMX registers\n\r\n\rSaving registers\n\r\n\rSaving Registers at the Procedure level\n\r\n\rUsing ESP and EBP\n\r\n\rSaving the FPU registers","Data types in Registers","scr\\html_data_types_in_registers.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the total count of the number of local DATA items that can be read with the READ$ function.\n\r\n\rSyntax\n\r\n\rCount% = DATACOUNT\n\r\n\rRemarks\n\r\n\rDATACOUNT only returns the number of DATA items in the Sub, Function, Method, or Property in which it appears (i.e., local DATA statements). While it is not possible to directly read data from outside of the scope of current procedure, global data can be emulated easily by placing it inside a procedure returns data to the calling code. There is a limit of 64 Kilobytes and 16384 separate data items per procedure.\n\r\n\rSee also\n\r\n\rDATA, READ$\n\r\n\rExample\n\r\n\rFUNCTION GetCategories(Category() AS STRING) AS LONG\n\r\n\r &nbsp;LOCAL x AS INTEGER\n\r\n\r &nbsp;REDIM Category(1 TO DATACOUNT) AS STRING\n\r\n\r &nbsp;FOR x = 1 TO DATACOUNT\n\r\n\r &nbsp; &nbsp;Category(x) = READ$(x)\n\r\n\r &nbsp;NEXT x\n\r\n\r &nbsp;FUNCTION = DATACOUNT\n\r\n\r &nbsp;DATA Animal, Mineral, Vegetable, Alien\n\r\n\rEND FUNCTION","DATACOUNT function","scr\\html_datacount_function.htm","                  \n\r\n\rPurpose\n\r\n\rSet or retrieve the system date.\n\r\n\rSyntax\n\r\n\rDATE$ = s$ &nbsp; &nbsp; &nbsp;\' sets system date according to s$\n\r\n\rs$ = DATE$ &nbsp; &nbsp; &nbsp;\' s$ now contains system date\n\r\n\rRemarks\n\r\n\rAssigning a properly formatted string value to DATE$ sets the system date. You can also assign DATE$ to a string variable, which stores 10 characters in the form &quot;mm-dd-yyyy&quot;, where mm represents the month, dd the day, and yyyy the year.\n\r\n\rTo change the date, your date string must be formatted in one of the following ways:\n\r\n\rmm-dd-yy\n\r\n\rmm/dd/yy\n\r\n\rmm-dd-yyyy\n\r\n\rmm/dd/yyyy\n\r\n\rFor example, DATE$ = &quot;11-09-84&quot; sets the system date to November 9, 1984.\n\r\n\rRestrictions\n\r\n\rThe year assigned to the DATE$ system variable must be within the range 1980 to 2099. DATE$ never returns locale-specific date formats. When assigning a two digit year, any value less than 81 will be assumed to be in the 2000\'s and any value greater than 80 will be assumed to be in the 1900\'s.\n\r\n\rSee also\n\r\n\rDAYNAME$, MONTHNAME$, POWERTIME, TIME$","DATE$ system variable","scr\\html_date_system_variable.htm","                  \n\r\n\rPurpose\n\r\n\rConverts a Day-of-Week number to the associated name.\n\r\n\rSyntax\n\r\n\rs$ = DAYNAME$(DayNumber&amp;)\n\r\n\rRemarks\n\r\n\rThe DAYNAME$ function converts a Day-of-Weeek number into a string representing its associated name. The argument must be in the range of 0 through 6, representing the names Sunday, Monday, etc.\n\r\n\rSee also\n\r\n\rDATE$, MONTHNAME$, POWERTIME","DAYNAME$ function","scr\\html_dayname$_function.htm","                  \n\r\n\rA Control is a special Window that provides a method for interacting with the user. Buttons, Combo boxes, List boxes, and Text boxes are all examples of controls. Whenever the user interacts with a control (clicks a button or types into a text box), an event occurs causing Windows to send a message to your application. Your application processes these messages in special functions called Callback Functions.\n\r\n\rWhen you add a control to a dialog, it is important that each control has a unique numeric identifier. This identifier helps your application to know which control is sending an event. For example, if your program has two buttons in it, the control ID allows you distinguish between them.\n\r\n\rAs each control is created, Windows assigns a unique window handle to identify the control. Because your program does not assign these handle values, your code cannot directly use them to identify individual controls. Further, each time a control is destroyed and recreated, a new unique handle value is assigned, further complicating the task. The control ID overcomes these problems, as the programmer determines the ID for each control.\n\r\n\r\n\r\n\rControls are added to your dialog with the CONTROL ADD statement. Make sure that each control you create has a unique numeric identifier, so that you (and Windows) can tell it apart from other controls on the dialog.\n\r\n\rGiven the ID of a control, DDT provides the CONTROL HANDLE statement to retrieve the window handle value of the control. If a given ID is duplicated in a dialog, CONTROL HANDLE is only able to identify the first control that matches the ID, and the remaining controls will essentially be ignored. Control ID\'s can often be duplicated for Label (static) text controls, provided these controls (and their contents, color, or styles) are not going to be modified at run-time. If such a Label control is to be modified, its control ID must be unique.\n\r\n\rPowerBASIC provides a comprehensive set of statements and functions for dealing with controls. The following is a small sample of these statements and functions with a brief description of the purpose of each:\n\r\n\rFunction Description\n\r\n\r#MESSAGES\n\r\n\rSpecify which messages should be sent to a Control Callback Function\n\r\n\rCB.CTL\n\r\n\rReturn the ID of the control sending a message to your Callback Function. (Only valid inside a Callback Function).\n\r\n\rCB.CTLMSG\n\r\n\rReturn the notification ID of the control sending a message to your Callback Function. (Only valid inside a Callback Function).\n\r\n\rCB.HNDL\n\r\n\rReturns the dialog handle sending a message to your Callback Function. (Only valid inside a Callback Function).\n\r\n\rCB.LPARAM\n\r\n\rReturns the lParam&amp; value sent to your Callback Function. (Only valid inside a Callback Function).\n\r\n\rCB.MSG\n\r\n\rReturns the wMsg&amp; value sent to your Callback Function. (Only valid inside a Callback Function).\n\r\n\rCB.NMCODE\n\r\n\rReturns the specific notification message describing the event which occurred. (Only valid inside a Callback Function).\n\r\n\rCB.NMHDR\n\r\n\rReturns the address (a pointer) to the NMHDR UDT for a notification message sent to your Callback Function. (Only valid inside a Callback Function).\n\r\n\rCB.NMHDR$\n\r\n\rReturns the contents of the NMHDR UDT as a dynamic string. (Only valid inside a Callback Function).\n\r\n\rCB.NMHWND\n\r\n\rReturns the handle of the control which sent this message to your Callback Function. (Only valid inside a Callback Function).\n\r\n\rCB.NMID\n\r\n\rReturns the ID number assigned to this control which sent this message to your Callback Function. (Only valid inside a Callback Function).\n\r\n\rCB.WPARAM\n\r\n\rReturns the wParam&amp; value sent to your Callback Function. (Only valid inside a Callback Function).\n\r\n\r\n\rCreate a control in a dialog.\n\r\n\rCONTROL DISABLE\n\r\n\rDisable a control so that it can no longer send messages to a callback. If the control is a button, it is grayed. If it is a text box, it becomes grayed out and you can no longer edit the text contained within it.\n\r\n\rCONTROL ENABLE\n\r\n\rEnable a control that was previously disabled. A control must be enabled in order for it to send notifications to a Callback Function.\n\r\n\rCONTROL GET SIZE\n\r\n\rGet the size of a control.\n\r\n\rCONTROL GET LOC\n\r\n\rGet the location of a control inside of its parent dialog.\n\r\n\rCONTROL GET TEXT\n\r\n\rRetrieve the text from a control, such as a Text box or Label, etc.\n\r\n\rCONTROL HANDLE\n\r\n\rReturn a window handle for a given control.\n\r\n\rCONTROL KILL\n\r\n\rRemove a control from a dialog.\n\r\n\rCONTROL SEND\n\r\n\rSend a message to a control.\n\r\n\rCONTROL SET FOCUS\n\r\n\rSet the keyboard focus to a given control. If the control is a button, it receives keyboard focus. If the control is a text box, the caret is placed in the text box to allow the user to edit the text.\n\r\n\rCONTROL SET FONT\n\r\n\rSelect a font to be used for a particular control.\n\r\n\rCONTROL SET IMAGE\n\r\n\rChange the image on an image button or image control. Also see CONTROL SET IMAGEX.\n\r\n\rCONTROL SET SIZE\n\r\n\rChange the size of a control.\n\r\n\rCONTROL SET LOC\n\r\n\rChange the location of a control within its parent dialog.\n\r\n\rCONTROL SET TEXT\n\r\n\rPlace new text into a control. Any existing text in the control is replaced.\n\r\n\rWINDOW GET ID\n\r\n\rReturns the Control ID for a given control.\n\r\n\rWINDOW GET PARENT\n\r\n\rReturns the handle of a controls parent.\n\r\n\r&nbsp;\n\r\n\rFor a more comprehensive list of DDT statements and functions, See the Command Summary for DDT.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rDynamic Dialog Tools (DDT)\n\r\n\rCreating a Dialog\n\r\n\rAdding Controls to the Dialog\n\r\n\rModal vs. Modeless\n\r\n\rControl Styles\n\r\n\rCallbacks\n\r\n\rDialog Styles\n\r\n\rMenus","Controls","scr\\html_ddtcontrols.htm","                  \n\r\n\rWhen creating child controls for your dialogs, you are free to use almost any control style permitted by Windows. These styles mostly start with the %WS_ prefix (Window Style), and are included in the WIN32API.INC file included in your WINAPI directory.\n\r\n\rIf the style parameter in your CONTROL ADD statements is set to 0, DDT will set default styles automatically for you. The default styles will depend on the type of control you are adding to your dialog. For example, a button will be given the %WS_TABSTOP style.\n\r\n\rNote that DDT always gives your controls certain styles, such as %WS_CHILD and %WS_VISIBLE, regardless of the styles you specify. When setting your style parameter, you can safely ignore these two styles and concentrate on the more important styles that are required. This has the advantage of reducing the clutter of your code. The exception is custom controls - in this case you must explicitly specify all required styles.\n\r\n\rThe &quot;tab-order&quot; of controls (also known as the &quot;z-order&quot;) is determined by the order that DDT controls are created at run-time. That is, the first control added to a dialog is the first control in the z-order, the second control added is second, and so forth. When a dialog is initially displayed, keyboard focus is automatically given to the first control in the z-order that has the %WS_TABSTOP style. Each time the TAB key is subsequently pressed, the keyboard focus moves to the next control in the tab-order. To ensure all controls in a dialog can be selected using the TAB key, each control in the dialog should include the %WS_TABSTOP style. The z-order also determines the order that controls are drawn on a dialog, to help ensure that control that overlap one another can be drawn in a predictable manner.\n\r\n\rControls that are disabled (because either they have the %WS_DISABLED style or they have been dynamically disabled with CONTROL DISABLE) are skipped over.\n\r\n\rMost DDT controls are created with the %WS_TABSTOP style by default. However, you should explicitly include the %WS_TABSTOP style in the control style parameter, if your DDT code creates controls with custom (non-default) styles. If you do not include this style, these control(s) may not be able to receive keyboard focus.\n\r\n\rThe following table lists the default DDT styles for many of the standard controls:\n\r\n\rControl type\n\r\n\rDefault DDT Styles \n\r\n\rHex Value\n\r\n\rBUTTON\n\r\n\r%WS_TABSTOP\n\r\n\r50010000\n\r\n\rCHECK3STATE\n\r\n\r%WS_TABSTOP, {%BS_AUTO3STATE}\n\r\n\r50010006\n\r\n\rCHECKBOX\n\r\n\r%WS_TABSTOP, {%BS_AUTOCHECKBOX}\n\r\n\r50010003\n\r\n\rCOMBOBOX\n\r\n\r%WS_TABSTOP, %CBS_SORT, %CBS_DROPDOWN, {%CBS_HASSTRINGS}\n\r\n\r50010302\n\r\n\rFRAME\n\r\n\r%BS_LEFT, {%BS_TOP, %BS_GROUPBOX}\n\r\n\r50000507\n\r\n\rGRAPHIC\n\r\n\r%WS_CHILD, %WS_VISIBLE, %SS_OWNERDRAW\n\r\n\r5001000D\n\r\n\rIMAGE\n\r\n\reither {%SS_ICON}\n\r\n\ror {%SS_BITMAP}\n\r\n\r50000003\n\r\n\r5000000E\n\r\n\rIMAGEX\n\r\n\reither {%SS_ICON}\n\r\n\ror {%SS_BITMAP}\n\r\n\r50000003\n\r\n\r5000000E\n\r\n\rIMGBUTTON\n\r\n\reither %WS_TABSTOP, {%BS_ICON}\n\r\n\ror %WS_TABSTOP, {%BS_BITMAP}\n\r\n\r50010040\n\r\n\r50010080\n\r\n\rIMGBUTTONX\n\r\n\reither %WS_TABSTOP, {%BS_ICON}\n\r\n\ror %WS_TABSTOP, {%BS_BITMAP}\n\r\n\r50010040\n\r\n\r50010080\n\r\n\rLABEL\n\r\n\r%SS_LEFT\n\r\n\r50000000\n\r\n\rLINE\n\r\n\r%SS_ETCHEDFRAME\n\r\n\r50000012\n\r\n\rLISTBOX\n\r\n\r%WS_TABSTOP, %LBS_SORT, %LBS_NOTIFY, %WS_VSCROLL\n\r\n\r50210003\n\r\n\rLISTVIEW\n\r\n\r%WS_TABSTOP, %LVS_REPORT, &nbsp;%LVS_SHOWSELALWAYS\n\r\n\r50000009\n\r\n\rOPTION\n\r\n\r%WS_TABSTOP, {%BS_AUTORADIOBUTTON}\n\r\n\r50010009\n\r\n\rPROGRESSBAR\n\r\n\r%WS_BORDER\n\r\n\r50800000\n\r\n\rSCROLLBAR\n\r\n\reither {%SBS_HORZ}\n\r\n\ror {%SBS_VERT}\n\r\n\r50000000\n\r\n\r50000001\n\r\n\rSTATUSBAR\n\r\n\r%CCS_BOTTOM\n\r\n\r50000003\n\r\n\rTAB\n\r\n\r%WS_CHILD, %WS_TABSTOP\n\r\n\r54010000\n\r\n\rTEXTBOX\n\r\n\r%WS_TABSTOP, %WS_BORDER, %ES_AUTOHSCROLL, %ES_LEFT\n\r\n\r50810080\n\r\n\rTOOLBAR\n\r\n\r%WS_CHILD, %WS_VISIBLE, %WS_BORDER, %CCS_TOP, and &nbsp;%TBSTYLE_FLAT\n\r\n\r50808801\n\r\n\rTREEVIEW\n\r\n\r%WS_TABSTOP, %TVS_HASBUTTONS, %TVS_LINESATROOT, %TVS_HASLINES, and %TVS_SHOWSELALWAYS\n\r\n\r50010027\n\r\n\r&quot;custom control&quot;\n\r\n\rNo default style (%WS_CHILD and %WS_VISIBLE not used)\n\r\n\r0\n\r\n\r \n\r\n\rSee Also\n\r\n\rDynamic Dialog Tools (DDT)\n\r\n\rCreating a Dialog\n\r\n\rAdding Controls to the Dialog\n\r\n\rModal vs. Modeless\n\r\n\rControls\n\r\n\rCallbacks\n\r\n\rDialog Styles\n\r\n\rMenus","Control Styles","scr\\html_ddtcontrolstyles.htm","","","scr\\html_debugger_evaluate_dialog box.htm","                  \n\r\n\r\n\r\n\rBreak on Error\n\r\n\rCauses the debugger to stop after every statement to check the error status and then automatically halt program execution when an error occurs (non-zero ERR value). In debugging with this setting enabled, programmed loop structures with larger iteration counts can reduce debugging speed to unacceptable levels. For best results, it is instead recommend to enable #DEBUG ERROR ON in your program instead of this option.\n\r\n\rAnimate Delay\n\r\n\rThe debugger\'s Animate debug mode pauses for at least the given amount of time before execution of the next line of code occurs. Animation is very useful for watching the general flow of a program. The delay is specified in milliseconds (mSec). The larger the delay value, the greater the delay between execution of lines of code. The default value is set for 333 milliseconds (1/3 of a second).\n\r\n\rShow Exceptions\n\r\n\rChoose the exceptions (Success, Informational, Warning, Error) you want the debugger to display.","Debugger tab","scr\\html_debugger_preferences.htm","                  \n\r\n\r \n\r\n\rCreate a new empty document (file) in the editor.\n\r\n\r \n\r\n\rUse the Open File dialog box to load an existing document.\n\r\n\r \n\r\n\rPrint the current document to a printer.\n\r\n\r \n\r\n\rCopy the selected text from the document to the clipboard.\n\r\n\r \n\r\n\rSearch the current document for a word or phrase. See Find dialog for more information.\n\r\n\r \n\r\n\rLaunch the Go to Line dialog to jump to a specific line in the current document.\n\r\n\r \n\r\n\rLaunch the Code Finder dialog, which presents a list of Subs, Functions, Methods, Properties, and Macros in current document, to quickly jump to a selected section of code.\n\r\n\r\n\r\n\rBegin running the program. It will continue to run until the debugger either encounters a breakpoint, or runs out of code to execute. F5 is the hot-key for the Run option.\n\r\n\r\n\r\n\rThe debugger runs the program using an automated Step-Into technique. Execution continues until a breakpoint is reached, the Stop button is pressed, or the program completes. The Animate delay can be set through the IDE\'s Options Dialog.\n\r\n\r\n\r\n\rThe debugger executes the current line of code. If the line contains a reference to a Sub, Function, Method, or Property, the debugger executes that code without tracing into the procedure. SHIFT+F8 is the Step Over hot-key.\n\r\n\r\n\r\n\rIf the current line contains a call to a Sub, Function, Method, or Property, the debugger traces execution into that procedure. You cannot step into an API call, or into an external module. F8 is the Step Into hot-key.\n\r\n\r\n\r\n\rThe debugger runs the code until the current Sub, Function, Method, or Property exits. If the current function is PBMAIN or WINMAIN, the code is executed until the program is finished or another breakpoint is encountered. CTRL+SHIFT+F8 is the Step Out hot-key.\n\r\n\r\n\r\n\rHalt the debugger. If the debugger is already halted, this has no effect.\n\r\n\r\n\r\n\rShow or hide the Register Watcher window, which lets you see the state of the CPU registers and flags when debugging.\n\r\n\r&nbsp;\n\r\n\r\n\r\n\rShow or hide the Variable Watcher window, which lets you see the state of the ERR function and any variables you choose to watch when debugging.\n\r\n\r\n\r\n\rHalts the current program and terminates the debugger. The variable list in the Watch window is retained between debugging sessions, until the IDE is closed.\n\r\n\r\n\r\n\rLaunches the PowerBASIC web site.\n\r\n\r \n\r\n\rDisplay the PowerBASIC or the WIN32.HLP file.","Debugger Toolbar Buttons","scr\\html_debugger_toolbar_buttons.htm","                  \n\r\n\rFor our first example, we\'ll use a simple program designed to read a text file and display it. Along the way, the program counts the number of words and tabulates the lengths of all words found - how many words are one character long, how many are exactly two characters long, and so on. The sample program, TWORD.BAS (\\PBWin10\\Samples\\TWord\\TWORD.BAS), contains a number of bugs; you will be using the PowerBASIC integrated debugger to find each of them.\n\r\n\rBe sure to make copies of the TWORD.DAT data file; TWORD.BAS reads that file and makes specific errors because of the data. While another data file may work as well, it is possible that one or more of the bugs will not occur if you use a different data file.\n\r\n\rHere is a listing of the TWORD.BAS program.\n\r\n\rWhen you have loaded TWORD.BAS into the editor, click on the Debugger button on the toolbar, or select Run from the menu, then Compile and Debug.\n\r\n\rAt this point, the debugger will have scrolled the program and highlighted the line containing the definition of the variable MaxWordLen, since that will be the first line executed when the program begins to run. The highlight is called the execution bar and marks the line of code at the execution position. In other words, that line will be executed next.\n\r\n\rTo make the program run, click on the Run button in the toolbar or press F5. The program\'s output appears in the User screen, which allows you to see how the program would look if you weren\'t using the debugger. If the User screen is not visible you may have to select it by using the Windows Taskbar, ALT+TAB, or by re-sizing the PowerBASIC IDE to a smaller size and different location until the User screen is visible. TWORD prompts you for the name of the file to read. Enter TWORD.DAT and press ENTER. TWORD displays the first line of the file then locks up because of one of the bugs in the program. To regain control, click on the Stop button. You can choose Program Reset (or press the SHIFT+F5 hot-key) to quit running the flawed program. Clicking the Run button lets you restart the program.\n\r\n\r&nbsp;\n\r\n\rNext See: Setting and using breakpoints\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rDebugging PB/Win Programs\n\r\n\rHow the integrated debugger works\n\r\n\rThe DEBUG Menu\n\r\n\rThe Integrated Development Environment\n\r\n\rDebugger Settings","Debugging a simple program","scr\\html_debugging_a_simple_program_.htm","                  \n\r\n\rThe following functions can be used to trap and manage error conditions:\n\r\n\r#DEBUG CODE\n\r\n\rCompiler directive to suppress generation of debugging code.\n\r\n\r#DEBUG DISPLAY\n\r\n\rDisplay a message when an untrapped run-time error occurs.\n\r\n\r#DEBUG ERROR\n\r\n\rControl generation of error checking code.\n\r\n\r#DEBUG PRINT\n\r\n\rDisplay information in the IDE\'s Debug Window.\n\r\n\r#DIM\n\r\n\rSpecify if variables must be declared before use.\n\r\n\r#STACK\n\r\n\rSet the maximum potential stack size.\n\r\n\r#TOOLS\n\r\n\rEnable/disable integrated development tools in compiled code.\n\r\n\rCALLSTK\n\r\n\rCapture a representation of the stack frames in the call stack.\n\r\n\rCALLSTK$\n\r\n\rRetrieve the details of a specific stack frame.\n\r\n\rCALLSTKCOUNT\n\r\n\rRetrieve the number of stack frames in the call stack.\n\r\n\rERL\n\r\n\rReturn the line number of the most recent run-time error.\n\r\n\rERL$\n\r\n\rReturn the last label, line number, or procedure name executed prior to the most recent error.\n\r\n\rERR\n\r\n\rReturn the error code of the most recent run-time error.\n\r\n\rERRCLEAR\n\r\n\rReturn and clear the error code of the most recent run-time error.\n\r\n\rERROR\n\r\n\rCause a specific run-time error to be generated and set ERR.\n\r\n\rERROR$\n\r\n\rReturn a string containing the descriptive name of an error.\n\r\n\rFILENAME$\n\r\n\rReturn the file-system name of an open file.\n\r\n\rFUNCNAME$\n\r\n\rReturn the name of the current Sub/Function/Method/Property.\n\r\n\rON ERROR\n\r\n\rSpecify an error handling routine; enable/disable trapping.\n\r\n\rOPTION EXPLICIT\n\r\n\rForce explicit declaration of all variables.\n\r\n\rPROFILE\n\r\n\rCapture an execution time profile of the Subs, Functions, Methods, and Properties.\n\r\n\rRESUME\n\r\n\rContinue execution after error handling with ON ERROR GOTO.\n\r\n\rRESUME FLUSH\n\r\n\rExecution continues on the line immediately following the RESUME FLUSH.\n\r\n\rRESUME NEXT\n\r\n\rExecution continues on the line immediately following the one which generated the error.\n\r\n\rRESUME &lt;Label&gt;\n\r\n\rExecution continues at the specified label location.\n\r\n\rTRACE\n\r\n\rCapture the precise flow of execution in a module.\n\r\n\rTRY/END TRY\n\r\n\rA structured method of trapping and responding to errors.","Debugging and Error Control","scr\\html_debugging_and_error_control_functions.htm","                  \n\r\n\rOnce your code is written, the next step is to test it to make sure it performs according to specifications. Regardless of the computer language used, certain programming errors are common: misspelled or misused variables, inverted logical tests, mistakes in syntax, and &quot;reasonable&quot; tests that cause disastrous failures when unreasonable data is supplied. Each language also has its own common errors, unique because of the peculiarities of its language.\n\r\n\rSome of BASIC\'s unique problems include the free conversion of most numeric data types, side effects of global variables, default data types, and overuse of GOTO causing problems with incorrect branching. These are well known to the experienced BASIC programmer but are not generally found in other languages.\n\r\n\rThe PowerBASIC Integrated Development Environment (PBEDIT.EXE) can be used to find, and correct, both general programming errors and errors specific to BASIC. Nearly every program has bugs at least at first. To find them, you may need to check any statement in the program, display the value of any variable, and observe the program flow from line to line. PBEDIT has all these capabilities and more.\n\r\n\rThis section explains how to use PBEDIT to find and fix errors in a sample program, by providing a list of the debugging commands, a description of each, and then showing how each is invoked. If you follow certain guidelines when creating your program, you will find debugging easier (and less necessary). The procedures we describe here will help you form your own set of guidelines that will make your programs easier to write and maintain.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rHow the integrated debugger works\n\r\n\rThe DEBUG Menu\n\r\n\rDebugging a simple program\n\r\n\rThe Integrated Development Environment\n\r\n\rDebugger Settings","Debugging PB/Win Programs","scr\\html_debugging_pbwin_programs.htm","                  \n\r\n\rTWORD fails because the program goes into an infinite loop. The infinite loop was caused by the fact that the number of characters removed was not shortening the input string.\n\r\n\rWhile tracking down this bug, you learned to:&#183;Set and use breakpoints&#183;Run a program without stopping at each line&#183;Step through your source one line at a time&#183;Evaluate the values of variables\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rDebugging PB/Win Programs\n\r\n\rHow the integrated debugger works\n\r\n\rThe DEBUG Menu\n\r\n\rDebugging a simple program\n\r\n\rDebugger Settings","Summary","scr\\html_debugging_tword_bas_summary.htm","                  \n\r\n\rPurpose\n\r\n\rConvert an integral value to a decimal string.\n\r\n\rSyntax\n\r\n\rs$ = DEC$(IntVal [, Digits, LeadSpaces, TrailSpaces])\n\r\n\rRemarks\n\r\n\rIntVal is a numeric expression in the range of a 64-bit Quad Integer (-9223372036854775808 to +9223372036854775807). Any fractional part of the value is rounded. If the value is negative, the leading minus sign occupies one digit position. The result string is always formatted as an integral number using all the significant digits in IntVal. It is never expressed in scientific notation.\n\r\n\rIf Digits is 0 (or not given), no leading characters will be added to the numeric field. If Digits is a positive number greater than 0, the result string will be prepended with leading zeros to achieve the desired length. If Digits is a negative number, leading spaces are added to reach the absolute length. Digits may be in the range of -20 to +20.\n\r\n\rLeadSpaces specifies additional leading spaces to be prepended, regardless of the length of the numeric portion of the string.\n\r\n\rTrailSpaces specifies additional trailing spaces to be appended to the end of the string.\n\r\n\rSee also\n\r\n\rBIN$, FORMAT$, HEX$, OCT$, STR$, TRIM$, USING$, VAL","DEC$ function","scr\\html_dec$_function.htm","                  \n\r\n\rPurpose\n\r\n\rExplicitly declare a Sub or Function.\n\r\n\rSyntax\n\r\n\rDECLARE SUB ProcName [ALIAS &quot;AliasName&quot;] [(arguments)] &lt;Descriptors&gt;\n\r\n\rDECLARE FUNCTION ProcName [ALIAS &quot;AliasName&quot;] [(arguments)] &lt;Descriptors&gt; AS RetType\n\r\n\rDECLARE CALLBACK FUNCTION ProcName [[()] AS LONG]\n\r\n\rDECLARE THREAD FUNCTION ProcName (BYVAL var AS (LONG | DWORD}) AS {LONG | DWORD}\n\r\n\rRemarks\n\r\n\rThe DECLARE statement has the following parts:\n\r\n\rProcName\n\r\n\rThe name of the Sub or Function to be declared. For Functions, a type-specifier may be appended (just like an ordinary variable name) to specify the data type of the Function\'s return value, in place of the [AS RetType] clause.\n\r\n\rFuture versions of PowerBASIC will not support type-specifier symbols for the Function return type. Specify the return data type with an explicit AS RetType clause in all DECLARE and FUNCTION definitions to ensure future compatibility.\n\r\n\rALIAS\n\r\n\rAn alias clause may be used to specify an alternate name to be used for imported or exported procedures. This allows you to interact with outside modules (DLL or EXE) using a different procedure name. The alias name must be specified by a string literal which provides the name and capitalization of the procedure in the external DLL.\n\r\n\rThis option is particularly useful if you want to abbreviate a long name, or if the original name of a function contains characters that are illegal in PowerBASIC. The alias name is the actual name used in the other module, while the ProcName is the word you use in your PowerBASIC program. For example:\n\r\n\rDECLARE SUB ShortName ALIAS &quot;VeryLongProcName&quot;()\n\r\n\rDECLARE FUNCTION LegalName ALIAS &quot;Illegal$Name&quot;()\n\r\n\rAlthough a ProcName must be unique, you may use the same AliasName in multiple declarations. This is particularly useful for avoiding AS ANY in cases where a procedure is designed to receive several different types of parameters.\n\r\n\rDECLARE FUNCTION AddAtom &nbsp; &nbsp;LIB &quot;KERNEL32.DLL&quot; ALIAS &quot;AddAtomA&quot; (lpString AS STRINGZ) AS WORD\n\r\n\rDECLARE FUNCTION AddIntAtom LIB &quot;KERNEL32.DLL&quot; ALIAS &quot;AddAtomA&quot; (BYVAL lpString AS DWORD) AS WORD\n\r\n\rThe ALIAS clause is very important when importing or exporting Subs and Functions from DLLs. Omitting the ALIAS clause or incorrectly capitalizing the alias name are common causes of DLL load failure problems. Please refer to the SUB and FUNCTION sections for more information.\n\r\n\r&nbsp;\n\r\n\rDescriptors\n\r\n\r&nbsp;\n\r\n\rYou may optionally add one or more descriptor words (Import, Export, Common, Private, ThreadSafe, BDecl, CDecl, SDecl) to provide specific functionality. They may be added to the DECLARE as a comma delimited list. You should note that some of them are mutually exclusive.\n\r\n\rIMPORT\n\r\n\rA string literal or equate that specifies the name of the module in which an imported procedure is located. This allows you to call Subs or Functions that reside in DLLs. The legacy word LIB may be substituted for IMPORT.\n\r\n\rEXPORT\n\r\n\rThis descriptor identifies a Sub or Function which may be accessed between Dynamic Link Libraries (DLLs), and/or the main executable which links them. If a procedure is not marked EXPORT, it is hidden from these other modules. The EXPORT attribute may be added to a Sub/Function defined elsewhere, by specifying EXPORT in a DECLARE statement. EXPORT can even be added to a Sub/Function in an SLL with a DECLARE in the host module.\n\r\n\rCOMMON\n\r\n\rA COMMON Sub/Function is one which may be called between linked unit modules (Host or SLL). If the Common Sub/Function is not present in this module, it is presumed to be found in a separate linked module (Host or SLL). It is not necessary to DECLARE a COMMON Sub or Function in the Host Module. If you choose to do so, it is generally advisable to omit the COMMON descriptor, as its presence will force the SLL to be linked, whether needed or not.\n\r\n\rPRIVATE\n\r\n\rA PRIVATE Sub/Function is one which may only be accessed from within the current PowerBASIC program or library. Even if not specified, this is the default mode of operation.\n\r\n\rTHREADSAFE\n\r\n\rWith the THREADSAFE option, PowerBASIC automatically establishes a semaphore which allows only one thread to execute the Sub/Function at a time. Other callers must wait until the first thread exits the THREADSAFE procedure before they are allowed to begin.\n\r\n\rBDECL\n\r\n\rSpecifies that the declared procedure uses the legacy BASIC/Pascal calling convention. Parameters are pushed on the stack from left to right, and the called procedure is responsible for removing them. BDECL should only be used when necessary to match outside modules.\n\r\n\rCDECL\n\r\n\rSpecifies that the declared procedure uses the C calling convention. Parameters are pushed on the stack from right to left, and the calling code is responsible for removing them. CDECL should only be used when necessary to match outside modules.\n\r\n\rWhen a procedure is imported or exported, PowerBASIC automatically creates a lowercase ALIAS, prefixed with an underscore. The following two declarations are equivalent, indicating how the default ALIAS name would be created by PowerBASIC:\n\r\n\rDECLARE SUB C_Function CDECL ()\n\r\n\rDECLARE SUB C_Function CDECL ALIAS &quot;_c_function&quot; ()\n\r\n\rSDECL\n\r\n\rThis is the default convention, and should be used whenever possible. SDECL (and its synonym STDCALL), specifies the &quot;Standard Calling Convention&quot; for Windows. Parameters are pushed on the stack from right to left, and the called procedure is responsible for removing them.\n\r\n\rCALLBACK\n\r\n\rCallback Functions are reserved for use with Dynamic Dialog Tools (DDT) functions. No parameters should be specified, as data is retrieved with the CALLBACK (CB) functions. Parentheses and the AS LONG return type may be added for clarity.\n\r\n\rTHREAD\n\r\n\rThread functions are reserved for use with the THREAD CREATE statement. It must take exactly one Long Integer parameter by value (BYVAL LONG), and must return a Long Integer value (AS LONG). It is permissible to substitute DWORD for both of these items.\n\r\n\r&nbsp;\n\r\n\rPassing parameters\n\r\n\rArguments\n\r\n\rContains the name(s) or the type of each parameter, in the order they are passed, for up to 32 parameters. If you wish to call a SUB or FUNCTION in a DLL, you must describe the target SUB or FUNCTION with an explicit DECLARE statement. The DECLARE must physically precede any reference to the target procedure.\n\r\n\rPrevious versions of PowerBASIC required that you create an explicit DECLARE statement if you wished to execute a SUB or function which did not physically precede the reference to it. This extra work is no longer required, as PowerBASIC resolves all forward references to internal procedures automatically.\n\r\n\rThe complete arguments list must be specified for each routine. Each parameter may be defined in one of three ways:&#183;List only its type name (INTEGER, DOUBLE, etc.)&#183;List a variable name with a type-specifier appended (count%, txt$)&#183;Use the AS clause to specify the type (count AS INTEGER, text AS STRING * 100, etc.).\n\r\n\rLegal type names for arguments include ANY, ASCIIZ, BYTE, CUR, CUX, DOUBLE, DWORD, EXT, INTEGER, LONG, PTR, QUAD, SINGLE, STRING, STRINGZ, WORD, WSTRING, WSTRINGZ and ARRAY. The ARRAY keyword is used in conjunction with one of the other types to specify an entire array of that type. For example:\n\r\n\rDECLARE SUB KerPlunk(INTEGER ARRAY, DOUBLE)\n\r\n\rdeclares a procedure called KerPlunk, which takes an entire Integer array and a Double-precision variable as parameters. You can also name the parameters using the AS keyword:\n\r\n\rDECLARE SUB KerPlunk(iArray() AS INTEGER, dVar AS DOUBLE)\n\r\n\rThe following four declare statements are equivalent:\n\r\n\rDECLARE SUB KerPlunk(x) \' if DEFINT A-Z is in effect\n\r\n\rDECLARE SUB KerPlunk(x%)\n\r\n\rDECLARE SUB Plunk(x AS INTEGER)\n\r\n\rDECLARE SUB KerPlunk(INTEGER)\n\r\n\rWhen parameters are passed by reference (BYREF), the address of the variable passed to the routine is placed on the stack. When they are passed by value (BYVAL), the actual data is placed on the stack. You can use the BYVAL or BYREF keywords to specify that a parameter should always be passed in a known format.\n\r\n\rUsing ANY disables type checking for a particular parameter, and passes the address of the variable on the stack. Since the internal format of variables differ greatly by type, you must use caution to be certain your code knows the data type in each invocation. Normally, a second parameter is used to specify the actual type of the ANY parameter.\n\r\n\rWhen a Sub/Function definition specifies either a BYREF parameter or a pointer variable parameter, the calling code may freely pass a BYVAL DWORD or a pointer instead. While the use of the explicit BYVAL override in the calling code is optional, it is recommended for clarity. It is necessary to explicitly declare all pointer parameters as BYVAL (BYVAL x AS BYTE PTR). Failure to do so will generate compile-time Error 549 (&quot;BYVAL required with pointers&quot;).\n\r\n\rAdditional information on BYVAL/BYREF/BYCOPY parameter passing can be found in the CALL statement topic.\n\r\n\r&nbsp;\n\r\n\rUsing OPTIONAL/OPT\n\r\n\rDECLARE statements may specify one or more parameters as optional by preceding the parameter with either the keyword OPTIONAL (or the abbreviation OPT). Optional parameters are only allowed with CDECL or SDECL calling conventions, not BDECL.\n\r\n\rWhen a parameter is declared optional, all subsequent parameters in the declaration are optional as well, whether or not they specify an explicit OPTIONAL or OPT directive. The following two lines are equivalent, with both second and third parameters being optional:\n\r\n\rDECLARE SUB sABC(a&amp;, OPTIONAL BYVAL b&amp;, OPTIONAL BYVAL c&amp;) AS LONG\n\r\n\rDECLARE SUB sABC(a&amp;, OPT BYVAL b&amp;, BYVAL c&amp;) AS LONG\n\r\n\rVARIANT variables are particularly well suited for use as an optional parameter. If the calling code omits an optional VARIANT parameter, (BYVAL or BYREF), PowerBASIC (and most other compilers) substitute a variant of type %VT_ERROR which contains an error value of %DISP_E_PARAMNOTFOUND (&amp;H80020004). In this case, you can check for this value directly, or use the ISMISSING() function to determine whether the parameter was physically passed or not.\n\r\n\rWhen optional parameters (other than VARIANT) are omitted in the calling code, the stack area normally reserved for those parameters is zero-filled.\n\r\n\rIf the parameter is defined as a BYVAL parameter, it will have the value zero. For TYPE or UNION variables passed BYVAL, the compiler will pass a string of binary zeroes of length SIZEOF(Type_or_union_var).\n\r\n\rIf the parameter is defined as a BYREF parameter, VARPTR (Varname) will equal zero; when this is true, any attempt to use Varname in your code will result in a General Protection Fault or memory corruption. You should use the ISMISSING() function first to determine whether it is safe to access the parameter.\n\r\n\rAS type\n\r\n\rYou may specify the type of data returned by a Function to the calling code. If you do not specify a type, PowerBASIC assumes that the Function returns the data type specified by a DEFtype statement. However, if no DEFtype or AS type has been specified, a compile-time error is generated.\n\r\n\rTherefore, there are two ways to specify the return type of a Function:&#183;Include a type-specifier character at the end of ProcName&#183;Include the AS type clause as the last part of the DECLARE statement (this is the recommended syntax to ensure compatibility with future versions of PowerBASIC).\n\r\n\rFor example, the following statements are equivalent:\n\r\n\rDECLARE FUNCTION aFunction?()\n\r\n\rDECLARE FUNCTION aFunction() AS BYTE\n\r\n\rWhile most FUNCTION calling conventions are fairly well defined throughout the industry, there are a few exceptions. In the case of functions which return a Quad Integer value, some programming languages (including PowerBASIC) return the quad value in the FPU, while others return it in EDX:EAX. PowerBASIC automatically detects the method used by imported functions and adjusts accordingly for you, but that\'s not a feature found in other compilers. Therefore, we recommend that you do not EXPORT QUAD FUNCTIONS unless they will only be accessed by PowerBASIC programs. A simple equivalent functionality would be to return the quad-integer value to the caller in a BYREF QUAD parameter.\n\r\n\rRestrictions\n\r\n\rA Sub/Function may be imported and exported within the same module. That is, a function in the module may be stated as EXPORT, while a DECLARE in the same module specifies it as an imported function by the option LIB &quot;filename.dll&quot;, as long as FILENAME.DLL is the name of the module. This may be particularly valuable when you wish to build an #INCLUDE file with all of the DECLARE statements for a project.\n\r\n\rSee also\n\r\n\r#EXPORT, #LINK, CALL, CALL DWORD, FASTPROC, FUNCTION/END FUNCTION, IMPORT, ISMISSING, SUB/END SUB, THREAD CREATE\n\r\n\rExample\n\r\n\r\' Main program\n\r\n\rDECLARE SUB Calculate LIB &quot;A.DLL&quot; (EXT, CUR, QUAD, INTEGER)\n\r\n\r\n\r\n\rCALL Calculate(w##, x@, y&amp;&amp;, z%)","DECLARE statement","scr\\html_declare_statement.htm","                  \n\r\n\rPurpose\n\r\n\rDecrement a variable by 1; Decrement a pointer by the size of its target; or decrement the target of a numeric pointer by 1.\n\r\n\rSyntax\n\r\n\rDECR variable\n\r\n\rRemarks\n\r\n\rvariable can be a numeric variable or a pointer variable. When DECR is used with a numeric variable, 1 is subtracted from the numeric variable.\n\r\n\rIf DECR is used on the target of a numeric pointer variable (i.e., DECR @IntPtr), the target numeric variable is decremented by one. However, when using DECR on a pointer variable, the value of the pointer variable is decremented by the size of its target.\n\r\n\rFor example, given a pointer to element 1000 of an Integer array, DECR of the pointer variable itself would result in a decrement of 2, which should point to the previous element in the array (element 999). This is because an Integer is two bytes wide, so the pointer value is reduced by 2 bytes.\n\r\n\rSee also\n\r\n\rINCR, LET\n\r\n\rExample\n\r\n\rDIM x&amp;, LongPtr AS LONG POINTER\n\r\n\rDECR x&amp;\n\r\n\rDECR LongPtr\n\r\n\rDECR @LongPtr","DECR statement","scr\\html_decr_statement.htm","                  \n\r\n\rIn most older versions of BASIC (including PowerBASIC for DOS), all variables without a TypeID (%, !, &amp;, etc.) are automatically considered to be single precision floating point. Other compilers have chosen other defaults (for example, VB defaults to Variant).\n\r\n\rTo avoid this ambiguity, PowerBASIC asks you to make this determination instead. You can use the DEF statement to specify your preferred default variable type to be applied to untyped variable names. For example, to mimic the single precision default of PB/DOS, simply add a DEFSNG statement to the top of your program:\n\r\n\rDEFSNG A-Z\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rVariables\n\r\n\rVariable Scope","Default Variable Typing","scr\\html_default_variable_typing.htm","                  \n\r\n\rPurpose\n\r\n\rDeclare the default type for variable identifiers that begin with specified letters.\n\r\n\rSyntax\n\r\n\rDEFtype letter_range [, letter_range] [, ...]\n\r\n\rRemarks\n\r\n\rtype represents one of PowerBASIC\'s variable types: INT (Integer), LNG (Long-integer), QUD (Quad-integer), SNG (Single-precision floating-point), DBL (Double-precision floating-point), EXT (Extended-precision floating-point), CUR (Currency), CUX (Extended-currency), STR (String), BYT (Byte), WRD (Word), and DWD (Double-word).\n\r\n\rletter_range\n\r\n\ris either a single alphabetic character (A through Z, case insignificant), or a range of letters (two letters separated by a hyphen, for example, A-M).\n\r\n\rDEFtype\n\r\n\rTells the compiler that variables and user-defined functions, whose names begin with the specified letter or range of letters, are of the specified type.\n\r\n\rNormally, when the compiler finds a variable name without a type specifier, a compile-time error is generated. If however, there was a preceding DEFtype statement such as DEFINT A-Z, the variable would default to that type (in this case, an Integer variable).\n\r\n\rYou may use multiple DEFtype statements. If there is overlap between two DEFtype statements, no error is generated; but the definition of the latter DEFtype statement overrides the former where the two overlap.\n\r\n\rThe DEFtype statement may not be supported in future editions of PowerBASIC, so we recommend explicit variable declarations, using DIM, INSTANCE, LOCAL, STATIC, THREADED, or GLOBAL.\n\r\n\rRestrictions\n\r\n\rDeftype only applies to implicitly-defined variables. It has no effect on variables that are defined explicitly. If a #DIM ALL statement exists in the application then Deftype statements will have no effect, #DIM ALL requires all variables to be defined explicitly\n\r\n\rExample\n\r\n\rDEFINT A-E, G, Q, Y-Z\n\r\n\rDEFCUX B, F, H-P, R-X\n\r\n\rFUNCTION PBMAIN\n\r\n\r &nbsp;A = 1 &nbsp;\' A is Integer\n\r\n\r &nbsp;B = 2 &nbsp;\' B is Extended-currency.\n\r\n\r &nbsp;[statements]\n\r\n\rEND FUNCTION\n\r\n\rSee Also\n\r\n\r#DIM ALL, DIM, INSTANCE, LOCAL, STATIC, THREADED, GLOBAL","DEFWRD statement","scr\\html_defbyt_defcur_defcux_defdbl_defdwd_defext_defint_deflng.htm","                  \n\r\n\rPB/Win constants (also known as equates) are defined by prefixing the name of the constant with a &quot;%&quot; character. MSBASIC and VB define constants with the CONST keyword. The MSBASIC/VB compiler then does type conversions at the point of use, if the constant\'s type was not specified. That overhead does not happen (and is not necessary) with PB/Win. String equates are specified with a leading &quot;$&quot; character.\n\r\n\rHowever, the MACRO facilities in PB/Win offer a way to retain the CONST syntax in your code, while maintaining the low overhead advantage of PowerBASIC. For example:\n\r\n\rMACRO CONST = MACRO\n\r\n\r[statements]\n\r\n\rCONST Something = 1&amp;\n\r\n\rCONST Something_Else = 2???\n\r\n\rCONST AppTitle = &quot;My Application&quot;\n\r\n\r[statements]\n\r\n\rMSGBOX FORMAT$(Something), ,AppTitle\n\r\n\rDuring compilation, the CONST keyword is replaced by the MACRO word, which dynamically creates a new macro that, in turn, defines a constant.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rConstants and Literals\n\r\n\rNumeric Equates\n\r\n\rBuilt-in numeric equates\n\r\n\rBuilt In RGB Color Equates\n\r\n\rString Equates\n\r\n\rBuilt-in string equates","Defining Constants","scr\\html_defining_constants.htm","                  \n\r\n\rThe definition of a User-Defined Type begins with the reserved word TYPE and ends with the keywords END TYPE. In between, you define the names and data typesof the member elements (fields) that are to be part of the new Type. For example:\n\r\n\rTYPE StudentRecord\n\r\n\r &nbsp;LastName &nbsp; &nbsp; AS STRING * 20 \' A 20-character string\n\r\n\r &nbsp;FirstName &nbsp; &nbsp;AS STRING * 15 \' A 15-character string\n\r\n\r &nbsp;IDnum &nbsp; &nbsp; &nbsp; &nbsp;AS LONG &nbsp; &nbsp; &nbsp; &nbsp;\' Student ID, a Long-integer\n\r\n\r &nbsp;Contact &nbsp; &nbsp; &nbsp;AS STRING * 30 \' Emergency contact person\n\r\n\r &nbsp;ContactPhone AS STRING * 14 \' Their phone number\n\r\n\r &nbsp;ContactRel &nbsp; AS STRING * 8 &nbsp;\' Relationship to student.\n\r\n\r &nbsp;AverageGrade AS SINGLE &nbsp; &nbsp; &nbsp;\' Single-precision % grade\n\r\n\rEND TYPE\n\r\n\rRemember that the definition of a User-Defined Type does not set aside memory for storing data of that Type. Rather, it defines a template for the new Type StudentRecord. Then when the compiler encounters a statement declaring (or creating) a variable of the new Type, it will &quot;know&quot; how many bytes of storage to set aside for the variable. In order to use this new Type, you must declare variables of that Type with the DIM statement:\n\r\n\rDIM Student AS StudentRecord\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rUser-Defined Types (UDTs)\n\r\n\rAccessing the fields of a User-Defined Type\n\r\n\rNesting User-Defined Types\n\r\n\rArrays within User-Defined Types\n\r\n\rUsing arrays of User-Defined Types\n\r\n\rUsing User-Defined Types with procedures\n\r\n\rStorage requirements and restrictions\n\r\n\rUnions","Defining User-Defined Types","scr\\html_defining_user_defined_types.htm","                  \n\r\n\rPurpose\n\r\n\rRetrieve the size of the client area of the desktop, in pixels.\n\r\n\rSyntax\n\r\n\rDESKTOP GET CLIENT TO ncWidth&amp;, ncHeight&amp;\n\r\n\rRemarks\n\r\n\rThe desktop client size is the part of the screen that is not obscured by the system tray.\n\r\n\rThis can be used in combination with DESKTOP GET LOC or DESKTOP GET SIZE for exact positioning of windows on the desktop.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, DESKTOP GET LOC, DESKTOP GET SIZE","DESKTOP GET CLIENT statement","scr\\html_desktop_get_client_statement.htm","                  \n\r\n\rPurpose\n\r\n\rRetrieve the location of the top, left corner of the client area of the desktop, in pixels.\n\r\n\rSyntax\n\r\n\rDESKTOP GET LOC TO x&amp;, y&amp;\n\r\n\rRemarks\n\r\n\rThe desktop client area is the part of the screen that is not obscured by the system tray. The system tray\'s position on the screen determines the upper, left position of the client area. If the tray is located at the bottom of the screen (default), left and top coordinates are 0,0. If the tray is located on the right side of the screen, left and top coordinates are 0,0. If the tray is located on the left side of the screen, left and top coordinates are &nbsp;TrayWidth,0. If the tray is located at the top of the screen, left and top coordinates are &nbsp;0,TrayHeight.\n\r\n\rThis can be used in combination with DESKTOP GET CLIENT or DESKTOP GET SIZE for exact positioning of windows on the desktop.\n\r\n\rSee also\n\r\n\rDESKTOP GET CLIENT, DESKTOP GET SIZE","DESKTOP GET LOC statement","scr\\html_desktop_get_loc_statement.htm","                  \n\r\n\rPurpose\n\r\n\rRetrieve the size of the entire desktop, in pixels.\n\r\n\rSyntax\n\r\n\rDESKTOP GET SIZE TO ncWidth&amp;, ncHeight&amp;\n\r\n\rRemarks\n\r\n\rThe desktop size includes the space taken up by the system tray and is same as the screen size. This can be used in combination with DESKTOP GET CLIENT or DESKTOP GET LOC for exact positioning of windows on the desktop.\n\r\n\rSee also\n\r\n\rDESKTOP GET CLIENT, DESKTOP GET LOC","DESKTOP GET SIZE statement","scr\\html_desktop_get_size_statement_.htm","                  \n\r\n\rPurpose\n\r\n\rDisable a dialog so that it no longer receives any mouse or keyboard messages.\n\r\n\rSyntax\n\r\n\rDIALOG DISABLE hDlg\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog you want to disable. A disabled dialog will not receive any messages when it is clicked with the mouse or selected with the keyboard. Disabling a dialog that is already disabled has no effect.\n\r\n\rIf the dialog has a Callback Function, a %WM_ENABLE message is sent to the Callback Function before DIALOG DISABLE finishes.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, DIALOG ENABLE, DIALOG HIDE, DIALOG NORMALIZE, DIALOG SHOW MODAL, DIALOG SHOW MODELESS, DIALOG SHOW STATE","DIALOG DISABLE statement","scr\\html_dialog_disable.htm","                  \n\r\n\rPurpose\n\r\n\rProcess pending window or dialog messages for MODELESS dialogs. If there are no pending messages, DIALOG DOEVENTS pauses execution of the current thread for a length of time specified by the programmer.\n\r\n\rSyntax\n\r\n\rDIALOG DOEVENTS [sleep&amp;] [TO count&amp;]\n\r\n\rRemarks\n\r\n\rDIALOG DOEVENTS is usually used to create a &quot;message pump&quot; for modeless dialog boxes.\n\r\n\rIf a window message is pending, it is processed appropriately. If no messages are pending, execution of the current thread is paused for the time specified by the sleep&amp; parameter. If sleep&amp; is zero (0), the remainder of the current time slice is relinquished to other threads or processes. If sleep&amp; is greater than zero, the current thread is paused for that number of milliseconds to allow other threads or processes to continue. If sleep&amp; is not specified, it defaults to a value of one (1). During the sleep period, all time-slices for the current thread are given to other threads and processes. If there are no other threads of equal priority, execution continues immediately. The time-slice duration (also known as the Quantum) can vary from version to version of Windows, ranging from 20 mSec to 120 mSec. If the optional TO clause is included, the number of active dialogs is returned in the count&amp; variable, once all of the pending messages have been processed.\n\r\n\rRestrictions \n\r\n\rThe DIALOG DOEVENTS loop must run for the duration of the modeless dialog(s), or they will not respond or be redrawn correctly.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, DIALOG NEW, DIALOG SHOW MODELESS, SLEEP\n\r\n\rExample\n\r\n\r\' Single modeless dialog message pump example.\n\r\n\r\' (Assume dialog already created with DIALOG NEW)\n\r\n\rDIALOG SHOW MODELESS hDlg CALL DlgCallback\n\r\n\rDO\n\r\n\r &nbsp;DIALOG DOEVENTS 0 TO Count&amp;\n\r\n\rLOOP WHILE Count&amp;\n\r\n\r\' Application code continues here...\n\r\n\r&nbsp;\n\r\n\r\' Multiple modeless dialog message pump example.\n\r\n\r\' In some applications, the number of modeless dialogs can vary at any given moment,\n\r\n\r\' we want to break the message loop when the \'main\' dialog is closed.\n\r\n\r\' (Assume dialogs already created with DIALOG NEW)\n\r\n\rDIALOG SHOW MODELESS hMainDlg&amp; CALL DlgCallback\n\r\n\rDIALOG SHOW MODELESS hChildDlg1&amp;\n\r\n\rDIALOG SHOW MODELESS hChildDlg2&amp;\n\r\n\r[statements]\n\r\n\rDO\n\r\n\r &nbsp;DIALOG DOEVENTS\n\r\n\rLOOP WHILE ISWIN(hMainDlg&amp;)\n\r\n\r\' Application code continues here...","DIALOG DOEVENTS statement","scr\\html_dialog_doevents.htm","                  \n\r\n\rPurpose\n\r\n\rEnable a dialog so that it can receive messages when the user interacts with it via the mouse or keyboard.\n\r\n\rSyntax\n\r\n\rDIALOG ENABLE hDlg\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog you want to enable. An enabled dialog will receive messages when it is clicked with the mouse or selected with the keyboard. Enabling a dialog has no effect if the dialog is already enabled.\n\r\n\rIf the dialog has a Callback Function, a %WM_ENABLE message is sent to the Callback Function before DIALOG ENABLE finishes.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, DIALOG DISABLE, DIALOG HIDE, DIALOG NORMALIZE, DIALOG SHOW MODAL, DIALOG SHOW MODELESS, DIALOG SHOW STATE","DIALOG ENABLE statement","scr\\html_dialog_enable.htm","                  \n\r\n\rPurpose\n\r\n\rClose and destroy the specified dialog.\n\r\n\rSyntax\n\r\n\rDIALOG END hDlg [, lResult&amp;]\n\r\n\rRemarks\n\r\n\rThe dialog specified by the hDlg variable is destroyed.\n\r\n\rlResult&amp; optionally specifies a value to return to the DIALOG SHOW MODAL or DIALOG SHOW MODELESS statement that activated the dialog initially.\n\r\n\rRestrictions \n\r\n\rDIALOG END cannot close or destroy a dialog in a separate thread. In this case, send or post a message to the dialog to signal it to close, and respond to the message in the callback for the specified dialog. For example:\n\r\n\r\' Trigger a DIALOG END in a separate thread\n\r\n\rDIALOG SEND hDlg, %WM_SYSCOMMAND, %SC_CLOSE, 0\n\r\n\rDIALOG END cannot be used during processing of the %WM_INITDIALOG message. If this effect is necessary, the solution is to post a user-defined message to the dialog and use DIALOG END at that point. For example:\n\r\n\rCALLBACK FUNCTION MyDialogCallback\n\r\n\r &nbsp;SELECT CASE CB.MSG\n\r\n\r &nbsp; &nbsp;CASE %WM_INITDIALOG\n\r\n\r &nbsp; &nbsp; &nbsp;IF gMustEnd&amp; THEN _ \' We have to stop!\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;DIALOG POST CB.HNDL, %WM_USER+999&amp;, 0, 0\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;CASE %WM_USER + 999&amp;\n\r\n\r &nbsp; &nbsp; &nbsp;DIALOG END CB.HNDL\n\r\n\r &nbsp; &nbsp; &nbsp;FUNCTION = 1\n\r\n\r &nbsp;END SELECT\n\r\n\rEND FUNCTION\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, DIALOG NEW, DIALOG SHOW MODELESS, THREAD CREATE","DIALOG END statement","scr\\html_dialog_end.htm","                  \n\r\n\rPurpose\n\r\n\rSpecify the default DDT font information.\n\r\n\rSyntax\n\r\n\rDIALOG DEFAULT FONT fontname$ [,points&amp;, style&amp;, charset&amp;]\n\r\n\rLegacy syntax:\n\r\n\rDIALOG FONT [DEFAULT] fontname$ [,points&amp;, style&amp;, charset&amp;]\n\r\n\rfontname$\n\r\n\rName of the font.\n\r\n\rpoints&amp;\n\r\n\rSize of the font, in points.\n\r\n\rstyle&amp;\n\r\n\rFont style attribute.\n\r\n\r0\n\r\n\rNormal\n\r\n\r2\n\r\n\rItalic\n\r\n\rcharset&amp;\n\r\n\rCharSet identifier.\n\r\n\r0\n\r\n\rANSI CharSet\n\r\n\r162\n\r\n\rTurkish CharSet\n\r\n\r1\n\r\n\rDefault CharSet\n\r\n\r177\n\r\n\rHebrew CharSet\n\r\n\r2\n\r\n\rSymbol CharSet\n\r\n\r178\n\r\n\rArabic CharSet\n\r\n\r77\n\r\n\rMac CharSet\n\r\n\r186\n\r\n\rBaltic CharSet\n\r\n\r128\n\r\n\rShiftjis CharSet\n\r\n\r204\n\r\n\rRussian CharSet\n\r\n\r129\n\r\n\rHangeul CharSet\n\r\n\r222\n\r\n\rThai CharSet\n\r\n\r130\n\r\n\rJohab CharSet\n\r\n\r238\n\r\n\rEast Europe CharSet\n\r\n\r136\n\r\n\rChinese CharSet\n\r\n\r255\n\r\n\rOEM CharSet\n\r\n\r161\n\r\n\rGreek CharSet\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\rRemarks\n\r\n\rThe DIALOG DEFAULT FONT statement specifies the font which will be used for all subsequent dialogs created with DIALOG NEW, until another DIALOG DEFAULT FONT statement is executed. When a DIALOG NEW statement is executed, the selected default font is associated with it, and its vhild controls, for the lifetime of the dialog.\n\r\n\rThe default font is particularly important when creating new dialogs which use dialog units (rather than pixels) as the unit of measurement. When sizing in dialog units, Windows calculates the physical size of the window based upon the font size, among other factors. Changing the font size later will not update the window size.\n\r\n\rYou may use the value zero (0) for any of the numeric parameters to designate that the compiler should use the default for that item. If parameter(s) are missing, the compiler substitutes the default value for all remaining parameters. If no DIALOG DEFAULT FONT statement is executed, PowerBASIC will select MS Sans Serif, 8 point, with no style attributes.\n\r\n\rWhen specifying a font, care should be exercised to use a standard font that is available in all versions of Windows, such as &quot;Times New Roman&quot;, &quot;Arial&quot;, &quot;Courier&quot;, &quot;MS Sans Serif&quot;, etc. Specifying a font name that is not available forces Windows to substitute a font that may not be visually appealing, and may also alter the relative size of the dialog.\n\r\n\rDIALOG DEFAULT FONT is module-specific. That is, it only affects subsequent dialogs created by code in the same EXE or DLL. For example, a DIALOG DEFAULT FONT statement in a DLL, will not affect dialogs created in the calling EXE or other DLLs loaded by the EXE.\n\r\n\rSee also\n\r\n\rCONTROL SET FONT, Dynamic Dialog Tools, DIALOG NEW, DIALOG SET COLOR, FONT END, FONT NEW, GRAPHIC SET FONT, XPRINT SET FONT","DIALOG DEFAULT FONT statement","scr\\html_dialog_font.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the client size of the specified dialog.\n\r\n\rSyntax\n\r\n\rDIALOG GET CLIENT hDlg TO nWide&amp;, nHigh&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog to examine. The size of the dialog client area is placed in the nWide&amp; (width) and nHigh&amp; (height) variables. The size is specified in the same terms (pixels or dialog units) as the parent dialog.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET CLIENT, DIALOG GET LOC, DIALOG GET SIZE, DIALOG PIXELS, DIALOG SET CLIENT, DIALOG SET LOC, DIALOG SET SIZE, DIALOG UNITS","DIALOG GET CLIENT statement","scr\\html_dialog_get_client.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the location of the specified dialog.\n\r\n\rSyntax\n\r\n\rDIALOG GET LOC hDlg TO x&amp;, y&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog to examine. The location of the dialog is placed in the x&amp; (horizontal position) and y&amp; (vertical position) variables as a relative location. If the dialog was created with the PIXELS option in the DIALOG NEW statement, the values are returned in pixel units. If the UNITS option was used (or no scaling option was specified), the values are returned in dialog units.\n\r\n\r[OBJECT]If the [OBJECT]parent[OBJECT] of the dialog is zero (or %HWND_DESKTOP), the location is relative to the upper-left corner of the display. Otherwise, it is relative to the upper-left corner of client area of the parent window.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, DIALOG GET CLIENT, DIALOG GET SIZE, DIALOG PIXELS, DIALOG SET LOC, DIALOG SET SIZE, DIALOG UNITS","DIALOG GET LOC statement","scr\\html_dialog_get_loc.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the size of the specified dialog.\n\r\n\rSyntax\n\r\n\rDIALOG GET SIZE hDlg TO x&amp;, y&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the dialog to examine. The total size of the dialog is placed in the x&amp; (width) and y&amp; (height) variables. If the dialog was created with the PIXELS option in the DIALOG NEW statement, the values are returned in pixel units. If the UNITS option was used (or no scaling option was specified), the values are returned in dialog units.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, DIALOG GET CLIENT, DIALOG GET LOC, DIALOG PIXELS, DIALOG SET LOC, DIALOG SET SIZE, DIALOG UNITS","DIALOG GET SIZE statement","scr\\html_dialog_get_size.htm","                  \n\r\n\rPurpose\n\r\n\rRetrieve the text in a dialog or window caption.\n\r\n\rSyntax\n\r\n\rDIALOG GET TEXT hDlg TO titletext$\n\r\n\rRemarks\n\r\n\rThe text of the dialog or window caption specified by hDlg. For DDT dialogs, hDlg is the dialog handle returned by the DIALOG NEW statement. In a dialog Callback Function, the CB.HNDL &nbsp;function will return the parent dialog handle and this can also be used with DIALOG GET TEXT.\n\r\n\rtitletext$\n\r\n\rThe text is returned and placed into the string variable titletext$. If the window or dialog is invalid, titletext$ will be set to an empty string.\n\r\n\rRestrictions \n\r\n\rhDlg is a dialog or window handle, so DIALOG GET TEXT works with both DDT dialogs and conventional windows and dialogs.\n\r\n\rSee also\n\r\n\rCB Callback functions, CONTROL GET TEXT, CONTROL SET TEXT, DIALOG NEW, DIALOG SET TEXT\n\r\n\rExample\n\r\n\rDIALOG GET TEXT hDlg1&amp; TO a$\n\r\n\rResult \n\r\n\rVariable a$ contains the caption text of the dialog referenced by hDlg","DIALOG GET TEXT statement","scr\\html_dialog_get_text.htm","                  \n\r\n\rPurpose\n\r\n\rRetrieve a value from the user data area of a DDT dialog.\n\r\n\rSyntax\n\r\n\rDIALOG GET USER hDlg, index&amp; TO retvar&amp;\n\r\n\rRemarks\n\r\n\rEach DDT dialog has a user data area consisting of eight Long-integer values which may be used at the programmer\'s discretion to save relevant data. DIALOG GET USER allows one of the values to be retrieved, based upon the index parameter value (1 through 8).\n\r\n\rhDlg refers to the dialog that contains the user data.\n\r\n\rindex&amp; is the index number of the user data value to retrieve, in the range 1 to 8 inclusive.\n\r\n\rretvar&amp; receives the Long-integer data value stored in the nominated user data index.\n\r\n\rRestrictions \n\r\n\rData in the user data area is lost when the dialog is destroyed. The data area is completely separate from the %GWL_USERDATA area maintained by Windows.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, COMBOBOX SET USER, CONTROL GET USER, CONTROL SET USER, DIALOG SET USER, LISTBOX GET USER, LISTBOX SET USER, LISTVIEW GET USER, LISTVIEW SET USER, TREEVIEW GET USER, TREEVIEW SET USER","DIALOG GET USER statement","scr\\html_dialog_get_user.htm","                  \n\r\n\rPurpose\n\r\n\rMake a Dialog invisible.\n\r\n\rSyntax\n\r\n\rDIALOG HIDE hDlg\n\r\n\rRemarks\n\r\n\rThe Dialog identified by the handle hDlg is made invisible.\n\r\n\rSee also\n\r\n\rCONTROL HIDE, CONTROL NORMALIZE, DIALOG MAXIMIZE, DIALOG MINIMIZE, DIALOG NORMALIZE","DIALOG HIDE statement","scr\\html_dialog_hide_statement.htm","                  \n\r\n\rPurpose\n\r\n\rMaximize a Dialog.\n\r\n\rSyntax\n\r\n\rDIALOG MAXIMIZE hDlg\n\r\n\rRemarks\n\r\n\rThe Dialog identified by the handle hDlg is maximized. You can restore the Dialog to its normal state with DIALOG NORMALIZE.\n\r\n\rSee also\n\r\n\rCONTROL HIDE, CONTROL NORMALIZE, CONTROL SET SIZE, DIALOG MINIMIZE, DIALOG NORMALIZE, DIALOG SET SIZE","DIALOG MAXIMIZE statement","scr\\html_dialog_maximize_statement.htm","                  \n\r\n\rPurpose\n\r\n\rMinimize a Dialog.\n\r\n\rSyntax\n\r\n\rDIALOG MINIMIZE hDlg\n\r\n\rRemarks\n\r\n\rThe Dialog identified by the handle hDlg is minimized. You can restore the Dialog to its normal state with DIALOG NORMALIZE.\n\r\n\rSee also\n\r\n\rCONTROL HIDE, CONTROL NORMALIZE, CONTROL SET SIZE, DIALOG MAXIMIZE, DIALOG NORMALIZE, DIALOG SET SIZE","DIALOG MINIMIZE statement","scr\\html_dialog_minimize_statement.htm","                  \n\r\n\rPurpose\n\r\n\rCreate a new dialog in memory, ready for display.\n\r\n\rSyntax\n\r\n\rDIALOG NEW [PIXELS, | UNITS,] hParent, title$, [x&amp;], [y&amp;], xx&amp;, yy&amp; [, [style&amp;] [, [exstyle&amp;]]] [,] TO hDlg\n\r\n\rRemarks\n\r\n\rA new empty dialog is created, but not yet displayed. Once the dialog has been created and all of the desired controls have been added with CONTROL ADD statements, the dialog can be displayed with the DIALOG SHOW MODELESS, or DIALOG SHOW MODAL statements.\n\r\n\rIf a modeless dialog is created, the application must create a DIALOG DOEVENTS message pump for the duration of the dialog. Failure to provide a message pump can result in disruptions to the display of the dialog, or the inability of the dialog to respond to messages such as button clicks, etc. Modal dialogs do not require a message pump.To change the displayed state of a dialog (i.e., hidden, minimized, etc) after the dialog has been created, use the DIALOG SHOW STATE statement.\n\r\n\rIf a dialog does not have either %WS_CHILD or %WS_POPUP styles, Windows may enforce a minimum dialog width of some 60-70 dialog units.\n\r\n\rPIXELS\n\r\n\rIf the PIXELS keyword is specified, all size and position parameters are specified in pixels. In this case, related statements such as DIALOG GET LOC will also return values in Pixels.\n\r\n\rUNITS\n\r\n\rIf UNITS is specified (or no scaling option is specified), all size and position parameters are specified in Dialog Units. (default)\n\r\n\r&nbsp;\n\r\n\rDIALOG NEW takes the following parameters.\n\r\n\rhParent\n\r\n\rHandle of the parent window or dialog. If there is no parent, use zero (0) or %HWND_DESKTOP. If the dialog is MODAL, the parent window/dialog will be disabled while this &quot;child&quot; dialog is running.\n\r\n\rtitle$\n\r\n\rThe text displayed in the title or caption bar of the dialog.\n\r\n\rx&amp;, y&amp;\n\r\n\rOptional location of the top-left corner for the dialog. The location is specified in the same terms (pixels or dialog units) as specified in the DIALOG NEW statement. If neither x&amp; and y&amp; are specified, the dialog is centered on the screen.\n\r\n\rIf %CW_USEDEFAULT (&amp;H080000000) is specified, the default Windows position is used (cascading from the upper-left corner).\n\r\n\rxx&amp;, yy&amp;\n\r\n\rThe width and height of the dialog. The size is specified in the same terms (pixels or dialog units) as specified in the DIALOG NEW statement.\n\r\n\rIf the default dialog style (or any other dialog style that includes the %WS_CAPTION style) is used, the width and height parameters specify the client size only, and this does not include any caption and border dimensions.\n\r\n\rIf the style does not include %WS_CAPTION, the width and height specify the overall dialog size, including the caption and border, if any.\n\r\n\rNote that %WS_CAPTION is a combination of the %WS_BORDER and %WS_DLGFRAME styles. The default dialog style includes %WS_BORDER and %WS_DLGFRAME styles, so it implicitly includes the %WS_CAPTION style.\n\r\n\rstyle&amp;\n\r\n\rAn optional bitmask describing how the dialog should be displayed. default style of &amp;H084C000D4&amp; is made up %DS_3DLOOK, %DS_SETFONT, %DS_MODALFRAME, %DS_NOFAILCREATE, %WS_BORDER, %WS_CLIPSIBLINGS, %WS_DLGFRAME and %WS_POPUP. used if parameter omitted from statement completely. For example:\n\r\n\rDIALOG NEW 0, &quot;Dialog Title&quot;,,, 100, 200,, TO hDlg\n\r\n\rCustom style values replace the default values. That is, they are not additional to the default style values - your code must specify all necessary style parameters (with the exception of %DS_NOFAILCREATE, %DS_SETFONT and %DS_3DLOOK, which are automatically added into the style&amp; parameter by PowerBASIC).\n\r\n\rThis also applies to the extended styles parameter - if your code specifies a custom primary style, the default extended style will no longer be in effect either. In this case, an explicit extended style may also need to be added to the DIALOG NEW statement if an explicit primary style is specified.\n\r\n\rThe primary style&amp; value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%DS_3DLOOK Give the dialog box a non-bold font, and draw three-dimensional borders around controls in the dialog box. The %DS_3DLOOK style is not required by applications marked with #OPTION VERSION4 or #OPTION VERSION5; as Windows automatically applies the 3D appearance. DDT dialogs are always created with this style. (default)\n\r\n\r%DS_3DLOOK\n\r\n\rGive the dialog box a non-bold font, and draw three-dimensional borders around controls in the dialog box. The %DS_3DLOOK style is not required by applications marked with #OPTION VERSION4 or #OPTION VERSION5; as Windows automatically applies the 3D appearance. DDT dialogs are always created with this style. (default)\n\r\n\r%DS_ABSALIGN\n\r\n\rIndicate that the coordinates of the dialog box are screen coordinates; otherwise, Windows assumes they are client coordinates.\n\r\n\r%DS_CENTER\n\r\n\rCenter the dialog box in the working area (the area not obscured by the task bar and system tray). This is the default if x&amp; and y&amp; are not specified.\n\r\n\r%DS_CENTERMOUSE\n\r\n\rCenter the mouse cursor in the dialog box when the dialog is initially created.\n\r\n\r%DS_CONTEXTHELP\n\r\n\rInclude a question mark in the title bar of the dialog box. When the user clicks the question mark, the cursor changes to a question mark with a pointer. If the user then clicks a control in the dialog box, the dialog callback receives a %WM_HELP message. This style cannot be used with the %WS_MAXIMIZEBOX and %WS_MINIMIZEBOX styles. Also see %WS_EX_CONTEXTHELP.\n\r\n\r%DS_CONTROL\n\r\n\rCreate a dialog that works as a child control of another dialog, smoothing the keyboard focus interface across the two dialogs when the TAB key or control accelerators are used. Typically used for dialogs that form the &quot;pages&quot; for tab controls and property-sheets.\n\r\n\r%DS_MODALFRAME\n\r\n\rCreate a dialog box with a modal dialog-box frame that can be combined with a title bar and System menu by specifying the %WS_CAPTION and %WS_SYSMENU styles. (default)\n\r\n\r%DS_NOFAILCREATE\n\r\n\rThe dialog is created regardless of any errors that may occur during the creation phase. DDT dialogs are always created with this style. (default)\n\r\n\r%DS_SETFONT\n\r\n\rThe font to be used by a DDT dialog and its controls can be predetermined with the DIALOG DEFAULT FONT statement. If the DIALOG DEFAULT FONT statement is not used, the default font (MS Sans Serif, 8 point) is used. The size of the dialog font proportionately affects the conversion of dialog units values into pixels, so an increase in default font size will automatically create a larger dialog, even through the dialog dimensions have remained constant. As child controls are added to a %DS_SETFONT dialog, they will be sent a %WM_SETFONT message to ensure they also make use of the specified dialog font. DDT dialogs are always created with this style. (default)\n\r\n\r%DS_SETFOREGROUND\n\r\n\rBring the dialog box to the foreground. Internally, Windows calls the SetForegroundWindow API function for the dialog box.\n\r\n\r%DS_SYSMODAL\n\r\n\rCreate a system-modal dialog box. This style causes the dialog box to have the %WS_EX_TOPMOST style, but otherwise has no effect on the dialog box or the behavior of other applications and windows when the dialog box is displayed.\n\r\n\r%WS_BORDER\n\r\n\rCreate a dialog that has a thin-line border.\n\r\n\r%WS_CAPTION\n\r\n\rCreate a dialog that has a title bar. Includes the %WS_BORDER and %WS_DLGFRAME styles. When this style is used, the xx&amp; and yy&amp; parameters specify the size of the client area of the dialog; otherwise, they specify the outer dimensions of the dialog. (default)\n\r\n\r%WS_CHILD\n\r\n\rCreate a child dialog. Cannot be used with the %WS_POPUP style. Typically used with %DS_CONTROL for tab control and property sheet &quot;pages&quot;.\n\r\n\r%WS_CLIPCHILDREN\n\r\n\rExclude the area occupied by child controls when drawing occurs on the dialog background. FRAME and LINE controls on a dialog with this style usually use the extended style %WS_EX_TRANSPARENT so the background of those controls is drawn by the dialog before the controls are drawn. %WS_CLIPCHILDREN is commonly used to reduce redraw flicker when a %WS_THICKFRAME style dialog is being resized.\n\r\n\r%WS_CLIPSIBLINGS\n\r\n\rChild controls are clipped (not overdrawn) by one another when the dialog window is repainted. (default)\n\r\n\r%WS_DISABLED\n\r\n\rCreate a dialog that is initially disabled. A disabled dialog cannot receive input from the user.\n\r\n\r%WS_DLGFRAME\n\r\n\rCreate a window that has a border of the style typically used with dialog boxes. (default)\n\r\n\r%WS_HSCROLL\n\r\n\rDialog contains a horizontal scroll bar.\n\r\n\r%WS_ICONIC\n\r\n\rCreate a dialog that is initially minimized, the same as the %WS_MINIMIZE style.\n\r\n\r%WS_MAXIMIZE\n\r\n\rCreate a dialog that is initially maximized.\n\r\n\r%WS_MAXIMIZEBOX\n\r\n\rCreate a dialog that has a Maximize button. Use with the %WS_SYSMENU style.\n\r\n\r%WS_MINIMIZE\n\r\n\rCreate a dialog that is initially minimized, the same as the %WS_ICONIC style.\n\r\n\r%WS_MINIMIZEBOX\n\r\n\rCreate a dialog that has a Minimize button. Use with the %WS_SYSMENU style.\n\r\n\r%WS_OVERLAPPED\n\r\n\rCreate an overlapped window. An overlapped window has a title bar (caption) and a border. Synonym of the obsolete style %WS_TILED.\n\r\n\r%WS_OVERLAPPEDWINDOW\n\r\n\rCombination style producing an overlapping dialog. Comprises %WS_CAPTION, %WS_SYSMENU, %WS_THICKFRAME, %WS_MINIMIZEBOX, %WS_MAXIMIZEBOX, and %WS_OVERLAPPED styles.\n\r\n\r%WS_POPUP\n\r\n\rCreate a popup dialog. When used by itself, a flat dialog is created with no caption or borders. Combine with %DS_MODALFRAME to create a 3D border. A popup dialog can overlap another window or dialog. (default)\n\r\n\r%WS_POPUPWINDOW\n\r\n\rCreate a popup dialog but with a border and system menu. Comprises %WS_BORDER, %WS_POPUP and %WS_SYSMENU. Combine %WS_POPUPWINDOW with %WS_CAPTION to make the Window menu visible.\n\r\n\r%WS_SYSMENU\n\r\n\rCreate a dialog that has a System-menu box in its title bar. Must be used with the %WS_CAPTION style.\n\r\n\r%WS_THICKFRAME\n\r\n\rCreate a dialog that has a sizing border. That is, the dialog will be resizable.\n\r\n\r%WS_VSCROLL\n\r\n\rDialog contains a vertical scroll bar. Also see %WS_EX_LEFTSCROLLBAR.\n\r\n\rexstyle&amp;\n\r\n\rAn optional extended style bitmask describing how the dialog should be displayed. The default extended dialog style comprises %WS_EX_LEFT with %WS_EX_LTRREADING and %WS_EX_RIGHTSCROLLBAR. The default extended style is used only if there are no explicit primary or extended styles parameters in the DIALOG NEW statement.\n\r\n\rAn explicit extended style value can be a combination of any values below, combined together with the OR operator to form a bitmask:\n\r\n\r%WS_EX_ACCEPTFILES\n\r\n\rThe dialog accepts drag+drop files. The dialog Callback Function receives a %WM_DROPFILES message when files have been dropped onto the dialog.\n\r\n\r%WS_EX_APPWINDOW\n\r\n\rForce a top-level dialog onto the application taskbar when the window is minimized.\n\r\n\r%WS_EX_CLIENTEDGE\n\r\n\rDialog has a border with a sunken edge.\n\r\n\r%WS_EX_CONTEXTHELP\n\r\n\rInclude a question mark in the title bar of the dialog. When the user clicks the question mark, the cursor changes to a question mark with a pointer. If the user then clicks a child window, the child receives a %WM_HELP message. Also see %DS_CONTEXTHELP.\n\r\n\r%WS_EX_CONTROLPARENT\n\r\n\rThe user may navigate among the child dialogs of the window by using the TAB key. See %DS_CONTROL.\n\r\n\r%WS_EX_LEFT\n\r\n\rDialog has generic &quot;left-aligned&quot; properties. (default)\n\r\n\r%WS_EX_LEFTSCROLLBAR\n\r\n\rIf present, the vertical scroll bar is positioned to the left of the client area. Also see %WS_VSCROLL.\n\r\n\r%WS_EX_LTRREADING\n\r\n\rDisplay the dialog text using Left to Right reading-order properties. (default)\n\r\n\r%WS_EX_NOPARENTNOTIFY\n\r\n\rSuppress %WM_PARENTNOTIFY messages when dialog is created or destroyed.\n\r\n\r%WS_EX_OVERLAPPEDWINDOW\n\r\n\rComprised of the %WS_EX_CLIENTEDGE and %WS_EX_WINDOWEDGE styles.\n\r\n\r%WS_EX_PALETTEWINDOW\n\r\n\rComprised of the %WS_EX_WINDOWEDGE, %WS_EX_TOOLWINDOW and %WS_EX_TOPMOST styles.\n\r\n\r%WS_EX_RIGHT \n\r\n\rDialog has generic &quot;right-aligned&quot; properties that depend on the window class. This style has an effect only if the shell language is Hebrew, Arabic, or another language that supports reading order alignment. Otherwise, the style is ignored.\n\r\n\r%WS_EX_RIGHTSCROLLBAR\n\r\n\rIf present, the vertical scroll bar is positioned to the right of the client area. See %WS_VSCROLL. (default)\n\r\n\r%WS_EX_RTLREADING\n\r\n\rIf the shell language is Hebrew, Arabic, or another language that supports reading order alignment, the dialog text is displayed using Right to Left reading-order properties. For other languages, the style is ignored.\n\r\n\r%WS_EX_STATICEDGE\n\r\n\rDialog has a 3D border. Primarily used for dialogs that do not require user-input.\n\r\n\r%WS_EX_TOOLWINDOW\n\r\n\rCreate a tool window (a window intended to be used as a floating toolbar). A tool window has a shorter than normal caption area and the dialog caption is drawn using a smaller font. A tool window does not appear in the task bar, or in the window that appears when the user presses ALT+TAB. The hybrid versions of Windows (95/98/ME) may require this extended style to be added after creation, using the SetWindowLong API function.\n\r\n\r%WS_EX_TOPMOST\n\r\n\rPlace dialog above all non-topmost windows and keep it above them, even while the dialog is deactivated.\n\r\n\r%WS_EX_TRANSPARENT\n\r\n\rControls/windows beneath the dialog are drawn before the dialog is drawn. The dialog is deemed transparent because elements behind the dialog have already been painted - the dialog itself is not drawn differently. True transparency is achieved by using Regions - see MSDN for more information.\n\r\n\r%WS_EX_WINDOWEDGE\n\r\n\rDialog has a border with a raised edge.\n\r\n\rhDlg\n\r\n\rLong-integer Variable where the Windows window handle of the dialog is stored after it has been created and assigned by Windows. This handle should be used with subsequent DIALOG and CONTROL statements, and may be directly used with Windows API calls.\n\r\n\rIf the dialog could not be created (i.e., due to low Windows resources), zero is returned.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD, DIALOG DOEVENTS, DIALOG END, DIALOG HIDE, DIALOG MAXIMIZE, DIALOG MINIMIZE, DIALOG NONSTABLE, DIALOG NORMALIZE, DIALOG SET COLOR, DIALOG SHOW MODAL, DIALOG SHOW MODELESS, DIALOG STABILIZE, DIALOG SHOW STATE, TXT pseudo-object","DIALOG NEW statement","scr\\html_dialog_new.htm","                  \n\r\n\rPurpose\n\r\n\rMake a Dialog non-stable (closeable).\n\r\n\rSyntax\n\r\n\rDIALOG NONSTABLE hDlg\n\r\n\rRemarks\n\r\n\rThe Dialog identified by the handle hDlg is made non-stable, meaning that it can be closed by the user. If there is a system menu, the close option and the close box are enabled. The ALT-F4 close key is also enabled. This is the default mode of operation.\n\r\n\rSee also\n\r\n\rDIALOG STABILIZE","DIALOG NONSTABLE statement","scr\\html_dialog_nonstable_statement_.htm","                  \n\r\n\rPurpose\n\r\n\rMake a Dialog visible.\n\r\n\rSyntax\n\r\n\rDIALOG NORMALIZE hDlg\n\r\n\rRemarks\n\r\n\rThe Dialog identified by the handle hDlg is made visible at its normal size and position.\n\r\n\rSee also\n\r\n\rDIALOG HIDE, DIALOG MAXIMIZE, DIALOG MINIMIZE, DIALOG SHOW STATE","DIALOG NORMALIZE statement","scr\\html_dialog_normalize_statement_.htm","                  \n\r\n\rPurpose\n\r\n\rConvert pixels (device units) into dialog units.\n\r\n\rSyntax\n\r\n\rDIALOG PIXELS hDlg, x&amp;, y&amp; TO UNITS xx&amp;, yy&amp;\n\r\n\rRemarks\n\r\n\rThe pixel values specified in the x&amp; and y&amp; variables are converted into dialog units, based on the default font of the dialog specified by hDlg. The resulting value in dialog units is stored in the xx&amp; and yy&amp; variables.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET CLIENT, DIALOG GET CLIENT, DIALOG GET LOC, DIALOG GET SIZE, DIALOG SET LOC, DIALOG SET SIZE, DIALOG UNITS","DIALOG PIXELS statement","scr\\html_dialog_pixels.htm","                  \n\r\n\rPurpose\n\r\n\rPlace a message in the message queue to be processed at the leisure of the target dialog.\n\r\n\rSyntax\n\r\n\rDIALOG POST hDlg, Msg&amp;, wParam&amp;, lParam&amp;\n\r\n\rRemarks\n\r\n\rDIALOG POST places the message in the message queue and returns immediately. The message is processed by the dialog at a later time, when it reads the message from the queue.\n\r\n\rThis behavior is quite different to the DIALOG SEND statement, which forces the control to process the message immediately before returning. Since DIALOG POST is an asynchronous operation, it is not possible to retrieve a return code from the message.\n\r\n\rhDlg refers to the target dialog.\n\r\n\rMsg&amp; is the message you want to post to the dialog.\n\r\n\rwParam&amp; is the first message parameter. lParam&amp; is the second message parameter. The values of wParam&amp; and lParam&amp; are message-dependent. By Default, PowerBASIC passes these parameters BYVAL. If the target dialog is expected to alter the values held by variables passed in the wParam&amp; and lParam&amp; parameters, pass them using VARPTR() or the changes will likely be discarded.\n\r\n\rNote that the address of the data must remain valid until after the dialog has processed the message and accessed the data. In this case, using STATIC or GLOBAL variables can be very important or a General Protection Fault (GPF) may occur (that is, if the variables have gone out of scope by the time the message is processed).\n\r\n\rAn example of posting the addresses of variables to a dialog:\n\r\n\r\' Sel1&amp; and Sel2&amp; must be STATIC or GLOBAL\n\r\n\rDIALOG POST CB.HNDL, %WM_USER + 999&amp;, VARPTR(Sel1&amp;), VARPTR(Sel2&amp;)\n\r\n\rDIALOG POST returns immediately after the placing the message in the queue.\n\r\n\r&nbsp;\n\r\n\rTo post a custom message to a dialog, use a message value in the range of (%WM_USER + 500) to (%WM_USER + &amp;H07FFF), or use the RegisterWindowMessage API to obtain a unique message value from the operating system. Using messages with a numeric value of less then %WM_USER + 500 may conflict with Windows Common Control messages.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CB Callback functions, CONTROL POST, CONTROL SEND, DIALOG SEND\n\r\n\rExample\n\r\n\r\' Programmatically post a message to a dialog:\n\r\n\rDIALOG POST hDlg, %WM_CLOSE, 0, 0","DIALOG POST statement","scr\\html_dialog_post.htm","                  \n\r\n\rPurpose\n\r\n\rSignal a designated dialog and all child controls to be redrawn immediately.\n\r\n\rSyntax\n\r\n\rDIALOG REDRAW hDlg\n\r\n\rRemarks\n\r\n\rDIALOG REDRAW invalidates the target dialog area, and signals a redraw/repaint to occur immediately, even if there are pending messages in the message queue.\n\r\n\rhDlg refers to the dialog that is to be redrawn.\n\r\n\rRestrictions \n\r\n\rIt is not advisable to use DIALOG REDRAW or CONTROL REDRAW statements within the %WM_PAINT and associated message handling code, or an infinite redraw loop could occur.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL REDRAW, CONTROL SET COLOR, DIALOG SET COLOR\n\r\n\rExample\n\r\n\rDIALOG REDRAW hDlg","DIALOG REDRAW statement","scr\\html_dialog_redraw.htm","                  \n\r\n\rPurpose\n\r\n\rSend a message to a dialog, then wait until the message has been processed before continuing.\n\r\n\rSyntax\n\r\n\rDIALOG SEND hDlg, msg&amp;, wParam&amp;, lParam&amp; [TO lResult&amp;]\n\r\n\rRemarks\n\r\n\rhDlg identifies the dialog which should receive the message specified by msg&amp;. wParam&amp; is the first message parameter, and lParam&amp; is the second message parameter.\n\r\n\rBy default, PowerBASIC passes these parameters BYVAL. If the target dialog is expected to return or alter the values passed in the wParam&amp; and lParam&amp; parameters, pass them using VARPTR() or the return values will be discarded. For example:\n\r\n\rDIALOG SEND CB.HNDL, %WM_USER, VARPTR(Param1&amp;), VARPTR(Param2&amp;)\n\r\n\rTO \n\r\n\rThe return value may be returned and stored in the variable lResult&amp; after the message was processed by the dialog.\n\r\n\rRestrictions \n\r\n\rIf the target dialog was not created by the same thread, the DIALOG SEND statement becomes blocked until the thread processes the message. The InSendMessage API function will return TRUE (non-zero) if the callback code is currently processing a message from a separate thread.\n\r\n\rTo send a custom message to a dialog, use a message value in the range of (%WM_USER + 500) to (%WM_USER + &amp;H07FFF), or use the RegisterWindowMessage API to obtain a unique message value from the operating system.\n\r\n\rA dialog callback can send a message to its own dialog, but care should be taken not to create an infinite loop. Also, if DIALOG SEND sends a message that arrives back in the same callback as the message originated, care should be exercised to ensure that critical STATIC and GLOBAL variables are not unexpectedly altered by the second message processing code in the callback. This is known as re-entrant code design.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL SEND","DIALOG SEND statement","scr\\html_dialog_send.htm","                  \n\r\n\rPurpose\n\r\n\rChange the size of a dialog to a specific client area size.\n\r\n\rSyntax\n\r\n\rDIALOG SET CLIENT hDlg, x&amp;, y&amp;\n\r\n\rRemarks\n\r\n\rhDlg refers to the handle of the dialog to change. x&amp; and y&amp; specify the new width and height of the dialog client area. x&amp; and y&amp; are specified in dialog units or pixels, depending upon the system used when the dialog was created.\n\r\n\rThe dialog client size may be smaller than total size, depending on the type of borders used.  The client area is the part below the dialog caption, and an eventual menu, where controls can be placed.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, DIALOG NEW, DIALOG PIXELS, DIALOG UNITS, DIALOG GET CLIENT, DIALOG GET LOC, DIALOG GET SIZE, DIALOG SET LOC, DIALOG SET SIZE\n\r\n\rExample\n\r\n\rLOCAL hDlg, hMnu, hSubMenu AS DWORD, h, w AS LONG\n\r\n\r&nbsp;\n\r\n\rDIALOG NEW 0, &quot;My Dialog&quot;,,, 400, 300, %WS_CAPTION OR %WS_SYSMENU, 0 TO hDlg\n\r\n\r\' Retrieve dialog client area\n\r\n\rDIALOG GET CLIENT hDlg TO w, h\n\r\n\rMENU NEW BAR TO hMnu\n\r\n\rMENU NEW POPUP TO hSubMenu\n\r\n\rMENU ADD POPUP, hMnu, &quot;&amp;File&quot;, hSubMenu, %MF_ENABLED\n\r\n\rMENU ADD STRING, hSubMenu, &quot;E&amp;Xit&quot;, %IDCANCEL, %MF_ENABLED\n\r\n\rMENU ATTACH hMnu, hDlg\n\r\n\r&nbsp;\n\r\n\r\' Restore client area to desired size\n\r\n\rDIALOG SET CLIENT hDlg, w, h &nbsp;  ","DIALOG SET CLIENT Statement","scr\\html_dialog_set_client_statement.htm","                  \n\r\n\rPurpose\n\r\n\rSet the background color of a dialog to a specific RGB color.\n\r\n\rSyntax\n\r\n\rDIALOG SET COLOR hDlg, foreclr&amp;, backclr&amp;\n\r\n\rRemarks\n\r\n\rhDlg identifies the dialog to colorize.\n\r\n\rColor values foreclr&amp; and backclr&amp; must be in the range of &amp;H0 to &amp;H00FFFFFF, while the value -1&amp; is used to specify the system default color. RGB can be a useful function to derive a 32-bit color value from discrete Red, Green and Blue values.\n\r\n\rforeclr&amp;\n\r\n\rIn the current implementation of PowerBASIC, the dialog foreground color parameter foreclr&amp; is not used, but the syntax is retained for future implementation. It is recommended that the foreground color parameter be set to -1&amp;.\n\r\n\rbackclr&amp;\n\r\n\rIn 16-bit or greater color-depth mode, the RGB color specified is used when the background of the dialog is drawn. If backclr&amp; = -1&amp;, the default dialog background color is used. If backclr&amp; = -2&amp;, the dialog background is not painted, allowing the content behind the dialog to become visible through the dialog.\n\r\n\rIn 16-bit or greater color-depth mode, the specified RGB color is used when the background of the dialog is drawn. However, in 8-bit (256-color) mode, the color system works quite differently. Behind the scenes in Windows, the base system palette usually contains 20 solid colors that are not dithered when drawn on a dialog background. These solid-colors are ideal for background colors with DDT dialogs in 256-color mode.\n\r\n\rConversely, when using a non-solid RGB color value, Windows will dither (approximate) the color to draw the dialog, using combinations of two or more colors. This usually produces an undesirable pattern effect.\n\r\n\rTo avoid these problems when in 256-color mode, dialogs should either be colored with one of the 20 standard (solid) system colors, or the default color should be used instead. PowerBASIC includes the following 10 built-in equates for help with the selection of a standard solid color:\n\r\n\r%RGB_BLACK %RGB_BLUE %RGB_GREEN %RGB_CYAN %RGB_RED\n\r\n\r%RGB_MAGENTA %RGB_YELLOW %RGB_WHITE %RGB_GRAY %RGB_LIGHTGRAY\n\r\n\rMany non standard colors are also built into the compiler, see the Built In RGB Color Equates topic for a complete list.\n\r\n\rIf you prefer to disable color in 256-color mode, the number of colors can be easily tested with the following code:\n\r\n\r\' Determine number of colors\n\r\n\rLOCAL hDC AS DWORD, iColors AS LONG\n\r\n\r&nbsp;\n\r\n\rhDC = GetWindowDC(GetDeskTopWindow())\n\r\n\riColors = 2&amp; ^ (GetDeviceCaps(hDC, %BITSPIXEL) * GetDeviceCaps(hDC, %PLANES))\n\r\n\rReleaseDC GetDeskTopWindow(), hDC\n\r\n\rIF iColors &gt; 256 THEN _\n\r\n\rDIALOG SET COLOR hDlg, -1, RGB(0,100,192)\n\r\n\rIn 256-color mode on most computers, the values of the standard 20 system colors can be found by requesting the first and last 10 (0 to 9, and 246 to 255 inclusive) entries from the GetSystemPaletteEntries API function, as follows:\n\r\n\r\' Fill array with solid colors\n\r\n\rDIM hDC AS DWORD, Cols AS LONG, x AS LONG\n\r\n\r&nbsp;\n\r\n\rhDC = GetWindowDC(GetDesktopWindow)\n\r\n\rCols = GetDeviceCaps(hDC, %NUMRESERVED)\n\r\n\rREDIM lp(1 TO Cols) AS LONG\n\r\n\rx&amp; = GetSystemPaletteEntries(hDC, 0, Cols \\ 2, BYVAL VARPTR(lp(1)))\n\r\n\rx&amp; = GetSystemPaletteEntries(hDC, 256 - x&amp;, Cols - x&amp;, BYVAL VARPTR(lp(x&amp; + 1)))\n\r\n\rReleaseDc GetDesktopWindow, hDC\n\r\n\r\' Array lp() now contains the solid color table\n\r\n\rFor more information on working with palettes in 256-color mode, please consult WIN32.HLP or visit http://msdn.microsoft.com.\n\r\n\rWhen dynamically changing colors of a dialog from within a callback (i.e., after the DIALOG SHOWstatement), a DIALOG SET COLOR statement should be immediately followed by an explicit DIALOG REDRAW statement.\n\r\n\rWithout a forced dialog redraw, the dialog background color change may not become evident to the user until the dialog is eventually repainted in the normal course of user interaction. For example, a normal repaint may only occur if the dialog becomes obscured and then uncovered by another window. Ensuring a timely repaint of the dialog will guarantee the dialog maintains an up-to-date appearance at all times.\n\r\n\rSee also\n\r\n\rBuilt In RGB Color Equates, Dynamic Dialog Tools, CONTROL REDRAW, DIALOG REDRAW, CONTROL SET COLOR, DIALOG SET ICON\n\r\n\rExample\n\r\n\rDIALOG NEW 0, &quot;Dialog&quot;,,, 160, 120, TO hDlg\n\r\n\r&nbsp;\n\r\n\r\' Set the color with an RGB value\n\r\n\rDIALOG SET COLOR hDlg, -1, RGB(0,0,255)\n\r\n\r&nbsp;\n\r\n\r\' Or we could use the built-in %BLUE equate:\n\r\n\rDIALOG SET COLOR hDlg, -1, %BLUE","DIALOG SET COLOR statement","scr\\html_dialog_set_color.htm","                  \n\r\n\rPurpose\n\r\n\rChange both the dialog icon in the caption, and the icon shown in the ALT+TAB task list.\n\r\n\rSyntax\n\r\n\rDIALOG SET ICON hDlg, newicon$\n\r\n\rRemarks\n\r\n\rDIALOG SET ICON changes both the small icon (as used in the dialog caption bar), and the large icon (visible in the icon task list presented during ALT+TAB task switching).\n\r\n\rhDlg \n\r\n\rHandle of the dialog that is to have its icon changed.\n\r\n\rnewicon$\n\r\n\rA string expression which specifies the name of the icon in the resource file. If the icon resource uses an integral identifier, newicon$ should begin with a Number symbol (#), followed by the integral identifier in ASCII format. For example, &quot;#998&quot;. Otherwise, the text identifier name should be used.\n\r\n\rRestrictions \n\r\n\rDIALOG SET ICON cannot use bitmap files. 32x32 pixel icons produce the most visually pleasing results.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL ADD IMAGE, CONTROL ADD IMAGEX, CONTROL ADD IMGBUTTON, CONTROL ADD IMGBUTTONX, CONTROL SET IMAGEX, CONTROL SET IMGBUTTON, CONTROL SET IMGBUTTONX, DIALOG SET TEXT","DIALOG SET ICON statement","scr\\html_dialog_set_icon.htm","                  \n\r\n\rPurpose\n\r\n\rChange the position of a dialog.\n\r\n\rSyntax\n\r\n\rDIALOG SET LOC hDlg, x&amp;, y&amp;\n\r\n\rRemarks\n\r\n\rhDlg identifies the dialog to reposition. x&amp; and y&amp; specify the new coordinates of the upper-left corner of the target dialog. x&amp; and y&amp; are the horizontal and vertical coordinates respectively. If the dialog was created with the PIXELS option in the DIALOG NEW statement, the values are returned in pixel units. If the UNITS option was used (or no scaling option was specified), the values are returned in dialog units.\n\r\n\rIf the dialog has a parent, the coordinates are relative to the upper-left corner of the parent dialog client area. Otherwise, the coordinates are relative to the upper-left corner of the desktop workspace.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, DIALOG GET CLIENT, DIALOG GET LOC, DIALOG GET SIZE, DIALOG PIXELS, DIALOG SET SIZE, DIALOG UNITS","DIALOG SET LOC statement","scr\\html_dialog_set_loc.htm","                  \n\r\n\rPurpose\n\r\n\rChange the size of a dialog.\n\r\n\rSyntax\n\r\n\rDIALOG SET SIZE hDlg, nWide&amp;, nHigh&amp;\n\r\n\rRemarks\n\r\n\rhDlg identifies the dialog to resize. nwide&amp; and nhigh&amp; specify the new width and height, in dialog units, for the dialog. If the dialog was created with the PIXELS option in the DIALOG NEW statement, the values are set in pixel units. If the UNITS option was used (or no scaling option was specified), the values are set in dialog units.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, DIALOG GET CLIENT, DIALOG GET LOC, DIALOG GET SIZE, DIALOG PIXELS, DIALOG SET CLIENT, DIALOG SET LOC, DIALOG UNITS","DIALOG SET SIZE statement","scr\\html_dialog_set_size.htm","                  \n\r\n\rPurpose\n\r\n\rSet the text in a dialog or window caption.\n\r\n\rSyntax\n\r\n\rDIALOG SET TEXT hDlg, titletext$\n\r\n\rRemarks\n\r\n\rThe caption of the dialog or window specified by hDlg is set with the DIALOG SET TEXT statement. For DDT dialogs, hDlg is the dialog handle returned by the DIALOG NEW statement. In a dialog Callback Function, the CB.HNDL function will return the parent dialog handle and this can also be used with DIALOG SET TEXT.\n\r\n\rtitletext$\n\r\n\rThe caption text is specified in titletext$. If the window or dialog is invalid, the operation is ignored.\n\r\n\rRestrictions\n\r\n\rhDlg is a dialog or window handle, so DIALOG SET TEXT works with both DDT dialogs and conventional windows and dialogs.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CB Callback functions, CONTROL GET TEXT, CONTROL SET TEXT, DIALOG GET TEXT, DIALOG NEW, DIALOG SET ICON\n\r\n\rExample\n\r\n\rDIALOG SET TEXT hDlgMine, &quot;This is my dialog!&quot;","DIALOG SET TEXT statement","scr\\html_dialog_set_text.htm","                  \n\r\n\rPurpose\n\r\n\rSet a value in the user data area of a DDT dialog.\n\r\n\rSyntax\n\r\n\rDIALOG SET USER hDlg, index&amp;, usrval&amp;\n\r\n\rRemarks\n\r\n\rEach DDT dialog has a user data area consisting of eight Long-integer values which may be used at the programmer\'s discretion to save relevant data. DIALOG SET USER allows one of the values to be set, based upon the index parameter value (1 through 8).\n\r\n\rhDlg refers to the dialog that owns the user data area.\n\r\n\rindex&amp; is the index number of the user data value to set, in the range 1 to 8 inclusive.\n\r\n\rusrval&amp; is the Long-integer data value to store in the user data area.\n\r\n\rRestrictions \n\r\n\rData in the user data area is lost when the dialog is destroyed. The data area is completely separate from the %GWL_USERDATA area maintained by Windows.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, COMBOBOX SET USER, CONTROL GET USER, CONTROL SET USER, DIALOG GET USER, LISTBOX GET USER, LISTBOX SET USER, LISTVIEW GET USER, LISTVIEW SET USER, TREEVIEW GET USER, TREEVIEW SET USER","DIALOG SET USER statement","scr\\html_dialog_set_user.htm","                  \n\r\n\rPurpose\n\r\n\rDisplay and activate a dialog, allowing it to receive user input and messages. The DIALOG SHOW MODAL statement blocks (halts) until the dialog is destroyed with DIALOG END.\n\r\n\rSyntax\n\r\n\rDIALOG SHOW MODAL hDlg [[,] CALL callback] [TO lResult&amp;]\n\r\n\rRemarks\n\r\n\rhDlg identifies a dialog created using DIALOG NEW. You can specify a Callback Function for all dialog messages using the CALL keyword, followed by the name of the Callback Function.\n\r\n\rWhen a modal dialog is displayed, the DIALOG SHOW MODAL statement is blocked until the dialog is destroyed with DIALOG END. During the duration of the dialog, the Callback Function code is executed in response to messages for the dialog.\n\r\n\rIf a parent was specified in the DIALOG NEW statement, the parent window is disabled until the modal dialog is destroyed.\n\r\n\rcallback \n\r\n\rIf specified, dialog messages are routed to the nominated Callback Function.\n\r\n\rJust before a dialog is initially displayed, the dialog Callback Function is sent a %WM_INITDIALOG message. By processing this message within the dialog callback, an application can take the opportunity to load controls with data before the controls become visible to the user. For example, a list box control could be loaded with a list of items so that the control appears populated with data when initially displayed.\n\r\n\rThe nominated callback function name must be a CALLBACK FUNCTION or a compile-time Error 547 (&quot;Callback function required&quot;) will occur.\n\r\n\rlResult&amp;\n\r\n\rWhen the modal dialog is destroyed using the DIALOG END statement, the resulting value is assigned to the lResult&amp; variable, if specified. lResult&amp; is excluded from becoming a Register variable by the compiler, since this value can be assigned from outside of the function containing the DIALOG SHOW MODAL statement, and this may only be performed with a memory variable. However, if the target variable is explicitly declared as a register variable, PowerBASIC raises a compile-time Error 491 (&quot;Invalid register variable&quot;).\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, DIALOG END, DIALOG NEW, DIALOG SHOW MODELESS","DIALOG SHOW MODAL statement","scr\\html_dialog_show_modal.htm","                  \n\r\n\rPurpose\n\r\n\rDisplay and activate a dialog, allowing it to receive user input and messages. Execution of the code continues at the same time as the dialog is displayed.  Modeless dialogs require a message pump to be running for the duration of the dialog.\n\r\n\rSyntax\n\r\n\rDIALOG SHOW MODELESS hDlg [[,] CALL callback] [TO lResult&amp;]\n\r\n\rRemarks\n\r\n\rhDlg identifies a dialog created using DIALOG NEW. You can specify a Callback Function for all dialog messages, using the CALL keyword followed by the name of the Callback Function.\n\r\n\rOnce a modeless dialog is displayed, the DIALOG SHOW MODELESS statement completes, and execution of the code continues. At the same time, the dialog can receive messages and process them via the Callback Function. A DIALOG SHOW MODELESS statement is usually followed by a message pump loop. For more information, please refer to the examples under DIALOG DOEVENTS.\n\r\n\rcallback \n\r\n\rIf specified, dialog messages are routed to the nominated Callback Function.\n\r\n\rThe nominated callback function name must be a CALLBACK FUNCTION or a compile-time Error 547 (&quot;Callback function required&quot;) will occur.\n\r\n\rlResult&amp;\n\r\n\rWhen the modeless dialog is destroyed using the DIALOG END statement, the resulting value is assigned to the lResult&amp; variable, if specified. lResult&amp; is excluded from becoming a Register variable by the compiler, since this value can be assigned from outside of the function containing the DIALOG SHOW MODELESS statement, and this may only be performed with a memory variable. However, if the target variable is explicitly declared as a register variable, PowerBASIC raises a compile-time Error 491 (&quot;Invalid register variable&quot;).\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, DIALOG DOEVENTS, DIALOG END, DIALOG NEW, DIALOG SHOW MODAL","DIALOG SHOW MODELESS statement","scr\\html_dialog_show_modeless.htm","                  \n\r\n\rPurpose\n\r\n\rChange the visible state of a dialog.\n\r\n\rSyntax\n\r\n\rDIALOG SHOW STATE hDlg, showstate&amp; [TO lResult&amp;]\n\r\n\rRemarks\n\r\n\rDIALOG SHOW STATE changes the visible state of the dialog identified by hDlg.\n\r\n\rshowstate&amp; can be one of the following values:\n\r\n\r%SW_HIDE \n\r\n\rHide the dialog.\n\r\n\r%SW_MAXIMIZE\n\r\n\rMaximize the specified dialog.\n\r\n\r%SW_MINIMIZE\n\r\n\rMinimize the specified dialog.\n\r\n\r%SW_RESTORE\n\r\n\rActivate and display the dialog. If the dialog is minimized or maximized, Windows restores it to its original size and position. An application should specify this flag when restoring a minimized dialog.\n\r\n\r%SW_SHOW\n\r\n\rActivate the dialog and displays it in its current size and position.\n\r\n\r%SW_SHOWMAXIMIZED\n\r\n\rSynonym of %SW_MAXIMIZE.\n\r\n\r%SW_SHOWMINIMIZED\n\r\n\rActivate the dialog and minimize it.\n\r\n\r%SW_SHOWNA\n\r\n\rDisplay the dialog in its current state without activating it. The currently active window remains active.\n\r\n\r%SW_SHOWNOACTIVATE\n\r\n\rDisplay the dialog in its most recent size and position without activating it. The currently active window remains active.\n\r\n\r%SW_SHOWNORMAL\n\r\n\rActivate and display the dialog. If the dialog is minimized or maximized, Windows restores it to its original size and position.\n\r\n\rIf the optional lResult&amp; parameter is used, it will contain the previous visibility state. If lResult&amp; is set to TRUE (non-zero), the dialog was visible. If the dialog was previously hidden, lResult&amp; is set to FALSE (zero).\n\r\n\rRestrictions\n\r\n\rIn previous versions of PowerBASIC, the DIALOG SHOW STATE was not permitted to be executed before a DIALOG SHOW MODAL or DIALOG SHOW MODELESS statement had been executed for that specific dialog. Starting with this version of PowerBASIC, DIALOG SHOW STATE may be executed before or after the dialog is activated with DIALOG SHOW MODAL or DIALOG SHOW MODELESS statement.\n\r\n\rWhen utilized prior to dialog activation, the attributes %SW_HIDE, %SW_MAXIMIZE, and %SW_MINIMIZE are remembered for use when activated. All other possible attributes are translated to the standard %SW_SHOW. Generally speaking, it is unwise to use %SW_HIDE with a modal dialog.\n\r\n\rDIALOG SHOW STATE can be used to show a dialog before the message pump for a modeless dialog begins operating (i.e., after the DIALOG SHOW MODELESS statement, etc). However, until the message pump begins its operation, the dialog may not be drawn or displayed completely.\n\r\n\rFor more information on message pumps, see DIALOG DOEVENTS and DIALOG SHOW MODELESS.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL SHOW STATE, DIALOG DOEVENTS, DIALOG HIDE, DIALOG MAXIMIZE, DIALOG MINIMIZE, DIALOG NONSTABLE, DIALOG NORMALIZE, DIALOG SHOW MODAL, DIALOG SHOW MODELESS, DIALOG STABILIZE","DIALOG SHOW STATE statement","scr\\html_dialog_show_state.htm","                  \n\r\n\rPurpose\n\r\n\rMake a Dialog stabilized (non-closeable).\n\r\n\rSyntax\n\r\n\rDIALOG STABILIZE hDlg\n\r\n\rRemarks\n\r\n\rThe Dialog identified by the handle hDlg is stabilized, meaning that it cannot be closed by the user. If there is a system menu, the close option and the close box are grayed. The ALT-F4 close key is disabled. This allows you to be certain that your operations on the dialog can be completed. When a dialog is stabilized, only DIALOG END or program termination will close it.\n\r\n\rSee also\n\r\n\rDIALOG END, DIALOG NONSTABLE","DIALOG STABILIZE statement","scr\\html_dialog_stabilize_statement_.htm","                  \n\r\n\rPurpose\n\r\n\rConvert dialog units into pixels.\n\r\n\rSyntax\n\r\n\rDIALOG UNITS hDlg, x&amp;, y&amp; TO PIXELS xx&amp;, yy&amp;\n\r\n\rRemarks\n\r\n\rThe dialog units specified in the x&amp; and y&amp; variables are converted into pixels, based on the default font of the dialog specified by hDlg. The resultant pixel values are stored in the xx&amp; and yy&amp; variables.\n\r\n\rSee also\n\r\n\rDynamic Dialog Tools, CONTROL GET CLIENT, DIALOG GET CLIENT, DIALOG GET LOC, DIALOG GET SIZE, DIALOG PIXELS, DIALOG SET LOC, DIALOG SET SIZE","DIALOG UNITS statement","scr\\html_dialog_units.htm","                  \n\r\n\rLike control styles, DDT provides a default style for a dialog window, if the DIALOG NEW statement does not specify a specific style parameters.\n\r\n\rThe default style comprises the combination of %WS_POPUP, %WS_CAPTION, %DS_SETFONT, %DS_NOFAILCREATE, %DS_MODALFRAME, and %DS_3DLOOK. These equates are equivalent to a style of &amp;H080C00D4. The extended style default is zero.\n\r\n\rIf you explicitly specify %WS_CAPTION in your DIALOG NEW statement, DDT will interpret the width and height values as client dimensions, rather then as overall dialog dimensions. This can be very useful for the times when you need to build a dialog with particular client dimensions.\n\r\n\rYou can create dialogs using combinations of the following styles:\n\r\n\rStyle Equate\n\r\n\rDescription\n\r\n\r%WS_BORDER\n\r\n\rDialog has a thin-line border.\n\r\n\r%WS_CAPTION\n\r\n\rDialog has a title bar (includes the %WS_BORDER style).\n\r\n\r%WS_HSCROLL\n\r\n\rDialog contains a horizontal scroll bar.\n\r\n\r%WS_MAXIMIZE\n\r\n\rDialog is initially maximized.\n\r\n\r%WS_MAXIMIZEBOX\n\r\n\rDialog has a Maximize button, but must be used in conjunction with the %WS_SYSMENU style. You cannot combine this style with the %WS_EX_CONTEXTHELP extended style.\n\r\n\r%WS_MINIMIZE\n\r\n\rDialog is initially minimized.\n\r\n\r%WS_MINIMIZEBOX\n\r\n\rDialog has a Minimize button, but must be used in conjunction with the %WS_SYSMENU style. You cannot combine this style with the %WS_EX_CONTEXTHELP extended style.\n\r\n\r%WS_SIZEBOX\n\r\n\rDialog has a resizable border. Equivalent to the %WS_THICKFRAME style.\n\r\n\r%WS_SYSMENU\n\r\n\rDialog contains a system-menu on its title bar. Must be used in conjunction with the %WS_CAPTION style.\n\r\n\r%WS_THICKFRAME\n\r\n\rSee %WS_SIZEBOX.\n\r\n\r%WS_VSCROLL\n\r\n\rDialog contains a vertical scroll bar.\n\r\n\r%DS_3DLOOK\n\r\n\rDialog uses a non-bold font and uses three-dimensional borders around child controls. Not required with applications marked for #OPTION VERSION4 or #OPTION VERSION5, as Windows provides this style automatically.\n\r\n\r%DS_CENTER\n\r\n\rCenters the dialog box in the region of the screen that is not obscured by the taskbar and tray (i.e., the work area).\n\r\n\r%DS_CENTERMOUSE\n\r\n\rCenters the mouse cursor in the dialog.\n\r\n\r%DS_CONTEXTHELP\n\r\n\rPlaces a &quot;question mark&quot; button in the title bar of the dialog. If this button is clicked, the cursor changes to a pointer with a question mark. If the next click is on a control in the dialog, the control\'s Callback Function will receive a %WM_HELP message. When a dialog containing this style is created, Windows automatically adds the %WS_EX_CONTEXTHELP extended style. %DS_CONTEXTHELP is mutually exclusive with the %WS_MAXIMIZEBOX and %WS_MINIMIZEBOX styles.\n\r\n\r%DS_CONTROL\n\r\n\rDialog operates as a child of another dialog. For example, a modeless dialog is able to operate as a child window of a tab control (although the parent must be the tab control\'s owner, not the tab control itself). This style permits the TAB key to move from control to control in both the parent and the modeless dialog seamlessly, provided the parent includes the extended style %WS_EX_CONTROLPARENT.\n\r\n\r%DS_FIXEDSYS\n\r\n\rDialog uses the %SYSTEM_FIXED_FONT instead of the %SYSTEM_FONT.\n\r\n\r%DS_MODALFRAME\n\r\n\rUsed in combination with %WS_CAPTION and %WS_SYSMENU to produce a dialog with a title bar and system-menu.\n\r\n\r%DS_NOFAILCREATE\n\r\n\rDialog is created even if an error occurs during creation. Such an error may occur if a child control cannot be created successfully.\n\r\n\r%DS_SETFONT\n\r\n\rDuring dialog creation, the child controls in the dialog will be sent a %WM_SETFONT message in order to receive the handle of the font specified by the dialog.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rDynamic Dialog Tools (DDT)\n\r\n\rCreating a Dialog\n\r\n\rAdding Controls to the Dialog\n\r\n\rModal vs. Modeless\n\r\n\rControls\n\r\n\rControl Styles\n\r\n\rMenus","Dialog Styles","scr\\html_dialogstyles.htm","                  \n\r\n\rPurpose\n\r\n\rDeclare and dimension arrays, scalar variables, and pointers.\n\r\n\rSyntax\n\r\n\rArrays:\n\r\n\rDIM var[(subscripts)] [AS [GLOBAL | INSTANCE | LOCAL | STATIC | THREADED]type] [PTR | POINTER] [AT address] [, ...]\n\r\n\rDIM var[(subscripts)] \' var may include a type-specifier\n\r\n\r&nbsp;\n\r\n\rScalar variables:\n\r\n\rDIM var AS [GLOBAL | INSTANCE | LOCAL | STATIC | THREADED] type [PTR |POINTER] [, ...]\n\r\n\rDIM var &nbsp;\' var must include a type-specifier\n\r\n\rRemarks\n\r\n\rDIM declares var to be a variable or array whose type is specified by appending a type-specifier to the name or by using the AS type keyword. If the AS clause is used, the variable name cannot end with a type-specifier character.\n\r\n\rDIM can only be used inside a SUB, FUNCTION, METHOD, or PROPERTY. Outside of Subs, Functions, Methods, or Properties, use GLOBAL or INSTANCE to declare variables and arrays.\n\r\n\rDIM can also be used to dimension an &quot;absolute array&quot; - one that occupies a specific location in memory. This can be useful to dynamically &quot;superimpose&quot; one type of array directly over the top of an existing block of memory (which could be another type of array, or data structure). This would form a Union-like overlay structure. See below.\n\r\n\rIn addition, it is possible to create an array of pointers with the DIM statement, and it is also possible to do so at a specific location in memory. This is termed an &quot;absolute pointer array&quot;.\n\r\n\rDimensioning arrays\n\r\n\rsubscripts may take one of the following forms for each array dimensioned:\n\r\n\r(a) A comma-delimited list of one or more Long-integer expressions, each defining a dimension of the array. &nbsp;This form is used to declare arrays whose subscript (index) range starts at 0. For example, the following lines are equivalent ways of dimensioning the same array:\n\r\n\rDIM lArray(20) AS LONG &nbsp;\' With an AS type clause\n\r\n\ror\n\r\n\rDIM lArray&amp;(20) &nbsp; &nbsp; &nbsp; &nbsp; \' With a type-specifier\n\r\n\rBoth lines above define a one dimension Long-integer array that has 21 elements, from lArray(0) to lArray(20) inclusive. The second line uses a type-specifier symbol to specify the data type, and this uses a simplified syntax (trailing clauses/keywords are not permitted). The simplified syntax is only valid for data types that have a type-specifier symbol ($, !, @, @@, #, ##, %, &amp;, &amp;&amp;, ?, ??, ???), or the specifier can be omitted if there is a DEFtype statement in effect. The specifier must be omitted if #DIM ALL is in effect.\n\r\n\rDeclarations of multiple-dimension arrays take the following forms:\n\r\n\rDIM sArray(20,40,2) AS STRING\n\r\n\ror\n\r\n\rDIM sArray$(20,40,2)\n\r\n\rThese two lines of code define a dynamic string array with three dimensions, 21 elements by 41 elements by 3 elements, totaling 2583 string elements. As before, the second line uses the simplified syntax form.\n\r\n\r(b) A comma-delimited list where both the upper and lower subscript bounds are explicitly declared for each dimension of the array. &nbsp;For each dimension, the lower bound is listed first, followed by the TO keyword, followed by the upper bound. For example:\n\r\n\rDIM MyArray(1 TO 20) AS LONG\n\r\n\rdefines an array of one dimension that has 20 elements, from MyArray(1) to MyArray(20). The lower bound does not have to be zero or one; for example:\n\r\n\rDIM SalesByYear(1980 TO 2000) AS INTEGER\n\r\n\ror\n\r\n\rDIM SalesByYear%(1980 TO 2000)\n\r\n\rEach array can access elements in the range of -2,147,483,648 to 2,147,483,647. It is recommended that an explicit variable scope clause (GLOBAL/LOCAL/STATIC, THREADED, INSTANCE) be added to each DIM statement that uses an explicit type clause. See Restrictions below.\n\r\n\rArray Initialization and Absolute Arrays\n\r\n\rPowerBASIC generates an error message when it encounters an array that hasn\'t been dimensioned. If the array has already been dimensioned, the DIM statement is ignored. A new array is not created and a run-time error is not generated.\n\r\n\rWhen a program is first executed, PowerBASIC sets each element of a numeric array to zero, and sets each element of regular string arrays to a null string (length zero). However, when an absolute array is Dimensioned (at a specific location in memory using the AT address syntax), PowerBASIC does not initialize the memory occupied by the array. Further, when an absolute array is erased, the memory is not released either. This provides a powerful mechanism to create Union-like overlay structures in memory.\n\r\n\rThe most common use of an absolute array is when manipulating Visual Basic arrays directly from a DLL. This involves obtaining a pointer to the array, the element size, and the number of elements. With this information, an absolute array can be dimensioned in PowerBASIC and the array memory manipulated directly. Another common use involves using a large dynamic or fixed-length string memory block, overlaid with an absolute numeric array.\n\r\n\rCare must be exercised when using absolute arrays, since the contents of an absolute array can only be valid for the scope of the memory the array references. If an absolute array references memory that is LOCAL to the procedure, the array contents become invalidated if the target memory block is released. For example, by either explicitly deallocating the memory block, or exiting the procedure itself. Attempting to access absolute array memory that has been deallocated will likely trigger a General Protection Fault (GPF). On this basis, absolute arrays should be LOCAL to the procedure in which they are to be used.\n\r\n\rWhile PowerBASIC supports LBOUND values that are non-zero, PowerBASIC generates the most efficient code if the LBOUND parameter is omitted (i.e., the array uses the default LBOUND of zero). You should also avoid specifying an explicit LBOUND of zero, since this imposes a small efficiency penalty with no meaningful benefits\n\r\n\rDeclaring scalar (non-array) variables\n\r\n\rIf you have specified #DIM ALL or OPTION EXPLICIT, you have to declare all variables used in your programs. PowerBASIC provides a variation of the DIM statement for this job, because of the reduced level of syntax required for scalar variables. The following is a simplified syntax for DIM that just applies to scalar variables: \n\r\n\rDIM var AS [GLOBAL | INSTANCE | LOCAL | STATIC | THREADED] type [PTR | POINTER] [, ...]\n\r\n\rDIM var &nbsp; \' var must include a type-specifier\n\r\n\rHere are some sample variable declarations:\n\r\n\rDIM a AS LOCAL INTEGER\n\r\n\rDIM b AS STATIC WORD\n\r\n\rDIM c AS GLOBAL DOUBLE POINTER\n\r\n\rDIM d AS STRINGZ * 255\n\r\n\rDIM e AS THREADED STRING\n\r\n\rDIM f AS INSTANCE SINGLE\n\r\n\r&nbsp;\n\r\n\rAS type\n\r\n\rType\n\r\n\rBYTE\n\r\n\rByte\n\r\n\rWORD\n\r\n\rWord\n\r\n\rINTEGER\n\r\n\rInteger\n\r\n\rDWORD\n\r\n\rDouble-word\n\r\n\rLONG\n\r\n\rLong-integer\n\r\n\rQUAD\n\r\n\rQuad-integer\n\r\n\rSINGLE\n\r\n\rSingle-precision floating-point\n\r\n\rDOUBLE\n\r\n\rDouble-precision floating-point\n\r\n\rEXT\n\r\n\rExtended-precision floating-point\n\r\n\rEXTENDED\n\r\n\rExtended-precision floating-point\n\r\n\rCUR\n\r\n\rCurrency\n\r\n\rCURRENCY\n\r\n\rCurrency\n\r\n\rCUX\n\r\n\rExtended-currency\n\r\n\rCURRENCYX\n\r\n\rExtended-currency\n\r\n\rSTRING\n\r\n\rDynamic (variable-length) string\n\r\n\rWSTRING\n\r\n\rUnicode Dynamic string\n\r\n\rSTRING * x\n\r\n\rFixed-length string\n\r\n\rASCIIZ * x\n\r\n\rNul-terminated string\n\r\n\rASCIZ * x\n\r\n\rNul-terminated string\n\r\n\rSTRINGZ * x\n\r\n\rNul-terminated string\n\r\n\rWSTRINGZ * x\n\r\n\rUnicode Nul-Terminated string\n\r\n\rPointer\n\r\n\rPointer\n\r\n\rPtr\n\r\n\rPointer\n\r\n\rVARIANT\n\r\n\rVariant\n\r\n\rIAUTOMATION\n\r\n\rAutomation Interface\n\r\n\rIDISPATCH\n\r\n\rDispatch Interface\n\r\n\rIUNKNOWN\n\r\n\rDirect Interface\n\r\n\rGUID\n\r\n\r16-byte GUID string\n\r\n\rFIELD\n\r\n\rField string\n\r\n\rRestrictions\n\r\n\rLOCAL ASCIIZ, LOCAL fixed-length strings, and LOCAL UDTs are created on the stack frame of the Sub/Function/Method/Property in which they are declared. You must therefore use caution so that the combined local variable size does not exceed the allocated stack size. Unless you declare otherwise, PowerBASIC sets a default stack size of 1MB. If more stack space is required, you can allocate it with the #STACK metastament. There are no such limitations with GLOBAL, INSTANCE, THREADED, or STATIC variables.\n\r\n\rWhen a DIM statement is used (without an explicit scope clause), to declare a variable in a procedure, and an identical variable has already been declared as GLOBAL, the variable in the procedure will be given GLOBAL scope. For example:\n\r\n\rGLOBAL xyz AS LONG\n\r\n\r...\n\r\n\rSUB MySub\n\r\n\r &nbsp;DIM xyz AS LONG\n\r\n\r &nbsp;\' Here, xyz is a GLOBAL variable\n\r\n\rEND SUB\n\r\n\rTo ensure that the variable scope is LOCAL to the Sub/Function/Method/Property, use a LOCAL statement rather than a DIM statement. Alternatively, add an explicit scope clause to the DIM statement. For example:\n\r\n\rGLOBAL xyz AS LONG\n\r\n\r[statements]\n\r\n\rSUB MySub\n\r\n\r &nbsp;DIM xyz AS LOCAL LONG\n\r\n\r &nbsp;\' Here, xyz is a LOCAL variable\n\r\n\rEND SUB\n\r\n\rDeclaring pointer variables\n\r\n\rA pointer must be declared before it can be used. You use the DIM statement to declare pointers, and describe the type of data to which they point. When a pointer is declared, it is automatically initialized to a value of zero. This is known as a null-pointer. You must remember to initialize it to a valid address, or you will get a General Protection Fault (GPF). The syntax for declaring pointer variables is similar to that of regular variables:\n\r\n\rDIM var[(subscripts)] AS [GLOBAL | INSTANCE | LOCAL | STATIC | THREADED] type [PTR | POINTER] [, ...]\n\r\n\rHere are some examples of pointer variable declarations:\n\r\n\rDIM a &nbsp; &nbsp; &nbsp; &nbsp;AS BYTE PTR\n\r\n\rDIM b &nbsp; &nbsp; &nbsp; &nbsp;AS INTEGER POINTER\n\r\n\rDIM c &nbsp; &nbsp; &nbsp; &nbsp;AS STRING PTR * 25\n\r\n\rDIM d &nbsp; &nbsp; &nbsp; &nbsp;AS MyType POINTER\n\r\n\rDIM e(500) &nbsp; AS INTEGER PTR\n\r\n\rPointers themselves are stored as DWORD values.\n\r\n\rOptions\n\r\n\rThe scope of a variable or array is set using the GLOBAL, INSTANCE, LOCAL, STATIC, or THREADED keywords.\n\r\n\rRestrictions\n\r\n\rWhen returning a pointer to a calling Sub, Function, Method, or Property, make sure the pointer target remains valid when the current routine terminates. For example, returning a pointer to a LOCAL variable is certain to trigger a GPF, since local storage is released when the routine ends. In this case, the pointers target should be STATIC, GLOBAL, or INSTANCE, or be valid within the scope of the calling code.\n\r\n\rIAUTOMATION, IDISPATCH, IUNKNOWN, VARIANT and GUID variables have special uses with COM.\n\r\n\rSee also\n\r\n\r#DIM, ARRAYATTR, ERASE, GLOBAL, INSTANCE, Just what is COM?, LOCAL, REDIM, RESET, STATIC, THREADED, Variables, Variable Scope, What is an object, anyway?","DIM statement","scr\\html_dim_statement.htm","                  \n\r\n\rPurpose\n\r\n\rForce the release of the operating system FindNext handle.\n\r\n\rSyntax\n\r\n\rDIR$ CLOSE\n\r\n\rRemarks\n\r\n\rDIR$ CLOSE will cause the operating system FindNext handle to be closed. Each time a new DIR$() sequence is initiated within a thread, or DIR$() returns an empty string, PowerBASIC automatically closes the FindNext handle to avoid overuse of system resources.\n\r\n\rHowever, in unusual circumstances (such as a recursive directory scan with delete or rename), it may be necessary to close the FindNext handle sooner, through the use of this explicit statement, so that a directory can be removed or renamed.\n\r\n\rRestrictions\n\r\n\rIt is never necessary to execute DIR$ CLOSE to simply avoid a &quot;System Handle Leak&quot;.\n\r\n\rSee also\n\r\n\rDIR$","DIR$ CLOSE statement","scr\\html_dir_close_statement.htm","                  \n\r\n\rPurpose\n\r\n\rReturn a filename and/or directory entry that matches a file name mask and an optional attribute.\n\r\n\rSyntax\n\r\n\rfile$ = DIR$(mask$ [, [ONLY] attribute&amp;, TO DirDataVar])\n\r\n\rfile$ = DIR$([NEXT] [TO DirDataVar])\n\r\n\rRemarks\n\r\n\rThere are two forms to the DIR$() function. The first form, which includes a mask string and optional attribute, is used to find the first filename which matches. The second form, without those parameters, returns subsequent matching filenames. When the returned string is null (zero-length), there are no further matching filenames.\n\r\n\rThe second form may optionally specify the key-word NEXT to aid in self-documentation of the source code.\n\r\n\rmask$ specifies a filename or path which can include a drive name and system wildcard characters (* and ?). If the numeric attribute parameter is zero (or not specified), DIR$ returns only &quot;Normal&quot; files. If mask$ is a null (zero-length) string, the function call is equivalent to the second form of the function to find subsequent matching filenames. In that case, an optional attribute is ignored.\n\r\n\rIf an attribute&amp; is specified, it must use a standard operating system numeric attribute code. This causes DIR$ to include filenames with specific attributes in the search, in addition to normal files. &quot;Normal&quot; files are those which are not hidden or system files, nor are they a directory or a volume label.\n\r\n\r&nbsp;\n\r\n\rAttribute\n\r\n\rDescription\n\r\n\rEquate\n\r\n\r 0\n\r\n\rNormal\n\r\n\r%NORMAL\n\r\n\r 2\n\r\n\rHidden\n\r\n\r%HIDDEN\n\r\n\r 4\n\r\n\rSystem\n\r\n\r%SYSTEM\n\r\n\r 8\n\r\n\rVolume Label\n\r\n\r%VLABEL\n\r\n\r16\n\r\n\rDirectory\n\r\n\r%SUBDIR\n\r\n\r&nbsp;\n\r\n\rYou can search for filenames with multiple attributes set by adding the attribute codes together. For example, to search for hidden and system files, you\'d add those codes together (2 and 4) to get 6. All other attribute codes (except for volume label) are normally inclusive. For example, specifying both hidden and system results in DIR$ returning all hidden files, system files, normal files, and files that are both hidden and system.\n\r\n\rIf the ONLY option is included, normal files are excluded from the file search. For example: DIR$(mask$, ONLY 16) just the directory entries which match mask$ are returned. Another useful search attribute is 6, which returns normal, hidden, and system file, but no directories.\n\r\n\rAn attribute of 8 will return the volume label, if one exists. In this case, mask$ must reference the drive letter of the target drive, and additional path information is ignored. Additionally, you may specify a UNC name for a shared drive (subject to operating system restrictions), and retrieve the volume label, if one exists, and you have suitable access rights. You can also obtain the volume label for a \'hidden\' share with NT/2000/XP by appending a trailing dollar symbol to the share name.\n\r\n\r\' Retrieve volume for share \\\\server\\drive0\n\r\n\rA$ = DIR$(&quot;\\\\server\\drive0&quot;, 8)\n\r\n\r&nbsp;\n\r\n\r\' Retrieve volume for hidden share D: (\\d$)\n\r\n\rA$ = DIR$(&quot;\\\\server\\d$&quot;, %VLABEL)\n\r\n\rThe DIR$ function may optionally assign the complete directory entry to an appropriate UDT variable if you include the TO clause as a parameter. The complete directory entry contains 592 bytes of data, corresponding to the following TYPE definition. This definition (DIRDATA) is built into PowerBASIC, and need not necessarily be included in your source code. The DirData UDT is identical to the Unicode version of the Win32_Find_Data structure used by the Windows API for this purpose.\n\r\n\rTYPE DirData\n\r\n\r &nbsp;FileAttributes &nbsp; &nbsp; &nbsp; &nbsp;AS DWORD\n\r\n\r &nbsp;CreationTime &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;AS QUAD\n\r\n\r &nbsp;LastAccessTime &nbsp; &nbsp; &nbsp; &nbsp;AS QUAD\n\r\n\r &nbsp;LastWriteTime &nbsp; &nbsp; &nbsp; &nbsp; AS QUAD\n\r\n\r &nbsp;FileSizeHigh &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;AS DWORD\n\r\n\r &nbsp;FileSizeLow &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; AS DWORD\n\r\n\r &nbsp;Reserved0 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; AS DWORD\n\r\n\r &nbsp;Reserved1 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; AS DWORD\n\r\n\r &nbsp;FileName &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;AS WSTRINGZ * 260\n\r\n\r &nbsp;ShortName &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; AS WSTRINGZ * 14\n\r\n\rEND TYPE\n\r\n\rYou can declare a variable as DIRDATA for this purpose, or use any other user-defined type of at least 592 data bytes. The additional data may be used for any other purpose in your program.\n\r\n\rCreationTime, LastAccessTime, and LastWriteTime members of the DIRDATA can be assigned to a PowerTime object to convert the QUAD integer (FILETIME) values for easy calculations and conversions.\n\r\n\rLOCAL f AS STRING\n\r\n\rLOCAL d AS DIRDATA\n\r\n\rLOCAL t AS IPOWERTIME\n\r\n\r&nbsp;\n\r\n\rt = CLASS &quot;PowerTime&quot;\n\r\n\r...\n\r\n\rf = DIR$(&quot;c:\\*.*&quot; TO d)\n\r\n\rt.FileTime = d.CreationTime &nbsp; \' t contains the file creation time in a localized format.\n\r\n\r&nbsp;\n\r\n\rPrevious versions of PowerBASIC used an ANSI version of DirData which was only 318 bytes in size. However, if you utilized the built-in form of DirData, your program should execute correctly under this version with no changes needed.\n\r\n\rRestrictions\n\r\n\rPowerBASIC performs file matching with both the long (LFN) and short (SFN) filename versions of filenames. This means that DIR$ will also return filenames that start with the specified extension (as per standard Windows operating system behavior).\n\r\n\rFor example, A$ = DIR$(&quot;*.htm&quot;) will match filenames such as &quot;Index.htm&quot;, &quot;Default.html&quot;, &quot;Homepages.htmb&quot;, &quot;cgilib.htmlpages&quot;, etc. Similarly, A$ = DIR$(&quot;*.h??&quot;) and DIR$(&quot;*.ht*&quot;) will match the same filenames.\n\r\n\rDIR$ is thread-safe, so DIR$ operations in one thread do not interfere with DIR$ operations in another thread. However, you should be aware &nbsp;that specifying a new mask$ parameter always starts an entirely new &nbsp;DIR$ search loop.\n\r\n\rSee also\n\r\n\rCURDIR$, DIR$ CLOSE, DISPLAY BROWSE, DISPLAY OPENFILE, FILEATTR, GETATTR, ISFILE, PATHNAME$, PATHSCAN$, SETATTR\n\r\n\rExample\n\r\n\rThe following code shows a typical method of retrieving filenames from a directory:\n\r\n\rDIM Listing(1000) AS DirData\n\r\n\rDIM x&amp;, temp$\n\r\n\rtemp$ = DIR$(&quot;*.*&quot;, TO Listing(x&amp;))\n\r\n\rWHILE LEN(temp$) AND x&amp; &lt; 1000 \' max = 1000\n\r\n\r &nbsp;INCR x&amp;\n\r\n\r &nbsp;temp$ = DIR$(NEXT, TO Listing(x&amp;) )\n\r\n\rWEND","DIR$ function","scr\\html_dir_function.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the amount of available space on a disk, in bytes.\n\r\n\rSyntax\n\r\n\rbytes&amp;&amp; = DISKFREE(drive$)\n\r\n\rRemarks\n\r\n\rdrive$ specifies the drive letter or UNC share name (subject to operating system restrictions) of the disk to examine. If drive$ is an empty string, information on the default drive is returned.\n\r\n\rRestrictions\n\r\n\rWith Windows 95 versions before OSR2, and Windows NT versions before 4.0, DISKFREE may return a negative or inaccurate value for drives larger than 2 GB.\n\r\n\rSee also\n\r\n\rDISKSIZE\n\r\n\rExample\n\r\n\rDisplayText &quot;Free bytes on C: &quot; + FORMAT$(DISKFREE(&quot;C&quot;), &quot;#,###&quot;)","DISKFREE function","scr\\html_diskfree_function.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the total amount of space on a disk, in bytes.\n\r\n\rSyntax\n\r\n\rbytes&amp;&amp; = DISKSIZE(drive$)\n\r\n\rRemarks\n\r\n\rdrive$ specifies the drive letter or UNC share name (subject to operating system restrictions) of the disk to examine. If drive$ is an empty string, information on the default drive is returned.\n\r\n\rRestrictions\n\r\n\rWith Windows 95 versions before OSR2, and Windows NT versions before 4.0, DISKSIZE may return a negative or inaccurate value for drives larger than 2 GB.\n\r\n\rSee also\n\r\n\rDISKFREE\n\r\n\rExample\n\r\n\rDisplayText &quot;Total bytes on C: &quot; + FORMAT$(DISKSIZE(&quot;C&quot;), &quot;#,###&quot;)","DISKSIZE function","scr\\html_disksize_function.htm","                  \n\r\n\rPurpose\n\r\n\rDisplay a folder selection dialog to return the user\'s choice.\n\r\n\rSyntax\n\r\n\rDISPLAY BROWSE [hParent], [xpos&amp;], [ypos&amp;], title$, start$, flags&amp; TO folder$\n\r\n\rhParent\n\r\n\rHandle of the parent window or dialog. If there is no parent, use zero (0) or %HWND_DESKTOP.\n\r\n\rxpos&amp;\n\r\n\rHorizontal position, in pixels, relative to the parent window. If omitted, PowerBASIC selects the position (offset from the parent, or centered if no parent).\n\r\n\rypos&amp;\n\r\n\rVertical position, in pixels, relative to the parent window. If missing, PowerBASIC selects the position (offset from the parent, or centered if no parent).\n\r\n\rtitle$\n\r\n\rThe caption to be displayed below the caption bar of the dialog box. If this parameter is a null string, the title &quot;Open&quot; is displayed.\n\r\n\rstart$\n\r\n\rA string which specifies the starting path to be used as the initial default folder. This may be disabled by passing a nul, zero-length string (&quot;&quot;).\n\r\n\rflags&amp;\n\r\n\rThe style attributes of the BROWSE Dialog. The following values may be used alone or combined, and are predefined in the PowerBASIC compiler:\n\r\n\r%BIF_BROWSEINCLUDEFILES (4.71)\n\r\n\rThe dialog box will display both files and folders.\n\r\n\r%BIF_BROWSEINCLUDEURLS\n\r\n\rThe dialog box can display URL\'s if %BIF_USENEWUI and %BIF_BROWSEINCLUDEFILES are also set.\n\r\n\r%BIF_DONTGOBELOWDOMAIN\n\r\n\rDoes not include network folders below the domain level in the treeview control.\n\r\n\r%BIF_EDITBOX\n\r\n\rIncludes an edit control in the dialog box that allows the user to type the name of an item.\n\r\n\r%BIF_NEWDIALOGSTYLE (5.0)\n\r\n\rProvides the new user interface, a larger dialog box that can be resized. It also offers drag-and-drop capability within the dialog box, reordering, shortcut menus, new folders, delete, and other shortcut menu commands. This is the default style implemented by PowerBASIC.\n\r\n\r%BIF_NONEWFOLDERBUTTON (6.0)\n\r\n\rDo not include the &quot;New Folder&quot; button in the dialog box.\n\r\n\r%BIF_NOTRANSLATETARGETS (6.0)\n\r\n\rWhen the selected item is a shortcut, return the PIDL of the shortcut itself rather than its target.\n\r\n\r%BIF_RETURNFSANCESTORS\n\r\n\rOnly returns file system ancestors. With any other selection, the OK button is grayed.\n\r\n\r%BIF_RETURNONLYFSDIRS\n\r\n\rOnly returns file system directories. With any other selection, the OK button is grayed.\n\r\n\r%BIF_SHAREABLE (5.0)\n\r\n\rThe dialog box can display shareable resources on remote systems. It is intended for applications that want to expose remote shares on a local system. The %BIF_NEWDIALOGSTYLE flag must also be set.\n\r\n\r%BIF_UAHINT (6.0)\n\r\n\rWhen this flag is combined with %BIF_NEWDIALOGSTYLE, adds a usage hint to the dialog box in place of the edit box.\n\r\n\r%BIF_USENEWUI (5.0)\n\r\n\rUse the new user interface, plus an edit box.\n\r\n\rfolder$\n\r\n\rContains the drive letter and path to the folder the user selected. If an error occurs or the user clicks the cancel button, this variable is set to a nul, zero-length string.\n\r\n\rSee also\n\r\n\rDISPLAY COLOR, DISPLAY FONT, DISPLAY OPENFILE, DISPLAY SAVEFILE","DISPLAY BROWSE statement","scr\\html_display_browse_statement.htm","                  \n\r\n\rPurpose\n\r\n\rDisplay a color selection dialog to return the user\'s choice.\n\r\n\rSyntax\n\r\n\rDISPLAY COLOR [hParent], [xpos&amp;], [ypos&amp;], firstcolor&amp;, custcolors, flags&amp; TO colorval&amp;\n\r\n\rhParent\n\r\n\rHandle of the parent window or dialog. If there is no parent, use zero (0) or %HWND_DESKTOP.\n\r\n\rxpos&amp;\n\r\n\rHorizontal position, in pixels, relative to the parent window. If omitted, PowerBASIC selects the position (offset from the parent, or centered if no parent).\n\r\n\rypos&amp;\n\r\n\rVertical position, in pixels, relative to the parent window. If missing, PowerBASIC selects the position (offset from the parent, or centered if no parent).\n\r\n\rfirstcolor&amp;\n\r\n\rSpecifies the RGB color which is initially selected when the dialog box is created.\n\r\n\rcustcolors\n\r\n\rUser-Defined Type variable which is used to initialize and return 16 custom colors on the dialog. The UDT must have 16 members, each of which is a long integer or dword. They may be scalar members, or a member array.\n\r\n\rflags&amp;\n\r\n\rThe style attributes of the COLOR Dialog. The following values may be used alone or combined, and are predefined in the PowerBASIC compiler:\n\r\n\r%CC_FULLOPEN\n\r\n\rCauses the entire dialog box to appear when created, including the section which allows the user to create custom colors.\n\r\n\r%CC_PREVENTFULLOPEN\n\r\n\rDisables the &quot;Define Custom Colors&quot; button, preventing the creation of custom colors.\n\r\n\r%CC_SHOWHELP\n\r\n\rCauses the Help Button to be displayed. The hParent parameter must not be zero or %HWND_DESKTOP.\n\r\n\rcolorval&amp;\n\r\n\rThe RGB value of the selected color. If the user fails to make a color selection, or chooses CANCEL, the value -1 is assigned to the colorval&amp; variable.\n\r\n\rRemarks\n\r\n\rIf you offer the user the ability to create custom colors, it is suggested you retain the custcolors&amp; UDT variable without change. It may then be used again on a later invocation of DISPLAY COLOR with the user\'s custom colors intact.\n\r\n\rSee also\n\r\n\rBuilt In RGB Color Equates, DISPLAY BROWSE, DISPLAY FONT, DISPLAY OPENFILE, DISPLAY SAVEFILE, RGB","DISPLAY COLOR statement","scr\\html_display_color_statement.htm","                  \n\r\n\rPurpose\n\r\n\rDisplay a font selection dialog to return user choices.\n\r\n\rSyntax\n\r\n\rDISPLAY FONT [hParent], [xpos&amp;], [ypos&amp;], defname$, defpoints&amp;, defstyle&amp;, flags&amp; _\n\r\n\rTO fontname$, points&amp;, style&amp; [,colorval&amp;, charset&amp;]\n\r\n\rhParent\n\r\n\rHandle of the parent window or dialog. If there is no parent, use zero (0) or %HWND_DESKTOP.\n\r\n\rxpos\n\r\n\rHorizontal position, in pixels, relative to the parent window. If omitted, PowerBASIC selects the position (offset from the parent, or centered if no parent).\n\r\n\rypos\n\r\n\rVertical position, in pixels, relative to the parent window. If missing, PowerBASIC selects the position (offset from the parent, or centered if no parent).\n\r\n\rdefname$\n\r\n\rThe name of the default, pre-selected font which will be initially highlighted when the font dialog is displayed. A default font may be disabled by passing a nul, zero-length\n\r\n\r (&quot;&quot;).\n\r\n\rdefpoints&amp;\n\r\n\rThe point size of the default, pre-selected font.\n\r\n\rdefstyle&amp;\n\r\n\rThe style attribute of the default, pre-selected font. See the specific definition of style&amp; below.\n\r\n\rflags&amp;\n\r\n\rThe style attributes of the FONT Dialog. The following &nbsp;values may be used alone or combined, and are predefined in the PowerBASIC compiler:\n\r\n\r%CF_BOTH\n\r\n\rCauses the dialog box to list both screen and printer fonts.\n\r\n\r%CF_TTONLY\n\r\n\rSpecifies that Font selection dialog should only enumerate and allow the selection of TrueType fonts.\n\r\n\r%CF_EFFECTS\n\r\n\rSpecifies that Font selection dialog should enable strikeout, underline, and color effect choices.\n\r\n\r%CF_FIXEDPITCHONLY\n\r\n\rSpecifies that Font selection dialog should select only fixed-pitch fonts.\n\r\n\r%CF_FORCEFONTEXIST\n\r\n\rSpecifies that Font selection dialog should indicate an error condition if the user attempts to select a font or style that does not exist.\n\r\n\r%CF_NOSTYLESEL\n\r\n\rSpecifies that Font selection dialog should not make an initial style selection.\n\r\n\r%CF_NOSIZESEL\n\r\n\rSpecifies that Font selection dialog should not make an initial size selection.\n\r\n\r%CF_NOSIMULATIONS\n\r\n\rSpecifies that Font selection dialog should not allow graphics device interface (GDI) font simulations.\n\r\n\r%CF_NOVECTORFONTS\n\r\n\rSpecifies that Font selection dialog should not allow vector font selections.\n\r\n\r%CF_PRINTERFONTS\n\r\n\rCauses the Font selection dialog box to list only the fonts supported by the printer.\n\r\n\r%CF_SCALABLEONLY\n\r\n\rSpecifies that Font selection dialog should allow only the selection of scalable fonts. (Scalable fonts include vector fonts, scalable printer fonts, TrueType fonts, and fonts scaled by other technologies.)\n\r\n\r%CF_SCREENFONTS\n\r\n\rCauses the Font selection dialog box to list only the screen fonts supported by the system.\n\r\n\r%CF_WYSIWYG\n\r\n\rSpecifies that the Font selection dialog should allow only the selection of fonts available on both the printer and the display. If this flag is specified, the %CF_BOTH and %CF_SCALABLEONLY flags should also be specified.\n\r\n\rfontname$\n\r\n\rThe name of the font selected by the user\n\r\n\rpoints&amp;\n\r\n\rThe point size of the font selected by the user.\n\r\n\rstyle&amp;\n\r\n\rThe style attribute of the selected font. Any of the following values can be combined or used alone:\n\r\n\r0\n\r\n\rNormal\n\r\n\r1\n\r\n\rBold\n\r\n\r2\n\r\n\rItalic\n\r\n\r4\n\r\n\rUnderline\n\r\n\r8\n\r\n\rStrikeout\n\r\n\rFor example, if a style&amp; value of 3 is returned, it specifies that a combination of both bold and italic attributes was selected by the user.\n\r\n\rcolorval&amp;\n\r\n\rThe RGB value of the selected color.\n\r\n\rcharset&amp;\n\r\n\rThe chosen character set - 0 if a standard U.S. charset.\n\r\n\rSee also\n\r\n\rCONTROL SET FONT, DIALOG DEFAULT FONT, DISPLAY BROWSE, DISPLAY COLOR, DISPLAY OPENFILE, DISPLAY SAVEFILE, FONT END, FONT NEW, GRAPHIC SET FONT, XPRINT SET FONT","DISPLAY FONT statement","scr\\html_display_font_statement.htm","                  \n\r\n\rPurpose\n\r\n\rDisplay an OpenFile selection dialog to return user choices.\n\r\n\rSyntax\n\r\n\rDISPLAY OPENFILE [hParent], [xpos&amp;], [ypos&amp;], title$, folder$, filter$, _\n\r\n\r  start$, defextn$, flags&amp; TO filevar$ [,countvar&amp;]\n\r\n\rhParent\n\r\n\rHandle of the parent window or dialog. If there is no parent, use zero (0) or %HWND_DESKTOP.\n\r\n\rxpos&amp;\n\r\n\rHorizontal position, in pixels, relative to the parent window. If omitted, PowerBASIC selects the position (offset from the parent, or centered if no parent).\n\r\n\rypos&amp;\n\r\n\rVertical position, in pixels, relative to the parent window. If missing, PowerBASIC selects the position (offset from the parent, or centered if no parent).\n\r\n\rtitle$\n\r\n\rThe title to be displayed in the title bar of the dialog box. If this parameter is a null string, the title &quot;Open&quot; is displayed.\n\r\n\rfolder$\n\r\n\rThe name of the initial file directory to be displayed. If this parameter is a null string, the current directory is used. Future invocations remember and use the ending directory, rather than honoring a null string for the current directory.\n\r\n\rfilter$\n\r\n\rA string expression containing pairs of null-terminated filter strings. The first string in each pair describes the filter, and the second the filter pattern. For example, if you wish to display BASIC source files, you might use an expression like:\n\r\n\r&quot;BASIC&quot; + CHR$(0) + &quot;*.BAS&quot; + CHR$(0)\n\r\n\rA simpler method using the unique characteristics of the CHR$() function in PowerBASIC to achieve the same result:\n\r\n\rCHR$(&quot;BASIC&quot;, 0, &quot;*.BAS&quot;, 0)\n\r\n\rMultiple filters can be designated for a single item by separating filter pattern strings with a semicolon:\n\r\n\rCHR$(&quot;BASIC&quot;, 0, &quot;*.BAS;*.INC;*.BAK&quot;, 0)\n\r\n\rstart$\n\r\n\rA string which specifies the starting file name to be used as the initial file selection. This may be disabled by passing a null, zero-length string (&quot;&quot;).\n\r\n\rdefextn$\n\r\n\rA default extension to be appended to the selected file name if the user does not enter it. This may be disabled by passing a null, zero-length string (&quot;&quot;).\n\r\n\rflags&amp;\n\r\n\rThe style attributes of the OPENFILE Dialog. The following values may be used alone or combined, and are predefined in the PowerBASIC compiler:\n\r\n\r%OFN_ALLOWMULTISELECT\n\r\n\rMultiple selections are allowed. If the user chooses multiple items, the return value consists of multiple file names which are null-terminated.\n\r\n\r%OFN_CREATEPROMPT\n\r\n\rThe user may specify a file which does not exist.\n\r\n\r%OFN_ENABLESIZING\n\r\n\rThe dialog may be resized by the user, but future invocations remember and use the ending size and screen location, rather than honoring xpos and ypos parameter values. The position parameters are ignored.\n\r\n\r%OFN_EXPLORER\n\r\n\rThe dialog uses the Explorer style interface. This is the default condition, even if the flag is not set.\n\r\n\r%OFN_FILEMUSTEXIST\n\r\n\rThe user may not specify a file which does not exist.\n\r\n\r%OFN_NODEREFERENCELINKS\n\r\n\rThe dialog returns the name of the selected shortcut (.LNK) file. If this value is not given, the name of the file referenced by the shortcut is returned.\n\r\n\r%OFN_NONETWORKBUTTON\n\r\n\rHides and disables the network button.\n\r\n\r%OFN_NOTESTFILECREATE\n\r\n\rThe file is not created before the dialog is closed.\n\r\n\r%OFN_NOVALIDATE\n\r\n\rThe file name is not validated for invalid characters.\n\r\n\r%OFN_PATHMUSTEXIST\n\r\n\rThe user may type only valid paths and filenames.\n\r\n\r%OFN_SHAREAWARE\n\r\n\rIf the dialog fails because of a network sharing violation, the error is ignored and the selected filename is returned.\n\r\n\r%OFN_SHOWHELP\n\r\n\rThe help button is displayed.\n\r\n\rReturn Values\n\r\n\r&nbsp;\n\r\n\rfilevar$\n\r\n\rIf the user selects one file, this variable receives the drive, path, and name of that file, followed by a $NUL terminator. If the user selects no files, an error occurs, or cancel/close is chosen, this variable is set to a null, zero-length string.\n\r\n\rIf the user selects multiple files, and specified the flag %OFN_ALLOWMULTISELECT, the returned string consists of the path name (which applies to all selected files), followed by each of the file names of the selected files. Each of these text items are delimited in the returned string by a nul - CHR$(0). You can extract each of the multiple names with the PARSE$() function or the PARSE statement.\n\r\n\rWindows imposes a text limit of 32K (32,768 bytes) for the returned string value. If it is exceeded, a nul, zero-length string is returned.\n\r\n\rcountvar&amp;\n\r\n\rIf this optional long integer variable is included, it receives a count of the number of file names which were selected by the user.\n\r\n\rRemarks\n\r\n\rThe current default directory is never altered by this statement, even if the user changes the directory while searching for files.\n\r\n\rSee also\n\r\n\rDISPLAY BROWSE, DISPLAY COLOR, DISPLAY FONT, DISPLAY SAVEFILE","DISPLAY OPENFILE statement","scr\\html_display_openfile_statement_.htm","                  \n\r\n\rPurpose\n\r\n\rDisplay a SaveFile selection dialog to return user choices.\n\r\n\rSyntax\n\r\n\rDISPLAY SAVEFILE [hParent], [xpos&amp;], [ypos&amp;], title$, folder$, filter$, _\n\r\n\r  start$, defext$, flags&amp; TO filevar$ [,countvar&amp;]\n\r\n\rhParent\n\r\n\rHandle of the parent window or dialog. If there is no parent, use zero (0) or %HWND_DESKTOP.\n\r\n\rxpos&amp;\n\r\n\rHorizontal position, in pixels, relative to the parent window. If omitted, PowerBASIC selects the position (offset from the parent, or centered if no parent).\n\r\n\rypos&amp;\n\r\n\rVertical position, in pixels, relative to the parent window. If missing, PowerBASIC selects the position (offset from the parent, or centered if no parent).\n\r\n\rtitle$\n\r\n\rThe title to be displayed in the title bar of the dialog box. If this parameter is a null string, the title &quot;Save As&quot; is displayed.\n\r\n\rfolder$\n\r\n\rThe name of the initial file directory to be displayed. If this parameter is a null string, the current directory is used.\n\r\n\rfilter$\n\r\n\rA string expression containing pairs of null-terminated filter strings. The first string in each pair describes the filter, and the second the filter pattern. For example, if you wish to display BASIC source files, you might use an expression like:\n\r\n\r&quot;BASIC&quot; + CHR$(0) + &quot;*.BAS&quot; + CHR$(0)\n\r\n\rA simpler method using the unique characteristics of the CHR$() function in PowerBASIC to achieve the same result:\n\r\n\rCHR$(&quot;BASIC&quot;, 0, &quot;*.BAS&quot;, 0)\n\r\n\rMultiple filters can be designated for a single item by separating filter pattern strings with a semicolon:\n\r\n\rCHR$(&quot;BASIC&quot;, 0, &quot;*.BAS;*.INC;*.BAK&quot;, 0)\n\r\n\rstart$\n\r\n\rA string which specifies the starting file name to be used as the initial file selection. This may be disabled by passing a nul, zero-length string (&quot;&quot;).\n\r\n\rdefext$\n\r\n\rA default extension to be appended to the selected file name if the user does not enter it. This may be disabled by passing a nul, zero-length string (&quot;&quot;).\n\r\n\rflags&amp;\n\r\n\rThe style attributes of the SAVEFILE Dialog. The following values may be used alone or combined, and are predefined in the PowerBASIC compiler:\n\r\n\r%OFN_ALLOWMULTISELECT\n\r\n\rMultiple selections are allowed. If the user chooses multiple items, the return value consists of multiple file names which are null-terminated.\n\r\n\r%OFN_CREATEPROMPT\n\r\n\rThe user may specify a file which does not exist.\n\r\n\r%OFN_ENABLESIZING\n\r\n\rThe dialog may be resized by the user, but future invocations remember and use the ending size and screen location, rather than honoring xpos and ypos parameter values. The position parameters are ignored.\n\r\n\r%OFN_EXPLORER\n\r\n\rThe dialog uses the Explorer style interface. This is the default condition, even if the flag is not set.\n\r\n\r%OFN_FILEMUSTEXIST\n\r\n\rThe user may not specify a file which does not exist.\n\r\n\r%OFN_NODEREFERENCELINKS\n\r\n\rThe dialog returns the name of the selected shortcut (.LNK) file. If this value is not given, the name of the file referenced by the shortcut is returned.\n\r\n\r%OFN_NONETWORKBUTTON\n\r\n\rHides and disables the network button.\n\r\n\r%OFN_NOTESTFILECREATE\n\r\n\rThe file is not created before the dialog is closed.\n\r\n\r%OFN_NOVALIDATE\n\r\n\rThe file name is not validated for invalid characters.\n\r\n\r%OFN_PATHMUSTEXIST\n\r\n\rThe user may type only valid paths and filenames.\n\r\n\r%OFN_OVERWRITEPROMPT\n\r\n\rThe user may select a filename that already exists.\n\r\n\r%OFN_SHAREAWARE\n\r\n\rIf the dialog fails because of a network sharing violation, the error is ignored and the selected filename is returned.\n\r\n\r%OFN_SHOWHELP\n\r\n\rThe help button is displayed.\n\r\n\rReturn Values\n\r\n\r&nbsp;\n\r\n\rfilevar$\n\r\n\rIf the user selects one file, this variable receives the drive, path, and name of that file. If the user selects no files, an error occurs, or cancel/close is chosen, this variable is set to a nul, zero-length string.\n\r\n\rIf the user selects multiple files, and specified the flag %OFN_ALLOWMULTISELECT, the returned string consists of the path name (which applies all selected files), followed by each of the file names of the selected files. Each of these text items are delimited in the returned string by a nul - CHR$(0). You can extract each of the multiple names with the PARSE$() function or the PARSE statement.\n\r\n\rWindows imposes a text limit of 32K (32,768 bytes) for the returned string value. If it is exceeded, a nul, zero-length string is returned.\n\r\n\rcountvar&amp;\n\r\n\rIf this optional long integer variable is included, it receives a count of the number of file names which were selected by the user.\n\r\n\rRemarks\n\r\n\rThe current default directory is never altered by this statement, even if the user changes the directory while searching for files.\n\r\n\rSee also\n\r\n\rDISPLAY BROWSE, DISPLAY COLOR, DISPLAY FONT, DISPLAY OPENFILE","DISPLAY SAVEFILE statement","scr\\html_display_savefile_statement_.htm","                  \n\r\n\rA very simple example is a DLL with a function that will add one to any Long-integer passed to it as a parameter:\n\r\n\r#COMPILE DLL\n\r\n\rFUNCTION AddOne ALIAS &quot;AddOne&quot; (BYVAL x AS LONG) EXPORT AS LONG\n\r\n\r &nbsp;AddOne = x + 1\n\r\n\rEND FUNCTION\n\r\n\rThe ALIAS keyword is used to indicate the capitalization that PowerBASIC will assign the function. In Win32, all exported (and imported) Sub and Function names are case-sensitive. If the ALIAS keyword was omitted, PowerBASIC will capitalize the exported name and this could cause &quot; Missing DLL entry point&quot; errors if the calling code did not match the capitalization exactly.\n\r\n\rBy default, all Subs and Functions in PowerBASIC are private, which means they cannot be seen outside of the DLL. The EXPORT keyword is used on the Sub or Function definition line to indicate that the routine is to be exported, i.e., made accessible to applications and other DLLs.\n\r\n\rWhen compiled into a DLL, AddOne is visible to outside applications. A Visual Basic program needs only include a prototype, or a DECLARE statement for the function, in order to call it as if it were a VB function:\n\r\n\rDECLARE FUNCTION AddOne LIB &quot;ADDONE.DLL&quot; ALIAS &quot;ADDONE&quot; (BYVAL x&amp;) AS LONG\n\r\n\rAddOne is then accessible from within your Visual Basic code:\n\r\n\ra&amp; = 4\n\r\n\rb&amp; = AddOne( a&amp; ) \' returns 5\n\r\n\rIf AddOne were not exported, Visual Basic would generate a run-time error when the example code attempts to call it.\n\r\n\rIf the EXPORT keyword is not used in the Sub or Function definition, the procedure will not be visible to outside applications. See the Visual Basic documentation for more information on calling DLLs from within Visual Basic code.\n\r\n\rBy using the ALIAS keyword in the DLL source code, you can have PowerBASIC export the Sub or Function using any capitalization you want. You can use the ALIAS clause to export the Sub or Function with a completely different name, in order to enhance or disguise the internal Sub or Function name:\n\r\n\r\' Exported as &quot;ADDONE1&quot;\n\r\n\rFUNCTION AddOne1 (BYVAL x&amp;) EXPORT AS LONG\n\r\n\r&nbsp;\n\r\n\r\' Exported as &quot;AddOne2&quot;\n\r\n\rFUNCTION AddOne2 ALIAS &quot;AddOne2&quot; (BYVAL x&amp;) EXPORT AS LONG\n\r\n\r&nbsp;\n\r\n\r\' Exported as &quot;ExprtFnctn1&quot;\n\r\n\rFUNCTION AddOne3 ALIAS &quot;ExprtFnctn1&quot; (BYVAL x&amp;) EXPORT AS LONG\n\r\n\rBecause the name after the ALIAS keyword is in quotes, the compiler will not convert it to upper case. Note that the name in the ALIAS clause is the name that you would use to access the Sub or Function from Visual Basic. Likewise, when importing Subs and Functions from external DLLs into PowerBASIC, the ALIAS clause must exactly match the capitalization of the exported name in the DLL.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rWhat is a Dll?\n\r\n\rCreating a Dynamic Link Library\n\r\n\rPrivate and Exported Procedures\n\r\n\rLibMain\n\r\n\rWhat is an object, anyway?\n\r\n\rJust what is COM?\n\r\n\rWhat is a COM component?","Dll example","scr\\html_dll_example.htm","                  \n\r\n\rPurpose\n\r\n\rDefine a group of program statements that are executed repetitively as long as a certain condition is met.\n\r\n\rSyntax\n\r\n\rDO [{WHILE | UNTIL} expression]\n\r\n\r &nbsp;[statements]\n\r\n\r &nbsp;[EXIT LOOP]\n\r\n\r &nbsp;[statements]\n\r\n\r &nbsp;[ITERATE LOOP]\n\r\n\r &nbsp;[statements]\n\r\n\rLOOP [{WHILE | UNTIL} expression]\n\r\n\rRemarks\n\r\n\rexpression is a numeric expression, in which non-zero values represent logical TRUE, and zero values represent logical FALSE. If a string expression is used (i.e., A$ &lt;&gt; &quot;&quot;), PowerBASIC returns TRUE if the length of result of the string expression is greater than zero.\n\r\n\rDO/LOOP statements are extremely flexible. They can be used to create loops for almost any imaginable programming situation. They allow you to create loops with the test for the terminating condition at the top of the loop, the bottom of the loop, both places, or none of the above.\n\r\n\rA DO statement must always be paired with a matching LOOP statement at the bottom of the loop. Failure to match each DO with a LOOP results in either a compile-time Error 448 (&quot;DO loop expected&quot;) or an Error 456 (&quot;LOOP/WEND expected&quot;).\n\r\n\rThe WHILE and UNTIL keywords are used to add tests to a DO/LOOP. Use the WHILE if the loop should be repeated if expression is TRUE, and terminated if expression is FALSE. UNTIL has the opposite effect; that is, the loop will be terminated if expression is TRUE, and repeated if FALSE.\n\r\n\rFor example:\n\r\n\rDO WHILE a = 13\n\r\n\r &nbsp;[statements]\n\r\n\rLOOP\n\r\n\rexecutes the statements between DO and LOOP as long as a is 13. If a is not 13 initially, the statements in the loop are never executed. Conversely:\n\r\n\rDO UNTIL a = 13\n\r\n\r &nbsp;[statements]\n\r\n\rLOOP\n\r\n\rexecutes the statements between DO and LOOP as long as a is not 13. If a equals 13 initially, the loop is never executed.\n\r\n\rAt any point in a DO/LOOP, you can include an EXIT LOOP or ITERATE LOOP statement. EXIT LOOP causes the loop to terminate, so that execution continues after the terminating loop statement. ITERATE LOOP causes the loop to continue at the terminating loop statement. \n\r\n\rThe WHILE/WEND statements can be used in many cases to perform the same functions as DO/LOOP. For example, this DO/LOOP:\n\r\n\rDO WHILE a &lt; b\n\r\n\r &nbsp;[statements]\n\r\n\rLOOP\n\r\n\rhas the same effect as this WHILE/WEND loop:\n\r\n\rWHILE a &lt; b\n\r\n\r &nbsp;[statements]\n\r\n\rWEND\n\r\n\rWhen using nested loops, be careful that inner loops do not modify variables that are used by the outer loop\'s terminating condition test. For example, the following code was intended to get all 20 elements of a 10x2 array (dimensioned arry(9,1)):\n\r\n\rCount1 = 0\n\r\n\rDO WHILE Count1 &lt; 10\n\r\n\r &nbsp;FOR Count2 = 0 TO 1\n\r\n\r &nbsp; &nbsp;x = arry(Count1,Count2)\n\r\n\r &nbsp; &nbsp;Count1 = Count1 + 1\n\r\n\r &nbsp;NEXT Count2\n\r\n\rLOOP\n\r\n\rBecause Count1 is incremented within the inner loop, which executes twice for each pass through the outer loop, this code would not get all the array values, but would only get the values for arry(0,0), arry(1,1), arry(2,0), arry(3,1) and so on. By moving the Count1 = Count1 + 1 statement to just below the NEXT Count2 statement, the code functions as intended.\n\r\n\rIf an EXIT LOOP statement is used within nested loops, it exits only the current loop, not the entire nest. Similarly, an ITERATE within nested loops iterates the current loop. For advice on exiting nested block structures, please refer to the EXIT statement. The PowerBASIC logical operators can be used to construct multiple test conditions for loop control. For example:\n\r\n\rDO WHILE x &lt; 10 AND y &lt; 10\n\r\n\r &nbsp;[statements]\n\r\n\rLOOP\n\r\n\ris executed only as long as both x and y are less than 10. Similarly, the loop:\n\r\n\rDO UNTIL X &gt; 10 OR Y &gt; 10\n\r\n\r &nbsp;[statements]\n\r\n\rLOOP\n\r\n\ris executed until either x or y (or both) is (are) greater than 10. See the data types and Arithmetic Operators topics for more information about using logical operators.\n\r\n\rAlthough the compiler doesn\'t care about such things, it is a good idea when writing your source code to indent the statements between DO and LOOP. The same is true of FOR/NEXT loops, WHILE/WEND loops, and multi-line IF statements. Such indenting makes the appearance of your source code reflect the logical structure of your program, resulting in greater readability. Indenting is particularly valuable when nesting multiple loops of the same type, since it makes it easier to see which LOOP goes with which DO.\n\r\n\rAlso see the discussion on the IF statement for notes on PowerBASIC\'s Short-circuit evaluation and its possible side effects.\n\r\n\rSee also\n\r\n\r#OPTIMIZE, EXIT, FOR EACH/NEXT, FOR/NEXT, IF, ITERATE, WHILE/WEND","DO/LOOP statements","scr\\html_do_loop_statements.htm","                  \n\r\n\rDouble-precision floating-point numbers are to Single-precision numbers what Long-integers are to Integers. They take twice as much space in memory (8 bytes versus 4 bytes), but have a greater range (+/- 4.19*10^-307 to 1.79*10^308) and a greater accuracy (15 to 16 digits of precision versus the 6 digits of Single-precision). A Double-precision, 5,000-element array requires 40,000 bytes. An Integer array with the same number of elements occupies only 10,000 bytes. The type-specifier character for a Double-precision floating-point is: #.\n\r\n\rDouble-precision variables are identified by following the variable name with a Number symbol (i.e., var#) or by using the DEFDBL statement as described in the previous discussion of Integers. You can also declare Double-precision variables using the DOUBLE keyword with the DIM statement. For example:\n\r\n\rDIM I AS DOUBLE\n\r\n\rC/C++, Delphi, and Visual Basic all offer a double data type that is identical to the PowerBASIC Double-precision variable.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rArray Data Types\n\r\n\rBit Data Types\n\r\n\rConstants and Literals\n\r\n\rGUID Data Types\n\r\n\rObject Data Types\n\r\n\rPointers\n\r\n\rUser Defined Types\n\r\n\rUnions\n\r\n\rVariant Data Types","Double-precision floating-point (#)","scr\\html_double_precision_floating_point_(_).htm","                  \n\r\n\rDouble-words are 32-bit (four byte) unsigned integer with a range of 0 to 4,294,967,295 &nbsp;( 0 to 2^32-1). The type-specifier character for a Double-word is: ???.\n\r\n\rDouble-word variables are identified by following the variable name with three question marks (i.e., var???), or by using the DEFDWD statement as described in the previous discussion of Integers. You can also declare Double word variables using the DWORD keyword with the DIM statement. For example:\n\r\n\rDIM I AS DWORD\n\r\n\rAs for Word values and Integers, Double-word values have a larger positive range than a Long-integer, and still require only four bytes. Double-word values are useful for indicating absolute memory addresses, such as may be used to store pointer values.\n\r\n\rA PowerBASIC Double-word is equivalent to a UINT32 in C/C++. In 32-bit C/C++ code, a UINT is also equivalent to a PowerBASIC Double-word variable. Note that 16-bit C/C++ code uses UINT to describe a 16-bit Word variable.\n\r\n\rA C++ unsigned int and a Delphi longword are equivalent to a PowerBASIC Double-word.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rArray Data Types\n\r\n\rBit Data Types\n\r\n\rConstants and Literals\n\r\n\rGUID Data Types\n\r\n\rObject Data Types\n\r\n\rPointers\n\r\n\rUser Defined Types\n\r\n\rUnions\n\r\n\rVariant Data Types ","Double-word (???)","scr\\html_double_word_(___).htm","                  \n\r\n\rDynamic string variables (also known as variable-length) may contain an arbitrary number of characters. Internally, each &nbsp;variable uses four bytes that contain a handle number, which is used to identify and locate information about the string. The type-specifier character is $ for an ANSI dynamic string, or $$ for a wide Unicode string.\n\r\n\rString variables are automatically declared when the variable name is followed by one or two dollar signs ($). You can also declare dynamic string variables using the STRING or WSTRING keywords with the DIM statement. For example:\n\r\n\r &nbsp; &nbsp; &nbsp; &nbsp;DIM MyStr AS WSTRING\n\r\n\rPowerBASIC allocates strings using the Win32 OLE string engine. This allows you to pass strings from your program to DLLs, or API calls that support OLE strings. The address of the contents of a non-empty string can be obtained with the STRPTR function. The address of the string handle can be obtained with VARPTR function. An empty (null) string may not return a valid STRPTR value. Dynamic strings move in memory with each assignment statement: that is, STRPTR will return a different address when the content of the string is changed. However, the associated string handle obtained by VARPTR stays constant for the duration of the life (scope) of the string variable.\n\r\n\rLOCAL dynamic string memory and handles are released when the associated Sub, Function, Method, or Property ends. Subsequent calls to a routine will result in new storage locations for both the handle and the string data. The address of the handle of a STATIC or GLOBAL dynamic string stays constant for the duration of the module. Dynamic strings and field strings cannot be part of UDT (User-Defined Type) or UNION structures. In C/C++, a dynamic wide string ($$) is referred to as a BSTR data type.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rNul-Terminated Strings\n\r\n\rFIELD strings\n\r\n\rFixed-length strings\n\r\n\rString expressions","Dynamic (Variable-length) strings ($)","scr\\html_dynamic_(variable_length)_strings_($)($$).htm","                  \n\r\n\rWelcome to PowerBASIC\'s powerful and improved Dynamic Dialog Tools. DDT allows a BASIC programmer to easily create a Graphical User Interface (GUI) for an application using simple BASIC statements. With DDT, there\'s no need to stress over learning how to effectively use GUI design software that contains icons you don\'t understand and also hundreds of cryptic &quot;property&quot; settings. With DDT, your PowerBASIC application or DLL can create user interface dialogs &quot;on the fly&quot;.\n\r\n\rFor programmers who are familiar with DDT, you will find that PowerBASIC has expanded the DDT implementation even further in this version of PowerBASIC, with advanced features such as User Data storage and accelerator tables.\n\r\n\rThis chapter describes PowerBASIC\'s Dynamic Dialog Tools and how to easily create full-featured Graphical User Interfaces in your code.\n\r\n\r&nbsp;\n\r\n\rSee Also \n\r\n\rCreating a Dialog\n\r\n\rAdding Controls to the Dialog\n\r\n\rModal vs. Modeless\n\r\n\rControls\n\r\n\rControl Styles\n\r\n\rCallbacks\n\r\n\rDialog Styles\n\r\n\rMenus\n\r\n\rMenu Walkthrough\n\r\n\rMore on the Menu\n\r\n\rMenu State\n\r\n\rMenu Example","Dynamic Dialog Tools (DDT)","scr\\html_dynamic_dialog_tools.htm","                  \n\r\n\rThe following functions can be used to create GUI application interfaces:\n\r\n\rACCEL ATTACH\n\r\n\rAttach a table of keyboard accelerators to a DDT dialog.\n\r\n\rCALLBACK FUNCTION\n\r\n\rDefine a Dialog/Control Callback Function block.\n\r\n\rCB.CTL\n\r\n\rReturn the numeric ID of the control sending a callback message.\n\r\n\rCB.CTLMSG\n\r\n\rReturn the numeric notification message parameter.\n\r\n\rCB.HNDL\n\r\n\rReturn the window handle of the parent dialog receiving the message.\n\r\n\rCB.LPARAM\n\r\n\rReturn the numeric value of the lParam&amp; parameter of the message.\n\r\n\rCB.MSG\n\r\n\rReturn the numeric value of the message sent by the caller.\n\r\n\rCB.WPARAM\n\r\n\rReturn the numeric value of the wParam&amp; parameter of the message.\n\r\n\rCB.NMCODE\n\r\n\rReturn the numeric value of the notification message describing the event which occurred.\n\r\n\rCB.NMHDR\n\r\n\rReturns the address (a pointers) to the NMHDR UDT for this notification message.\n\r\n\rCB.NMHDR$\n\r\n\rReturns the contents of the NMHDR UDT as a dynamic string.\n\r\n\rCB.NMHWND\n\r\n\rReturns the handle of the control which sent this message.\n\r\n\rCB.NMID\n\r\n\rReturns the ID number assigned to the control.\n\r\n\rCLIPBOARD GET BITMAP\n\r\n\rA bitmap is copied from the CLIPBOARD and stored in a newly created GRAPHIC BITMAP.\n\r\n\rCLIPBOARD GET OEMTEXT\n\r\n\rA text string is retrieved from the CLIPBOARD. If necessary, it is converted to OEM Text format.\n\r\n\rCLIPBOARD GET TEXT\n\r\n\rA text string is retrieved from the CLIPBOARD. If necessary, it is converted to ASCII Text format.\n\r\n\rCLIPBOARD GET UNICODE\n\r\n\rA text string is retrieved from the CLIPBOARD. If necessary, it is converted to Unicode Text format.\n\r\n\rCLIPBOARD RESET\n\r\n\rThe contents of the CLIPBOARD are deleted.\n\r\n\rCLIPBOARD SET BITMAP\n\r\n\rCopies a GRAPHIC BITMAP to the CLIPBOARD.\n\r\n\rCLIPBOARD SET OEMTEXT\n\r\n\rCopies a OEM text string to the CLIPBOARD.\n\r\n\rCLIPBOARD SET TEXT\n\r\n\rCopies a ASCII text string to the CLIPBOARD.\n\r\n\rCLIPBOARD SET UNICODE\n\r\n\rCopies a Unicode text string to the CLIPBOARD.\n\r\n\rCOMBOBOX ADD\n\r\n\rAdd a string value to a combo box control.\n\r\n\rCOMBOBOX DELETE\n\r\n\rRemove a string from a combo box control.\n\r\n\rCOMBOBOX FIND\n\r\n\rStrings in the COMBOBOX are searched to find the first string which begins with the specified characters.\n\r\n\rCOMBOBOX FIND EXACT\n\r\n\rStrings in the COMBOBOX are searched to find the first string which exactly matches the specified characters.\n\r\n\rCOMBOBOX GET COUNT\n\r\n\rThe number of items in the list box of the COMBOBOX is retrieved.\n\r\n\rCOMBOBOX GET SELCOUNT\n\r\n\rThe number of selected items in the list box of the COMBOBOX is retrieved.\n\r\n\rCOMBOBOX GET SELECT\n\r\n\rThe index of the currently selected item in the list box of the COMBOBOX is retrieved.\n\r\n\rCOMBOBOX GET STATE\n\r\n\rA data item is checked to see if it is currently selected.\n\r\n\rCOMBOBOX GET TEXT\n\r\n\rRetrieve the default text from a combo box.\n\r\n\rCOMBOBOX GET USER\n\r\n\rRetrieve the value in the user data area of the COMBOBOX.\n\r\n\rCOMBOBOX INSERT\n\r\n\rInsert a new data item at a specified location.\n\r\n\rCOMBOBOX RESET\n\r\n\rRemove all strings from a combo box.\n\r\n\rCOMBOBOX SELECT\n\r\n\rSelect a string in a combo box and make it the default selection.\n\r\n\rCOMBOBOX SET TEXT\n\r\n\rReplace the string for a specific data item with a new string.\n\r\n\rCOMBOBOX SET USER\n\r\n\rSet a value in the user data area of the COMBOBOX.\n\r\n\rCOMBOBOX UNSELECT\n\r\n\rAll items in a COMBOBOX control are set to an unselected state.\n\r\n\rCONTROL ADD\n\r\n\rAdd a custom control to a DDT dialog.\n\r\n\rCONTROL ADD BUTTON\n\r\n\rAdd a command button to a dialog.\n\r\n\rCONTROL ADD CHECK3STATE\n\r\n\rAdd an auto 3-state checkbox to a dialog.\n\r\n\rCONTROL ADD CHECKBOX\n\r\n\rAdd an checkbox to a dialog.\n\r\n\rCONTROL ADD COMBOBOX\n\r\n\rAdd a combo box to a dialog.\n\r\n\rCONTROL ADD FRAME\n\r\n\rAdd a frame control to a dialog.\n\r\n\rCONTROL ADD GRAPHIC\n\r\n\rAdd a graphic control to a dialog.\n\r\n\rCONTROL ADD HEADER\n\r\n\rAdd a header control to a dialog.\n\r\n\rCONTROL ADD IMAGE\n\r\n\rAdd a non-resizing image control to a dialog.\n\r\n\rCONTROL ADD IMAGEX\n\r\n\rAdd an image control to a dialog.\n\r\n\rCONTROL ADD IMGBUTTON\n\r\n\rAdd a non-resizing image button to a dialog.\n\r\n\rCONTROL ADD IMGBUTTONX\n\r\n\rAdd an image button to a dialog.\n\r\n\rCONTROL ADD LABEL\n\r\n\rAdd a text label to a dialog.\n\r\n\rCONTROL ADD LINE\n\r\n\rAdd a line control to a dialog.\n\r\n\rCONTROL ADD LISTBOX\n\r\n\rAdd a list box control to a dialog.\n\r\n\rCONTROL ADD LISTVIEW\n\r\n\rAdd a ListView control to a dialog.\n\r\n\rCONTROL ADD OPTION\n\r\n\rAdd an option button to a dialog.\n\r\n\rCONTROL ADD PROGRESSBAR\n\r\n\rAdd a ProgressBar control to a dialog.\n\r\n\rCONTROL ADD SCROLLBAR\n\r\n\rAdd a scroll bar control to a dialog.\n\r\n\rCONTROL ADD STATUSBAR\n\r\n\rAdd a StatusBar control to a dialog.\n\r\n\rCONTROL ADD TAB\n\r\n\rAdd a Tab Control to a dialog.\n\r\n\rCONTROL ADD TEXTBOX\n\r\n\rAdd a text box control to a dialog.\n\r\n\rCONTROL ADD TOOLBAR\n\r\n\rAdd a ToolBar control to a dialog.\n\r\n\rCONTROL ADD TREEVIEW\n\r\n\rAdd a TreeView control to a dialog.\n\r\n\rCONTROL DISABLE\n\r\n\rDisable a control so that it no longer accepts user interaction.\n\r\n\rCONTROL ENABLE\n\r\n\rEnable a control so that it can receive user interaction.\n\r\n\rCONTROL GET CHECK\n\r\n\rGet the Check State of a 3-state, checkbox, or option button.\n\r\n\rCONTROL GET CLIENT\n\r\n\rGet the client area dimensions of a control.\n\r\n\rCONTROL GET LOC\n\r\n\rGet the location of the specified control in a dialog.\n\r\n\rCONTROL GET SIZE\n\r\n\rGet the size of a control in the specified dialog.\n\r\n\rCONTROL GET TEXT\n\r\n\rGet the text from a control.\n\r\n\rCONTROL GET USER\n\r\n\rRetrieve a value from the user data area of a DDT control.\n\r\n\rCONTROL HANDLE\n\r\n\rReturn a window handle for a given control ID.\n\r\n\rCONTROL HIDE\n\r\n\rMake a Control invisible.\n\r\n\rCONTROL KILL\n\r\n\rRemove a control from a dialog.\n\r\n\rCONTROL NORMALIZE\n\r\n\rMake a Control visible.\n\r\n\rCONTROL POST\n\r\n\rPlace a message into the message queue of a control (non-blocking).\n\r\n\rCONTROL REDRAW\n\r\n\rSchedule a control to be redrawn.\n\r\n\rCONTROL SEND\n\r\n\rSend a message to a control and wait for it to be processed.\n\r\n\rCONTROL SET CHECK\n\r\n\rSet the Check State for a 3-state or checkbox control.\n\r\n\rCONTROL SET CLIENT\n\r\n\rChange the size of a control to a specific client area size.\n\r\n\rCONTROL SET COLOR\n\r\n\rSet the foreground and background color of a control.\n\r\n\rCONTROL SET FOCUS\n\r\n\rSet the keyboard focus to the specified control.\n\r\n\rCONTROL SET FONT\n\r\n\rSelect a font to be used for a particular Windows Control.\n\r\n\rCONTROL SET IMAGE\n\r\n\rChange the icon or bitmap displayed in an IMAGE control.\n\r\n\rCONTROL SET IMAGEX\n\r\n\rChange the icon or bitmap displayed in an IMAGEX control.\n\r\n\rCONTROL SET IMGBUTTON\n\r\n\rChange the icon or bitmap displayed in an IMGBUTTON control.\n\r\n\rCONTROL SET IMGBUTTONX\n\r\n\rChange the icon or bitmap displayed in an IMGBUTTONX control.\n\r\n\rCONTROL SET LOC\n\r\n\rMove the control to a new location in the dialog.\n\r\n\rCONTROL SET OPTION\n\r\n\rSet the Check State for an option (radio) control.\n\r\n\rCONTROL SET SIZE\n\r\n\rChange the size of a control.\n\r\n\rCONTROL SET TEXT\n\r\n\rChange the text in a control.\n\r\n\rCONTROL SET USER\n\r\n\rSet a value in the user data area of a DDT control.\n\r\n\rCONTROL SHOW STATE\n\r\n\rChange the visible state of a control.\n\r\n\rDESKTOP GET CLIENT\n\r\n\rRetrieve the size of the client area of the desktop, in pixels.\n\r\n\rDESKTOP GET LOC\n\r\n\rRetrieve the location of the top, left corner of the client area of the desktop, in pixels.\n\r\n\rDESKTOP GET SIZE\n\r\n\rReturn the size of the specified dialog.\n\r\n\rDIALOG DISABLE\n\r\n\rDisable a dialog so that it no longer responds to user interaction.\n\r\n\rDIALOG DOEVENTS\n\r\n\rProcess pending window or dialog messages for modeless dialogs.\n\r\n\rDIALOG ENABLE\n\r\n\rEnable a dialog so that it responds to user interaction.\n\r\n\rDIALOG END\n\r\n\rClose and destroy the specified dialog.\n\r\n\rDIALOG DEFAULT FONT\n\r\n\rSpecify the default DDT font and point size.\n\r\n\rDIALOG GET CLIENT\n\r\n\rReturn the client size of the specified dialog.\n\r\n\rDIALOG GET LOC\n\r\n\rReturn the location of the specified dialog.\n\r\n\rDIALOG GET SIZE\n\r\n\rReturn the size of the specified dialog.\n\r\n\rDIALOG GET TEXT\n\r\n\rRetrieve the text in a dialog or window caption.\n\r\n\rDIALOG GET USER\n\r\n\rRetrieve a value from the user data area of a DDT dialog.\n\r\n\rDIALOG HIDE\n\r\n\rMake a Dialog invisible.\n\r\n\rDIALOG MAXIMIZE\n\r\n\rMaximize a Dialog.\n\r\n\rDIALOG MINIMIZE\n\r\n\rMinimize a Dialog.\n\r\n\rDIALOG NEW\n\r\n\rCreate a new dialog in memory, ready for display.\n\r\n\rDIALOG NONSTABLE\n\r\n\rMake a Dialog non-stable (closeable).\n\r\n\rDIALOG NORMALIZE\n\r\n\rMake a Dialog visible.\n\r\n\rDIALOG PIXELS\n\r\n\rConvert pixels (device units) into dialog units.\n\r\n\rDIALOG POST\n\r\n\rPlace a message in the dialog message queue (non-blocking).\n\r\n\rDIALOG REDRAW\n\r\n\rForce a dialog and all child controls to be redrawn immediately.\n\r\n\rDIALOG SEND\n\r\n\rSend a message to a dialog and wait for it to be processed.\n\r\n\rDIALOG SET CLIENT\n\r\n\rChange the size of a dialog to a specific client area size.\n\r\n\rDIALOG SET COLOR\n\r\n\rSet the background color of a dialog to a specific RGB color.\n\r\n\rDIALOG SET ICON\n\r\n\rChange both the dialog icon in the caption, and the icon shown in the ALT+TAB task list.\n\r\n\rDIALOG SET LOC\n\r\n\rChange the position of a dialog.\n\r\n\rDIALOG SET SIZE\n\r\n\rChange the size of a dialog.\n\r\n\rDIALOG SET TEXT\n\r\n\rSet the text in a dialog or window caption.\n\r\n\rDIALOG SET USER\n\r\n\rSet a value in the user data area of a DDT dialog.\n\r\n\rDIALOG SHOW MODAL\n\r\n\rDisplay and activate a modal dialog.\n\r\n\rDIALOG SHOW MODELESS\n\r\n\rDisplay and activate a modeless dialog.\n\r\n\rDIALOG SHOW STATE\n\r\n\rChange the visible state of a dialog.\n\r\n\rDIALOG STABILIZE\n\r\n\rMake a Dialog stabilized (non-closeable).\n\r\n\rDIALOG UNITS\n\r\n\rConvert dialog units into pixels.\n\r\n\rDISPLAY BROWSE\n\r\n\rDisplay a folder selection dialog to return the user\'s choice.\n\r\n\rDISPLAY COLOR\n\r\n\rDisplay a color selection dialog to return the user\'s choice.\n\r\n\rDISPLAY FONT\n\r\n\rDisplay a &nbsp;selection dialog to return user choices.\n\r\n\rDISPLAY OPENFILE\n\r\n\rDisplay an OpenFile selection dialog to return user choices.\n\r\n\rDISPLAY SAVEFILE\n\r\n\rDisplay a SaveFile selection dialog to return user choices.\n\r\n\rFONT END\n\r\n\rDestroy a font when it is no longer needed.\n\r\n\rFONT NEW\n\r\n\rCreate a new font for use with GRAPHIC PRINT, XPRINT, etc.\n\r\n\rHEADER GET COUNT\n\r\n\rRetrieves the count of the items in a Header control.\n\r\n\rHEADER GET ITEM\n\r\n\rRetrieves an HD_Item structure which describes an item in a Header control.\n\r\n\rHEADER SEND\n\r\n\rSends a message to a Header control.\n\r\n\rHEADER SET ITEM\n\r\n\rSets the attributes of the specified item in a Header Control.\n\r\n\rIMAGELIST ADD BITMAP\n\r\n\rAn bitmap image is added to the IMAGELIST.\n\r\n\rIMAGELIST ADD ICON\n\r\n\rAn icon image is added to the IMAGELIST.\n\r\n\rIMAGELIST ADD MASKED\n\r\n\rA bitmap is added to the icon IMAGELIST.\n\r\n\rIMAGELIST GET COUNT\n\r\n\rThe number of images in the IMAGELIST is retrieved.\n\r\n\rIMAGELIST KILL\n\r\n\rThe specified IMAGELIST is destroyed.\n\r\n\rIMAGELIST NEW BITMAP\n\r\n\rA new bitmap IMAGELIST structure is created.\n\r\n\rIMAGELIST NEW ICON\n\r\n\rA new icon IMAGELIST structure is created.\n\r\n\rIMAGELIST SET OVERLAY\n\r\n\rSpecify an image to be used as an overlay.\n\r\n\rINPUTBOX$\n\r\n\rDisplays a dialog box containing a prompt.\n\r\n\rISMISSING\n\r\n\rDetermine whether an argument was passed by the calling code.\n\r\n\rISWIN\n\r\n\rDetermine whether a Control/Dialog/Window currently exists.\n\r\n\rLISTBOX ADD\n\r\n\rAdd a string value to a LISTBOX control.\n\r\n\rLISTBOX DELETE\n\r\n\rRemove a string from a LISTBOX control.\n\r\n\rLISTBOX FIND\n\r\n\rStrings in the LISTBOX are searched to find the first string which begins with the specified characters.\n\r\n\rLISTBOX FIND EXACT\n\r\n\rStrings in the LISTBOX are searched to find the first string which exactly matches the specified characters.\n\r\n\rLISTBOX GET COUNT\n\r\n\rThe number of items in the LISTBOX is retrieved.\n\r\n\rLISTBOX GET SELCOUNT\n\r\n\rThe number of selected items in the LISTBOX is retrieved.\n\r\n\rLISTBOX GET SELECT\n\r\n\rThe LISTBOX is searched to find the first selected item.\n\r\n\rLISTBOX GET STATE\n\r\n\rA data item is checked to see if it is currently selected.\n\r\n\rLISTBOX GET TEXT\n\r\n\rRetrieve the default text from a LISTBOX control.\n\r\n\rLISTBOX GET USER\n\r\n\rRetrieve the value in the user data area of the LISTBOX.\n\r\n\rLISTBOX INSERT\n\r\n\rInsert a new data item at a specified location.\n\r\n\rLISTBOX RESET\n\r\n\rRemove all strings from a list box.\n\r\n\rLISTBOX SELECT\n\r\n\rSelect a string in a list box and make it the default selection.\n\r\n\rLISTBOX SET TEXT\n\r\n\rReplace the string for a specific data item with a new string.\n\r\n\rLISTBOX SET USER\n\r\n\rSet a value in the user data area of the LISTBOX.\n\r\n\rLISTBOX UNSELECT\n\r\n\rA specified data item in the LISTBOX control is set to an unselected state.\n\r\n\rLISTVIEW DELETE COLUMN\n\r\n\rDelete a column, including its associated header text (if any) from the LISTVIEW control.\n\r\n\rLISTVIEW DELETE ITEM\n\r\n\rThe specified data item is deleted from the LISTVIEW control.\n\r\n\rLISTVIEW FIND\n\r\n\rStrings in the LISTVIEW are searched to find the first string which begins with the specified characters.\n\r\n\rLISTVIEW FIND EXACT\n\r\n\rStrings in the LISTVIEW are searched to find the first string which exactly matches the specified characters.\n\r\n\rLISTVIEW FIT CONTENT\n\r\n\rThe width of the specified column is adjusted to fit the width of the data items displayed in that column.\n\r\n\rLISTVIEW FIT HEADER\n\r\n\rThe width of the specified column is adjusted to fit the width of the data items displayed in that column, and the header text at the top of that column.\n\r\n\rLISTVIEW GET COLUMN\n\r\n\rThe width of the designated column is retrieved from the LISTVIEW.\n\r\n\rLISTVIEW GET COUNT\n\r\n\rThe number of data items in the LISTVIEW is retrieved.\n\r\n\rLISTVIEW GET HEADER\n\r\n\rColumn header text is retrieved from the LISTVIEW.\n\r\n\rLISTVIEW GET HEADERID\n\r\n\rRetrieves the Listview handle and header control id.\n\r\n\rLISTVIEW GET MODE\n\r\n\rThe display mode of the specified LISTVIEW control is retrieved.\n\r\n\rLISTVIEW GET SELCOUNT\n\r\n\rThe number of selected items in the LISTVIEW is retrieved.\n\r\n\rLISTVIEW GET STATE\n\r\n\rA data item is tested to see if it is currently selected.\n\r\n\rLISTVIEW GET STYLEXX\n\r\n\rRetrieves the current setting of the LISTVIEW controls extended style.\n\r\n\rLISTVIEW GET TEXT\n\r\n\rA string data item is retrieved from the LISTVIEW control.\n\r\n\rLISTVIEW GET USER\n\r\n\rRetrieve the value in the user data area of the LISTVIEW.\n\r\n\rLISTVIEW INSERT COLUMN\n\r\n\rA new vertical column is defined for Report Mode of the LISTVIEW.\n\r\n\rLISTVIEW INSERT ITEM\n\r\n\rA new data item is added to this LISTVIEW control.\n\r\n\rLISTVIEW RESET\n\r\n\rAll data items are deleted from the specified LISTVIEW control.\n\r\n\rLISTVIEW SELECT\n\r\n\rThe specified string data item is chosen as selected text for the LISTVIEW.\n\r\n\rLISTVIEW SET COLUMN\n\r\n\rChange the width of a LISTVIEW column.\n\r\n\rLISTVIEW SET HEADER\n\r\n\rNew column header text is displayed above the specified column on the LISTVIEW control.\n\r\n\rLISTVIEW SET IMAGE\n\r\n\rThe specified image is displayed next to the item specified.\n\r\n\rLISTVIEW SET IMAGE2\n\r\n\rThe specified image is displayed as a secondary &quot;status&quot; image next to the primary image.\n\r\n\rLISTVIEW SET IMAGELIST\n\r\n\rAttach an IMAGELIST to the LISTVIEW control.\n\r\n\rLISTVIEW SET MODE\n\r\n\rChange the display mode of the specified LISTVIEW control.\n\r\n\rLISTVIEW SET OVERLAY\n\r\n\rThe specified overlay image is displayed on top of the image specified.\n\r\n\rLISTVIEW SET STYLE\n\r\n\rAlter the current settings of the LISTVIEW controls extended style.\n\r\n\rLISTVIEW SET TEXT\n\r\n\rThe text, if any, for the specified data item is replaced with new text.\n\r\n\rLISTVIEW SET USER\n\r\n\rSet a value in the user data area of the LISTVIEW.\n\r\n\rLISTVIEW SORT\n\r\n\rAll of the items in a LISTVIEW are sorted.\n\r\n\rLISTVIEW UNSELECT\n\r\n\rThe specified data item is set to an unselected state.\n\r\n\rLISTVIEW VISIBLE\n\r\n\rThe specified data item is scrolled, if necessary, to ensure that the data item is visible.\n\r\n\rPROGRESSBAR GET POS\n\r\n\rThe current position of the PROGRESSBAR is retrieved.\n\r\n\rPROGRESSBAR GET RANGE\n\r\n\rThe current range of the PROGRESSBAR is retrieved.\n\r\n\rPROGRESSBAR SET POS\n\r\n\rSet the current position of the PROGRESSBAR .\n\r\n\rPROGRESSBAR SET RANGE\n\r\n\rSet the minimum and maximum ranges of the PROGRESSBAR .\n\r\n\rPROGRESSBAR SET STEP\n\r\n\rSpecify the default increment value to be used by PROGRESSBAR STEP.\n\r\n\rPROGRESSBAR STEP\n\r\n\rAdvance the current position of the PROGRESSBAR by the default increment value.\n\r\n\rMENU ADD POPUP\n\r\n\rAdd a popup child menu to an existing menu.\n\r\n\rMENU ADD STRING\n\r\n\rAdd a string or separator to an existing menu.\n\r\n\rMENU ATTACH\n\r\n\rAttach a menu to a given dialog.\n\r\n\rMENU CONTEXT\n\r\n\rCreate a floating context menu.\n\r\n\rMENU DELETE\n\r\n\rDelete a menu item from an existing menu.\n\r\n\rMENU DRAW BAR\n\r\n\rRedraw the menu bar for a given dialog.\n\r\n\rMENU GET STATE\n\r\n\rReturn the state of a specified menu item.\n\r\n\rMENU GET TEXT\n\r\n\rReturn the text associated with a given menu item.\n\r\n\rMENU NEW BAR\n\r\n\rCreate a new menu bar.\n\r\n\rMENU NEW POPUP\n\r\n\rCreate a new popup menu.\n\r\n\rMENU SET STATE\n\r\n\rSet the state of a specified menu item.\n\r\n\rMENU SET TEXT\n\r\n\rSet the text of a given menu item.\n\r\n\rMOUSEPTR\n\r\n\rChange the mouse pointer (cursor) to a new shape.\n\r\n\rSCROLLBAR GET PAGESIZE\n\r\n\rRetrieve the current page size.\n\r\n\rSCROLLBAR GET POS\n\r\n\rReturns the current position of the SCROLLBAR.\n\r\n\rSCROLLBAR GET RANGE\n\r\n\rReturns the current range of the SCROLLBAR.\n\r\n\rSCROLLBAR GET TRACKPOS\n\r\n\rRetrieve the current position of the scroll box.\n\r\n\rSCROLLBAR SET PAGESIZE\n\r\n\rSet the current page size.\n\r\n\rSCROLLBAR SET POS\n\r\n\rSet the current position of the SCROLLBAR.\n\r\n\rSCROLLBAR SET RANGE\n\r\n\rSet the range of the SCROLLBAR.\n\r\n\rSTATUSBAR SET PARTS\n\r\n\rSet the number of parts to be displayed in the STATUSBAR.\n\r\n\rSTATUSBAR SET TEXT\n\r\n\rAssign the text to be displayed in the specified part of the STATUSBAR.\n\r\n\rTAB DELETE\n\r\n\rDelete a page from the TAB control.\n\r\n\rTAB GET COUNT\n\r\n\rReturn the number of pages in a TAB control.\n\r\n\rTAB GET DIALOG\n\r\n\rRetrieve the handle of the dialog for a specific page in a TAB control.\n\r\n\rTAB GET IMAGE\n\r\n\rRetrieves the index of the image displayed on the specified TAB page.\n\r\n\rTAB GET PAGE\n\r\n\rRetrieves the page number of the specified TAB page dialog handle.\n\r\n\rTAB GET SELECT\n\r\n\rReturns the currently selected page in a TAB control.\n\r\n\rTAB GET TEXT\n\r\n\rThe text displayed on the specified page tab is retrieved.\n\r\n\rTAB INSERT PAGE\n\r\n\rAdd a new page to a TAB control.\n\r\n\rTAB RESET\n\r\n\rDelete all pages in a TAB control.\n\r\n\rTAB SELECT\n\r\n\rSelect a specific page in a TAB control to be the active page.\n\r\n\rTAB SET IMAGE\n\r\n\rThe specified image is displayed on the specified page tab.\n\r\n\rTAB SET IMAGELIST\n\r\n\rAssign an IMAGELIST to be used in a TAB control.\n\r\n\rTAB SET TEXT\n\r\n\rDisplays the specified text on the tab of the page.\n\r\n\rTOOLBAR ADD BUTTON\n\r\n\rAdd a button to a TOOLBAR control.\n\r\n\rTOOLBAR ADD SEPARATOR\n\r\n\rAdd a separator to a TOOLBAR control.\n\r\n\rTOOLBAR DELETE BUTTON\n\r\n\rDelete a button from a TOOLBAR control.\n\r\n\rTOOLBAR GET STATE\n\r\n\rGet the state of a button on a TOOLBAR control.\n\r\n\rTOOLBAR GET COUNT\n\r\n\rRetrieve the number of buttons on a TOOLBAR control.\n\r\n\rTOOLBAR SET IMAGELIST\n\r\n\rAttach an IMAGELIST to a TOOLBAR control.\n\r\n\rTOOLBAR SET STATE\n\r\n\rSet the state of a button on a TOOLBAR control.\n\r\n\rTREEVIEW DELETE\n\r\n\rDelete a data item from a TREEVIEW control.\n\r\n\rTREEVIEW GET BOLD\n\r\n\rThe bold attribute for a data item is retrieved.\n\r\n\rTREEVIEW GET CHECK\n\r\n\rThe checkmark attribute for a data item is retrieved.\n\r\n\rTREEVIEW GET CHILD\n\r\n\rReturn the handle of the first child item of a specified data item.\n\r\n\rTREEVIEW GET COUNT\n\r\n\rThe number of data items in the TREEVIEW is retrieved.\n\r\n\rTREEVIEW GET EXPANDED\n\r\n\rThe expanded attribute for the data item is retrieved.\n\r\n\rTREEVIEW GET NEXT\n\r\n\rReturn the handle of the next sibling data item.\n\r\n\rTREEVIEW GET PARENT\n\r\n\rThe handle of the parent for a specified data item is returned.\n\r\n\rTREEVIEW GET PREVIOUS\n\r\n\rReturn the handle of the previous sibling data item.\n\r\n\rTREEVIEW GET ROOT\n\r\n\rThe handle of the very first data item (topmost) in the TREEVIEW is retrieved.\n\r\n\rTREEVIEW GET SELECT\n\r\n\rThe handle of the currently selected data item is retrieved.\n\r\n\rTREEVIEW GET TEXT\n\r\n\rThe text of a specific data item is retrieved.\n\r\n\rTREEVIEW GET USER\n\r\n\rRetrieve the value in the user data area for a specific data item of the TREEVIEW.\n\r\n\rTREEVIEW INSERT ITEM\n\r\n\rAdd a new data item to a TREEVIEW control.\n\r\n\rTREEVIEW RESET\n\r\n\rAll data items are deleted from the specified TREEVIEW control.\n\r\n\rTREEVIEW SELECT\n\r\n\rSelect a specific data item in the TREEVIEW control.\n\r\n\rTREEVIEW SET BOLD\n\r\n\rSet the bold attribute for specific data item.\n\r\n\rTREEVIEW SET CHECK\n\r\n\rSet the checkmark attribute for a specific data item.\n\r\n\rTREEVIEW SET EXPANDED\n\r\n\rSet the expanded attribute for a specific data item.\n\r\n\rTREEVIEW SET IMAGELIST\n\r\n\rAttach an IMAGELIST to a TREEVIEW control.\n\r\n\rTREEVIEW SET TEXT\n\r\n\rThe text, if any, for the specified data item is replaced with new text.\n\r\n\rTREEVIEW SET USER\n\r\n\rSet the value in the user data area for a specific data item in the TREEVIEW control.\n\r\n\rTREEVIEW UNSELECT\n\r\n\rAll items in the TREEVIEW control are set to an unselected state.\n\r\n\rWINDOW GET HANDLE\n\r\n\rRetrieves the handle of a Window.\n\r\n\rWINDOW GET ID\n\r\n\rThe integral ID of the window is retrieved.\n\r\n\rWINDOW GET PARENT\n\r\n\rThe handle of the parent is retrieved.\n\r\n\rWINDOW GET STYLE\n\r\n\rRetrieves the style of the Window.\n\r\n\rWINDOW GET STYLEX\n\r\n\rRetrieves the extended-style of the Window.\n\r\n\rWINDOW GET USER\n\r\n\rRetrieves the 32-bit user data value associated with the window.\n\r\n\rWINDOW SET ID\n\r\n\rChanges the integral ID of the window.\n\r\n\rWINDOW SET STYLE\n\r\n\rChanges the style of the Window.\n\r\n\rWINDOW SET STYLEX\n\r\n\rChanges the extended-style of the Window.\n\r\n\rWINDOW SET USER\n\r\n\rChanges the 32-bit user data value associated with the window.","Dynamic Dialog Tools","scr\\html_dynamic_dialog_tools_commands.htm","                  \n\r\n\rThe following table summarizes the hot-keys available in the PowerBASIC IDE Editor Window:\n\r\n\rKeystroke\n\r\n\rDescription\n\r\n\rF1\n\r\n\rDynamic Help\n\r\n\rF2\n\r\n\rCode Finder dialog\n\r\n\rF3\n\r\n\rFind dialog/Find next\n\r\n\rSHIFT+F3\n\r\n\rFind previous\n\r\n\rF4\n\r\n\rDuplicate current line\n\r\n\rCTRL+F4\n\r\n\rClose current document\n\r\n\rALT+F4\n\r\n\rExit PBEDIT\n\r\n\rF5\n\r\n\rCompile and debug (if in edit mode) or Run program (if in debug mode)\n\r\n\rCTRL+F5\n\r\n\rAnimate program.\n\r\n\rF6\n\r\n\rClear to end-of-line\n\r\n\rCTRL+TAB\n\r\n\rSwitch to the next document window\n\r\n\rCTRL+F6\n\r\n\rSwitch to the next document window\n\r\n\rSHIFT+CTRL+TAB\n\r\n\rSwitch to the previous document window\n\r\n\rCTRL+SHIFT+F6\n\r\n\rSwitch to the previous document window\n\r\n\rF8\n\r\n\rStep into next program line (when debugging)\n\r\n\rCTRL+SHIFT+F8\n\r\n\rStep out of current procedure (when debugging)\n\r\n\rSHIFT+F8\n\r\n\rStep over next program line (when debugging)\n\r\n\rCTRL+F8\n\r\n\rRun to caret (when debugging)\n\r\n\rF9\n\r\n\rBreak (stop the program being debugged)\n\r\n\rCTRL++\n\r\n\rIncreases the IDE\'s Font size\n\r\n\rCTRL+-\n\r\n\rDecreases the IDE\'s Font size\n\r\n\rSHIFT+INSERT\n\r\n\rPaste text from clipboard\n\r\n\rSHIFT+DELETE\n\r\n\rCut text to clipboard\n\r\n\rCTRL+DELETE\n\r\n\rCut text to clipboard\n\r\n\rCTRL+INSERT\n\r\n\rCopy text to clipboard\n\r\n\rCTRL+HOME\n\r\n\rMove to start of document\n\r\n\rCTRL+END\n\r\n\rMove to end of document\n\r\n\rCTRL+PAGEUP\n\r\n\rMove to start of document, maintaining caret position on screen\n\r\n\rCTRL+PAGEDOWN\n\r\n\rMove to end of document, maintaining caret position on screen\n\r\n\rCTRL+ALT+G\n\r\n\rInsert a GUID\n\r\n\rCTRL+ALT+O\n\r\n\rDisplay the Open Project dialog box.\n\r\n\rCTRL+ALT+P\n\r\n\rPrimary Source File Dialog\n\r\n\rSHIFT+CTRL+S\n\r\n\rSave all opened files\n\r\n\rCTRL+0\n\r\n\rGo to bookmark 0\n\r\n\rALT+0\n\r\n\rSet bookmark 0\n\r\n\rCTRL+1\n\r\n\rGo to bookmark 1\n\r\n\rALT+1\n\r\n\rSet bookmark 1\n\r\n\rCTRL+2\n\r\n\rGo to bookmark 2\n\r\n\rALT+2\n\r\n\rSet bookmark 2\n\r\n\rCTRL+3\n\r\n\rGo to bookmark 3\n\r\n\rALT+3\n\r\n\rSet bookmark 3\n\r\n\rCTRL+4\n\r\n\rGo to bookmark 4\n\r\n\rALT+4\n\r\n\rSet bookmark 4\n\r\n\rCTRL+5\n\r\n\rGo to bookmark 5\n\r\n\rALT+5\n\r\n\rSet bookmark 5\n\r\n\rCTRL+6\n\r\n\rGo to bookmark 6\n\r\n\rALT+6\n\r\n\rSet bookmark 6\n\r\n\rCTRL+7\n\r\n\rGo to bookmark 7\n\r\n\rALT+7\n\r\n\rSet bookmark 7\n\r\n\rCTRL+8\n\r\n\rGo to bookmark 8\n\r\n\rALT+8\n\r\n\rSet bookmark 8\n\r\n\rCTRL+9\n\r\n\rGo to bookmark 9\n\r\n\rALT+9\n\r\n\rSet bookmark 9\n\r\n\rTAB\n\r\n\rIndent marked block by one tab level\n\r\n\rSHIFT+TAB\n\r\n\rOutdent marked block by one tab level\n\r\n\rSPACE\n\r\n\rIndent marked block by one space\n\r\n\rSHIFT+SPACE\n\r\n\rOutdent marked block by one space\n\r\n\rCTRL+A\n\r\n\rSelect all\n\r\n\rALT+B\n\r\n\rToggle Bookmark\n\r\n\rCTRL+B\n\r\n\rGo to Bookmark dialog\n\r\n\rALT+C\n\r\n\rCopy text to the clipboard as BB Code for posting in the PowerBASIC Forums.\n\r\n\rCTRL+C\n\r\n\rCopy text to the clipboard\n\r\n\rCTRL+D\n\r\n\rDuplicate current line\n\r\n\rCTRL+E\n\r\n\rBuild and Execute\n\r\n\rCTRL+F\n\r\n\rFind dialog\n\r\n\rCTRL+G\n\r\n\rGo to Line dialog\n\r\n\rCTRL+I\n\r\n\rToggle auto-indent mode\n\r\n\rCTRL+K\n\r\n\rClear to end-of-line\n\r\n\rCTRL+L\n\r\n\rSelect current line\n\r\n\rCTRL+M\n\r\n\rCompile the current document (or primary source file, if any)\n\r\n\rCTRL+N\n\r\n\rCreate a new document, using the default file template\n\r\n\rCTRL+O\n\r\n\rOpen an existing document\n\r\n\rCTRL+P\n\r\n\rPrint the current source document\n\r\n\rCTRL+Q\n\r\n\rComment-out marked block\n\r\n\rCTRL+SHIFT+Q\n\r\n\rUncomment-out marked block\n\r\n\rCTRL+R\n\r\n\rFind and Replace dialog\n\r\n\rCTRL+S\n\r\n\rSave the current document\n\r\n\rCTRL+T\n\r\n\rDelete the word at the caret\n\r\n\rCTRL+U\n\r\n\rPaste text from clipboard\n\r\n\rCTRL+V\n\r\n\rPaste text from clipboard\n\r\n\rCTRL+X\n\r\n\rCut text to clipboard\n\r\n\rCTRL+Y\n\r\n\rCut current line to clipboard\n\r\n\rCTRL+Z\n\r\n\rUndo last change","Editor Hot Keys","scr\\html_editor_hot_keys.htm","                  \n\r\n\r\n\r\n\rPB Source\n\r\n\rThis is the file extension, or list of extensions, you expect to use for main PowerBASIC source code modules: programs you can compile directly. You may enter multiple extensions by separating each with the vertical bar or &quot;pipe&quot; character, &quot;|&quot;. The default setting for PB Source is &quot;.bas&quot;.\n\r\n\rPB Include\n\r\n\rThis is the file extension, or list of extensions, you expect to use for PowerBASIC include files: bits of code that you will #include in a main module before compiling. You may enter multiple extensions by separating each with the vertical bar or &quot;pipe&quot; character, &quot;|&quot;. The default setting for PB Include is &quot;.bi|.inc&quot;.\n\r\n\rRC Source\n\r\n\rThis is the file extension, or list of extensions, you expect to use for resource scripts: programs that are compiled with the RC.EXE resource compiler. You may enter multiple extensions by separating each with the vertical bar or &quot;pipe&quot; character, &quot;|&quot;. The default setting for RC Source is &quot;.dlg|.rc&quot;.\n\r\n\rRC Include\n\r\n\rThis is the file extension, or list of extensions, you expect to use for your PowerBASIC include files: bits of code that you will #include in a resource script before compiling with the RC.EXE resource compiler. You may enter multiple extensions by separating each with the vertical bar or &quot;pipe&quot; character, &quot;|&quot;. The default setting for RC Include is &quot;.h&quot;.\n\r\n\rPB Project\n\r\n\rThis is the file extension, or list of extensions, you expect to use for your PowerBASIC Project files. You may enter multiple extensions by separating each with the vertical bar or &quot;pipe&quot; character, &quot;|&quot;. The default setting for a project file Include is &quot;.PBprj|.prj&quot;.\n\r\n\rRegister file extensions\n\r\n\rCheck this box to register your selected file extensions with Windows. This allows Windows to automatically load files with these extensions into the PowerBASIC IDE when you click on a file in Explorer, or launch it from the Start menu, for example.\n\r\n\rKeep Line Length\n\r\n\rClicking the mouse cursor beyond the right-most character of a line does not extend the line beyond the end of the actual text content.\n\r\n\rHome to logical line start\n\r\n\rThe Home key functions according to VB6 rules if this option is selected.\n\r\n\rWrap Caret at Line Ends\n\r\n\rCheck this box to have left-arrow wrap to the previous line, and right arrow wrap to the next line, instead of stopping at the start or end of the current line.\n\r\n\rDelete line to clipboard\n\r\n\rWhen this option is selected a line deleted from the source code is placed on the clipboard.\n\r\n\rAuto Indent\n\r\n\rThe IDE provides automatic indenting when ENTER is pressed, in order to assist with writing visually structured code. The Indent depth depends on the context of the text on the preceding line. For example, if the previous line starts with the word FUNCTION, the following line is automatically indented. Auto-indent can be toggled from within the editor with the CTRL+I hot-key combination. See Tab Size.\n\r\n\rTab Size\n\r\n\rThe number of characters between &quot;tab stops&quot;, in the range 1 through 8 inclusive. When the TAB key is pressed, the IDE substitutes space characters to move the caret to the next tab stop position. Tab Size also affects the Auto Indent depth.\n\r\n\rKeyword Case\n\r\n\rThe IDE automatically sets the capitalization of reserved keywords as directed by this option. The use of capitalization can help readability of code. By default, the IDE applies keyword capitalization to BASIC source code files only, which are determined by the file extensions set under Compiler Preferences. Use care when applying capitalization to resource files (for example, .RC files, .H, and .DLG files) as these usually contain case-sensitive keywords. Custom keyword colors can be configured in the Color Preferences page, and the editor font can be configured on the Font Preferences page.","Editor tab","scr\\html_editor_preferences.htm","                  \n\r\n\rThe notation to calculate the effective address of data in memory can look complicated but it is in fact very clear and precise notation. In the range of allowable notation for Intel 80x86 assembler, an address in memory can be placed in a register and treated directly as a memory operand by enclosing it in square brackets.\n\r\n\r! MOV EAX, lpArray ; Copy address into EAX\n\r\n\r! MOV ECX, [EAX] &nbsp; ; Copy 1st item in array into ECX\n\r\n\r! ADD EAX, 4 &nbsp; &nbsp; &nbsp; ; Increment the array location by 4 bytes\n\r\n\r! MOV ECX, [EAX] &nbsp; ; Copy 2nd item in array into ECX\n\r\n\rThis works fine in simple situations where the register that has the address is manually incremented or decremented by the data size each time it is accessed, but there is a much more powerful and flexible technique available by using the standard Intel notation that is available.\n\r\n\rThe Intel 80x86 allows the following format to calculate the effective address of a value in memory:\n\r\n\r[ Base Address + Index * Scale + Displacement ]\n\r\n\rBase Address &nbsp; &nbsp; &nbsp; &nbsp;The register that has the starting address or base address of the array (or buffer) in memory.\n\r\n\rIndex &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;The register used to determine the offset from the base address.\n\r\n\rScale &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;The data size based multiplier for the index.\n\r\n\rDisplacement &nbsp; &nbsp; &nbsp; The additional offset adjustment from the base address.\n\r\n\rFor example:\n\r\n\r[EBX + ECX * 4 + 8]\n\r\n\r&nbsp;\n\r\n\rEBX is the Base Address\n\r\n\rECX is the Index\n\r\n\r4 &nbsp; is the Scale based on the data size\n\r\n\r8 &nbsp; is the Displacement in BYTES\n\r\n\rNot all of the additional notation has to be used. For example, in a Byte array, you can just use the base address and the index:\n\r\n\r! MOV AL, [EBX + ECX]\n\r\n\rThe advantage of this technique is that you set the base address once and vary the index. In the case above, ECX is the index. In terms of flexibility, you have the choice of varying the base address, the index, and the displacement so that you can access data in memory by a number of different methods that best suit your code.\n\r\n\rThe only difference when using data sizes larger than Byte is that you multiply the &quot;index&quot; by the &quot;scale&quot; of the data size:\n\r\n\r! MOV EAX, [EBX + ECX * 4]\n\r\n\rTo make a practical example let us assume we have an array of 64 items that were each 32-bits in size, and we wanted to read the 16th member of that 32-bit array. In this case, we would copy the 16th member of the zero-based index into the register that we are using as the index. Next, copy the address of the array into the register that you are using as the base address, and finally read the value of the array member into another register.\n\r\n\r! MOV ESI, lpArray &nbsp; &nbsp; &nbsp; &nbsp; ; Base address register\n\r\n\r! MOV ECX, 15 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;; Zero-based index register\n\r\n\r! MOV EAX, [ESI + ECX * 4] ; Copy the value into EAX\n\r\n\rThese three lines of code read the target value from the array into the EAX register.\n\r\n\rIf we wanted to compare the 16th and 17th members of the array and not have to use an additional register, we can add the required displacement so that we only have an extra line of code:\n\r\n\r! MOV EAX, [ESI + ECX * 4]\n\r\n\r! CMP EAX, [ESI + ECX * 4 + 4]\n\r\n\rTo compare the 17th and 18th members of the array, all we need to do is increment the index:\n\r\n\r! INC ECX\n\r\n\rWriting to the array is simply the reverse of reading it. With the same code as above:\n\r\n\r! MOV ESI, lpArray &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;; Base address register\n\r\n\r! MOV ECX, 15 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ; Zero-based index register\n\r\n\r! MOV EAX, 1234\n\r\n\r! MOV [ESI + ECX * 4], EAX\n\r\n\rWe can also write an immediate (literal) number to the array but it takes a slightly different notation:\n\r\n\r! MOV DWORD PTR [ESI + ECX * 4], 1234\n\r\n\rThe extra notation &quot;DWORD PTR&quot; is because there is no way for the assembler to determine the data size from either the memory operand for the array or the immediate number. Specifying the size tells PowerBASIC what data size should be written to the address contained in the memory operand.\n\r\n\rA very similar notation is used when an array is placed on the stack by creating a LOCAL variable. With a stack variable MyArray, PowerBASIC resolves this variable to an address on the stack, which will be something like this:\n\r\n\rx&amp; = VARPTR(Myarray(0)) \' first element\n\r\n\r! mov edx, x&amp;\n\r\n\r! mov ecx, 3\n\r\n\r! mov eax, [edx][ecx*4] \' assuming 32-bit integer\n\r\n\r&nbsp;\n\r\n\r\' eax = MyArray(3) \' 4th element of MyArray\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rThe Inline Assembler\n\r\n\rAddressing and pointers\n\r\n\rRegisters\n\r\n\rPassing parameters","Effective Addressing","scr\\html_effective_addressing.htm","                  \n\r\n\rPurpose\n\r\n\rTerminate program immediately.\n\r\n\rSyntax\n\r\n\rEND [nErrorLevel&amp;]\n\r\n\rRemarks\n\r\n\rNormally, PowerBASIC programs are terminated when you exit the PBMAIN or WINMAIN() function. It should always be your goal to end programs in this fashion, so that the compiler and the operating system can do everything possible to leave things in an orderly state.\n\r\n\rThe END statement is an alternative termination method which should only be used in limited circumstances. It may be helpful in emergency situations, such as a fatal error like &quot;out of memory&quot;. It\'s also useful (temporarily) in the conversion of DOS programs, just for the sake of compatibility. However, once conversion is complete, you should eliminate it as soon as possible.\n\r\n\rThe optional nErrorLevel&amp; value has an effective range of 0 to 255. Batch files may act on the result through the IF [NOT] ERRORLEVEL batch command.\n\r\n\rRestrictions\n\r\n\rEND may not be used in a DLL. END is intended only for temporary use in converting DOS programs to Windows. You should convert it to the standard EXIT FUNCTION method as soon as possible. It should be avoided while any COM objects are active.\n\r\n\rSee also\n\r\n\rEXIT, PBMAIN, WINMAIN","END statement","scr\\html_end_statement.htm","                  \n\r\n\rPurpose\n\r\n\rCreates a group of logically related numeric equates.\n\r\n\rSyntax\n\r\n\rENUM Name [SINGULAR] [BITS] [AS COM]\n\r\n\r  EquateName [= value]\n\r\n\r  EquateName [= value]\n\r\n\r &nbsp;...\n\r\n\rEND ENUM\n\r\n\rRemarks\n\r\n\rPowerBASIC allows you to refer to integral numeric constants by name. These names are called equates, and are visible throughout your program. If you need a set of equates which are logically related, you can define them as a group in an enumeration. This provides meaningful names for the enumeration, its members, and therefore the name by which it is referenced.\n\r\n\rWhen an equate is created in an enumeration, its name is composed of a leading percent sign (%), the enumeration name, a period (.), and then the member name. For example:\n\r\n\rENUM abc\n\r\n\r &nbsp;count = 7\n\r\n\rEND ENUM\n\r\n\rIn the above example, the equate is referenced as %abc.count, and returns the value seven (7).\n\r\n\rEach member of an enumeration may be assigned a specific integral value (in the range of a 64-bit quad integer) by using the optional [=value] syntax. In this case, only a constant value (or a simple constant/literal expression) may be assigned to it. If an expression is used, all of the terms in the expression must be constants; numeric equates; bitwise operators like AND, OR, NOT; arithmetic operators +, -, *, /, \\; &nbsp;the relational operators &gt;, &lt;, &gt;=, &lt;=, &lt;&gt;, =; and the CVQ function.\n\r\n\rIf the [=value] option is omitted, each member of the enumeration is assigned an integral value in sequence beginning with the value 0. If one or more equates are assigned an explicit value, equates which follow are assigned the next value in the sequence. For example:\n\r\n\rENUM abc\n\r\n\r &nbsp;direction\n\r\n\r &nbsp;count = 8\n\r\n\r &nbsp;scope\n\r\n\rEND ENUM\n\r\n\rIn the above example, %abc.direction = 0, %abc.count = 8, and %abc.scope = 9.\n\r\n\rBITS\n\r\n\rIf the BITS option is included, the members are auto-assigned values suitable for use as a bit mask, increasing as integral powers of two. The first member is auto-assigned the value 0, the next is 1, then 2, 4, 8, 16, etc. If one or more are assigned an explicit value, equates which follow are assigned the next value in the sequence. For example:\n\r\n\rENUM abc BITS\n\r\n\r &nbsp;direction = 1\n\r\n\r &nbsp;count = 8\n\r\n\r &nbsp;scope\n\r\n\rEND ENUM\n\r\n\rIn the above example, %abc.direction = 1, %abc.count = 8, and %abc.scope = 16.\n\r\n\rSINGULAR\n\r\n\rIf the SINGULAR option is included, the member name is the complete name, without the ENUM name or the period. The equate is referenced by just the member name with a percent (%) prepended. For example:\n\r\n\rENUM abc SINGULAR\n\r\n\r &nbsp;count = 7\n\r\n\rEND ENUM\n\r\n\rIn the above example, the equate would normally be referenced by the compound name %abc.count. However, since it includes the SINGULAR option, it is referenced by the simplified name %count.\n\r\n\rAS COM\n\r\n\rIf you are using a version of PowerBASIC which creates COM servers, you can easily include these equates in your type library; just append the words AS COM to the ENUM definition.","ENUM/END ENUM statements","scr\\html_enum_end_enum_statements.htm","                  \n\r\n\rA collection is simply a set or group of items, where each can be accessed through its own Interface. For example, Microsoft Word can have multiple documents open at the same time, and it can provide an Interface reference for each open document.\n\r\n\rTherefore, enumerating a collection is simply a matter of determining the number of items in the collection, looping through and retrieving the appropriate information for one or more Interface members of the collection.\n\r\n\rWe\'ll start off with the Visual Basic syntax and show how to perform the same kind of task with PowerBASIC.\n\r\n\rVisual Basic syntax for enumerating a collection looks something like this:\n\r\n\rDim Item &nbsp;As InterfaceItem\n\r\n\rDim Items As InterfaceItemsCollection\n\r\n\r[statements]\n\r\n\rFor Each Item In Items\n\r\n\r &nbsp;\'do something with the Item.member Method/Property, e.g.,\n\r\n\r &nbsp;var$ = Item.StringProp\n\r\n\rNext\n\r\n\rIn PowerBASIC, we can perform the same enumeration. For example:\n\r\n\rDIM oItem &nbsp;AS InterfaceItem\n\r\n\rDIM oItems AS InterfaceItemsCollection\n\r\n\r[statements]\n\r\n\rOBJECT GET oItems.Count TO c&amp;\n\r\n\rFOR Index&amp; = 1 TO c&amp;\n\r\n\r &nbsp;OBJECT GET oItems.Item(Index&amp;) TO oItem\n\r\n\r &nbsp;\'do something with the Item.member Method/Property, e.g.,\n\r\n\r &nbsp;OBJECT GET oItem.StringProp TO var$$\n\r\n\rNEXT\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rCOLLECTION Object Group\n\r\n\rWhat is an object, anyway?\n\r\n\rJust what is COM?\n\r\n\rWhat are Type Libraries?","Enumerating Collections","scr\\html_enumerating_collections.htm","                  \n\r\n\rPurpose\n\r\n\rRetrieve information from the current program\'s environment table.\n\r\n\rSyntax\n\r\n\rs$ = ENVIRON$({parameter_string | n})\n\r\n\rRemarks\n\r\n\rparameter_string is a string expression denoting which environment parameter is to be retrieved. n is an integral expression, starting at 1.\n\r\n\rIf a string argument is used, ENVIRON$ returns the text that follows parameter_string (after the equal sign) in the environment table. If parameter_string is not found, or no text follows the equal sign in the environment string table, an empty string is returned.\n\r\n\rIf the numeric argument is used, it acts as an index into the environment table. ENVIRON$ returns a string containing the nth parameter from the start of the table. If there is no nth parameter, an empty string is returned. If the index is negative, private Windows variables are returned.\n\r\n\rWhen launching a program from within the IDE, PowerBASIC sets the &quot;PBIDE&quot; environment variable with the IDE name and version number. For example, &quot;CCEDIT 5.00&quot; or &quot;PBEDIT 9.00&quot;. Similarly, when running in the debugger, the &quot;PBDEBUG&quot; environment string will return the IDE name and version.\n\r\n\rPrograms can use these environment strings to detect their &quot;mode&quot; of operation, for example, to signal a program to save internal data to a disk file, and when to display helpful debugging information. DLLs created with PB/Win can also examine these environment strings and adapt behavior accordingly. This will be of particular interest to 3rd-party DLL programmers who create libraries and add-ons for other PowerBASIC programmers.\n\r\n\rRestrictions\n\r\n\rWhen a program (process) starts, it is given its own local environment table, which is typically a copy of the parent program\'s environment table. ENVIRON$ works with this local table, not the parent\'s table.\n\r\n\rSee also\n\r\n\rENVIRON\n\r\n\rExample\n\r\n\r\' Retrieve the PATH environment variable\n\r\n\rPath$ = ENVIRON$(&quot;PATH&quot;)\n\r\n\r&nbsp;\n\r\n\rIF LEN(ENVIRON$(&quot;PBDEBUG&quot;)) THEN _\n\r\n\r &nbsp;CALL DisplayMyDebugData()\n\r\n\r&nbsp;\n\r\n\r\' Enumerate all Environment strings\n\r\n\rRESET x&amp;\n\r\n\rDO\n\r\n\r &nbsp;INCR x&amp;\n\r\n\r &nbsp;a$ = ENVIRON$(x&amp;)\n\r\n\r &nbsp;\' process a$ here\n\r\n\rLOOP WHILE LEN(a$)","ENVIRON$ function","scr\\html_environ_function.htm","                  \n\r\n\rPurpose\n\r\n\rModify the current program\'s environment table.\n\r\n\rSyntax\n\r\n\rENVIRON envstring$\n\r\n\rRemarks\n\r\n\rModify the environment table for the current program and any subsequent child programs that are launched. A single string expression parameter sets both the name of the environment variable and its value, delimited by an equal (&quot;=&quot;) sign. If a value is not specified, the variable is removed from the environment table.\n\r\n\rSee also\n\r\n\rENVIRON$\n\r\n\rExample\n\r\n\rENVIRON &quot;SETMODE=YES&quot; &nbsp; \' SETMODE = &quot;YES&quot;\n\r\n\rENVIRON &quot;SETMODE=&quot; &nbsp; &nbsp; &nbsp;\' Removes SETMODE","ENVIRON statement","scr\\html_environ_statement.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the end-of-file status of an opened file or TCP/UDP transmission.\n\r\n\rSyntax\n\r\n\ry = EOF([#] filenum&amp;)\n\r\n\rRemarks\n\r\n\rUse EOF to determine when the end of a file has been reached while reading its data. filenum&amp; is the file number specified when the file was Opened. EOF returns -1 (TRUE) if the end of the specified file has been reached, or if an error occurs trying to check for the end of the file. Otherwise, EOF returns 0 (FALSE).\n\r\n\rIf filenum&amp; is not a valid, open file, a run-time Error 53 will occur (&quot;File not found&quot;). If filenum&amp; is for a binary file, EOF returns TRUE only if the most recent file operation was a read operation, and that operation could not read the requested number of bytes.\n\r\n\rThe EOF function may also be used with the COMM LINE and TCP LINE statements to detect that an incomplete line was received. Normally, these statements read data until a $CRLF character pair is found, and in that case, EOF will return 0 (FALSE). However, even if no $CRLF has been found, the statements will end when no additional data is available. In that case, they will return whatever data has already been accumulated, and set EOF to -1 (TRUE).\n\r\n\rIn many cases, it would be prudent to test EOF after every COMM LINE and TCP LINE to verify that a full line has been received. In some cases, you may wish to execute the statement one or more additional times, combining the data, in order to obtain a full line of text.\n\r\n\rSee also\n\r\n\rCOMM LINE, LOC, LOF, OPEN, TCP LINE\n\r\n\rExample\n\r\n\r\' Open an ASCII text file and read it\n\r\n\rhFile = FREEFILE\n\r\n\rOPEN &quot;TEXTFILE.TXT&quot; FOR INPUT AS hFile\n\r\n\rWHILE ISFALSE EOF(hFile)\n\r\n\r &nbsp;LINE INPUT# hFile, x$\n\r\n\rWEND\n\r\n\rCLOSE hFile","EOF function","scr\\html_eof_function.htm","                  \n\r\n\rPurpose\n\r\n\rThe EQV operator works as both a logical and a bitwise arithmetic operator.\n\r\n\rSyntax\n\r\n\rp EQV q\n\r\n\rRemarks\n\r\n\rUsing EQV as a logical operator\n\r\n\rEQV returns TRUE (non-zero) if at least one bit in one operand contains the same value as the identical bit position in the other operand. Further, EQV will return zero if and only if there are no matching bit values between the two operands. This can occur when one operand is equal to the bitwise NOT value of the other operand. For example:\n\r\n\rIF x EQV y = 0 THEN statement\n\r\n\ris equivalent to:\n\r\n\rIF x = NOT y THEN statement\n\r\n\rThe EQV operator can be used for comparing signed and unsigned values of the same bit size, such as Long-integer and Double-word. This use of EQV is similar to using the BITS functions; however, care must be exercised to test the return value of EQV correctly, since EQV will return an unsigned value with all bits set only if the bit patterns of the two operands are an exact match.\n\r\n\rThe EQV truth table looks like this:\n\r\n\rTruth table\n\r\n\rx\n\r\n\ry\n\r\n\rx EQV y\n\r\n\rT\n\r\n\rT\n\r\n\rT\n\r\n\rT\n\r\n\rF\n\r\n\rF\n\r\n\rF\n\r\n\rT\n\r\n\rF\n\r\n\rF\n\r\n\rF\n\r\n\rT\n\r\n\r&nbsp;\n\r\n\rSee also\n\r\n\rArithmetic Operators, AND, IMP, ISFALSE, ISTRUE, LET, NOT, OR, XOR\n\r\n\rExample\n\r\n\rIF (Var1&amp; EQV Var2???) &nbsp;= BITS???(-1&amp;) THEN ...\n\r\n\rIF (Val1% EQV Var2??) &nbsp; = &amp;H0FFFF?? &nbsp; &nbsp;THEN ...\n\r\n\rIF -1&amp; EQV BITS???(-1&amp;) = &amp;H0FFFFFFFF &nbsp;THEN ...\n\r\n\rIF -1% EQV BITS??(-1%) &nbsp;= &amp;H0FFFF &nbsp; &nbsp; &nbsp;THEN ...","EQV operator","scr\\html_eqv_operator.htm","                  \n\r\n\rPurpose\n\r\n\rDeallocate array memory and release it from memory.\n\r\n\rSyntax\n\r\n\rERASE array[()] &nbsp;[, array[()]] ...\n\r\n\rRemarks\n\r\n\rAny memory assigned to the individual elements (if they are dynamic strings, Objects, Variants, etc.) is also released. ERASE deallocates all the memory for LOCAL, STATIC, and GLOBAL arrays. After an array is erased, attempting to access the array may produce a General Protection Fault (GPF). Local arrays are implicitly erased upon exit from the Sub/Function/Method/Property that created them.\n\r\n\rarray\n\r\n\rThe name of the array to deallocate. Parentheses are optional, but are recommended for clarity of the source code.\n\r\n\rOne method to check if an array has been dimensioned without triggering a GPF is to use the LBOUND and UBOUND functions, as follows:\n\r\n\rIF UBOUND(array) - LBOUND(array) = -1 THEN\n\r\n\r &nbsp;\' array() is not allocated\n\r\n\rEND IF\n\r\n\rERASE can deallocate an array that was passed as a parameter to a procedure, but only if the array was passed by reference (BYREF). To clear the contents of an array back to its initialized state, use REDIM or RESET.\n\r\n\rRestrictions\n\r\n\rAbsolute arrays (those created by DIM...AT) are handled differently by ERASE. An explicit ERASE will release the individual elements of an absolute array, if needed, but the full data block is left as-is because no assumptions can be made as to its origin. It is the programmer\'s responsibility to ensure that the memory block overlaid by the absolute array is handled correctly. In an implied ERASE (Sub/Function/Method/Property exit) of a LOCAL absolute array, the internal array descriptor is deactivated, but no changes of any kind are made to the individual data elements or the full block. RESET may be used to set arrays to zeroes or empty strings without releasing the data block.\n\r\n\rSee also\n\r\n\rARRAYATTR, DIM, REDIM, RESET\n\r\n\rExample\n\r\n\rERASE Array1$(), MyArray%()","ERASE statement","scr\\html_erase_statement.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the last label, line number, or procedure name executed prior to the most recent error.\n\r\n\rSyntax\n\r\n\rposition$ = ERL$\n\r\n\rRemarks\n\r\n\rReturn a string containing the name of the last (most recent) label, line number, or procedure that was executed prior to the most recent run-time error, within the current Sub, Function, Method, or Property. In order to maintain high efficiency levels, the returned name is limited to the first 8 characters of the actual name.\n\r\n\rSee also\n\r\n\rERL, ERR, ERRCLEAR, ERROR, ERROR$, Error &nbsp;Overview, Error Trapping, ON ERROR\n\r\n\rExample\n\r\n\rMyLabel:\n\r\n\rERRCLEAR\n\r\n\rNAME &quot;a nonexisting filename.txt&quot; AS &quot;abc.txt&quot;\n\r\n\rIF ERR THEN Position$ = ERL$","ERL$ function","scr\\html_erl$_function.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the last line number encountered before the most recent error.\n\r\n\rSyntax\n\r\n\rnline = ERL\n\r\n\rRemarks\n\r\n\rReturn the last (most recent) line number that was encountered before the most recent run-time error, within the current Sub, Function, Method, or Property. With ERL, line numbers are of the traditional-basic line numbering variety, not the physical source code line.\n\r\n\rSee also\n\r\n\rERL$, ERR, ERRCLEAR, ERROR, ERROR$, Error &nbsp;Overview, Error Trapping, ON ERROR\n\r\n\rExample\n\r\n\r10 ERRCLEAR\n\r\n\r20 NAME &quot;a nonexisting filename.txt&quot; AS &quot;abc.txt&quot;\n\r\n\r30 IF ERR THEN lErrLine = ERL &nbsp; &nbsp;\' lErrLine = 20","ERL system variable","scr\\html_erl_system_variable.htm","                  \n\r\n\rPurpose\n\r\n\rReturn the error code of the most recent PowerBASIC run-time error.\n\r\n\rSyntax\n\r\n\ry = ERR\n\r\n\rERR = ErrNum\n\r\n\ry = ERRCLEAR\n\r\n\rERRCLEAR\n\r\n\rRemarks\n\r\n\rERR and ERRCLEAR return the error code of the most recent run-time error in the current Sub, Function, Method, or Property. This number can be tested after any critical operation, so that appropriate error-handling code can be executed.\n\r\n\rYou can also assign a value to ERR. This is similar to executing an ERROR statement, except that no branch to an error trap routine is generated. Instead, subsequent tests of ERR and ERRCLEAR reflect ErrNum.\n\r\n\rERRCLEAR returns the error code of the most recent run-time error. In addition, it resets PowerBASIC\'s internal error code variable ERR to zero after you reference it. Finally, it emulates RESUME FLUSH so that no RESUME execution is needed or allowed. This ensures that the next time you test ERR or ERRCLEAR, you are guaranteed to get a zero, unless a new error has actually occurred in the interim.\n\r\n\rERRCLEAR can also be used as a statement to reset ERR to zero.\n\r\n\rIMPORTANT: Be sure to study the Errors and Error Trapping.\n\r\n\rRestrictions\n\r\n\rValid run-time error values are in the range 0 through 255. A value of 0 indicates no error. Attempting to set an error value (with the ERROR statement) outside of that range will convert the value to a run-time Error 5 (&quot;Illegal function call&quot;).\n\r\n\rSee also\n\r\n\rERROR, ERROR$, Error Overview, Error Trapping, ON ERROR\n\r\n\rExample\n\r\n\ry = ERR &nbsp; &nbsp; &nbsp; &nbsp;\' sets y = ERR\n\r\n\rERR = 6 &nbsp; &nbsp; &nbsp; &nbsp;\' sets ERR to 6\n\r\n\ry = ERRCLEAR &nbsp; \' sets y = ERR and ERR = 0\n\r\n\rERRCLEAR &nbsp; &nbsp; &nbsp; \' sets ERR = 0","ERRCLEAR system variable","scr\\html_err_and_errclear_system_variables.htm","                  \n\r\n\rNo error (%ERR_NOERROR)","Error 0 - No error","scr\\html_error_0___no_error.htm","                  \n\r\n\rDivision by zero (%ERR_DIVISIONBYZERO) &nbsp;- This error is not currently supported.","Error 11 - Division by zero","scr\\html_error_11___division_by_zero.htm","                  \n\r\n\rDevice time-out - (%ERR_DEVICETIMEOUT) - The specified time-out value for a UDP or TCP communications operation has expired.","Error 24 - Device time-out","scr\\html_error_24___device_time_out_.htm","                  \n\r\n\rGlobal memory corrupt - (%ERR_GLOBALMEMORYCORRUPT) - PowerBASIC detected a global memory corruption.\n\r\n\rTypical causes include misuse of pointers, accessing an array beyond its boundary, or bad Inline Assembly code. The cause of the problem may actually be in a seemingly unrelated portion of the program, and/or in a DLL or module used by the program.\n\r\n\rError 241 was formerly deemed &quot;Far heap corrupt&quot; (%ERR_FARHEAPCORRUPT). While this equate remains supported for a short period, source code should be updated to maintain compatibility with future versions of PowerBASIC.","Error 241 - Global memory corrupt","scr\\html_error_241___global_memory_corrupt.htm","                  \n\r\n\rString space corrupt - (%ERR_STRINGSPACECORRUPT) - PowerBASIC detected a memory or string space corruption. Typical causes include misuse of , accessing an array beyond its boundary, or bad Inline Assembly code. The cause of the problem may actually be located in a seemingly unrelated portion of the program, and/or in a DLL or module used by the program. ","Error 242 - String space corrupt","scr\\html_error_242___string_space_corrupt.htm","                  \n\r\n\rExpression too long/complex - The expression contained too many operators; break it down into two or more simplified expressions.","Error 401 Expression too long/complex","scr\\html_error_401_expression_too_long_complex.htm","                  \n\r\n\rStatement too long/complex - The statement complexity caused an overflow of the internal compiler buffers; break the statement down into two or more simplified statements. This error can also occur if a SELECT CASE structure using the AS CONST optimization causes the internal jump table to exceed the maximum size (approximately 3200 entries or 12 Kb).","Error 402 - Statement too long/complex","scr\\html_error_402___statement_too_long_complex.htm","                  \n\r\n\r#IF nesting overflow - Conditional compilation blocks (#IF/#ELSE/#ENDIF) can only be nested up to 16 levels deep.","Error 403 - #IF nesting overflow","scr\\html_error_403____if_nesting_overflow.htm","                  \n\r\n\r#INCLUDE file/Macro nesting overflow - Include files and macros may be nested up to twelve levels deep. The most common cause of this error stems from excessive nesting and/or circular references. For example, a nested #INCLUDE file that includes itself or an ancestor file that in turn includes the file again, etc. Likewise, a macro that references itself either directly or indirectly can cause a circular reference. See the MACRO statement for more information on the limits of macro expansions.","Error 404 - #INCLUDE file/Macro nesting overflow","scr\\html_error_404____include_file_macro_nesting_overflow.htm","                  \n\r\n\rBlock nesting overflow - Your program has too many statement block structures nested within each other. In PowerBASIC block structures may be nested 64 levels deep.","Error 405 - Block nesting overflow","scr\\html_error_405___block_nesting_overflow.htm","                  \n\r\n\rCompiler out of memory - Available compiler memory for symbol space, buffers, and so on, has been exhausted.\n\r\n\rIf no more memory is available, separate your program into a small main program which uses the #INCLUDE metastatement to include the rest of your program. You can also try the following steps:&#183;Remove unnecessary line numbers and labels.&#183;Shorten your variable and procedure names.&#183;If your code includes WIN32API.INC: Try adding the &quot;code exclusion&quot; equates such as %NOGDI = 1 to your code to cause the compiler to ignore large sections of the API file. Please review the first few pages of notes in WIN32API.INC for more information.\n\r\n\rAlternatively, create a customized version of WIN32API.INC that contains just the definitions and declarations actually used by your code. The latter solution, whilst more work initially, will have the added benefit of much faster compilation times, and make your code more resistant to changes in subsequent releases of WIN32API.INC.","Error 406 - Compiler out of memory","scr\\html_error_406___compiler_out_of_memory.htm","                  \n\r\n\rSource line too long - The line of code is too long for the compiler to process. This can also occur if the file contains lines of source code that are not CR/LF delimited. Try breaking the line of code up into smaller logical lines with the use of line continuation characters, and ensure that the file is using the Win32 standard of CR/LF line delimiting. If you are using a 3rd-party editor, try opening the source code file in the PowerBASIC IDE and examine the lines where the error occurred -- merged lines here will be a good indication of invalid line delimiting.","Error 407 - Source line too long","scr\\html_error_407___source_line_too_long.htm","                  \n\r\n\rWrong compiler for this program - The compiler you are using is not compatible with the compiler version specified by the #COMPILER metastatement. Use the compiler specified by the #COMPILER metastatement. Another approach would be to change the #COMPILER settings to match your compiler but, this should be done with caution, since the program may no longer work the same way (or at all) with a different compiler.","Error 408 - Wrong compiler for this program","scr\\html_error_408___wrong_compiler_for_this_program.htm","                  \n\r\n\rSub/Function/Method/Property is too large - There is a reasonable limit for the physical size of a single Sub, Function,  Method, or Property. The limit is imposed for practical reasons (such as the size of internal compiler buffers), but also for logical suitability. A huge block of code is very difficult to maintain. In the current version of PowerBASIC, this absolute limit is set at approximately 12,000 lines of source code per procedure. PowerBASIC recommends that each procedure perform one logical function, with a general goal of no more than perhaps 100 lines of source code. If you encounter this error, just break up your code into two or more procedures.","Error 409 - Sub/Function is too large","scr\\html_error_409___sub_function_method_property_is_too_large.htm","                  \n\r\n\r&quot;,&quot; expected - The statement\'s syntax requires a comma (,).","Error 411 - \",\" expected","scr\\html_error_411______expected.htm","                  \n\r\n\r&quot;;&quot; expected - The statement\'s syntax requires a semicolon (;).","Error 412 - \";\" expected","scr\\html_error_412_______expected.htm","                  \n\r\n\r&quot;(&quot; expected - The statement\'s syntax requires a left parenthesis (().","Error 413 - \"(\" expected","scr\\html_error_413____(__expected.htm","                  \n\r\n\r&quot;)&quot; expected - The statement\'s syntax requires a right parenthesis ()). The compiler encountered text or symbols where a right parenthesis was expected, or a parenthesis is missing. This error can also occur when attempting to pass more than 32 parameters to a Sub, Function, Method, or Property.","Error 414 - \")\" expected","scr\\html_error_414____)__expected.htm","                  \n\r\n\r &quot;=&quot;expected - The statement\'s syntax requires an equal sign (=).","Error 415 - \"=\" expected","scr\\html_error_415______expected.htm","                  \n\r\n\r&quot;-&quot; expected - The statement\'s syntax requires a hyphen (-).","Error 416 - \"-\" expected","scr\\html_error_416_______expected.htm","                  \n\r\n\r&quot;*&quot; expected - The statement\'s syntax requires an asterisk (*).","Error 417 - \"*\" expected","scr\\html_error_417_______expected.htm","                  \n\r\n\rStatement expected - A PowerBASIC statement was expected. Some character could not be identified as a statement, metastatement, or variable.","Error 418 - Statement expected","scr\\html_error_418___statement_expected.htm","                  \n\r\n\rLabel/line number expected - A valid label or line-number reference was expected in an IF, GOTO, GOSUB, or ON statement. ","Error 419 - Label/line number expected","scr\\html_error_419___label_line_number_expected.htm","                  \n\r\n\rRelational operator expected - The compiler has found a string operand in a position where a numeric operand should be, or a type mismatch has been detected.\n\r\n\rFor example, the statement X&amp; = Y$ triggers an error because a string cannot be assigned or compared to numeric variable, hence the compiler expected to find an additional operator that would return a numeric result. For example, X&amp; = Y$ &gt; Z$.","Error 420 - Relational operator expected","scr\\html_error_420___relational_operator_expected.htm","                  \n\r\n\rString operand expected - The compiler expected a string expression and found something else; for example, X$ = A$ + 3.","Error 421 - String operand expected","scr\\html_error_421___string_operand_expected.htm","                  \n\r\n\rScalar variable expected - The compiler expected a scalar variable as a formal parameter to a user-defined function. Scalar variables are non-array variables.","Error 422 - Scalar variable expected","scr\\html_error_422___scalar_variable_expected.htm","                  \n\r\n\rArray variable expected - An array variable was expected in a DIM statement.","Error 423 - Array variable expected","scr\\html_error_423___array_variable_expected.htm","                  \n\r\n\rNumeric variable expected - A numeric variable was expected, such as in an INCR or DECR.","Error 424 - Numeric variable expected","scr\\html_error_424___numeric_variable_expected.htm","                  \n\r\n\rString variable expected - A string variable was expected, such as in a PUT$ or a GET$ statement.","Error 425 - String variable expected","scr\\html_error_425___string_variable_expected.htm","                  \n\r\n\rVariable expected - A variable was expected, but not found. A common cause for this error is the use of a reserved keyword as a variable.","Error 426 - Variable expected","scr\\html_error_426___variable_expected.htm","                  \n\r\n\rInteger constant expected - An integer constant, numeric literal, or numeric equate was expected, such as in a named constant assignment.\n\r\n\rThis error can occur when attempting to use a numeric variable to dictate the size of the target of a fixed-length or Nul-Terminated string pointer. For example:\n\r\n\rDIM X AS STRING PTR * Y&amp;\n\r\n\ris not permitted as this statement could only be evaluated at run-time. However:\n\r\n\rDIM X AS STRING PTR * 1024\n\r\n\ris acceptable as the target size is known at compile-time.\n\r\n\rAnother cause of this error is specifying a non-integral CASE argument in a SELECT CASE AS CONST block.","Error 427 - Integer constant expected","scr\\html_error_427___integer_constant_expected.htm","                  \n\r\n\rPositive integer constant expected - A positive integer constant was expected, but not found.","Error 428 - Positive integer constant expected","scr\\html_error_428___positive_integer_constant_expected.htm","                  \n\r\n\rString constant expected - A string constant was expected, but not found. For example, this error can occur when in a SELECT CASE AS CONST$ block when a non-string CASE argument is specified.","Error 429 - String constant expected","scr\\html_error_429___string_constant_expected.htm","                  \n\r\n\rInteger variable expected - An integer variable was expected, but not found","Error 430 - Integer variable expected","scr\\html_error_430___integer_variable_expected.htm","                  \n\r\n\rNumeric scalar variable expected - The counter variable in a FOR/NEXT counter variable is a BYREF parameter passed to the Sub/Function/Method/Property, a &nbsp;pointer target, a THREADED variable, an array variable (non-scalar), or the counter variable is not a numeric data type. Scalar variables are non-array variables. ","Error 431 - Numeric scalar variable expected","scr\\html_error_431___numeric_scalar_variable_expected.htm","                  \n\r\n\rLong-integer variable expected - A Long-integer variable is expected.","Error 432 - Long-integer variable expected","scr\\html_error_432___long_integer_variable_expected.htm","                  \n\r\n\rMatrix array expected (integer/float) - Matrix arrays may only be of integer or floating point types.\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rMAT Statement","Error 433 - Matrix array expected (integer/float)","scr\\html_error_433___matrix_array_expected_(integer_float).htm","                  \n\r\n\rEnd of line expected - No characters are allowed on a line (except for a comment) following a metastatement, END SUB, or a label.","Error 434 - End of line expected","scr\\html_error_434___end_of_line_expected.htm","                  \n\r\n\r#IF expected - An #ENDIF conditional compilation metastatement is missing its accompanying #IF. Look for all #ENDIF metastatements and figure out where to put the associated #IF.","Error 435 - #IF expected","scr\\html_error_435____if_expected.htm","                  \n\r\n\r#ENDIF expected - An #IF conditional compilation metastatement is missing its accompanying #ENDIF. Examine all #IF metastatements to determine where to put the associated #ENDIF.","Error 436 - #ENDIF expected","scr\\html_error_436____endif_expected.htm","                  \n\r\n\rAS expected - The AS reserved word is missing, such as in a variable declaration.","Error 437 - AS expected","scr\\html_error_437___as_expected.htm","                  \n\r\n\rMember name expected - The compiler encountered a statement or other text where a structure member name was expected.","Error 438 - Member name expected","scr\\html_error_438___member_name_expected.htm","                  \n\r\n\rGOSUB expected - An ON statement is missing its accompanying GOSUB part.","Error 439 - GOSUB expected","scr\\html_error_439___gosub_expected_.htm","                  \n\r\n\rGOTO expected - An ON statement is missing its accompanying GOTO part.","Error 440 - GOTO expected","scr\\html_error_440___goto_expected.htm","                  \n\r\n\rIN expected - The IN reserved word is missing in a REGEXPR, REGREPL, or REPLACE statement. Check the syntax of the relevant statement in the reference directory section.","Error 441 - IN expected","scr\\html_error_441___in_expected.htm","                  \n\r\n\rTHEN expected - An IF is missing its accompanying THEN part.","Error 442 - THEN expected","scr\\html_error_442___then_expected.htm","                  \n\r\n\rTO expected - Missing TO in a FOR statement. This can also be reported for a missing TO in the CALL FuncName TO syntax.","Error 443 - TO expected","scr\\html_error_443___to_expected.htm","                  \n\r\n\rWITH clause expected - A PREFIX clause is expected in this statement.","Error 444 - PREFIX clause expected","scr\\html_error_444___prefix_clause_expected.htm","                  \n\r\n\rOF expected - Indexed pointers with dual indexes require an &quot;OF Limit&quot; clause on both indexes. For example:\n\r\n\rx = @w[i&amp; OF m&amp;, j&amp; OF n&amp;]","Error 445 - OF expected","scr\\html_error_445___of_expected.htm","                  \n\r\n\rFUNCTION expected - The compiler found an END FUNCTION or EXIT FUNCTION statement without a FUNCTION defined. When defining a FUNCTION, it must begin with a FUNCTION statement.","Error 446 - FUNCTION expected","scr\\html_error_446___function_expected.htm","                  \n\r\n\rIF expected - The compiler found an END IF or an EXIT IF statement without a beginning IF statement defined.","Error 447 - IF expected","scr\\html_error_447___if_expected.htm","                  \n\r\n\rDO loop expected - The compiler found a LOOP or EXIT LOOP statement without a beginning DO statement defined.","Error 448 - DO loop expected","scr\\html_error_448___do_loop_expected.htm","                  \n\r\n\rSELECT expected - When defining a SELECT CASE statement, you either forgot to include the reserved word SELECT or the compiler ran into an END SELECT or EXIT SELECT without a beginning SELECT CASE statement. This error can also occur if you try to use the reserved word CASE as a variable name in your program.","Error 449 - SELECT expected","scr\\html_error_449___select_expected.htm","                  \n\r\n\rCASE expected - When defining a SELECT CASE statement, you forgot to include the reserved word CASE. This error can also occur if you try to use the reserved word SELECT as a variable name in your program.","Error 450 - CASE expected","scr\\html_error_450___case_expected.htm","                  \n\r\n\rFOR loop expected - &nbsp;A NEXT, EXIT FOR, or ITERATE FOR was encountered here without the associated FOR statement to begin the FOR/NEXT loop.","Error 451 - FOR loop expected","scr\\html_error_451___for_loop_expected.htm","                  \n\r\n\rSUB expected - An END SUB was encountered here without the associated SUB statement to begin the procedure.","Error 452 - SUB expected","scr\\html_error_452___sub_expected.htm","                  \n\r\n\rEquate (%xyz) expected - The %DEF() function requires a numeric or string equate name as the parameter. It returns true (non-zero) or false (zero) to advise whether this equate has been defined in the program.","Error 453 - Equate (%xyz) expected","scr\\html_error_453___equate_(_xyz)_expected.htm","                  \n\r\n\rEND FUNCTION expected - A FUNCTION block was not terminated with an associated END FUNCTION statement. It\'s likely you tried to start a new procedure block, without first terminating the current FUNCTION.","Error 454 - END FUNCTION expected","scr\\html_error_454___end_function_expected.htm","                  \n\r\n\rEND IF expected - An IF block was not terminated with a corresponding END IF statement.","Error 455 - END IF expected","scr\\html_error_455___end_if_expected.htm","                  \n\r\n\rLOOP/WEND expected - A DO or WHILE loop was not terminated with a corresponding LOOP or WEND statement.","Error 456 - LOOP/WEND expected","scr\\html_error_456___loop_wend_expected.htm","                  \n\r\n\rEND SELECT expected - A SELECT CASE statement was not properly terminated with an END SELECT statement.","Error 457 - END SELECT expected","scr\\html_error_457___end_select_expected.htm","                  \n\r\n\rEND SUB expected - A SUB block was not terminated with an associated END SUB statement. It\'s likely you tried to start a new procedure block, without first terminating the current SUB.","Error 458 - END SUB expected","scr\\html_error_458___end_sub_expected.htm","                  \n\r\n\rNEXT expected - A FOR loop was not properly terminated with a NEXT statement.","Error 459 - NEXT expected","scr\\html_error_459___next_expected.htm","                  \n\r\n\rUndefined equate - A named constant (numeric equate or string equate) was referenced in your program, but it has not yet been defined.","Error 460 - Undefined equate","scr\\html_error_460___undefined_equate.htm","                  \n\r\n\rINSTANCE arrays must be declared before any CLASS code.","Error 461 - INSTANCE arrays must be declared","scr\\html_error_461___instance_arrays_must_be_declared.htm","                  \n\r\n\rUndefined Procedure reference - You attempted to execute or reference a SUB or FUNCTION, but it has not been declared or defined anywhere in the program. Check for the possibility of spelling errors.","Error 462 - Undefined SUB/FUNCTION reference","scr\\html_error_462___undefined_procedure_reference.htm","                  \n\r\n\rUndefined label/line reference - You used a label or line number, but it does not exist. Check for the possibility of spelling errors. Note that labels and line numbers are local to the procedures where they are defined.","Error 463 - Undefined label/line reference","scr\\html_error_463___undefined_label_line_reference.htm","                  \n\r\n\rUndefined class reference - You used a CLASS name which does not exist. You must define a CLASS before it can be used. Check for the possibility of spelling errors.","Error 464 - Undefined class reference","scr\\html_error_464___undefined_class_reference.htm","                  \n\r\n\rMay be defined only once - A program element which should only appear once was duplicated in your program. For example, two #STACK metastatements could cause this error to be generated. A common source of this problem is multiple #INCLUDE files which define the same term.","Error 465 - May be defined only once","scr\\html_error_465___may_be_defined_only_once.htm","                  \n\r\n\rThis name is already in use - This name (identifier) is used for more than one purpose, causing a fatal conflict. For example, you might have used the name ABC as both a variable and a label. You must rename one or both uses of this particular name. PowerBASIC generates this error when it sees the second use of the name.","Error 466 - This name is already in use","scr\\html_error_466___this_name_is_already_in_use.htm","                  \n\r\n\rDuplicate line number - &nbsp;A line number was used more than once.","Error 467 - Duplicate line number","scr\\html_error_467___duplicate_line_number.htm","                  \n\r\n\rThis equate may not be redefined - A numeric or string equate is defined a second time with a different value. Equate definitions may appear more than once, but the value must remain constant.","Error 468 - This equate may not be redefined","scr\\html_error_468___this_equate_may_not_be_redefined.htm","                  \n\r\n\rQuad integer variable expected - A Quad integer variable is required as a parameter in this statement.","Error 469 - Quad integer variable expected","scr\\html_error_469___quad_integer_variable_expected.htm","                  \n\r\n\rInvalid line number - Line numbers must be in the range 1 through 65535.","Error 471 - Invalid line number","scr\\html_error_471___invalid_line_number.htm","                  \n\r\n\rInvalid label - A label in your code contains invalid characters, such as the period character or the label conflicts with another function, sub, variable, etc. name.","Error 472 - Invalid label","scr\\html_error_472___invalid_label.htm","                  \n\r\n\rInvalid numeric format - Your program declared a number with more than 18 digits or a floating point number with an E component without the exponent value. This error can also occur if the &quot;&amp;&quot; string concatenation operator is used without leading whitespace. For example: a$ = a$&amp;b$ should be written a$ = a$ &nbsp;&amp; &nbsp;b$ ","Error 473 - Invalid numeric format","scr\\html_error_473___invalid_numeric_format.htm","                  \n\r\n\rInvalid name - A function, sub, method, property, macro, or label has an invalid name. In the case of a Sub, Function, Method, or Property, the name must begin with a letter and can be followed by other letters, digits, and underscores, but may not include a type-specifier or period. In the case of a macro you may have a duplicate macro name defined.","Error 474 - Invalid name","scr\\html_error_474___invalid_name.htm","                  \n\r\n\rMetastatements not allowed here - A metastatement must be the first statement on a line.","Error 475 - Metastatements not allowed here","scr\\html_error_475___metastatements_not_allowed_here.htm","                  \n\r\n\rBlock/scanned statements not allowed here - Block statements (like WHILE/WEND, DO/LOOP, and SELECT CASE) are not allowed in single line IF statements. In addition, you may not have a Sub, Function, Method, or Property definition nested within the body of another definition. A missing END SUB, END FUNCTION, END METHOD, or END PROPERTY can also cause this error.","Error 476 - Block/scanned statements not allowed here","scr\\html_error_476___block_scanned_statements_not_allowed_here.htm","                  \n\r\n\rSyntax error - Something is incorrect on the line; however, the compiler could not determine a proper error message or decode the line further. A common cause is mixing two statement keywords together, using a reserved keyword for a variable name, or attempting to use an undefined interface member (in an OBJECT statement) when using ID Binding, etc.","Error 477 - Syntax error","scr\\html_error_477___syntax_error.htm","                  \n\r\n\rResource file error - The resource file referenced has not been found or is not identifiable as a valid resource file. A common cause of this problem is attempting to use #RESOURCE with a non-PBR file, or if the PBR file was not able to be opened by the compiler (for example, because the file is locked by another process or application).","Error 478 - Resource file error","scr\\html_error_478___resource_file_error.htm","                  \n\r\n\rArray bounds error - You dimensioned an array within a User-Defined Type that contains invalid array boundaries. For example:\n\r\n\rTYPE MyType\n\r\n\r &nbsp;ArrayWithinUDT(5 TO 1)\n\r\n\rEND TYPE","Error 479 - Array bounds error","scr\\html_error_479___array_bounds_error.htm","                  \n\r\n\rParameter mismatches definition - You attempted to reference a procedure using a parameter which does not match (or cannot be converted to) the data type found in the original declaration/definition. This might also be caused by passing too few or too many parameters, misspellings, etc.","Error 480 - Parameter mismatches definition","scr\\html_error_480___parameter_mismatches_definition.htm","                  \n\r\n\rMismatch with prior definition - This program element (TYPE, UNION, SUB, FUNCTION, etc.) does not match a declaration or definition found previously in the program. It could be a SUB or FUNCTION which mismatches a declaration, a duplicate TYPE or INTERFACE which is not identical, or another similar condition.","Error 481 - Mismatch with prior definition","scr\\html_error_481___mismatch_with_prior_definition.htm","                  \n\r\n\rData type mismatch - Many PowerBASIC statements and functions require parameters which evaluate to a variable or expression of a particular data type. This error is generated if there is a mismatch with the expected data type. Consult the documentation for the specific statement or function to determine the exact parameter requirements.","Error 482 - Data type mismatch","scr\\html_error_482___data_type_mismatch.htm","                  \n\r\n\rRequires Object Procedure (Method/Property) - The statement or function found here is only allowed within a METHOD or PROPERTY. Elsewhere, it has no valid meaning and must be removed.","Error 483 - Requires Object Procedure (Method/Property)","scr\\html_error_483___requires_object_procedure_(method_property).htm","                  \n\r\n\rRequires procedure (Sub/Function/Method/Property) - The statement or function found here is only allowed within a procedure (SUB, FUNCTION, METHOD or PROPERTY). Elsewhere, it has no valid meaning and must be removed.","Error 484 - Requires procedure (Sub/Function)","scr\\html_error_484___requires_procedure_(sub_function_method_property).htm","                  \n\r\n\rDynamic/Field strings not allowed - A TYPE or UNION may not include a dynamic string or a field string as a member, because the total size of the structure must be known at compile-time. Fixed-length strings and Nul-Terminated Strings should be used instead.","Error 485 - Dynamic/Field strings not allowed","scr\\html_error_485___dynamic_field_strings_not_allowed.htm","                  \n\r\n\rBYVAL option not allowed - Use of the BYVAL option in this context is not allowed. This error is most frequently generated by an attempt to pass an array as a BYVAL parameter. Generally speaking, you should change this to BYREF instead. ","Error 486 - BYVAL option not allowed","scr\\html_error_486___byval_option_not_allowed.htm","                  \n\r\n\r Multiple NEXT not allowed - Prior versions of PowerBASIC allowed multiple NEXT statements implied by, or separated by commas. This is no longer supported.","Error 487 - Multiple NEXT not allowed","scr\\html_error_487___multiple_next_not_allowed.htm","                  \n\r\n\rNumeric processor overflow - Execution of this line of source code is complex, and requires more floating point registers than are currently available in the FPU. One solution might be to add the metastatement #REGISTER NONE to the current procedure, if register variables are being allocated. Another solution would be to break up the source code into multiple simpler statements. ","Error 488 - Numeric processor overflow","scr\\html_error_488___numeric_processor_overflow.htm","                  \n\r\n\rInvalid string length - You attempted to DIM a fixed-length string with a length of zero, or you attempted to create a string equate whose length exceeds 255 characters. Fixed-length strings must be at least 1 byte long, and individual string equates may not exceed 255 bytes in length","Error 489 - Invalid string length","scr\\html_error_489___invalid_string_length.htm","                  \n\r\n\rStatic array too large - You attempted to dimension a static array larger than 16 MB in a User-Defined Type.","Error 490 - Static array too large","scr\\html_error_490___static_array_too_large.htm","                  \n\r\n\rInvalid register variable - You specified a register variable which is not allowed in this context. Register variables must be LOCAL, and must be one of: Integer, Long, Word, DWord, or Extended float. It\'s also possible this variable was used with a function such as VARPTR(), which requires a memory variable for correct execution.","Error 491 - Invalid register variable","scr\\html_error_491___invalid_register_variable.htm","                  \n\r\n\rInvalid SORT function - ARRAY SORT of a custom array requires a custom user FUNCTION with a specific signature (2 BYREF parameters, STDCALL calling conventions, etc.). The function you supplied did not meet these requirements. ","Error 492 - Invalid SORT function","scr\\html_error_492___invalid_sort_function.htm","                  \n\r\n\rCompiler file not found/accessible - A source file could not be found in the specified directory path, or the current directory, or in the search path specified in the compiler /I command-line option. Alternatively, the file may be locked by another process. Check the directory paths or make sure that the specified file exists, and that another process or application has not locked the file.","Error 493 - Compiler file not found/accessible","scr\\html_error_493___compiler_file_not_found_accessible.htm","                  \n\r\n\rASM not allowed here - You tried to use multiple statements on a line containing an ASM statement. An ASM statement must be the only statement on a line (plus an optional comment or REM statement).","Error 494 - ASM not allowed here","scr\\html_error_494___asm_not_allowed_here.htm","                  \n\r\n\rCompiler file read error - During the compilation process, the compiler tried to open an #INCLUDE or #RESOURCE file, but a disk error was encountered. Verify that the file is present, not locked by another process, and that the disk itself is free from errors.","Error 495 - Compiler file read error","scr\\html_error_495___compiler_file_read_error.htm","                  \n\r\n\rDestination file write error - During compilation the compiler received a disk write error. This can occur if the destination EXE is, for example, still running in memory when you attempt to compile, the target file is write locked by another process or compile session, or the target file is write-protected (read-only).","Error 496 - Destination file write error","scr\\html_error_496___destination_file_write_error.htm","                  \n\r\n\rAssembler syntax error - An ASM statement contains an invalid assembly-language construction.","Error 497 - Assembler syntax error","scr\\html_error_497___assembler_syntax_error.htm","                  \n\r\n\rAssembler variables must be declared - An attempt was made to reference an assembler variable before it was defined.","Error 498 - Assembler variables must be declared","scr\\html_error_498___assembler_variables_must_be_declared.htm","                  \n\r\n\rStatement must be first on line - Certain PowerBASIC statements, and all metastatements, must be the first statement on a line. This includes block structures like PREFIX and MACRO, as well as constructs like SELECT CASE elements. If this error is generated, split compound statements apart so that each statement is on a separate line.","Error 499 - Statement must be first on line","scr\\html_error_499___statement_must_be_first_on_line.htm","                  \n\r\n\rIllegal function call - (%ERR_ILLEGALFUNCTIONCALL) - This is a catch-all error related to passing an inappropriate argument to some statement or function.\n\r\n\rThere are many things that can cause an Error 5, for example:&#183;A record number is too large (or negative) in a GET or PUT.&#183;Attempting to use the WIDTH# statement on a non-sequential file.&#183; The run-time execution of a LET, LET (with Objects), LET (with Types), LET (with Variants), or OBJECT statement failed (see OBJRESULT and OBJRESULT$ to obtain an extended error code).","Error 5 - Illegal function call","scr\\html_error_5___illegal_function_call.htm","                  \n\r\n\rVariable name must be unique - &nbsp; All Global, Threaded, and Instance variable names must be unique to guarantee access to a specific variable. If #UNIQUE VAR ON is specified, then all variable names must be unique.","Error 500 - Variable name must be unique","scr\\html_error_500___variable_name_must_be_unique.htm","","","scr\\html_error_501___parameters too_large_(exceed_64_kb).htm","                  \n\r\n\rCOM interface name expected - This form of the LET (assignment) statement is used to create a COM object, one which is created externally using the COM services provided by Windows. The associated interface name is not valid.","Error 502 - COM interface name expected","scr\\html_error_502___com_interface_name_expected.htm","                  \n\r\n\rInvalid MAIN Function(s) - Main/LibMain Function(s) do not match the target file type.","Error 503 - Invalid MAIN Function(s)","scr\\html_error_503___invalid_main_functions.htm","                  \n\r\n\rExecutable requires PBMAIN/WINMAIN function - No WINMAIN or PBMAIN function was located in an executable program. Without one of these functions, it is not possible for Windows to execute the program.","Error 504 - Executable requires PBMAIN/WINMAIN function","scr\\html_error_504___executable_requires_pbmain_winmain_function.htm","                  \n\r\n\rDebugging requires EXE file, not DLL - An attempt was made to launch the debugger on a DLL rather than an EXE file &nbsp;(PB/Win only). Be sure to use an explicit #COMPILE EXE metastatement to ensure the compiler generates the correct type of compiled code.","Error 505 - Debugging requires EXE file, not DLL","scr\\html_error_505___debugging_requires_exe_file_not_dll.htm","                  \n\r\n\rDeclaration must precede statements - You attempted to use a declaration, such as a #DIM ALL metastatement after executable code. Move the declaration to a position before any statements that generate executable code.","Error 506 - Declaration must precede statements","scr\\html_error_506___declaration_must_precede_statements.htm","                  \n\r\n\rOLE variable expected - The OBJECT statement requires that all parameters, return values, and assignment values be in the form of COM-compatible variables. Literals and expressions are not allowed. COM-compatible variables include BYTE, WORD, DWORD, INTEGER, LONG, QUAD, SINGLE, DOUBLE, CURRENCY, STRING, WSTRING, and VARIANT.","Error 507 - OLE variable expected","scr\\html_error_507___ole_variable_expected.htm","                  \n\r\n\rINSTANCE not allowed here - INSTANCE statements may only be placed at the beginning of a CLASS/END CLASS block, preceding all INTERFACE blocks and METHODS.","Error 508 - INSTANCE not allowed here","scr\\html_error_508___instance_not_allowed_here.htm","                  \n\r\n\rInterface mismatches class - This form of the LET (assignment) statement is used to create an internal object, but the associated class and interface are not defined in the program.","Error 509 - Interface mismatches class","scr\\html_error_509___interface_mismatches_class.htm","                  \n\r\n\rInternal error - (%ERR_INTERNALERROR) - A malfunction occurred within the PowerBASIC run-time system, or the operating system reported an error that PowerBASIC was not expecting (or was unable to decipher). For example, attempting to KILL (delete) an open file can cause this kind of problem.\n\r\n\rIf you are unable to identify the cause of the problem, contact the PowerBASIC Technical Support group with information about your program.","Error 51 - Internal error","scr\\html_error_51___internal_error.htm","                  \n\r\n\rInterface name expected - The compiler encountered a statement or other text where an INTERFACE name was expected.","Error 510 - Interface name expected","scr\\html_error_510___interface_name_expected.htm","                  \n\r\n\rNumeric operand expected - The compiler encountered a statement or other text where a numeric operand was expected.","Error 511 - Numeric operand expected","scr\\html_error_511___numeric_operand_expected.htm","                  \n\r\n\rBrackets not supported (use OPTIONAL) - Brackets are no longer supported for optional parameters.","Error 512 - Brackets not supported (use OPTIONAL)","scr\\html_error_512___brackets_not_supported_(use_optional).htm","                  \n\r\n\r&quot;]&quot; expected - The statement\'s syntax requires a closing bracket ( ] ).","Error 513 - \"]\" expected","scr\\html_error_513_______expected.htm","                  \n\r\n\rEnclosing &lt;...&gt; angle brackets expected - An INTERFACE definition block member item requires a parameter enclosed with angle brackets to identify the member ID.","Error 514 - Enclosing <...> angle brackets expected","scr\\html_error_514___enclosing_______angle_brackets_expected.htm","                  \n\r\n\rFixup overflow - You have a jump short instruction that exceeds its maximum length.","Error 515 - Fixup overflow","scr\\html_error_515___fixup_overflow_.htm","                  \n\r\n\rDEFtype, Type ID or type-specifier (?%&amp;!#$), or AS ... required - A variable with no type declaration was found and no DEFtype statement (such as DEFINT) was found. The compiler was unable to identify the type of variable indicated. The misspelling of variable names commonly causes this error. The DEFtype statement may not be supported in future editions of PowerBASIC. Use explicit declarations wherever possible to maintain future compatibility.","Error 516 - DEFtype, Type ID or type-specifier required","scr\\html_error_516___deftype_type_id_or_type_specifier_required.htm","                  \n\r\n\rOPTIONAL requires CDECL or SDECL - The OPTIONAL (or OPT) clause in a DECLARE, SUB, FUNCTION, METHOD, or PROPERTY statement requires the SDECL or CDECL calling convention. You may not use OPTIONAL or OPT parameters with BDECL calling convention.   ","Error 517 - OPTIONAL requires CDECL or SDECL","scr\\html_error_517___optional_requires_cdecl_or_sdecl.htm","                  \n\r\n\rMissing declaration - You specified that all variables must be declared before use, but this one was not declared. Use DIM, GLOBAL, INSTANCE, LOCAL, STATIC, or THREADED to declare the data type and dimensions, if an array. To declare Register Variables use the REGISTER statement.","Error 519 - Missing declaration","scr\\html_error_519___missing_declaration.htm","                  \n\r\n\rBad file name or number - (%ERR_BADFILENAMEORNUMBER) - The file number you gave in a file statement does not match the file number given in an OPEN statement, or the file number may be out of the range of valid file numbers.","Error 52 - Bad file name or number","scr\\html_error_52___bad_file_name_or_number.htm","                  \n\r\n\rTYPE expected - An END TYPE was encountered here without the associated TYPE statement to initiate the data block.","Error 520 - TYPE expected","scr\\html_error_520___type_expected.htm","                  \n\r\n\rUNION expected - An END UNION was encountered here without the associated UNION statement to initiate the data block.","Error 521 - UNION expected","scr\\html_error_521___union_expected_.htm","                  \n\r\n\rEND TYPE expected - The compiler found a TYPE statement without a terminating END TYPE statement.","Error 522 - END TYPE expected","scr\\html_error_522___end_type_expected.htm","                  \n\r\n\rEND UNION expected - The compiler found a UNION statement without a terminating END UNION statement.","Error 523 - END UNION expected","scr\\html_error_523___end_union_expected.htm","                  \n\r\n\rUndefined type - You referenced a TYPE or UNION which was not defined. Check for the possibility of spelling errors.","Error 524 - Undefined type","scr\\html_error_524___undefined_type_.htm","                  \n\r\n\rType ID or specifier (?%&amp;!#$) not allowed - Members in a User-Defined Type (UDT) or UNION variable must not include type ID or type-specifier characters. Change the definition to use the AS type syntax instead.","Error 525 - Type ID or specifier (?%&!#$) not allowed","scr\\html_error_525___type_id_or_specifier_(___$)_not_allowed.htm","                  \n\r\n\rPeriod not allowed - Periods are not allowed within any identifier names. They may only be used as a separator for member names. A good alternative is to use an underscore (_) character to decorate variable names.","Error 526 - Period not allowed","scr\\html_error_526___period_not_allowed.htm","                  \n\r\n\rEnd of statement expected - There were one or more extra characters at the end of this statement.","Error 527 - End of statement expected","scr\\html_error_527___end_of_statement_expected.htm","                  \n\r\n\rType too large - This TYPE or UNION exceeded the 16 Megabyte structure size limit.","Error 528 - Type too large","scr\\html_error_528___type_too_large_.htm","                  \n\r\n\rPointer variable error - You used pointer variable syntax incorrectly, such as placing a leading &quot;@&quot; on a variable which is not declared as a pointer.","Error 529 - Pointer variable error","scr\\html_error_529___pointer_variable_error.htm","                  \n\r\n\rFile not found - (%ERR_FILENOTFOUND) - The file name specified could not be found on the indicated drive.","Error 53 - File not found","scr\\html_error_53___file_not_found.htm","                  \n\r\n\rInvalid member name/definition - This usage of a member name or definition is not allowed in a TYPE, UNION, or INTERFACE. The name could be invalid, or the data type could be disallowed. See the specific statement definition for more information.","Error 530 - Invalid member name/definition","scr\\html_error_530___invalid_member_name_definition.htm","                  \n\r\n\rObject variable expected - The syntax of this statement or function requires an object variable here. Substitution with another data type is not possible. See the specific statement definition for more information.","Error 531 - Object variable expected","scr\\html_error_531___object_variable_expected.htm","                  \n\r\n\rVariant variable expected - The syntax of this statement or function requires a VARIANT variable here. Substitution with another data type is not possible. See the specific statement definition for more information.","Error 532 - Variant variable expected","scr\\html_error_532___variant_variable_expected.htm","                  \n\r\n\rIDispatch object variable expected - The OBJECT statement requires an object variable which has either been declared as IDISPATCH (for late binding), or by a specific dispatch interface (for ID binding).","Error 533 - Dispatch object variable expected","scr\\html_error_533___dispatch_object_variable_expected.htm","                  \n\r\n\rBit field error - An error was made in defining a bit field of BIT/SBIT variables. For example, it could be that the first variable in the bit field did not define the total size (using IN BYTE|WORD|DWORD), or the total number of bits may have exceeded the maximum of 32.","Error 534 - Bit field error","scr\\html_error_534___bit_field_error.htm","                  \n\r\n\rDynamic string variable expected - The syntax of this statement or function requires a dynamic string variable here. Substitution with another data type is not possible. See the specific statement definition for more information.","Error 535 - Dynamic string variable expected","scr\\html_error_535___dynamic_string_variable_expected.htm","                  \n\r\n\rToo many imports - The program has exceeded the maximum number of allowed imports.","Error 536 - Too many imports","scr\\html_error_536___too_many_imports.htm","                  \n\r\n\rPointer expected - This operation expects a pointer. For example:\n\r\n\r... @PtrName[n]","Error 537 - Pointer expected","scr\\html_error_537___pointer_expected.htm","                  \n\r\n\rInvalid FOR/NEXT limits - The specified start, stop and/or increment value(s) for a FOR/NEXT loop are not within the allowable range for the class of counter variable used. For example, you attempted to specify an increment value of -1 (a signed value) when the loop counter uses an unsigned variable. This error is also generated if the compiler is able to determine, at compile time, that the start and stop values chosen will prevent the FOR/NEXT from ever executing, e.g., FOR x = 10 TO 1.","Error 538 - Invalid FOR/NEXT limits","scr\\html_error_538___invalid_for_next_limits.htm","                  \n\r\n\rError 539 - Invalid thread function - A valid thread Function may only take one 32-bit LONG INTEGER or DWORD parameter passed BYVAL (by value). &nbsp;This error can occur if the Thread Function does not match the following syntax:\n\r\n\r&nbsp;\n\r\n\r &nbsp; &nbsp;FUNCTION ThreadFuncName (BYVAL param AS {LONG | DWORD}) AS {LONG | DWORD}\n\r\n\r&nbsp;\n\r\n\rFurther, the function must use SDECL (StdCall) conventions, it must not be labeled a CALLBACK function, and it must not be an IMPORT.\n\r\n\r&nbsp;\n\r\n\r&nbsp;\n\r\n\rSee Also\n\r\n\rTHREAD CREATE statement","Error 539 - Invalid thread function","scr\\html_error_539___invalid_thread_function.htm","                  \n\r\n\rBad file mode - (%ERR_BADFILEMODE) - You attempted a PUT or a GET (or PUT$ or GET$) on a file opened in sequential mode.","Error 54 - Bad file mode","scr\\html_error_54___bad_file_mode.htm","                  \n\r\n\rInvalid operation with a register variable - This assembler opcode or operands are invalid using a register variable.","Error 540 - Invalid operation with a register variable","scr\\html_error_540___invalid_operation_with_a_register_variable.htm","                  \n\r\n\rRegister size conflict - An inline assembler statement (ASM) used registers or a memory operand which conflicted in size. For example, an attempt might have been made to move a value such as:\n\r\n\rASM MOV &nbsp; AX, EBX\n\r\n\rASM SUB &nbsp; EBX, DL","Error 541 - Register size conflict","scr\\html_error_541___register_size_conflict.htm","                  \n\r\n\rMay not be altered - An attempt was made to change the value of a read-only parameter. For example, COMM SET cannot be used with RING, RLSD, RXQUE or TXQUE.","Error 542 - May not be altered","scr\\html_error_542___may_not_be_altered.htm","                  \n\r\n\rMust be outside Sub/Function/Class... - This statement/function is only allowed outside of any Sub, Function, Method, or Property block. It should be moved to the correct location.","Error 543 - Must be outside Sub/Function/Class...","scr\\html_error_543___must_be_outside_sub_function_method_property.htm","                  \n\r\n\rField variable expected - The syntax of this statement or function requires a field variable here. Substitution with another data type is not possible. See the specific statement definition for more information.","Error 544 - Field variable expected","scr\\html_error_544___field_variable_expected.htm","                   - The syntax of this statement or function requires the word AT here. See the specific statement definition for more information.","Error 545 - AT expected","scr\\html_error_545___at_expected.htm","                  \n\r\n\rUse only as a Callback - You tried to explicitly call a DDT Callback function. Callback functions may only be invoked by the DDT engine or Windows. To reference it indirectly, send an appropriate window message using CONTROL SEND or DIALOG SEND. To send custom messages, be sure to use message values higher than %WM_USER+500 to avoid conflicts with other notification messages.","Error 546 - Use only as a Callback","scr\\html_error_546___use_only_as_a_callback.htm","                  \n\r\n\rCallback function required - A Callback Function was named but the target function was not defined as a CALLBACK, or the nominated function was not a Callback Function. (PB/Win only)","Error 547 - Callback function required","scr\\html_error_547___callback_function_required.htm","                  \n\r\n\rNo parameters with Callback - A Callback Function definition cannot specify parameters. (PB/Win only)\n\r\n\rOmit the parameters from the function definition. For example:\n\r\n\rCALLBACK FUNCTION Dlg1Callback()\n\r\n\r[statements]\n\r\n\rEND FUNCTION","Error 548 - No parameters with Callback","scr\\html_error_548___no_parameters_with_callback.htm","                  \n\r\n\rBYVAL required with pointers - Pointers may only be passed BYVAL. Add an explicit BYVAL to the Sub/Function/Method/Property declaration and prototype. Previous versions of PowerBASIC used an implied BYVAL.","Error 549 - BYVAL required with pointers","scr\\html_error_549___byval_required_with_pointers.htm","                  \n\r\n\rFile is already open - (%ERR_FILEISOPEN) - You attempted to OPEN a file that was already open, or you attempted to delete an open file.","Error 55 - File is already open","scr\\html_error_55___file_is_already_open.htm","                  \n\r\n\rToo many data statements - Data is limited to 64 Kb per Sub, Function, Method, or Property, and 16384 individual data items. Either reduce the number of DATA statements, or split the data into separate procedures.","Error 550 - Too many data statements","scr\\html_error_550___too_many_data_statements.htm","                  \n\r\n\rNot supported in this version - An attempt was made to use a feature that is not supported by this version of the compiler. This error may also occur if a reserved word is used as a variable, label, Sub, Function, Method, or Property name. For example, using INP or OUT.","Error 551 - Not supported in this version","scr\\html_error_551___not_supported_in_this_version.htm","                  \n\r\n\rTRY statement expected - PowerBASIC expected to find a TRY statement at or before the indicated position in the code. Check the syntax of the surrounding code for other syntax errors, such as the misplacement of a CATCH or END TRY statement, conditional compilation excluding required portions of the code, etc.","Error 552 - TRY statement expected","scr\\html_error_552___try_statement_expected.htm","                  \n\r\n\rCATCH statement expected - A TRY/END TRY block did not include a CATCH statement. Recheck the syntax of the block.","Error 553 - CATCH statement expected","scr\\html_error_553___catch_statement_expected.htm","                  \n\r\n\rEND TRY statement expected - A TRY/END TRY block appears to be missing its END TRY clause. This can typically occur if an END SUB, END FUNCTION, END METHOD, END PROPERTY statement was encountered within the TRY/END TRY block.","Error 554 - END TRY statement expected","scr\\html_error_554___end_try_statement_expected.htm","                  \n\r\n\rON ERROR/RESUME not allowed here - An attempt was made to include an ON ERROR or a RESUME statement inside a TRY/END TRY block. Remove the ON ERROR or RESUME statement or move it out of the TRY/END TRY block. Error handling is automatic within a TRY/END TRY block.","Error 555 - ON ERROR/RESUME not allowed here","scr\\html_error_555___on_error_resume_not_allowed_here.htm","                  \n\r\n\rFunction restricted to threads - Functions that are called with THREAD CREATE may not be called in the conventional manner. This restriction is necessary because thread Functions require additional initialization steps that are not included in standard function code.\n\r\n\rOne situation that can arise is where a Function may need to be invoked both directly and used as a thread Function. The easiest solution is to create a small wrapper function for the function, then use THREAD CREATE with the wrapper function, or call the original function directly. For example:\n\r\n\rFUNCTION WorkerFunc(BYVAL x AS LONG) AS LONG\n\r\n\r &nbsp;\' code here\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\rFUNCTION WorkerThread(BYVAL x AS LONG) AS LONG\n\r\n\r &nbsp;FUNCTION = WorkerFunc(x)\n\r\n\rEND FUNCTION\n\r\n\r&nbsp;\n\r\n\r\' more code here\n\r\n\r&nbsp;\n\r\n\r\' Execute the worker function directly, thus:\n\r\n\rlResult&amp; = WorkerFunc(var&amp;)\n\r\n\r&nbsp;\n\r\n\r\' Execute the worker thread as a thread, using\n\r\n\r\' the wrapper function:\n\r\n\rTHREAD CREATE WorkerThread(var&amp;) TO hThread???","Error 556 - Function restricted to threads","scr\\html_error_556___function_restricted_to_threads.htm","                  \n\r\n\rMacro too long/complex - An attempt was made to create a MACRO that is too long or complex. An individual macro can contain replacement text of up to approximately 4000 characters, and can specify up to 240 parameters occupy up to approximately 2000 bytes expanded space per macro. Macro substitutions are limited to an expanded total of approximately 16000 characters per line of original source code.","Error 557 - Macro too long/complex","scr\\html_error_557___macro_too_long_complex.htm","                  \n\r\n\rMACRO expected - An END MACRO statement was found without a matching MACRO statement. Please recheck the syntax of the macro block.","Error 558 - MACRO expected","scr\\html_error_558___macro_expected_.htm","                  \n\r\n\rEND MACRO expected - A MACRO block appears to be missing a terminating END MACRO statement. Please recheck the syntax of the macro block.","Error 559 - END MACRO expected","scr\\html_error_559___end_macro_expected.htm","                  \n\r\n\rFASTPROC expected - A FASTPROC statement must precede other related statements like EXIT FASTPROC and END FASTPROC.","Error 560 - FASTPROC expected","scr\\html_error_560___fastproc_expected.htm","                  \n\r\n\rEND FASTPROC expected - A FASTPROC statement must be matched with an associated END FASTPROC.","Error 561 - END FASTPROC expected","scr\\html_error_561___end_fastproc_expected.htm","                  \n\r\n\rINTERFACE expected - An END INTERFACE statement was found to be without a matching INTERFACE statement. Please recheck the syntax of the interface definition block.","Error 562 - INTERFACE expected","scr\\html_error_562___interface_expected.htm","                  \n\r\n\rEND INTERFACE expected - An INTERFACE statement was found without a matching END INTERFACE statement. Please recheck the syntax of the interface definition block.","Error 563 - END INTERFACE expected","scr\\html_error_563___end_interface_expected.htm","                  \n\r\n\rMACROTEMP not allowed here - PowerBASIC encountered a MACROTEMP statement outside the scope of a MACRO block.","Error 564 - MACROTEMP not allowed here","scr\\html_error_564___macrotemp_not_allowed_here.htm","                  \n\r\n\rMacro mismatch with code position - The compiler encountered a multi-line MACRO statement in a non-statement position.","Error 565 - Macro mismatch with code position","scr\\html_error_565___macro_mismatch_with_code_position.htm","                  \n\r\n\rCLASS expected - An END CLASS statement was encountered here without the associated CLASS statement to initiate the block.","Error 566 - CLASS expected","scr\\html_error_566___class_expected_.htm","                  \n\r\n\rEND CLASS expected - A CLASS block was not terminated with an associated END CLASS statement.","Error 567 - END CLASS expected","scr\\html_error_567___end_class_expected.htm","                  \n\r\n\rMETHOD expected - An END METHOD statement was encountered here without the associated METHOD statement to initiate the block.","Error 568 - METHOD expected","scr\\html_error_568___method_expected.htm","                  \n\r\n\rEND METHOD expected - A METHOD block was not terminated with an associated END METHOD statement. It\'s likely you tried to start a new procedure block, without first terminating the current METHOD.","Error 569 - END METHOD expected","scr\\html_error_569___end_method_expected.htm","                  \n\r\n\rDevice I/O error - (%ERR_DEVICEIOERROR) - A hardware problem occurred when trying to carry out some device-orientated command.\n\r\n\rFor example, a COMM connection was lost during a session, or a TCP/UDP statement failed to be connected, etc. Alternatively, a TCP/UDP port may have been closed unexpectedly or the network refused the connection requested.\n\r\n\rIf an ERROR 57 occurs with a TCP OPEN statement under Windows 98 when using a dotted IP address string (i.e., &quot;202.123.456.1&quot;), then check to ensure that &quot;Client for Microsoft Networks&quot; is installed in the Network applet in Control Panel. Alternatively, manually add a DNS entry in the HOSTS file in the \\WINDOWS folder.\n\r\n\rFor example, add the following line into the HOSTS file, and change the TCP OPEN statement to use the (dummy) domain name instead of the dotted IP address:\n\r\n\r202.123.456.1 &nbsp;dummyname.com","Error 57 - Device I/O error","scr\\html_error_57___device_i_o_error.htm","                  \n\r\n\rProperty expected - An END PROPERTY statement was encountered here without the associated PROPERTY statement to initiate the block.","Error 570 - PROPERTY expected","scr\\html_error_570___property_expected.htm","                  \n\r\n\rEND METHOD expected - A PROPERTY block was not terminated with an associated END PROPERTY statement. It\'s likely you tried to start a new procedure block, without first terminating the current PROPERTY.","Error 571 - END PROPERTY expected","scr\\html_error_571___end_property_expected.htm","                  \n\r\n\rPROPERTY GET expected - A PROPERTY = nnnn statement (for assigning the return value) was found, but it was not located within a PROPERTY GET block. It is not allowed at any other location in your program.","Error 572 - PROPERTY GET expected","scr\\html_error_572___property_get_expected.htm","                  \n\r\n\rError 573 - Valid only in a CALLBACK FUNCTION - FUNCTION = x,y with two parameters is only valid in a CALLBACK FUNCTION.","Error 573 - Valid only in a CALLBACK FUNCTION","scr\\html_error_573___valid_only_in_a_callback_function.htm","                  \n\r\n\rNot allowed in an Event Class - The statement or function found here is not allowed within an EVENT CLASS. It has no valid meaning and must be removed. See the specific statement definition for more information.","Error 574 - Not allowed in an Event Class","scr\\html_error_574___not_allowed_in_an_event_class.htm","                  \n\r\n\rEVENT SOURCE is not declared - You included code which generates events with the RAISEEVENT statement, but did not declare an event source with the EVENT SOURCE statement.","Error 575 - EVENT SOURCE is not declared","scr\\html_error_575___event_source_is_not_declared.htm","                  \n\r\n\rToo many Interfaces - PowerBASIC allows up to 32 interfaces per CLASS, but you have exceeded that limit. You should try to combine two or more of those interfaces.","Error 576 - Too many Interfaces","scr\\html_error_576___too_many_interfaces.htm","                  \n\r\n\rEVENT INTERFACE expected - The EVENT INTERFACE you specified could not be found.","Error 577 - EVENT INTERFACE expected","scr\\html_error_577___event_interface_expected.htm","                  \n\r\n\rINHERIT of Base Class expected - Every INTERFACE must INHERIT from a base class, which may be nested any level. Ultimately, every interface inherits from IUnknown. The INHERIT statement must be the first statement in every INTERFACE block.","Error 578 - INHERIT of Base Class expected","scr\\html_error_578___inherit_of_base_class_expected.htm","                  \n\r\n\rBYREF variable or BYVAL/BYREF variant expected - The ISMISSING() function can only detect a missing parameter for a BYREF variable, or a BYVAL/BYREF variant.","Error 579 - BYREF variable or BYVAL/BYREF variant expected","scr\\html_error_579___byref_variable_or_byval_byref_variant_expected.htm","                  \n\r\n\rFile already exists - (%ERR_FILEALREADYEXISTS) - The new name argument specified in your NAME statement already exists.","Error 58 - File already exists","scr\\html_error_58___file_already_exists.htm","                  \n\r\n\rDuplicate GUID usage - You have used a single GUID to identify two or more elements of your program. Change at least one of the GUIDs to a new value.","Error 580 - Duplicate GUID usage","scr\\html_error_580___duplicate_guid_usage.htm","                  \n\r\n\rType Library creation error - A system error occurred while creating the COM Type Library. The common cause of this error is using a data type not supported by Type Libraries. Type Libraries only support the following data types: BYTE, WORD, DWORD, INTEGER, LONG, QUAD, SINGLE, DOUBLE, CURRENCY, OBJECT, STRING, and VARIANT. Either suppress the creation of a Type Library by using the #COM TLIB OFF metastatement or by changing the Methods and Properties to only use supported data types.","Error 581 - Type Library creation error","scr\\html_err